/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.validation.iterable;

import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Struct$;
import com.daml.lf.language.Ast;
import com.daml.lf.language.Ast$;
import com.daml.lf.validation.Util$;
import com.daml.lf.validation.Util$TupleImmArrayOps$;
import com.daml.lf.validation.iterable.ExprIterable$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.Tuple8;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LazyZip2;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorMap;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class TypeIterable$ {
    public static final TypeIterable$ MODULE$ = new TypeIterable$();

    private Ast.Type toType(Ast.TypeConApp tyCon) {
        return (Ast.Type)tyCon.args().iterator().foldLeft((Object)new Ast.TTyCon(tyCon.tycon()), (Function2)Ast.TApp$.MODULE$);
    }

    public Iterator<Ast.Type> iterator(Ast.Type typ) {
        Iterator iterator;
        Ast.Type type = typ;
        if (type instanceof Ast.TSynApp) {
            Ast.TSynApp tSynApp = (Ast.TSynApp)type;
            ImmArray args = tSynApp.args();
            iterator = args.iterator();
        } else {
            boolean bl = type instanceof Ast.TVar ? true : (type instanceof Ast.TTyCon ? true : (type instanceof Ast.TBuiltin ? true : type instanceof Ast.TNat));
            if (bl) {
                iterator = package$.MODULE$.Iterator().empty();
            } else if (type instanceof Ast.TApp) {
                Ast.TApp tApp = (Ast.TApp)type;
                Ast.Type tyfun = tApp.tyfun();
                Ast.Type arg = tApp.arg();
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{tyfun, arg}));
            } else if (type instanceof Ast.TForall) {
                Ast.TForall tForall = (Ast.TForall)type;
                Ast.Type body = tForall.body();
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{body}));
            } else if (type instanceof Ast.TStruct) {
                Ast.TStruct tStruct = (Ast.TStruct)type;
                ArraySeq fields = tStruct.fields();
                iterator = Struct$.MODULE$.values$extension(fields);
            } else {
                throw new MatchError((Object)type);
            }
        }
        return iterator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterator<Ast.Type> iterator(Ast.Expr expr0) {
        Ast.Expr expr = expr0;
        if (expr instanceof Ast.ERecCon) {
            Ast.ERecCon eRecCon = (Ast.ERecCon)expr;
            Ast.TypeConApp tycon = eRecCon.tycon();
            ImmArray fields = eRecCon.fields();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{this.toType(tycon)})).$plus$plus((Function0 & Serializable)() -> Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(fields)).flatMap((Function1 & Serializable)x$1 -> MODULE$.iterator((Ast.Expr)x$1)));
        }
        if (expr instanceof Ast.ERecProj) {
            Ast.ERecProj eRecProj = (Ast.ERecProj)expr;
            Ast.TypeConApp tycon = eRecProj.tycon();
            Ast.Expr record = eRecProj.record();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{this.toType(tycon)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(record));
        }
        if (expr instanceof Ast.ERecUpd) {
            Ast.ERecUpd eRecUpd = (Ast.ERecUpd)expr;
            Ast.TypeConApp tycon = eRecUpd.tycon();
            Ast.Expr record = eRecUpd.record();
            Ast.Expr update = eRecUpd.update();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{this.toType(tycon)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(record)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(update));
        }
        if (expr instanceof Ast.EVariantCon) {
            Ast.EVariantCon eVariantCon = (Ast.EVariantCon)expr;
            Ast.TypeConApp tycon = eVariantCon.tycon();
            Ast.Expr arg = eVariantCon.arg();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{this.toType(tycon)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(arg));
        }
        if (expr instanceof Ast.ETyApp) {
            Ast.ETyApp eTyApp = (Ast.ETyApp)expr;
            Ast.Expr expr2 = eTyApp.expr();
            Ast.Type typ = eTyApp.typ();
            return this.iterator(expr2).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})));
        }
        if (expr instanceof Ast.EAbs) {
            Ast.EAbs eAbs = (Ast.EAbs)expr;
            Tuple2 tuple2 = eAbs.binder();
            Ast.Expr body = eAbs.body();
            if (tuple2 != null) {
                Ast.Type boundVarType = (Ast.Type)tuple2._2();
                return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{boundVarType})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
            }
        }
        if (expr instanceof Ast.ELet) {
            Ast.ELet eLet = (Ast.ELet)expr;
            Ast.Binding binding = eLet.binding();
            Ast.Expr body = eLet.body();
            return this.iterator(binding).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        }
        if (expr instanceof Ast.EEnumCon) {
            Ast.EEnumCon eEnumCon = (Ast.EEnumCon)expr;
            Ref.Identifier tyConName = eEnumCon.tyConName();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(tyConName)}));
        }
        if (expr instanceof Ast.EToAny) {
            Ast.EToAny eToAny = (Ast.EToAny)expr;
            Ast.Type typ = eToAny.ty();
            Ast.Expr expr3 = eToAny.body();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(expr3));
        }
        if (expr instanceof Ast.EFromAny) {
            Ast.EFromAny eFromAny = (Ast.EFromAny)expr;
            Ast.Type typ = eFromAny.ty();
            Ast.Expr expr4 = eFromAny.body();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(expr4));
        }
        if (expr instanceof Ast.ETypeRep) {
            Ast.ETypeRep eTypeRep = (Ast.ETypeRep)expr;
            Ast.Type tyCon = eTypeRep.typ();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{tyCon}));
        }
        if (expr instanceof Ast.ENil) {
            Ast.ENil eNil = (Ast.ENil)expr;
            Ast.Type typ = eNil.typ();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ}));
        }
        if (expr instanceof Ast.ECons) {
            Ast.ECons eCons = (Ast.ECons)expr;
            Ast.Type typ = eCons.typ();
            ImmArray front = eCons.front();
            Ast.Expr tail = eCons.tail();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> front.iterator().flatMap((Function1 & Serializable)x$2 -> MODULE$.iterator((Ast.Expr)x$2))).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(tail));
        }
        if (expr instanceof Ast.ENone) {
            Ast.ENone eNone = (Ast.ENone)expr;
            Ast.Type typ = eNone.typ();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ}));
        }
        if (expr instanceof Ast.ESome) {
            Ast.ESome eSome = (Ast.ESome)expr;
            Ast.Type typ = eSome.typ();
            Ast.Expr body = eSome.body();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        }
        if (expr instanceof Ast.EUpdate) {
            Ast.EUpdate eUpdate = (Ast.EUpdate)expr;
            Ast.Update u = eUpdate.update();
            return this.iterator(u);
        }
        if (expr instanceof Ast.EScenario) {
            Ast.EScenario eScenario = (Ast.EScenario)expr;
            Ast.Scenario s = eScenario.scenario();
            return this.iterator(s);
        }
        if (expr instanceof Ast.EThrow) {
            Ast.EThrow eThrow = (Ast.EThrow)expr;
            Ast.Type returnType = eThrow.returnType();
            Ast.Type exceptionType = eThrow.exceptionType();
            Ast.Expr exception = eThrow.exception();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{returnType, exceptionType})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(exception));
        }
        if (expr instanceof Ast.EToAnyException) {
            Ast.EToAnyException eToAnyException = (Ast.EToAnyException)expr;
            Ast.Type typ = eToAnyException.typ();
            Ast.Expr value = eToAnyException.value();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(value));
        }
        if (expr instanceof Ast.EFromAnyException) {
            Ast.EFromAnyException eFromAnyException = (Ast.EFromAnyException)expr;
            Ast.Type typ = eFromAnyException.typ();
            Ast.Expr value = eFromAnyException.value();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(value));
        }
        if (expr instanceof Ast.EToInterface) {
            Ast.EToInterface eToInterface = (Ast.EToInterface)expr;
            Ref.Identifier iface = eToInterface.interfaceId();
            Ref.Identifier tpl = eToInterface.templateId();
            Ast.Expr value = eToInterface.value();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(iface), new Ast.TTyCon(tpl)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(value));
        }
        if (expr instanceof Ast.EFromInterface) {
            Ast.EFromInterface eFromInterface = (Ast.EFromInterface)expr;
            Ref.Identifier iface = eFromInterface.interfaceId();
            Ref.Identifier tpl = eFromInterface.templateId();
            Ast.Expr value = eFromInterface.value();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(iface), new Ast.TTyCon(tpl)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(value));
        }
        if (expr instanceof Ast.EUnsafeFromInterface) {
            Ast.EUnsafeFromInterface eUnsafeFromInterface = (Ast.EUnsafeFromInterface)expr;
            Ref.Identifier iface = eUnsafeFromInterface.interfaceId();
            Ref.Identifier tpl = eUnsafeFromInterface.templateId();
            Ast.Expr cid = eUnsafeFromInterface.contractIdExpr();
            Ast.Expr value = eUnsafeFromInterface.ifaceExpr();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(iface), new Ast.TTyCon(tpl)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(cid)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(value));
        }
        if (expr instanceof Ast.ECallInterface) {
            Ast.ECallInterface eCallInterface = (Ast.ECallInterface)expr;
            Ref.Identifier iface = eCallInterface.interfaceId();
            Ast.Expr value = eCallInterface.value();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(iface)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(value));
        }
        if (expr instanceof Ast.EToRequiredInterface) {
            Ast.EToRequiredInterface eToRequiredInterface = (Ast.EToRequiredInterface)expr;
            Ref.Identifier requiredIfaceId = eToRequiredInterface.requiredIfaceId();
            Ref.Identifier requiringIfaceId = eToRequiredInterface.requiringIfaceId();
            Ast.Expr body = eToRequiredInterface.body();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(requiredIfaceId), new Ast.TTyCon(requiringIfaceId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        }
        if (expr instanceof Ast.EFromRequiredInterface) {
            Ast.EFromRequiredInterface eFromRequiredInterface = (Ast.EFromRequiredInterface)expr;
            Ref.Identifier requiredIfaceId = eFromRequiredInterface.requiredIfaceId();
            Ref.Identifier requiringIfaceId = eFromRequiredInterface.requiringIfaceId();
            Ast.Expr body = eFromRequiredInterface.body();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(requiredIfaceId), new Ast.TTyCon(requiringIfaceId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        }
        if (expr instanceof Ast.EUnsafeFromRequiredInterface) {
            Ast.EUnsafeFromRequiredInterface eUnsafeFromRequiredInterface = (Ast.EUnsafeFromRequiredInterface)expr;
            Ref.Identifier requiredIfaceId = eUnsafeFromRequiredInterface.requiredIfaceId();
            Ref.Identifier requiringIfaceId = eUnsafeFromRequiredInterface.requiringIfaceId();
            Ast.Expr cid = eUnsafeFromRequiredInterface.contractIdExpr();
            Ast.Expr body = eUnsafeFromRequiredInterface.ifaceExpr();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(requiredIfaceId), new Ast.TTyCon(requiringIfaceId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(cid)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        }
        if (expr instanceof Ast.EInterfaceTemplateTypeRep) {
            Ast.EInterfaceTemplateTypeRep eInterfaceTemplateTypeRep = (Ast.EInterfaceTemplateTypeRep)expr;
            Ref.Identifier ifaceId = eInterfaceTemplateTypeRep.ifaceId();
            Ast.Expr body = eInterfaceTemplateTypeRep.body();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(ifaceId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        }
        if (expr instanceof Ast.ESignatoryInterface) {
            Ast.ESignatoryInterface eSignatoryInterface = (Ast.ESignatoryInterface)expr;
            Ref.Identifier ifaceId = eSignatoryInterface.ifaceId();
            Ast.Expr body = eSignatoryInterface.body();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(ifaceId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        }
        if (expr instanceof Ast.EObserverInterface) {
            Ast.EObserverInterface eObserverInterface = (Ast.EObserverInterface)expr;
            Ref.Identifier ifaceId = eObserverInterface.ifaceId();
            Ast.Expr body = eObserverInterface.body();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(ifaceId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        }
        if (expr instanceof Ast.EViewInterface) {
            Ast.EViewInterface eViewInterface = (Ast.EViewInterface)expr;
            Ref.Identifier ifaceId = eViewInterface.ifaceId();
            Ast.Expr expr5 = eViewInterface.expr();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(ifaceId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(expr5));
        }
        boolean bl = expr instanceof Ast.EVar ? true : (expr instanceof Ast.EVal ? true : (expr instanceof Ast.EBuiltin ? true : (expr instanceof Ast.EPrimCon ? true : (expr instanceof Ast.EPrimLit ? true : (expr instanceof Ast.EApp ? true : (expr instanceof Ast.ECase ? true : (expr instanceof Ast.ELocation ? true : (expr instanceof Ast.EStructCon ? true : (expr instanceof Ast.EStructProj ? true : (expr instanceof Ast.EStructUpd ? true : (expr instanceof Ast.ETyAbs ? true : expr instanceof Ast.EExperimental)))))))))));
        if (!bl) throw new MatchError((Object)expr);
        return ExprIterable$.MODULE$.iterator(expr0).flatMap((Function1 & Serializable)x$3 -> MODULE$.iterator((Ast.Expr)x$3));
    }

    public Iterator<Ast.Type> iterator(Ast.Update update) {
        Iterator iterator;
        Ast.Update update2 = update;
        if (update2 instanceof Ast.UpdatePure) {
            Ast.UpdatePure updatePure = (Ast.UpdatePure)update2;
            Ast.Type typ = updatePure.t();
            Ast.Expr expr = updatePure.expr();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(expr));
        } else if (update2 instanceof Ast.UpdateBlock) {
            Ast.UpdateBlock updateBlock = (Ast.UpdateBlock)update2;
            ImmArray bindings = updateBlock.bindings();
            Ast.Expr body = updateBlock.body();
            iterator = bindings.iterator().flatMap((Function1 & Serializable)x$4 -> MODULE$.iterator((Ast.Binding)x$4)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        } else if (update2 instanceof Ast.UpdateCreate) {
            Ast.UpdateCreate updateCreate = (Ast.UpdateCreate)update2;
            Ref.Identifier templateId = updateCreate.templateId();
            Ast.Expr arg = updateCreate.arg();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(templateId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(arg));
        } else if (update2 instanceof Ast.UpdateCreateInterface) {
            Ast.UpdateCreateInterface updateCreateInterface = (Ast.UpdateCreateInterface)update2;
            Ref.Identifier identifier = updateCreateInterface.interfaceId();
            Ast.Expr arg = updateCreateInterface.arg();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(identifier)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(arg));
        } else if (update2 instanceof Ast.UpdateFetchTemplate) {
            Ast.UpdateFetchTemplate updateFetchTemplate = (Ast.UpdateFetchTemplate)update2;
            Ref.Identifier templateId = updateFetchTemplate.templateId();
            Ast.Expr contractId = updateFetchTemplate.contractId();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(templateId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(contractId));
        } else if (update2 instanceof Ast.UpdateFetchInterface) {
            Ast.UpdateFetchInterface updateFetchInterface = (Ast.UpdateFetchInterface)update2;
            Ref.Identifier identifier = updateFetchInterface.interfaceId();
            Ast.Expr contractId = updateFetchInterface.contractId();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(identifier)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(contractId));
        } else if (update2 instanceof Ast.UpdateExercise) {
            Ast.UpdateExercise updateExercise = (Ast.UpdateExercise)update2;
            Ref.Identifier templateId = updateExercise.templateId();
            Ast.Expr cid = updateExercise.cidE();
            Ast.Expr arg = updateExercise.argE();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(templateId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(cid)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(arg));
        } else if (update2 instanceof Ast.UpdateExerciseInterface) {
            Ast.UpdateExerciseInterface updateExerciseInterface = (Ast.UpdateExerciseInterface)update2;
            Ref.Identifier identifier = updateExerciseInterface.interfaceId();
            Ast.Expr cid = updateExerciseInterface.cidE();
            Ast.Expr arg = updateExerciseInterface.argE();
            Option guard = updateExerciseInterface.guardE();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(identifier)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(cid)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(arg)).$plus$plus((Function0 & Serializable)() -> guard.iterator().flatMap((Function1 & Serializable)x$5 -> MODULE$.iterator((Ast.Expr)x$5)));
        } else if (update2 instanceof Ast.UpdateExerciseByKey) {
            Ast.UpdateExerciseByKey updateExerciseByKey = (Ast.UpdateExerciseByKey)update2;
            Ref.Identifier templateId = updateExerciseByKey.templateId();
            Ast.Expr key = updateExerciseByKey.keyE();
            Ast.Expr arg = updateExerciseByKey.argE();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(templateId)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(key)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(arg));
        } else if (update2 instanceof Ast.UpdateEmbedExpr) {
            Ast.UpdateEmbedExpr updateEmbedExpr = (Ast.UpdateEmbedExpr)update2;
            Ast.Type typ = updateEmbedExpr.typ();
            Ast.Expr body = updateEmbedExpr.body();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        } else {
            boolean bl = Ast.UpdateGetTime$.MODULE$.equals(update2) ? true : (update2 instanceof Ast.UpdateFetchByKey ? true : update2 instanceof Ast.UpdateLookupByKey);
            if (bl) {
                iterator = ExprIterable$.MODULE$.iterator(update).flatMap((Function1 & Serializable)x$6 -> MODULE$.iterator((Ast.Expr)x$6));
            } else if (update2 instanceof Ast.UpdateTryCatch) {
                Ast.UpdateTryCatch updateTryCatch = (Ast.UpdateTryCatch)update2;
                Ast.Type typ = updateTryCatch.typ();
                Ast.Expr body = updateTryCatch.body();
                Ast.Expr handler = updateTryCatch.handler();
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(handler));
            } else {
                throw new MatchError((Object)update2);
            }
        }
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.Binding binding) {
        Ast.Binding binding2 = binding;
        if (binding2 == null) {
            throw new MatchError((Object)binding2);
        }
        Ast.Type typ = binding2.typ();
        Ast.Expr bound = binding2.bound();
        Iterator iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(bound));
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.Scenario scenario) {
        Iterator iterator;
        Ast.Scenario scenario2 = scenario;
        if (scenario2 instanceof Ast.ScenarioPure) {
            Ast.ScenarioPure scenarioPure = (Ast.ScenarioPure)scenario2;
            Ast.Type typ = scenarioPure.t();
            Ast.Expr expr = scenarioPure.expr();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(expr));
        } else if (scenario2 instanceof Ast.ScenarioBlock) {
            Ast.ScenarioBlock scenarioBlock = (Ast.ScenarioBlock)scenario2;
            ImmArray bindings = scenarioBlock.bindings();
            Ast.Expr body = scenarioBlock.body();
            iterator = bindings.iterator().flatMap((Function1 & Serializable)x$7 -> MODULE$.iterator((Ast.Binding)x$7)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        } else if (scenario2 instanceof Ast.ScenarioCommit) {
            Ast.ScenarioCommit scenarioCommit = (Ast.ScenarioCommit)scenario2;
            Ast.Expr party = scenarioCommit.partyE();
            Ast.Expr update = scenarioCommit.updateE();
            Ast.Type retType = scenarioCommit.retType();
            iterator = this.iterator(party).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(update)).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{retType})));
        } else if (scenario2 instanceof Ast.ScenarioMustFailAt) {
            Ast.ScenarioMustFailAt scenarioMustFailAt = (Ast.ScenarioMustFailAt)scenario2;
            Ast.Expr party = scenarioMustFailAt.partyE();
            Ast.Expr update = scenarioMustFailAt.updateE();
            Ast.Type retType = scenarioMustFailAt.retType();
            iterator = this.iterator(party).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(update)).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{retType})));
        } else if (scenario2 instanceof Ast.ScenarioEmbedExpr) {
            Ast.ScenarioEmbedExpr scenarioEmbedExpr = (Ast.ScenarioEmbedExpr)scenario2;
            Ast.Type typ = scenarioEmbedExpr.typ();
            Ast.Expr body = scenarioEmbedExpr.body();
            iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
        } else {
            boolean bl = Ast.ScenarioGetTime$.MODULE$.equals(scenario2) ? true : (scenario2 instanceof Ast.ScenarioPass ? true : scenario2 instanceof Ast.ScenarioGetParty);
            if (bl) {
                iterator = ExprIterable$.MODULE$.iterator(scenario).flatMap((Function1 & Serializable)x$8 -> MODULE$.iterator((Ast.Expr)x$8));
            } else {
                throw new MatchError((Object)scenario2);
            }
        }
        return iterator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterator<Ast.Type> iterator(Ast.GenDefinition<Ast.Expr> defn) {
        Ast.DataCons dataCons;
        Ast.DataCons dataCons2;
        Ast.DataCons dataCons3;
        boolean bl = false;
        Ast.DDataType dDataType = null;
        Ast.GenDefinition<Ast.Expr> genDefinition = defn;
        if (genDefinition instanceof Ast.DTypeSyn) {
            Ast.DTypeSyn dTypeSyn = (Ast.DTypeSyn)genDefinition;
            Ast.Type typ = dTypeSyn.typ();
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ}));
        }
        if (genDefinition instanceof Ast.DDataType) {
            bl = true;
            dDataType = (Ast.DDataType)genDefinition;
            Ast.DataCons dataCons4 = dDataType.cons();
            if (dataCons4 instanceof Ast.DataRecord) {
                Ast.DataRecord dataRecord = (Ast.DataRecord)dataCons4;
                ImmArray fields = dataRecord.fields();
                return Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(fields));
            }
        }
        if (bl && (dataCons3 = dDataType.cons()) instanceof Ast.DataVariant) {
            Ast.DataVariant dataVariant = (Ast.DataVariant)dataCons3;
            ImmArray variants = dataVariant.variants();
            return Util$TupleImmArrayOps$.MODULE$.values$extension(Util$.MODULE$.TupleImmArrayOps(variants));
        }
        if (bl && (dataCons2 = dDataType.cons()) instanceof Ast.DataEnum) {
            return package$.MODULE$.Iterator().empty();
        }
        if (bl && Ast.DataInterface$.MODULE$.equals(dataCons = dDataType.cons())) {
            return package$.MODULE$.Iterator().empty();
        }
        if (!(genDefinition instanceof Ast.GenDValue)) throw new MatchError(genDefinition);
        Ast.GenDValue genDValue = (Ast.GenDValue)genDefinition;
        Some some = Ast$.MODULE$.DValue().unapply(genDValue);
        if (some.isEmpty()) throw new MatchError(genDefinition);
        Ast.Type typ = (Ast.Type)((Tuple3)some.get())._1();
        Ast.Expr body = (Ast.Expr)((Tuple3)some.get())._2();
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body));
    }

    public Iterator<Ast.Type> iterator(Ast.GenTemplate<Ast.Expr> x) {
        Some some;
        Ast.GenTemplate<Ast.Expr> genTemplate = x;
        if (genTemplate == null || (some = Ast$.MODULE$.Template().unapply(genTemplate)).isEmpty()) {
            throw new MatchError(genTemplate);
        }
        Ast.Expr precond = (Ast.Expr)((Tuple8)some.get())._2();
        Ast.Expr signatories = (Ast.Expr)((Tuple8)some.get())._3();
        Ast.Expr agreementText = (Ast.Expr)((Tuple8)some.get())._4();
        Map choices = (Map)((Tuple8)some.get())._5();
        Ast.Expr observers = (Ast.Expr)((Tuple8)some.get())._6();
        Option key = (Option)((Tuple8)some.get())._7();
        VectorMap vectorMap = (VectorMap)((Tuple8)some.get())._8();
        Iterator iterator = this.iterator(precond).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(signatories)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(agreementText)).$plus$plus((Function0 & Serializable)() -> (Iterable)choices.values().flatMap((Function1 & Serializable)x$9 -> MODULE$.iterator((Ast.GenTemplateChoice<Ast.Expr>)x$9))).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(observers)).$plus$plus((Function0 & Serializable)() -> key.iterator().flatMap((Function1 & Serializable)x$10 -> MODULE$.iterator((Ast.GenTemplateKey<Ast.Expr>)x$10))).$plus$plus((Function0 & Serializable)() -> (scala.collection.immutable.Iterable)vectorMap.values().flatMap((Function1 & Serializable)x$11 -> MODULE$.iterator((Ast.GenTemplateImplements<Ast.Expr>)x$11)));
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.GenTemplateChoice<Ast.Expr> choice) {
        Ast.Expr update;
        Ast.Type retType;
        Tuple2 tuple2;
        Option observers;
        Ast.Expr controllers;
        block3: {
            Ast.GenTemplateChoice<Ast.Expr> genTemplateChoice;
            block2: {
                Some some;
                genTemplateChoice = choice;
                if (genTemplateChoice == null || (some = Ast$.MODULE$.TemplateChoice().unapply(genTemplateChoice)).isEmpty()) break block2;
                controllers = (Ast.Expr)((Tuple8)some.get())._3();
                observers = (Option)((Tuple8)some.get())._4();
                tuple2 = (Tuple2)((Tuple8)some.get())._6();
                retType = (Ast.Type)((Tuple8)some.get())._7();
                update = (Ast.Expr)((Tuple8)some.get())._8();
                if (tuple2 != null) break block3;
            }
            throw new MatchError(genTemplateChoice);
        }
        Ast.Type boundedVarType = (Ast.Type)tuple2._2();
        Iterator iterator = this.iterator(controllers).$plus$plus((Function0 & Serializable)() -> observers.iterator().flatMap((Function1 & Serializable)x$12 -> MODULE$.iterator((Ast.Expr)x$12))).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(update)).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{boundedVarType}))).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{retType})));
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.GenTemplateKey<Ast.Expr> key) {
        Some some;
        Ast.GenTemplateKey<Ast.Expr> genTemplateKey = key;
        if (genTemplateKey == null || (some = Ast$.MODULE$.TemplateKey().unapply(genTemplateKey)).isEmpty()) {
            throw new MatchError(genTemplateKey);
        }
        Ast.Type typ = (Ast.Type)((Tuple3)some.get())._1();
        Ast.Expr body = (Ast.Expr)((Tuple3)some.get())._2();
        Ast.Expr maintainers = (Ast.Expr)((Tuple3)some.get())._3();
        Iterator iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{typ})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(body)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(maintainers));
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.GenTemplateImplements<Ast.Expr> impl) {
        Some some;
        Ast.GenTemplateImplements<Ast.Expr> genTemplateImplements = impl;
        if (genTemplateImplements == null || (some = Ast$.MODULE$.TemplateImplements().unapply(genTemplateImplements)).isEmpty()) {
            throw new MatchError(genTemplateImplements);
        }
        Ref.Identifier identifier = (Ref.Identifier)((Tuple2)some.get())._1();
        Ast.GenInterfaceInstanceBody body = (Ast.GenInterfaceInstanceBody)((Tuple2)some.get())._2();
        Iterator iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(identifier)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator((Ast.GenInterfaceInstanceBody<Ast.Expr>)body));
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.GenInterfaceInstanceBody<Ast.Expr> iiBody) {
        Some some;
        Ast.GenInterfaceInstanceBody<Ast.Expr> genInterfaceInstanceBody = iiBody;
        if (genInterfaceInstanceBody == null || (some = Ast$.MODULE$.InterfaceInstanceBody().unapply(genInterfaceInstanceBody)).isEmpty()) {
            throw new MatchError(genInterfaceInstanceBody);
        }
        Map methods = (Map)((Tuple2)some.get())._1();
        Ast.Expr view = (Ast.Expr)((Tuple2)some.get())._2();
        Iterator iterator = methods.values().iterator().flatMap((Function1 & Serializable)method -> MODULE$.iterator((Ast.GenInterfaceInstanceMethod<Ast.Expr>)method)).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(view));
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.GenInterfaceInstanceMethod<Ast.Expr> method) {
        Some some;
        Ast.GenInterfaceInstanceMethod<Ast.Expr> genInterfaceInstanceMethod = method;
        if (genInterfaceInstanceMethod == null || (some = Ast$.MODULE$.InterfaceInstanceMethod().unapply(genInterfaceInstanceMethod)).isEmpty()) {
            throw new MatchError(genInterfaceInstanceMethod);
        }
        Ast.Expr value = (Ast.Expr)((Tuple2)some.get())._2();
        Iterator<Ast.Type> iterator = this.iterator(value);
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.GenInterfaceCoImplements<Ast.Expr> coImpl) {
        Some some;
        Ast.GenInterfaceCoImplements<Ast.Expr> genInterfaceCoImplements = coImpl;
        if (genInterfaceCoImplements == null || (some = Ast$.MODULE$.InterfaceCoImplements().unapply(genInterfaceCoImplements)).isEmpty()) {
            throw new MatchError(genInterfaceCoImplements);
        }
        Ref.Identifier template = (Ref.Identifier)((Tuple2)some.get())._1();
        Ast.GenInterfaceInstanceBody body = (Ast.GenInterfaceInstanceBody)((Tuple2)some.get())._2();
        Iterator iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TTyCon[]{new Ast.TTyCon(template)})).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator((Ast.GenInterfaceInstanceBody<Ast.Expr>)body));
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.GenDefInterface<Ast.Expr> genDefInterface) {
        Some some;
        Ast.GenDefInterface<Ast.Expr> genDefInterface2 = genDefInterface;
        if (genDefInterface2 == null || (some = Ast$.MODULE$.DefInterface().unapply(genDefInterface2)).isEmpty()) {
            throw new MatchError(genDefInterface2);
        }
        Set requires = (Set)((Tuple6)some.get())._1();
        Map choices = (Map)((Tuple6)some.get())._3();
        Map methods = (Map)((Tuple6)some.get())._4();
        Map coImplements = (Map)((Tuple6)some.get())._5();
        Ast.Type view = (Ast.Type)((Tuple6)some.get())._6();
        Iterator iterator = requires.iterator().map((Function1)Ast.TTyCon$.MODULE$).$plus$plus((Function0 & Serializable)() -> choices.values().iterator().flatMap((Function1 & Serializable)choice -> MODULE$.iterator((Ast.GenTemplateChoice<Ast.Expr>)choice))).$plus$plus((Function0 & Serializable)() -> methods.values().iterator().flatMap((Function1 & Serializable)imethod -> MODULE$.iterator((Ast.InterfaceMethod)imethod))).$plus$plus((Function0 & Serializable)() -> (Iterable)coImplements.values().flatMap((Function1 & Serializable)coImpl -> MODULE$.iterator((Ast.GenInterfaceCoImplements<Ast.Expr>)coImpl))).$plus$plus((Function0 & Serializable)() -> MODULE$.iterator(view));
        return iterator;
    }

    public Iterator<Ast.Type> iterator(Ast.InterfaceMethod imethod) {
        Ast.InterfaceMethod interfaceMethod = imethod;
        if (interfaceMethod == null) {
            throw new MatchError((Object)interfaceMethod);
        }
        Ast.Type retType = interfaceMethod.returnType();
        Iterator iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{retType}));
        return iterator;
    }

    public Iterable<Ast.Type> apply(Ast.Type typ) {
        return new Iterable<Ast.Type>(typ){
            private final Ast.Type typ$2;

            public final Iterable<Ast.Type> toIterable() {
                return Iterable.toIterable$((Iterable)this);
            }

            public final Iterable<Ast.Type> coll() {
                return Iterable.coll$((Iterable)this);
            }

            public IterableFactory<Iterable> iterableFactory() {
                return Iterable.iterableFactory$((Iterable)this);
            }

            public Iterable<Ast.Type> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public String className() {
                return Iterable.className$((Iterable)this);
            }

            public final String collectionClassName() {
                return Iterable.collectionClassName$((Iterable)this);
            }

            public String stringPrefix() {
                return Iterable.stringPrefix$((Iterable)this);
            }

            public String toString() {
                return Iterable.toString$((Iterable)this);
            }

            public <B> LazyZip2<Ast.Type, B, Iterable> lazyZip(Iterable<B> that) {
                return Iterable.lazyZip$((Iterable)this, that);
            }

            public IterableOps fromSpecific(IterableOnce coll) {
                return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
            }

            public Builder<Ast.Type, Iterable<Ast.Type>> newSpecificBuilder() {
                return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
            }

            public IterableOps empty() {
                return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
            }

            public final Iterable<Ast.Type> toTraversable() {
                return IterableOps.toTraversable$((IterableOps)this);
            }

            public boolean isTraversableAgain() {
                return IterableOps.isTraversableAgain$((IterableOps)this);
            }

            public final Object repr() {
                return IterableOps.repr$((IterableOps)this);
            }

            public IterableFactory<Iterable> companion() {
                return IterableOps.companion$((IterableOps)this);
            }

            public Object head() {
                return IterableOps.head$((IterableOps)this);
            }

            public Option<Ast.Type> headOption() {
                return IterableOps.headOption$((IterableOps)this);
            }

            public Object last() {
                return IterableOps.last$((IterableOps)this);
            }

            public Option<Ast.Type> lastOption() {
                return IterableOps.lastOption$((IterableOps)this);
            }

            public View<Ast.Type> view() {
                return IterableOps.view$((IterableOps)this);
            }

            public int sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public final IterableOps sizeIs() {
                return IterableOps.sizeIs$((IterableOps)this);
            }

            public int sizeCompare(Iterable<?> that) {
                return IterableOps.sizeCompare$((IterableOps)this, that);
            }

            public View<Ast.Type> view(int from, int until) {
                return IterableOps.view$((IterableOps)this, (int)from, (int)until);
            }

            public Object transpose(Function1 asIterable) {
                return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
            }

            public Object filter(Function1 pred) {
                return IterableOps.filter$((IterableOps)this, (Function1)pred);
            }

            public Object filterNot(Function1 pred) {
                return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
            }

            public WithFilter<Ast.Type, Iterable> withFilter(Function1<Ast.Type, Object> p) {
                return IterableOps.withFilter$((IterableOps)this, p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> partition(Function1<Ast.Type, Object> p) {
                return IterableOps.partition$((IterableOps)this, p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> splitAt(int n) {
                return IterableOps.splitAt$((IterableOps)this, (int)n);
            }

            public Object take(int n) {
                return IterableOps.take$((IterableOps)this, (int)n);
            }

            public Object takeRight(int n) {
                return IterableOps.takeRight$((IterableOps)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> span(Function1<Ast.Type, Object> p) {
                return IterableOps.span$((IterableOps)this, p);
            }

            public Object drop(int n) {
                return IterableOps.drop$((IterableOps)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableOps.dropRight$((IterableOps)this, (int)n);
            }

            public Object dropWhile(Function1 p) {
                return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
            }

            public Iterator<Iterable<Ast.Type>> grouped(int size) {
                return IterableOps.grouped$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<Ast.Type>> sliding(int size) {
                return IterableOps.sliding$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<Ast.Type>> sliding(int size, int step) {
                return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
            }

            public Object tail() {
                return IterableOps.tail$((IterableOps)this);
            }

            public Object init() {
                return IterableOps.init$((IterableOps)this);
            }

            public Object slice(int from, int until) {
                return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
            }

            public <K> Map<K, Iterable<Ast.Type>> groupBy(Function1<Ast.Type, K> f) {
                return IterableOps.groupBy$((IterableOps)this, f);
            }

            public <K, B> Map<K, Iterable<B>> groupMap(Function1<Ast.Type, K> key, Function1<Ast.Type, B> f) {
                return IterableOps.groupMap$((IterableOps)this, key, f);
            }

            public <K, B> Map<K, B> groupMapReduce(Function1<Ast.Type, K> key, Function1<Ast.Type, B> f, Function2<B, B, B> reduce) {
                return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
            }

            public Object scan(Object z, Function2 op) {
                return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanLeft(Object z, Function2 op) {
                return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanRight(Object z, Function2 op) {
                return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object map(Function1 f) {
                return IterableOps.map$((IterableOps)this, (Function1)f);
            }

            public Object flatMap(Function1 f) {
                return IterableOps.flatMap$((IterableOps)this, (Function1)f);
            }

            public Object flatten(Function1 asIterable) {
                return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
            }

            public Object collect(PartialFunction pf) {
                return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<Ast.Type, Either<A1, A2>> f) {
                return IterableOps.partitionMap$((IterableOps)this, f);
            }

            public Object concat(IterableOnce suffix) {
                return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public final Object $plus$plus(IterableOnce suffix) {
                return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
            }

            public Object zip(IterableOnce that) {
                return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
            }

            public Object zipWithIndex() {
                return IterableOps.zipWithIndex$((IterableOps)this);
            }

            public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Ast.Type, Tuple2<A1, A2>> asPair) {
                return IterableOps.unzip$((IterableOps)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Ast.Type, Tuple3<A1, A2, A3>> asTriple) {
                return IterableOps.unzip3$((IterableOps)this, asTriple);
            }

            public Iterator<Iterable<Ast.Type>> tails() {
                return IterableOps.tails$((IterableOps)this);
            }

            public Iterator<Iterable<Ast.Type>> inits() {
                return IterableOps.inits$((IterableOps)this);
            }

            public Object tapEach(Function1 f) {
                return IterableOps.tapEach$((IterableOps)this, (Function1)f);
            }

            public Object $plus$plus$colon(IterableOnce that) {
                return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
            }

            public boolean hasDefiniteSize() {
                return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Ast.Type, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Ast.Type> find(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Type, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Type, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean isEmpty() {
                return IterableOnceOps.isEmpty$((IterableOnceOps)this);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Ast.Type> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Ast.Type> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Ast.Type> maxByOption(Function1<Ast.Type, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Ast.Type> minByOption(Function1<Ast.Type, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Type, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Type, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Ast.Type, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Ast.Type, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Ast.Type> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Ast.Type> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Ast.Type> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<Ast.Type, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Ast.Type> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Ast.Type> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Ast.Type> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Ast.Type> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Ast.Type, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public Iterator<Ast.Type> iterator() {
                return TypeIterable$.MODULE$.iterator(this.typ$2);
            }
            {
                this.typ$2 = typ$2;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
            }
        };
    }

    public Iterable<Ast.Type> apply(Ast.Expr expr) {
        return new Iterable<Ast.Type>(expr){
            private final Ast.Expr expr$6;

            public final Iterable<Ast.Type> toIterable() {
                return Iterable.toIterable$((Iterable)this);
            }

            public final Iterable<Ast.Type> coll() {
                return Iterable.coll$((Iterable)this);
            }

            public IterableFactory<Iterable> iterableFactory() {
                return Iterable.iterableFactory$((Iterable)this);
            }

            public Iterable<Ast.Type> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public String className() {
                return Iterable.className$((Iterable)this);
            }

            public final String collectionClassName() {
                return Iterable.collectionClassName$((Iterable)this);
            }

            public String stringPrefix() {
                return Iterable.stringPrefix$((Iterable)this);
            }

            public String toString() {
                return Iterable.toString$((Iterable)this);
            }

            public <B> LazyZip2<Ast.Type, B, Iterable> lazyZip(Iterable<B> that) {
                return Iterable.lazyZip$((Iterable)this, that);
            }

            public IterableOps fromSpecific(IterableOnce coll) {
                return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
            }

            public Builder<Ast.Type, Iterable<Ast.Type>> newSpecificBuilder() {
                return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
            }

            public IterableOps empty() {
                return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
            }

            public final Iterable<Ast.Type> toTraversable() {
                return IterableOps.toTraversable$((IterableOps)this);
            }

            public boolean isTraversableAgain() {
                return IterableOps.isTraversableAgain$((IterableOps)this);
            }

            public final Object repr() {
                return IterableOps.repr$((IterableOps)this);
            }

            public IterableFactory<Iterable> companion() {
                return IterableOps.companion$((IterableOps)this);
            }

            public Object head() {
                return IterableOps.head$((IterableOps)this);
            }

            public Option<Ast.Type> headOption() {
                return IterableOps.headOption$((IterableOps)this);
            }

            public Object last() {
                return IterableOps.last$((IterableOps)this);
            }

            public Option<Ast.Type> lastOption() {
                return IterableOps.lastOption$((IterableOps)this);
            }

            public View<Ast.Type> view() {
                return IterableOps.view$((IterableOps)this);
            }

            public int sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public final IterableOps sizeIs() {
                return IterableOps.sizeIs$((IterableOps)this);
            }

            public int sizeCompare(Iterable<?> that) {
                return IterableOps.sizeCompare$((IterableOps)this, that);
            }

            public View<Ast.Type> view(int from, int until) {
                return IterableOps.view$((IterableOps)this, (int)from, (int)until);
            }

            public Object transpose(Function1 asIterable) {
                return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
            }

            public Object filter(Function1 pred) {
                return IterableOps.filter$((IterableOps)this, (Function1)pred);
            }

            public Object filterNot(Function1 pred) {
                return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
            }

            public WithFilter<Ast.Type, Iterable> withFilter(Function1<Ast.Type, Object> p) {
                return IterableOps.withFilter$((IterableOps)this, p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> partition(Function1<Ast.Type, Object> p) {
                return IterableOps.partition$((IterableOps)this, p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> splitAt(int n) {
                return IterableOps.splitAt$((IterableOps)this, (int)n);
            }

            public Object take(int n) {
                return IterableOps.take$((IterableOps)this, (int)n);
            }

            public Object takeRight(int n) {
                return IterableOps.takeRight$((IterableOps)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> span(Function1<Ast.Type, Object> p) {
                return IterableOps.span$((IterableOps)this, p);
            }

            public Object drop(int n) {
                return IterableOps.drop$((IterableOps)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableOps.dropRight$((IterableOps)this, (int)n);
            }

            public Object dropWhile(Function1 p) {
                return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
            }

            public Iterator<Iterable<Ast.Type>> grouped(int size) {
                return IterableOps.grouped$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<Ast.Type>> sliding(int size) {
                return IterableOps.sliding$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<Ast.Type>> sliding(int size, int step) {
                return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
            }

            public Object tail() {
                return IterableOps.tail$((IterableOps)this);
            }

            public Object init() {
                return IterableOps.init$((IterableOps)this);
            }

            public Object slice(int from, int until) {
                return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
            }

            public <K> Map<K, Iterable<Ast.Type>> groupBy(Function1<Ast.Type, K> f) {
                return IterableOps.groupBy$((IterableOps)this, f);
            }

            public <K, B> Map<K, Iterable<B>> groupMap(Function1<Ast.Type, K> key, Function1<Ast.Type, B> f) {
                return IterableOps.groupMap$((IterableOps)this, key, f);
            }

            public <K, B> Map<K, B> groupMapReduce(Function1<Ast.Type, K> key, Function1<Ast.Type, B> f, Function2<B, B, B> reduce) {
                return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
            }

            public Object scan(Object z, Function2 op) {
                return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanLeft(Object z, Function2 op) {
                return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanRight(Object z, Function2 op) {
                return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object map(Function1 f) {
                return IterableOps.map$((IterableOps)this, (Function1)f);
            }

            public Object flatMap(Function1 f) {
                return IterableOps.flatMap$((IterableOps)this, (Function1)f);
            }

            public Object flatten(Function1 asIterable) {
                return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
            }

            public Object collect(PartialFunction pf) {
                return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<Ast.Type, Either<A1, A2>> f) {
                return IterableOps.partitionMap$((IterableOps)this, f);
            }

            public Object concat(IterableOnce suffix) {
                return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public final Object $plus$plus(IterableOnce suffix) {
                return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
            }

            public Object zip(IterableOnce that) {
                return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
            }

            public Object zipWithIndex() {
                return IterableOps.zipWithIndex$((IterableOps)this);
            }

            public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Ast.Type, Tuple2<A1, A2>> asPair) {
                return IterableOps.unzip$((IterableOps)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Ast.Type, Tuple3<A1, A2, A3>> asTriple) {
                return IterableOps.unzip3$((IterableOps)this, asTriple);
            }

            public Iterator<Iterable<Ast.Type>> tails() {
                return IterableOps.tails$((IterableOps)this);
            }

            public Iterator<Iterable<Ast.Type>> inits() {
                return IterableOps.inits$((IterableOps)this);
            }

            public Object tapEach(Function1 f) {
                return IterableOps.tapEach$((IterableOps)this, (Function1)f);
            }

            public Object $plus$plus$colon(IterableOnce that) {
                return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
            }

            public boolean hasDefiniteSize() {
                return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Ast.Type, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Ast.Type> find(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Type, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Type, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean isEmpty() {
                return IterableOnceOps.isEmpty$((IterableOnceOps)this);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Ast.Type> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Ast.Type> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Ast.Type> maxByOption(Function1<Ast.Type, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Ast.Type> minByOption(Function1<Ast.Type, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Type, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Type, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Ast.Type, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Ast.Type, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Ast.Type> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Ast.Type> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Ast.Type> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<Ast.Type, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Ast.Type> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Ast.Type> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Ast.Type> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Ast.Type> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Ast.Type, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public Iterator<Ast.Type> iterator() {
                return TypeIterable$.MODULE$.iterator(this.expr$6);
            }
            {
                this.expr$6 = expr$6;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
            }
        };
    }

    public Iterable<Ast.Type> apply(Ast.GenModule<Ast.Expr> module) {
        return new Iterable<Ast.Type>(module){
            private final Ast.GenModule module$1;

            public final Iterable<Ast.Type> toIterable() {
                return Iterable.toIterable$((Iterable)this);
            }

            public final Iterable<Ast.Type> coll() {
                return Iterable.coll$((Iterable)this);
            }

            public IterableFactory<Iterable> iterableFactory() {
                return Iterable.iterableFactory$((Iterable)this);
            }

            public Iterable<Ast.Type> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public String className() {
                return Iterable.className$((Iterable)this);
            }

            public final String collectionClassName() {
                return Iterable.collectionClassName$((Iterable)this);
            }

            public String stringPrefix() {
                return Iterable.stringPrefix$((Iterable)this);
            }

            public String toString() {
                return Iterable.toString$((Iterable)this);
            }

            public <B> LazyZip2<Ast.Type, B, Iterable> lazyZip(Iterable<B> that) {
                return Iterable.lazyZip$((Iterable)this, that);
            }

            public IterableOps fromSpecific(IterableOnce coll) {
                return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
            }

            public Builder<Ast.Type, Iterable<Ast.Type>> newSpecificBuilder() {
                return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
            }

            public IterableOps empty() {
                return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
            }

            public final Iterable<Ast.Type> toTraversable() {
                return IterableOps.toTraversable$((IterableOps)this);
            }

            public boolean isTraversableAgain() {
                return IterableOps.isTraversableAgain$((IterableOps)this);
            }

            public final Object repr() {
                return IterableOps.repr$((IterableOps)this);
            }

            public IterableFactory<Iterable> companion() {
                return IterableOps.companion$((IterableOps)this);
            }

            public Object head() {
                return IterableOps.head$((IterableOps)this);
            }

            public Option<Ast.Type> headOption() {
                return IterableOps.headOption$((IterableOps)this);
            }

            public Object last() {
                return IterableOps.last$((IterableOps)this);
            }

            public Option<Ast.Type> lastOption() {
                return IterableOps.lastOption$((IterableOps)this);
            }

            public View<Ast.Type> view() {
                return IterableOps.view$((IterableOps)this);
            }

            public int sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public final IterableOps sizeIs() {
                return IterableOps.sizeIs$((IterableOps)this);
            }

            public int sizeCompare(Iterable<?> that) {
                return IterableOps.sizeCompare$((IterableOps)this, that);
            }

            public View<Ast.Type> view(int from, int until) {
                return IterableOps.view$((IterableOps)this, (int)from, (int)until);
            }

            public Object transpose(Function1 asIterable) {
                return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
            }

            public Object filter(Function1 pred) {
                return IterableOps.filter$((IterableOps)this, (Function1)pred);
            }

            public Object filterNot(Function1 pred) {
                return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
            }

            public WithFilter<Ast.Type, Iterable> withFilter(Function1<Ast.Type, Object> p) {
                return IterableOps.withFilter$((IterableOps)this, p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> partition(Function1<Ast.Type, Object> p) {
                return IterableOps.partition$((IterableOps)this, p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> splitAt(int n) {
                return IterableOps.splitAt$((IterableOps)this, (int)n);
            }

            public Object take(int n) {
                return IterableOps.take$((IterableOps)this, (int)n);
            }

            public Object takeRight(int n) {
                return IterableOps.takeRight$((IterableOps)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
            }

            public Tuple2<Iterable<Ast.Type>, Iterable<Ast.Type>> span(Function1<Ast.Type, Object> p) {
                return IterableOps.span$((IterableOps)this, p);
            }

            public Object drop(int n) {
                return IterableOps.drop$((IterableOps)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableOps.dropRight$((IterableOps)this, (int)n);
            }

            public Object dropWhile(Function1 p) {
                return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
            }

            public Iterator<Iterable<Ast.Type>> grouped(int size) {
                return IterableOps.grouped$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<Ast.Type>> sliding(int size) {
                return IterableOps.sliding$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<Ast.Type>> sliding(int size, int step) {
                return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
            }

            public Object tail() {
                return IterableOps.tail$((IterableOps)this);
            }

            public Object init() {
                return IterableOps.init$((IterableOps)this);
            }

            public Object slice(int from, int until) {
                return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
            }

            public <K> Map<K, Iterable<Ast.Type>> groupBy(Function1<Ast.Type, K> f) {
                return IterableOps.groupBy$((IterableOps)this, f);
            }

            public <K, B> Map<K, Iterable<B>> groupMap(Function1<Ast.Type, K> key, Function1<Ast.Type, B> f) {
                return IterableOps.groupMap$((IterableOps)this, key, f);
            }

            public <K, B> Map<K, B> groupMapReduce(Function1<Ast.Type, K> key, Function1<Ast.Type, B> f, Function2<B, B, B> reduce) {
                return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
            }

            public Object scan(Object z, Function2 op) {
                return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanLeft(Object z, Function2 op) {
                return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanRight(Object z, Function2 op) {
                return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object map(Function1 f) {
                return IterableOps.map$((IterableOps)this, (Function1)f);
            }

            public Object flatMap(Function1 f) {
                return IterableOps.flatMap$((IterableOps)this, (Function1)f);
            }

            public Object flatten(Function1 asIterable) {
                return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
            }

            public Object collect(PartialFunction pf) {
                return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<Ast.Type, Either<A1, A2>> f) {
                return IterableOps.partitionMap$((IterableOps)this, f);
            }

            public Object concat(IterableOnce suffix) {
                return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public final Object $plus$plus(IterableOnce suffix) {
                return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
            }

            public Object zip(IterableOnce that) {
                return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
            }

            public Object zipWithIndex() {
                return IterableOps.zipWithIndex$((IterableOps)this);
            }

            public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Ast.Type, Tuple2<A1, A2>> asPair) {
                return IterableOps.unzip$((IterableOps)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Ast.Type, Tuple3<A1, A2, A3>> asTriple) {
                return IterableOps.unzip3$((IterableOps)this, asTriple);
            }

            public Iterator<Iterable<Ast.Type>> tails() {
                return IterableOps.tails$((IterableOps)this);
            }

            public Iterator<Iterable<Ast.Type>> inits() {
                return IterableOps.inits$((IterableOps)this);
            }

            public Object tapEach(Function1 f) {
                return IterableOps.tapEach$((IterableOps)this, (Function1)f);
            }

            public Object $plus$plus$colon(IterableOnce that) {
                return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
            }

            public boolean hasDefiniteSize() {
                return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Ast.Type, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Ast.Type> find(Function1<Ast.Type, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Ast.Type, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Ast.Type, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Ast.Type, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Ast.Type, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean isEmpty() {
                return IterableOnceOps.isEmpty$((IterableOnceOps)this);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Ast.Type> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Ast.Type> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Ast.Type> maxByOption(Function1<Ast.Type, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Ast.Type> minByOption(Function1<Ast.Type, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<Ast.Type, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Ast.Type, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Ast.Type, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Ast.Type, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Ast.Type> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Ast.Type> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Ast.Type> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<Ast.Type, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Ast.Type> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Ast.Type> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Ast.Type> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Ast.Type> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Ast.Type, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public Iterator<Ast.Type> iterator() {
                return this.module$1.definitions().values().iterator().flatMap((Function1 & Serializable)x$13 -> TypeIterable$.MODULE$.iterator((Ast.GenDefinition<Ast.Expr>)x$13)).$plus$plus((Function0 & Serializable)() -> $this.module$1.interfaces().values().iterator().flatMap((Function1 & Serializable)x$14 -> TypeIterable$.MODULE$.iterator((Ast.GenDefInterface<Ast.Expr>)x$14))).$plus$plus((Function0 & Serializable)() -> $this.module$1.templates().values().iterator().flatMap((Function1 & Serializable)x$15 -> TypeIterable$.MODULE$.iterator((Ast.GenTemplate<Ast.Expr>)x$15)));
            }
            {
                this.module$1 = module$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$iterator$90(com.daml.lf.language.Ast$GenDefinition ), $anonfun$iterator$91(com.daml.lf.validation.iterable.TypeIterable$$anon$3 ), $anonfun$iterator$92(com.daml.lf.language.Ast$GenDefInterface ), $anonfun$iterator$93(com.daml.lf.validation.iterable.TypeIterable$$anon$3 ), $anonfun$iterator$94(com.daml.lf.language.Ast$GenTemplate )}, serializedLambda);
            }
        };
    }

    private TypeIterable$() {
    }
}

