/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.tls;

import com.daml.ledger.api.tls.TlsConfiguration;
import io.netty.handler.ssl.ClientAuth;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Try$;
import scopt.OptionParser;
import scopt.Read$;

public final class TlsConfigurationCli$ {
    public static final TlsConfigurationCli$ MODULE$ = new TlsConfigurationCli$();

    public <C> void parse(OptionParser<C> parser, String colSpacer, Function2<Function1<TlsConfiguration, TlsConfiguration>, C, C> setter) {
        parser.opt("pem", Read$.MODULE$.stringRead()).optional().text("TLS: The pem file to be used as the private key.").validate((Function1 & Serializable)x$1 -> MODULE$.validatePath((String)x$1, "The file specified via --pem does not exist")).action((Function2 & Serializable)(path, c) -> TlsConfigurationCli$.enableSet$1((Function1 & Serializable)x$2 -> {
            Some x$1 = new Some((Object)Paths.get(path, new String[0]).toFile());
            boolean x$22 = x$2.copy$default$1();
            Option x$3 = x$2.copy$default$2();
            Option x$4 = x$2.copy$default$4();
            Option x$5 = x$2.copy$default$5();
            ClientAuth x$6 = x$2.copy$default$6();
            boolean x$7 = x$2.copy$default$7();
            Option x$8 = x$2.copy$default$8();
            return x$2.copy(x$22, x$3, (Option)x$1, x$4, x$5, x$6, x$7, x$8);
        }, c, setter));
        parser.opt("crt", Read$.MODULE$.stringRead()).optional().text(new StringBuilder(0).append(new StringBuilder(48).append("TLS: The crt file to be used as the cert chain.\n").append(colSpacer).toString()).append("Required for client authentication.").toString()).validate((Function1 & Serializable)x$3 -> MODULE$.validatePath((String)x$3, "The file specified via --crt does not exist")).action((Function2 & Serializable)(path, c) -> TlsConfigurationCli$.enableSet$1((Function1 & Serializable)x$4 -> {
            Some x$9 = new Some((Object)Paths.get(path, new String[0]).toFile());
            boolean x$10 = x$4.copy$default$1();
            Option x$11 = x$4.copy$default$3();
            Option x$12 = x$4.copy$default$4();
            Option x$13 = x$4.copy$default$5();
            ClientAuth x$14 = x$4.copy$default$6();
            boolean x$15 = x$4.copy$default$7();
            Option x$16 = x$4.copy$default$8();
            return x$4.copy(x$10, (Option)x$9, x$11, x$12, x$13, x$14, x$15, x$16);
        }, c, setter));
        parser.opt("cacrt", Read$.MODULE$.stringRead()).optional().text("TLS: The crt file to be used as the trusted root CA.").validate((Function1 & Serializable)x$5 -> MODULE$.validatePath((String)x$5, "The file specified via --cacrt does not exist")).action((Function2 & Serializable)(path, c) -> TlsConfigurationCli$.enableSet$1((Function1 & Serializable)x$6 -> {
            Some x$17 = new Some((Object)Paths.get(path, new String[0]).toFile());
            boolean x$18 = x$6.copy$default$1();
            Option x$19 = x$6.copy$default$2();
            Option x$20 = x$6.copy$default$3();
            Option x$21 = x$6.copy$default$5();
            ClientAuth x$22 = x$6.copy$default$6();
            boolean x$23 = x$6.copy$default$7();
            Option x$24 = x$6.copy$default$8();
            return x$6.copy(x$18, x$19, x$20, (Option)x$17, x$21, x$22, x$23, x$24);
        }, c, setter));
        parser.opt("tls", Read$.MODULE$.unitRead()).optional().text("TLS: Enable tls. This is redundant if --pem, --crt or --cacrt are set").action((Function2 & Serializable)(x$7, c) -> TlsConfigurationCli$.enableSet$1((Function1 & Serializable)x -> (TlsConfiguration)Predef$.MODULE$.identity(x), c, setter));
    }

    private Either<String, BoxedUnit> validatePath(String path, String message) {
        boolean valid = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> Paths.get(path, new String[0]).toFile().canRead()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        return valid ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)message);
    }

    private static final Object enableSet$1(Function1 tlsUp, Object c, Function2 setter$1) {
        return setter$1.apply((Function1 & Serializable)tlsc -> (TlsConfiguration)tlsUp.apply((Object)tlsc.copy(true, tlsc.copy$default$2(), tlsc.copy$default$3(), tlsc.copy$default$4(), tlsc.copy$default$5(), tlsc.copy$default$6(), tlsc.copy$default$7(), tlsc.copy$default$8())), c);
    }

    private TlsConfigurationCli$() {
    }
}

