/*
 * Decompiled with CFR 0.152.
 */
package com.daml.cliopts;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.daml.cliopts.Logging;
import com.daml.cliopts.Logging$LogEncoder$Json$;
import com.daml.cliopts.Logging$LogEncoder$Plain$;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scopt.OptionParser;
import scopt.Read;
import scopt.Read$;

public final class Logging$ {
    public static final Logging$ MODULE$ = new Logging$();
    private static final Set<String> KnownLogLevels = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR", "WARN", "INFO", "DEBUG", "TRACE"}));
    private static final Read<Level> scoptLogLevel = Read$.MODULE$.reads((Function1 & Serializable)level -> (Level)package$.MODULE$.Either().cond(MODULE$.KnownLogLevels().contains((Object)level.toUpperCase()), (Function0 & Serializable)() -> Level.toLevel((String)level.toUpperCase()), (Function0 & Serializable)() -> new StringBuilder(27).append("Unrecognized logging level ").append((String)level).toString()).getOrElse((Function0 & Serializable)() -> {
        throw new IllegalArgumentException(new StringBuilder(22).append("Unknown logging level ").append((String)level).toString());
    }));
    private static final Read<Logging.LogEncoder> scoptLogEncoder = Read$.MODULE$.reads((Function1 & Serializable)encoder -> {
        Product product;
        block4: {
            String string = encoder.toLowerCase();
            switch (string == null ? 0 : string.hashCode()) {
                case 3271912: {
                    if (!"json".equals(string)) break;
                    product = Logging$LogEncoder$Json$.MODULE$;
                    break block4;
                }
                case 106748362: {
                    if (!"plain".equals(string)) break;
                    product = Logging$LogEncoder$Plain$.MODULE$;
                    break block4;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(29).append("Unrecognized logging encoder ").append((String)encoder).toString());
        }
        return product;
    });

    public void reconfigure(Class<?> clazz) {
        block3: {
            String string = System.getProperty("logback.configurationFile");
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (string != null) break;
                    Logging$.reloadConfig$1(clazz.getClassLoader().getResource("logback.xml"));
                    break block3;
                }
            }
            Logging$.reloadConfig$1(new File(string).toURI().toURL());
        }
    }

    private Set<String> KnownLogLevels() {
        return KnownLogLevels;
    }

    private Read<Level> scoptLogLevel() {
        return scoptLogLevel;
    }

    private Read<Logging.LogEncoder> scoptLogEncoder() {
        return scoptLogEncoder;
    }

    public <C> void logLevelParse(OptionParser<C> parser, Function2<Function1<Option<Level>, Option<Level>>, C, C> logLevel) {
        parser.opt("log-level", this.scoptLogLevel()).optional().action((Function2 & Serializable)(level, c) -> logLevel.apply((Function1 & Serializable)x$1 -> new Some(level), c)).text(new StringBuilder(70).append("Default logging level to use. Available values are ").append(this.KnownLogLevels().mkString(", ")).append(". Defaults to INFO.").toString());
    }

    public <C> void logEncoderParse(OptionParser<C> parser, Function2<Function1<Logging.LogEncoder, Logging.LogEncoder>, C, C> logEncoder) {
        parser.opt("log-encoder", this.scoptLogEncoder()).optional().action((Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Logging.LogEncoder logEncoder = (Logging.LogEncoder)tuple2._1();
                Object c = tuple2._2();
                if (Logging$LogEncoder$Plain$.MODULE$.equals(logEncoder)) {
                    return c;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Logging.LogEncoder encoder = (Logging.LogEncoder)tuple2._1();
            Object c = tuple2._2();
            return logEncoder.apply((Function1 & Serializable)x$2 -> encoder, c);
        }).text("Which encoder to use: plain|json");
    }

    public void setUseJsonLogEncoderSystemProp() {
        System.setProperty("LOG_FORMAT_JSON", "true");
    }

    private static final void reloadConfig$1(URL path) {
        try {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(path);
        }
        catch (JoranException je) {
            System.err.println(new StringBuilder(32).append("reconfigured failed using url ").append(path).append(": ").append((Object)je).toString());
        }
    }

    private Logging$() {
    }
}

