/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.service;

import com.daml.daml_lf_dev.DamlLf;
import com.daml.ledger.api.v1.package_service.GetPackageResponse;
import com.daml.ledger.client.services.pkg.PackageClient;
import com.daml.lf.archive.Reader$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.iface.DefDataType;
import com.daml.lf.iface.Interface;
import com.daml.lf.iface.Type;
import com.daml.lf.iface.reader.Errors;
import com.daml.lf.iface.reader.Errors$;
import com.daml.lf.iface.reader.InterfaceReader$;
import com.google.protobuf.CodedInputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scalaz.;
import scalaz.$bslash$div$;
import scalaz.Applicative;
import scalaz.Bind;
import scalaz.Foldable;
import scalaz.Liskov$;
import scalaz.Scalaz$;

public final class LedgerReader$ {
    public static LedgerReader$ MODULE$;
    private final Future<.bslash.div<String, Option<Map<String, Interface>>>> UpToDate;

    static {
        new LedgerReader$();
    }

    public Future<.bslash.div<String, Option<Map<String, Interface>>>> UpToDate() {
        return this.UpToDate;
    }

    public Future<.bslash.div<String, Option<Map<String, Interface>>>> loadPackageStoreUpdates(PackageClient client, Option<String> token, Set<String> loadedPackageIds) {
        return client.listPackages(token).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.packageIds().toList(), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)newPackageIds -> {
            List diffIds = (List)newPackageIds.filterNot((Function1)loadedPackageIds);
            return new Tuple2(newPackageIds, (Object)diffIds);
        }, ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List diffIds = (List)tuple2._2();
            Future future = (diffIds.isEmpty() ? MODULE$.UpToDate() : MODULE$.load(client, (List<String>)diffIds, token)).map((Function1 & Serializable & scala.Serializable)result -> result, ExecutionContext.Implicits$.MODULE$.global());
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<.bslash.div<String, Some<Map<String, Interface>>>> load(PackageClient client, List<String> packageIds, Option<String> token) {
        return ((Future)Scalaz$.MODULE$.ToTraverseOps(packageIds, Scalaz$.MODULE$.listInstance()).traverse((Function1 & Serializable & scala.Serializable)x$3 -> client.getPackage(x$3, token), (Applicative)Scalaz$.MODULE$.futureInstance(ExecutionContext.Implicits$.MODULE$.global()))).map((Function1 & Serializable & scala.Serializable)packageResponses -> MODULE$.createPackageStoreFromArchives((List<GetPackageResponse>)packageResponses), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.map((Function1 & Serializable & scala.Serializable)x$5 -> new Some(x$5)), ExecutionContext.Implicits$.MODULE$.global());
    }

    private .bslash.div<String, Map<String, Interface>> createPackageStoreFromArchives(List<GetPackageResponse> packageResponses) {
        return ((.bslash.div)Scalaz$.MODULE$.ToTraverseOps(packageResponses, Scalaz$.MODULE$.listInstance()).traverse((Function1 & Serializable & scala.Serializable)packageResponse -> MODULE$.decodeInterfaceFromPackageResponse((GetPackageResponse)packageResponse).map((Function1 & Serializable & scala.Serializable)interface_ -> new Tuple2((Object)interface_.packageId(), interface_)), (Applicative)$bslash$div$.MODULE$.DisjunctionInstances1())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toMap(Predef$.MODULE$.$conforms()));
    }

    private .bslash.div<String, Interface> decodeInterfaceFromPackageResponse(GetPackageResponse packageResponse) {
        return (.bslash.div)Scalaz$.MODULE$.ToBindOps((Object)$bslash$div$.MODULE$.fromTryCatchNonFatal((Function0 & Serializable & scala.Serializable)() -> {
            CodedInputStream cos = Reader$.MODULE$.damlLfCodedInputStream(packageResponse.archivePayload().newInput(), Reader$.MODULE$.damlLfCodedInputStream$default$2());
            DamlLf.ArchivePayload payload = DamlLf.ArchivePayload.parseFrom((CodedInputStream)cos);
            Tuple2 tuple2 = InterfaceReader$.MODULE$.readInterface(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Ref$.MODULE$.PackageId().assertFromString(packageResponse.hash())), (Object)payload));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Errors errors = (Errors)tuple2._1();
            Interface out = (Interface)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)errors, (Object)out);
            Tuple2 tuple23 = tuple22;
            Errors errors2 = (Errors)tuple23._1();
            Interface out2 = (Interface)tuple23._2();
            return !Scalaz$.MODULE$.ToFoldableOps((Object)errors2, (Foldable)Errors$.MODULE$.Errors$u0020covariant()).empty() ? (.bslash.div)$bslash$div$.MODULE$.left().apply((Object)new StringBuilder(27).append("Errors reading LF archive:\n").append(errors2.toString()).toString()) : (.bslash.div)$bslash$div$.MODULE$.right().apply((Object)out2);
        }).leftMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getLocalizedMessage()), (Bind)$bslash$div$.MODULE$.DisjunctionInstances1()).join(Liskov$.MODULE$.refl());
    }

    public Option<DefDataType<Type, Type>> damlLfTypeLookup(Function0<Map<String, Interface>> packageStore, Ref.Identifier id) {
        return ((MapLike)packageStore.apply()).get((Object)id.packageId()).flatMap((Function1 & Serializable & scala.Serializable)iface -> iface.typeDecls().get((Object)id.qualifiedName()).map((Function1 & Serializable & scala.Serializable)ifaceType -> ifaceType.type()));
    }

    private LedgerReader$() {
        MODULE$ = this;
        this.UpToDate = Future$.MODULE$.successful((Object)new .bslash.div.minus((Object)None$.MODULE$));
    }
}

