/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.service;

import com.daml.daml_lf_dev.DamlLf;
import com.daml.ledger.api.v1.package_service.GetPackageResponse;
import com.daml.ledger.client.services.pkg.PackageClient;
import com.daml.ledger.service.Grpc$StatusEnvelope$;
import com.daml.ledger.service.LedgerReader;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.typesig.DataType;
import com.daml.lf.typesig.DefDataType;
import com.daml.lf.typesig.PackageSignature;
import com.daml.lf.typesig.PackageSignature$;
import com.daml.lf.typesig.Type;
import com.daml.lf.typesig.reader.Errors;
import com.daml.lf.typesig.reader.Errors$;
import com.daml.lf.typesig.reader.SignatureReader$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.scalautil.TraverseFMSyntax;
import com.daml.scalautil.TraverseFMSyntax$;
import com.daml.timer.RetryStrategy;
import com.daml.timer.RetryStrategy$;
import com.google.rpc.Code;
import com.google.rpc.Status;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Random$;
import scalaz.;
import scalaz.$bslash$div$;
import scalaz.Applicative;
import scalaz.Bind;
import scalaz.Foldable;
import scalaz.Leibniz$;
import scalaz.Liskov$;
import scalaz.Monad;
import scalaz.Scalaz$;

public final class LedgerReader$ {
    public static final LedgerReader$ MODULE$ = new LedgerReader$();
    private static final Future<.bslash.div<String, Option<Map<String, PackageSignature>>>> UpToDate = Future$.MODULE$.successful((Object)new .bslash.div.minus((Object)None$.MODULE$));
    private static final ContextualizedLogger com$daml$ledger$service$LedgerReader$$logger = ContextualizedLogger$.MODULE$.get(MODULE$.getClass());

    public Future<.bslash.div<String, Option<Map<String, PackageSignature>>>> UpToDate() {
        return UpToDate;
    }

    public Future<.bslash.div<String, Option<Map<String, PackageSignature>>>> loadPackageStoreUpdates(com.daml.ledger.client.services.pkg.withoutledgerid.PackageClient client, LedgerReader.LoadCache loadCache, Option<String> token, Object ledgerId, Set<String> loadedPackageIds, ExecutionContext ec, LoggingContext lc) {
        return client.listPackages(ledgerId, token).map((Function1 & Serializable)x$1 -> x$1.packageIds().toList(), ec).map((Function1 & Serializable)newPackageIds -> {
            List diffIds = newPackageIds.filterNot((Function1)loadedPackageIds);
            return new Tuple2(newPackageIds, (Object)diffIds);
        }, ec).flatMap((Function1 & Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                List diffIds = (List)tuple2._2();
                return (diffIds.isEmpty() ? MODULE$.UpToDate() : MODULE$.load(client, loadCache, (List<String>)diffIds, ledgerId, token, ec, lc)).map((Function1 & Serializable)result -> result, ec);
            }
            throw new MatchError((Object)tuple2);
        }, ec);
    }

    public Future<.bslash.div<String, Option<Map<String, PackageSignature>>>> loadPackageStoreUpdates(PackageClient client, LedgerReader.LoadCache loadCache, Option<String> token, Set<String> loadedPackageIds, ExecutionContext ec, LoggingContext lc) {
        return this.loadPackageStoreUpdates(client.it(), loadCache, token, client.ledgerId(), loadedPackageIds, ec, lc);
    }

    private <PS> Future<.bslash.div<String, PS>> load(com.daml.ledger.client.services.pkg.withoutledgerid.PackageClient client, LedgerReader.LoadCache loadCache, List<String> packageIds, Object ledgerId, Option<String> token, ExecutionContext ec, LoggingContext lc) {
        return ((Future)TraverseFMSyntax.TraverseFM$u0020Ops$.MODULE$.traverseFM$extension(TraverseFMSyntax$.MODULE$.TraverseFM$u0020Ops(Random$.MODULE$.shuffle((IterableOnce)packageIds.grouped(loadCache.ParallelLoadFactor()).toList(), BuildFrom$.MODULE$.buildFromIterableOps())), (Function1 & Serializable)x$3 -> (Future)Scalaz$.MODULE$.ToTraverseOps(x$3, Scalaz$.MODULE$.listInstance()).traverse((Function1 & Serializable)x$4 -> MODULE$.getPackage(client, loadCache, ledgerId, token, (String)x$4, ec, lc), (Applicative)Scalaz$.MODULE$.futureInstance(ec)), (Monad)Scalaz$.MODULE$.futureInstance(ec), Scalaz$.MODULE$.listInstance())).map((Function1 & Serializable)groups -> MODULE$.createPackageStoreFromArchives((List<.bslash.div<String, PackageSignature>>)((List)groups.flatten(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)x$5 -> new Some(x$5)), ec);
    }

    private Future<.bslash.div<String, PackageSignature>> getPackage(com.daml.ledger.client.services.pkg.withoutledgerid.PackageClient client, LedgerReader.LoadCache loadCache, Object ledgerId, Option<String> token, String pkid, ExecutionContext ec, LoggingContext lc) {
        Tuple2 ck = new Tuple2(ledgerId, (Object)pkid);
        return this.retryLoop((Function0 & Serializable)() -> (Future)Scalaz$.MODULE$.ToOptionOpsFromOption(loadCache.cache().getIfPresent((Object)ck)).cata((Function1 & Serializable)v -> {
            MODULE$.com$daml$ledger$service$LedgerReader$$logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(49).append("detected redundant package load before starting: ").append(pkid).toString(), lc);
            return Future$.MODULE$.successful(v);
        }, (Function0 & Serializable)() -> client.getPackage(pkid, ledgerId, token).map((Function1 & Serializable)pkresp -> (.bslash.div)Scalaz$.MODULE$.ToOptionOpsFromOption(loadCache.cache().getIfPresent((Object)ck)).cata((Function1 & Serializable)decoded -> {
            MODULE$.com$daml$ledger$service$LedgerReader$$logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(44).append("detected redundant package load after gRPC: ").append(pkid).toString(), lc);
            return decoded;
        }, (Function0 & Serializable)() -> {
            .bslash.div<String, PackageSignature> decoded = MODULE$.decodeInterfaceFromPackageResponse((GetPackageResponse)pkresp);
            if (MODULE$.com$daml$ledger$service$LedgerReader$$logger().trace().isEnabled() && loadCache.cache().getIfPresent((Object)ck).isDefined()) {
                MODULE$.com$daml$ledger$service$LedgerReader$$logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(48).append("detected redundant package load after decoding: ").append(pkid).toString(), lc);
            }
            loadCache.cache().put((Object)ck, decoded);
            return decoded;
        }), ec)), ec, lc);
    }

    private .bslash.div<String, Map<String, PackageSignature>> createPackageStoreFromArchives(List<.bslash.div<String, PackageSignature>> packageResponses) {
        return ((.bslash.div)Scalaz$.MODULE$.ToTraverseOps(packageResponses, Scalaz$.MODULE$.listInstance()).sequence(Leibniz$.MODULE$.refl(), (Applicative)$bslash$div$.MODULE$.DisjunctionInstances1())).map((Function1 & Serializable)x$6 -> x$6.groupMapReduce((Function1 & Serializable)x$7 -> x$7.packageId(), (Function1 & Serializable)x -> (PackageSignature)Predef$.MODULE$.identity(x), (Function2 & Serializable)(x$8, sig) -> sig));
    }

    private .bslash.div<String, PackageSignature> decodeInterfaceFromPackageResponse(GetPackageResponse packageResponse) {
        return (.bslash.div)Scalaz$.MODULE$.ToBindOps((Object)$bslash$div$.MODULE$.attempt((Function0 & Serializable)() -> {
            DamlLf.ArchivePayload payload = (DamlLf.ArchivePayload)com.daml.lf.archive.package$.MODULE$.ArchivePayloadParser().assertFromByteString(packageResponse.archivePayload());
            Tuple2 tuple2 = SignatureReader$.MODULE$.readPackageSignature((String)Ref$.MODULE$.PackageId().assertFromString(packageResponse.hash()), payload);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Errors errors = (Errors)tuple2._1();
            PackageSignature out = (PackageSignature)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)errors, (Object)out);
            Errors errors2 = (Errors)tuple22._1();
            PackageSignature out2 = (PackageSignature)tuple22._2();
            if (!Scalaz$.MODULE$.ToFoldableOps((Object)errors2, (Foldable)Errors$.MODULE$.Errors$u0020covariant()).empty()) {
                return new .minus.bslash.div((Object)new StringBuilder(27).append("Errors reading LF archive:\n").append(errors2.toString()).toString());
            }
            return new .bslash.div.minus((Object)out2);
        }, (Function1 & Serializable)x$10 -> x$10.getLocalizedMessage()), (Bind)$bslash$div$.MODULE$.DisjunctionInstances1()).join(Liskov$.MODULE$.refl());
    }

    private <A> Future<A> retryLoop(Function0<Future<A>> fa, ExecutionContext ec, LoggingContext lc) {
        return this.packageRetry(lc).apply((Function2 & Serializable)(x$11, x$12) -> LedgerReader$.$anonfun$retryLoop$1(fa, BoxesRunTime.unboxToInt((Object)x$11), x$12), ec);
    }

    private RetryStrategy packageRetry(LoggingContext lc) {
        return RetryStrategy$.MODULE$.constant((Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(250)).millis(), (PartialFunction)new Serializable(lc){
            private static final long serialVersionUID = 0L;
            private final LoggingContext lc$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Status> option;
                A1 A1 = x1;
                if (A1 != null && !(option = Grpc$StatusEnvelope$.MODULE$.unapply(A1)).isEmpty()) {
                    boolean retry;
                    Status status = (Status)option.get();
                    boolean bl = retry = Code.ABORTED.equals(Code.forNumber((int)status.getCode())) && status.getMessage().startsWith("THREADPOOL_OVERLOADED");
                    if (retry) {
                        LedgerReader$.MODULE$.com$daml$ledger$service$LedgerReader$$logger().trace().apply((Function0 & Serializable)() -> "package load failed with THREADPOOL_OVERLOADED; retrying", this.lc$4);
                    }
                    return (B1)BoxesRunTime.boxToBoolean((boolean)retry);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option<Status> option;
                Throwable throwable = x1;
                return throwable != null && !(option = Grpc$StatusEnvelope$.MODULE$.unapply(throwable)).isEmpty();
            }
            {
                this.lc$4 = lc$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
            }
        });
    }

    public Option<DefDataType<Type, Type>> damlLfTypeLookup(Function0<Map<String, PackageSignature>> packageStore, Ref.Identifier id) {
        Map store = (Map)packageStore.apply();
        return store.get((Object)id.packageId()).flatMap((Function1 & Serializable)packageSignature -> packageSignature.typeDecls().get((Object)id.qualifiedName()).map((Function1 & Serializable)x$13 -> x$13.type()).orElse((Function0 & Serializable)() -> packageSignature.interfaces().get((Object)id.qualifiedName()).flatMap((Function1 & Serializable)defInterface -> defInterface.viewType().flatMap((Function1 & Serializable)viewTypeId -> ((Option)PackageSignature$.MODULE$.resolveInterfaceViewType((PartialFunction)store).lift().apply(viewTypeId)).map((Function1 & Serializable)viewType -> new DefDataType((ImmArray.ImmArraySeq)ImmArray.ImmArraySeq$.MODULE$.apply((Seq)Nil$.MODULE$), (DataType)viewType))))));
    }

    public ContextualizedLogger com$daml$ledger$service$LedgerReader$$logger() {
        return com$daml$ledger$service$LedgerReader$$logger;
    }

    public static final /* synthetic */ Future $anonfun$retryLoop$1(Function0 fa$1, int x$11, Duration x$12) {
        return (Future)fa$1.apply();
    }

    private LedgerReader$() {
    }
}

