/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.participant.state.kvutils;

import com.daml.daml_lf_dev.DamlLf;
import com.daml.ledger.participant.state.kvutils.DamlKvutils;
import com.daml.ledger.participant.state.kvutils.committer.CommitContext;
import com.daml.ledger.participant.state.v1.Configuration;
import com.daml.ledger.participant.state.v1.TimeModel$;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.Time;
import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.UUID;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;

public final class TestHelpers$ {
    public static TestHelpers$ MODULE$;
    private final DamlLf.Archive badArchive;
    private final Time.Timestamp theRecordTime;
    private final Configuration theDefaultConfig;

    static {
        new TestHelpers$();
    }

    public String name(String value) {
        return (String)Ref$.MODULE$.Name().assertFromString(value);
    }

    public String party(String value) {
        return (String)Ref$.MODULE$.Party().assertFromString(value);
    }

    public DamlLf.Archive badArchive() {
        return this.badArchive;
    }

    public Time.Timestamp theRecordTime() {
        return this.theRecordTime;
    }

    public Configuration theDefaultConfig() {
        return this.theDefaultConfig;
    }

    public DamlKvutils.DamlLogEntryId mkEntryId(int n) {
        return DamlKvutils.DamlLogEntryId.newBuilder().setEntryId(ByteString.copyFromUtf8((String)Integer.toString(n))).build();
    }

    public String mkParticipantId(int n) {
        return (String)Ref$.MODULE$.ParticipantId().assertFromString(new StringBuilder(12).append("participant-").append(n).toString());
    }

    public String randomLedgerString() {
        return (String)Ref$.MODULE$.LedgerString().assertFromString(UUID.randomUUID().toString());
    }

    public CommitContext createCommitContext(Option<Time.Timestamp> recordTime, Map<DamlKvutils.DamlStateKey, Option<DamlKvutils.DamlStateValue>> inputs, int participantId) {
        return new CommitContext(inputs, recordTime, this.mkParticipantId(participantId));
    }

    public Map<DamlKvutils.DamlStateKey, Option<DamlKvutils.DamlStateValue>> createCommitContext$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public int createCommitContext$default$3() {
        return 0;
    }

    private TestHelpers$() {
        MODULE$ = this;
        this.badArchive = DamlLf.Archive.newBuilder().setHash("blablabla").build();
        this.theRecordTime = Time.Timestamp$.MODULE$.Epoch();
        this.theDefaultConfig = new Configuration(0L, TimeModel$.MODULE$.reasonableDefault(), Duration.ofDays(1L));
    }
}

