/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.participant.state.kvutils;

import com.codahale.metrics.MetricRegistry;
import com.daml.daml_lf_dev.DamlLf;
import com.daml.error.ValueSwitch;
import com.daml.ledger.api.DeduplicationPeriod;
import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.configuration.Configuration$;
import com.daml.ledger.configuration.LedgerTimeModel$;
import com.daml.ledger.participant.state.kvutils.Conversions$;
import com.daml.ledger.participant.state.kvutils.KVTestState;
import com.daml.ledger.participant.state.kvutils.KeyValueCommitting;
import com.daml.ledger.participant.state.kvutils.KeyValueCommitting$;
import com.daml.ledger.participant.state.kvutils.KeyValueConsumption$;
import com.daml.ledger.participant.state.kvutils.KeyValueSubmission;
import com.daml.ledger.participant.state.kvutils.SimplePackage;
import com.daml.ledger.participant.state.kvutils.TestHelpers$;
import com.daml.ledger.participant.state.kvutils.store.DamlLogEntry;
import com.daml.ledger.participant.state.kvutils.store.DamlLogEntryId;
import com.daml.ledger.participant.state.kvutils.store.DamlStateKey;
import com.daml.ledger.participant.state.kvutils.store.DamlStateValue;
import com.daml.ledger.participant.state.kvutils.wire.DamlSubmission;
import com.daml.ledger.participant.state.v2.SubmitterInfo;
import com.daml.ledger.participant.state.v2.TransactionMeta;
import com.daml.ledger.test.SimplePackagePartyTestDar$;
import com.daml.ledger.test.TestDar;
import com.daml.lf.command.ApiCommand;
import com.daml.lf.command.Commands;
import com.daml.lf.crypto.Hash;
import com.daml.lf.data.ImmArray$;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.Time;
import com.daml.lf.engine.Engine;
import com.daml.lf.engine.Engine$;
import com.daml.lf.language.Ast;
import com.daml.lf.transaction.Transaction;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scalaz.Applicative;
import scalaz.Functor;
import scalaz.IndexedStateT;
import scalaz.IndexedStateT$;
import scalaz.Leibniz$;
import scalaz.Monad;
import scalaz.package;
import scalaz.package$;
import scalaz.std.list$;

public final class KVTest$ {
    public static KVTest$ MODULE$;
    private final Duration MinMaxRecordTimeDelta;
    private final SimplePackage DefaultSimplePackage;
    private final Metrics metrics;
    private final ValueSwitch errorVersionSwitch;

    static {
        new KVTest$();
    }

    public <A> IndexedStateT<Object, KVTestState, KVTestState, A> KVReader(Function1<KVTestState, A> f) {
        return package.Reader$.MODULE$.apply(f).state((Monad)package$.MODULE$.idInstance());
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ValueSwitch errorVersionSwitch() {
        return this.errorVersionSwitch;
    }

    private KVTestState initialTestState() {
        Engine engine = Engine$.MODULE$.DevEngine();
        return new KVTestState(TestHelpers$.MODULE$.mkParticipantId(0), Time.Timestamp$.MODULE$.Epoch().addMicros(1000000L), TestHelpers$.MODULE$.theDefaultConfig(), 0, engine, new KeyValueSubmission(this.metrics()), new KeyValueCommitting(engine, this.metrics()), (Map<String, Ast.GenPackage<Ast.Expr>>)Predef$.MODULE$.Map().empty(), (Map<DamlStateKey, DamlStateValue>)Predef$.MODULE$.Map().empty());
    }

    public <A> IndexedStateT<Object, KVTestState, KVTestState, List<A>> sequentially(Seq<IndexedStateT<Object, KVTestState, KVTestState, A>> operations) {
        return (IndexedStateT)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps((Object)operations.toList(), list$.MODULE$.listInstance()).sequence(Leibniz$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.stateMonad());
    }

    public <A> IndexedStateT<Object, KVTestState, KVTestState, Seq<A>> inParallelReadOnly(Seq<IndexedStateT<Object, KVTestState, KVTestState, A>> operations) {
        return this.KVReader((Function1 & Serializable & scala.Serializable)state -> (Seq)operations.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.eval(state, (Monad)package$.MODULE$.idInstance()), Seq$.MODULE$.canBuildFrom()));
    }

    public <A> A runTest(IndexedStateT<Object, KVTestState, KVTestState, A> test) {
        return (A)test.eval((Object)this.initialTestState(), (Monad)package$.MODULE$.idInstance());
    }

    public <A> A runTestWithPackage(SimplePackage simplePackage, Seq<String> parties, IndexedStateT<?, KVTestState, KVTestState, A> test, LoggingContext loggingContext) {
        return (A)this.uploadArchive(simplePackage, loggingContext).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ((IndexedStateT)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps((Object)parties.toList(), list$.MODULE$.listInstance()).traverse((Function1 & Serializable & scala.Serializable)p -> MODULE$.allocateParty((String)p, (String)p, loggingContext), (Applicative)IndexedStateT$.MODULE$.stateMonad())).flatMap((Function1 & Serializable & scala.Serializable)_ -> test.map((Function1 & Serializable & scala.Serializable)r -> r, (Functor)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance()).eval((Object)this.initialTestState(), (Monad)package$.MODULE$.idInstance());
    }

    public <A> A runTestWithSimplePackage(Seq<String> parties, Function1<SimplePackage, IndexedStateT<?, KVTestState, KVTestState, A>> test, LoggingContext loggingContext) {
        return this.runTestWithPackage(this.DefaultSimplePackage, parties, (IndexedStateT)test.apply((Object)this.DefaultSimplePackage), loggingContext);
    }

    private IndexedStateT<Object, KVTestState, KVTestState, BoxedUnit> uploadArchive(SimplePackage simplePackage, LoggingContext loggingContext) {
        return this.submitArchives("simple-archive-submission", (Seq<DamlLf.Archive>)simplePackage.archives().values().toSeq(), loggingContext).map((Function1 & Serializable & scala.Serializable)x$2 -> (DamlLogEntry)x$2._2(), (Functor)package$.MODULE$.idInstance()).map((Function1 & Serializable & scala.Serializable)archiveLogEntry -> {
            DamlLogEntry.PayloadCase payloadCase = archiveLogEntry.getPayloadCase();
            DamlLogEntry.PayloadCase payloadCase2 = DamlLogEntry.PayloadCase.PACKAGE_UPLOAD_ENTRY;
            Predef$.MODULE$.assert(!(payloadCase != null ? !payloadCase.equals(payloadCase2) : payloadCase2 != null));
            BoxedUnit x$3 = BoxedUnit.UNIT;
            return new Tuple2(archiveLogEntry, (Object)x$3);
        }, (Functor)package$.MODULE$.idInstance()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            IndexedStateT indexedStateT = package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)state -> {
                Map x$1 = state.uploadedPackages().$plus$plus(simplePackage.packages());
                String x$2 = state.copy$default$1();
                Time.Timestamp x$3 = state.copy$default$2();
                Configuration x$4 = state.copy$default$3();
                int x$5 = state.copy$default$4();
                Engine x$6 = state.copy$default$5();
                KeyValueSubmission x$7 = state.copy$default$6();
                KeyValueCommitting x$8 = state.copy$default$7();
                Map<DamlStateKey, DamlStateValue> x$9 = state.copy$default$9();
                return state.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Map<String, Ast.GenPackage<Ast.Expr>>)x$1, x$9);
            }).map((Function1 & Serializable & scala.Serializable)_ -> {
                KVTest$.$anonfun$uploadArchive$5(_);
                return BoxedUnit.UNIT;
            }, (Functor)package$.MODULE$.idInstance());
            return indexedStateT;
        }, (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, DamlLogEntryId> freshEntryId() {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)s2 -> package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)s -> {
            int x$1 = s.nextEntryId() + 1;
            String x$2 = s.copy$default$1();
            Time.Timestamp x$3 = s.copy$default$2();
            Configuration x$4 = s.copy$default$3();
            Engine x$5 = s.copy$default$5();
            KeyValueSubmission x$6 = s.copy$default$6();
            KeyValueCommitting x$7 = s.copy$default$7();
            Map<String, Ast.GenPackage<Ast.Expr>> x$8 = s.copy$default$8();
            Map<DamlStateKey, DamlStateValue> x$9 = s.copy$default$9();
            return s.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9);
        }).map((Function1 & Serializable & scala.Serializable)_ -> TestHelpers$.MODULE$.mkEntryId(s2.nextEntryId()), (Functor)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, BoxedUnit> setParticipantId(String pid) {
        return package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)x$5 -> x$5.copy(pid, x$5.copy$default$2(), x$5.copy$default$3(), x$5.copy$default$4(), x$5.copy$default$5(), x$5.copy$default$6(), x$5.copy$default$7(), x$5.copy$default$8(), x$5.copy$default$9()));
    }

    public <A> IndexedStateT<Object, KVTestState, KVTestState, A> withParticipantId(String pid, IndexedStateT<?, KVTestState, KVTestState, A> test) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)oldState -> package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)x$6 -> x$6.copy(pid, x$6.copy$default$2(), x$6.copy$default$3(), x$6.copy$default$4(), x$6.copy$default$5(), x$6.copy$default$6(), x$6.copy$default$7(), x$6.copy$default$8(), x$6.copy$default$9())).flatMap((Function1 & Serializable & scala.Serializable)_ -> test.flatMap((Function1 & Serializable & scala.Serializable)x -> package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)x$7 -> x$7.copy(oldState.participantId(), x$7.copy$default$2(), x$7.copy$default$3(), x$7.copy$default$4(), x$7.copy$default$5(), x$7.copy$default$6(), x$7.copy$default$7(), x$7.copy$default$8(), x$7.copy$default$9())).map((Function1 & Serializable & scala.Serializable)_ -> x, (Functor)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Configuration> getDefaultConfiguration() {
        return package.State$.MODULE$.gets((Function1 & Serializable & scala.Serializable)x$8 -> x$8.defaultConfig());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, BoxedUnit> setDefaultConfiguration(Configuration config) {
        return package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)x$9 -> {
            Configuration x$1 = config;
            String x$2 = x$9.copy$default$1();
            Time.Timestamp x$3 = x$9.copy$default$2();
            int x$4 = x$9.copy$default$4();
            Engine x$5 = x$9.copy$default$5();
            KeyValueSubmission x$6 = x$9.copy$default$6();
            KeyValueCommitting x$7 = x$9.copy$default$7();
            Map<String, Ast.GenPackage<Ast.Expr>> x$8 = x$9.copy$default$8();
            Map<DamlStateKey, DamlStateValue> x$92 = x$9.copy$default$9();
            return x$9.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$92);
        });
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Configuration> getConfiguration() {
        return this.getDamlState(Conversions$.MODULE$.configurationStateKey()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IndexedStateT indexedStateT;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                indexedStateT = MODULE$.getDefaultConfiguration();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                DamlStateValue v = (DamlStateValue)some.value();
                indexedStateT = package.State$.MODULE$.state(Configuration$.MODULE$.decode(v.getConfigurationEntry().getConfiguration()).toOption().get());
            } else {
                throw new MatchError((Object)option);
            }
            return indexedStateT;
        }, (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Time.Timestamp> currentRecordTime() {
        return package.State$.MODULE$.get().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.recordTime(), (Functor)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, BoxedUnit> setRecordTime(Time.Timestamp rt) {
        return package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)x$11 -> {
            Time.Timestamp x$1 = rt;
            String x$2 = x$11.copy$default$1();
            Configuration x$3 = x$11.copy$default$3();
            int x$4 = x$11.copy$default$4();
            Engine x$5 = x$11.copy$default$5();
            KeyValueSubmission x$6 = x$11.copy$default$6();
            KeyValueCommitting x$7 = x$11.copy$default$7();
            Map<String, Ast.GenPackage<Ast.Expr>> x$8 = x$11.copy$default$8();
            Map<DamlStateKey, DamlStateValue> x$9 = x$11.copy$default$9();
            return x$11.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
        });
    }

    public IndexedStateT<Object, KVTestState, KVTestState, BoxedUnit> advanceRecordTime(long micros) {
        return package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)s -> {
            Time.Timestamp x$1 = s.recordTime().addMicros(micros);
            String x$2 = s.copy$default$1();
            Configuration x$3 = s.copy$default$3();
            int x$4 = s.copy$default$4();
            Engine x$5 = s.copy$default$5();
            KeyValueSubmission x$6 = s.copy$default$6();
            KeyValueCommitting x$7 = s.copy$default$7();
            Map<String, Ast.GenPackage<Ast.Expr>> x$8 = s.copy$default$8();
            Map<DamlStateKey, DamlStateValue> x$9 = s.copy$default$9();
            return s.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
        });
    }

    public IndexedStateT<Object, KVTestState, KVTestState, BoxedUnit> addDamlState(Map<DamlStateKey, DamlStateValue> newState) {
        return package.State$.MODULE$.modify((Function1 & Serializable & scala.Serializable)s -> {
            Map x$1 = s.damlState().$plus$plus((GenTraversableOnce)newState);
            String x$2 = s.copy$default$1();
            Time.Timestamp x$3 = s.copy$default$2();
            Configuration x$4 = s.copy$default$3();
            int x$5 = s.copy$default$4();
            Engine x$6 = s.copy$default$5();
            KeyValueSubmission x$7 = s.copy$default$6();
            KeyValueCommitting x$8 = s.copy$default$7();
            Map<String, Ast.GenPackage<Ast.Expr>> x$9 = s.copy$default$8();
            return s.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Map<DamlStateKey, DamlStateValue>)x$1);
        });
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Option<DamlStateValue>> getDamlState(DamlStateKey key) {
        return package.State$.MODULE$.gets((Function1 & Serializable & scala.Serializable)s -> s.damlState().get((Object)key));
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Tuple2<DamlLogEntryId, DamlLogEntry>> submitArchives(String submissionId, Seq<DamlLf.Archive> archives, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.submit(MODULE$.createArchiveSubmission(submissionId, (KVTestState)testState, archives), loggingContext), (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Tuple2<DamlLogEntryId, KeyValueCommitting.PreExecutionResult>> preExecuteArchives(String submissionId, Seq<DamlLf.Archive> archives, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.preExecute(MODULE$.createArchiveSubmission(submissionId, (KVTestState)testState, archives), loggingContext), (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Tuple2<VersionedTransaction, Transaction.Metadata>> runCommand(String submitter, Hash submissionSeed, ApiCommand command) {
        return this.KVReader((Function1 & Serializable & scala.Serializable)state -> (Tuple2)state.engine().submit((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{submitter})), Predef$.MODULE$.Set().empty(), new Commands(ImmArray$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ApiCommand[]{command})), state.recordTime(), "cmds-ref"), state.participantId(), submissionSeed).consume((Function1 & Serializable & scala.Serializable)contractId -> state.damlState().get((Object)Conversions$.MODULE$.contractIdToStateKey(contractId)).map((Function1 & Serializable & scala.Serializable)v -> Conversions$.MODULE$.decodeContractInstance(v.getContractState().getContractInstance())), (Function1 & Serializable & scala.Serializable)key -> state.uploadedPackages().get(key), (Function1 & Serializable & scala.Serializable)globalKey -> state.damlState().get((Object)Conversions$.MODULE$.globalKeyToStateKey(globalKey.globalKey())).map((Function1 & Serializable & scala.Serializable)value -> Conversions$.MODULE$.decodeContractId(value.getContractKeyState().getContractId()))).fold((Function1 & Serializable & scala.Serializable)error -> {
            throw new RuntimeException(error.message());
        }, (Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x)));
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Tuple2<VersionedTransaction, Transaction.Metadata>> runSimpleCommand(String submitter, Hash submissionSeed, ApiCommand command) {
        return this.runCommand(submitter, submissionSeed, command);
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Tuple2<DamlLogEntryId, DamlLogEntry>> submitTransaction(String submitter, Tuple2<VersionedTransaction, Transaction.Metadata> transaction, Hash submissionSeed, Duration letDelta, String commandId, Duration deduplicationDuration, LoggingContext loggingContext) {
        return this.prepareTransactionSubmission(submitter, transaction, submissionSeed, letDelta, commandId, deduplicationDuration).flatMap((Function1 & Serializable & scala.Serializable)submission -> MODULE$.submit((DamlSubmission)submission, loggingContext), (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Tuple2<DamlLogEntryId, KeyValueCommitting.PreExecutionResult>> preExecuteTransaction(String submitter, Tuple2<VersionedTransaction, Transaction.Metadata> transaction, Hash submissionSeed, Duration letDelta, String commandId, Duration deduplicationDuration, LoggingContext loggingContext) {
        return this.prepareTransactionSubmission(submitter, transaction, submissionSeed, letDelta, commandId, deduplicationDuration).flatMap((Function1 & Serializable & scala.Serializable)damlSubmission -> MODULE$.preExecute((DamlSubmission)damlSubmission, loggingContext), (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, DamlSubmission> prepareTransactionSubmission(String submitter, Tuple2<VersionedTransaction, Transaction.Metadata> transaction, Hash submissionSeed, Duration letDelta, String commandId, Duration deduplicationDuration) {
        return this.KVReader((Function1 & Serializable & scala.Serializable)testState -> {
            Tuple2 tuple2 = transaction;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            VersionedTransaction tx = (VersionedTransaction)tuple2._1();
            Transaction.Metadata txMetaData = (Transaction.Metadata)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)tx, (Object)txMetaData);
            Tuple2 tuple23 = tuple22;
            VersionedTransaction tx2 = (VersionedTransaction)tuple23._1();
            Transaction.Metadata txMetaData2 = (Transaction.Metadata)tuple23._2();
            SubmitterInfo submitterInfo = MODULE$.createSubmitterInfo(submitter, commandId, deduplicationDuration);
            return testState.keyValueSubmission().transactionToSubmission(submitterInfo, new TransactionMeta(testState.recordTime().addMicros(letDelta.toNanos() / 1000L), (Option)None$.MODULE$, txMetaData2.submissionTime(), submissionSeed, (Option)new Some((Object)txMetaData2.usedPackages()), (Option)None$.MODULE$, (Option)None$.MODULE$), tx2);
        });
    }

    public Duration prepareTransactionSubmission$default$4() {
        return Duration.ZERO;
    }

    public String prepareTransactionSubmission$default$5() {
        return TestHelpers$.MODULE$.randomLedgerString();
    }

    public Duration prepareTransactionSubmission$default$6() {
        return Duration.ofDays(1L);
    }

    public IndexedStateT<Object, KVTestState, KVTestState, DamlLogEntry> submitConfig(Function1<Configuration, Configuration> configModify, String submissionId, Duration minMaxRecordTimeDelta, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.getConfiguration().flatMap((Function1 & Serializable & scala.Serializable)oldConf -> MODULE$.submit(MODULE$.createConfigurationSubmission(configModify, submissionId, minMaxRecordTimeDelta, (KVTestState)testState, (Configuration)oldConf), loggingContext).map((Function1 & Serializable & scala.Serializable)result -> (DamlLogEntry)result._2(), (Functor)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, KeyValueCommitting.PreExecutionResult> preExecuteConfig(Function1<Configuration, Configuration> configModify, String submissionId, Duration minMaxRecordTimeDelta, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.getConfiguration().flatMap((Function1 & Serializable & scala.Serializable)oldConf -> MODULE$.preExecute(MODULE$.createConfigurationSubmission(configModify, submissionId, minMaxRecordTimeDelta, (KVTestState)testState, (Configuration)oldConf), loggingContext).map((Function1 & Serializable & scala.Serializable)result -> (KeyValueCommitting.PreExecutionResult)result._2(), (Functor)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, DamlLogEntry> submitPartyAllocation(String subId, String hint, String participantId, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.submit(MODULE$.createPartySubmission(subId, hint, participantId, (KVTestState)testState), loggingContext), (Monad)package$.MODULE$.idInstance()).map((Function1 & Serializable & scala.Serializable)x$13 -> (DamlLogEntry)x$13._2(), (Functor)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, KeyValueCommitting.PreExecutionResult> preExecutePartyAllocation(String subId, String hint, String participantId, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.preExecute(MODULE$.createPartySubmission(subId, hint, participantId, (KVTestState)testState), loggingContext), (Monad)package$.MODULE$.idInstance()).map((Function1 & Serializable & scala.Serializable)x$14 -> (KeyValueCommitting.PreExecutionResult)x$14._2(), (Functor)package$.MODULE$.idInstance());
    }

    public IndexedStateT<Object, KVTestState, KVTestState, String> allocateParty(String subId, String hint, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.submitPartyAllocation(subId, hint, testState.participantId(), loggingContext).map((Function1 & Serializable & scala.Serializable)logEntry -> {
            DamlLogEntry.PayloadCase payloadCase = logEntry.getPayloadCase();
            DamlLogEntry.PayloadCase payloadCase2 = DamlLogEntry.PayloadCase.PARTY_ALLOCATION_ENTRY;
            Predef$.MODULE$.assert(!(payloadCase != null ? !payloadCase.equals(payloadCase2) : payloadCase2 != null));
            return (String)Ref$.MODULE$.Party().assertFromString(logEntry.getPartyAllocationEntry().getParty());
        }, (Functor)package$.MODULE$.idInstance()).map((Function1 & Serializable & scala.Serializable)result -> result, (Functor)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance());
    }

    private IndexedStateT<Object, KVTestState, KVTestState, Tuple2<DamlLogEntryId, DamlLogEntry>> submit(DamlSubmission submission, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.freshEntryId().map((Function1 & Serializable & scala.Serializable)entryId -> {
            Tuple2 tuple2 = testState.keyValueCommitting().processSubmission(entryId, testState.recordTime(), testState.defaultConfig(), submission, testState.participantId(), ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(submission.getInputDamlStateList()).asScala()).map((Function1 & Serializable & scala.Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)testState.damlState().get(key)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), loggingContext);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DamlLogEntry logEntry = (DamlLogEntry)tuple2._1();
            Map newState = (Map)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)logEntry, (Object)newState);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$15 = (Tuple2)tuple32._1();
            DamlLogEntry logEntry2 = (DamlLogEntry)tuple32._2();
            Map newState2 = (Map)tuple32._3();
            return new Tuple2(entryId, (Object)x$15);
        }, (Functor)package$.MODULE$.idInstance()).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple2 tuple2;
            DamlLogEntryId entryId;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x$17;
                    if (tuple22 == null) break block2;
                    entryId = (DamlLogEntryId)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            DamlLogEntry logEntry = (DamlLogEntry)tuple2._1();
            Map newState = (Map)tuple2._2();
            IndexedStateT indexedStateT = MODULE$.addDamlState((Map<DamlStateKey, DamlStateValue>)newState).map((Function1 & Serializable & scala.Serializable)_ -> {
                Predef$.MODULE$.assert(newState.keySet().subsetOf((GenSet)KeyValueCommitting$.MODULE$.submissionOutputs(submission)));
                List _2 = KeyValueConsumption$.MODULE$.logEntryToUpdate(entryId, logEntry, MODULE$.errorVersionSwitch(), KeyValueConsumption$.MODULE$.logEntryToUpdate$default$4(), loggingContext);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entryId), (Object)logEntry);
            }, (Functor)package$.MODULE$.idInstance());
            return indexedStateT;
        }, (Monad)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance());
    }

    public Duration submitTransaction$default$4() {
        return Duration.ZERO;
    }

    public String submitTransaction$default$5() {
        return TestHelpers$.MODULE$.randomLedgerString();
    }

    public Duration submitTransaction$default$6() {
        return Duration.ofDays(1L);
    }

    public String submitConfig$default$2() {
        return TestHelpers$.MODULE$.randomLedgerString();
    }

    public Duration submitConfig$default$3() {
        return this.MinMaxRecordTimeDelta;
    }

    public IndexedStateT<Object, KVTestState, KVTestState, Tuple2<DamlLogEntryId, KeyValueCommitting.PreExecutionResult>> preExecute(DamlSubmission damlSubmission, LoggingContext loggingContext) {
        return package.State$.MODULE$.get().flatMap((Function1 & Serializable & scala.Serializable)testState -> MODULE$.freshEntryId().map((Function1 & Serializable & scala.Serializable)entryId -> {
            Buffer inputKeys = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(damlSubmission.getInputDamlStateList()).asScala();
            return new Tuple2(entryId, (Object)inputKeys);
        }, (Functor)package$.MODULE$.idInstance()).flatMap((Function1 & Serializable & scala.Serializable)x$21 -> {
            Tuple2 tuple2 = x$21;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DamlLogEntryId entryId = (DamlLogEntryId)tuple2._1();
            Buffer inputKeys = (Buffer)tuple2._2();
            IndexedStateT indexedStateT = MODULE$.createInputState((Seq<DamlStateKey>)inputKeys).map((Function1 & Serializable & scala.Serializable)inputState -> {
                KeyValueCommitting.PreExecutionResult preExecutionResult = testState.keyValueCommitting().preExecuteSubmission(testState.defaultConfig(), damlSubmission, testState.participantId(), inputState, loggingContext);
                KeyValueCommitting.PreExecutionResult preExecutionResult2 = preExecutionResult;
                if (preExecutionResult2 == null) {
                    throw new MatchError((Object)preExecutionResult2);
                }
                Set readSet = preExecutionResult2.readSet();
                DamlLogEntry successfulLogEntry = preExecutionResult2.successfulLogEntry();
                Map newState = preExecutionResult2.stateUpdates();
                DamlLogEntry outOfTimeBoundsLogEntry = preExecutionResult2.outOfTimeBoundsLogEntry();
                Tuple5 tuple5 = new Tuple5((Object)preExecutionResult2, (Object)readSet, (Object)successfulLogEntry, (Object)newState, (Object)outOfTimeBoundsLogEntry);
                Tuple5 tuple52 = tuple5;
                KeyValueCommitting.PreExecutionResult x$18 = (KeyValueCommitting.PreExecutionResult)tuple52._1();
                Set readSet2 = (Set)tuple52._2();
                DamlLogEntry successfulLogEntry2 = (DamlLogEntry)tuple52._3();
                Map newState2 = (Map)tuple52._4();
                DamlLogEntry outOfTimeBoundsLogEntry2 = (DamlLogEntry)tuple52._5();
                return new Tuple3(inputState, (Object)preExecutionResult, (Object)x$18);
            }, (Functor)package$.MODULE$.idInstance()).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
                KeyValueCommitting.PreExecutionResult preExecutionResult;
                KeyValueCommitting.PreExecutionResult preExecutionResult2;
                block3: {
                    Tuple3 tuple3;
                    block2: {
                        tuple3 = x$20;
                        if (tuple3 == null) break block2;
                        preExecutionResult2 = (KeyValueCommitting.PreExecutionResult)tuple3._2();
                        preExecutionResult = (KeyValueCommitting.PreExecutionResult)tuple3._3();
                        if (preExecutionResult != null) break block3;
                    }
                    throw new MatchError((Object)tuple3);
                }
                Set readSet = preExecutionResult.readSet();
                DamlLogEntry successfulLogEntry = preExecutionResult.successfulLogEntry();
                Map newState = preExecutionResult.stateUpdates();
                DamlLogEntry outOfTimeBoundsLogEntry = preExecutionResult.outOfTimeBoundsLogEntry();
                IndexedStateT indexedStateT = MODULE$.addDamlState((Map<DamlStateKey, DamlStateValue>)newState).map((Function1 & Serializable & scala.Serializable)_ -> {
                    Predef$.MODULE$.assert(readSet.subsetOf((GenSet)inputKeys.toSet()));
                    KeyValueConsumption$.MODULE$.logEntryToUpdate(entryId, successfulLogEntry, MODULE$.errorVersionSwitch(), MODULE$.recordTimeFromTimeUpdateLogEntry(), loggingContext);
                    KeyValueConsumption$.MODULE$.logEntryToUpdate(entryId, outOfTimeBoundsLogEntry, MODULE$.errorVersionSwitch(), MODULE$.recordTimeFromTimeUpdateLogEntry(), loggingContext);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entryId), (Object)preExecutionResult2);
                }, (Functor)package$.MODULE$.idInstance());
                return indexedStateT;
            }, (Monad)package$.MODULE$.idInstance());
            return indexedStateT;
        }, (Monad)package$.MODULE$.idInstance()), (Monad)package$.MODULE$.idInstance());
    }

    public Duration preExecuteTransaction$default$4() {
        return Duration.ZERO;
    }

    public String preExecuteTransaction$default$5() {
        return TestHelpers$.MODULE$.randomLedgerString();
    }

    public Duration preExecuteTransaction$default$6() {
        return Duration.ofDays(1L);
    }

    public String preExecuteConfig$default$2() {
        return TestHelpers$.MODULE$.randomLedgerString();
    }

    public Duration preExecuteConfig$default$3() {
        return this.MinMaxRecordTimeDelta;
    }

    private IndexedStateT<Object, KVTestState, KVTestState, Map<DamlStateKey, Option<DamlStateValue>>> createInputState(Seq<DamlStateKey> inputKeys) {
        return this.KVReader((Function1 & Serializable & scala.Serializable)state -> ((TraversableOnce)inputKeys.view().map((Function1 & Serializable & scala.Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)state.damlState().get(key)), SeqView$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private SubmitterInfo createSubmitterInfo(String submitter, String commandId, Duration deduplicationDuration) {
        return new SubmitterInfo((List)new .colon.colon((Object)submitter, (List)Nil$.MODULE$), (String)Ref$.MODULE$.LedgerString().assertFromString("test"), commandId, (DeduplicationPeriod)new DeduplicationPeriod.DeduplicationDuration(deduplicationDuration), (Option)None$.MODULE$, new Configuration(1L, LedgerTimeModel$.MODULE$.reasonableDefault(), Duration.ofSeconds(1L)));
    }

    private DamlSubmission createPartySubmission(String subId, String hint, String participantId, KVTestState testState) {
        return testState.keyValueSubmission().partyToSubmission((String)Ref$.MODULE$.LedgerString().assertFromString(subId), (Option)new Some((Object)hint), (Option)None$.MODULE$, participantId);
    }

    private DamlSubmission createConfigurationSubmission(Function1<Configuration, Configuration> configModify, String submissionId, Duration minMaxRecordTimeDelta, KVTestState testState, Configuration oldConf) {
        return testState.keyValueSubmission().configurationToSubmission(testState.recordTime().addMicros(minMaxRecordTimeDelta.toNanos() / 1000L), submissionId, testState.participantId(), (Configuration)configModify.apply((Object)oldConf));
    }

    private DamlSubmission createArchiveSubmission(String submissionId, KVTestState testState, Seq<DamlLf.Archive> archives) {
        return testState.keyValueSubmission().archivesToSubmission(submissionId, archives.toList(), "description", testState.participantId());
    }

    private Option<Time.Timestamp> recordTimeFromTimeUpdateLogEntry() {
        return new Some((Object)Time.Timestamp$.MODULE$.now());
    }

    public static final /* synthetic */ void $anonfun$uploadArchive$5(BoxedUnit _) {
    }

    private KVTest$() {
        MODULE$ = this;
        this.MinMaxRecordTimeDelta = Duration.ofSeconds(1L);
        this.DefaultSimplePackage = new SimplePackage((TestDar)SimplePackagePartyTestDar$.MODULE$);
        this.metrics = new Metrics(new MetricRegistry());
        this.errorVersionSwitch = new ValueSwitch(true);
    }
}

