/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.participant.state.kvutils;

import com.daml.daml_lf_dev.DamlLf;
import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.configuration.LedgerTimeModel$;
import com.daml.ledger.participant.state.kvutils.Conversions$;
import com.daml.ledger.participant.state.kvutils.committer.CommitContext;
import com.daml.ledger.participant.state.kvutils.committer.StepResult;
import com.daml.ledger.participant.state.kvutils.committer.StepStop;
import com.daml.ledger.participant.state.kvutils.committer.transaction.DamlTransactionEntrySummary;
import com.daml.ledger.participant.state.kvutils.store.DamlLogEntryId;
import com.daml.ledger.participant.state.kvutils.store.DamlStateKey;
import com.daml.ledger.participant.state.kvutils.store.DamlStateValue;
import com.daml.ledger.participant.state.kvutils.store.events.DamlSubmitterInfo;
import com.daml.ledger.participant.state.kvutils.store.events.DamlTransactionEntry;
import com.daml.ledger.participant.state.kvutils.store.events.DamlTransactionRejectionEntry;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.Time;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.lf.transaction.test.TransactionBuilder$;
import com.daml.lf.value.Value;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.time.Duration;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;

public final class TestHelpers$ {
    public static TestHelpers$ MODULE$;
    private final DamlLf.Archive badArchive;
    private final Time.Timestamp theRecordTime;
    private final Configuration theDefaultConfig;

    static {
        new TestHelpers$();
    }

    public String name(String value) {
        return (String)Ref$.MODULE$.Name().assertFromString(value);
    }

    public String party(String value) {
        return (String)Ref$.MODULE$.Party().assertFromString(value);
    }

    public DamlLf.Archive badArchive() {
        return this.badArchive;
    }

    public Time.Timestamp theRecordTime() {
        return this.theRecordTime;
    }

    public Configuration theDefaultConfig() {
        return this.theDefaultConfig;
    }

    public DamlLogEntryId mkEntryId(int n) {
        return DamlLogEntryId.newBuilder().setEntryId(ByteString.copyFromUtf8((String)Integer.toString(n))).build();
    }

    public String mkParticipantId(int n) {
        return (String)Ref$.MODULE$.ParticipantId().assertFromString(new StringBuilder(12).append("participant-").append(n).toString());
    }

    public String randomLedgerString() {
        return (String)Ref$.MODULE$.LedgerString().assertFromString(UUID.randomUUID().toString());
    }

    public CommitContext createCommitContext(Option<Time.Timestamp> recordTime, Map<DamlStateKey, Option<DamlStateValue>> inputs, int participantId) {
        return new CommitContext(inputs, recordTime, this.mkParticipantId(participantId));
    }

    public Map<DamlStateKey, Option<DamlStateValue>> createCommitContext$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public int createCommitContext$default$3() {
        return 0;
    }

    public DamlTransactionEntry createEmptyTransactionEntry(List<String> submitters) {
        return this.createTransactionEntry(submitters, TransactionBuilder$.MODULE$.EmptySubmitted());
    }

    public DamlTransactionEntry createTransactionEntry(List<String> submitters, VersionedTransaction tx) {
        return DamlTransactionEntry.newBuilder().setTransaction(Conversions$.MODULE$.encodeTransaction(tx)).setSubmitterInfo(DamlSubmitterInfo.newBuilder().setCommandId("commandId").addAllSubmitters((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter(submitters).asJava())).setSubmissionSeed(ByteString.copyFromUtf8((String)new StringOps(Predef$.MODULE$.augmentString("a")).$times(32))).build();
    }

    public DamlTransactionRejectionEntry getTransactionRejectionReason(StepResult<DamlTransactionEntrySummary> result) {
        return ((StepStop)result).logEntry().getTransactionRejectionEntry();
    }

    public Value lfTuple(Seq<String> values) {
        return TransactionBuilder$.MODULE$.record((Seq)((TraversableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String v = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append("_").append(i).toString()), (Object)v);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private TestHelpers$() {
        MODULE$ = this;
        this.badArchive = DamlLf.Archive.newBuilder().setHash("blablabla").build();
        this.theRecordTime = Time.Timestamp$.MODULE$.Epoch();
        this.theDefaultConfig = new Configuration(0L, LedgerTimeModel$.MODULE$.reasonableDefault(), Duration.ofDays(1L));
    }
}

