/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import com.auth0.jwt.interfaces.JWTVerifier;
import com.daml.jwt.JwtVerifierBase;
import com.daml.jwt.domain.Jwt;
import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.AuthServiceJWT$;
import com.daml.ledger.api.auth.AuthServiceJWTCodec$JsonImplicits$AuthServiceJWTPayloadFormat$;
import com.daml.ledger.api.auth.AuthServiceJWTPayload;
import com.daml.ledger.api.auth.Claim;
import com.daml.ledger.api.auth.ClaimActAsParty;
import com.daml.ledger.api.auth.ClaimAdmin$;
import com.daml.ledger.api.auth.ClaimPublic$;
import com.daml.ledger.api.auth.ClaimReadAsParty;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.ClaimSet$Unauthenticated$;
import com.daml.ledger.api.auth.CustomDamlJWTPayload;
import com.daml.ledger.api.auth.StandardJWTPayload;
import com.daml.lf.data.Ref$;
import io.grpc.Metadata;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Try$;
import scala.util.matching.Regex;
import spray.json.JsonParser$;
import spray.json.JsonReader;
import spray.json.ParserInput;
import spray.json.ParserInput$;

@ScalaSignature(bytes="\u0006\u0005\tMb\u0001\u0002\u0014(\u0001IB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0011\u0002\u0011\r\u0011\"\u0005J\u0011\u0019\u0011\u0006\u0001)A\u0005\u0015\")1\u000b\u0001C!)\"1A\u000e\u0001Q\u0005\n5Da! \u0001!\n\u0013q\b\u0002CA\u0002\u0001\u0001&I!!\u0002\t\u0011\t\r\u0002\u0001)C\u0005\u0005KA\u0001B!\u000b\u0001A\u0013%!1F\u0004\b\u0003c9\u0003\u0012AA\u001a\r\u00191s\u0005#\u0001\u00026!1A\t\u0004C\u0001\u0003o1a!!\u000f\r\u0005\u0006m\u0002BCA%\u001d\tU\r\u0011\"\u0001\u0002L!I\u0011Q\n\b\u0003\u0012\u0003\u0006I!\u001d\u0005\u0007\t:!\t!a\u0014\t\u0013\u0005]c\"!A\u0005\u0002\u0005e\u0003\"CA/\u001dE\u0005I\u0011AA0\u0011%\t)HDA\u0001\n\u0003\n9\bC\u0005\u0002\u0004:\t\t\u0011\"\u0001\u0002\u0006\"I\u0011Q\u0012\b\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u00037s\u0011\u0011!C!\u0003;C\u0011\"a+\u000f\u0003\u0003%\t!!,\t\u0013\u0005]f\"!A\u0005B\u0005e\u0006\"CA_\u001d\u0005\u0005I\u0011IA`\u0011%\t\tMDA\u0001\n\u0003\n\u0019\rC\u0005\u0002F:\t\t\u0011\"\u0011\u0002H\u001eI\u00111\u001a\u0007\u0002\u0002#\u0005\u0011Q\u001a\u0004\n\u0003sa\u0011\u0011!E\u0001\u0003\u001fDa\u0001\u0012\u0010\u0005\u0002\u0005\u0015\b\"CAa=\u0005\u0005IQIAb\u0011%\t9OHA\u0001\n\u0003\u000bI\u000fC\u0005\u0002nz\t\t\u0011\"!\u0002p\"I\u0011Q\u001f\u0010\u0002\u0002\u0013%\u0011q\u001f\u0005\b\u0003OdA\u0011AA\u0000\u0011\u001d\t9\u000f\u0004C\u0001\u0005+\u0011a\"Q;uQN+'O^5dK*;FK\u0003\u0002)S\u0005!\u0011-\u001e;i\u0015\tQ3&A\u0002ba&T!\u0001L\u0017\u0002\r1,GmZ3s\u0015\tqs&\u0001\u0003eC6d'\"\u0001\u0019\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VM\u001a\t\u0003umj\u0011aJ\u0005\u0003y\u001d\u00121\"Q;uQN+'O^5dK\u0006Aa/\u001a:jM&,'\u000f\u0005\u0002@\u00056\t\u0001I\u0003\u0002B[\u0005\u0019!n\u001e;\n\u0005\r\u0003%a\u0004&xiZ+'/\u001b4jKJ\u0014\u0015m]3\u0002\rqJg.\u001b;?)\t1u\t\u0005\u0002;\u0001!)QH\u0001a\u0001}\u00051An\\4hKJ,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bQa\u001d7gi)T\u0011aT\u0001\u0004_J<\u0017BA)M\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013A\u00043fG>$W-T3uC\u0012\fG/\u0019\u000b\u0003+\n\u00042AV/`\u001b\u00059&B\u0001-Z\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u00035n\u000bA!\u001e;jY*\tA,\u0001\u0003kCZ\f\u0017B\u00010X\u0005=\u0019u.\u001c9mKRLwN\\*uC\u001e,\u0007C\u0001\u001ea\u0013\t\twE\u0001\u0005DY\u0006LWnU3u\u0011\u0015\u0019W\u00011\u0001e\u0003\u001dAW-\u00193feN\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\t\u001d\u0014\bo\u0019\u0006\u0002S\u0006\u0011\u0011n\\\u0005\u0003W\u001a\u0014\u0001\"T3uC\u0012\fG/Y\u0001\u0017O\u0016$\u0018)\u001e;i_JL'0\u0019;j_:DU-\u00193feR\u0011a\u000e \t\u0004i=\f\u0018B\u000196\u0005\u0019y\u0005\u000f^5p]B\u0011!/\u001f\b\u0003g^\u0004\"\u0001^\u001b\u000e\u0003UT!A^\u0019\u0002\rq\u0012xn\u001c;?\u0013\tAX'\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=6\u0011\u0015\u0019g\u00011\u0001e\u0003-\u0001\u0018M]:f\u0011\u0016\fG-\u001a:\u0015\u0005}{\bBBA\u0001\u000f\u0001\u0007\u0011/\u0001\u0004iK\u0006$WM]\u0001\ra\u0006\u00148/\u001a)bs2|\u0017\r\u001a\u000b\u0005\u0003\u000f\u0011y\u0002\u0005\u0005\u0002\n\u0005M\u0011\u0011\u0004B\r\u001d\u0011\tY!a\u0004\u000f\u0007Q\fi!C\u00017\u0013\r\t\t\"N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)\"a\u0006\u0003\r\u0015KG\u000f[3s\u0015\r\t\t\"\u000e\t\u0004\u00037qabAA\u000f\u00179!\u0011qDA\u0018\u001d\u0011\t\t#!\f\u000f\t\u0005\r\u00121\u0006\b\u0005\u0003K\tICD\u0002u\u0003OI\u0011\u0001M\u0005\u0003]=J!\u0001L\u0017\n\u0005)Z\u0013B\u0001\u0015*\u00039\tU\u000f\u001e5TKJ4\u0018nY3K/R\u0003\"A\u000f\u0007\u0014\u00051\u0019DCAA\u001a\u0005\u0015)%O]8s'\u0019q1'!\u0010\u0002DA\u0019A'a\u0010\n\u0007\u0005\u0005SGA\u0004Qe>$Wo\u0019;\u0011\t\u0005%\u0011QI\u0005\u0005\u0003\u000f\n9B\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004nKN\u001c\u0018mZ3\u0016\u0003E\f\u0001\"\\3tg\u0006<W\r\t\u000b\u0005\u0003#\n)\u0006E\u0002\u0002T9i\u0011\u0001\u0004\u0005\u0007\u0003\u0013\n\u0002\u0019A9\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003#\nY\u0006\u0003\u0005\u0002JI\u0001\n\u00111\u0001r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0019+\u0007E\f\u0019g\u000b\u0002\u0002fA!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014!C;oG\",7m[3e\u0015\r\ty'N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA:\u0003S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0010\t\u0005\u0003w\n\t)\u0004\u0002\u0002~)\u0019\u0011qP.\u0002\t1\fgnZ\u0005\u0004u\u0006u\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAAD!\r!\u0014\u0011R\u0005\u0004\u0003\u0017+$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAI\u0003/\u00032\u0001NAJ\u0013\r\t)*\u000e\u0002\u0004\u0003:L\b\"CAM-\u0005\u0005\t\u0019AAD\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0014\t\u0007\u0003C\u000b9+!%\u000e\u0005\u0005\r&bAASk\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00161\u0015\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00020\u0006U\u0006c\u0001\u001b\u00022&\u0019\u00111W\u001b\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u0014\r\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002z\u0005m\u0006\"CAM3\u0005\u0005\t\u0019AAD\u0003!A\u0017m\u001d5D_\u0012,GCAAD\u0003!!xn\u0015;sS:<GCAA=\u0003\u0019)\u0017/^1mgR!\u0011qVAe\u0011%\tI\nHA\u0001\u0002\u0004\t\t*A\u0003FeJ|'\u000fE\u0002\u0002Ty\u0019RAHAi\u0003;\u0004r!a5\u0002ZF\f\t&\u0004\u0002\u0002V*\u0019\u0011q[\u001b\u0002\u000fI,h\u000e^5nK&!\u00111\\Ak\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003?\f\u0019/\u0004\u0002\u0002b*\u0011\u0011nW\u0005\u0005\u0003\u000f\n\t\u000f\u0006\u0002\u0002N\u0006)\u0011\r\u001d9msR!\u0011\u0011KAv\u0011\u0019\tI%\ta\u0001c\u00069QO\\1qa2LHc\u00018\u0002r\"I\u00111\u001f\u0012\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA}!\u0011\tY(a?\n\t\u0005u\u0018Q\u0010\u0002\u0007\u001f\nTWm\u0019;\u0015\u0007\u0019\u0013\t\u0001\u0003\u0004>I\u0001\u0007!1\u0001\t\u0005\u0005\u000b\u0011\t\"\u0004\u0002\u0003\b)!!\u0011\u0002B\u0006\u0003)Ig\u000e^3sM\u0006\u001cWm\u001d\u0006\u0004\u0003\n5!b\u0001B\b_\u0005)\u0011-\u001e;ia%!!1\u0003B\u0004\u0005-Qu\u000b\u0016,fe&4\u0017.\u001a:\u0015\u0007\u0019\u00139\u0002C\u0003>K\u0001\u0007a\bE\u0002;\u00057I1A!\b(\u0005U\tU\u000f\u001e5TKJ4\u0018nY3K/R\u0003\u0016-\u001f7pC\u0012DaA!\t\t\u0001\u0004\t\u0018A\u00036xiB\u000b\u0017\u0010\\8bI\u0006y\u0001/\u0019:tK*;F\u000bU1zY>\fG\r\u0006\u0003\u0002\b\t\u001d\u0002BBA\u0001\u0013\u0001\u0007\u0011/A\bqCfdw.\u00193U_\u000ec\u0017-[7t+\t\u0011i\u0003\u0005\u00045\u0005_\u0011IbX\u0005\u0004\u0005c)$!\u0003$v]\u000e$\u0018n\u001c82\u0001")
public class AuthServiceJWT
implements AuthService {
    private final JwtVerifierBase verifier;
    private final Logger logger;
    private Metadata.Key<String> AUTHORIZATION_KEY;

    public static AuthServiceJWT apply(JwtVerifierBase verifier) {
        return AuthServiceJWT$.MODULE$.apply(verifier);
    }

    public static AuthServiceJWT apply(JWTVerifier verifier) {
        return AuthServiceJWT$.MODULE$.apply(verifier);
    }

    @Override
    public Metadata.Key<String> AUTHORIZATION_KEY() {
        return this.AUTHORIZATION_KEY;
    }

    @Override
    public void com$daml$ledger$api$auth$AuthService$_setter_$AUTHORIZATION_KEY_$eq(Metadata.Key<String> x$1) {
        this.AUTHORIZATION_KEY = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public CompletionStage<ClaimSet> decodeMetadata(Metadata headers) {
        ClaimSet claimSet;
        Option<String> option = this.getAuthorizationHeader(headers);
        if (None$.MODULE$.equals(option)) {
            claimSet = ClaimSet$Unauthenticated$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String header = (String)some.value();
            claimSet = this.parseHeader(header);
        } else {
            throw new MatchError(option);
        }
        return CompletableFuture.completedFuture(claimSet);
    }

    private Option<String> getAuthorizationHeader(Metadata headers) {
        return Option$.MODULE$.apply(headers.get(this.AUTHORIZATION_KEY()));
    }

    private ClaimSet parseHeader(String header) {
        return (ClaimSet)this.parseJWTPayload(header).fold((Function1 & Serializable)error -> {
            this.logger().warn(new StringBuilder(21).append("Authorization error: ").append(error.message()).toString());
            return ClaimSet$Unauthenticated$.MODULE$;
        }, (Function1 & Serializable)token -> (ClaimSet)this.payloadToClaims().apply(token));
    }

    private Either<Error, AuthServiceJWTPayload> parsePayload(String jwtPayload) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (AuthServiceJWTPayload)JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(jwtPayload)).convertTo((JsonReader)AuthServiceJWTCodec$JsonImplicits$AuthServiceJWTPayloadFormat$.MODULE$)).toEither().left().map((Function1 & Serializable)t -> new Error(new StringBuilder(27).append("Could not parse JWT token: ").append(t.getMessage()).toString()));
    }

    private Either<Error, AuthServiceJWTPayload> parseJWTPayload(String header) {
        Regex BearerTokenRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Bearer (.*)"));
        return BearerTokenRegex.findFirstMatchIn((CharSequence)header).map((Function1 & Serializable)x$1 -> x$1.group(1)).toRight((Function0 & Serializable)() -> new Error("Authorization header does not use Bearer format")).flatMap((Function1 & Serializable)token -> $this.verifier.verify(new Jwt(token)).toEither().left().map((Function1 & Serializable)e -> new Error(new StringBuilder(28).append("Could not verify JWT token: ").append(e.message()).toString())).flatMap((Function1 & Serializable)decoded -> this.parsePayload((String)decoded.payload()).map((Function1 & Serializable)parsed -> parsed)));
    }

    private Function1<AuthServiceJWTPayload, ClaimSet> payloadToClaims() {
        return (Function1 & Serializable)x0$1 -> {
            Product product;
            AuthServiceJWTPayload authServiceJWTPayload = x0$1;
            if (authServiceJWTPayload instanceof CustomDamlJWTPayload) {
                CustomDamlJWTPayload customDamlJWTPayload = (CustomDamlJWTPayload)authServiceJWTPayload;
                ListBuffer claims = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                claims.append((Object)ClaimPublic$.MODULE$);
                Object object = customDamlJWTPayload.admin() ? claims.append((Object)ClaimAdmin$.MODULE$) : BoxedUnit.UNIT;
                customDamlJWTPayload.actAs().foreach((Function1 & Serializable)party -> (ListBuffer)claims.append((Object)new ClaimActAsParty((String)Ref$.MODULE$.Party().assertFromString(party))));
                customDamlJWTPayload.readAs().foreach((Function1 & Serializable)party -> (ListBuffer)claims.append((Object)new ClaimReadAsParty((String)Ref$.MODULE$.Party().assertFromString(party))));
                product = new ClaimSet.Claims((Seq<Claim>)claims.toList(), customDamlJWTPayload.ledgerId(), customDamlJWTPayload.participantId(), customDamlJWTPayload.applicationId(), customDamlJWTPayload.exp(), false);
            } else if (authServiceJWTPayload instanceof StandardJWTPayload) {
                StandardJWTPayload standardJWTPayload = (StandardJWTPayload)authServiceJWTPayload;
                Option<String> x$1 = standardJWTPayload.participantId();
                String x$2 = standardJWTPayload.userId();
                Option<Instant> x$3 = standardJWTPayload.exp();
                product = new ClaimSet.AuthenticatedUser(x$2, x$1, x$3);
            } else {
                throw new MatchError((Object)authServiceJWTPayload);
            }
            return product;
        };
    }

    public AuthServiceJWT(JwtVerifierBase verifier) {
        this.verifier = verifier;
        AuthService.$init$(this);
        this.logger = LoggerFactory.getLogger(AuthServiceJWT$.MODULE$.getClass());
        Statics.releaseFence();
    }

    public static final class Error
    implements Product,
    Serializable {
        private final String message;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String message() {
            return this.message;
        }

        public Error copy(String message) {
            return new Error(message);
        }

        public String copy$default$1() {
            return this.message();
        }

        public String productPrefix() {
            return "Error";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.message();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Error;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "message";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Error)) return false;
            boolean bl = true;
            if (!bl) return false;
            Error error = (Error)x$1;
            String string = this.message();
            String string2 = error.message();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public Error(String message) {
            this.message = message;
            Product.$init$((Product)this);
        }
    }
}

