/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import com.daml.ledger.api.auth.AuthServiceJWTPayload;
import com.daml.ledger.api.auth.CustomDamlJWTPayload;
import com.daml.ledger.api.auth.StandardJWTPayload;
import java.io.Serializable;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import spray.json.JsArray;
import spray.json.JsArray$;
import spray.json.JsBoolean;
import spray.json.JsBoolean$;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsNumber$;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsString;
import spray.json.JsValue;

public final class AuthServiceJWTCodec$ {
    public static final AuthServiceJWTCodec$ MODULE$ = new AuthServiceJWTCodec$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String oidcNamespace = "https://daml.com/ledger-api";
    private static final String scopeLedgerApiFull = "daml_ledger_api";
    private static final String propLedgerId = "ledgerId";
    private static final String propParticipantId = "participantId";
    private static final String propApplicationId = "applicationId";
    private static final String propAdmin = "admin";
    private static final String propActAs = "actAs";
    private static final String propReadAs = "readAs";
    private static final String propExp = "exp";
    private static final String propParty = "party";

    public Logger logger() {
        return logger;
    }

    public final String oidcNamespace() {
        return oidcNamespace;
    }

    public final String scopeLedgerApiFull() {
        return scopeLedgerApiFull;
    }

    public String writeToString(AuthServiceJWTPayload v) {
        return ((JsValue)this.writePayload().apply((Object)v)).compactPrint();
    }

    public Function1<AuthServiceJWTPayload, JsValue> writePayload() {
        return (Function1 & Serializable)x0$1 -> {
            JsObject jsObject;
            AuthServiceJWTPayload authServiceJWTPayload = x0$1;
            if (authServiceJWTPayload instanceof CustomDamlJWTPayload) {
                CustomDamlJWTPayload customDamlJWTPayload = (CustomDamlJWTPayload)authServiceJWTPayload;
                jsObject = JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.oidcNamespace()), (Object)JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propLedgerId), (Object)MODULE$.writeOptionalString(customDamlJWTPayload.ledgerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propParticipantId), (Object)MODULE$.writeOptionalString(customDamlJWTPayload.participantId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propApplicationId), (Object)MODULE$.writeOptionalString(customDamlJWTPayload.applicationId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propAdmin), (Object)JsBoolean$.MODULE$.apply(customDamlJWTPayload.admin())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propActAs), (Object)MODULE$.writeStringList(customDamlJWTPayload.actAs())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propReadAs), (Object)MODULE$.writeStringList(customDamlJWTPayload.readAs()))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propExp), (Object)MODULE$.writeOptionalInstant(customDamlJWTPayload.exp()))}));
            } else if (authServiceJWTPayload instanceof StandardJWTPayload) {
                StandardJWTPayload standardJWTPayload = (StandardJWTPayload)authServiceJWTPayload;
                jsObject = JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aud"), (Object)MODULE$.writeOptionalString(standardJWTPayload.participantId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sub"), (Object)new JsString(standardJWTPayload.userId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp"), (Object)MODULE$.writeOptionalInstant(standardJWTPayload.exp())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scope"), (Object)new JsString(MODULE$.scopeLedgerApiFull()))}));
            } else {
                throw new MatchError((Object)authServiceJWTPayload);
            }
            return jsObject;
        };
    }

    public String compactPrint(AuthServiceJWTPayload v) {
        return ((JsValue)this.writePayload().apply((Object)v)).compactPrint();
    }

    private JsValue writeOptionalString(Option<String> value) {
        return (JsValue)value.fold((Function0 & Serializable)() -> JsNull$.MODULE$, (Function1 & Serializable)x$1 -> new JsString(x$1));
    }

    private JsValue writeStringList(List<String> value) {
        return JsArray$.MODULE$.apply((Seq)value.map((Function1 & Serializable)x$2 -> new JsString(x$2)));
    }

    private JsValue writeOptionalInstant(Option<Instant> value) {
        return (JsValue)value.fold((Function0 & Serializable)() -> JsNull$.MODULE$, (Function1 & Serializable)i -> JsNumber$.MODULE$.apply(i.getEpochSecond()));
    }

    public Try<AuthServiceJWTPayload> readFromString(String value) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> spray.json.package$.MODULE$.enrichString(value).parseJson()).flatMap((Function1 & Serializable)json -> Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.readPayload((JsValue)json)).map((Function1 & Serializable)parsed -> parsed));
    }

    public AuthServiceJWTPayload readPayload(JsValue value) {
        AuthServiceJWTPayload authServiceJWTPayload;
        JsValue jsValue = value;
        if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            Map fields = jsObject.fields();
            Option scope = fields.get((Object)"scope");
            List scopes = (List)scope.toList().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends JsValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    String[] stringArray;
                    A1 A1 = x1;
                    if (A1 instanceof JsString) {
                        JsString jsString = (JsString)A1;
                        String scope = jsString.value();
                        stringArray = scope.split(" ");
                    } else {
                        stringArray = function1.apply(x1);
                    }
                    return (B1)stringArray;
                }

                public final boolean isDefinedAt(JsValue x1) {
                    JsValue jsValue = x1;
                    boolean bl = jsValue instanceof JsString;
                    return bl;
                }
            }).flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
            if (scopes.contains((Object)this.scopeLedgerApiFull())) {
                Option<String> x$1 = this.readOptionalString("aud", (Map<String, JsValue>)fields);
                String x$2 = (String)this.readOptionalString("sub", (Map<String, JsValue>)fields).get();
                Option<Instant> x$3 = this.readInstant("exp", (Map<String, JsValue>)fields);
                authServiceJWTPayload = new StandardJWTPayload(x$2, x$1, x$3);
            } else {
                if (scope.nonEmpty()) {
                    this.logger().warn(new StringBuilder(143).append("Access token with unknown scope \"").append(scope.get()).append("\" is being parsed as a custom claims token. Issue tokens with adjusted or no scope to get rid of this warning.").toString());
                }
                if (!fields.contains((Object)this.oidcNamespace())) {
                    this.logger().warn(new StringBuilder(47).append("Token ").append(value.compactPrint()).append(" is using a deprecated JWT payload format").toString());
                    authServiceJWTPayload = new CustomDamlJWTPayload(this.readOptionalString(propLedgerId, (Map<String, JsValue>)fields), this.readOptionalString(propParticipantId, (Map<String, JsValue>)fields), this.readOptionalString(propApplicationId, (Map<String, JsValue>)fields), this.readInstant(propExp, (Map<String, JsValue>)fields), BoxesRunTime.unboxToBoolean((Object)this.readOptionalBoolean(propAdmin, (Map<String, JsValue>)fields).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), (List<String>)((List)this.readOptionalStringList(propActAs, (Map<String, JsValue>)fields).$plus$plus((IterableOnce)this.readOptionalString(propParty, (Map<String, JsValue>)fields).toList())), this.readOptionalStringList(propReadAs, (Map<String, JsValue>)fields));
                } else {
                    Map customClaims = ((JsValue)fields.getOrElse((Object)this.oidcNamespace(), (Function0 & Serializable)() -> spray.json.package$.MODULE$.deserializationError(new StringBuilder(55).append("Can't read ").append(value.prettyPrint()).append(" as AuthServiceJWTPayload: namespace missing").toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3()))).asJsObject(new StringBuilder(64).append("Can't read ").append(value.prettyPrint()).append(" as AuthServiceJWTPayload: namespace is not an object").toString()).fields();
                    authServiceJWTPayload = new CustomDamlJWTPayload(this.readOptionalString(propLedgerId, (Map<String, JsValue>)customClaims), this.readOptionalString(propParticipantId, (Map<String, JsValue>)customClaims), this.readOptionalString(propApplicationId, (Map<String, JsValue>)customClaims), this.readInstant(propExp, (Map<String, JsValue>)fields), BoxesRunTime.unboxToBoolean((Object)this.readOptionalBoolean(propAdmin, (Map<String, JsValue>)customClaims).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), this.readOptionalStringList(propActAs, (Map<String, JsValue>)customClaims), this.readOptionalStringList(propReadAs, (Map<String, JsValue>)customClaims));
                }
            }
        } else {
            throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(60).append("Can't read ").append(value.prettyPrint()).append(" as AuthServiceJWTPayload: value is not an object").toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
        }
        StandardJWTPayload standardJWTPayload = authServiceJWTPayload;
        return standardJWTPayload;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<String> readOptionalString(String name, Map<String, JsValue> fields) {
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option = fields.get((Object)name);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return None$.MODULE$;
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            String value = jsString.value();
            return new Some((Object)value);
        }
        if (!bl) throw new MatchError((Object)option);
        JsValue value = (JsValue)some.value();
        throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(26).append("Can't read ").append(value.prettyPrint()).append(" as string for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> readOptionalStringList(String name, Map<String, JsValue> fields) {
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option = fields.get((Object)name);
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return package$.MODULE$.List().empty();
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            Vector values = jsArray.elements();
            return values.toList().map((Function1 & Serializable)x0$1 -> {
                String value;
                JsValue jsValue = x0$1;
                if (!(jsValue instanceof JsString)) {
                    throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(34).append("Can't read ").append(jsValue.prettyPrint()).append(" as string element for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
                }
                JsString jsString = (JsString)jsValue;
                String string = value = jsString.value();
                return string;
            });
        }
        if (!bl) throw new MatchError((Object)option);
        JsValue value = (JsValue)some.value();
        throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(31).append("Can't read ").append(value.prettyPrint()).append(" as string list for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Object> readOptionalBoolean(String name, Map<String, JsValue> fields) {
        JsBoolean jsBoolean;
        Option option;
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option2 = fields.get((Object)name);
        if (None$.MODULE$.equals(option2)) {
            return None$.MODULE$;
        }
        if (option2 instanceof Some) {
            bl = true;
            some = (Some)option2;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return None$.MODULE$;
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsBoolean && !(option = JsBoolean$.MODULE$.unapply(jsBoolean = (JsBoolean)jsValue)).isEmpty()) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)option.get());
            return new Some((Object)BoxesRunTime.boxToBoolean((boolean)value));
        }
        if (!bl) throw new MatchError((Object)option2);
        JsValue value = (JsValue)some.value();
        throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(27).append("Can't read ").append(value.prettyPrint()).append(" as boolean for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Instant> readInstant(String name, Map<String, JsValue> fields) {
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option = fields.get((Object)name);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return None$.MODULE$;
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsNumber) {
            JsNumber jsNumber = (JsNumber)jsValue;
            BigDecimal epochSeconds = jsNumber.value();
            return new Some((Object)Instant.ofEpochSecond(epochSeconds.longValue()));
        }
        if (!bl) throw new MatchError((Object)option);
        JsValue value = (JsValue)some.value();
        throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(33).append("Can't read ").append(value.prettyPrint()).append(" as epoch seconds for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
    }

    private AuthServiceJWTCodec$() {
    }
}

