/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import akka.actor.Scheduler;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.LedgerApiErrors;
import com.daml.ledger.api.auth.AuthorizationError;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.ClaimSet$Unauthenticated$;
import com.daml.ledger.api.auth.OngoingAuthorizationObserver$;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$;
import com.daml.ledger.api.v1.transaction_filter.TransactionFilter;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.server.api.validation.ErrorFactories;
import com.daml.platform.server.api.validation.ErrorFactories$;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scalapb.lenses.Lens;

@ScalaSignature(bytes="\u0006\u0005\r5e\u0001\u0002\u0013&\u0005AB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Aq\n\u0001B\u0001B\u0003%A\t\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011!\u0004!\u0011!Q\u0001\n%D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006YA\u001d\u0005\u0006q\u0002!\t!\u001f\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"!\u0006\u0001A\u0003%\u0011q\u0002\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033A\u0001\"!\r\u0001A\u0003%\u00111\u0004\u0005\n\u0003g\u0001!\u0019!C\u0006\u0003kA\u0001\"a\u0011\u0001A\u0003%\u0011q\u0007\u0005\b\u0003\u000b\u0002A\u0011BA$\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!!/\u0001\t\u0003\tY\fC\u0004\u0002V\u0002!\t!a6\t\u0011\u0005%\b\u0001)C\u0005\u0003WDqA!\u0002\u0001\t\u0003\u00119\u0001C\u0004\u0003$\u0001!\tA!\n\t\u000f\t5\u0003\u0001\"\u0001\u0003P!9!1\r\u0001\u0005\u0002\t\u0015\u0004b\u0002BE\u0001\u0011\u0005!1\u0012\u0005\b\u0005o\u0003A\u0011\u0001B]\u0011\u001d\u0011I\r\u0001C\u0005\u0005\u0017DqA!8\u0001\t\u0013\u0011y\u000eC\u0004\u0003p\u0002!IA!=\t\u000f\r\u001d\u0001\u0001\"\u0003\u0004\n!91q\u0003\u0001\u0005\n\re\u0001bBB\u000f\u0001\u0011%1q\u0004\u0005\b\u0007\u007f\u0001A\u0011BB!\u0011!\u0019i\u0002\u0001C\u0001K\ru\u0003\u0002CB \u0001\u0011\u0005Qea\u001e\u0003\u0015\u0005+H\u000f[8sSj,'O\u0003\u0002'O\u0005!\u0011-\u001e;i\u0015\tA\u0013&A\u0002ba&T!AK\u0016\u0002\r1,GmZ3s\u0015\taS&\u0001\u0003eC6d'\"\u0001\u0018\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g-A\u0002o_^\u00042AM\u001d<\u0013\tQ4GA\u0005Gk:\u001cG/[8oaA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005i&lWMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$aB%ogR\fg\u000e^\u0001\tY\u0016$w-\u001a:JIB\u0011Q\t\u0014\b\u0003\r*\u0003\"aR\u001a\u000e\u0003!S!!S\u0018\u0002\rq\u0012xn\u001c;?\u0013\tY5'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&4\u00035\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;JI\u0006\u0019Ro]3s\u001b\u0006t\u0017mZ3nK:$8\u000b^8sKB\u0011!kW\u0007\u0002'*\u0011A+V\u0001\u0003mJR!AV,\u0002\u000b%tG-\u001a=\u000b\u0005aK\u0016!B:uCR,'B\u0001.*\u0003-\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;\n\u0005q\u001b&aE+tKJl\u0015M\\1hK6,g\u000e^*u_J,\u0017AA3d!\ty&-D\u0001a\u0015\t\t7'\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u00191\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018\u0001I;tKJ\u0014\u0016n\u001a5ug\u000eCWmY6J]R,'O^1m\u0013:\u001cVmY8oIN\u0004\"A\r4\n\u0005\u001d\u001c$aA%oi\u0006i\u0011m[6b'\u000eDW\rZ;mKJ\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\u000b\u0005\u001cGo\u001c:\u000b\u00039\fA!Y6lC&\u0011\u0001o\u001b\u0002\n'\u000eDW\rZ;mKJ\fa\u0002\\8hO&twmQ8oi\u0016DH\u000f\u0005\u0002tm6\tAO\u0003\u0002vW\u00059An\\4hS:<\u0017BA<u\u00059aunZ4j]\u001e\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0004>\u007f\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI\u0001\u0006\u0002|{B\u0011A\u0010A\u0007\u0002K!)\u0011/\u0003a\u0002e\")q'\u0003a\u0001q!)1)\u0003a\u0001\t\")q*\u0003a\u0001\t\")\u0001+\u0003a\u0001#\")Q,\u0003a\u0001=\")A-\u0003a\u0001K\")\u0001.\u0003a\u0001S\u00061An\\4hKJ,\"!a\u0004\u0011\u0007M\f\t\"C\u0002\u0002\u0014Q\u0014AcQ8oi\u0016DH/^1mSj,G\rT8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u000fKJ\u0014xN\u001d$bGR|'/[3t+\t\tY\u0002\u0005\u0003\u0002\u001e\u00055RBAA\u0010\u0015\u0011\t\t#a\t\u0002\u0015Y\fG.\u001b3bi&|gNC\u0002)\u0003KQA!a\n\u0002*\u000511/\u001a:wKJT1!a\u000b,\u0003!\u0001H.\u0019;g_Jl\u0017\u0002BA\u0018\u0003?\u0011a\"\u0012:s_J4\u0015m\u0019;pe&,7/A\bfeJ|'OR1di>\u0014\u0018.Z:!\u0003-)'O]8s\u0019><w-\u001a:\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u2&A\u0003feJ|'/\u0003\u0003\u0002B\u0005m\"!G\"p]R,\u0007\u0010^;bY&TX\rZ#se>\u0014Hj\\4hKJ\fA\"\u001a:s_JdunZ4fe\u0002\nQA^1mS\u0012$B!!\u0013\u0002hAA\u00111JA+\u00037\n\tG\u0004\u0003\u0002N\u0005EcbA$\u0002P%\tA'C\u0002\u0002TM\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002X\u0005e#AB#ji\",'OC\u0002\u0002TM\u00022\u0001`A/\u0013\r\ty&\n\u0002\u0013\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8FeJ|'\u000fE\u00023\u0003GJ1!!\u001a4\u0005\u0011)f.\u001b;\t\u000f\u0005%\u0004\u00031\u0001\u0002l\u000511\r\\1j[N\u0004B!!\u001c\u0002t9\u0019A0a\u001c\n\u0007\u0005ET%\u0001\u0005DY\u0006LWnU3u\u0013\u0011\t)(a\u001e\u0003\r\rc\u0017-[7t\u0015\r\t\t(J\u0001\u001ce\u0016\fX/\u001b:f!V\u0014G.[2DY\u0006LWn](o'R\u0014X-Y7\u0016\r\u0005u\u0014\u0011RAY)\u0011\ty(!.\u0011\u0013I\n\t)!\"\u0002\u001c\u0006\u0005\u0014bAABg\tIa)\u001e8di&|gN\r\t\u0005\u0003\u000f\u000bI\t\u0004\u0001\u0005\u000f\u0005-\u0015C1\u0001\u0002\u000e\n\u0019!+Z9\u0012\t\u0005=\u0015Q\u0013\t\u0004e\u0005E\u0015bAAJg\t9aj\u001c;iS:<\u0007c\u0001\u001a\u0002\u0018&\u0019\u0011\u0011T\u001a\u0003\u0007\u0005s\u0017\u0010\u0005\u0004\u0002\u001e\u0006-\u0016qV\u0007\u0003\u0003?SA!!)\u0002$\u0006!1\u000f^;c\u0015\u0011\t)+a*\u0002\t\u001d\u0014\bo\u0019\u0006\u0003\u0003S\u000b!![8\n\t\u00055\u0016q\u0014\u0002\u000f'R\u0014X-Y7PEN,'O^3s!\u0011\t9)!-\u0005\u000f\u0005M\u0016C1\u0001\u0002\u000e\n\u0019!+Z:\t\u000f\u0005]\u0016\u00031\u0001\u0002\u0000\u0005!1-\u00197m\u0003M\u0011X-];je\u0016\u0004VO\u00197jG\u000ec\u0017-[7t+\u0019\ti,a2\u0002RR!\u0011qXAj!\u001d\u0011\u0014\u0011YAc\u0003\u0013L1!a14\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\b\u0006\u001dGaBAF%\t\u0007\u0011Q\u0012\t\u0006?\u0006-\u0017qZ\u0005\u0004\u0003\u001b\u0004'A\u0002$viV\u0014X\r\u0005\u0003\u0002\b\u0006EGaBAZ%\t\u0007\u0011Q\u0012\u0005\b\u0003o\u0013\u0002\u0019AA`\u0003I\u0011X-];je\u0016\fE-\\5o\u00072\f\u0017.\\:\u0016\r\u0005e\u0017q\\As)\u0011\tY.a:\u0011\u000fI\n\t-!8\u0002bB!\u0011qQAp\t\u001d\tYi\u0005b\u0001\u0003\u001b\u0003RaXAf\u0003G\u0004B!a\"\u0002f\u00129\u00111W\nC\u0002\u00055\u0005bBA\\'\u0001\u0007\u00111\\\u0001\u000ee\u0016\fX/\u001b:f\r>\u0014\u0018\t\u001c7\u0016\t\u00055\u00181 \u000b\u0007\u0003\u0013\ny/a@\t\u000f\u0005EH\u00031\u0001\u0002t\u0006\u0011\u0001p\u001d\t\u0007\u0003\u0017\n)0!?\n\t\u0005]\u0018\u0011\f\u0002\r\u0013R,'/\u00192mK>s7-\u001a\t\u0005\u0003\u000f\u000bY\u0010B\u0004\u0002~R\u0011\r!!$\u0003\u0003QCqA!\u0001\u0015\u0001\u0004\u0011\u0019!A\u0001g!\u001d\u0011\u0014\u0011YA}\u0003\u0013\naE]3rk&\u0014XMU3bI\u000ec\u0017-[7t\r>\u0014\u0018\t\u001c7QCJ$\u0018.Z:P]N#(/Z1n+\u0019\u0011IAa\u0004\u0003\u0016Q1!1\u0002B\f\u0005C\u0001\u0012BMAA\u0005\u001b\u0011\t\"!\u0019\u0011\t\u0005\u001d%q\u0002\u0003\b\u0003\u0017+\"\u0019AAG!\u0019\ti*a+\u0003\u0014A!\u0011q\u0011B\u000b\t\u001d\t\u0019,\u0006b\u0001\u0003\u001bCqA!\u0007\u0016\u0001\u0004\u0011Y\"A\u0004qCJ$\u0018.Z:\u0011\u000b\u0005-#Q\u0004#\n\t\t}\u0011\u0011\f\u0002\t\u0013R,'/\u00192mK\"9\u0011qW\u000bA\u0002\t-\u0011a\u000e:fcVL'/\u001a*fC\u0012\u001cE.Y5ng\u001a{'/\u00117m!\u0006\u0014H/[3t\u001f:\u001cFO]3b[^KG\u000f[!qa2L7-\u0019;j_:LE-\u0006\u0004\u0003(\t5\"1\u0007\u000b\t\u0005S\u0011)Da\u000e\u0003LAI!'!!\u0003,\t=\u0012\u0011\r\t\u0005\u0003\u000f\u0013i\u0003B\u0004\u0002\fZ\u0011\r!!$\u0011\r\u0005u\u00151\u0016B\u0019!\u0011\t9Ia\r\u0005\u000f\u0005MfC1\u0001\u0002\u000e\"9!\u0011\u0004\fA\u0002\tm\u0001b\u0002B\u001d-\u0001\u0007!1H\u0001\u000fCB\u0004H.[2bi&|g.\u00133M!\u001d\u0011iDa\u0012\u0003,\u0011k!Aa\u0010\u000b\t\t\u0005#1I\u0001\u0007Y\u0016t7/Z:\u000b\u0005\t\u0015\u0013aB:dC2\f\u0007OY\u0005\u0005\u0005\u0013\u0012yD\u0001\u0003MK:\u001c\bbBA\\-\u0001\u0007!\u0011F\u0001\u001fe\u0016\fX/\u001b:f%\u0016\fGm\u00117bS6\u001chi\u001c:BY2\u0004\u0016M\u001d;jKN,bA!\u0015\u0003X\tuCC\u0002B*\u0005?\u0012\t\u0007E\u00043\u0003\u0003\u0014)F!\u0017\u0011\t\u0005\u001d%q\u000b\u0003\b\u0003\u0017;\"\u0019AAG!\u0015y\u00161\u001aB.!\u0011\t9I!\u0018\u0005\u000f\u0005MvC1\u0001\u0002\u000e\"9!\u0011D\fA\u0002\tm\u0001bBA\\/\u0001\u0007!1K\u0001\"e\u0016\fX/\u001b:f\u0003\u000e$\u0018I\u001c3SK\u0006$7\t\\1j[N4uN\u001d)beRLWm]\u000b\u0007\u0005O\u0012iGa\u001d\u0015\u0015\t%$Q\u000fB@\u0005\u0007\u00139\tE\u00043\u0003\u0003\u0014YGa\u001c\u0011\t\u0005\u001d%Q\u000e\u0003\b\u0003\u0017C\"\u0019AAG!\u0015y\u00161\u001aB9!\u0011\t9Ia\u001d\u0005\u000f\u0005M\u0006D1\u0001\u0002\u000e\"9!q\u000f\rA\u0002\te\u0014!B1di\u0006\u001b\b\u0003B#\u0003|\u0011K1A! O\u0005\r\u0019V\r\u001e\u0005\b\u0005\u0003C\u0002\u0019\u0001B=\u0003\u0019\u0011X-\u00193Bg\"9!\u0011\b\rA\u0002\t\u0015\u0005c\u0002B\u001f\u0005\u000f\u0012Y\u0007\u0012\u0005\b\u0003oC\u0002\u0019\u0001B5\u00035\u0012X-];je\u0016\u0014V-\u00193DY\u0006LWn\u001d$peR\u0013\u0018M\\:bGRLwN\u001c$jYR,'o\u00148TiJ,\u0017-\\\u000b\u0007\u0005\u001b\u0013\u0019J!'\u0015\r\t=%1\u0014B[!%\u0011\u0014\u0011\u0011BI\u0005+\u000b\t\u0007\u0005\u0003\u0002\b\nMEaBAF3\t\u0007\u0011Q\u0012\t\u0007\u0003;\u000bYKa&\u0011\t\u0005\u001d%\u0011\u0014\u0003\b\u0003gK\"\u0019AAG\u0011\u001d\u0011i*\u0007a\u0001\u0005?\u000baAZ5mi\u0016\u0014\b#\u0002\u001a\u0003\"\n\u0015\u0016b\u0001BRg\t1q\n\u001d;j_:\u0004BAa*\u000326\u0011!\u0011\u0016\u0006\u0005\u0005W\u0013i+\u0001\nue\u0006t7/Y2uS>twLZ5mi\u0016\u0014(b\u0001BXO\u0005\u0011a/M\u0005\u0005\u0005g\u0013IKA\tUe\u0006t7/Y2uS>tg)\u001b7uKJDq!a.\u001a\u0001\u0004\u0011y)A\nbkRDWM\u001c;jG\u0006$X\rZ+tKJLE\r\u0006\u0002\u0003<B1!Q\u0018Bb\u0005\u000fl!Aa0\u000b\u0007\t\u00057'\u0001\u0003vi&d\u0017\u0002\u0002Bc\u0005\u007f\u00131\u0001\u0016:z!\u0011\u0011$\u0011\u0015#\u0002)\u0011,g-Y;mi\u0006\u0003\b\u000f\\5dCRLwN\\%e)\u0019\u0011iMa6\u0003\\B9\u00111JA+\u0005\u001f$\u0005\u0003\u0002Bi\u0005'l!!a)\n\t\tU\u00171\u0015\u0002\u0017'R\fG/^:Sk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]\"1!\u0011\\\u000eA\u0002\u0011\u000b\u0001C]3r\u0003B\u0004H.[2bi&|g.\u00133\t\u000f\u0005%4\u00041\u0001\u0002l\u0005A\u0012-\u001e;i_JL'0\u0019;j_:,%O]8s\u0003N<%\u000f]2\u0016\t\t\u0005(q\u001d\u000b\u0005\u0005G\u0014I\u000f\u0005\u0005\u0002L\u0005U#q\u001aBs!\u0011\t9Ia:\u0005\u000f\u0005uHD1\u0001\u0002\u000e\"9!1\u001e\u000fA\u0002\t5\u0018AB3se>\u0013h\u000b\u0005\u0005\u0002L\u0005U\u00131\fBs\u0003A\t7o]3siN+'O^3s\u0007\u0006dG.\u0006\u0003\u0003t\nuH\u0003\u0002B{\u0007\u0003\u0001b!!(\u0003x\nm\u0018\u0002\u0002B}\u0003?\u0013\u0001dU3sm\u0016\u00148)\u00197m'R\u0014X-Y7PEN,'O^3s!\u0011\t9I!@\u0005\u000f\t}XD1\u0001\u0002\u000e\n\t\u0011\tC\u0004\u0004\u0004u\u0001\ra!\u0002\u0002\u0011=\u00147/\u001a:wKJ\u0004b!!(\u0002,\nm\u0018\u0001F8oO>LgnZ!vi\"|'/\u001b>bi&|g.\u0006\u0003\u0004\f\rEACBB\u0007\u0007'\u0019)\u0002\u0005\u0004\u0002\u001e\n]8q\u0002\t\u0005\u0003\u000f\u001b\t\u0002B\u0004\u00024z\u0011\r!!$\t\u000f\r\ra\u00041\u0001\u0004\u000e!9\u0011\u0011\u000e\u0010A\u0002\u0005-\u0014AH1vi\",g\u000e^5dCR,Gm\u00117bS6\u001chI]8n\u0007>tG/\u001a=u)\t\u0019Y\u0002\u0005\u0004\u0003>\n\r\u00171N\u0001\u0011CV$\bn\u001c:ju\u0016<\u0016\u000e\u001e5SKF,ba!\t\u0004*\r=B\u0003BB\u0012\u0007s!Ba!\n\u00042AI!'!!\u0004(\r-\u0012\u0011\r\t\u0005\u0003\u000f\u001bI\u0003B\u0004\u0002\f\u0002\u0012\r!!$\u0011\r\u0005u\u00151VB\u0017!\u0011\t9ia\f\u0005\u000f\u0005M\u0006E1\u0001\u0002\u000e\"911\u0007\u0011A\u0002\rU\u0012AC1vi\"|'/\u001b>fIBI!'!!\u0002l\r\u001d2q\u0007\t\t\u0003\u0017\n)Fa4\u0004(!9\u0011q\u0017\u0011A\u0002\rm\u0002#\u0003\u001a\u0002\u0002\u000e\u001d2QHA1!\u0019\tiJa>\u0004.\u0005I\u0011-\u001e;i_JL'0Z\u000b\u0007\u0007\u0007\u001aYe!\u0015\u0015\t\r\u00153q\u000b\u000b\u0005\u0007\u000f\u001a\u0019\u0006E\u00053\u0003\u0003\u001bIe!\u0014\u0002bA!\u0011qQB&\t\u001d\tY)\tb\u0001\u0003\u001b\u0003b!!(\u0002,\u000e=\u0003\u0003BAD\u0007#\"q!a-\"\u0005\u0004\ti\tC\u0004\u00044\u0005\u0002\ra!\u0016\u0011\u000fI\n\t-a\u001b\u0002J!9\u0011qW\u0011A\u0002\re\u0003#\u0003\u001a\u0002\u0002\u000e%31LA1!\u0019\tiJa>\u0004PU11qLB4\u0007[\"Ba!\u0019\u0004vQ!11MB8!\u001d\u0011\u0014\u0011YB3\u0007S\u0002B!a\"\u0004h\u00119\u00111\u0012\u0012C\u0002\u00055\u0005#B0\u0002L\u000e-\u0004\u0003BAD\u0007[\"q!a-#\u0005\u0004\ti\tC\u0004\u00044\t\u0002\ra!\u001d\u0011\u0013I\n\t)a\u001b\u0004f\rM\u0004\u0003CA&\u0003+\u0012ym!\u001a\t\u000f\u0005]&\u00051\u0001\u0004dU11\u0011PBA\u0007\u000f#Baa\u001f\u0004\fR!1QPBE!\u001d\u0011\u0014\u0011YB@\u0007\u0007\u0003B!a\"\u0004\u0002\u00129\u00111R\u0012C\u0002\u00055\u0005#B0\u0002L\u000e\u0015\u0005\u0003BAD\u0007\u000f#q!a-$\u0005\u0004\ti\tC\u0004\u00044\r\u0002\ra!\u0016\t\u000f\u0005]6\u00051\u0001\u0004~\u0001")
public final class Authorizer {
    private final Function0<Instant> now;
    private final String ledgerId;
    private final String participantId;
    private final UserManagementStore userManagementStore;
    private final ExecutionContext ec;
    private final int userRightsCheckIntervalInSeconds;
    private final Scheduler akkaScheduler;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final ErrorFactories errorFactories;
    private final ContextualizedErrorLogger errorLogger;

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private ErrorFactories errorFactories() {
        return this.errorFactories;
    }

    private ContextualizedErrorLogger errorLogger() {
        return this.errorLogger;
    }

    private Either<AuthorizationError, BoxedUnit> valid(ClaimSet.Claims claims) {
        return claims.notExpired((Instant)this.now.apply()).flatMap((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            Either either = claims.validForLedger($this.ledgerId).flatMap((Function1 & Serializable)x$2 -> {
                BoxedUnit boxedUnit = x$2;
                Either either = claims.validForParticipant($this.participantId).map((Function1 & Serializable)x$1 -> {
                    Authorizer.$anonfun$valid$3(x$1);
                    return BoxedUnit.UNIT;
                });
                return either;
            });
            return either;
        });
    }

    public <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> requirePublicClaimsOnStream(Function2<Req, StreamObserver<Res>, BoxedUnit> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$5 -> {
            BoxedUnit boxedUnit = x$5;
            Either either = claims.isPublic().map((Function1 & Serializable)x$4 -> {
                Authorizer.$anonfun$requirePublicClaimsOnStream$3(x$4);
                return BoxedUnit.UNIT;
            });
            return either;
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requirePublicClaims(Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$7 -> {
            BoxedUnit boxedUnit = x$7;
            Either either = claims.isPublic().map((Function1 & Serializable)x$6 -> {
                Authorizer.$anonfun$requirePublicClaims$3(x$6);
                return BoxedUnit.UNIT;
            });
            return either;
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requireAdminClaims(Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            Either either = claims.isAdmin().map((Function1 & Serializable)x$8 -> {
                Authorizer.$anonfun$requireAdminClaims$3(x$8);
                return BoxedUnit.UNIT;
            });
            return either;
        }));
    }

    private <T> Either<AuthorizationError, BoxedUnit> requireForAll(IterableOnce<T> xs, Function1<T, Either<AuthorizationError, BoxedUnit>> f) {
        return (Either)xs.iterator().foldLeft((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT), (Function2 & Serializable)(acc, x) -> acc.flatMap((Function1 & Serializable)x$10 -> (Either)f.apply(x)));
    }

    public <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> requireReadClaimsForAllPartiesOnStream(Iterable<String> parties, Function2<Req, StreamObserver<Res>, BoxedUnit> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            Either either = this.requireForAll((IterableOnce)parties, (Function1)(Function1 & Serializable)party -> claims.canReadAs((String)party)).map((Function1 & Serializable)x$11 -> {
                Authorizer.$anonfun$requireReadClaimsForAllPartiesOnStream$4(x$11);
                return BoxedUnit.UNIT;
            });
            return either;
        }));
    }

    public <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> requireReadClaimsForAllPartiesOnStreamWithApplicationId(Iterable<String> parties, Lens<Req, String> applicationIdL, Function2<Req, StreamObserver<Res>, BoxedUnit> call) {
        return this.authorizeWithReq(call, (Function2 & Serializable)(claims, req) -> {
            String reqApplicationId = (String)applicationIdL.get(req);
            return this.authorizationErrorAsGrpc(this.valid((ClaimSet.Claims)claims)).flatMap((Function1 & Serializable)x$15 -> {
                BoxedUnit boxedUnit = x$15;
                Either either = this.authorizationErrorAsGrpc(this.requireForAll((IterableOnce)parties, (Function1)(Function1 & Serializable)party -> claims.canReadAs((String)party))).flatMap((Function1 & Serializable)x$14 -> {
                    BoxedUnit boxedUnit = x$14;
                    Either either = this.defaultApplicationId(reqApplicationId, (ClaimSet.Claims)claims).flatMap((Function1 & Serializable)defaultedApplicationId -> this.authorizationErrorAsGrpc(claims.validForApplication((String)defaultedApplicationId)).map((Function1 & Serializable)x$13 -> {
                        BoxedUnit boxedUnit = x$13;
                        Object object = applicationIdL.set(defaultedApplicationId).apply(req);
                        return object;
                    }));
                    return either;
                });
                return either;
            });
        });
    }

    public <Req, Res> Function1<Req, Future<Res>> requireReadClaimsForAllParties(Iterable<String> parties, Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$17 -> {
            BoxedUnit boxedUnit = x$17;
            Either either = this.requireForAll((IterableOnce)parties, (Function1)(Function1 & Serializable)party -> claims.canReadAs((String)party)).map((Function1 & Serializable)x$16 -> {
                Authorizer.$anonfun$requireReadClaimsForAllParties$4(x$16);
                return BoxedUnit.UNIT;
            });
            return either;
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requireActAndReadClaimsForParties(Set<String> actAs, Set<String> readAs, Lens<Req, String> applicationIdL, Function1<Req, Future<Res>> call) {
        return this.authorizeWithReq(call, (Function2 & Serializable)(claims, req) -> {
            String reqApplicationId = (String)applicationIdL.get(req);
            return this.authorizationErrorAsGrpc(this.valid((ClaimSet.Claims)claims)).flatMap((Function1 & Serializable)x$23 -> {
                BoxedUnit boxedUnit = x$23;
                Either either = this.authorizationErrorAsGrpc((Either)actAs.foldRight((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT), (Function2 & Serializable)(p, acc) -> acc.flatMap((Function1 & Serializable)x$18 -> claims.canActAs((String)p)))).flatMap((Function1 & Serializable)x$22 -> {
                    BoxedUnit boxedUnit = x$22;
                    Either either = this.authorizationErrorAsGrpc((Either)readAs.foldRight((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT), (Function2 & Serializable)(p, acc) -> acc.flatMap((Function1 & Serializable)x$19 -> claims.canReadAs((String)p)))).flatMap((Function1 & Serializable)x$21 -> {
                        BoxedUnit boxedUnit = x$21;
                        Either either = this.defaultApplicationId(reqApplicationId, (ClaimSet.Claims)claims).flatMap((Function1 & Serializable)defaultedApplicationId -> this.authorizationErrorAsGrpc(claims.validForApplication((String)defaultedApplicationId)).map((Function1 & Serializable)x$20 -> {
                            BoxedUnit boxedUnit = x$20;
                            Object object = applicationIdL.set(defaultedApplicationId).apply(req);
                            return object;
                        }));
                        return either;
                    });
                    return either;
                });
                return either;
            });
        });
    }

    public <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> requireReadClaimsForTransactionFilterOnStream(Option<TransactionFilter> filter, Function2<Req, StreamObserver<Res>, BoxedUnit> call) {
        return this.requireReadClaimsForAllPartiesOnStream((Iterable<String>)((Iterable)filter.map((Function1 & Serializable)x$24 -> x$24.filtersByParty()).fold((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable)x$25 -> x$25.keySet())), call);
    }

    public Try<Option<String>> authenticatedUserId() {
        return this.authenticatedClaimsFromContext().flatMap((Function1 & Serializable)claims -> {
            Success success;
            if (claims.resolvedFromUser()) {
                Success success2;
                Option<String> option = claims.applicationId();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String applicationId = (String)some.value();
                    success2 = new Success((Object)new Some((Object)applicationId));
                } else if (None$.MODULE$.equals(option)) {
                    success2 = new Failure((Throwable)new LedgerApiErrors.AuthorizationChecks$.InternalAuthorizationError$.Reject("unexpectedly the user-id is not set in the authenticated claims", (Throwable)new RuntimeException(), this.errorLogger()).asGrpcError());
                } else {
                    throw new MatchError(option);
                }
                success = success2;
            } else {
                success = new Success((Object)None$.MODULE$);
            }
            return success;
        });
    }

    private Either<StatusRuntimeException, String> defaultApplicationId(String reqApplicationId, ClaimSet.Claims claims) {
        Right right;
        if (reqApplicationId.isEmpty()) {
            Some some;
            String applicationId;
            Option<String> option = claims.applicationId();
            Object object = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(applicationId = (String)(some = (Some)option).value())) ? package$.MODULE$.Right().apply((Object)applicationId) : package$.MODULE$.Left().apply((Object)this.errorFactories().invalidArgument("Cannot default application_id field because claims do not specify an application-id or user-id. Is authentication turned on?", this.errorLogger()));
            right = object;
        } else {
            right = package$.MODULE$.Right().apply((Object)reqApplicationId);
        }
        return right;
    }

    private <T> Either<StatusRuntimeException, T> authorizationErrorAsGrpc(Either<AuthorizationError, T> errOrV) {
        return (Either)errOrV.fold((Function1 & Serializable)err -> package$.MODULE$.Left().apply((Object)this.errorFactories().permissionDenied(err.reason(), this.errorLogger())), (Function1 & Serializable)x$26 -> package$.MODULE$.Right().apply(x$26));
    }

    private <A> ServerCallStreamObserver<A> assertServerCall(StreamObserver<A> observer) {
        StreamObserver<A> streamObserver = observer;
        if (!(streamObserver instanceof ServerCallStreamObserver)) {
            throw new IllegalArgumentException(new StringBuilder(29).append("The wrapped stream MUST be a ").append(ServerCallStreamObserver.class.getName()).toString());
        }
        ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)observer;
        return serverCallStreamObserver;
    }

    private <Res> ServerCallStreamObserver<Res> ongoingAuthorization(ServerCallStreamObserver<Res> observer, ClaimSet.Claims claims) {
        return OngoingAuthorizationObserver$.MODULE$.apply(observer, claims, this.now, this.errorFactories(), this.userManagementStore, this.userRightsCheckIntervalInSeconds, this.akkaScheduler, this.loggingContext, this.ec);
    }

    private Try<ClaimSet.Claims> authenticatedClaimsFromContext() {
        return AuthorizationInterceptor$.MODULE$.extractClaimSetFromContext().flatMap((Function1 & Serializable)x0$1 -> {
            Failure failure;
            ClaimSet claimSet = x0$1;
            if (ClaimSet$Unauthenticated$.MODULE$.equals(claimSet)) {
                failure = new Failure((Throwable)this.errorFactories().unauthenticatedMissingJwtToken(this.errorLogger()));
            } else if (claimSet instanceof ClaimSet.AuthenticatedUser) {
                ClaimSet.AuthenticatedUser authenticatedUser = (ClaimSet.AuthenticatedUser)claimSet;
                failure = new Failure((Throwable)this.errorFactories().internalAuthenticationError("Unexpected unresolved authenticated user claim", (Throwable)new RuntimeException(new StringBuilder(57).append("Unexpected unresolved authenticated user claim for user '").append(authenticatedUser.userId()).toString()), this.errorLogger()));
            } else if (claimSet instanceof ClaimSet.Claims) {
                ClaimSet.Claims claims = (ClaimSet.Claims)claimSet;
                failure = new Success((Object)claims);
            } else {
                throw new MatchError((Object)claimSet);
            }
            return failure;
        });
    }

    private <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> authorizeWithReq(Function2<Req, ServerCallStreamObserver<Res>, BoxedUnit> call, Function2<ClaimSet.Claims, Req, Either<StatusRuntimeException, Req>> authorized) {
        return (Function2 & Serializable)(request, observer) -> {
            Authorizer.$anonfun$authorizeWithReq$1(this, authorized, call, request, observer);
            return BoxedUnit.UNIT;
        };
    }

    private <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> authorize(Function2<Req, ServerCallStreamObserver<Res>, BoxedUnit> call, Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>> authorized) {
        return this.authorizeWithReq(call, (Function2 & Serializable)(claims, req) -> this.authorizationErrorAsGrpc((Either)authorized.apply(claims)).map((Function1 & Serializable)x$27 -> req));
    }

    public <Req, Res> Function1<Req, Future<Res>> authorizeWithReq(Function1<Req, Future<Res>> call, Function2<ClaimSet.Claims, Req, Either<StatusRuntimeException, Req>> authorized) {
        return (Function1 & Serializable)request -> {
            Future future;
            Try<ClaimSet.Claims> try_ = this.authenticatedClaimsFromContext();
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                future = Future$.MODULE$.failed(ex);
            } else if (try_ instanceof Success) {
                Future future2;
                Success success = (Success)try_;
                ClaimSet.Claims claims = (ClaimSet.Claims)success.value();
                Either either = (Either)authorized.apply((Object)claims, request);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Object modifiedReq = right.value();
                    future2 = (Future)call.apply(modifiedReq);
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    StatusRuntimeException ex = (StatusRuntimeException)left.value();
                    future2 = Future$.MODULE$.failed((Throwable)ex);
                } else {
                    throw new MatchError((Object)either);
                }
                future = future2;
            } else {
                throw new MatchError(try_);
            }
            return future;
        };
    }

    public <Req, Res> Function1<Req, Future<Res>> authorize(Function1<Req, Future<Res>> call, Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>> authorized) {
        return this.authorizeWithReq(call, (Function2 & Serializable)(claims, req) -> this.authorizationErrorAsGrpc((Either)authorized.apply(claims)).map((Function1 & Serializable)x$28 -> req));
    }

    public static final /* synthetic */ void $anonfun$valid$3(BoxedUnit x$1) {
        BoxedUnit boxedUnit = x$1;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$requirePublicClaimsOnStream$3(BoxedUnit x$4) {
        BoxedUnit boxedUnit = x$4;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$requirePublicClaims$3(BoxedUnit x$6) {
        BoxedUnit boxedUnit = x$6;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$requireAdminClaims$3(BoxedUnit x$8) {
        BoxedUnit boxedUnit = x$8;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$requireReadClaimsForAllPartiesOnStream$4(BoxedUnit x$11) {
        BoxedUnit boxedUnit = x$11;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$requireReadClaimsForAllParties$4(BoxedUnit x$16) {
        BoxedUnit boxedUnit = x$16;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$authorizeWithReq$2(Authorizer $this, StreamObserver observer$1, Throwable ex) {
        $this.logger().debug().apply((Function0 & Serializable)() -> "No authenticated claims found in the request context. Returning UNAUTHENTICATED", $this.loggingContext);
        observer$1.onError(ex);
    }

    public static final /* synthetic */ void $anonfun$authorizeWithReq$4(Authorizer $this, Function2 authorized$1, Object request$1, Function2 call$1, ServerCallStreamObserver serverCallStreamObserver$1, StreamObserver observer$1, ClaimSet.Claims claims) {
        Either either = (Either)authorized$1.apply((Object)claims, request$1);
        if (either instanceof Right) {
            Right right = (Right)either;
            Object modifiedRequest = right.value();
            BoxedUnit boxedUnit = (BoxedUnit)call$1.apply(modifiedRequest, claims.expiration().isDefined() || claims.resolvedFromUser() ? $this.ongoingAuthorization(serverCallStreamObserver$1, claims) : serverCallStreamObserver$1);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            StatusRuntimeException ex = (StatusRuntimeException)left.value();
            observer$1.onError((Throwable)ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    public static final /* synthetic */ void $anonfun$authorizeWithReq$1(Authorizer $this, Function2 authorized$1, Function2 call$1, Object request, StreamObserver observer) {
        ServerCallStreamObserver serverCallStreamObserver = $this.assertServerCall(observer);
        $this.authenticatedClaimsFromContext().fold((Function1 & Serializable)ex -> {
            Authorizer.$anonfun$authorizeWithReq$2($this, observer, ex);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)claims -> {
            Authorizer.$anonfun$authorizeWithReq$4($this, authorized$1, request, call$1, serverCallStreamObserver, observer, claims);
            return BoxedUnit.UNIT;
        });
    }

    public Authorizer(Function0<Instant> now, String ledgerId, String participantId, UserManagementStore userManagementStore, ExecutionContext ec, int userRightsCheckIntervalInSeconds, Scheduler akkaScheduler, LoggingContext loggingContext) {
        this.now = now;
        this.ledgerId = ledgerId;
        this.participantId = participantId;
        this.userManagementStore = userManagementStore;
        this.ec = ec;
        this.userRightsCheckIntervalInSeconds = userRightsCheckIntervalInSeconds;
        this.akkaScheduler = akkaScheduler;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.errorFactories = ErrorFactories$.MODULE$.apply();
        this.errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
    }
}

