/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import akka.actor.Scheduler;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.LedgerApiErrors;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.OngoingAuthorizationObserver$;
import com.daml.ledger.api.auth.UserRightsChangeAsyncChecker;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.server.api.validation.ErrorFactories;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tmd!\u0002\u0014(\u0005\u001d\n\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"Aa\u000e\u0001B\u0001B\u0003%q\u000e\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011!I\bA!A!\u0002\u0013Q\bBCA\u0005\u0001\t\u0005\t\u0015a\u0003\u0002\f!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001\"CA\u0018\u0001\t\u0007I\u0011BA\u0019\u0011!\tI\u0004\u0001Q\u0001\n\u0005M\u0002\"CA\u001e\u0001\t\u0007I\u0011BA\u001f\u0011!\tY\u0005\u0001Q\u0001\n\u0005}\u0002\"CA'\u0001\u0001\u0007I\u0011BA(\u0011%\t9\u0006\u0001a\u0001\n\u0013\tI\u0006\u0003\u0005\u0002f\u0001\u0001\u000b\u0015BA)\u0011%\t9\u0007\u0001b\u0001\n\u0013\tI\u0007\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA6\u0011\u001d\t\t\b\u0001C!\u0003gBq!!\u001e\u0001\t\u0003\n9\bC\u0004\u0002\n\u0002!\t%a#\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002t!9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003g\u0003A\u0011IA[\u0011\u001d\tY\f\u0001C!\u0003{Cq!a1\u0001\t\u0003\n)\rC\u0004\u0002L\u0002!\t%!4\t\u000f\u0005\u0015\b\u0001\"\u0011\u00022\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBA{\u0001\u0011%\u0011q\u001f\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'9\u0001B!\u0006(\u0011\u00039#q\u0003\u0004\bM\u001dB\ta\nB\r\u0011\u001d\t9b\tC\u0001\u0005CAqAa\t$\t\u0003\u0011)C\u0001\u000fP]\u001e|\u0017N\\4BkRDwN]5{CRLwN\\(cg\u0016\u0014h/\u001a:\u000b\u0005!J\u0013\u0001B1vi\"T!AK\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002-[\u00051A.\u001a3hKJT!AL\u0018\u0002\t\u0011\fW\u000e\u001c\u0006\u0002a\u0005\u00191m\\7\u0016\u0005Iz4C\u0001\u00014!\r!4(P\u0007\u0002k)\u0011agN\u0001\u0005gR,(M\u0003\u00029s\u0005!qM\u001d9d\u0015\u0005Q\u0014AA5p\u0013\taTG\u0001\rTKJ4XM]\"bY2\u001cFO]3b[>\u00137/\u001a:wKJ\u0004\"AP \r\u0001\u0011)\u0001\t\u0001b\u0001\u0005\n\t\u0011i\u0001\u0001\u0012\u0005\rK\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%a\u0002(pi\"Lgn\u001a\t\u0003\t*K!aS#\u0003\u0007\u0005s\u00170\u0001\u0005pEN,'O^3s\u00039y'/[4j]\u0006d7\t\\1j[N\u0004\"aT*\u000f\u0005A\u000bV\"A\u0014\n\u0005I;\u0013\u0001C\"mC&l7+\u001a;\n\u0005Q+&AB\"mC&l7O\u0003\u0002SO\u0005!an\\<G!\r!\u0005LW\u0005\u00033\u0016\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016\u0001\u0002;j[\u0016T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b9\n9\u0011J\\:uC:$\u0018AD3se>\u0014h)Y2u_JLWm\u001d\t\u0003I2l\u0011!\u001a\u0006\u0003M\u001e\f!B^1mS\u0012\fG/[8o\u0015\tQ\u0003N\u0003\u0002jU\u000611/\u001a:wKJT!a[\u0017\u0002\u0011Ad\u0017\r\u001e4pe6L!!\\3\u0003\u001d\u0015\u0013(o\u001c:GC\u000e$xN]5fg\u0006\u0011Ro]3s%&<\u0007\u000e^:DQ\u0016\u001c7.\u001a:P!\r!\u0005O]\u0005\u0003c\u0016\u0013aa\u00149uS>t\u0007C\u0001)t\u0013\t!xE\u0001\u000fVg\u0016\u0014(+[4iiN\u001c\u0005.\u00198hK\u0006\u001b\u0018P\\2DQ\u0016\u001c7.\u001a:\u0002AU\u001cXM\u001d*jO\"$8o\u00115fG.Le\u000e^3sm\u0006d\u0017J\\*fG>tGm\u001d\t\u0003\t^L!\u0001_#\u0003\u0007%sG/A\fmCN$Xk]3s%&<\u0007\u000e^:DQ\u0016\u001c7\u000eV5nKB!10!\u0002[\u001b\u0005a(BA?\u007f\u0003\u0019\tGo\\7jG*\u0019q0!\u0001\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\u0004y\u000bA!\u001e;jY&\u0019\u0011q\u0001?\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\fa\u0002\\8hO&twmQ8oi\u0016DH\u000f\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\"L\u0001\bY><w-\u001b8h\u0013\u0011\t)\"a\u0004\u0003\u001d1{wmZ5oO\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0002#a\u0007\u0002\"\u0005\r\u0012QEA\u0014\u0003S\tY#!\f\u0015\t\u0005u\u0011q\u0004\t\u0004!\u0002i\u0004bBA\u0005\u0013\u0001\u000f\u00111\u0002\u0005\u0006\u0019&\u0001\ra\r\u0005\u0006\u001b&\u0001\rA\u0014\u0005\u0006-&\u0001\ra\u0016\u0005\u0006E&\u0001\ra\u0019\u0005\u0006]&\u0001\ra\u001c\u0005\u0006k&\u0001\rA\u001e\u0005\u0006s&\u0001\rA_\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005M\u0002\u0003BA\u0007\u0003kIA!a\u000e\u0002\u0010\t!2i\u001c8uKb$X/\u00197ju\u0016$Gj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006feJ|'\u000fT8hO\u0016\u0014XCAA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#[\u0005)QM\u001d:pe&!\u0011\u0011JA\"\u0005u!\u0015-\u001c7D_:$X\r\u001f;vC2L'0\u001a3FeJ|'\u000fT8hO\u0016\u0014\u0018\u0001D3se>\u0014Hj\\4hKJ\u0004\u0013AF1gi\u0016\u00148i\\7qY\u0016$\u0018n\u001c8Pe\u0016\u0013(o\u001c:\u0016\u0005\u0005E\u0003c\u0001#\u0002T%\u0019\u0011QK#\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0012M\u001a;fe\u000e{W\u000e\u001d7fi&|gn\u0014:FeJ|'o\u0018\u0013fcR!\u00111LA1!\r!\u0015QL\u0005\u0004\u0003?*%\u0001B+oSRD\u0011\"a\u0019\u0010\u0003\u0003\u0005\r!!\u0015\u0002\u0007a$\u0013'A\fbMR,'oQ8na2,G/[8o\u001fJ,%O]8sA\u000592-\u00198dK2,6/\u001a:SS\u001eDGo]\"iK\u000e\\7oT\u000b\u0003\u0003W\u0002B\u0001\u00129\u0002nA!A\tWA.\u0003a\u0019\u0017M\\2fYV\u001bXM\u001d*jO\"$8o\u00115fG.\u001cx\nI\u0001\fSN\u001c\u0015M\\2fY2,G\r\u0006\u0002\u0002R\u0005\u00112/\u001a;P]\u000e\u000bgnY3m\u0011\u0006tG\r\\3s)\u0011\tY&!\u001f\t\u000f\u0005mD\u00031\u0001\u0002~\u0005A!/\u001e8oC\ndW\r\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019IX\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\b\u0006\u0005%\u0001\u0003*v]:\f'\r\\3\u0002\u001dM,GoQ8naJ,7o]5p]R!\u00111LAG\u0011\u001d\ty)\u0006a\u0001\u0003#\u000b\u0011a\u001d\t\u0005\u0003'\u000b\tK\u0004\u0003\u0002\u0016\u0006u\u0005cAAL\u000b6\u0011\u0011\u0011\u0014\u0006\u0004\u00037\u000b\u0015A\u0002\u001fs_>$h(C\u0002\u0002 \u0016\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAR\u0003K\u0013aa\u0015;sS:<'bAAP\u000b\u00069\u0011n\u001d*fC\u0012L\u0018!E:fi>s'+Z1es\"\u000bg\u000e\u001a7feR!\u00111LAW\u0011\u001d\tYh\u0006a\u0001\u0003{\nQ\u0004Z5tC\ndW-Q;u_&s'm\\;oI\u001acwn^\"p]R\u0014x\u000e\u001c\u000b\u0003\u00037\nqA]3rk\u0016\u001cH\u000f\u0006\u0003\u0002\\\u0005]\u0006BBA]3\u0001\u0007a/A\u0001j\u0003U\u0019X\r^'fgN\fw-Z\"p[B\u0014Xm]:j_:$B!a\u0017\u0002@\"9\u0011\u0011\u0019\u000eA\u0002\u0005E\u0013!\u00012\u0002\r=tg*\u001a=u)\u0011\tY&a2\t\r\u0005%7\u00041\u0001>\u0003\u00051\u0018aB8o\u000bJ\u0014xN\u001d\u000b\u0005\u00037\ny\rC\u0004\u0002Rr\u0001\r!a5\u0002\u0013QD'o\\<bE2,\u0007\u0003BAk\u0003?tA!a6\u0002\\:!\u0011qSAm\u0013\u00051\u0015bAAo\u000b\u00069\u0001/Y2lC\u001e,\u0017\u0002BAq\u0003G\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005uW)A\u0006p]\u000e{W\u000e\u001d7fi\u0016$\u0017aG8oYf\u0014UMZ8sK\u000e{W\u000e\u001d7fi&|gn\u0014:FeJ|'\u000f\u0006\u0003\u0002\\\u0005-\b\u0002CAw=\u0011\u0005\r!a<\u0002\t\t|G-\u001f\t\u0006\t\u0006E\u00181L\u0005\u0004\u0003g,%\u0001\u0003\u001fcs:\fW.\u001a \u0002;\rDWmY6Vg\u0016\u0014(+[4iiN\u0014VM\u001a:fg\"$\u0016.\\3pkR$B!!?\u0003\bAA\u0011Q[A~\u0003\u007f\fY&\u0003\u0003\u0002~\u0006\r(AB#ji\",'\u000f\u0005\u0003\u0003\u0002\t\rQ\"A\u001c\n\u0007\t\u0015qG\u0001\fTi\u0006$Xo\u001d*v]RLW.Z#yG\u0016\u0004H/[8o\u0011\u0019\u0011Ia\ba\u00015\u0006\u0019an\\<\u0002#\rDWmY6DY\u0006LWn]#ya&\u0014\u0018\u0010\u0006\u0003\u0002z\n=\u0001B\u0002B\u0005A\u0001\u0007!,\u0001\u000bti\u0006dWm\u0015;sK\u0006l\u0017)\u001e;i\u000bJ\u0014xN]\u000b\u0003\u0003\u007f\fAd\u00148h_&tw-Q;uQ>\u0014\u0018N_1uS>twJY:feZ,'\u000f\u0005\u0002QGM\u00191Ea\u0007\u0011\u0007\u0011\u0013i\"C\u0002\u0003 \u0015\u0013a!\u00118z%\u00164GC\u0001B\f\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\u00119Ca\f\u0015!\t%\"\u0011\tB\"\u0005\u000b\u00129E!\u0013\u0003f\t\u001dDC\u0002B\u0016\u0005c\u0011\u0019\u0004\u0005\u00035w\t5\u0002c\u0001 \u00030\u0011)\u0001)\nb\u0001\u0005\"9\u0011\u0011B\u0013A\u0004\u0005-\u0001b\u0002B\u001bK\u0001\u000f!qG\u0001\u0003K\u000e\u0004BA!\u000f\u0003>5\u0011!1\b\u0006\u0003\u007f\u0016KAAa\u0010\u0003<\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0019\u0016\u0002\rAa\u000b\t\u000b5+\u0003\u0019\u0001(\t\u000bY+\u0003\u0019A,\t\u000b\t,\u0003\u0019A2\t\u000f\t-S\u00051\u0001\u0003N\u0005\u0019Ro]3s\u001b\u0006t\u0017mZ3nK:$8\u000b^8sKB!!q\nB1\u001b\t\u0011\tF\u0003\u0003\u0003T\tU\u0013A\u0001<3\u0015\u0011\u00119F!\u0017\u0002\u000b%tG-\u001a=\u000b\t\tm#QL\u0001\u0006gR\fG/\u001a\u0006\u0004\u0005?Z\u0013a\u00039beRL7-\u001b9b]RLAAa\u0019\u0003R\t\u0019Rk]3s\u001b\u0006t\u0017mZ3nK:$8\u000b^8sK\")Q/\na\u0001m\"9!\u0011N\u0013A\u0002\t-\u0014!D1lW\u0006\u001c6\r[3ek2,'\u000f\u0005\u0003\u0003n\t]TB\u0001B8\u0015\u0011\u0011\tHa\u001d\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\tU\u0014\u0001B1lW\u0006LAA!\u001f\u0003p\tI1k\u00195fIVdWM\u001d")
public final class OngoingAuthorizationObserver<A>
extends ServerCallStreamObserver<A> {
    private final ServerCallStreamObserver<A> observer;
    private final ClaimSet.Claims originalClaims;
    private final Function0<Instant> nowF;
    private final ErrorFactories errorFactories;
    private final int userRightsCheckIntervalInSeconds;
    private final AtomicReference<Instant> lastUserRightsCheckTime;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final DamlContextualizedErrorLogger errorLogger;
    private boolean afterCompletionOrError;
    private final Option<Function0<BoxedUnit>> cancelUserRightsChecksO;

    public static <A> ServerCallStreamObserver<A> apply(ServerCallStreamObserver<A> observer, ClaimSet.Claims originalClaims, Function0<Instant> nowF, ErrorFactories errorFactories, UserManagementStore userManagementStore, int userRightsCheckIntervalInSeconds, Scheduler akkaScheduler, LoggingContext loggingContext, ExecutionContext ec) {
        return OngoingAuthorizationObserver$.MODULE$.apply(observer, originalClaims, nowF, errorFactories, userManagementStore, userRightsCheckIntervalInSeconds, akkaScheduler, loggingContext, ec);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private DamlContextualizedErrorLogger errorLogger() {
        return this.errorLogger;
    }

    private boolean afterCompletionOrError() {
        return this.afterCompletionOrError;
    }

    private void afterCompletionOrError_$eq(boolean x$1) {
        this.afterCompletionOrError = x$1;
    }

    private Option<Function0<BoxedUnit>> cancelUserRightsChecksO() {
        return this.cancelUserRightsChecksO;
    }

    public synchronized boolean isCancelled() {
        return this.observer.isCancelled();
    }

    public synchronized void setOnCancelHandler(Runnable runnable) {
        this.observer.setOnCancelHandler(runnable);
    }

    public synchronized void setCompression(String s) {
        this.observer.setCompression(s);
    }

    public synchronized boolean isReady() {
        return this.observer.isReady();
    }

    public synchronized void setOnReadyHandler(Runnable runnable) {
        this.observer.setOnReadyHandler(runnable);
    }

    public synchronized void disableAutoInboundFlowControl() {
        this.observer.disableAutoInboundFlowControl();
    }

    public synchronized void request(int i) {
        this.observer.request(i);
    }

    public synchronized void setMessageCompression(boolean b) {
        this.observer.setMessageCompression(b);
    }

    public void onNext(A v) {
        this.onlyBeforeCompletionOrError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Instant now = (Instant)$this.nowF.apply();
            Either either = this.checkClaimsExpiry(now).flatMap((Function1 & Serializable)x$3 -> {
                BoxedUnit boxedUnit = x$3;
                Either either = this.checkUserRightsRefreshTimeout(now).map((Function1 & Serializable)x$2 -> {
                    OngoingAuthorizationObserver.$anonfun$onNext$3(x$2);
                    return BoxedUnit.UNIT;
                });
                return either;
            });
            if (either instanceof Right) {
                $this.observer.onNext(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (either instanceof Left) {
                Left left = (Left)either;
                StatusRuntimeException e = (StatusRuntimeException)left.value();
                this.onError((Throwable)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        });
    }

    public void onError(Throwable throwable) {
        this.onlyBeforeCompletionOrError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.afterCompletionOrError_$eq(true);
            this.cancelUserRightsChecksO().foreach((Function1 & Serializable)x$4 -> {
                x$4.apply$mcV$sp();
                return BoxedUnit.UNIT;
            });
            $this.observer.onError(throwable);
        });
    }

    public void onCompleted() {
        this.onlyBeforeCompletionOrError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.afterCompletionOrError_$eq(true);
            this.cancelUserRightsChecksO().foreach((Function1 & Serializable)x$5 -> {
                x$5.apply$mcV$sp();
                return BoxedUnit.UNIT;
            });
            $this.observer.onCompleted();
        });
    }

    private synchronized void onlyBeforeCompletionOrError(Function0<BoxedUnit> body) {
        block0: {
            if (this.afterCompletionOrError()) break block0;
            body.apply$mcV$sp();
        }
    }

    private Either<StatusRuntimeException, BoxedUnit> checkUserRightsRefreshTimeout(Instant now) {
        return this.originalClaims.resolvedFromUser() && this.lastUserRightsCheckTime.get().isBefore(now.minusSeconds(2L * (long)this.userRightsCheckIntervalInSeconds)) ? package$.MODULE$.Left().apply((Object)this.staleStreamAuthError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private Either<StatusRuntimeException, BoxedUnit> checkClaimsExpiry(Instant now) {
        return this.originalClaims.notExpired(now).left().map((Function1 & Serializable)authorizationError -> $this.errorFactories.permissionDenied(authorizationError.reason(), (ContextualizedErrorLogger)this.errorLogger()));
    }

    private StatusRuntimeException staleStreamAuthError() {
        return new LedgerApiErrors.AuthorizationChecks$.StaleUserManagementBasedStreamClaims$.Reject((ContextualizedErrorLogger)this.errorLogger()).asGrpcError();
    }

    public static final /* synthetic */ void $anonfun$onNext$3(BoxedUnit x$2) {
        BoxedUnit boxedUnit = x$2;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public OngoingAuthorizationObserver(ServerCallStreamObserver<A> observer, ClaimSet.Claims originalClaims, Function0<Instant> nowF, ErrorFactories errorFactories, Option<UserRightsChangeAsyncChecker> userRightsCheckerO, int userRightsCheckIntervalInSeconds, AtomicReference<Instant> lastUserRightsCheckTime, LoggingContext loggingContext) {
        this.observer = observer;
        this.originalClaims = originalClaims;
        this.nowF = nowF;
        this.errorFactories = errorFactories;
        this.userRightsCheckIntervalInSeconds = userRightsCheckIntervalInSeconds;
        this.lastUserRightsCheckTime = lastUserRightsCheckTime;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.afterCompletionOrError = false;
        this.cancelUserRightsChecksO = userRightsCheckerO.map((Function1 & Serializable)x$1 -> x$1.schedule((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.onError((Throwable)this.staleStreamAuthError()), $this.loggingContext));
    }
}

