/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.daml.ledger.api.auth.Claim;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$;
import com.daml.ledger.api.domain;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.lf.data.Ref$;
import com.daml.logging.LoggingContext;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005e4QAC\u0006\u0003\u0017UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011]\u0003!\u0011!Q\u0001\faCQ!\u0018\u0001\u0005\u0002yCQ\u0001\u001b\u0001\u0005\u0002%\u0014A$V:feJKw\r\u001b;t\u0007\"\fgnZ3Bgft7m\u00115fG.,'O\u0003\u0002\r\u001b\u0005!\u0011-\u001e;i\u0015\tqq\"A\u0002ba&T!\u0001E\t\u0002\r1,GmZ3s\u0015\t\u00112#\u0001\u0003eC6d'\"\u0001\u000b\u0002\u0007\r|Wn\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\fq\u0003\\1tiV\u001bXM\u001d*jO\"$8o\u00115fG.$\u0016.\\3\u0004\u0001A\u0019q\u0004\u000b\u0016\u000e\u0003\u0001R!!\t\u0012\u0002\r\u0005$x.\\5d\u0015\t\u0019C%\u0001\u0006d_:\u001cWO\u001d:f]RT!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0002O\u0005!!.\u0019<b\u0013\tI\u0003EA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\tYc&D\u0001-\u0015\tic%\u0001\u0003uS6,\u0017BA\u0018-\u0005\u001dIen\u001d;b]R\fab\u001c:jO&t\u0017\r\\\"mC&l7\u000f\u0005\u00023m9\u00111\u0007N\u0007\u0002\u0017%\u0011QgC\u0001\t\u00072\f\u0017.\\*fi&\u0011q\u0007\u000f\u0002\u0007\u00072\f\u0017.\\:\u000b\u0005UZ\u0011\u0001\u00028po\u001a\u00032aF\u001e+\u0013\ta\u0004DA\u0005Gk:\u001cG/[8oa\u0005\u0019Ro]3s\u001b\u0006t\u0017mZ3nK:$8\u000b^8sKB\u0011q\bS\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0003mJR!a\u0011#\u0002\u000b%tG-\u001a=\u000b\u0005\u00153\u0015!B:uCR,'BA$\u0010\u0003-\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;\n\u0005%\u0003%aE+tKJl\u0015M\\1hK6,g\u000e^*u_J,\u0017\u0001I;tKJ\u0014\u0016n\u001a5ug\u000eCWmY6J]R,'O^1m\u0013:\u001cVmY8oIN\u0004\"a\u0006'\n\u00055C\"aA%oi\u0006i\u0011m[6b'\u000eDW\rZ;mKJ\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003Q\u000bA!Y6lC&\u0011a+\u0015\u0002\n'\u000eDW\rZ;mKJ\f!!Z2\u0011\u0005e[V\"\u0001.\u000b\u0005\rB\u0012B\u0001/[\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\b?\n\u001cG-\u001a4h)\t\u0001\u0017\r\u0005\u00024\u0001!)q\u000b\u0003a\u00021\")A\u0004\u0003a\u0001=!)\u0001\u0007\u0003a\u0001c!)\u0011\b\u0003a\u0001u!)Q\b\u0003a\u0001}!)!\n\u0003a\u0001\u0017\")a\n\u0003a\u0001\u001f\u0006A1o\u00195fIVdW\r\u0006\u0002koR\u00111n\u001c\t\u0004/mb\u0007CA\fn\u0013\tq\u0007D\u0001\u0003V]&$\b\"\u00029\n\u0001\b\t\u0018A\u00047pO\u001eLgnZ\"p]R,\u0007\u0010\u001e\t\u0003eVl\u0011a\u001d\u0006\u0003iF\tq\u0001\\8hO&tw-\u0003\u0002wg\nqAj\\4hS:<7i\u001c8uKb$\b\"\u0002=\n\u0001\u0004Y\u0017AG;tKJ\u001cE.Y5ng6K7/\\1uG\"\u001c\u0015\r\u001c7cC\u000e\\\u0007")
public final class UserRightsChangeAsyncChecker {
    private final AtomicReference<Instant> lastUserRightsCheckTime;
    private final ClaimSet.Claims originalClaims;
    private final Function0<Instant> nowF;
    private final UserManagementStore userManagementStore;
    private final int userRightsCheckIntervalInSeconds;
    private final Scheduler akkaScheduler;
    private final ExecutionContext ec;

    public Function0<BoxedUnit> schedule(Function0<BoxedUnit> userClaimsMismatchCallback, LoggingContext loggingContext) {
        FiniteDuration delay = new package.DurationInt(package$.MODULE$.DurationInt(this.userRightsCheckIntervalInSeconds)).seconds();
        String userId = (String)this.originalClaims.applicationId().fold((Function0 & Serializable)() -> {
            throw new RuntimeException("Claims were resolved from a user but userId (applicationId) is missing in the claims.");
        }, (Function1 & Serializable)s -> (String)Ref$.MODULE$.UserId().assertFromString(s));
        Predef$.MODULE$.assert(this.originalClaims.resolvedFromUser(), (Function0 & Serializable)() -> "The claims were not resolved from a user. Expected claims resolved from a user.");
        Cancellable cancellable = this.akkaScheduler.scheduleWithFixedDelay(delay, delay, () -> $this.userManagementStore.listUserRights(userId, loggingContext).onComplete((Function1 & Serializable)x0$1 -> {
            UserRightsChangeAsyncChecker.$anonfun$schedule$5(this, userClaimsMismatchCallback, x0$1);
            return BoxedUnit.UNIT;
        }, $this.ec), this.ec);
        return (JFunction0.mcV.sp & Serializable)() -> cancellable.cancel();
    }

    public static final /* synthetic */ void $anonfun$schedule$5(UserRightsChangeAsyncChecker $this, Function0 userClaimsMismatchCallback$1, Try x0$1) {
        Success success;
        Either either;
        Success success2;
        Either either2;
        Try try_ = x0$1;
        boolean bl = try_ instanceof Failure ? true : try_ instanceof Success && (either2 = (Either)(success2 = (Success)try_).value()) instanceof Left;
        if (bl) {
            userClaimsMismatchCallback$1.apply$mcV$sp();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success && (either = (Either)(success = (Success)try_).value()) instanceof Right) {
            Right right = (Right)either;
            Set userRights = (Set)right.value();
            Seq<Claim> updatedClaims = AuthorizationInterceptor$.MODULE$.convertUserRightsToClaims((Set<domain.UserRight>)userRights);
            Set set = updatedClaims.toSet();
            Set set2 = $this.originalClaims.claims().toSet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                userClaimsMismatchCallback$1.apply$mcV$sp();
            }
            $this.lastUserRightsCheckTime.set((Instant)$this.nowF.apply());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public UserRightsChangeAsyncChecker(AtomicReference<Instant> lastUserRightsCheckTime, ClaimSet.Claims originalClaims, Function0<Instant> nowF, UserManagementStore userManagementStore, int userRightsCheckIntervalInSeconds, Scheduler akkaScheduler, ExecutionContext ec) {
        this.lastUserRightsCheckTime = lastUserRightsCheckTime;
        this.originalClaims = originalClaims;
        this.nowF = nowF;
        this.userManagementStore = userManagementStore;
        this.userRightsCheckIntervalInSeconds = userRightsCheckIntervalInSeconds;
        this.akkaScheduler = akkaScheduler;
        this.ec = ec;
    }
}

