/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth.interceptor;

import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.Claim;
import com.daml.ledger.api.auth.ClaimActAsParty;
import com.daml.ledger.api.auth.ClaimAdmin$;
import com.daml.ledger.api.auth.ClaimPublic$;
import com.daml.ledger.api.auth.ClaimReadAsParty;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor;
import com.daml.ledger.api.domain;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.lf.data.Ref$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import io.grpc.Context;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class AuthorizationInterceptor$ {
    public static final AuthorizationInterceptor$ MODULE$ = new AuthorizationInterceptor$();
    private static final Context.Key<ClaimSet> contextKeyClaimSet = Context.key((String)"AuthServiceDecodedClaim");

    public Context.Key<ClaimSet> contextKeyClaimSet() {
        return contextKeyClaimSet;
    }

    public Try<ClaimSet> extractClaimSetFromContext() {
        ClaimSet claimSet = (ClaimSet)this.contextKeyClaimSet().get();
        return claimSet == null ? new Failure((Throwable)new RuntimeException("Thread local context unexpectedly does not store authorization claims. Perhaps a Future was used in some intermediate computation and changed the executing thread?")) : new Success((Object)claimSet);
    }

    public AuthorizationInterceptor apply(AuthService authService, Option<UserManagementStore> userManagementStoreO, ExecutionContext ec) {
        return (AuthorizationInterceptor)LoggingContext$.MODULE$.newLoggingContext((Function1 & Serializable)loggingContext -> new AuthorizationInterceptor(authService, userManagementStoreO, ec, (LoggingContext)loggingContext));
    }

    public Seq<Claim> convertUserRightsToClaims(Set<domain.UserRight> userRights) {
        return ((IterableOnceOps)userRights.view().map((Function1 & Serializable)r -> MODULE$.userRightToClaim((domain.UserRight)r))).toList().prepended((Object)ClaimPublic$.MODULE$);
    }

    private Claim userRightToClaim(domain.UserRight r) {
        Claim claim;
        domain.UserRight userRight = r;
        if (userRight instanceof domain.UserRight$.CanActAs) {
            domain.UserRight$.CanActAs canActAs = (domain.UserRight$.CanActAs)userRight;
            String p = canActAs.party();
            claim = new ClaimActAsParty((String)Ref$.MODULE$.Party().assertFromString(p));
        } else if (userRight instanceof domain.UserRight$.CanReadAs) {
            domain.UserRight$.CanReadAs canReadAs = (domain.UserRight$.CanReadAs)userRight;
            String p = canReadAs.party();
            claim = new ClaimReadAsParty((String)Ref$.MODULE$.Party().assertFromString(p));
        } else if (domain.UserRight$.ParticipantAdmin$.MODULE$.equals(userRight)) {
            claim = ClaimAdmin$.MODULE$;
        } else {
            throw new MatchError((Object)userRight);
        }
        return claim;
    }

    private AuthorizationInterceptor$() {
    }
}

