/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth.interceptor;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.LedgerApiErrors;
import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.Claim;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.interceptor.AsyncForwardingListener;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$;
import com.daml.ledger.api.domain;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.lf.data.Ref$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.server.api.validation.ErrorFactories;
import com.daml.platform.server.api.validation.ErrorFactories$;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\teb\u0001\u0002\u000e\u001c\u0005!B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A\u0011\u000b\u0001BC\u0002\u0013\r!\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003T\u0011!Q\u0006A!A!\u0002\u0017Y\u0006\"B1\u0001\t\u0003\u0011\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00027\t\u000fA\u0004!\u0019!C\u0005c\"1\u0001\u0010\u0001Q\u0001\nIDq!\u001f\u0001C\u0002\u0013%!\u0010C\u0004\u0002\u000e\u0001\u0001\u000b\u0011B>\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!A\u0011Q\f\u0001!\n\u0013\ty\u0006\u0003\u0005\u0002r\u0001\u0001K\u0011BA:\u0011!\tI\b\u0001Q\u0005\n\u0005mtaBAY7!\u0005\u00111\u0017\u0004\u00075mA\t!!.\t\r\u0005\u0014B\u0011AA_\u0011)\tyL\u0005b\u0001\n\u0003i\u0012\u0011\u0019\u0005\t\u0003#\u0014\u0002\u0015!\u0003\u0002D\"9\u00111\u001b\n\u0005\u0002\u0005U\u0007bBAr%\u0011\u0005\u0011Q\u001d\u0005\b\u0003[\u0014B\u0011AAx\u0011!\u0011\tD\u0005Q\u0005\n\tM\"\u0001G!vi\"|'/\u001b>bi&|g.\u00138uKJ\u001cW\r\u001d;pe*\u0011A$H\u0001\fS:$XM]2faR|'O\u0003\u0002\u001f?\u0005!\u0011-\u001e;i\u0015\t\u0001\u0013%A\u0002ba&T!AI\u0012\u0002\r1,GmZ3s\u0015\t!S%\u0001\u0003eC6d'\"\u0001\u0014\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001I\u0013\u0007\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!A.\u00198h\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\r=\u0013'.Z2u!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003heB\u001c'\"\u0001\u001c\u0002\u0005%|\u0017B\u0001\u001d4\u0005E\u0019VM\u001d<fe&sG/\u001a:dKB$xN]\u0001\fCV$\bnU3sm&\u001cW\r\u0005\u0002<y5\tQ$\u0003\u0002>;\tY\u0011)\u001e;i'\u0016\u0014h/[2f\u0003Q)8/\u001a:NC:\fw-Z7f]R\u001cFo\u001c:f\u001fB\u0019\u0001iQ#\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013aa\u00149uS>t\u0007C\u0001$P\u001b\u00059%B\u0001%J\u0003\t1(G\u0003\u0002K\u0017\u0006)\u0011N\u001c3fq*\u0011A*T\u0001\u0006gR\fG/\u001a\u0006\u0003\u001d\u0006\n1\u0002]1si&\u001c\u0017\u000e]1oi&\u0011\u0001k\u0012\u0002\u0014+N,'/T1oC\u001e,W.\u001a8u'R|'/Z\u0001\u0003K\u000e,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0006\u000b!bY8oGV\u0014(/\u001a8u\u0013\tAVK\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB\u0011AlX\u0007\u0002;*\u0011alI\u0001\bY><w-\u001b8h\u0013\t\u0001WL\u0001\bM_\u001e<\u0017N\\4D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0011\u0019w\r[5\u0015\u0005\u00114\u0007CA3\u0001\u001b\u0005Y\u0002\"\u0002.\u0007\u0001\bY\u0006\"B\u001d\u0007\u0001\u0004Q\u0004\"\u0002 \u0007\u0001\u0004y\u0004\"B)\u0007\u0001\b\u0019\u0016A\u00027pO\u001e,'/F\u0001m!\taV.\u0003\u0002o;\n!2i\u001c8uKb$X/\u00197ju\u0016$Gj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006feJ|'\u000fT8hO\u0016\u0014X#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U\u001c\u0013!B3se>\u0014\u0018BA<u\u0005u!\u0015-\u001c7D_:$X\r\u001f;vC2L'0\u001a3FeJ|'\u000fT8hO\u0016\u0014\u0018\u0001D3se>\u0014Hj\\4hKJ\u0004\u0013AD3se>\u0014h)Y2u_JLWm]\u000b\u0002wB\u0019A0!\u0003\u000e\u0003uT!A`@\u0002\u0015Y\fG.\u001b3bi&|gNC\u0002!\u0003\u0003QA!a\u0001\u0002\u0006\u000511/\u001a:wKJT1!a\u0002$\u0003!\u0001H.\u0019;g_Jl\u0017bAA\u0006{\nqQI\u001d:pe\u001a\u000b7\r^8sS\u0016\u001c\u0018aD3se>\u0014h)Y2u_JLWm\u001d\u0011\u0002\u001b%tG/\u001a:dKB$8)\u00197m+\u0019\t\u0019\"a\n\u0002FQA\u0011QCA\u001d\u0003\u0013\n\u0019\u0006\u0005\u0004\u0002\u0018\u0005u\u00111\u0005\b\u0004e\u0005e\u0011bAA\u000eg\u0005Q1+\u001a:wKJ\u001c\u0015\r\u001c7\n\t\u0005}\u0011\u0011\u0005\u0002\t\u0019&\u001cH/\u001a8fe*\u0019\u00111D\u001a\u0011\t\u0005\u0015\u0012q\u0005\u0007\u0001\t\u001d\tI#\u0004b\u0001\u0003W\u0011AAU3r)F!\u0011QFA\u001a!\r\u0001\u0015qF\u0005\u0004\u0003c\t%a\u0002(pi\"Lgn\u001a\t\u0004\u0001\u0006U\u0012bAA\u001c\u0003\n\u0019\u0011I\\=\t\u000f\u0005mR\u00021\u0001\u0002>\u0005!1-\u00197m!\u001d\u0011\u0014qHA\u0012\u0003\u0007J1!!\u00114\u0005)\u0019VM\u001d<fe\u000e\u000bG\u000e\u001c\t\u0005\u0003K\t)\u0005B\u0004\u0002H5\u0011\r!a\u000b\u0003\u000bI+7\u000f\u001d+\t\u000f\u0005-S\u00021\u0001\u0002N\u00059\u0001.Z1eKJ\u001c\bc\u0001\u001a\u0002P%\u0019\u0011\u0011K\u001a\u0003\u00115+G/\u00193bi\u0006Dq!!\u0016\u000e\u0001\u0004\t9&\u0001\u0007oKb$H*[:uK:,'\u000fE\u00043\u00033\n\u0019#a\u0011\n\u0007\u0005m3GA\tTKJ4XM]\"bY2D\u0015M\u001c3mKJ\faD]3t_24X-Q;uQ\u0016tG/[2bi\u0016$Wk]3s%&<\u0007\u000e^:\u0015\t\u0005\u0005\u0014Q\u000e\t\u0006)\u0006\r\u0014qM\u0005\u0004\u0003K*&A\u0002$viV\u0014X\rE\u0002<\u0003SJ1!a\u001b\u001e\u0005!\u0019E.Y5n'\u0016$\bbBA8\u001d\u0001\u0007\u0011qM\u0001\tG2\f\u0017.\\*fi\u00061r-\u001a;Vg\u0016\u0014X*\u00198bO\u0016lWM\u001c;Ti>\u0014X\r\u0006\u0003\u0002v\u0005]\u0004\u0003\u0002+\u0002d\u0015CQAP\bA\u0002}\n\u0011bZ3u+N,'/\u00133\u0015\t\u0005u\u0014q\u0013\t\u0006)\u0006\r\u0014q\u0010\t\u0005\u0003\u0003\u000b\tJ\u0004\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003\u0017\u001b\u0013A\u00017g\u0013\u0011\ty)!\"\u0002\u0007I+g-\u0003\u0003\u0002\u0014\u0006U%AB+tKJLEM\u0003\u0003\u0002\u0010\u0006\u0015\u0005bBAM!\u0001\u0007\u00111T\u0001\nkN,'/\u00133TiJ\u0004B!!(\u0002,:!\u0011qTAT!\r\t\t+Q\u0007\u0003\u0003GS1!!*(\u0003\u0019a$o\\8u}%\u0019\u0011\u0011V!\u0002\rA\u0013X\rZ3g\u0013\u0011\ti+a,\u0003\rM#(/\u001b8h\u0015\r\tI+Q\u0001\u0019\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8J]R,'oY3qi>\u0014\bCA3\u0013'\r\u0011\u0012q\u0017\t\u0004\u0001\u0006e\u0016bAA^\u0003\n1\u0011I\\=SK\u001a$\"!a-\u0002%\r|g\u000e^3yi.+\u0017p\u00117bS6\u001cV\r^\u000b\u0003\u0003\u0007\u0004b!!2\u0002L\u0006\u001ddb\u0001\u001a\u0002H&\u0019\u0011\u0011Z\u001a\u0002\u000f\r{g\u000e^3yi&!\u0011QZAh\u0005\rYU-\u001f\u0006\u0004\u0003\u0013\u001c\u0014aE2p]R,\u0007\u0010^&fs\u000ec\u0017-[7TKR\u0004\u0013AG3yiJ\f7\r^\"mC&l7+\u001a;Ge>l7i\u001c8uKb$HCAAl!\u0019\tI.a8\u0002h5\u0011\u00111\u001c\u0006\u0004\u0003;\f\u0015\u0001B;uS2LA!!9\u0002\\\n\u0019AK]=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0011\f9/!;\u0002l\")\u0011h\u0006a\u0001u!)ah\u0006a\u0001\u007f!)\u0011k\u0006a\u0001'\u0006I2m\u001c8wKJ$Xk]3s%&<\u0007\u000e^:U_\u000ec\u0017-[7t)\u0011\t\tP!\u0003\u0011\r\u0005M\u0018Q B\u0002\u001d\u0011\t)0!?\u000f\t\u0005\u0005\u0016q_\u0005\u0002\u0005&\u0019\u00111`!\u0002\u000fA\f7m[1hK&!\u0011q B\u0001\u0005\r\u0019V-\u001d\u0006\u0004\u0003w\f\u0005cA\u001e\u0003\u0006%\u0019!qA\u000f\u0003\u000b\rc\u0017-[7\t\u000f\t-\u0001\u00041\u0001\u0003\u000e\u0005QQo]3s%&<\u0007\u000e^:\u0011\r\u0005u%q\u0002B\n\u0013\u0011\u0011\t\"a,\u0003\u0007M+G\u000f\u0005\u0003\u0003\u0016\t-b\u0002\u0002B\f\u0005OqAA!\u0007\u0003&9!!1\u0004B\u0012\u001d\u0011\u0011iB!\t\u000f\t\u0005\u0005&qD\u0005\u0002M%\u0011A%J\u0005\u0003E\rJ!\u0001I\u0011\n\u0007\t%r$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0005[\u0011yCA\u0005Vg\u0016\u0014(+[4ii*\u0019!\u0011F\u0010\u0002!U\u001cXM\u001d*jO\"$Hk\\\"mC&lG\u0003\u0002B\u0002\u0005kAqAa\u000e\u001a\u0001\u0004\u0011\u0019\"A\u0001s\u0001")
public final class AuthorizationInterceptor
implements ServerInterceptor {
    public final AuthService com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$authService;
    private final Option<UserManagementStore> userManagementStoreO;
    private final ExecutionContext ec;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final DamlContextualizedErrorLogger com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger;
    private final ErrorFactories com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorFactories;

    public static Seq<Claim> convertUserRightsToClaims(Set<domain.UserRight> userRights) {
        return AuthorizationInterceptor$.MODULE$.convertUserRightsToClaims(userRights);
    }

    public static AuthorizationInterceptor apply(AuthService authService, Option<UserManagementStore> userManagementStoreO, ExecutionContext ec) {
        return AuthorizationInterceptor$.MODULE$.apply(authService, userManagementStoreO, ec);
    }

    public static Try<ClaimSet> extractClaimSetFromContext() {
        return AuthorizationInterceptor$.MODULE$.extractClaimSetFromContext();
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public DamlContextualizedErrorLogger com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger() {
        return this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger;
    }

    public ErrorFactories com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorFactories() {
        return this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorFactories;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> nextListener) {
        Context prevCtx = Context.current();
        return new AsyncForwardingListener<ReqT>(this, headers, prevCtx, call, nextListener){
            private final /* synthetic */ AuthorizationInterceptor $outer;
            private final ServerCall call$1;

            private ServerCall.Listener<Nothing$> closeWithError(StatusRuntimeException error) {
                this.call$1.close(error.getStatus(), error.getTrailers());
                return new ServerCall.Listener<Nothing$>(null){};
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.call$1 = call$1;
                FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps($outer.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$authService.decodeMetadata(headers$1))).flatMap((Function1 & Serializable)claimSet -> $this.$outer.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$resolveAuthenticatedUserRights((ClaimSet)claimSet), $outer.ec()).onComplete((Function1 & Serializable)x0$1 -> {
                    Throwable exception;
                    boolean bl = false;
                    Failure failure = null;
                    Try try_ = x0$1;
                    if (try_ instanceof Failure) {
                        bl = true;
                        failure = (Failure)try_;
                        Throwable error = failure.exception();
                        if (error instanceof StatusRuntimeException) {
                            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)error;
                            return this.closeWithError(statusRuntimeException);
                        }
                    }
                    if (bl && (exception = failure.exception()) != null) {
                        Throwable throwable = exception;
                        StatusRuntimeException error = $this.$outer.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorFactories().internalAuthenticationError("Failed to get claims from request metadata", throwable, (ContextualizedErrorLogger)$this.$outer.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger());
                        return this.closeWithError(error);
                    }
                    if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                    Success success = (Success)try_;
                    ClaimSet claimSet = (ClaimSet)success.value();
                    Context nextCtx = prevCtx$1.withValue(AuthorizationInterceptor$.MODULE$.contextKeyClaimSet(), (Object)claimSet);
                    ServerCall.Listener nextListenerWithContext = Contexts.interceptCall((Context)nextCtx, (ServerCall)call$1, (Metadata)headers$1, (ServerCallHandler)nextListener$1);
                    this.setNextListener(nextListenerWithContext);
                    return nextListenerWithContext;
                }, $outer.ec());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$$anon$1 com.daml.ledger.api.auth.ClaimSet ), $anonfun$new$2(com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$$anon$1 io.grpc.Context io.grpc.ServerCall io.grpc.Metadata io.grpc.ServerCallHandler scala.util.Try )}, serializedLambda);
            }
        };
    }

    public Future<ClaimSet> com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$resolveAuthenticatedUserRights(ClaimSet claimSet) {
        Future future;
        ClaimSet claimSet2 = claimSet;
        if (claimSet2 instanceof ClaimSet.AuthenticatedUser) {
            ClaimSet.AuthenticatedUser authenticatedUser = (ClaimSet.AuthenticatedUser)claimSet2;
            String userIdStr = authenticatedUser.userId();
            Option<String> participantId = authenticatedUser.participantId();
            Option<Instant> expiration = authenticatedUser.expiration();
            future = this.getUserManagementStore(this.userManagementStoreO).flatMap((Function1 & Serializable)userManagementStore -> this.getUserId(userIdStr).flatMap((Function1 & Serializable)userId -> userManagementStore.listUserRights(userId, $this.loggingContext).flatMap((Function1 & Serializable)userRightsResult -> {
                Right right;
                Set userRights;
                Future future;
                Either either = userRightsResult;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    UserManagementStore.Error msg = (UserManagementStore.Error)left.value();
                    future = Future$.MODULE$.failed((Throwable)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorFactories().permissionDenied(new StringBuilder(46).append("Could not resolve rights for user '").append((String)userId).append("' due to '").append(msg).append("'").toString(), (ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()));
                } else if (either instanceof Right && (userRights = (Set)(right = (Right)either).value()) != null) {
                    Set set = userRights;
                    future = Future$.MODULE$.successful((Object)new ClaimSet.Claims(AuthorizationInterceptor$.MODULE$.convertUserRightsToClaims((Set<domain.UserRight>)set), (Option<String>)None$.MODULE$, participantId, (Option<String>)new Some(userId), expiration, true));
                } else {
                    throw new MatchError((Object)either);
                }
                return future.map((Function1 & Serializable)claimsSet -> claimsSet, this.ec());
            }, this.ec()), this.ec()), this.ec());
        } else {
            future = Future$.MODULE$.successful((Object)claimSet);
        }
        return future;
    }

    private Future<UserManagementStore> getUserManagementStore(Option<UserManagementStore> userManagementStoreO) {
        Future future;
        Option<UserManagementStore> option = userManagementStoreO;
        if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.failed((Throwable)new LedgerApiErrors.AuthorizationChecks$.Unauthenticated$.UserBasedAuthenticationIsDisabled((ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()).asGrpcError());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            UserManagementStore userManagementStore = (UserManagementStore)some.value();
            future = Future$.MODULE$.successful((Object)userManagementStore);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    private Future<String> getUserId(String userIdStr) {
        Future future;
        Either either = Ref$.MODULE$.UserId().fromString(userIdStr);
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            future = Future$.MODULE$.failed((Throwable)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorFactories().invalidArgument(new StringBuilder(6).append("token ").append(err).toString(), (ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            String userId = (String)right.value();
            future = Future$.MODULE$.successful((Object)userId);
        } else {
            throw new MatchError((Object)either);
        }
        return future;
    }

    public AuthorizationInterceptor(AuthService authService, Option<UserManagementStore> userManagementStoreO, ExecutionContext ec, LoggingContext loggingContext) {
        this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$authService = authService;
        this.userManagementStoreO = userManagementStoreO;
        this.ec = ec;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorFactories = ErrorFactories$.MODULE$.apply();
    }
}

