/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth.services;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.LedgerApiErrors;
import com.daml.ledger.api.auth.Authorizer;
import com.daml.ledger.api.v1.admin.user_management_service.CreateUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersRequest;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersResponse;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc$;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc$UserManagementService$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.server.api.ProxyCloseable;
import io.grpc.ServerServiceDefinition;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005-h!\u0002\f\u0018\u0005}\u0019\u0003\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011\u0003&\t\u0011Y\u0003!\u0011!Q\u0001\n-C\u0001b\u0016\u0001\u0003\u0006\u0004%I\u0001\u0017\u0005\t;\u0002\u0011\t\u0011)A\u00053\"Aa\f\u0001B\u0001B\u0003-q\f\u0003\u0005f\u0001\t\u0005\t\u0015a\u0003g\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001d9\bA1A\u0005\naDa\u0001 \u0001!\u0002\u0013I\bbB?\u0001\u0005\u0004%YA \u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003\u0000\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002<\u0001!\t%!\u0010\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\ty\n\u0001C!\u0003CCq!!-\u0001\t\u0003\n\u0019\fC\u0004\u0002<\u0002!I!!0\u0003EU\u001bXM]'b]\u0006<W-\\3oiN+'O^5dK\u0006+H\u000f[8sSj\fG/[8o\u0015\tA\u0012$\u0001\u0005tKJ4\u0018nY3t\u0015\tQ2$\u0001\u0003bkRD'B\u0001\u000f\u001e\u0003\r\t\u0007/\u001b\u0006\u0003=}\ta\u0001\\3eO\u0016\u0014(B\u0001\u0011\"\u0003\u0011!\u0017-\u001c7\u000b\u0003\t\n1aY8n'\u0015\u0001AE\u000b\u001dB!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111&\u000e\b\u0003YMj\u0011!\f\u0006\u0003]=\nq#^:fe~k\u0017M\\1hK6,g\u000e^0tKJ4\u0018nY3\u000b\u0005A\n\u0014!B1e[&t'B\u0001\u001a\u001c\u0003\t1\u0018'\u0003\u00025[\u0005IRk]3s\u001b\u0006t\u0017mZ3nK:$8+\u001a:wS\u000e,wI\u001d9d\u0013\t1tGA\u000bVg\u0016\u0014X*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3\u000b\u0005Qj\u0003CA\u001d@\u001b\u0005Q$B\u0001\u000f<\u0015\taT(\u0001\u0004tKJ4XM\u001d\u0006\u0003}}\t\u0001\u0002\u001d7bi\u001a|'/\\\u0005\u0003\u0001j\u0012a\u0002\u0015:pqf\u001cEn\\:fC\ndW\r\u0005\u0002C\r6\t1I\u0003\u0002E\u000b\u0006!qM\u001d9d\u0015\taR(\u0003\u0002H\u0007\nqqI\u001d9d\u0003BL7+\u001a:wS\u000e,\u0017aB:feZL7-Z\u0002\u0001+\u0005Y%c\u0001'+\u001d\u001a!Q\n\u0001\u0001L\u00051a$/\u001a4j]\u0016lWM\u001c;?!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0003mC:<'\"A*\u0002\t)\fg/Y\u0005\u0003+B\u0013Q\"Q;u_\u000ecwn]3bE2,\u0017\u0001C:feZL7-\u001a\u0011\u0002\u0015\u0005,H\u000f[8sSj,'/F\u0001Z!\tQ6,D\u0001\u001a\u0013\ta\u0016D\u0001\u0006BkRDwN]5{KJ\f1\"Y;uQ>\u0014\u0018N_3sA\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0003A\u000el\u0011!\u0019\u0006\u0003E\u001a\n!bY8oGV\u0014(/\u001a8u\u0013\t!\u0017M\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006qAn\\4hS:<7i\u001c8uKb$\bCA4k\u001b\u0005A'BA5 \u0003\u001dawnZ4j]\u001eL!a\u001b5\u0003\u001d1{wmZ5oO\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2A\\:w)\ry\u0017O\u001d\t\u0003a\u0002i\u0011a\u0006\u0005\u0006=\u001e\u0001\u001da\u0018\u0005\u0006K\u001e\u0001\u001dA\u001a\u0005\u0006\u0011\u001e\u0001\r\u0001\u001e\n\u0004k*re\u0001B'\u0001\u0001QDQaV\u0004A\u0002e\u000ba\u0001\\8hO\u0016\u0014X#A=\u0011\u0005\u001dT\u0018BA>i\u0005Q\u0019uN\u001c;fqR,\u0018\r\\5{K\u0012dunZ4fe\u00069An\\4hKJ\u0004\u0013aC3se>\u0014Hj\\4hKJ,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0010\u0002\u000b\u0015\u0014(o\u001c:\n\t\u0005%\u00111\u0001\u0002\u001a\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'/\u0001\u0007feJ|'\u000fT8hO\u0016\u0014\b%\u0001\u0006de\u0016\fG/Z+tKJ$B!!\u0005\u0002\u001eA)\u0001-a\u0005\u0002\u0018%\u0019\u0011QC1\u0003\r\u0019+H/\u001e:f!\ra\u0013\u0011D\u0005\u0004\u00037i#AE\"sK\u0006$X-V:feJ+7\u000f]8og\u0016Dq!a\b\r\u0001\u0004\t\t#A\u0004sKF,Xm\u001d;\u0011\u00071\n\u0019#C\u0002\u0002&5\u0012\u0011c\u0011:fCR,Wk]3s%\u0016\fX/Z:u\u0003\u001d9W\r^+tKJ$B!a\u000b\u00024A)\u0001-a\u0005\u0002.A\u0019A&a\f\n\u0007\u0005ERFA\bHKR,6/\u001a:SKN\u0004xN\\:f\u0011\u001d\ty\"\u0004a\u0001\u0003k\u00012\u0001LA\u001c\u0013\r\tI$\f\u0002\u000f\u000f\u0016$Xk]3s%\u0016\fX/Z:u\u0003)!W\r\\3uKV\u001bXM\u001d\u000b\u0005\u0003\u007f\t9\u0005E\u0003a\u0003'\t\t\u0005E\u0002-\u0003\u0007J1!!\u0012.\u0005I!U\r\\3uKV\u001bXM\u001d*fgB|gn]3\t\u000f\u0005}a\u00021\u0001\u0002JA\u0019A&a\u0013\n\u0007\u00055SFA\tEK2,G/Z+tKJ\u0014V-];fgR\f\u0011\u0002\\5tiV\u001bXM]:\u0015\t\u0005M\u00131\f\t\u0006A\u0006M\u0011Q\u000b\t\u0004Y\u0005]\u0013bAA-[\t\tB*[:u+N,'o\u001d*fgB|gn]3\t\u000f\u0005}q\u00021\u0001\u0002^A\u0019A&a\u0018\n\u0007\u0005\u0005TF\u0001\tMSN$Xk]3sgJ+\u0017/^3ti\u0006yqM]1oiV\u001bXM\u001d*jO\"$8\u000f\u0006\u0003\u0002h\u0005=\u0004#\u00021\u0002\u0014\u0005%\u0004c\u0001\u0017\u0002l%\u0019\u0011QN\u0017\u0003/\u001d\u0013\u0018M\u001c;Vg\u0016\u0014(+[4iiN\u0014Vm\u001d9p]N,\u0007bBA\u0010!\u0001\u0007\u0011\u0011\u000f\t\u0004Y\u0005M\u0014bAA;[\t1rI]1oiV\u001bXM\u001d*jO\"$8OU3rk\u0016\u001cH/\u0001\tsKZ|7.Z+tKJ\u0014\u0016n\u001a5ugR!\u00111PAB!\u0015\u0001\u00171CA?!\ra\u0013qP\u0005\u0004\u0003\u0003k#\u0001\u0007*fm>\\W-V:feJKw\r\u001b;t%\u0016\u001c\bo\u001c8tK\"9\u0011qD\tA\u0002\u0005\u0015\u0005c\u0001\u0017\u0002\b&\u0019\u0011\u0011R\u0017\u0003/I+go\\6f+N,'OU5hQR\u001c(+Z9vKN$\u0018A\u00047jgR,6/\u001a:SS\u001eDGo\u001d\u000b\u0005\u0003\u001f\u000b9\nE\u0003a\u0003'\t\t\nE\u0002-\u0003'K1!!&.\u0005Ya\u0015n\u001d;Vg\u0016\u0014(+[4iiN\u0014Vm\u001d9p]N,\u0007bBA\u0010%\u0001\u0007\u0011\u0011\u0014\t\u0004Y\u0005m\u0015bAAO[\t)B*[:u+N,'OU5hQR\u001c(+Z9vKN$\u0018a\u00032j]\u0012\u001cVM\u001d<jG\u0016$\"!a)\u0011\t\u0005\u0015\u0016QV\u0007\u0003\u0003OS1\u0001RAU\u0015\t\tY+\u0001\u0002j_&!\u0011qVAT\u0005]\u0019VM\u001d<feN+'O^5dK\u0012+g-\u001b8ji&|g.A\u0003dY>\u001cX\r\u0006\u0002\u00026B\u0019Q%a.\n\u0007\u0005efE\u0001\u0003V]&$\u0018A\u00073fM\u0006,H\u000e\u001e+p\u0003V$\b.\u001a8uS\u000e\fG/\u001a3Vg\u0016\u0014H\u0003BA`\u0003O\u0004b!!1\u0002H\u0006-WBAAb\u0015\r\t)MJ\u0001\u0005kRLG.\u0003\u0003\u0002J\u0006\r'a\u0001+ssB)Q%!4\u0002R&\u0019\u0011q\u001a\u0014\u0003\r=\u0003H/[8o!\u0011\t\u0019.!9\u000f\t\u0005U\u0017Q\u001c\t\u0004\u0003/4SBAAm\u0015\r\tY.S\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}g%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\f)O\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?4\u0003bBAu+\u0001\u0007\u0011\u0011[\u0001\u0007kN,'/\u00133")
public final class UserManagementServiceAuthorization
implements UserManagementServiceGrpc.UserManagementService,
ProxyCloseable,
GrpcApiService {
    private final UserManagementServiceGrpc.UserManagementService service;
    private final Authorizer authorizer;
    private final ExecutionContext executionContext;
    private final ContextualizedLogger logger;
    private final ContextualizedErrorLogger errorLogger;

    public UserManagementServiceGrpc$UserManagementService$ serviceCompanion() {
        return UserManagementServiceGrpc.UserManagementService.serviceCompanion$((UserManagementServiceGrpc.UserManagementService)this);
    }

    public UserManagementServiceGrpc.UserManagementService service() {
        return this.service;
    }

    private Authorizer authorizer() {
        return this.authorizer;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private ContextualizedErrorLogger errorLogger() {
        return this.errorLogger;
    }

    public Future<CreateUserResponse> createUser(CreateUserRequest request2) {
        return (Future)this.authorizer().requireAdminClaims((Function1 & Serializable)request -> this.service().createUser(request)).apply((Object)request2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<GetUserResponse> getUser(GetUserRequest request2) {
        boolean bl = false;
        Success success = null;
        Try<Option<String>> try_ = this.defaultToAuthenticatedUser(request2.userId());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            return Future$.MODULE$.failed(ex);
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option = (Option)success.value();
            if (option instanceof Some) {
                Some some = (Some)option;
                String userId = (String)some.value();
                return this.service().getUser(request2.copy(userId));
            }
        }
        if (!bl) throw new MatchError(try_);
        Option option = (Option)success.value();
        if (!None$.MODULE$.equals(option)) throw new MatchError(try_);
        return (Future)this.authorizer().requireAdminClaims((Function1 & Serializable)request -> this.service().getUser(request)).apply((Object)request2);
    }

    public Future<DeleteUserResponse> deleteUser(DeleteUserRequest request2) {
        return (Future)this.authorizer().requireAdminClaims((Function1 & Serializable)request -> this.service().deleteUser(request)).apply((Object)request2);
    }

    public Future<ListUsersResponse> listUsers(ListUsersRequest request2) {
        return (Future)this.authorizer().requireAdminClaims((Function1 & Serializable)request -> this.service().listUsers(request)).apply((Object)request2);
    }

    public Future<GrantUserRightsResponse> grantUserRights(GrantUserRightsRequest request2) {
        return (Future)this.authorizer().requireAdminClaims((Function1 & Serializable)request -> this.service().grantUserRights(request)).apply((Object)request2);
    }

    public Future<RevokeUserRightsResponse> revokeUserRights(RevokeUserRightsRequest request2) {
        return (Future)this.authorizer().requireAdminClaims((Function1 & Serializable)request -> this.service().revokeUserRights(request)).apply((Object)request2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<ListUserRightsResponse> listUserRights(ListUserRightsRequest request2) {
        boolean bl = false;
        Success success = null;
        Try<Option<String>> try_ = this.defaultToAuthenticatedUser(request2.userId());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            return Future$.MODULE$.failed(ex);
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option = (Option)success.value();
            if (option instanceof Some) {
                Some some = (Some)option;
                String userId = (String)some.value();
                return this.service().listUserRights(request2.copy(userId));
            }
        }
        if (!bl) throw new MatchError(try_);
        Option option = (Option)success.value();
        if (!None$.MODULE$.equals(option)) throw new MatchError(try_);
        return (Future)this.authorizer().requireAdminClaims((Function1 & Serializable)request -> this.service().listUserRights(request)).apply((Object)request2);
    }

    public ServerServiceDefinition bindService() {
        return UserManagementServiceGrpc$.MODULE$.bindService((UserManagementServiceGrpc.UserManagementService)this, this.executionContext);
    }

    public void close() {
        ((AutoCloseable)this.service()).close();
    }

    private Try<Option<String>> defaultToAuthenticatedUser(String userId) {
        return this.authorizer().authenticatedUserId().flatMap((Function1 & Serializable)x0$1 -> {
            void var3_10;
            Option option;
            block4: {
                String authUserId;
                block5: {
                    option = x0$1;
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    authUserId = (String)some.value();
                    if (userId.isEmpty()) break block5;
                    String string = userId;
                    String string2 = authUserId;
                    if (string != null ? !string.equals(string2) : string2 != null) break block4;
                }
                Success success = new Success((Object)new Some((Object)authUserId));
                return var3_10;
            }
            if (None$.MODULE$.equals(option) && userId.isEmpty()) {
                Failure failure = new Failure((Throwable)new LedgerApiErrors.RequestValidation$.InvalidArgument$.Reject("requests with an empty user-id are only supported if there is an authenticated user", this.errorLogger()).asGrpcError());
                return var3_10;
            }
            Success success = new Success((Object)None$.MODULE$);
            return var3_10;
        });
    }

    public UserManagementServiceAuthorization(UserManagementServiceGrpc.UserManagementService service, Authorizer authorizer, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.service = service;
        this.authorizer = authorizer;
        this.executionContext = executionContext;
        UserManagementServiceGrpc.UserManagementService.$init$((UserManagementServiceGrpc.UserManagementService)this);
        ProxyCloseable.$init$((ProxyCloseable)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
    }
}

