/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import com.auth0.jwt.interfaces.JWTVerifier;
import com.daml.jwt.Error;
import com.daml.jwt.JwtFromBearerHeader$;
import com.daml.jwt.JwtVerifierBase;
import com.daml.jwt.domain.Jwt;
import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.AuthService$;
import com.daml.ledger.api.auth.AuthServiceJWT$;
import com.daml.ledger.api.auth.AuthServiceJWTCodec$JsonImplicits$AuthServiceJWTPayloadFormat$;
import com.daml.ledger.api.auth.AuthServiceJWTPayload;
import com.daml.ledger.api.auth.Claim;
import com.daml.ledger.api.auth.ClaimActAsParty;
import com.daml.ledger.api.auth.ClaimAdmin$;
import com.daml.ledger.api.auth.ClaimPublic$;
import com.daml.ledger.api.auth.ClaimReadAsParty;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.ClaimSet$Unauthenticated$;
import com.daml.ledger.api.auth.CustomDamlJWTPayload;
import com.daml.ledger.api.auth.StandardJWTPayload;
import com.daml.ledger.api.domain;
import com.daml.lf.data.Ref$;
import io.grpc.Metadata;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Symbol;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.util.Either;
import scala.util.Try$;
import spray.json.JsonParser$;
import spray.json.JsonReader;
import spray.json.ParserInput;
import spray.json.ParserInput$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\t\u0012\u0001qA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006]\u0001!\ta\f\u0005\be\u0001\u0011\r\u0011\"\u00054\u0011\u0019a\u0004\u0001)A\u0005i!)Q\b\u0001C!}!1a\u000b\u0001Q\u0005\n]Caa\u001a\u0001!\n\u0013A\u0007BB6\u0001A\u0013%A\u000e\u0003\u0004\u007f\u0001\u0001&Ia \u0005\t\u0003\u0007\u0001\u0001\u0015\"\u0003\u0002\u0006\u001d9\u0011QB\t\t\u0002\u0005=aA\u0002\t\u0012\u0011\u0003\t\t\u0002\u0003\u0004/\u0019\u0011\u0005\u00111\u0003\u0005\b\u0003+aA\u0011AA\f\u0011\u001d\t)\u0002\u0004C\u0001\u0003[\u0011a\"Q;uQN+'O^5dK*;FK\u0003\u0002\u0013'\u0005!\u0011-\u001e;i\u0015\t!R#A\u0002ba&T!AF\f\u0002\r1,GmZ3s\u0015\tA\u0012$\u0001\u0003eC6d'\"\u0001\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0003I\u0015j\u0011!E\u0005\u0003ME\u00111\"Q;uQN+'O^5dK\u0006Aa/\u001a:jM&,'\u000f\u0005\u0002*Y5\t!F\u0003\u0002,/\u0005\u0019!n\u001e;\n\u00055R#a\u0004&xiZ+'/\u001b4jKJ\u0014\u0015m]3\u0002\rqJg.\u001b;?)\t\u0001\u0014\u0007\u0005\u0002%\u0001!)qE\u0001a\u0001Q\u00051An\\4hKJ,\u0012\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\nQa\u001d7gi)T\u0011!O\u0001\u0004_J<\u0017BA\u001e7\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013A\u00043fG>$W-T3uC\u0012\fG/\u0019\u000b\u0003\u007f1\u00032\u0001Q$J\u001b\u0005\t%B\u0001\"D\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%B\u0005=\u0019u.\u001c9mKRLwN\\*uC\u001e,\u0007C\u0001\u0013K\u0013\tY\u0015C\u0001\u0005DY\u0006LWnU3u\u0011\u0015iU\u00011\u0001O\u0003\u001dAW-\u00193feN\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\t\u001d\u0014\bo\u0019\u0006\u0002'\u0006\u0011\u0011n\\\u0005\u0003+B\u0013\u0001\"T3uC\u0012\fG/Y\u0001\u0017O\u0016$\u0018)\u001e;i_JL'0\u0019;j_:DU-\u00193feR\u0011\u0001L\u001a\t\u0004=e[\u0016B\u0001. \u0005\u0019y\u0005\u000f^5p]B\u0011Al\u0019\b\u0003;\u0006\u0004\"AX\u0010\u000e\u0003}S!\u0001Y\u000e\u0002\rq\u0012xn\u001c;?\u0013\t\u0011w$\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012 \u0011\u0015ie\u00011\u0001O\u0003-\u0001\u0018M]:f\u0011\u0016\fG-\u001a:\u0015\u0005%K\u0007\"\u00026\b\u0001\u0004Y\u0016A\u00025fC\u0012,'/\u0001\u0007qCJ\u001cX\rU1zY>\fG\r\u0006\u0002nyB!an\u001d<z\u001d\ty\u0017O\u0004\u0002_a&\t\u0001%\u0003\u0002s?\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005\u0019)\u0015\u000e\u001e5fe*\u0011!o\b\t\u0003S]L!\u0001\u001f\u0016\u0003\u000b\u0015\u0013(o\u001c:\u0011\u0005\u0011R\u0018BA>\u0012\u0005U\tU\u000f\u001e5TKJ4\u0018nY3K/R\u0003\u0016-\u001f7pC\u0012DQ! \u0005A\u0002m\u000b!B[<u!\u0006LHn\\1e\u0003=\u0001\u0018M]:f\u0015^#\u0006+Y=m_\u0006$GcA7\u0002\u0002!)!.\u0003a\u00017\u0006y\u0001/Y=m_\u0006$Gk\\\"mC&l7/\u0006\u0002\u0002\bA)a$!\u0003z\u0013&\u0019\u00111B\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0014AD!vi\"\u001cVM\u001d<jG\u0016Tu\u000b\u0016\t\u0003I1\u0019\"\u0001D\u000f\u0015\u0005\u0005=\u0011!B1qa2LHc\u0001\u0019\u0002\u001a!1qE\u0004a\u0001\u00037\u0001B!!\b\u0002*5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0006j]R,'OZ1dKNT1aKA\u0013\u0015\r\t9#G\u0001\u0006CV$\b\u000eM\u0005\u0005\u0003W\tyBA\u0006K/R3VM]5gS\u0016\u0014Hc\u0001\u0019\u00020!)qe\u0004a\u0001Q\u0001")
public class AuthServiceJWT
implements AuthService {
    private final JwtVerifierBase verifier;
    private final Logger logger;

    public static AuthServiceJWT apply(JwtVerifierBase verifier) {
        return AuthServiceJWT$.MODULE$.apply(verifier);
    }

    public static AuthServiceJWT apply(JWTVerifier verifier) {
        return AuthServiceJWT$.MODULE$.apply(verifier);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public CompletionStage<ClaimSet> decodeMetadata(Metadata headers) {
        ClaimSet claimSet;
        Option<String> option = this.getAuthorizationHeader(headers);
        if (None$.MODULE$.equals(option)) {
            claimSet = ClaimSet$Unauthenticated$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String header = (String)some.value();
            claimSet = this.parseHeader(header);
        } else {
            throw new MatchError(option);
        }
        return CompletableFuture.completedFuture(claimSet);
    }

    private Option<String> getAuthorizationHeader(Metadata headers) {
        return Option$.MODULE$.apply(headers.get(AuthService$.MODULE$.AUTHORIZATION_KEY()));
    }

    private ClaimSet parseHeader(String header) {
        return (ClaimSet)this.parseJWTPayload(header).fold((Function1 & Serializable)error -> {
            this.logger().warn(new StringBuilder(21).append("Authorization error: ").append(error.message()).toString());
            return ClaimSet$Unauthenticated$.MODULE$;
        }, (Function1 & Serializable)token -> (ClaimSet)this.payloadToClaims().apply(token));
    }

    private Either<Error, AuthServiceJWTPayload> parsePayload(String jwtPayload) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (AuthServiceJWTPayload)JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(jwtPayload)).convertTo((JsonReader)AuthServiceJWTCodec$JsonImplicits$AuthServiceJWTPayloadFormat$.MODULE$)).toEither().left().map((Function1 & Serializable)t -> new Error((Symbol)SymbolLiteral.bootstrap("apply", "parsePayload"), new StringBuilder(27).append("Could not parse JWT token: ").append(t.getMessage()).toString()));
    }

    private Either<Error, AuthServiceJWTPayload> parseJWTPayload(String header) {
        return JwtFromBearerHeader$.MODULE$.apply(header).flatMap((Function1 & Serializable)token -> $this.verifier.verify(new Jwt(token)).toEither().left().map((Function1 & Serializable)e -> new Error((Symbol)SymbolLiteral.bootstrap("apply", "parseJWTPayload"), new StringBuilder(28).append("Could not verify JWT token: ").append(e.message()).toString())).flatMap((Function1 & Serializable)decoded -> this.parsePayload((String)decoded.payload()).map((Function1 & Serializable)parsed -> parsed)));
    }

    private Function1<AuthServiceJWTPayload, ClaimSet> payloadToClaims() {
        return (Function1 & Serializable)x0$1 -> {
            AuthServiceJWTPayload authServiceJWTPayload = x0$1;
            if (authServiceJWTPayload instanceof CustomDamlJWTPayload) {
                CustomDamlJWTPayload customDamlJWTPayload = (CustomDamlJWTPayload)authServiceJWTPayload;
                ListBuffer claims = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                claims.append((Object)ClaimPublic$.MODULE$);
                Object object = customDamlJWTPayload.admin() ? claims.append((Object)ClaimAdmin$.MODULE$) : BoxedUnit.UNIT;
                customDamlJWTPayload.actAs().foreach((Function1 & Serializable)party -> (ListBuffer)claims.append((Object)new ClaimActAsParty((String)Ref$.MODULE$.Party().assertFromString(party))));
                customDamlJWTPayload.readAs().foreach((Function1 & Serializable)party -> (ListBuffer)claims.append((Object)new ClaimReadAsParty((String)Ref$.MODULE$.Party().assertFromString(party))));
                List x$1 = claims.toList();
                Option<String> x$2 = customDamlJWTPayload.ledgerId();
                Option<String> x$3 = customDamlJWTPayload.participantId();
                Option<String> x$4 = customDamlJWTPayload.applicationId();
                Option<Instant> x$5 = customDamlJWTPayload.exp();
                boolean x$6 = false;
                domain.IdentityProviderId$.Default$ x$7 = domain.IdentityProviderId$.Default$.MODULE$;
                return new ClaimSet.Claims((Seq<Claim>)x$1, x$2, x$3, x$4, x$5, (domain.IdentityProviderId)x$7, false);
            }
            if (authServiceJWTPayload instanceof StandardJWTPayload) {
                StandardJWTPayload standardJWTPayload = (StandardJWTPayload)authServiceJWTPayload;
                domain.IdentityProviderId$.Default$ x$8 = domain.IdentityProviderId$.Default$.MODULE$;
                Option<String> x$9 = standardJWTPayload.participantId();
                String x$10 = standardJWTPayload.userId();
                Option<Instant> x$11 = standardJWTPayload.exp();
                return new ClaimSet.AuthenticatedUser((domain.IdentityProviderId)x$8, x$10, x$9, x$11);
            }
            throw new MatchError((Object)authServiceJWTPayload);
        };
    }

    public AuthServiceJWT(JwtVerifierBase verifier) {
        this.verifier = verifier;
        this.logger = LoggerFactory.getLogger(AuthServiceJWT$.MODULE$.getClass());
    }
}

