/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import com.daml.ledger.api.auth.AuthServiceJWTPayload;
import com.daml.ledger.api.auth.CustomDamlJWTPayload;
import com.daml.ledger.api.auth.StandardJWTPayload;
import com.daml.ledger.api.auth.StandardJWTTokenFormat;
import com.daml.ledger.api.auth.StandardJWTTokenFormat$ParticipantId$;
import com.daml.ledger.api.auth.StandardJWTTokenFormat$Scope$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArraySeq;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import spray.json.JsArray;
import spray.json.JsArray$;
import spray.json.JsBoolean;
import spray.json.JsBoolean$;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsNumber$;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsString;
import spray.json.JsValue;

public final class AuthServiceJWTCodec$ {
    public static final AuthServiceJWTCodec$ MODULE$ = new AuthServiceJWTCodec$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String oidcNamespace = "https://daml.com/ledger-api";
    private static final String scopeLedgerApiFull = "daml_ledger_api";
    private static final String audPrefix = "https://daml.com/jwt/aud/participant/";
    private static final String propLedgerId = "ledgerId";
    private static final String propParticipantId = "participantId";
    private static final String propApplicationId = "applicationId";
    private static final String propAud = "aud";
    private static final String propIss = "iss";
    private static final String propAdmin = "admin";
    private static final String propActAs = "actAs";
    private static final String propReadAs = "readAs";
    private static final String propExp = "exp";
    private static final String propParty = "party";

    public Logger logger() {
        return logger;
    }

    public final String oidcNamespace() {
        return oidcNamespace;
    }

    public final String scopeLedgerApiFull() {
        return scopeLedgerApiFull;
    }

    public String writeToString(AuthServiceJWTPayload v) {
        return ((JsValue)this.writePayload().apply((Object)v)).compactPrint();
    }

    public Function1<AuthServiceJWTPayload, JsValue> writePayload() {
        return (Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            StandardJWTPayload standardJWTPayload = null;
            AuthServiceJWTPayload authServiceJWTPayload = x0$1;
            if (authServiceJWTPayload instanceof CustomDamlJWTPayload) {
                CustomDamlJWTPayload customDamlJWTPayload = (CustomDamlJWTPayload)authServiceJWTPayload;
                return JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.oidcNamespace()), (Object)JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propLedgerId), (Object)MODULE$.writeOptionalString(customDamlJWTPayload.ledgerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propParticipantId), (Object)MODULE$.writeOptionalString(customDamlJWTPayload.participantId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propApplicationId), (Object)MODULE$.writeOptionalString(customDamlJWTPayload.applicationId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propAdmin), (Object)JsBoolean$.MODULE$.apply(customDamlJWTPayload.admin())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propActAs), (Object)MODULE$.writeStringList(customDamlJWTPayload.actAs())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propReadAs), (Object)MODULE$.writeStringList(customDamlJWTPayload.readAs()))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propExp), (Object)MODULE$.writeOptionalInstant(customDamlJWTPayload.exp()))}));
            }
            if (authServiceJWTPayload instanceof StandardJWTPayload) {
                bl = true;
                standardJWTPayload = (StandardJWTPayload)authServiceJWTPayload;
                StandardJWTTokenFormat standardJWTTokenFormat = standardJWTPayload.format();
                StandardJWTTokenFormat$Scope$ standardJWTTokenFormat$Scope$ = StandardJWTTokenFormat$Scope$.MODULE$;
                if (!(standardJWTTokenFormat != null ? !standardJWTTokenFormat.equals(standardJWTTokenFormat$Scope$) : standardJWTTokenFormat$Scope$ != null)) {
                    return JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propIss), (Object)MODULE$.writeOptionalString(standardJWTPayload.issuer())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propAud), (Object)MODULE$.writeOptionalString(standardJWTPayload.participantId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sub"), (Object)new JsString(standardJWTPayload.userId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp"), (Object)MODULE$.writeOptionalInstant(standardJWTPayload.exp())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scope"), (Object)new JsString(MODULE$.scopeLedgerApiFull()))}));
                }
            }
            if (bl) {
                return JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propIss), (Object)MODULE$.writeOptionalString(standardJWTPayload.issuer())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propAud), (Object)new JsString(new StringBuilder(0).append(audPrefix).append(standardJWTPayload.participantId().getOrElse((Function0 & Serializable)() -> "")).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sub"), (Object)new JsString(standardJWTPayload.userId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp"), (Object)MODULE$.writeOptionalInstant(standardJWTPayload.exp()))}));
            }
            throw new MatchError((Object)authServiceJWTPayload);
        };
    }

    public String compactPrint(AuthServiceJWTPayload v) {
        return ((JsValue)this.writePayload().apply((Object)v)).compactPrint();
    }

    private JsValue writeOptionalString(Option<String> value) {
        return (JsValue)value.fold((Function0 & Serializable)() -> JsNull$.MODULE$, (Function1 & Serializable)x$1 -> new JsString(x$1));
    }

    private JsValue writeStringList(List<String> value) {
        return JsArray$.MODULE$.apply((Seq)value.map((Function1 & Serializable)x$2 -> new JsString(x$2)));
    }

    private JsValue writeOptionalInstant(Option<Instant> value) {
        return (JsValue)value.fold((Function0 & Serializable)() -> JsNull$.MODULE$, (Function1 & Serializable)i -> JsNumber$.MODULE$.apply(i.getEpochSecond()));
    }

    public Try<AuthServiceJWTPayload> readFromString(String value) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> spray.json.package$.MODULE$.enrichString(value).parseJson()).flatMap((Function1 & Serializable)json -> Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.readPayload((JsValue)json)).map((Function1 & Serializable)parsed -> parsed));
    }

    /*
     * Unable to fully structure code
     */
    public AuthServiceJWTPayload readPayload(JsValue value) {
        block10: {
            block11: {
                var5_2 = value;
                if (!(var5_2 instanceof JsObject)) break block10;
                var6_3 = (JsObject)var5_2;
                fields = var6_3.fields();
                scope = fields.get((Object)"scope");
                scopes = (List)scope.toList().collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends JsValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof JsString) {
                            JsString jsString = (JsString)A1;
                            String scope = jsString.value();
                            return (B1)scope.split(" ");
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(JsValue x1) {
                        JsValue jsValue = x1;
                        return jsValue instanceof JsString;
                    }
                }).flatten((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readPayload$1(java.lang.String[] ), ([Ljava/lang/String;)Lscala/collection/mutable/ArraySeq$ofRef;)());
                audienceValue = this.readOptionalStringOrArray(AuthServiceJWTCodec$.propAud, (Map<String, JsValue>)fields);
                participantAudiences = audienceValue.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readPayload$2$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)());
                if (participantAudiences.nonEmpty()) {
                    var12_9 = participantAudiences.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readPayload$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readPayload$4$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)());
                    if (var12_9 instanceof .colon.colon) {
                        var13_10 = (.colon.colon)var12_9;
                        participantId = (String)var13_10.head();
                        var15_12 = var13_10.next$access$1();
                        if (Nil$.MODULE$.equals(var15_12)) {
                            x$1 = this.readOptionalString("iss", (Map<String, JsValue>)fields);
                            x$2 = new Some((Object)participantId);
                            x$3 = (String)this.readOptionalString("sub", (Map<String, JsValue>)fields).get();
                            x$4 = this.readInstant("exp", (Map<String, JsValue>)fields);
                            x$5 = StandardJWTTokenFormat$ParticipantId$.MODULE$;
                            return new StandardJWTPayload(x$1, x$3, (Option<String>)x$2, x$4, x$5);
                        }
                    }
                    if (Nil$.MODULE$.equals(var12_9)) {
                        throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(93).append("Could not read ").append(value.prettyPrint()).append(" as AuthServiceJWTPayload: ").append("`aud` must include participantId value prefixed by ").append(AuthServiceJWTCodec$.audPrefix).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
                    }
                    throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(102).append("Could not read ").append(value.prettyPrint()).append(" as AuthServiceJWTPayload: ").append("`aud` must include a single participantId value prefixed by ").append(AuthServiceJWTCodec$.audPrefix).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
                }
                if (!scopes.contains((Object)this.scopeLedgerApiFull())) break block11;
                var22_18 = audienceValue;
                if (!(var22_18 instanceof .colon.colon)) ** GOTO lbl-1000
                var23_19 = (.colon.colon)var22_18;
                id = (String)var23_19.head();
                var25_21 = var23_19.next$access$1();
                if (Nil$.MODULE$.equals(var25_21)) {
                    v0 = new Some((Object)id);
                } else if (Nil$.MODULE$.equals(var22_18)) {
                    v0 = None$.MODULE$;
                } else {
                    throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(88).append("Could not read ").append(value.prettyPrint()).append(" as AuthServiceJWTPayload: ").append("`aud` must be empty or a single participantId.").toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
                }
                participantId = v0;
                x$6 = this.readOptionalString("iss", (Map<String, JsValue>)fields);
                x$7 = participantId;
                x$8 = (String)this.readOptionalString("sub", (Map<String, JsValue>)fields).get();
                x$9 = this.readInstant("exp", (Map<String, JsValue>)fields);
                x$10 = StandardJWTTokenFormat$Scope$.MODULE$;
                return new StandardJWTPayload(x$6, x$8, (Option<String>)x$7, x$9, x$10);
            }
            if (scope.nonEmpty()) {
                this.logger().warn(new StringBuilder(143).append("Access token with unknown scope \"").append(scope.get()).append("\" is being parsed as a custom claims token. Issue tokens with adjusted or no scope to get rid of this warning.").toString());
            }
            if (!fields.contains((Object)this.oidcNamespace())) {
                this.logger().warn(new StringBuilder(47).append("Token ").append(value.compactPrint()).append(" is using a deprecated JWT payload format").toString());
                return new CustomDamlJWTPayload(this.readOptionalString(AuthServiceJWTCodec$.propLedgerId, (Map<String, JsValue>)fields), this.readOptionalString(AuthServiceJWTCodec$.propParticipantId, (Map<String, JsValue>)fields), this.readOptionalString(AuthServiceJWTCodec$.propApplicationId, (Map<String, JsValue>)fields), this.readInstant(AuthServiceJWTCodec$.propExp, (Map<String, JsValue>)fields), BoxesRunTime.unboxToBoolean((Object)this.readOptionalBoolean(AuthServiceJWTCodec$.propAdmin, (Map<String, JsValue>)fields).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$readPayload$5(), ()Z)())), (List<String>)((List)this.readOptionalStringList(AuthServiceJWTCodec$.propActAs, (Map<String, JsValue>)fields).$plus$plus((IterableOnce)this.readOptionalString(AuthServiceJWTCodec$.propParty, (Map<String, JsValue>)fields).toList())), this.readOptionalStringList(AuthServiceJWTCodec$.propReadAs, (Map<String, JsValue>)fields));
            }
            customClaims = ((JsValue)fields.getOrElse((Object)this.oidcNamespace(), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$readPayload$6(spray.json.JsValue ), ()Lscala/runtime/Nothing$;)((JsValue)value))).asJsObject(new StringBuilder(68).append("Could not read ").append(value.prettyPrint()).append(" as AuthServiceJWTPayload: namespace is not an object").toString()).fields();
            return new CustomDamlJWTPayload(this.readOptionalString(AuthServiceJWTCodec$.propLedgerId, (Map<String, JsValue>)customClaims), this.readOptionalString(AuthServiceJWTCodec$.propParticipantId, (Map<String, JsValue>)customClaims), this.readOptionalString(AuthServiceJWTCodec$.propApplicationId, (Map<String, JsValue>)customClaims), this.readInstant(AuthServiceJWTCodec$.propExp, (Map<String, JsValue>)fields), BoxesRunTime.unboxToBoolean((Object)this.readOptionalBoolean(AuthServiceJWTCodec$.propAdmin, (Map<String, JsValue>)customClaims).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$readPayload$7(), ()Z)())), this.readOptionalStringList(AuthServiceJWTCodec$.propActAs, (Map<String, JsValue>)customClaims), this.readOptionalStringList(AuthServiceJWTCodec$.propReadAs, (Map<String, JsValue>)customClaims));
        }
        throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(64).append("Could not read ").append(value.prettyPrint()).append(" as AuthServiceJWTPayload: value is not an object").toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
    }

    private Option<String> readOptionalString(String name, Map<String, JsValue> fields) {
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option = fields.get((Object)name);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return None$.MODULE$;
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            String value = jsString.value();
            return new Some((Object)value);
        }
        if (bl) {
            JsValue value = (JsValue)some.value();
            throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(30).append("Could not read ").append(value.prettyPrint()).append(" as string for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
        }
        throw new MatchError((Object)option);
    }

    private List<String> readOptionalStringOrArray(String name, Map<String, JsValue> fields) {
        JsValue array;
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option = fields.get((Object)name);
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return package$.MODULE$.List().empty();
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            String value = jsString.value();
            return new .colon.colon((Object)value, (List)Nil$.MODULE$);
        }
        if (bl && (array = (JsValue)some.value()) instanceof JsArray) {
            JsArray jsArray = (JsArray)array;
            return this.readStringList(name, (Vector<JsValue>)jsArray.elements());
        }
        if (bl) {
            JsValue value = (JsValue)some.value();
            throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(30).append("Could not read ").append(value.prettyPrint()).append(" as string for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
        }
        throw new MatchError((Object)option);
    }

    private List<String> readOptionalStringList(String name, Map<String, JsValue> fields) {
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option = fields.get((Object)name);
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return package$.MODULE$.List().empty();
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            Vector values = jsArray.elements();
            return this.readStringList(name, (Vector<JsValue>)values);
        }
        if (bl) {
            JsValue value = (JsValue)some.value();
            throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(35).append("Could not read ").append(value.prettyPrint()).append(" as string list for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
        }
        throw new MatchError((Object)option);
    }

    private List<String> readStringList(String name, Vector<JsValue> values) {
        return values.toList().map((Function1 & Serializable)x0$1 -> {
            JsValue jsValue = x0$1;
            if (jsValue instanceof JsString) {
                JsString jsString = (JsString)jsValue;
                String value = jsString.value();
                return value;
            }
            throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(38).append("Could not read ").append(jsValue.prettyPrint()).append(" as string element for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
        });
    }

    private Option<Object> readOptionalBoolean(String name, Map<String, JsValue> fields) {
        JsBoolean jsBoolean;
        Option option;
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option2 = fields.get((Object)name);
        if (None$.MODULE$.equals(option2)) {
            return None$.MODULE$;
        }
        if (option2 instanceof Some) {
            bl = true;
            some = (Some)option2;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return None$.MODULE$;
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsBoolean && !(option = JsBoolean$.MODULE$.unapply(jsBoolean = (JsBoolean)jsValue)).isEmpty()) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)option.get());
            return new Some((Object)BoxesRunTime.boxToBoolean((boolean)value));
        }
        if (bl) {
            JsValue value = (JsValue)some.value();
            throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(31).append("Could not read ").append(value.prettyPrint()).append(" as boolean for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
        }
        throw new MatchError((Object)option2);
    }

    private Option<Instant> readInstant(String name, Map<String, JsValue> fields) {
        JsValue jsValue;
        boolean bl = false;
        Some some = null;
        Option option = fields.get((Object)name);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            JsValue jsValue2 = (JsValue)some.value();
            if (JsNull$.MODULE$.equals(jsValue2)) {
                return None$.MODULE$;
            }
        }
        if (bl && (jsValue = (JsValue)some.value()) instanceof JsNumber) {
            JsNumber jsNumber = (JsNumber)jsValue;
            BigDecimal epochSeconds = jsNumber.value();
            return new Some((Object)Instant.ofEpochSecond(epochSeconds.longValue()));
        }
        if (bl) {
            JsValue value = (JsValue)some.value();
            throw spray.json.package$.MODULE$.deserializationError(new StringBuilder(37).append("Could not read ").append(value.prettyPrint()).append(" as epoch seconds for ").append(name).toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ ArraySeq.ofRef $anonfun$readPayload$1(String[] xs) {
        return Predef$.MODULE$.wrapRefArray((Object[])xs);
    }

    public static final /* synthetic */ String $anonfun$readPayload$3(String x$4) {
        return x$4.substring(audPrefix.length());
    }

    public static final /* synthetic */ boolean $anonfun$readPayload$5() {
        return false;
    }

    public static final /* synthetic */ Nothing$ $anonfun$readPayload$6(JsValue value$2) {
        return spray.json.package$.MODULE$.deserializationError(new StringBuilder(59).append("Could not read ").append(value$2.prettyPrint()).append(" as AuthServiceJWTPayload: namespace missing").toString(), spray.json.package$.MODULE$.deserializationError$default$2(), spray.json.package$.MODULE$.deserializationError$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$readPayload$7() {
        return false;
    }

    private AuthServiceJWTCodec$() {
    }

    public static final /* synthetic */ Object $anonfun$readPayload$2$adapted(String x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.startsWith(AuthServiceJWTCodec$.audPrefix));
    }

    public static final /* synthetic */ Object $anonfun$readPayload$4$adapted(String x$5) {
        return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5)));
    }
}

