/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import akka.actor.Scheduler;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.AuthorizationChecks;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.jwt.JwtTimestampLeeway;
import com.daml.ledger.api.auth.AuthorizationError;
import com.daml.ledger.api.auth.Authorizer$;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.ClaimSet$Unauthenticated$;
import com.daml.ledger.api.auth.OngoingAuthorizationObserver$;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.v1.transaction_filter.TransactionFilter;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.localstore.api.UserManagementStore;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scalapb.lenses.Lens;

@ScalaSignature(bytes="\u0006\u0005\u0011}b\u0001B\u0017/\u0005eB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\f\u0001B\u0001B\u0003%Q\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u00119\u0004!\u0011!Q\u0001\n=D\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\f\u0005\u0015\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003_A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003s\u0001!\u0019!C\u0006\u0003wA\u0001\"!\u0013\u0001A\u0003%\u0011Q\b\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003Cq!a0\u0001\t\u0003\t\t\rC\u0004\u0002\\\u0002!\t!!8\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u0011q\u001e\u0001\u0005\u0002\t\u001d\u0001b\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#BqA!\u001e\u0001\t\u0013\u00119\b\u0003\u0005\u0003\u0000\u0001\u0001K\u0011\u0002BA\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;CqA!/\u0001\t\u0003\u0011Y\fC\u0004\u0003d\u0002!\tA!:\t\u000f\te\b\u0001\"\u0001\u0003|\"91q\u0004\u0001\u0005\u0002\r\u0005\u0002bBB%\u0001\u0011\u000511\n\u0005\b\u00077\u0002A\u0011BB/\u0011\u001d\u0019y\u0007\u0001C\u0005\u0007cBqa!!\u0001\t\u0013\u0019\u0019\tC\u0004\u0004\u001a\u0002!Iaa'\t\u000f\r%\u0006\u0001\"\u0003\u0004,\"91q\u0016\u0001\u0005\n\rE\u0006bBBi\u0001\u0011%11\u001b\u0005\t\u0007_\u0003A\u0011\u0001\u0018\u0004p\"A1\u0011\u001b\u0001\u0005\u00029\"IaB\u0005\u0005 9\n\t\u0011#\u0001\u0005\"\u0019AQFLA\u0001\u0012\u0003!\u0019\u0003C\u0004\u0002\u0012)\"\t\u0001\"\n\t\u0013\u0011\u001d\"&%A\u0005\u0002\u0011%\"AC!vi\"|'/\u001b>fe*\u0011q\u0006M\u0001\u0005CV$\bN\u0003\u00022e\u0005\u0019\u0011\r]5\u000b\u0005M\"\u0014A\u00027fI\u001e,'O\u0003\u00026m\u0005!A-Y7m\u0015\u00059\u0014aA2p[\u000e\u00011C\u0001\u0001;!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0019\te.\u001f*fM\u0006\u0019an\\<\u0011\u0007m\u0012E)\u0003\u0002Dy\tIa)\u001e8di&|g\u000e\r\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bA\u0001^5nK*\t\u0011*\u0001\u0003kCZ\f\u0017BA&G\u0005\u001dIen\u001d;b]R\f\u0001\u0002\\3eO\u0016\u0014\u0018\n\u001a\t\u0003\u001dVs!aT*\u0011\u0005AcT\"A)\u000b\u0005IC\u0014A\u0002\u001fs_>$h(\u0003\u0002Uy\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!F(A\u0007qCJ$\u0018nY5qC:$\u0018\nZ\u0001\u0014kN,'/T1oC\u001e,W.\u001a8u'R|'/\u001a\t\u00037\u0006l\u0011\u0001\u0018\u0006\u0003cuS!AX0\u0002\u00151|7-\u00197ti>\u0014XM\u0003\u0002ai\u0005A\u0001\u000f\\1uM>\u0014X.\u0003\u0002c9\n\u0019Rk]3s\u001b\u0006t\u0017mZ3nK:$8\u000b^8sK\u0006\u0011Qm\u0019\t\u0003K\"l\u0011A\u001a\u0006\u0003Or\n!bY8oGV\u0014(/\u001a8u\u0013\tIgM\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0001So]3s%&<\u0007\u000e^:DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\%o'\u0016\u001cwN\u001c3t!\tYD.\u0003\u0002ny\t\u0019\u0011J\u001c;\u0002\u001b\u0005\\7.Y*dQ\u0016$W\u000f\\3s!\t\u0001X/D\u0001r\u0015\t\u00118/A\u0003bGR|'OC\u0001u\u0003\u0011\t7n[1\n\u0005Y\f(!C*dQ\u0016$W\u000f\\3s\u0003IQw\u000f\u001e+j[\u0016\u001cH/Y7q\u0019\u0016,w/Y=\u0011\u0007mJ80\u0003\u0002{y\t1q\n\u001d;j_:\u0004\"\u0001`@\u000e\u0003uT!A \u001b\u0002\u0007)<H/C\u0002\u0002\u0002u\u0014!CS<u)&lWm\u001d;b[BdU-Z<bs\u0006qAn\\4hS:<7i\u001c8uKb$\b\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-A'A\u0004m_\u001e<\u0017N\\4\n\t\u0005=\u0011\u0011\u0002\u0002\u000f\u0019><w-\u001b8h\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0011\u0012QCA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016)\u0011\t9\"a\u0007\u0011\u0007\u0005e\u0001!D\u0001/\u0011\u001d\t\u0019A\u0003a\u0002\u0003\u000bAQ\u0001\u0011\u0006A\u0002\u0005CQ\u0001\u0014\u0006A\u00025CQ\u0001\u0017\u0006A\u00025CQ!\u0017\u0006A\u0002iCQa\u0019\u0006A\u0002\u0011DQA\u001b\u0006A\u0002-DQA\u001c\u0006A\u0002=Dqa\u001e\u0006\u0011\u0002\u0003\u0007\u00010\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003c\u0001B!a\u0002\u00024%!\u0011QGA\u0005\u0005Q\u0019uN\u001c;fqR,\u0018\r\\5{K\u0012dunZ4fe\u00069An\\4hKJ\u0004\u0013aC3se>\u0014Hj\\4hKJ,\"!!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u00115\u0003\u0015)'O]8s\u0013\u0011\t9%!\u0011\u00033\r{g\u000e^3yiV\fG.\u001b>fI\u0016\u0013(o\u001c:M_\u001e<WM]\u0001\rKJ\u0014xN\u001d'pO\u001e,'\u000fI\u0001\u0006m\u0006d\u0017\u000e\u001a\u000b\u0005\u0003\u001f\ni\u0007\u0005\u0005\u0002R\u0005m\u0013\u0011MA4\u001d\u0011\t\u0019&a\u0016\u000f\u0007A\u000b)&C\u0001>\u0013\r\tI\u0006P\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti&a\u0018\u0003\r\u0015KG\u000f[3s\u0015\r\tI\u0006\u0010\t\u0005\u00033\t\u0019'C\u0002\u0002f9\u0012!#Q;uQ>\u0014\u0018N_1uS>tWI\u001d:peB\u00191(!\u001b\n\u0007\u0005-DH\u0001\u0003V]&$\bbBA8\u001f\u0001\u0007\u0011\u0011O\u0001\u0007G2\f\u0017.\\:\u0011\t\u0005M\u0014\u0011\u0010\b\u0005\u00033\t)(C\u0002\u0002x9\n\u0001b\u00117bS6\u001cV\r^\u0005\u0005\u0003w\niH\u0001\u0004DY\u0006LWn\u001d\u0006\u0004\u0003or\u0013a\u0007:fcVL'/\u001a)vE2L7m\u00117bS6\u001cxJ\\*ue\u0016\fW.\u0006\u0004\u0002\u0004\u0006=\u0015q\u0017\u000b\u0005\u0003\u000b\u000bY\fE\u0005<\u0003\u000f\u000bY)!)\u0002h%\u0019\u0011\u0011\u0012\u001f\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BAG\u0003\u001fc\u0001\u0001B\u0004\u0002\u0012B\u0011\r!a%\u0003\u0007I+\u0017/\u0005\u0003\u0002\u0016\u0006m\u0005cA\u001e\u0002\u0018&\u0019\u0011\u0011\u0014\u001f\u0003\u000f9{G\u000f[5oOB\u00191(!(\n\u0007\u0005}EHA\u0002B]f\u0004b!a)\u00022\u0006UVBAAS\u0015\u0011\t9+!+\u0002\tM$XO\u0019\u0006\u0005\u0003W\u000bi+\u0001\u0003heB\u001c'BAAX\u0003\tIw.\u0003\u0003\u00024\u0006\u0015&AD*ue\u0016\fWn\u00142tKJ4XM\u001d\t\u0005\u0003\u001b\u000b9\fB\u0004\u0002:B\u0011\r!a%\u0003\u0007I+7\u000fC\u0004\u0002>B\u0001\r!!\"\u0002\t\r\fG\u000e\\\u0001\u0014e\u0016\fX/\u001b:f!V\u0014G.[2DY\u0006LWn]\u000b\u0007\u0003\u0007\fi-a6\u0015\t\u0005\u0015\u0017\u0011\u001c\t\bw\u0005\u001d\u00171ZAh\u0013\r\tI\r\u0010\u0002\n\rVt7\r^5p]F\u0002B!!$\u0002N\u00129\u0011\u0011S\tC\u0002\u0005M\u0005#B3\u0002R\u0006U\u0017bAAjM\n1a)\u001e;ve\u0016\u0004B!!$\u0002X\u00129\u0011\u0011X\tC\u0002\u0005M\u0005bBA_#\u0001\u0007\u0011QY\u0001\u0013e\u0016\fX/\u001b:f\u0003\u0012l\u0017N\\\"mC&l7/\u0006\u0004\u0002`\u0006\u0015\u00181\u001e\u000b\u0005\u0003C\fi\u000fE\u0004<\u0003\u000f\f\u0019/a:\u0011\t\u00055\u0015Q\u001d\u0003\b\u0003#\u0013\"\u0019AAJ!\u0015)\u0017\u0011[Au!\u0011\ti)a;\u0005\u000f\u0005e&C1\u0001\u0002\u0014\"9\u0011Q\u0018\nA\u0002\u0005\u0005\u0018\u0001\f:fcVL'/Z%ea\u0006#W.\u001b8DY\u0006LWn]!oI6\u000bGo\u00195j]\u001e\u0014V-];fgRLE\r]%e+\u0019\t\u00190!?\u0002\u0000R1\u0011Q\u001fB\u0001\u0005\u000b\u0001raOAd\u0003o\fY\u0010\u0005\u0003\u0002\u000e\u0006eHaBAI'\t\u0007\u00111\u0013\t\u0006K\u0006E\u0017Q \t\u0005\u0003\u001b\u000by\u0010B\u0004\u0002:N\u0011\r!a%\t\r\t\r1\u00031\u0001N\u0003IIG-\u001a8uSRL\bK]8wS\u0012,'/\u00133\t\u000f\u0005u6\u00031\u0001\u0002vV1!\u0011\u0002B\b\u0005+!\u0002Ba\u0003\u0003\u0018\te!1\u0005\t\bw\u0005\u001d'Q\u0002B\t!\u0011\tiIa\u0004\u0005\u000f\u0005EEC1\u0001\u0002\u0014B)Q-!5\u0003\u0014A!\u0011Q\u0012B\u000b\t\u001d\tI\f\u0006b\u0001\u0003'CaAa\u0001\u0015\u0001\u0004i\u0005b\u0002B\u000e)\u0001\u0007!QD\u0001\u0017[V\u001cHOQ3QCJ$\u0018nY5qC:$\u0018\tZ7j]B\u00191Ha\b\n\u0007\t\u0005BHA\u0004C_>dW-\u00198\t\u000f\u0005uF\u00031\u0001\u0003\f\u0005Y\"/Z9vSJ,W*\u0019;dQ&twMU3rk\u0016\u001cH/\u00133q\u0013\u0012,bA!\u000b\u00030\tUBC\u0002B\u0016\u0005o\u0011I\u0004E\u0004<\u0003\u000f\u0014iC!\r\u0011\t\u00055%q\u0006\u0003\b\u0003#+\"\u0019AAJ!\u0015)\u0017\u0011\u001bB\u001a!\u0011\tiI!\u000e\u0005\u000f\u0005eVC1\u0001\u0002\u0014\"1!1A\u000bA\u00025Cq!!0\u0016\u0001\u0004\u0011Y#A\u000bsKF,\u0018N]3JIB\fE-\\5o\u00072\f\u0017.\\:\u0016\r\t}\"Q\tB&)\u0011\u0011\tE!\u0014\u0011\u000fm\n9Ma\u0011\u0003HA!\u0011Q\u0012B#\t\u001d\t\tJ\u0006b\u0001\u0003'\u0003R!ZAi\u0005\u0013\u0002B!!$\u0003L\u00119\u0011\u0011\u0018\fC\u0002\u0005M\u0005bBA_-\u0001\u0007!\u0011I\u0001\u001ae\u0016\fX/\u001b:f\u0013\u0012,g\u000e^5usB\u0013xN^5eKJLE\r\u0006\u0003\u0003T\tM\u0004\u0003CA)\u00037\n\tG!\u0016\u0011\t\t]#Q\u000e\b\u0005\u00053\u0012IG\u0004\u0003\u0003\\\t\u001dd\u0002\u0002B/\u0005KrAAa\u0018\u0003d9\u0019\u0001K!\u0019\n\u0003]J!!\u000e\u001c\n\u0005M\"\u0014BA\u00193\u0013\r\u0011Y\u0007M\u0001\u0007I>l\u0017-\u001b8\n\t\t=$\u0011\u000f\u0002\u0013\u0013\u0012,g\u000e^5usB\u0013xN^5eKJLEMC\u0002\u0003lABaAa\u0001\u0018\u0001\u0004i\u0015!\t<bY&$\u0017\r^3SKF,Xm\u001d;JI\u0016tG/\u001b;z!J|g/\u001b3fe&#GCBA(\u0005s\u0012i\bC\u0004\u0003|a\u0001\rA!\u0016\u00023I,\u0017/^3ti&#WM\u001c;jif\u0004&o\u001c<jI\u0016\u0014\u0018\n\u001a\u0005\b\u0003_B\u0002\u0019AA9\u00035\u0011X-];je\u00164uN]!mYV!!1\u0011BI)\u0019\tyE!\"\u0003\u0016\"9!qQ\rA\u0002\t%\u0015A\u0001=t!\u0019\t\tFa#\u0003\u0010&!!QRA0\u00051IE/\u001a:bE2,wJ\\2f!\u0011\tiI!%\u0005\u000f\tM\u0015D1\u0001\u0002\u0014\n\tA\u000bC\u0004\u0003\u0018f\u0001\rA!'\u0002\u0003\u0019\u0004raOAd\u0005\u001f\u000by%\u0001\u0014sKF,\u0018N]3SK\u0006$7\t\\1j[N4uN]!mYB\u000b'\u000f^5fg>s7\u000b\u001e:fC6,bAa(\u0003&\n-FC\u0002BQ\u0005[\u00139\fE\u0005<\u0003\u000f\u0013\u0019Ka*\u0002hA!\u0011Q\u0012BS\t\u001d\t\tJ\u0007b\u0001\u0003'\u0003b!a)\u00022\n%\u0006\u0003BAG\u0005W#q!!/\u001b\u0005\u0004\t\u0019\nC\u0004\u00030j\u0001\rA!-\u0002\u000fA\f'\u000f^5fgB)\u0011\u0011\u000bBZ\u001b&!!QWA0\u0005!IE/\u001a:bE2,\u0007bBA_5\u0001\u0007!\u0011U\u00018e\u0016\fX/\u001b:f%\u0016\fGm\u00117bS6\u001chi\u001c:BY2\u0004\u0016M\u001d;jKN|en\u0015;sK\u0006lw+\u001b;i\u0003B\u0004H.[2bi&|g.\u00133\u0016\r\tu&1\u0019Be)!\u0011yLa3\u0003N\n\u0005\b#C\u001e\u0002\b\n\u0005'QYA4!\u0011\tiIa1\u0005\u000f\u0005E5D1\u0001\u0002\u0014B1\u00111UAY\u0005\u000f\u0004B!!$\u0003J\u00129\u0011\u0011X\u000eC\u0002\u0005M\u0005b\u0002BX7\u0001\u0007!\u0011\u0017\u0005\b\u0005\u001f\\\u0002\u0019\u0001Bi\u00039\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI2\u0003rAa5\u0003^\n\u0005W*\u0004\u0002\u0003V*!!q\u001bBm\u0003\u0019aWM\\:fg*\u0011!1\\\u0001\bg\u000e\fG.\u00199c\u0013\u0011\u0011yN!6\u0003\t1+gn\u001d\u0005\b\u0003{[\u0002\u0019\u0001B`\u0003y\u0011X-];je\u0016\u0014V-\u00193DY\u0006LWn\u001d$pe\u0006cG\u000eU1si&,7/\u0006\u0004\u0003h\n5(1\u001f\u000b\u0007\u0005S\u0014)Pa>\u0011\u000fm\n9Ma;\u0003pB!\u0011Q\u0012Bw\t\u001d\t\t\n\bb\u0001\u0003'\u0003R!ZAi\u0005c\u0004B!!$\u0003t\u00129\u0011\u0011\u0018\u000fC\u0002\u0005M\u0005b\u0002BX9\u0001\u0007!\u0011\u0017\u0005\b\u0003{c\u0002\u0019\u0001Bu\u0003\u0005\u0012X-];je\u0016\f5\r^!oIJ+\u0017\rZ\"mC&l7OR8s!\u0006\u0014H/[3t+\u0019\u0011ipa\u0001\u0004\nQQ!q`B\u0006\u0007+\u0019Ib!\b\u0011\u000fm\n9m!\u0001\u0004\u0006A!\u0011QRB\u0002\t\u001d\t\t*\bb\u0001\u0003'\u0003R!ZAi\u0007\u000f\u0001B!!$\u0004\n\u00119\u0011\u0011X\u000fC\u0002\u0005M\u0005bBB\u0007;\u0001\u00071qB\u0001\u0006C\u000e$\u0018i\u001d\t\u0005\u001d\u000eEQ*C\u0002\u0004\u0014]\u00131aU3u\u0011\u001d\u00199\"\ba\u0001\u0007\u001f\taA]3bI\u0006\u001b\bb\u0002Bh;\u0001\u000711\u0004\t\b\u0005'\u0014in!\u0001N\u0011\u001d\ti,\ba\u0001\u0005\u007f\fQF]3rk&\u0014XMU3bI\u000ec\u0017-[7t\r>\u0014HK]1og\u0006\u001cG/[8o\r&dG/\u001a:P]N#(/Z1n+\u0019\u0019\u0019c!\u000b\u00040Q11QEB\u0019\u0007\u000f\u0002\u0012bOAD\u0007O\u0019Y#a\u001a\u0011\t\u000555\u0011\u0006\u0003\b\u0003#s\"\u0019AAJ!\u0019\t\u0019+!-\u0004.A!\u0011QRB\u0018\t\u001d\tIL\bb\u0001\u0003'Cqaa\r\u001f\u0001\u0004\u0019)$\u0001\u0004gS2$XM\u001d\t\u0005we\u001c9\u0004\u0005\u0003\u0004:\r\rSBAB\u001e\u0015\u0011\u0019ida\u0010\u0002%Q\u0014\u0018M\\:bGRLwN\\0gS2$XM\u001d\u0006\u0004\u0007\u0003\u0002\u0014A\u0001<2\u0013\u0011\u0019)ea\u000f\u0003#Q\u0013\u0018M\\:bGRLwN\u001c$jYR,'\u000fC\u0004\u0002>z\u0001\ra!\n\u0002'\u0005,H\u000f[3oi&\u001c\u0017\r^3e+N,'/\u00133\u0015\u0005\r5\u0003CBB(\u0007+\u001aI&\u0004\u0002\u0004R)\u001911\u000b\u001f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007/\u001a\tFA\u0002Uef\u00042aO=N\u0003Q!WMZ1vYR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8JIR11qLB5\u0007[\u0002r!!\u0015\u0002\\\r\u0005T\n\u0005\u0003\u0004d\r\u0015TBAAU\u0013\u0011\u00199'!+\u0003-M#\u0018\r^;t%VtG/[7f\u000bb\u001cW\r\u001d;j_:Daaa\u001b!\u0001\u0004i\u0015\u0001\u0005:fc\u0006\u0003\b\u000f\\5dCRLwN\\%e\u0011\u001d\ty\u0007\ta\u0001\u0003c\n\u0001$Y;uQ>\u0014\u0018N_1uS>tWI\u001d:pe\u0006\u001bxI\u001d9d+\u0011\u0019\u0019h!\u001f\u0015\t\rU41\u0010\t\t\u0003#\nYf!\u0019\u0004xA!\u0011QRB=\t\u001d\u0011\u0019*\tb\u0001\u0003'Cqa! \"\u0001\u0004\u0019y(\u0001\u0004feJ|%O\u0016\t\t\u0003#\nY&!\u0019\u0004x\u0005\u0001\u0012m]:feR\u001cVM\u001d<fe\u000e\u000bG\u000e\\\u000b\u0005\u0007\u000b\u001by\t\u0006\u0003\u0004\b\u000eM\u0005CBAR\u0007\u0013\u001bi)\u0003\u0003\u0004\f\u0006\u0015&\u0001G*feZ,'oQ1mYN#(/Z1n\u001f\n\u001cXM\u001d<feB!\u0011QRBH\t\u001d\u0019\tJ\tb\u0001\u0003'\u0013\u0011!\u0011\u0005\b\u0007+\u0013\u0003\u0019ABL\u0003!y'm]3sm\u0016\u0014\bCBAR\u0003c\u001bi)\u0001\u000bp]\u001e|\u0017N\\4BkRDwN]5{CRLwN\\\u000b\u0005\u0007;\u001b\u0019\u000b\u0006\u0004\u0004 \u000e\u00156q\u0015\t\u0007\u0003G\u001bIi!)\u0011\t\u0005551\u0015\u0003\b\u0003s\u001b#\u0019AAJ\u0011\u001d\u0019)j\ta\u0001\u0007?Cq!a\u001c$\u0001\u0004\t\t(\u0001\u0010bkRDWM\u001c;jG\u0006$X\rZ\"mC&l7O\u0012:p[\u000e{g\u000e^3yiR\u00111Q\u0016\t\u0007\u0007\u001f\u001a)&!\u001d\u0002!\u0005,H\u000f[8sSj,w+\u001b;i%\u0016\fXCBBZ\u0007w\u001b\t\r\u0006\u0003\u00046\u000e-G\u0003BB\\\u0007\u0007\u0004\u0012bOAD\u0007s\u001bi,a\u001a\u0011\t\u0005551\u0018\u0003\b\u0003#+#\u0019AAJ!\u0019\t\u0019+!-\u0004@B!\u0011QRBa\t\u001d\tI,\nb\u0001\u0003'Cqa!2&\u0001\u0004\u00199-\u0001\u0006bkRDwN]5{K\u0012\u0004\u0012bOAD\u0003c\u001aIl!3\u0011\u0011\u0005E\u00131LB1\u0007sCq!!0&\u0001\u0004\u0019i\rE\u0005<\u0003\u000f\u001bIla4\u0002hA1\u00111UBE\u0007\u007f\u000b\u0011\"Y;uQ>\u0014\u0018N_3\u0016\r\rU7Q\\Br)\u0011\u00199n!;\u0015\t\re7Q\u001d\t\nw\u0005\u001d51\\Bp\u0003O\u0002B!!$\u0004^\u00129\u0011\u0011\u0013\u0014C\u0002\u0005M\u0005CBAR\u0003c\u001b\t\u000f\u0005\u0003\u0002\u000e\u000e\rHaBA]M\t\u0007\u00111\u0013\u0005\b\u0007\u000b4\u0003\u0019ABt!\u001dY\u0014qYA9\u0003\u001fBq!!0'\u0001\u0004\u0019Y\u000fE\u0005<\u0003\u000f\u001bYn!<\u0002hA1\u00111UBE\u0007C,ba!=\u0004z\u000e}H\u0003BBz\t\u000f!Ba!>\u0005\u0002A91(a2\u0004x\u000em\b\u0003BAG\u0007s$q!!%(\u0005\u0004\t\u0019\nE\u0003f\u0003#\u001ci\u0010\u0005\u0003\u0002\u000e\u000e}HaBA]O\t\u0007\u00111\u0013\u0005\b\u0007\u000b<\u0003\u0019\u0001C\u0002!%Y\u0014qQA9\u0007o$)\u0001\u0005\u0005\u0002R\u0005m3\u0011MB|\u0011\u001d\til\na\u0001\u0007k,b\u0001b\u0003\u0005\u0014\u0011eA\u0003\u0002C\u0007\t;!B\u0001b\u0004\u0005\u001cA91(a2\u0005\u0012\u0011U\u0001\u0003BAG\t'!q!!%)\u0005\u0004\t\u0019\nE\u0003f\u0003#$9\u0002\u0005\u0003\u0002\u000e\u0012eAaBA]Q\t\u0007\u00111\u0013\u0005\b\u0007\u000bD\u0003\u0019ABt\u0011\u001d\ti\f\u000ba\u0001\t\u001f\t!\"Q;uQ>\u0014\u0018N_3s!\r\tIBK\n\u0003Ui\"\"\u0001\"\t\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t!YCK\u0002y\t[Y#\u0001b\f\u0011\t\u0011EB1H\u0007\u0003\tgQA\u0001\"\u000e\u00058\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\tsa\u0014AC1o]>$\u0018\r^5p]&!AQ\bC\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public final class Authorizer {
    private final Function0<Instant> now;
    private final String ledgerId;
    private final String participantId;
    private final UserManagementStore userManagementStore;
    private final ExecutionContext ec;
    private final int userRightsCheckIntervalInSeconds;
    private final Scheduler akkaScheduler;
    private final Option<JwtTimestampLeeway> jwtTimestampLeeway;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final ContextualizedErrorLogger errorLogger;

    public static Option<JwtTimestampLeeway> $lessinit$greater$default$8() {
        return Authorizer$.MODULE$.$lessinit$greater$default$8();
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private ContextualizedErrorLogger errorLogger() {
        return this.errorLogger;
    }

    private Either<AuthorizationError, BoxedUnit> valid(ClaimSet.Claims claims) {
        return claims.notExpired((Instant)this.now.apply(), this.jwtTimestampLeeway).flatMap((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            return claims.validForLedger($this.ledgerId).flatMap((Function1 & Serializable)x$2 -> {
                BoxedUnit boxedUnit = x$2;
                return claims.validForParticipant($this.participantId).map((Function1 & Serializable)x$1 -> {
                    boxedUnit = x$1;
                    return BoxedUnit.UNIT;
                });
            });
        });
    }

    public <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> requirePublicClaimsOnStream(Function2<Req, StreamObserver<Res>, BoxedUnit> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$5 -> {
            BoxedUnit boxedUnit = x$5;
            return claims.isPublic().map((Function1 & Serializable)x$4 -> {
                boxedUnit = x$4;
                return BoxedUnit.UNIT;
            });
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requirePublicClaims(Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$7 -> {
            BoxedUnit boxedUnit = x$7;
            return claims.isPublic().map((Function1 & Serializable)x$6 -> {
                boxedUnit = x$6;
                return BoxedUnit.UNIT;
            });
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requireAdminClaims(Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            return claims.isAdmin().map((Function1 & Serializable)x$8 -> {
                boxedUnit = x$8;
                return BoxedUnit.UNIT;
            });
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requireIdpAdminClaimsAndMatchingRequestIdpId(String identityProviderId, Function1<Req, Future<Res>> call) {
        return this.requireIdpAdminClaimsAndMatchingRequestIdpId(identityProviderId, false, call);
    }

    public <Req, Res> Function1<Req, Future<Res>> requireIdpAdminClaimsAndMatchingRequestIdpId(String identityProviderId, boolean mustBeParticipantAdmin, Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return (mustBeParticipantAdmin ? claims.isAdmin() : claims.isAdminOrIDPAdmin()).flatMap((Function1 & Serializable)x$11 -> {
                BoxedUnit boxedUnit = x$11;
                return this.requireIdentityProviderId(identityProviderId).flatMap((Function1 & Serializable)requestIdentityProviderId -> this.validateRequestIdentityProviderId((domain.IdentityProviderId)requestIdentityProviderId, (ClaimSet.Claims)claims).map((Function1 & Serializable)x$10 -> {
                    boxedUnit = x$10;
                    return BoxedUnit.UNIT;
                }));
            });
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requireMatchingRequestIdpId(String identityProviderId, Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$14 -> {
            BoxedUnit boxedUnit = x$14;
            return this.requireIdentityProviderId(identityProviderId).flatMap((Function1 & Serializable)requestIdentityProviderId -> this.validateRequestIdentityProviderId((domain.IdentityProviderId)requestIdentityProviderId, (ClaimSet.Claims)claims).map((Function1 & Serializable)x$13 -> {
                boxedUnit = x$13;
                return BoxedUnit.UNIT;
            }));
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requireIdpAdminClaims(Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$16 -> {
            BoxedUnit boxedUnit = x$16;
            return claims.isAdminOrIDPAdmin().map((Function1 & Serializable)x$15 -> {
                boxedUnit = x$15;
                return BoxedUnit.UNIT;
            });
        }));
    }

    private Either<AuthorizationError, domain.IdentityProviderId> requireIdentityProviderId(String identityProviderId) {
        return domain.IdentityProviderId$.MODULE$.fromString(identityProviderId).left().map((Function1 & Serializable)reason -> new AuthorizationError.InvalidField("identity_provider_id", (String)reason));
    }

    private Either<AuthorizationError, BoxedUnit> validateRequestIdentityProviderId(domain.IdentityProviderId requestIdentityProviderId, ClaimSet.Claims claims) {
        domain.IdentityProviderId identityProviderId = claims.identityProviderId();
        if (identityProviderId instanceof domain.IdentityProviderId$.Id) {
            domain.IdentityProviderId$.Id id = (domain.IdentityProviderId$.Id)identityProviderId;
            domain.IdentityProviderId identityProviderId2 = requestIdentityProviderId;
            domain.IdentityProviderId$.Id id2 = id;
            if (identityProviderId2 == null ? id2 != null : !identityProviderId2.equals(id2)) {
                return package$.MODULE$.Left().apply((Object)new AuthorizationError.InvalidIdentityProviderId(requestIdentityProviderId));
            }
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private <T> Either<AuthorizationError, BoxedUnit> requireForAll(IterableOnce<T> xs, Function1<T, Either<AuthorizationError, BoxedUnit>> f) {
        return (Either)xs.iterator().foldLeft((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT), (Function2 & Serializable)(acc, x) -> acc.flatMap((Function1 & Serializable)x$17 -> (Either)f.apply(x)));
    }

    public <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> requireReadClaimsForAllPartiesOnStream(Iterable<String> parties, Function2<Req, StreamObserver<Res>, BoxedUnit> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$19 -> {
            BoxedUnit boxedUnit = x$19;
            return this.requireForAll((IterableOnce)parties, (Function1)(Function1 & Serializable)party -> claims.canReadAs((String)party)).map((Function1 & Serializable)x$18 -> {
                boxedUnit = x$18;
                return BoxedUnit.UNIT;
            });
        }));
    }

    public <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> requireReadClaimsForAllPartiesOnStreamWithApplicationId(Iterable<String> parties, Lens<Req, String> applicationIdL, Function2<Req, StreamObserver<Res>, BoxedUnit> call) {
        return this.authorizeWithReq(call, (Function2 & Serializable)(claims, req) -> {
            String reqApplicationId = (String)applicationIdL.get(req);
            return this.authorizationErrorAsGrpc(this.valid((ClaimSet.Claims)claims)).flatMap((Function1 & Serializable)x$22 -> {
                BoxedUnit boxedUnit = x$22;
                return this.authorizationErrorAsGrpc(this.requireForAll((IterableOnce)parties, (Function1)(Function1 & Serializable)party -> claims.canReadAs((String)party))).flatMap((Function1 & Serializable)x$21 -> {
                    BoxedUnit boxedUnit = x$21;
                    return this.defaultApplicationId(reqApplicationId, (ClaimSet.Claims)claims).flatMap((Function1 & Serializable)defaultedApplicationId -> this.authorizationErrorAsGrpc(claims.validForApplication((String)defaultedApplicationId)).map((Function1 & Serializable)x$20 -> {
                        BoxedUnit boxedUnit = x$20;
                        return applicationIdL.set(defaultedApplicationId).apply(req);
                    }));
                });
            });
        });
    }

    public <Req, Res> Function1<Req, Future<Res>> requireReadClaimsForAllParties(Iterable<String> parties, Function1<Req, Future<Res>> call) {
        return this.authorize(call, (Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>>)(Function1 & Serializable)claims -> this.valid((ClaimSet.Claims)claims).flatMap((Function1 & Serializable)x$24 -> {
            BoxedUnit boxedUnit = x$24;
            return this.requireForAll((IterableOnce)parties, (Function1)(Function1 & Serializable)party -> claims.canReadAs((String)party)).map((Function1 & Serializable)x$23 -> {
                boxedUnit = x$23;
                return BoxedUnit.UNIT;
            });
        }));
    }

    public <Req, Res> Function1<Req, Future<Res>> requireActAndReadClaimsForParties(Set<String> actAs, Set<String> readAs, Lens<Req, String> applicationIdL, Function1<Req, Future<Res>> call) {
        return this.authorizeWithReq(call, (Function2 & Serializable)(claims, req) -> {
            String reqApplicationId = (String)applicationIdL.get(req);
            return this.authorizationErrorAsGrpc(this.valid((ClaimSet.Claims)claims)).flatMap((Function1 & Serializable)x$30 -> {
                BoxedUnit boxedUnit = x$30;
                return this.authorizationErrorAsGrpc((Either)actAs.foldRight((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT), (Function2 & Serializable)(p, acc) -> acc.flatMap((Function1 & Serializable)x$25 -> claims.canActAs((String)p)))).flatMap((Function1 & Serializable)x$29 -> {
                    BoxedUnit boxedUnit = x$29;
                    return this.authorizationErrorAsGrpc((Either)readAs.foldRight((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT), (Function2 & Serializable)(p, acc) -> acc.flatMap((Function1 & Serializable)x$26 -> claims.canReadAs((String)p)))).flatMap((Function1 & Serializable)x$28 -> {
                        BoxedUnit boxedUnit = x$28;
                        return this.defaultApplicationId(reqApplicationId, (ClaimSet.Claims)claims).flatMap((Function1 & Serializable)defaultedApplicationId -> this.authorizationErrorAsGrpc(claims.validForApplication((String)defaultedApplicationId)).map((Function1 & Serializable)x$27 -> {
                            BoxedUnit boxedUnit = x$27;
                            return applicationIdL.set(defaultedApplicationId).apply(req);
                        }));
                    });
                });
            });
        });
    }

    public <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> requireReadClaimsForTransactionFilterOnStream(Option<TransactionFilter> filter, Function2<Req, StreamObserver<Res>, BoxedUnit> call) {
        return this.requireReadClaimsForAllPartiesOnStream((Iterable<String>)((Iterable)filter.map((Function1 & Serializable)x$31 -> x$31.filtersByParty()).fold((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable)x$32 -> x$32.keySet())), call);
    }

    public Try<Option<String>> authenticatedUserId() {
        return this.authenticatedClaimsFromContext().flatMap((Function1 & Serializable)claims -> {
            if (claims.resolvedFromUser()) {
                Option<String> option = claims.applicationId();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String applicationId = (String)some.value();
                    return new Success((Object)new Some((Object)applicationId));
                }
                if (None$.MODULE$.equals(option)) {
                    return new Failure((Throwable)new AuthorizationChecks.InternalAuthorizationError$.Reject("unexpectedly the user-id is not set in the authenticated claims", (Throwable)new RuntimeException(), this.errorLogger()).asGrpcError());
                }
                throw new MatchError(option);
            }
            return new Success((Object)None$.MODULE$);
        });
    }

    private Either<StatusRuntimeException, String> defaultApplicationId(String reqApplicationId, ClaimSet.Claims claims) {
        if (reqApplicationId.isEmpty()) {
            Some some;
            String applicationId;
            Option<String> option = claims.applicationId();
            if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(applicationId = (String)(some = (Some)option).value()))) {
                return package$.MODULE$.Right().apply((Object)applicationId);
            }
            return package$.MODULE$.Left().apply((Object)ValidationErrors$.MODULE$.invalidArgument("Cannot default application_id field because claims do not specify an application-id or user-id. Is authentication turned on?", this.errorLogger()));
        }
        return package$.MODULE$.Right().apply((Object)reqApplicationId);
    }

    private <T> Either<StatusRuntimeException, T> authorizationErrorAsGrpc(Either<AuthorizationError, T> errOrV) {
        return (Either)errOrV.fold((Function1 & Serializable)x0$1 -> {
            AuthorizationError authorizationError = x0$1;
            if (authorizationError instanceof AuthorizationError.InvalidField) {
                AuthorizationError.InvalidField invalidField = (AuthorizationError.InvalidField)authorizationError;
                String fieldName = invalidField.fieldName();
                String reason = invalidField.reason();
                return package$.MODULE$.Left().apply((Object)new RequestValidation.InvalidField$.Reject(fieldName, reason, this.errorLogger()).asGrpcError());
            }
            return package$.MODULE$.Left().apply((Object)new AuthorizationChecks.PermissionDenied$.Reject(authorizationError.reason(), this.errorLogger()).asGrpcError());
        }, (Function1 & Serializable)x$33 -> package$.MODULE$.Right().apply(x$33));
    }

    private <A> ServerCallStreamObserver<A> assertServerCall(StreamObserver<A> observer) {
        StreamObserver<A> streamObserver = observer;
        if (streamObserver instanceof ServerCallStreamObserver) {
            return (ServerCallStreamObserver)observer;
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("The wrapped stream MUST be a ").append(ServerCallStreamObserver.class.getName()).toString());
    }

    private <Res> ServerCallStreamObserver<Res> ongoingAuthorization(ServerCallStreamObserver<Res> observer, ClaimSet.Claims claims) {
        return OngoingAuthorizationObserver$.MODULE$.apply(observer, claims, this.now, this.userManagementStore, this.userRightsCheckIntervalInSeconds, this.akkaScheduler, this.jwtTimestampLeeway, this.loggingContext, this.ec);
    }

    private Try<ClaimSet.Claims> authenticatedClaimsFromContext() {
        return AuthorizationInterceptor$.MODULE$.extractClaimSetFromContext().flatMap((Function1 & Serializable)x0$1 -> {
            ClaimSet claimSet = x0$1;
            if (ClaimSet$Unauthenticated$.MODULE$.equals(claimSet)) {
                return new Failure((Throwable)new AuthorizationChecks.Unauthenticated$.MissingJwtToken(this.errorLogger()).asGrpcError());
            }
            if (claimSet instanceof ClaimSet.AuthenticatedUser) {
                ClaimSet.AuthenticatedUser authenticatedUser = (ClaimSet.AuthenticatedUser)claimSet;
                return new Failure((Throwable)new AuthorizationChecks.InternalAuthorizationError$.Reject("Unexpected unresolved authenticated user claim", (Throwable)new RuntimeException(new StringBuilder(57).append("Unexpected unresolved authenticated user claim for user '").append(authenticatedUser.userId()).toString()), this.errorLogger()).asGrpcError());
            }
            if (claimSet instanceof ClaimSet.Claims) {
                ClaimSet.Claims claims = (ClaimSet.Claims)claimSet;
                return new Success((Object)claims);
            }
            throw new MatchError((Object)claimSet);
        });
    }

    private <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> authorizeWithReq(Function2<Req, ServerCallStreamObserver<Res>, BoxedUnit> call, Function2<ClaimSet.Claims, Req, Either<StatusRuntimeException, Req>> authorized) {
        return (Function2 & Serializable)(request, observer) -> {
            Authorizer.$anonfun$authorizeWithReq$1(this, authorized, call, request, observer);
            return BoxedUnit.UNIT;
        };
    }

    private <Req, Res> Function2<Req, StreamObserver<Res>, BoxedUnit> authorize(Function2<Req, ServerCallStreamObserver<Res>, BoxedUnit> call, Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>> authorized) {
        return this.authorizeWithReq(call, (Function2 & Serializable)(claims, req) -> this.authorizationErrorAsGrpc((Either)authorized.apply(claims)).map((Function1 & Serializable)x$34 -> req));
    }

    public <Req, Res> Function1<Req, Future<Res>> authorizeWithReq(Function1<Req, Future<Res>> call, Function2<ClaimSet.Claims, Req, Either<StatusRuntimeException, Req>> authorized) {
        return (Function1 & Serializable)request -> {
            Try<ClaimSet.Claims> try_ = this.authenticatedClaimsFromContext();
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                return Future$.MODULE$.failed(ex);
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ClaimSet.Claims claims = (ClaimSet.Claims)success.value();
                Either either = (Either)authorized.apply((Object)claims, request);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Object modifiedReq = right.value();
                    return (Future)call.apply(modifiedReq);
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    StatusRuntimeException ex = (StatusRuntimeException)left.value();
                    return Future$.MODULE$.failed((Throwable)ex);
                }
                throw new MatchError((Object)either);
            }
            throw new MatchError(try_);
        };
    }

    public <Req, Res> Function1<Req, Future<Res>> authorize(Function1<Req, Future<Res>> call, Function1<ClaimSet.Claims, Either<AuthorizationError, BoxedUnit>> authorized) {
        return this.authorizeWithReq(call, (Function2 & Serializable)(claims, req) -> this.authorizationErrorAsGrpc((Either)authorized.apply(claims)).map((Function1 & Serializable)x$35 -> req));
    }

    public static final /* synthetic */ void $anonfun$authorizeWithReq$3(Authorizer $this, Function2 authorized$1, Object request$1, Function2 call$1, ServerCallStreamObserver serverCallStreamObserver$1, StreamObserver observer$1, ClaimSet.Claims claims) {
        Either either = (Either)authorized$1.apply((Object)claims, request$1);
        if (either instanceof Right) {
            Right right = (Right)either;
            Object modifiedRequest = right.value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)call$1.apply(modifiedRequest, claims.expiration().isDefined() || claims.resolvedFromUser() ? $this.ongoingAuthorization(serverCallStreamObserver$1, claims) : serverCallStreamObserver$1);
            return;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            StatusRuntimeException ex = (StatusRuntimeException)left.value();
            observer$1.onError((Throwable)ex);
            return;
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ void $anonfun$authorizeWithReq$1(Authorizer $this, Function2 authorized$1, Function2 call$1, Object request, StreamObserver observer) {
        ServerCallStreamObserver serverCallStreamObserver = $this.assertServerCall(observer);
        $this.authenticatedClaimsFromContext().fold((Function1 & Serializable)ex -> {
            observer.onError(ex);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)claims -> {
            Authorizer.$anonfun$authorizeWithReq$3($this, authorized$1, request, call$1, serverCallStreamObserver, observer, claims);
            return BoxedUnit.UNIT;
        });
    }

    public Authorizer(Function0<Instant> now, String ledgerId, String participantId, UserManagementStore userManagementStore, ExecutionContext ec, int userRightsCheckIntervalInSeconds, Scheduler akkaScheduler, Option<JwtTimestampLeeway> jwtTimestampLeeway, LoggingContext loggingContext) {
        this.now = now;
        this.ledgerId = ledgerId;
        this.participantId = participantId;
        this.userManagementStore = userManagementStore;
        this.ec = ec;
        this.userRightsCheckIntervalInSeconds = userRightsCheckIntervalInSeconds;
        this.akkaScheduler = akkaScheduler;
        this.jwtTimestampLeeway = jwtTimestampLeeway;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
    }
}

