/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import com.auth0.jwk.UrlJwkProvider;
import com.daml.caching.CaffeineCache;
import com.daml.jwt.Error;
import com.daml.jwt.JwtTimestampLeeway;
import com.daml.jwt.JwtVerifier;
import com.daml.jwt.RSA256Verifier$;
import com.daml.ledger.api.auth.CachedJwtVerifierLoader$;
import com.daml.ledger.api.auth.JwtVerifierLoader;
import com.daml.ledger.api.domain;
import com.daml.metrics.Metrics;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.security.interfaces.RSAPublicKey;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scalaz.;

@ScalaSignature(bytes="\u0006\u0005\tUg\u0001\u0002\u001c8\u0001\tC\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t#\u0002\u0011\t\u0011)A\u0005\u001d\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003O\u0011!q\u0006A!A!\u0002\u0013\u0019\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011\u0001\u0004!\u0011!Q\u0001\nMC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"A\u0011\u000f\u0001B\u0001B\u0003-!\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A!\u0011\u0010\u0001!\u0002\u0013\ty\u0001C\u0004\u0003|\u0001!\tE! \t\u000f\t%\u0005\u0001\"\u0003\u0003\f\"9!q\u0014\u0001\u0005\n\t\u0005\u0006b\u0002BT\u0001\u0011%!\u0011V\u0004\b\u0003\u0003:\u0004\u0012AA\"\r\u00191t\u0007#\u0001\u0002F!1qo\u0005C\u0001\u0003\u000f2a!!\u0013\u0014\u0001\u0006-\u0003BCA3+\tU\r\u0011\"\u0001\u0002h!Q\u0011qO\u000b\u0003\u0012\u0003\u0006I!!\u001b\t\u0015\u0005eTC!f\u0001\n\u0003\tY\b\u0003\u0006\u0002\u0010V\u0011\t\u0012)A\u0005\u0003{Baa^\u000b\u0005\u0002\u0005E\u0005\"CAN+\u0005\u0005I\u0011AAO\u0011%\t\u0019+FI\u0001\n\u0003\t)\u000bC\u0005\u0002<V\t\n\u0011\"\u0001\u0002>\"I\u0011\u0011Y\u000b\u0002\u0002\u0013\u0005\u00131\u0019\u0005\n\u0003\u001f,\u0012\u0011!C\u0001\u0003#D\u0011\"!7\u0016\u0003\u0003%\t!a7\t\u0013\u0005\u001dX#!A\u0005B\u0005%\b\"CA|+\u0005\u0005I\u0011AA}\u0011%\u0011\u0019!FA\u0001\n\u0003\u0012)\u0001C\u0005\u0003\nU\t\t\u0011\"\u0011\u0003\f!I!QB\u000b\u0002\u0002\u0013\u0005#q\u0002\u0005\n\u0005#)\u0012\u0011!C!\u0005'9\u0011Ba\u0006\u0014\u0003\u0003E\tA!\u0007\u0007\u0013\u0005%3#!A\t\u0002\tm\u0001BB<)\t\u0003\u0011\u0019\u0004C\u0005\u0003\u000e!\n\t\u0011\"\u0012\u0003\u0010!I!Q\u0007\u0015\u0002\u0002\u0013\u0005%q\u0007\u0005\n\u0005{A\u0013\u0011!CA\u0005\u007fA\u0011B!\u0014)\u0003\u0003%IAa\u0014\t\u0013\t]3#%A\u0005\u0002\te\u0003\"\u0003B/'E\u0005I\u0011\u0001B-\u0011%\u0011yfEI\u0001\n\u0003\u0011\t\u0007C\u0005\u0003fM\t\n\u0011\"\u0001\u0003Z!I!qM\n\u0012\u0002\u0013\u0005!\u0011\r\u0005\n\u0005S\u001a\u0012\u0013!C\u0001\u00053B\u0011Ba\u001b\u0014#\u0003%\tA!\u0019\t\u0013\t54#%A\u0005\u0002\t=$aF\"bG\",GMS<u-\u0016\u0014\u0018NZ5fe2{\u0017\rZ3s\u0015\tA\u0014(\u0001\u0003bkRD'B\u0001\u001e<\u0003\r\t\u0007/\u001b\u0006\u0003yu\na\u0001\\3eO\u0016\u0014(B\u0001 @\u0003\u0011!\u0017-\u001c7\u000b\u0003\u0001\u000b1aY8n\u0007\u0001\u00192\u0001A\"J!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0019\te.\u001f*fMB\u0011!jS\u0007\u0002o%\u0011Aj\u000e\u0002\u0012\u0015^$h+\u001a:jM&,'\u000fT8bI\u0016\u0014\u0018\u0001D2bG\",W*\u0019=TSj,\u0007C\u0001#P\u0013\t\u0001VI\u0001\u0003M_:<\u0017aE2bG\",W\t\u001f9je\u0006$\u0018n\u001c8US6,\u0017aE2bG\",W\t\u001f9je\u0006$\u0018n\u001c8V]&$\bC\u0001+\\\u001b\u0005)&B\u0001,X\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u00031f\u000bA!\u001e;jY*\t!,\u0001\u0003kCZ\f\u0017B\u0001/V\u0005!!\u0016.\\3V]&$\u0018!E2p]:,7\r^5p]RKW.Z8vi\u0006)2m\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;V]&$\u0018a\u0003:fC\u0012$\u0016.\\3pkR\fqB]3bIRKW.Z8viVs\u0017\u000e^\u0001\u0013U^$H+[7fgR\fW\u000e\u001d'fK^\f\u0017\u0010E\u0002EG\u0016L!\u0001Z#\u0003\r=\u0003H/[8o!\t1\u0017.D\u0001h\u0015\tAW(A\u0002koRL!A[4\u0003%);H\u000fV5nKN$\u0018-\u001c9MK\u0016<\u0018-_\u0001\b[\u0016$(/[2t!\tiw.D\u0001o\u0015\tYW(\u0003\u0002q]\n9Q*\u001a;sS\u000e\u001c\u0018\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\t\u0019X/D\u0001u\u0015\t1V)\u0003\u0002wi\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001fedXP`@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013!\"A_>\u0011\u0005)\u0003\u0001\"B9\f\u0001\b\u0011\bbB'\f!\u0003\u0005\rA\u0014\u0005\b#.\u0001\n\u00111\u0001O\u0011\u001d\u00116\u0002%AA\u0002MCq!X\u0006\u0011\u0002\u0003\u0007a\nC\u0004_\u0017A\u0005\t\u0019A*\t\u000f}[\u0001\u0013!a\u0001\u001d\"9\u0001m\u0003I\u0001\u0002\u0004\u0019\u0006bB1\f!\u0003\u0005\rA\u0019\u0005\u0006W.\u0001\r\u0001\\\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0003\u0003\u001f\u0001\u0002\"!\u0005\u0002\u001e\u0005\r\"1\u000f\b\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC\u001f\u0002\u000f\r\f7\r[5oO&!\u00111DA\u000b\u00035\u0019\u0015M\u001a4fS:,7)Y2iK&!\u0011qDA\u0011\u0005e\t5/\u001f8d\u0019>\fG-\u001b8h\u0007\u00064g-Z5oK\u000e\u000b7\r[3\u000b\t\u0005m\u0011Q\u0003\t\u0004\u0003K)bbAA\u0014%9!\u0011\u0011FA \u001d\u0011\tY#!\u0010\u000f\t\u00055\u00121\b\b\u0005\u0003_\tID\u0004\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)$Q\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001K!AP \n\u0005qj\u0014B\u0001\u001e<\u0013\tA\u0014(A\fDC\u000eDW\r\u001a&xiZ+'/\u001b4jKJdu.\u00193feB\u0011!jE\n\u0003'\r#\"!a\u0011\u0003\u0011\r\u000b7\r[3LKf\u001cb!F\"\u0002N\u0005M\u0003c\u0001#\u0002P%\u0019\u0011\u0011K#\u0003\u000fA\u0013x\u000eZ;diB!\u0011QKA0\u001d\u0011\t9&a\u0017\u000f\t\u0005E\u0012\u0011L\u0005\u0002\r&\u0019\u0011QL#\u0002\u000fA\f7m[1hK&!\u0011\u0011MA2\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\ti&R\u0001\bU^\\7/\u0016:m+\t\tI\u0007\u0005\u0003\u0002l\u0005Ed\u0002BA\u0015\u0003[J1!a\u001c:\u0003\u0019!w.\\1j]&!\u00111OA;\u0005\u001dQuo[:Ve2T1!a\u001c:\u0003!Qwo[:Ve2\u0004\u0013!B6fs&#WCAA?!\u0011!5-a \u0011\t\u0005\u0005\u0015\u0011\u0012\b\u0005\u0003\u0007\u000b)\tE\u0002\u00022\u0015K1!a\"F\u0003\u0019\u0001&/\u001a3fM&!\u00111RAG\u0005\u0019\u0019FO]5oO*\u0019\u0011qQ#\u0002\r-,\u00170\u00133!)\u0019\t\u0019*a&\u0002\u001aB\u0019\u0011QS\u000b\u000e\u0003MAq!!\u001a\u001b\u0001\u0004\tI\u0007C\u0004\u0002zi\u0001\r!! \u0002\t\r|\u0007/\u001f\u000b\u0007\u0003'\u000by*!)\t\u0013\u0005\u00154\u0004%AA\u0002\u0005%\u0004\"CA=7A\u0005\t\u0019AA?\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a*+\t\u0005%\u0014\u0011V\u0016\u0003\u0003W\u0003B!!,\u000286\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,A\u0005v]\u000eDWmY6fI*\u0019\u0011QW#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002:\u0006=&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA`U\u0011\ti(!+\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\r\u0005\u0003\u0002H\u00065WBAAe\u0015\r\tY-W\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\f\u0006%\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAj!\r!\u0015Q[\u0005\u0004\u0003/,%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAo\u0003G\u00042\u0001RAp\u0013\r\t\t/\u0012\u0002\u0004\u0003:L\b\"CAsA\u0005\u0005\t\u0019AAj\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001e\t\u0007\u0003[\f\u00190!8\u000e\u0005\u0005=(bAAy\u000b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0018q\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002|\n\u0005\u0001c\u0001#\u0002~&\u0019\u0011q`#\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u001d\u0012\u0002\u0002\u0003\u0007\u0011Q\\\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002F\n\u001d\u0001\"CAsG\u0005\u0005\t\u0019AAj\u0003!A\u0017m\u001d5D_\u0012,GCAAj\u0003!!xn\u0015;sS:<GCAAc\u0003\u0019)\u0017/^1mgR!\u00111 B\u000b\u0011%\t)OJA\u0001\u0002\u0004\ti.\u0001\u0005DC\u000eDWmS3z!\r\t)\nK\n\u0006Q\tu!\u0011\u0006\t\u000b\u0005?\u0011)#!\u001b\u0002~\u0005MUB\u0001B\u0011\u0015\r\u0011\u0019#R\u0001\beVtG/[7f\u0013\u0011\u00119C!\t\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\r\u0011y#W\u0001\u0003S>LA!!\u0019\u0003.Q\u0011!\u0011D\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003'\u0013IDa\u000f\t\u000f\u0005\u00154\u00061\u0001\u0002j!9\u0011\u0011P\u0016A\u0002\u0005u\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0003\u0012I\u0005\u0005\u0003EG\n\r\u0003c\u0002#\u0003F\u0005%\u0014QP\u0005\u0004\u0005\u000f*%A\u0002+va2,'\u0007C\u0005\u0003L1\n\t\u00111\u0001\u0002\u0014\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tE\u0003\u0003BAd\u0005'JAA!\u0016\u0002J\n1qJ\u00196fGR\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTC\u0001B.U\rq\u0015\u0011V\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019GK\u0002T\u0003S\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011\tHK\u0002c\u0003S\u00032A\u001aB;\u0013\r\u00119h\u001a\u0002\f\u0015^$h+\u001a:jM&,'/\u0001\u0004dC\u000eDW\rI\u0001\u0010Y>\fGMS<u-\u0016\u0014\u0018NZ5feR1!q\u0010BC\u0005\u000f\u0003Ra\u001dBA\u0005gJ1Aa!u\u0005\u00191U\u000f^;sK\"9\u0011Q\r\bA\u0002\u0005%\u0004bBA=\u001d\u0001\u0007\u0011QP\u0001\fU^\\\u0007K]8wS\u0012,'\u000f\u0006\u0003\u0003\u000e\nu\u0005\u0003\u0002BH\u00053k!A!%\u000b\t\tM%QS\u0001\u0004U^\\'b\u0001BL\u007f\u0005)\u0011-\u001e;ia%!!1\u0014BI\u00059)&\u000f\u001c&xWB\u0013xN^5eKJDq!!\u001a\u0010\u0001\u0004\tI'A\u0006hKR4VM]5gS\u0016\u0014H\u0003\u0002B@\u0005GCqA!*\u0011\u0001\u0004\t\u0019#A\u0002lKf\fqB\u001a:p[\u0012K7O[;oGRLwN\\\u000b\u0005\u0005W\u0013\u0019\f\u0006\u0003\u0003.\n}\u0006#B:\u0003\u0002\n=\u0006\u0003\u0002BY\u0005gc\u0001\u0001B\u0004\u00036F\u0011\rAa.\u0003\u0003Q\u000bBA!/\u0002^B\u0019AIa/\n\u0007\tuVIA\u0004O_RD\u0017N\\4\t\u000f\t\u0005\u0017\u00031\u0001\u0003D\u0006\tQ\r\u0005\u0005\u0003F\n-'q\u001aBX\u001b\t\u00119M\u0003\u0002\u0003J\u000611oY1mCjLAA!4\u0003H\nYAEY:mCNDG\u0005Z5w!\r1'\u0011[\u0005\u0004\u0005'<'!B#se>\u0014\b")
public class CachedJwtVerifierLoader
implements JwtVerifierLoader {
    private final long connectionTimeout;
    private final TimeUnit connectionTimeoutUnit;
    private final long readTimeout;
    private final TimeUnit readTimeoutUnit;
    private final Option<JwtTimestampLeeway> jwtTimestampLeeway;
    private final ExecutionContext executionContext;
    private final CaffeineCache.AsyncLoadingCaffeineCache<CacheKey, JwtVerifier> cache;

    public static Option<JwtTimestampLeeway> $lessinit$greater$default$8() {
        return CachedJwtVerifierLoader$.MODULE$.$lessinit$greater$default$8();
    }

    public static TimeUnit $lessinit$greater$default$7() {
        return CachedJwtVerifierLoader$.MODULE$.$lessinit$greater$default$7();
    }

    public static long $lessinit$greater$default$6() {
        return CachedJwtVerifierLoader$.MODULE$.$lessinit$greater$default$6();
    }

    public static TimeUnit $lessinit$greater$default$5() {
        return CachedJwtVerifierLoader$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return CachedJwtVerifierLoader$.MODULE$.$lessinit$greater$default$4();
    }

    public static TimeUnit $lessinit$greater$default$3() {
        return CachedJwtVerifierLoader$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return CachedJwtVerifierLoader$.MODULE$.$lessinit$greater$default$2();
    }

    public static long $lessinit$greater$default$1() {
        return CachedJwtVerifierLoader$.MODULE$.$lessinit$greater$default$1();
    }

    private CaffeineCache.AsyncLoadingCaffeineCache<CacheKey, JwtVerifier> cache() {
        return this.cache;
    }

    @Override
    public Future<JwtVerifier> loadJwtVerifier(String jwksUrl, Option<String> keyId) {
        return this.cache().get((Object)new CacheKey(jwksUrl, keyId));
    }

    private UrlJwkProvider jwkProvider(String jwksUrl) {
        return new UrlJwkProvider(domain.JwksUrl$.MODULE$.toURL$extension(jwksUrl), Integer.valueOf((int)this.connectionTimeoutUnit.toMillis(this.connectionTimeout)), Integer.valueOf((int)this.readTimeoutUnit.toMillis(this.readTimeout)));
    }

    private Future<JwtVerifier> getVerifier(CacheKey key) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> this.jwkProvider(key.jwksUrl()).get((String)key.keyId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), this.executionContext).map((Function1 & Serializable)jwk -> {
            RSAPublicKey publicKey = (RSAPublicKey)jwk.getPublicKey();
            return new Tuple2(jwk, (Object)publicKey);
        }, this.executionContext).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RSAPublicKey publicKey = (RSAPublicKey)tuple2._2();
                return this.fromDisjunction(RSA256Verifier$.MODULE$.apply(publicKey, $this.jwtTimestampLeeway)).map((Function1 & Serializable)verifier -> verifier, $this.executionContext);
            }
            throw new MatchError((Object)tuple2);
        }, this.executionContext);
    }

    private <T> Future<T> fromDisjunction(.bslash.div<Error, T> e) {
        return (Future)e.fold((Function1 & Serializable)err -> Future$.MODULE$.failed((Throwable)new Exception(err.message())), (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    public CachedJwtVerifierLoader(long cacheMaxSize, long cacheExpirationTime, TimeUnit cacheExpirationUnit, long connectionTimeout, TimeUnit connectionTimeoutUnit, long readTimeout, TimeUnit readTimeoutUnit, Option<JwtTimestampLeeway> jwtTimestampLeeway, Metrics metrics, ExecutionContext executionContext) {
        this.connectionTimeout = connectionTimeout;
        this.connectionTimeoutUnit = connectionTimeoutUnit;
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = readTimeoutUnit;
        this.jwtTimestampLeeway = jwtTimestampLeeway;
        this.executionContext = executionContext;
        this.cache = new CaffeineCache.AsyncLoadingCaffeineCache(Caffeine.newBuilder().expireAfterWrite(cacheExpirationTime, cacheExpirationUnit).maximumSize(cacheMaxSize).buildAsync((AsyncCacheLoader)new CaffeineCache.FutureAsyncCacheLoader((Function1 & Serializable)key -> this.getVerifier((CacheKey)key), executionContext)), metrics.daml().identityProviderConfigStore().verifierCache());
    }

    public static class CacheKey
    implements Product,
    Serializable {
        private final String jwksUrl;
        private final Option<String> keyId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String jwksUrl() {
            return this.jwksUrl;
        }

        public Option<String> keyId() {
            return this.keyId;
        }

        public CacheKey copy(String jwksUrl, Option<String> keyId) {
            return new CacheKey(jwksUrl, keyId);
        }

        public String copy$default$1() {
            return this.jwksUrl();
        }

        public Option<String> copy$default$2() {
            return this.keyId();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return new domain.JwksUrl(this.jwksUrl());
                }
                case 1: {
                    return this.keyId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "jwksUrl";
                }
                case 1: {
                    return "keyId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.jwksUrl();
            String string2 = cacheKey.jwksUrl();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.keyId();
            Option<String> option2 = cacheKey.keyId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String jwksUrl, Option<String> keyId) {
            this.jwksUrl = jwksUrl;
            this.keyId = keyId;
            Product.$init$((Product)this);
        }
    }
}

