/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import com.auth0.jwt.JWT;
import com.daml.jwt.Error;
import com.daml.jwt.JwtFromBearerHeader$;
import com.daml.jwt.JwtVerifier;
import com.daml.jwt.domain.DecodedJwt;
import com.daml.jwt.domain.Jwt;
import com.daml.ledger.api.auth.AuthService$;
import com.daml.ledger.api.auth.AuthServiceJWTCodec$JsonImplicits$AuthServiceJWTPayloadFormat$;
import com.daml.ledger.api.auth.AuthServiceJWTPayload;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.ClaimSet$Unauthenticated$;
import com.daml.ledger.api.auth.CustomDamlJWTPayload;
import com.daml.ledger.api.auth.IdentityProviderConfigLoader;
import com.daml.ledger.api.auth.JwtVerifierLoader;
import com.daml.ledger.api.auth.StandardJWTPayload;
import com.daml.ledger.api.auth.interceptor.IdentityProviderAwareAuthService;
import com.daml.ledger.api.domain;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import io.grpc.Metadata;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import spray.json.JsonParser$;
import spray.json.JsonReader;
import spray.json.ParserInput;
import spray.json.ParserInput$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\t\u0013\u0001uA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003-A\u0007\u0003\u0005;\u0001\t\u0005\t\u0015a\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001dI\u0005A1A\u0005\f)CaA\u0014\u0001!\u0002\u0013Y\u0005\"B(\u0001\t\u0003\u0001\u0006\"B1\u0001\t\u0013\u0011\u0007\"\u0002:\u0001\t\u0013\u0019\b\"\u0002<\u0001\t\u00039\b\"\u0002@\u0001\t\u0013y\bbBA\u0011\u0001\u0011%\u00111\u0005\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\t\t\b\u0001C\u0005\u0003gBq!a\u001e\u0001\t\u0013\tIH\u0001\u0013JI\u0016tG/\u001b;z!J|g/\u001b3fe\u0006;\u0018M]3BkRD7+\u001a:wS\u000e,\u0017*\u001c9m\u0015\t\u0019B#\u0001\u0003bkRD'BA\u000b\u0017\u0003\r\t\u0007/\u001b\u0006\u0003/a\ta\u0001\\3eO\u0016\u0014(BA\r\u001b\u0003\u0011!\u0017-\u001c7\u000b\u0003m\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011Q\u0005K\u0007\u0002M)\u0011qEE\u0001\fS:$XM]2faR|'/\u0003\u0002*M\t\u0001\u0013\nZ3oi&$\u0018\u0010\u0015:pm&$WM]!xCJ,\u0017)\u001e;i'\u0016\u0014h/[2f\u0003qIG-\u001a8uSRL\bK]8wS\u0012,'oQ8oM&<Gj\\1eKJ\u0004\"\u0001L\u0017\u000e\u0003II!A\f\n\u00039%#WM\u001c;jif\u0004&o\u001c<jI\u0016\u00148i\u001c8gS\u001edu.\u00193fe\u0006\t\"n\u001e;WKJLg-[3s\u0019>\fG-\u001a:\u0011\u00051\n\u0014B\u0001\u001a\u0013\u0005EQu\u000f\u001e,fe&4\u0017.\u001a:M_\u0006$WM]\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0011\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002:m\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u000fY><w-\u001b8h\u0007>tG/\u001a=u!\tat(D\u0001>\u0015\tq\u0004$A\u0004m_\u001e<\u0017N\\4\n\u0005\u0001k$A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r;\u0005\nF\u0002E\u000b\u001a\u0003\"\u0001\f\u0001\t\u000bM*\u00019\u0001\u001b\t\u000bi*\u00019A\u001e\t\u000b)*\u0001\u0019A\u0016\t\u000b=*\u0001\u0019\u0001\u0019\u0002\r1|wmZ3s+\u0005Y\u0005C\u0001\u001fM\u0013\tiUH\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u00039!WmY8eK6+G/\u00193bi\u0006$\"!U,\u0011\u0007U\u0012F+\u0003\u0002Tm\t1a)\u001e;ve\u0016\u0004\"\u0001L+\n\u0005Y\u0013\"\u0001C\"mC&l7+\u001a;\t\u000baC\u0001\u0019A-\u0002\u000f!,\u0017\rZ3sgB\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0005OJ\u00048MC\u0001_\u0003\tIw.\u0003\u0002a7\nAQ*\u001a;bI\u0006$\u0018-\u0001\fhKR\fU\u000f\u001e5pe&T\u0018\r^5p]\"+\u0017\rZ3s)\t\u0019\u0017\u000fE\u0002 I\u001aL!!\u001a\u0011\u0003\r=\u0003H/[8o!\t9gN\u0004\u0002iYB\u0011\u0011\u000eI\u0007\u0002U*\u00111\u000eH\u0001\u0007yI|w\u000e\u001e \n\u00055\u0004\u0013A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\u001c\u0011\t\u000baK\u0001\u0019A-\u0002\u001fA\f'o]3K/R\u0003\u0016-\u001f7pC\u0012$\"!\u0015;\t\u000bUT\u0001\u0019\u00014\u0002\r!,\u0017\rZ3s\u00035)\u0007\u0010\u001e:bGR\u001cE.Y5ngR!\u0011\u000b\u001f>}\u0011\u0015I8\u00021\u0001g\u0003\u0015!xn[3o\u0011\u0015Y8\u00021\u0001d\u0003\u0019I7o];fe\")Qp\u0003a\u0001G\u0006)1.Z=JI\u0006Ya/\u001a:jMf$vn[3o)\u0019\t\t!a\u0005\u0002\u0016A!QGUA\u0002!\u0015\t)!a\u0004g\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011A\u00023p[\u0006LgNC\u0002\u0002\u000ea\t1A[<u\u0013\u0011\t\t\"a\u0002\u0003\u0015\u0011+7m\u001c3fI*;H\u000fC\u0003z\u0019\u0001\u0007a\rC\u0004\u0002\u00181\u0001\r!!\u0007\u0002\u0011Y,'/\u001b4jKJ\u0004B!a\u0007\u0002\u001e5\u0011\u00111B\u0005\u0005\u0003?\tYAA\u0006KoR4VM]5gS\u0016\u0014\u0018\u0001\u0003;p\rV$XO]3\u0016\t\u0005\u0015\u0012Q\u0006\u000b\u0005\u0003O\ty\u0004\u0005\u00036%\u0006%\u0002\u0003BA\u0016\u0003[a\u0001\u0001B\u0004\u000205\u0011\r!!\r\u0003\u0003Q\u000bB!a\r\u0002:A\u0019q$!\u000e\n\u0007\u0005]\u0002EA\u0004O_RD\u0017N\\4\u0011\u0007}\tY$C\u0002\u0002>\u0001\u00121!\u00118z\u0011\u001d\t\t%\u0004a\u0001\u0003\u0007\n\u0011!\u001a\t\t\u0003\u000b\ny%!\u0016\u0002*9!\u0011qIA&\u001d\rI\u0017\u0011J\u0005\u0002C%\u0019\u0011Q\n\u0011\u0002\u000fA\f7m[1hK&!\u0011\u0011KA*\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011Q\n\u0011\u0011\t\u0005m\u0011qK\u0005\u0005\u00033\nYAA\u0003FeJ|'/\u0001\u0007qCJ\u001cX\rU1zY>\fG\r\u0006\u0003\u0002`\u0005\u001d\u0004\u0003B\u001bS\u0003C\u00022\u0001LA2\u0013\r\t)G\u0005\u0002\u0013'R\fg\u000eZ1sI*;F\u000bU1zY>\fG\rC\u0004\u0002j9\u0001\r!a\u001b\u0002\u0015)<H\u000fU1zY>\fG\rE\u0002-\u0003[J1!a\u001c\u0013\u0005U\tU\u000f\u001e5TKJ4\u0018nY3K/R\u0003\u0016-\u001f7pC\u0012\fQ\u0001]1sg\u0016$B!a\u001b\u0002v!1\u0011\u0011N\bA\u0002\u0019\f1\u0003^8BkRDWM\u001c;jG\u0006$X\rZ+tKJ$b!a\u001f\u0002\n\u00065\u0005\u0003BA?\u0003\u0007s1\u0001LA@\u0013\r\t\tIE\u0001\t\u00072\f\u0017.\\*fi&!\u0011QQAD\u0005E\tU\u000f\u001e5f]RL7-\u0019;fIV\u001bXM\u001d\u0006\u0004\u0003\u0003\u0013\u0002bBAF!\u0001\u0007\u0011\u0011M\u0001\ba\u0006LHn\\1e\u0011\u001d\ty\t\u0005a\u0001\u0003#\u000b!!\u001b3\u0011\t\u0005M\u0015q\u0016\b\u0005\u0003+\u000bIK\u0004\u0003\u0002\u0018\u0006\u001df\u0002BAM\u0003KsA!a'\u0002$:!\u0011QTAQ\u001d\rI\u0017qT\u0005\u00027%\u0011\u0011DG\u0005\u0003/aI!!\u0006\f\n\u0007\u0005%A#\u0003\u0003\u0002,\u00065\u0016AE%eK:$\u0018\u000e^=Qe>4\u0018\u000eZ3s\u0013\u0012T1!!\u0003\u0015\u0013\u0011\t\t,a-\u0003\u0005%#'\u0002BAV\u0003[\u0003")
public class IdentityProviderAwareAuthServiceImpl
implements IdentityProviderAwareAuthService {
    private final IdentityProviderConfigLoader identityProviderConfigLoader;
    private final JwtVerifierLoader jwtVerifierLoader;
    private final ExecutionContext executionContext;
    public final LoggingContext com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$loggingContext;
    private final ContextualizedLogger com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$logger;

    public ContextualizedLogger com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$logger() {
        return this.com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$logger;
    }

    @Override
    public Future<ClaimSet> decodeMetadata(Metadata headers) {
        Option<String> option = this.getAuthorizationHeader(headers);
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)ClaimSet$Unauthenticated$.MODULE$);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String header = (String)some.value();
            return this.parseJWTPayload(header).recover((PartialFunction)new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ IdentityProviderAwareAuthServiceImpl $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    this.$outer.com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$logger().warn().apply((Function0 & Serializable)() -> new StringBuilder(31).append("Failed to authorize the token: ").append(A1.getMessage()).toString(), this.$outer.com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$loggingContext);
                    return (B1)ClaimSet$Unauthenticated$.MODULE$;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.Throwable )}, serializedLambda);
                }
            }, this.executionContext);
        }
        throw new MatchError(option);
    }

    private Option<String> getAuthorizationHeader(Metadata headers) {
        return Option$.MODULE$.apply(headers.get(AuthService$.MODULE$.AUTHORIZATION_KEY()));
    }

    private Future<ClaimSet> parseJWTPayload(String header) {
        return this.toFuture(JwtFromBearerHeader$.MODULE$.apply(header)).flatMap((Function1 & Serializable)token -> Future$.MODULE$.apply((Function0 & Serializable)() -> JWT.decode((String)token), $this.executionContext).flatMap((Function1 & Serializable)decodedJWT -> this.extractClaims((String)token, (Option<String>)Option$.MODULE$.apply((Object)decodedJWT.getIssuer()), (Option<String>)Option$.MODULE$.apply((Object)decodedJWT.getKeyId())).map((Function1 & Serializable)claims -> claims, $this.executionContext), $this.executionContext), this.executionContext);
    }

    public Future<ClaimSet> extractClaims(String token, Option<String> issuer, Option<String> keyId) {
        Option<String> option = issuer;
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)ClaimSet$Unauthenticated$.MODULE$);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String issuer2 = (String)some.value();
            return this.identityProviderConfigLoader.getIdentityProviderConfig(issuer2, this.com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$loggingContext).flatMap((Function1 & Serializable)identityProviderConfig -> $this.jwtVerifierLoader.loadJwtVerifier(identityProviderConfig.jwksUrl(), keyId).flatMap((Function1 & Serializable)verifier -> this.verifyToken(token, (JwtVerifier)verifier).flatMap((Function1 & Serializable)decodedJwt -> Future$.MODULE$.apply((Function0 & Serializable)() -> this.parse((String)decodedJwt.payload()), $this.executionContext).flatMap((Function1 & Serializable)payload -> this.parsePayload((AuthServiceJWTPayload)payload).map((Function1 & Serializable)jwtPayload -> this.toAuthenticatedUser((StandardJWTPayload)jwtPayload, identityProviderConfig.identityProviderId()), $this.executionContext), $this.executionContext), $this.executionContext), $this.executionContext), this.executionContext);
        }
        throw new MatchError(option);
    }

    private Future<DecodedJwt<String>> verifyToken(String token, JwtVerifier verifier) {
        return this.toFuture(verifier.verify(new Jwt(token)).toEither());
    }

    private <T> Future<T> toFuture(Either<Error, T> e) {
        return (Future)e.fold((Function1 & Serializable)err -> Future$.MODULE$.failed((Throwable)new Exception(err.message())), (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Future<StandardJWTPayload> parsePayload(AuthServiceJWTPayload jwtPayload) {
        AuthServiceJWTPayload authServiceJWTPayload = jwtPayload;
        if (authServiceJWTPayload instanceof CustomDamlJWTPayload) {
            return Future$.MODULE$.failed((Throwable)new Exception("Unexpected token payload format"));
        }
        if (authServiceJWTPayload instanceof StandardJWTPayload) {
            StandardJWTPayload standardJWTPayload = (StandardJWTPayload)authServiceJWTPayload;
            return Future$.MODULE$.successful((Object)standardJWTPayload);
        }
        throw new MatchError((Object)authServiceJWTPayload);
    }

    private AuthServiceJWTPayload parse(String jwtPayload) {
        return (AuthServiceJWTPayload)JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(jwtPayload)).convertTo((JsonReader)AuthServiceJWTCodec$JsonImplicits$AuthServiceJWTPayloadFormat$.MODULE$);
    }

    private ClaimSet.AuthenticatedUser toAuthenticatedUser(StandardJWTPayload payload, domain.IdentityProviderId$.Id id) {
        domain.IdentityProviderId$.Id x$1 = id;
        Option<String> x$2 = payload.participantId();
        String x$3 = payload.userId();
        Option<Instant> x$4 = payload.exp();
        return new ClaimSet.AuthenticatedUser((domain.IdentityProviderId)x$1, x$3, x$2, x$4);
    }

    public IdentityProviderAwareAuthServiceImpl(IdentityProviderConfigLoader identityProviderConfigLoader, JwtVerifierLoader jwtVerifierLoader, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.identityProviderConfigLoader = identityProviderConfigLoader;
        this.jwtVerifierLoader = jwtVerifierLoader;
        this.executionContext = executionContext;
        this.com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$loggingContext = loggingContext;
        this.com$daml$ledger$api$auth$IdentityProviderAwareAuthServiceImpl$$logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

