/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import akka.actor.Scheduler;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.AuthorizationChecks;
import com.daml.jwt.JwtTimestampLeeway;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.OngoingAuthorizationObserver$;
import com.daml.ledger.api.auth.UserRightsChangeAsyncChecker;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.localstore.api.UserManagementStore;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t-e!B\u0014)\u0005!\u0012\u0004\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u00119\u0003!\u0011!Q\u0001\n=C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!I\bA!A!\u0002\u0013Q\bBCA\u0002\u0001\t\u0005\t\u0015a\u0003\u0002\u0006!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0011!\t\u0019\u0004\u0001Q\u0001\n\u00055\u0002\"CA\u001b\u0001\t\u0007I\u0011BA\u001c\u0011!\t)\u0005\u0001Q\u0001\n\u0005e\u0002\"CA$\u0001\u0001\u0007I\u0011BA%\u0011%\t\t\u0006\u0001a\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0015BA&\u0011%\t\t\u0007\u0001b\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA3\u0011\u001d\tY\u0007\u0001C!\u0003[Bq!a\u001c\u0001\t\u0003\n\t\bC\u0004\u0002\u0004\u0002!\t%!\"\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002n!9\u00111\u0015\u0001\u0005B\u0005\u0015\u0006bBAU\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\t)\f\u0001C!\u0003oCq!!0\u0001\t\u0003\ny\fC\u0004\u0002F\u0002!\t%a2\t\u000f\u0005}\u0007\u0001\"\u0011\u0002,\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0005\u000b\u0001A\u0011\u0002B\u0004\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001b9\u0001Ba\u0004)\u0011\u0003A#\u0011\u0003\u0004\bO!B\t\u0001\u000bB\n\u0011\u001d\t\tb\tC\u0001\u00057AqA!\b$\t\u0003\u0011y\u0002C\u0005\u0003p\r\n\n\u0011\"\u0001\u0003r\tarJ\\4pS:<\u0017)\u001e;i_JL'0\u0019;j_:|%m]3sm\u0016\u0014(BA\u0015+\u0003\u0011\tW\u000f\u001e5\u000b\u0005-b\u0013aA1qS*\u0011QFL\u0001\u0007Y\u0016$w-\u001a:\u000b\u0005=\u0002\u0014\u0001\u00023b[2T\u0011!M\u0001\u0004G>lWCA\u001aA'\t\u0001A\u0007E\u00026yyj\u0011A\u000e\u0006\u0003oa\nAa\u001d;vE*\u0011\u0011HO\u0001\u0005OJ\u00048MC\u0001<\u0003\tIw.\u0003\u0002>m\tA2+\u001a:wKJ\u001c\u0015\r\u001c7TiJ,\u0017-\\(cg\u0016\u0014h/\u001a:\u0011\u0005}\u0002E\u0002\u0001\u0003\u0006\u0003\u0002\u0011\ra\u0011\u0002\u0002\u0003\u000e\u0001\u0011C\u0001#K!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!R&\n\u000513%aA!os\u0006AqNY:feZ,'/\u0001\bpe&<\u0017N\\1m\u00072\f\u0017.\\:\u0011\u0005A#fBA)S\u001b\u0005A\u0013BA*)\u0003!\u0019E.Y5n'\u0016$\u0018BA+W\u0005\u0019\u0019E.Y5ng*\u00111\u000bK\u0001\u0005]><h\tE\u0002F3nK!A\u0017$\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001/b\u001b\u0005i&B\u00010`\u0003\u0011!\u0018.\\3\u000b\u0003\u0001\fAA[1wC&\u0011!-\u0018\u0002\b\u0013:\u001cH/\u00198u\u0003I)8/\u001a:SS\u001eDGo]\"iK\u000e\\WM](\u0011\u0007\u0015+w-\u0003\u0002g\r\n1q\n\u001d;j_:\u0004\"!\u00155\n\u0005%D#\u0001H+tKJ\u0014\u0016n\u001a5ug\u000eC\u0017M\\4f\u0003NLhnY\"iK\u000e\\WM]\u0001!kN,'OU5hQR\u001c8\t[3dW&sG/\u001a:wC2LenU3d_:$7\u000f\u0005\u0002FY&\u0011QN\u0012\u0002\u0004\u0013:$\u0018a\u00067bgR,6/\u001a:SS\u001eDGo]\"iK\u000e\\G+[7f!\r\u0001xoW\u0007\u0002c*\u0011!o]\u0001\u0007CR|W.[2\u000b\u0005Q,\u0018AC2p]\u000e,(O]3oi*\u0011aoX\u0001\u0005kRLG.\u0003\u0002yc\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW-\u0001\nkoR$\u0016.\\3ti\u0006l\u0007\u000fT3fo\u0006L\bcA#fwB\u0011Ap`\u0007\u0002{*\u0011aPL\u0001\u0004U^$\u0018bAA\u0001{\n\u0011\"j\u001e;US6,7\u000f^1na2+Wm^1z\u00039awnZ4j]\u001e\u001cuN\u001c;fqR\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017q\u0013a\u00027pO\u001eLgnZ\u0005\u0005\u0003\u001f\tIA\u0001\bM_\u001e<\u0017N\\4D_:$X\r\u001f;\u0002\rqJg.\u001b;?)A\t)\"a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9\u0003\u0006\u0003\u0002\u0018\u0005e\u0001cA)\u0001}!9\u00111A\u0005A\u0004\u0005\u0015\u0001\"B'\n\u0001\u0004!\u0004\"\u0002(\n\u0001\u0004y\u0005\"B,\n\u0001\u0004A\u0006\"B2\n\u0001\u0004!\u0007\"\u00026\n\u0001\u0004Y\u0007\"\u00028\n\u0001\u0004y\u0007\"B=\n\u0001\u0004Q\u0018A\u00027pO\u001e,'/\u0006\u0002\u0002.A!\u0011qAA\u0018\u0013\u0011\t\t$!\u0003\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\n1\"\u001a:s_JdunZ4feV\u0011\u0011\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b\u0018\u0002\u000b\u0015\u0014(o\u001c:\n\t\u0005\r\u0013Q\b\u0002\u001e\t\u0006lGnQ8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4fe\u0006aQM\u001d:pe2{wmZ3sA\u00051\u0012M\u001a;fe\u000e{W\u000e\u001d7fi&|gn\u0014:FeJ|'/\u0006\u0002\u0002LA\u0019Q)!\u0014\n\u0007\u0005=cIA\u0004C_>dW-\u00198\u00025\u00054G/\u001a:D_6\u0004H.\u001a;j_:|%/\u0012:s_J|F%Z9\u0015\t\u0005U\u00131\f\t\u0004\u000b\u0006]\u0013bAA-\r\n!QK\\5u\u0011%\tifDA\u0001\u0002\u0004\tY%A\u0002yIE\nq#\u00194uKJ\u001cu.\u001c9mKRLwN\\(s\u000bJ\u0014xN\u001d\u0011\u0002/\r\fgnY3m+N,'OU5hQR\u001c8\t[3dWN|UCAA3!\u0011)U-a\u001a\u0011\t\u0015K\u0016QK\u0001\u0019G\u0006t7-\u001a7Vg\u0016\u0014(+[4iiN\u001c\u0005.Z2lg>\u0003\u0013aC5t\u0007\u0006t7-\u001a7mK\u0012$\"!a\u0013\u0002%M,Go\u00148DC:\u001cW\r\u001c%b]\u0012dWM\u001d\u000b\u0005\u0003+\n\u0019\bC\u0004\u0002vQ\u0001\r!a\u001e\u0002\u0011I,hN\\1cY\u0016\u0004B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{z\u0016\u0001\u00027b]\u001eLA!!!\u0002|\tA!+\u001e8oC\ndW-\u0001\btKR\u001cu.\u001c9sKN\u001c\u0018n\u001c8\u0015\t\u0005U\u0013q\u0011\u0005\b\u0003\u0013+\u0002\u0019AAF\u0003\u0005\u0019\b\u0003BAG\u00037sA!a$\u0002\u0018B\u0019\u0011\u0011\u0013$\u000e\u0005\u0005M%bAAK\u0005\u00061AH]8pizJ1!!'G\u0003\u0019\u0001&/\u001a3fM&!\u0011QTAP\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0014$\u0002\u000f%\u001c(+Z1es\u0006\t2/\u001a;P]J+\u0017\rZ=IC:$G.\u001a:\u0015\t\u0005U\u0013q\u0015\u0005\b\u0003k:\u0002\u0019AA<\u0003u!\u0017n]1cY\u0016\fU\u000f^8J]\n|WO\u001c3GY><8i\u001c8ue>dGCAA+\u0003\u001d\u0011X-];fgR$B!!\u0016\u00022\"1\u00111W\rA\u0002-\f\u0011![\u0001\u0016g\u0016$X*Z:tC\u001e,7i\\7qe\u0016\u001c8/[8o)\u0011\t)&!/\t\u000f\u0005m&\u00041\u0001\u0002L\u0005\t!-\u0001\u0004p]:+\u0007\u0010\u001e\u000b\u0005\u0003+\n\t\r\u0003\u0004\u0002Dn\u0001\rAP\u0001\u0002m\u00069qN\\#se>\u0014H\u0003BA+\u0003\u0013Dq!a3\u001d\u0001\u0004\ti-A\u0005uQJ|w/\u00192mKB!\u0011qZAm\u001d\u0011\t\t.!6\u000f\t\u0005E\u00151[\u0005\u0002\u000f&\u0019\u0011q\u001b$\u0002\u000fA\f7m[1hK&!\u00111\\Ao\u0005%!\u0006N]8xC\ndWMC\u0002\u0002X\u001a\u000b1b\u001c8D_6\u0004H.\u001a;fI\u0006YrN\u001c7z\u0005\u00164wN]3D_6\u0004H.\u001a;j_:|%/\u0012:s_J$B!!\u0016\u0002f\"A\u0011q\u001d\u0010\u0005\u0002\u0004\tI/\u0001\u0003c_\u0012L\b#B#\u0002l\u0006U\u0013bAAw\r\nAAHY=oC6,g(A\u000fdQ\u0016\u001c7.V:feJKw\r\u001b;t%\u00164'/Z:i)&lWm\\;u)\u0011\t\u0019P!\u0001\u0011\u0011\u0005=\u0017Q_A}\u0003+JA!a>\u0002^\n1Q)\u001b;iKJ\u0004B!a?\u0002~6\t\u0001(C\u0002\u0002\u0000b\u0012ac\u0015;biV\u001c(+\u001e8uS6,W\t_2faRLwN\u001c\u0005\u0007\u0005\u0007y\u0002\u0019A.\u0002\u00079|w/A\tdQ\u0016\u001c7n\u00117bS6\u001cX\t\u001f9jef$B!a=\u0003\n!1!1\u0001\u0011A\u0002m\u000bAc\u001d;bY\u0016\u001cFO]3b[\u0006+H\u000f[#se>\u0014XCAA}\u0003qyenZ8j]\u001e\fU\u000f\u001e5pe&T\u0018\r^5p]>\u00137/\u001a:wKJ\u0004\"!U\u0012\u0014\u0007\r\u0012)\u0002E\u0002F\u0005/I1A!\u0007G\u0005\u0019\te.\u001f*fMR\u0011!\u0011C\u0001\u0006CB\u0004H._\u000b\u0005\u0005C\u0011I\u0003\u0006\t\u0003$\tm\"Q\bB \u0005\u0003\u00129F!\u0017\u0003nQ1!Q\u0005B\u0016\u0005[\u0001B!\u000e\u001f\u0003(A\u0019qH!\u000b\u0005\u000b\u0005+#\u0019A\"\t\u000f\u0005\rQ\u0005q\u0001\u0002\u0006!9!qF\u0013A\u0004\tE\u0012AA3d!\u0011\u0011\u0019Da\u000e\u000e\u0005\tU\"B\u0001;G\u0013\u0011\u0011ID!\u000e\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bBB'&\u0001\u0004\u0011)\u0003C\u0003OK\u0001\u0007q\nC\u0003XK\u0001\u0007\u0001\fC\u0004\u0003D\u0015\u0002\rA!\u0012\u0002'U\u001cXM]'b]\u0006<W-\\3oiN#xN]3\u0011\t\t\u001d#1K\u0007\u0003\u0005\u0013R1a\u000bB&\u0015\u0011\u0011iEa\u0014\u0002\u00151|7-\u00197ti>\u0014XMC\u0002\u0003R9\n\u0001\u0002\u001d7bi\u001a|'/\\\u0005\u0005\u0005+\u0012IEA\nVg\u0016\u0014X*\u00198bO\u0016lWM\u001c;Ti>\u0014X\rC\u0003kK\u0001\u00071\u000eC\u0004\u0003\\\u0015\u0002\rA!\u0018\u0002\u001b\u0005\\7.Y*dQ\u0016$W\u000f\\3s!\u0011\u0011yF!\u001b\u000e\u0005\t\u0005$\u0002\u0002B2\u0005K\nQ!Y2u_JT!Aa\u001a\u0002\t\u0005\\7.Y\u0005\u0005\u0005W\u0012\tGA\u0005TG\",G-\u001e7fe\"9\u00110\nI\u0001\u0002\u0004Q\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\u0016\t\tM$\u0011R\u000b\u0003\u0005kR3A\u001fB<W\t\u0011I\b\u0005\u0003\u0003|\t\u0015UB\u0001B?\u0015\u0011\u0011yH!!\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BB\r\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d%Q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!B!'\u0005\u0004\u0019\u0005")
public final class OngoingAuthorizationObserver<A>
extends ServerCallStreamObserver<A> {
    private final ServerCallStreamObserver<A> observer;
    private final ClaimSet.Claims originalClaims;
    private final Function0<Instant> nowF;
    private final int userRightsCheckIntervalInSeconds;
    private final AtomicReference<Instant> lastUserRightsCheckTime;
    private final Option<JwtTimestampLeeway> jwtTimestampLeeway;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final DamlContextualizedErrorLogger errorLogger;
    private boolean afterCompletionOrError;
    private final Option<Function0<BoxedUnit>> cancelUserRightsChecksO;

    public static <A> Option<JwtTimestampLeeway> apply$default$7() {
        return OngoingAuthorizationObserver$.MODULE$.apply$default$7();
    }

    public static <A> ServerCallStreamObserver<A> apply(ServerCallStreamObserver<A> observer, ClaimSet.Claims originalClaims, Function0<Instant> nowF, UserManagementStore userManagementStore, int userRightsCheckIntervalInSeconds, Scheduler akkaScheduler, Option<JwtTimestampLeeway> jwtTimestampLeeway, LoggingContext loggingContext, ExecutionContext ec) {
        return OngoingAuthorizationObserver$.MODULE$.apply(observer, originalClaims, nowF, userManagementStore, userRightsCheckIntervalInSeconds, akkaScheduler, jwtTimestampLeeway, loggingContext, ec);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private DamlContextualizedErrorLogger errorLogger() {
        return this.errorLogger;
    }

    private boolean afterCompletionOrError() {
        return this.afterCompletionOrError;
    }

    private void afterCompletionOrError_$eq(boolean x$1) {
        this.afterCompletionOrError = x$1;
    }

    private Option<Function0<BoxedUnit>> cancelUserRightsChecksO() {
        return this.cancelUserRightsChecksO;
    }

    public synchronized boolean isCancelled() {
        return this.observer.isCancelled();
    }

    public synchronized void setOnCancelHandler(Runnable runnable) {
        this.observer.setOnCancelHandler(runnable);
    }

    public synchronized void setCompression(String s) {
        this.observer.setCompression(s);
    }

    public synchronized boolean isReady() {
        return this.observer.isReady();
    }

    public synchronized void setOnReadyHandler(Runnable runnable) {
        this.observer.setOnReadyHandler(runnable);
    }

    public synchronized void disableAutoInboundFlowControl() {
        this.observer.disableAutoInboundFlowControl();
    }

    public synchronized void request(int i) {
        this.observer.request(i);
    }

    public synchronized void setMessageCompression(boolean b) {
        this.observer.setMessageCompression(b);
    }

    public void onNext(A v) {
        this.onlyBeforeCompletionOrError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Instant now = (Instant)$this.nowF.apply();
            Either either = this.checkClaimsExpiry(now).flatMap((Function1 & Serializable)x$3 -> {
                BoxedUnit boxedUnit = x$3;
                return this.checkUserRightsRefreshTimeout(now).map((Function1 & Serializable)x$2 -> {
                    boxedUnit = x$2;
                    return BoxedUnit.UNIT;
                });
            });
            if (either instanceof Right) {
                $this.observer.onNext(v);
                return;
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                StatusRuntimeException e = (StatusRuntimeException)left.value();
                this.onError((Throwable)e);
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    public void onError(Throwable throwable) {
        this.onlyBeforeCompletionOrError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.afterCompletionOrError_$eq(true);
            this.cancelUserRightsChecksO().foreach((Function1 & Serializable)x$4 -> {
                x$4.apply$mcV$sp();
                return BoxedUnit.UNIT;
            });
            $this.observer.onError(throwable);
        });
    }

    public void onCompleted() {
        this.onlyBeforeCompletionOrError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.afterCompletionOrError_$eq(true);
            this.cancelUserRightsChecksO().foreach((Function1 & Serializable)x$5 -> {
                x$5.apply$mcV$sp();
                return BoxedUnit.UNIT;
            });
            $this.observer.onCompleted();
        });
    }

    private synchronized void onlyBeforeCompletionOrError(Function0<BoxedUnit> body) {
        if (!this.afterCompletionOrError()) {
            body.apply$mcV$sp();
            return;
        }
    }

    private Either<StatusRuntimeException, BoxedUnit> checkUserRightsRefreshTimeout(Instant now) {
        if (this.originalClaims.resolvedFromUser() && this.lastUserRightsCheckTime.get().isBefore(now.minusSeconds(2L * (long)this.userRightsCheckIntervalInSeconds))) {
            return package$.MODULE$.Left().apply((Object)this.staleStreamAuthError());
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private Either<StatusRuntimeException, BoxedUnit> checkClaimsExpiry(Instant now) {
        return this.originalClaims.notExpired(now, this.jwtTimestampLeeway).left().map((Function1 & Serializable)authorizationError -> new AuthorizationChecks.PermissionDenied$.Reject(authorizationError.reason(), (ContextualizedErrorLogger)this.errorLogger()).asGrpcError());
    }

    private StatusRuntimeException staleStreamAuthError() {
        return new AuthorizationChecks.StaleUserManagementBasedStreamClaims$.Reject((ContextualizedErrorLogger)this.errorLogger()).asGrpcError();
    }

    public OngoingAuthorizationObserver(ServerCallStreamObserver<A> observer, ClaimSet.Claims originalClaims, Function0<Instant> nowF, Option<UserRightsChangeAsyncChecker> userRightsCheckerO, int userRightsCheckIntervalInSeconds, AtomicReference<Instant> lastUserRightsCheckTime, Option<JwtTimestampLeeway> jwtTimestampLeeway, LoggingContext loggingContext) {
        this.observer = observer;
        this.originalClaims = originalClaims;
        this.nowF = nowF;
        this.userRightsCheckIntervalInSeconds = userRightsCheckIntervalInSeconds;
        this.lastUserRightsCheckTime = lastUserRightsCheckTime;
        this.jwtTimestampLeeway = jwtTimestampLeeway;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.afterCompletionOrError = false;
        this.cancelUserRightsChecksO = userRightsCheckerO.map((Function1 & Serializable)x$1 -> x$1.schedule((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.onError((Throwable)this.staleStreamAuthError()), $this.loggingContext));
    }
}

