/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth;

import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.daml.ledger.api.auth.Claim;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$;
import com.daml.ledger.api.domain;
import com.daml.lf.data.Ref$;
import com.daml.logging.LoggingContext;
import com.daml.platform.localstore.api.UserManagementStore;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005Y4QAC\u0006\u0003\u0017UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011Q\u0003!\u0011!Q\u0001\fUCQA\u0017\u0001\u0005\u0002mCQ!\u001a\u0001\u0005\u0002\u0019\u0014A$V:feJKw\r\u001b;t\u0007\"\fgnZ3Bgft7m\u00115fG.,'O\u0003\u0002\r\u001b\u0005!\u0011-\u001e;i\u0015\tqq\"A\u0002ba&T!\u0001E\t\u0002\r1,GmZ3s\u0015\t\u00112#\u0001\u0003eC6d'\"\u0001\u000b\u0002\u0007\r|Wn\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\fq\u0003\\1tiV\u001bXM\u001d*jO\"$8o\u00115fG.$\u0016.\\3\u0004\u0001A\u0019q\u0004\u000b\u0016\u000e\u0003\u0001R!!\t\u0012\u0002\r\u0005$x.\\5d\u0015\t\u0019C%\u0001\u0006d_:\u001cWO\u001d:f]RT!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0002O\u0005!!.\u0019<b\u0013\tI\u0003EA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\tYc&D\u0001-\u0015\tic%\u0001\u0003uS6,\u0017BA\u0018-\u0005\u001dIen\u001d;b]R\fab\u001c:jO&t\u0017\r\\\"mC&l7\u000f\u0005\u00023m9\u00111\u0007N\u0007\u0002\u0017%\u0011QgC\u0001\t\u00072\f\u0017.\\*fi&\u0011q\u0007\u000f\u0002\u0007\u00072\f\u0017.\\:\u000b\u0005UZ\u0011\u0001\u00028po\u001a\u00032aF\u001e+\u0013\ta\u0004DA\u0005Gk:\u001cG/[8oa\u0005\u0019Ro]3s\u001b\u0006t\u0017mZ3nK:$8\u000b^8sKB\u0011q(R\u0007\u0002\u0001*\u0011a\"\u0011\u0006\u0003\u0005\u000e\u000b!\u0002\\8dC2\u001cHo\u001c:f\u0015\t!\u0015#\u0001\u0005qY\u0006$hm\u001c:n\u0013\t1\u0005IA\nVg\u0016\u0014X*\u00198bO\u0016lWM\u001c;Ti>\u0014X-\u0001\u0011vg\u0016\u0014(+[4iiN\u001c\u0005.Z2l\u0013:$XM\u001d<bY&s7+Z2p]\u0012\u001c\bCA\fJ\u0013\tQ\u0005DA\u0002J]R\fQ\"Y6lCN\u001b\u0007.\u001a3vY\u0016\u0014\bCA'S\u001b\u0005q%BA(Q\u0003\u0015\t7\r^8s\u0015\u0005\t\u0016\u0001B1lW\u0006L!a\u0015(\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018AA3d!\t1\u0006,D\u0001X\u0015\t\u0019\u0003$\u0003\u0002Z/\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fq{\u0006-\u00192dIR\u0011QL\u0018\t\u0003g\u0001AQ\u0001\u0016\u0005A\u0004UCQ\u0001\b\u0005A\u0002yAQ\u0001\r\u0005A\u0002EBQ!\u000f\u0005A\u0002iBQ!\u0010\u0005A\u0002yBQa\u0012\u0005A\u0002!CQa\u0013\u0005A\u00021\u000b\u0001b]2iK\u0012,H.\u001a\u000b\u0003OR$\"\u0001\u001b7\u0011\u0007]Y\u0014\u000e\u0005\u0002\u0018U&\u00111\u000e\u0007\u0002\u0005+:LG\u000fC\u0003n\u0013\u0001\u000fa.\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\f\u0012a\u00027pO\u001eLgnZ\u0005\u0003gB\u0014a\u0002T8hO&twmQ8oi\u0016DH\u000fC\u0003v\u0013\u0001\u0007\u0001.\u0001\u000evg\u0016\u00148\t\\1j[Nl\u0015n]7bi\u000eD7)\u00197mE\u0006\u001c7\u000e")
public final class UserRightsChangeAsyncChecker {
    private final AtomicReference<Instant> lastUserRightsCheckTime;
    private final ClaimSet.Claims originalClaims;
    private final Function0<Instant> nowF;
    private final UserManagementStore userManagementStore;
    private final int userRightsCheckIntervalInSeconds;
    private final Scheduler akkaScheduler;
    private final ExecutionContext ec;

    public Function0<BoxedUnit> schedule(Function0<BoxedUnit> userClaimsMismatchCallback, LoggingContext loggingContext) {
        FiniteDuration delay = new package.DurationInt(package$.MODULE$.DurationInt(this.userRightsCheckIntervalInSeconds)).seconds();
        domain.IdentityProviderId identityProviderId = this.originalClaims.identityProviderId();
        String userId = (String)this.originalClaims.applicationId().fold((Function0 & Serializable)() -> {
            throw new RuntimeException("Claims were resolved from a user but userId (applicationId) is missing in the claims.");
        }, (Function1 & Serializable)s -> (String)Ref$.MODULE$.UserId().assertFromString(s));
        Predef$.MODULE$.assert(this.originalClaims.resolvedFromUser(), (Function0 & Serializable)() -> "The claims were not resolved from a user. Expected claims resolved from a user.");
        Cancellable cancellable = this.akkaScheduler.scheduleWithFixedDelay(delay, delay, () -> {
            Future userState = $this.userManagementStore.listUserRights(userId, identityProviderId, loggingContext).flatMap((Function1 & Serializable)userRightsResult -> $this.userManagementStore.getUser(userId, identityProviderId, loggingContext).map((Function1 & Serializable)userResult -> userRightsResult.flatMap((Function1 & Serializable)userRights -> userResult.map((Function1 & Serializable)user -> new Tuple2(user, userRights))), $this.ec), $this.ec);
            userState.onComplete((Function1 & Serializable)x0$1 -> {
                UserRightsChangeAsyncChecker.$anonfun$schedule$9(this, userClaimsMismatchCallback, x0$1);
                return BoxedUnit.UNIT;
            }, $this.ec);
        }, this.ec);
        return (JFunction0.mcV.sp & Serializable)() -> cancellable.cancel();
    }

    public static final /* synthetic */ void $anonfun$schedule$9(UserRightsChangeAsyncChecker $this, Function0 userClaimsMismatchCallback$1, Try x0$1) {
        Right right;
        Tuple2 tuple2;
        Success success;
        Either either;
        Success success2;
        Either either2;
        Try try_ = x0$1;
        if (try_ instanceof Failure ? true : try_ instanceof Success && (either2 = (Either)(success2 = (Success)try_).value()) instanceof Left) {
            userClaimsMismatchCallback$1.apply$mcV$sp();
            return;
        }
        if (try_ instanceof Success && (either = (Either)(success = (Success)try_).value()) instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            domain.User user = (domain.User)tuple2._1();
            Set userRights = (Set)tuple2._2();
            Seq<Claim> updatedClaims = AuthorizationInterceptor$.MODULE$.convertUserRightsToClaims((Set<domain.UserRight>)userRights);
            Set set = updatedClaims.toSet();
            Set set2 = $this.originalClaims.claims().toSet();
            if ((set != null ? !set.equals(set2) : set2 != null) || user.isDeactivated()) {
                userClaimsMismatchCallback$1.apply$mcV$sp();
            }
            $this.lastUserRightsCheckTime.set((Instant)$this.nowF.apply());
            return;
        }
        throw new MatchError((Object)try_);
    }

    public UserRightsChangeAsyncChecker(AtomicReference<Instant> lastUserRightsCheckTime, ClaimSet.Claims originalClaims, Function0<Instant> nowF, UserManagementStore userManagementStore, int userRightsCheckIntervalInSeconds, Scheduler akkaScheduler, ExecutionContext ec) {
        this.lastUserRightsCheckTime = lastUserRightsCheckTime;
        this.originalClaims = originalClaims;
        this.nowF = nowF;
        this.userManagementStore = userManagementStore;
        this.userRightsCheckIntervalInSeconds = userRightsCheckIntervalInSeconds;
        this.akkaScheduler = akkaScheduler;
        this.ec = ec;
    }
}

