/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth.interceptor;

import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.Claim;
import com.daml.ledger.api.auth.ClaimActAsParty;
import com.daml.ledger.api.auth.ClaimAdmin$;
import com.daml.ledger.api.auth.ClaimIdentityProviderAdmin$;
import com.daml.ledger.api.auth.ClaimPublic$;
import com.daml.ledger.api.auth.ClaimReadAsParty;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor;
import com.daml.ledger.api.auth.interceptor.IdentityProviderAwareAuthService;
import com.daml.ledger.api.domain;
import com.daml.lf.data.Ref$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.platform.localstore.api.UserManagementStore;
import io.grpc.Context;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class AuthorizationInterceptor$ {
    public static final AuthorizationInterceptor$ MODULE$ = new AuthorizationInterceptor$();
    private static final Context.Key<ClaimSet> contextKeyClaimSet = Context.key((String)"AuthServiceDecodedClaim");

    public Context.Key<ClaimSet> contextKeyClaimSet() {
        return contextKeyClaimSet;
    }

    public Try<ClaimSet> extractClaimSetFromContext() {
        ClaimSet claimSet = (ClaimSet)this.contextKeyClaimSet().get();
        if (claimSet == null) {
            return new Failure((Throwable)new RuntimeException("Thread local context unexpectedly does not store authorization claims. Perhaps a Future was used in some intermediate computation and changed the executing thread?"));
        }
        return new Success((Object)claimSet);
    }

    public AuthorizationInterceptor apply(AuthService authService, Option<UserManagementStore> userManagementStoreO, IdentityProviderAwareAuthService identityProviderAwareAuthService, ExecutionContext ec) {
        return (AuthorizationInterceptor)LoggingContext$.MODULE$.newLoggingContext((Function1 & Serializable)loggingContext -> new AuthorizationInterceptor(authService, userManagementStoreO, identityProviderAwareAuthService, ec, (LoggingContext)loggingContext));
    }

    public Seq<Claim> convertUserRightsToClaims(Set<domain.UserRight> userRights) {
        return ((IterableOnceOps)userRights.view().map((Function1 & Serializable)r -> MODULE$.userRightToClaim((domain.UserRight)r))).toList().prepended((Object)ClaimPublic$.MODULE$);
    }

    private Claim userRightToClaim(domain.UserRight r) {
        domain.UserRight userRight = r;
        if (userRight instanceof domain.UserRight$.CanActAs) {
            domain.UserRight$.CanActAs canActAs = (domain.UserRight$.CanActAs)userRight;
            String p = canActAs.party();
            return new ClaimActAsParty((String)Ref$.MODULE$.Party().assertFromString(p));
        }
        if (userRight instanceof domain.UserRight$.CanReadAs) {
            domain.UserRight$.CanReadAs canReadAs = (domain.UserRight$.CanReadAs)userRight;
            String p = canReadAs.party();
            return new ClaimReadAsParty((String)Ref$.MODULE$.Party().assertFromString(p));
        }
        if (domain.UserRight$.IdentityProviderAdmin$.MODULE$.equals(userRight)) {
            return ClaimIdentityProviderAdmin$.MODULE$;
        }
        if (domain.UserRight$.ParticipantAdmin$.MODULE$.equals(userRight)) {
            return ClaimAdmin$.MODULE$;
        }
        throw new MatchError((Object)userRight);
    }

    private AuthorizationInterceptor$() {
    }
}

