/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth.interceptor;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.AuthorizationChecks;
import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.Claim;
import com.daml.ledger.api.auth.ClaimSet;
import com.daml.ledger.api.auth.ClaimSet$Unauthenticated$;
import com.daml.ledger.api.auth.interceptor.AsyncForwardingListener;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$;
import com.daml.ledger.api.auth.interceptor.IdentityProviderAwareAuthService;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.lf.data.Ref$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.localstore.api.UserManagementStore;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t-d\u0001\u0002\u000f\u001e\u0005)B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005V\u0001\t\u0015\r\u0011b\u0001W\u0011!i\u0006A!A!\u0002\u00139\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b1B0\t\u000b\u0015\u0004A\u0011\u00014\t\u000f9\u0004!\u0019!C\u0005_\"11\u000f\u0001Q\u0001\nADq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004}\u0001\u0001\u0006IA\u001e\u0005\u0006{\u0002!\tE \u0005\b\u0003\u0013\u0002A\u0011BA&\u0011!\ty\u0006\u0001Q\u0005\n\u0005\u0005\u0004bBA3\u0001\u0011%\u0011q\r\u0005\b\u0003G\u0003A\u0011BAS\u0011!\t\t\u000e\u0001Q\u0005\n\u0005M\u0007\u0002CAm\u0001\u0001&I!a7\b\u000f\u0005eX\u0004#\u0001\u0002|\u001a1A$\bE\u0001\u0003{Da!\u001a\u000b\u0005\u0002\t\u0015\u0001B\u0003B\u0004)\t\u0007I\u0011A\u0010\u0003\n!A!\u0011\u0004\u000b!\u0002\u0013\u0011Y\u0001C\u0004\u0003\u001cQ!\tA!\b\t\u000f\t-B\u0003\"\u0001\u0003.!9!q\u0007\u000b\u0005\u0002\te\u0002\u0002\u0003B2)\u0001&IA!\u001a\u00031\u0005+H\u000f[8sSj\fG/[8o\u0013:$XM]2faR|'O\u0003\u0002\u001f?\u0005Y\u0011N\u001c;fe\u000e,\u0007\u000f^8s\u0015\t\u0001\u0013%\u0001\u0003bkRD'B\u0001\u0012$\u0003\r\t\u0007/\u001b\u0006\u0003I\u0015\na\u0001\\3eO\u0016\u0014(B\u0001\u0014(\u0003\u0011!\u0017-\u001c7\u000b\u0003!\n1aY8n\u0007\u0001\u00192\u0001A\u00164!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003mC:<'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aa\u00142kK\u000e$\bC\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u00119'\u000f]2\u000b\u0003a\n!![8\n\u0005i*$!E*feZ,'/\u00138uKJ\u001cW\r\u001d;pe\u0006Y\u0011-\u001e;i'\u0016\u0014h/[2f!\tid(D\u0001 \u0013\tytDA\u0006BkRD7+\u001a:wS\u000e,\u0017\u0001F;tKJl\u0015M\\1hK6,g\u000e^*u_J,w\nE\u0002C\u000b\u001ek\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005!sU\"A%\u000b\u0005\tR%BA&M\u0003)awnY1mgR|'/\u001a\u0006\u0003\u001b\u0016\n\u0001\u0002\u001d7bi\u001a|'/\\\u0005\u0003\u001f&\u00131#V:fe6\u000bg.Y4f[\u0016tGo\u0015;pe\u0016\f\u0001%\u001b3f]RLG/\u001f)s_ZLG-\u001a:Bo\u0006\u0014X-Q;uQN+'O^5dKB\u0011!kU\u0007\u0002;%\u0011A+\b\u0002!\u0013\u0012,g\u000e^5usB\u0013xN^5eKJ\fu/\u0019:f\u0003V$\bnU3sm&\u001cW-\u0001\u0002fGV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[\u0007\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005qK&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\r)7\rI\u0001\u000fY><w-\u001b8h\u0007>tG/\u001a=u!\t\u00017-D\u0001b\u0015\t\u0011W%A\u0004m_\u001e<\u0017N\\4\n\u0005\u0011\f'A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u001dT7\u000e\\7\u0015\u0005!L\u0007C\u0001*\u0001\u0011\u0015qv\u0001q\u0001`\u0011\u0015Yt\u00011\u0001=\u0011\u0015\u0001u\u00011\u0001B\u0011\u0015\u0001v\u00011\u0001R\u0011\u0015)v\u0001q\u0001X\u0003\u0019awnZ4feV\t\u0001\u000f\u0005\u0002ac&\u0011!/\u0019\u0002\u0015\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005YQM\u001d:pe2{wmZ3s+\u00051\bCA<{\u001b\u0005A(BA=&\u0003\u0015)'O]8s\u0013\tY\bPA\u000fEC6d7i\u001c8uKb$X/\u00197ju\u0016$WI\u001d:pe2{wmZ3s\u00031)'O]8s\u0019><w-\u001a:!\u00035Ig\u000e^3sG\u0016\u0004HoQ1mYV)q0a\u0005\u00022QA\u0011\u0011AA\u0013\u0003k\ty\u0004\u0005\u0004\u0002\u0004\u0005%\u0011q\u0002\b\u0004i\u0005\u0015\u0011bAA\u0004k\u0005Q1+\u001a:wKJ\u001c\u0015\r\u001c7\n\t\u0005-\u0011Q\u0002\u0002\t\u0019&\u001cH/\u001a8fe*\u0019\u0011qA\u001b\u0011\t\u0005E\u00111\u0003\u0007\u0001\t\u001d\t)\u0002\u0004b\u0001\u0003/\u0011AAU3r)F!\u0011\u0011DA\u0010!\r\u0011\u00151D\u0005\u0004\u0003;\u0019%a\u0002(pi\"Lgn\u001a\t\u0004\u0005\u0006\u0005\u0012bAA\u0012\u0007\n\u0019\u0011I\\=\t\u000f\u0005\u001dB\u00021\u0001\u0002*\u0005!1-\u00197m!\u001d!\u00141FA\b\u0003_I1!!\f6\u0005)\u0019VM\u001d<fe\u000e\u000bG\u000e\u001c\t\u0005\u0003#\t\t\u0004B\u0004\u000241\u0011\r!a\u0006\u0003\u000bI+7\u000f\u001d+\t\u000f\u0005]B\u00021\u0001\u0002:\u00059\u0001.Z1eKJ\u001c\bc\u0001\u001b\u0002<%\u0019\u0011QH\u001b\u0003\u00115+G/\u00193bi\u0006Dq!!\u0011\r\u0001\u0004\t\u0019%\u0001\u0007oKb$H*[:uK:,'\u000fE\u00045\u0003\u000b\ny!a\f\n\u0007\u0005\u001dSGA\tTKJ4XM]\"bY2D\u0015M\u001c3mKJ\f\u0001DZ1mY\n\f7m\u001b+p\u0013\u0012\u0004\u0018)\u001e;i'\u0016\u0014h/[2f)\u0019\ti%!\u0017\u0002\\A)\u0001,a\u0014\u0002T%\u0019\u0011\u0011K-\u0003\r\u0019+H/\u001e:f!\ri\u0014QK\u0005\u0004\u0003/z\"\u0001C\"mC&l7+\u001a;\t\u000f\u0005]R\u00021\u0001\u0002:!9\u0011QL\u0007A\u0002\u0005M\u0013\u0001C2mC&l7+\u001a;\u0002=I,7o\u001c7wK\u0006+H\u000f[3oi&\u001c\u0017\r^3e+N,'OU5hQR\u001cH\u0003BA'\u0003GBq!!\u0018\u000f\u0001\u0004\t\u0019&\u0001\u0012wKJLg-_+tKJL5oV5uQ&t\u0017\nZ3oi&$\u0018\u0010\u0015:pm&$WM\u001d\u000b\u0007\u0003S\n\t(!'\u0011\u000ba\u000by%a\u001b\u0011\u0007\t\u000bi'C\u0002\u0002p\r\u0013A!\u00168ji\"9\u00111O\bA\u0002\u0005U\u0014AE5eK:$\u0018\u000e^=Qe>4\u0018\u000eZ3s\u0013\u0012\u0004B!a\u001e\u0002\u0014:!\u0011\u0011PAH\u001d\u0011\tY(!$\u000f\t\u0005u\u00141\u0012\b\u0005\u0003\u007f\nII\u0004\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t))K\u0001\u0007yI|w\u000e\u001e \n\u0003!J!AJ\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\r\t\t*I\u0001\u0007I>l\u0017-\u001b8\n\t\u0005U\u0015q\u0013\u0002\u0013\u0013\u0012,g\u000e^5usB\u0013xN^5eKJLEMC\u0002\u0002\u0012\u0006Bq!a'\u0010\u0001\u0004\ti*\u0001\u0003vg\u0016\u0014\b\u0003BA<\u0003?KA!!)\u0002\u0018\n!Qk]3s\u0003I1XM]5gsV\u001bXM]%t\u0003\u000e$\u0018N^3\u0015\u0011\u0005\u001d\u0016\u0011VAW\u0003\u001f\u0004R\u0001WA(\u0003;Ca!a+\u0011\u0001\u00049\u0015aE;tKJl\u0015M\\1hK6,g\u000e^*u_J,\u0007bBAX!\u0001\u0007\u0011\u0011W\u0001\u0007kN,'/\u00133\u0011\t\u0005M\u0016\u0011\u001a\b\u0005\u0003k\u000b\u0019M\u0004\u0003\u00028\u0006uf\u0002BA?\u0003sK1!a/&\u0003\tag-\u0003\u0003\u0002@\u0006\u0005\u0017\u0001\u00023bi\u0006T1!a/&\u0013\u0011\t)-a2\u0002\u0007I+gM\u0003\u0003\u0002@\u0006\u0005\u0017\u0002BAf\u0003\u001b\u0014a!V:fe&#'\u0002BAc\u0003\u000fDq!a\u001d\u0011\u0001\u0004\t)(\u0001\fhKR,6/\u001a:NC:\fw-Z7f]R\u001cFo\u001c:f)\u0011\t).a6\u0011\ta\u000bye\u0012\u0005\u0006\u0001F\u0001\r!Q\u0001\nO\u0016$Xk]3s\u0013\u0012$B!!8\u0002fB)\u0001,a\u0014\u0002`B!\u0011\u0011]Ae\u001d\u0011\t\u0019/a1\u000e\u0005\u0005\u001d\u0007bBAt%\u0001\u0007\u0011\u0011^\u0001\nkN,'/\u00133TiJ\u0004B!a;\u0002t:!\u0011Q^Ax!\r\t\tiQ\u0005\u0004\u0003c\u001c\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002v\u0006](AB*ue&twMC\u0002\u0002r\u000e\u000b\u0001$Q;uQ>\u0014\u0018N_1uS>t\u0017J\u001c;fe\u000e,\u0007\u000f^8s!\t\u0011FcE\u0002\u0015\u0003\u007f\u00042A\u0011B\u0001\u0013\r\u0011\u0019a\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005m\u0018AE2p]R,\u0007\u0010^&fs\u000ec\u0017-[7TKR,\"Aa\u0003\u0011\r\t5!1CA*\u001d\r!$qB\u0005\u0004\u0005#)\u0014aB\"p]R,\u0007\u0010^\u0005\u0005\u0005+\u00119BA\u0002LKfT1A!\u00056\u0003M\u0019wN\u001c;fqR\\U-_\"mC&l7+\u001a;!\u0003i)\u0007\u0010\u001e:bGR\u001cE.Y5n'\u0016$hI]8n\u0007>tG/\u001a=u)\t\u0011y\u0002\u0005\u0004\u0003\"\t\u001d\u00121K\u0007\u0003\u0005GQ1A!\nD\u0003\u0011)H/\u001b7\n\t\t%\"1\u0005\u0002\u0004)JL\u0018!B1qa2LH#\u00035\u00030\tE\"1\u0007B\u001b\u0011\u0015Y\u0014\u00041\u0001=\u0011\u0015\u0001\u0015\u00041\u0001B\u0011\u0015\u0001\u0016\u00041\u0001R\u0011\u0015)\u0016\u00041\u0001X\u0003e\u0019wN\u001c<feR,6/\u001a:SS\u001eDGo\u001d+p\u00072\f\u0017.\\:\u0015\t\tm\"1\u000b\t\u0007\u0005{\u00119E!\u0014\u000f\t\t}\"1\t\b\u0005\u0003\u0003\u0013\t%C\u0001E\u0013\r\u0011)eQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011IEa\u0013\u0003\u0007M+\u0017OC\u0002\u0003F\r\u00032!\u0010B(\u0013\r\u0011\tf\b\u0002\u0006\u00072\f\u0017.\u001c\u0005\b\u0005+R\u0002\u0019\u0001B,\u0003))8/\u001a:SS\u001eDGo\u001d\t\u0007\u0003W\u0014IF!\u0018\n\t\tm\u0013q\u001f\u0002\u0004'\u0016$\b\u0003BA<\u0005?JAA!\u0019\u0002\u0018\nIQk]3s%&<\u0007\u000e^\u0001\u0011kN,'OU5hQR$vn\u00117bS6$BA!\u0014\u0003h!9!\u0011N\u000eA\u0002\tu\u0013!\u0001:")
public final class AuthorizationInterceptor
implements ServerInterceptor {
    public final AuthService com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$authService;
    private final Option<UserManagementStore> userManagementStoreO;
    private final IdentityProviderAwareAuthService identityProviderAwareAuthService;
    private final ExecutionContext ec;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final DamlContextualizedErrorLogger com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger;

    public static Seq<Claim> convertUserRightsToClaims(Set<domain.UserRight> userRights) {
        return AuthorizationInterceptor$.MODULE$.convertUserRightsToClaims(userRights);
    }

    public static AuthorizationInterceptor apply(AuthService authService, Option<UserManagementStore> userManagementStoreO, IdentityProviderAwareAuthService identityProviderAwareAuthService, ExecutionContext ec) {
        return AuthorizationInterceptor$.MODULE$.apply(authService, userManagementStoreO, identityProviderAwareAuthService, ec);
    }

    public static Try<ClaimSet> extractClaimSetFromContext() {
        return AuthorizationInterceptor$.MODULE$.extractClaimSetFromContext();
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public DamlContextualizedErrorLogger com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger() {
        return this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> nextListener) {
        Context prevCtx = Context.current();
        return new AsyncForwardingListener<ReqT>(this, headers, prevCtx, call, nextListener){
            private final /* synthetic */ AuthorizationInterceptor $outer;
            private final ServerCall call$1;

            private ServerCall.Listener<Nothing$> closeWithError(StatusRuntimeException error) {
                this.call$1.close(error.getStatus(), error.getTrailers());
                return new ServerCall.Listener<Nothing$>(null){};
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.call$1 = call$1;
                FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps($outer.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$authService.decodeMetadata(headers$1))).flatMap((Function1 & Serializable)x$1 -> $this.$outer.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$fallbackToIdpAuthService(headers$1, (ClaimSet)x$1), $outer.ec()).flatMap((Function1 & Serializable)claimSet -> $this.$outer.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$resolveAuthenticatedUserRights((ClaimSet)claimSet), $outer.ec()).onComplete((Function1 & Serializable)x0$1 -> {
                    Throwable exception;
                    boolean bl = false;
                    Failure failure = null;
                    Try try_ = x0$1;
                    if (try_ instanceof Failure) {
                        bl = true;
                        failure = (Failure)try_;
                        Throwable error = failure.exception();
                        if (error instanceof StatusRuntimeException) {
                            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)error;
                            return this.closeWithError(statusRuntimeException);
                        }
                    }
                    if (bl && (exception = failure.exception()) != null) {
                        Throwable throwable = exception;
                        StatusRuntimeException error = new AuthorizationChecks.InternalAuthorizationError$.Reject("Failed to get claims from request metadata", throwable, (ContextualizedErrorLogger)$this.$outer.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()).asGrpcError();
                        return this.closeWithError(error);
                    }
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        ClaimSet claimSet = (ClaimSet)success.value();
                        Context nextCtx = prevCtx$1.withValue(AuthorizationInterceptor$.MODULE$.contextKeyClaimSet(), (Object)claimSet);
                        ServerCall.Listener nextListenerWithContext = Contexts.interceptCall((Context)nextCtx, (ServerCall)call$1, (Metadata)headers$1, (ServerCallHandler)nextListener$1);
                        this.setNextListener(nextListenerWithContext);
                        return nextListenerWithContext;
                    }
                    throw new MatchError((Object)try_);
                }, $outer.ec());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$$anon$1 io.grpc.Metadata com.daml.ledger.api.auth.ClaimSet ), $anonfun$new$2(com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$$anon$1 com.daml.ledger.api.auth.ClaimSet ), $anonfun$new$3(com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$$anon$1 io.grpc.Context io.grpc.ServerCall io.grpc.Metadata io.grpc.ServerCallHandler scala.util.Try )}, serializedLambda);
            }
        };
    }

    public Future<ClaimSet> com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$fallbackToIdpAuthService(Metadata headers, ClaimSet claimSet) {
        ClaimSet claimSet2 = claimSet;
        ClaimSet$Unauthenticated$ claimSet$Unauthenticated$ = ClaimSet$Unauthenticated$.MODULE$;
        if (!(claimSet2 != null ? !claimSet2.equals(claimSet$Unauthenticated$) : claimSet$Unauthenticated$ != null)) {
            return this.identityProviderAwareAuthService.decodeMetadata(headers);
        }
        return Future$.MODULE$.successful((Object)claimSet);
    }

    public Future<ClaimSet> com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$resolveAuthenticatedUserRights(ClaimSet claimSet) {
        ClaimSet claimSet2 = claimSet;
        if (claimSet2 instanceof ClaimSet.AuthenticatedUser) {
            ClaimSet.AuthenticatedUser authenticatedUser = (ClaimSet.AuthenticatedUser)claimSet2;
            domain.IdentityProviderId identityProviderId = authenticatedUser.identityProviderId();
            String userIdStr = authenticatedUser.userId();
            Option<String> participantId = authenticatedUser.participantId();
            Option<Instant> expiration = authenticatedUser.expiration();
            return this.getUserManagementStore(this.userManagementStoreO).flatMap((Function1 & Serializable)userManagementStore -> this.getUserId(userIdStr).flatMap((Function1 & Serializable)userId -> this.verifyUserIsActive((UserManagementStore)userManagementStore, (String)userId, identityProviderId).flatMap((Function1 & Serializable)user -> this.verifyUserIsWithinIdentityProvider(identityProviderId, (domain.User)user).flatMap((Function1 & Serializable)x$2 -> {
                BoxedUnit boxedUnit = x$2;
                return userManagementStore.listUserRights(userId, identityProviderId, $this.loggingContext).flatMap((Function1 & Serializable)userRightsResult -> {
                    Right right;
                    Set userRights;
                    Future future;
                    Either either = userRightsResult;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        UserManagementStore.Error msg = (UserManagementStore.Error)left.value();
                        future = Future$.MODULE$.failed((Throwable)new AuthorizationChecks.PermissionDenied$.Reject(new StringBuilder(46).append("Could not resolve rights for user '").append((String)userId).append("' due to '").append(msg).append("'").toString(), (ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()).asGrpcError());
                    } else if (either instanceof Right && (userRights = (Set)(right = (Right)either).value()) != null) {
                        Set set = userRights;
                        Seq<Claim> x$1 = AuthorizationInterceptor$.MODULE$.convertUserRightsToClaims((Set<domain.UserRight>)set);
                        None$ x$2 = None$.MODULE$;
                        Option x$3 = participantId;
                        Some x$4 = new Some(userId);
                        Option x$5 = expiration;
                        boolean x$6 = true;
                        domain.IdentityProviderId x$7 = identityProviderId;
                        future = Future$.MODULE$.successful((Object)new ClaimSet.Claims(x$1, (Option<String>)x$2, (Option<String>)x$3, (Option<String>)x$4, (Option<Instant>)x$5, x$7, true));
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return future.map((Function1 & Serializable)claimsSet -> claimsSet, this.ec());
                }, this.ec());
            }, this.ec()), this.ec()), this.ec()), this.ec());
        }
        return Future$.MODULE$.successful((Object)claimSet);
    }

    private Future<BoxedUnit> verifyUserIsWithinIdentityProvider(domain.IdentityProviderId identityProviderId, domain.User user) {
        domain.IdentityProviderId identityProviderId2 = user.identityProviderId();
        domain.IdentityProviderId identityProviderId3 = identityProviderId;
        if (identityProviderId2 == null ? identityProviderId3 != null : !identityProviderId2.equals(identityProviderId3)) {
            return Future$.MODULE$.failed((Throwable)new AuthorizationChecks.PermissionDenied$.Reject("User is assigned to another identity provider", (ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()).asGrpcError());
        }
        return Future$.MODULE$.unit();
    }

    private Future<domain.User> verifyUserIsActive(UserManagementStore userManagementStore, String userId, domain.IdentityProviderId identityProviderId) {
        return userManagementStore.getUser(userId, identityProviderId, this.loggingContext).flatMap((Function1 & Serializable)userResult -> {
            Right right;
            domain.User user;
            Future future;
            Either either = userResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                UserManagementStore.Error msg = (UserManagementStore.Error)left.value();
                future = Future$.MODULE$.failed((Throwable)new AuthorizationChecks.PermissionDenied$.Reject(new StringBuilder(61).append("Could not resolve is_deactivated status for user '").append(userId).append("' due to '").append(msg).append("'").toString(), (ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()).asGrpcError());
            } else if (either instanceof Right && (user = (domain.User)(right = (Right)either).value()) != null) {
                domain.User user2 = user;
                future = user2.isDeactivated() ? Future$.MODULE$.failed((Throwable)new AuthorizationChecks.PermissionDenied$.Reject(new StringBuilder(20).append("User ").append(userId).append(" is deactivated").toString(), (ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()).asGrpcError()) : Future$.MODULE$.successful((Object)user2);
            } else {
                throw new MatchError((Object)either);
            }
            return future.map((Function1 & Serializable)value -> value, this.ec());
        }, this.ec());
    }

    private Future<UserManagementStore> getUserManagementStore(Option<UserManagementStore> userManagementStoreO) {
        Option<UserManagementStore> option = userManagementStoreO;
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.failed((Throwable)new AuthorizationChecks.Unauthenticated$.UserBasedAuthenticationIsDisabled((ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()).asGrpcError());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            UserManagementStore userManagementStore = (UserManagementStore)some.value();
            return Future$.MODULE$.successful((Object)userManagementStore);
        }
        throw new MatchError(option);
    }

    private Future<String> getUserId(String userIdStr) {
        Either either = Ref$.MODULE$.UserId().fromString(userIdStr);
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            return Future$.MODULE$.failed((Throwable)ValidationErrors$.MODULE$.invalidArgument(new StringBuilder(6).append("token ").append(err).toString(), (ContextualizedErrorLogger)this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger()));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String userId = (String)right.value();
            return Future$.MODULE$.successful((Object)userId);
        }
        throw new MatchError((Object)either);
    }

    public AuthorizationInterceptor(AuthService authService, Option<UserManagementStore> userManagementStoreO, IdentityProviderAwareAuthService identityProviderAwareAuthService, ExecutionContext ec, LoggingContext loggingContext) {
        this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$authService = authService;
        this.userManagementStoreO = userManagementStoreO;
        this.identityProviderAwareAuthService = identityProviderAwareAuthService;
        this.ec = ec;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.com$daml$ledger$api$auth$interceptor$AuthorizationInterceptor$$errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
    }
}

