/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.auth.services;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.auth.Authorizer;
import com.daml.ledger.api.v1.admin.user_management_service.CreateUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersRequest;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersResponse;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.Right;
import com.daml.ledger.api.v1.admin.user_management_service.UpdateUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.UpdateUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.User;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc$;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc$UserManagementService$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.server.api.ProxyCloseable;
import io.grpc.ServerServiceDefinition;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t%b!\u0002\r\u001a\u0005\u0005*\u0003\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011\u0003'\t\u0011a\u0003!\u0011!Q\u0001\n5C\u0001\"\u0017\u0001\u0003\u0006\u0004%IA\u0017\u0005\t?\u0002\u0011\t\u0011)A\u00057\"A\u0001\r\u0001B\u0001B\u0003-\u0011\r\u0003\u0005h\u0001\t\u0005\t\u0015a\u0003i\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u001dI\bA1A\u0005\niDaA \u0001!\u0002\u0013Y\b\u0002C@\u0001\u0005\u0004%Y!!\u0001\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0007Aq!!\u0005\u0001\t\u0013\t\u0019\u0002C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u00111\u000e\u0001\u0005B\u00055\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\t9\u000b\u0001C!\u0003SCq!a/\u0001\t\u0003\ni\fC\u0004\u0002P\u0002!\t%!5\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\"9\u0011Q\u001f\u0001\u0005B\u0005]\bbBA\u0000\u0001\u0011%!\u0011\u0001\u0002#+N,'/T1oC\u001e,W.\u001a8u'\u0016\u0014h/[2f\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8\u000b\u0005iY\u0012\u0001C:feZL7-Z:\u000b\u0005qi\u0012\u0001B1vi\"T!AH\u0010\u0002\u0007\u0005\u0004\u0018N\u0003\u0002!C\u00051A.\u001a3hKJT!AI\u0012\u0002\t\u0011\fW\u000e\u001c\u0006\u0002I\u0005\u00191m\\7\u0014\u000b\u00011CFO\"\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tisG\u0004\u0002/k5\tqF\u0003\u00021c\u00059Ro]3s?6\fg.Y4f[\u0016tGoX:feZL7-\u001a\u0006\u0003eM\nQ!\u00193nS:T!\u0001N\u000f\u0002\u0005Y\f\u0014B\u0001\u001c0\u0003e)6/\u001a:NC:\fw-Z7f]R\u001cVM\u001d<jG\u0016<%\u000f]2\n\u0005aJ$!F+tKJl\u0015M\\1hK6,g\u000e^*feZL7-\u001a\u0006\u0003m=\u0002\"aO!\u000e\u0003qR!AH\u001f\u000b\u0005yz\u0014AB:feZ,'O\u0003\u0002AC\u0005A\u0001\u000f\\1uM>\u0014X.\u0003\u0002Cy\tq\u0001K]8ys\u000ecwn]3bE2,\u0007C\u0001#I\u001b\u0005)%B\u0001$H\u0003\u00119'\u000f]2\u000b\u0005yy\u0014BA%F\u000599%\u000f]2Ba&\u001cVM\u001d<jG\u0016\fqa]3sm&\u001cWm\u0001\u0001\u0016\u00035\u00132A\u0014\u0017Q\r\u0011y\u0005\u0001A'\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001\u00027b]\u001eT\u0011!V\u0001\u0005U\u00064\u0018-\u0003\u0002X%\ni\u0011)\u001e;p\u00072|7/Z1cY\u0016\f\u0001b]3sm&\u001cW\rI\u0001\u000bCV$\bn\u001c:ju\u0016\u0014X#A.\u0011\u0005qkV\"A\u000e\n\u0005y[\"AC!vi\"|'/\u001b>fe\u0006Y\u0011-\u001e;i_JL'0\u001a:!\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0002cK6\t1M\u0003\u0002eQ\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0019\u001c'\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u00039awnZ4j]\u001e\u001cuN\u001c;fqR\u0004\"!\u001b7\u000e\u0003)T!a[\u0011\u0002\u000f1|wmZ5oO&\u0011QN\u001b\u0002\u000f\u0019><w-\u001b8h\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019\u0001/\u001e=\u0015\u0007E\u001cH\u000f\u0005\u0002s\u00015\t\u0011\u0004C\u0003a\u000f\u0001\u000f\u0011\rC\u0003h\u000f\u0001\u000f\u0001\u000eC\u0003K\u000f\u0001\u0007aOE\u0002xYA3Aa\u0014\u0001\u0001m\")\u0011l\u0002a\u00017\u00061An\\4hKJ,\u0012a\u001f\t\u0003SrL!! 6\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\n1\"\u001a:s_JdunZ4feV\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u0011\u0002\u000b\u0015\u0014(o\u001c:\n\t\u00055\u0011q\u0001\u0002\u001a\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'/\u0001\u0007feJ|'\u000fT8hO\u0016\u0014\b%\u0001\rd_:$\u0018-\u001b8t!\u0006\u0014H/[2ja\u0006tG/\u00113nS:$B!!\u0006\u0002\u001cA\u0019q%a\u0006\n\u0007\u0005e\u0001FA\u0004C_>dW-\u00198\t\u000f\u0005uA\u00021\u0001\u0002 \u00051!/[4iiN\u0004b!!\t\u00022\u0005]b\u0002BA\u0012\u0003[qA!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003SY\u0015A\u0002\u001fs_>$h(C\u0001*\u0013\r\ty\u0003K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019$!\u000e\u0003\u0007M+\u0017OC\u0002\u00020!\u00022ALA\u001d\u0013\r\tYd\f\u0002\u0006%&<\u0007\u000e^\u0001\u000bGJ,\u0017\r^3Vg\u0016\u0014H\u0003BA!\u0003\u001b\u0002RAYA\"\u0003\u000fJ1!!\u0012d\u0005\u00191U\u000f^;sKB\u0019a&!\u0013\n\u0007\u0005-sF\u0001\nDe\u0016\fG/Z+tKJ\u0014Vm\u001d9p]N,\u0007bBA(\u001b\u0001\u0007\u0011\u0011K\u0001\be\u0016\fX/Z:u!\rq\u00131K\u0005\u0004\u0003+z#!E\"sK\u0006$X-V:feJ+\u0017/^3ti\u00069q-\u001a;Vg\u0016\u0014H\u0003BA.\u0003G\u0002RAYA\"\u0003;\u00022ALA0\u0013\r\t\tg\f\u0002\u0010\u000f\u0016$Xk]3s%\u0016\u001c\bo\u001c8tK\"9\u0011q\n\bA\u0002\u0005\u0015\u0004c\u0001\u0018\u0002h%\u0019\u0011\u0011N\u0018\u0003\u001d\u001d+G/V:feJ+\u0017/^3ti\u0006QA-\u001a7fi\u0016,6/\u001a:\u0015\t\u0005=\u0014q\u000f\t\u0006E\u0006\r\u0013\u0011\u000f\t\u0004]\u0005M\u0014bAA;_\t\u0011B)\u001a7fi\u0016,6/\u001a:SKN\u0004xN\\:f\u0011\u001d\tye\u0004a\u0001\u0003s\u00022ALA>\u0013\r\tih\f\u0002\u0012\t\u0016dW\r^3Vg\u0016\u0014(+Z9vKN$\u0018!\u00037jgR,6/\u001a:t)\u0011\t\u0019)a#\u0011\u000b\t\f\u0019%!\"\u0011\u00079\n9)C\u0002\u0002\n>\u0012\u0011\u0003T5tiV\u001bXM]:SKN\u0004xN\\:f\u0011\u001d\ty\u0005\u0005a\u0001\u0003\u001b\u00032ALAH\u0013\r\t\tj\f\u0002\u0011\u0019&\u001cH/V:feN\u0014V-];fgR\fqb\u001a:b]R,6/\u001a:SS\u001eDGo\u001d\u000b\u0005\u0003/\u000by\nE\u0003c\u0003\u0007\nI\nE\u0002/\u00037K1!!(0\u0005]9%/\u00198u+N,'OU5hQR\u001c(+Z:q_:\u001cX\rC\u0004\u0002PE\u0001\r!!)\u0011\u00079\n\u0019+C\u0002\u0002&>\u0012ac\u0012:b]R,6/\u001a:SS\u001eDGo\u001d*fcV,7\u000f^\u0001\u0011e\u00164xn[3Vg\u0016\u0014(+[4iiN$B!a+\u00024B)!-a\u0011\u0002.B\u0019a&a,\n\u0007\u0005EvF\u0001\rSKZ|7.Z+tKJ\u0014\u0016n\u001a5ugJ+7\u000f]8og\u0016Dq!a\u0014\u0013\u0001\u0004\t)\fE\u0002/\u0003oK1!!/0\u0005]\u0011VM^8lKV\u001bXM\u001d*jO\"$8OU3rk\u0016\u001cH/\u0001\bmSN$Xk]3s%&<\u0007\u000e^:\u0015\t\u0005}\u0016q\u0019\t\u0006E\u0006\r\u0013\u0011\u0019\t\u0004]\u0005\r\u0017bAAc_\t1B*[:u+N,'OU5hQR\u001c(+Z:q_:\u001cX\rC\u0004\u0002PM\u0001\r!!3\u0011\u00079\nY-C\u0002\u0002N>\u0012Q\u0003T5tiV\u001bXM\u001d*jO\"$8OU3rk\u0016\u001cH/\u0001\u0006va\u0012\fG/Z+tKJ$B!a5\u0002\\B)!-a\u0011\u0002VB\u0019a&a6\n\u0007\u0005ewF\u0001\nVa\u0012\fG/Z+tKJ\u0014Vm\u001d9p]N,\u0007bBA()\u0001\u0007\u0011Q\u001c\t\u0004]\u0005}\u0017bAAq_\t\tR\u000b\u001d3bi\u0016,6/\u001a:SKF,Xm\u001d;\u0002\u0017\tLg\u000eZ*feZL7-\u001a\u000b\u0003\u0003O\u0004B!!;\u0002r6\u0011\u00111\u001e\u0006\u0004\r\u00065(BAAx\u0003\tIw.\u0003\u0003\u0002t\u0006-(aF*feZ,'oU3sm&\u001cW\rR3gS:LG/[8o\u0003\u0015\u0019Gn\\:f)\t\tI\u0010E\u0002(\u0003wL1!!@)\u0005\u0011)f.\u001b;\u00025\u0011,g-Y;miR{\u0017)\u001e;iK:$\u0018nY1uK\u0012,6/\u001a:\u0015\t\t\r!Q\u0005\t\u0007\u0005\u000b\u0011YAa\u0004\u000e\u0005\t\u001d!b\u0001B\u0005Q\u0005!Q\u000f^5m\u0013\u0011\u0011iAa\u0002\u0003\u0007Q\u0013\u0018\u0010E\u0003(\u0005#\u0011)\"C\u0002\u0003\u0014!\u0012aa\u00149uS>t\u0007\u0003\u0002B\f\u0005?qAA!\u0007\u0003\u001cA\u0019\u0011Q\u0005\u0015\n\u0007\tu\u0001&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005C\u0011\u0019C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005;A\u0003b\u0002B\u0014/\u0001\u0007!QC\u0001\u0007kN,'/\u00133")
public final class UserManagementServiceAuthorization
implements UserManagementServiceGrpc.UserManagementService,
ProxyCloseable,
GrpcApiService {
    private final UserManagementServiceGrpc.UserManagementService service;
    private final Authorizer authorizer;
    private final ExecutionContext executionContext;
    private final ContextualizedLogger logger;
    private final ContextualizedErrorLogger errorLogger;

    public UserManagementServiceGrpc$UserManagementService$ serviceCompanion() {
        return UserManagementServiceGrpc.UserManagementService.serviceCompanion$((UserManagementServiceGrpc.UserManagementService)this);
    }

    public UserManagementServiceGrpc.UserManagementService service() {
        return this.service;
    }

    private Authorizer authorizer() {
        return this.authorizer;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private ContextualizedErrorLogger errorLogger() {
        return this.errorLogger;
    }

    private boolean containsParticipantAdmin(Seq<Right> rights) {
        return rights.contains((Object)new Right((Right.Kind)new Right.Kind$.ParticipantAdmin(new Right.ParticipantAdmin())));
    }

    public Future<CreateUserResponse> createUser(CreateUserRequest request2) {
        Option option = request2.user();
        if (option instanceof Some) {
            Some some = (Some)option;
            User user = (User)some.value();
            return (Future)this.authorizer().requireIdpAdminClaimsAndMatchingRequestIdpId(user.identityProviderId(), this.containsParticipantAdmin((Seq<Right>)request2.rights()), (Function1 & Serializable)request -> this.service().createUser(request)).apply((Object)request2);
        }
        if (None$.MODULE$.equals(option)) {
            return (Future)this.authorizer().requireIdpAdminClaims((Function1 & Serializable)request -> this.service().createUser(request)).apply((Object)request2);
        }
        throw new MatchError((Object)option);
    }

    public Future<GetUserResponse> getUser(GetUserRequest request2) {
        Option option;
        boolean bl = false;
        Success success = null;
        Try<Option<String>> try_ = this.defaultToAuthenticatedUser(request2.userId());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            return Future$.MODULE$.failed(ex);
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String userId = (String)some.value();
                return (Future)this.authorizer().requireMatchingRequestIdpId(request2.identityProviderId(), (Function1 & Serializable)request -> this.service().getUser(request)).apply((Object)request2.copy(userId, request2.copy$default$2()));
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
            return (Future)this.authorizer().requireIdpAdminClaimsAndMatchingRequestIdpId(request2.identityProviderId(), (Function1 & Serializable)request -> this.service().getUser(request)).apply((Object)request2);
        }
        throw new MatchError(try_);
    }

    public Future<DeleteUserResponse> deleteUser(DeleteUserRequest request2) {
        return (Future)this.authorizer().requireIdpAdminClaimsAndMatchingRequestIdpId(request2.identityProviderId(), (Function1 & Serializable)request -> this.service().deleteUser(request)).apply((Object)request2);
    }

    public Future<ListUsersResponse> listUsers(ListUsersRequest request2) {
        return (Future)this.authorizer().requireIdpAdminClaimsAndMatchingRequestIdpId(request2.identityProviderId(), (Function1 & Serializable)request -> this.service().listUsers(request)).apply((Object)request2);
    }

    public Future<GrantUserRightsResponse> grantUserRights(GrantUserRightsRequest request2) {
        return (Future)this.authorizer().requireIdpAdminClaimsAndMatchingRequestIdpId(request2.identityProviderId(), this.containsParticipantAdmin((Seq<Right>)request2.rights()), (Function1 & Serializable)request -> this.service().grantUserRights(request)).apply((Object)request2);
    }

    public Future<RevokeUserRightsResponse> revokeUserRights(RevokeUserRightsRequest request2) {
        return (Future)this.authorizer().requireIdpAdminClaimsAndMatchingRequestIdpId(request2.identityProviderId(), this.containsParticipantAdmin((Seq<Right>)request2.rights()), (Function1 & Serializable)request -> this.service().revokeUserRights(request)).apply((Object)request2);
    }

    public Future<ListUserRightsResponse> listUserRights(ListUserRightsRequest request2) {
        Option option;
        boolean bl = false;
        Success success = null;
        Try<Option<String>> try_ = this.defaultToAuthenticatedUser(request2.userId());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            return Future$.MODULE$.failed(ex);
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String userId = (String)some.value();
                return (Future)this.authorizer().requireMatchingRequestIdpId(request2.identityProviderId(), (Function1 & Serializable)request -> this.service().listUserRights(request)).apply((Object)request2.copy(userId, request2.copy$default$2()));
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
            return (Future)this.authorizer().requireIdpAdminClaimsAndMatchingRequestIdpId(request2.identityProviderId(), (Function1 & Serializable)request -> this.service().listUserRights(request)).apply((Object)request2);
        }
        throw new MatchError(try_);
    }

    public Future<UpdateUserResponse> updateUser(UpdateUserRequest request2) {
        Option option = request2.user();
        if (option instanceof Some) {
            Some some = (Some)option;
            User user = (User)some.value();
            return (Future)this.authorizer().requireIdpAdminClaimsAndMatchingRequestIdpId(user.identityProviderId(), (Function1 & Serializable)request -> this.service().updateUser(request)).apply((Object)request2);
        }
        if (None$.MODULE$.equals(option)) {
            return (Future)this.authorizer().requireIdpAdminClaims((Function1 & Serializable)request -> this.service().updateUser(request)).apply((Object)request2);
        }
        throw new MatchError((Object)option);
    }

    public ServerServiceDefinition bindService() {
        return UserManagementServiceGrpc$.MODULE$.bindService((UserManagementServiceGrpc.UserManagementService)this, this.executionContext);
    }

    public void close() {
        ((AutoCloseable)this.service()).close();
    }

    private Try<Option<String>> defaultToAuthenticatedUser(String userId) {
        return this.authorizer().authenticatedUserId().flatMap((Function1 & Serializable)x0$1 -> {
            Option option;
            block4: {
                String authUserId;
                block5: {
                    option = x0$1;
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    authUserId = (String)some.value();
                    if (userId.isEmpty()) break block5;
                    String string = userId;
                    String string2 = authUserId;
                    if (string != null ? !string.equals(string2) : string2 != null) break block4;
                }
                return new Success((Object)new Some((Object)authUserId));
            }
            if (None$.MODULE$.equals(option) && userId.isEmpty()) {
                return new Failure((Throwable)new RequestValidation.InvalidArgument$.Reject("requests with an empty user-id are only supported if there is an authenticated user", this.errorLogger()).asGrpcError());
            }
            return new Success((Object)None$.MODULE$);
        });
    }

    public UserManagementServiceAuthorization(UserManagementServiceGrpc.UserManagementService service, Authorizer authorizer, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.service = service;
        this.authorizer = authorizer;
        this.executionContext = executionContext;
        UserManagementServiceGrpc.UserManagementService.$init$((UserManagementServiceGrpc.UserManagementService)this);
        ProxyCloseable.$init$((ProxyCloseable)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
    }
}

