/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import com.daml.platform.apiserver.AuthServiceConfig;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Try$;
import scopt.OptionParser;
import scopt.Read$;

public final class AuthServiceConfigCli$ {
    public static final AuthServiceConfigCli$ MODULE$ = new AuthServiceConfigCli$();

    public <C> void parse(OptionParser<C> parser, Function2<AuthServiceConfig, C, C> setter) {
        parser.opt("auth-jwt-hs256-unsafe", Read$.MODULE$.stringRead()).optional().hidden().validate((Function1 & Serializable)v -> package$.MODULE$.Either().cond(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(v)), (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> "HMAC secret must be a non-empty string")).text("[UNSAFE] Enables JWT-based authorization with shared secret HMAC256 signing: USE THIS EXCLUSIVELY FOR TESTING").action((Function2 & Serializable)(secret, config) -> AuthServiceConfigCli$.setAuthServiceConfig$1(new AuthServiceConfig.UnsafeJwtHmac256((String)secret), config, setter));
        parser.opt("auth-jwt-rs256-crt", Read$.MODULE$.stringRead()).optional().validate((Function1 & Serializable)x$1 -> MODULE$.validatePath((String)x$1, "The certificate file specified via --auth-jwt-rs256-crt does not exist")).text("Enables JWT-based authorization, where the JWT is signed by RSA256 with a public key loaded from the given X509 certificate file (.crt)").action((Function2 & Serializable)(path, config) -> AuthServiceConfigCli$.setAuthServiceConfig$1(new AuthServiceConfig.JwtRs256Crt((String)path), config, setter));
        parser.opt("auth-jwt-es256-crt", Read$.MODULE$.stringRead()).optional().validate((Function1 & Serializable)x$2 -> MODULE$.validatePath((String)x$2, "The certificate file specified via --auth-jwt-es256-crt does not exist")).text("Enables JWT-based authorization, where the JWT is signed by ECDSA256 with a public key loaded from the given X509 certificate file (.crt)").action((Function2 & Serializable)(path, config) -> AuthServiceConfigCli$.setAuthServiceConfig$1(new AuthServiceConfig.JwtEs256Crt((String)path), config, setter));
        parser.opt("auth-jwt-es512-crt", Read$.MODULE$.stringRead()).optional().validate((Function1 & Serializable)x$3 -> MODULE$.validatePath((String)x$3, "The certificate file specified via --auth-jwt-es512-crt does not exist")).text("Enables JWT-based authorization, where the JWT is signed by ECDSA512 with a public key loaded from the given X509 certificate file (.crt)").action((Function2 & Serializable)(path, config) -> AuthServiceConfigCli$.setAuthServiceConfig$1(new AuthServiceConfig.JwtEs512Crt((String)path), config, setter));
        parser.opt("auth-jwt-rs256-jwks", Read$.MODULE$.stringRead()).optional().validate((Function1 & Serializable)v -> package$.MODULE$.Either().cond(v.length() > 0, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> "JWK server URL must be a non-empty string")).text("Enables JWT-based authorization, where the JWT is signed by RSA256 with a public key loaded from the given JWKS URL").action((Function2 & Serializable)(url, config) -> AuthServiceConfigCli$.setAuthServiceConfig$1(new AuthServiceConfig.JwtRs256Jwks((String)url), config, setter));
    }

    private Either<String, BoxedUnit> validatePath(String path, String message) {
        boolean valid = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> Paths.get(path, new String[0]).toFile().canRead()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        return valid ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)message);
    }

    private static final Object setAuthServiceConfig$1(AuthServiceConfig authServiceConfig, Object c, Function2 setter$1) {
        return setter$1.apply((Object)authServiceConfig, c);
    }

    private AuthServiceConfigCli$() {
    }
}

