/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import akka.actor.ActorSystem;
import akka.stream.Materializer;
import com.daml.api.util.TimeProvider;
import com.daml.api.util.TimeProvider$UTC$;
import com.daml.buildinfo.BuildInfo$;
import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.Authorizer;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor;
import com.daml.ledger.api.auth.interceptor.AuthorizationInterceptor$;
import com.daml.ledger.api.health.HealthChecks;
import com.daml.ledger.participant.state.index.v2.IndexService;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.ledger.participant.state.v2.SubmissionResult;
import com.daml.ledger.participant.state.v2.WriteService;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.lf.engine.Engine;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.ApiServer;
import com.daml.platform.apiserver.ApiServerConfig;
import com.daml.platform.apiserver.ApiServices;
import com.daml.platform.apiserver.ExecutionSequencerFactoryOwner;
import com.daml.platform.apiserver.LedgerApiServer;
import com.daml.platform.apiserver.LedgerFeatures;
import com.daml.platform.apiserver.SeedService;
import com.daml.platform.apiserver.SeedService$;
import com.daml.platform.apiserver.TimeServiceBackend;
import com.daml.platform.configuration.CommandConfiguration;
import com.daml.platform.configuration.InitialLedgerConfiguration;
import com.daml.platform.configuration.PartyConfiguration;
import com.daml.platform.services.time.TimeProviderType;
import com.daml.platform.services.time.TimeProviderType$Static$;
import com.daml.platform.usermanagement.UserManagementConfig;
import com.daml.ports.Port;
import com.daml.ports.PortFiles;
import com.daml.ports.PortFiles$;
import com.daml.resources.AbstractResourceOwner;
import com.daml.telemetry.TelemetryContext;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Clock;
import java.util.concurrent.Executor;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scalaz.;

public final class StandaloneApiServer$ {
    public static final StandaloneApiServer$ MODULE$ = new StandaloneApiServer$();
    private static final ContextualizedLogger logger = ContextualizedLogger$.MODULE$.get(MODULE$.getClass());

    private ContextualizedLogger logger() {
        return logger;
    }

    public AbstractResourceOwner<ResourceContext, ApiServer> apply(IndexService indexService, UserManagementStore userManagementStore, String ledgerId, String participantId, ApiServerConfig config, Option<WriteService> optWriteService, HealthChecks healthChecks, Metrics metrics, Option<TimeServiceBackend> timeServiceBackend, Seq<BindableService> otherServices, List<ServerInterceptor> otherInterceptors, Engine engine, ExecutionContextExecutor servicesExecutionContext, Function1<TelemetryContext, Option<SubmissionResult>> checkOverloaded, LedgerFeatures ledgerFeatures, AuthService authService, ActorSystem actorSystem, Materializer materializer, LoggingContext loggingContext) {
        Clock clock = Clock.systemUTC();
        Authorizer authorizer = new Authorizer((Function0 & Serializable)() -> clock.instant(), ledgerId, participantId, userManagementStore, (ExecutionContext)servicesExecutionContext, config.userManagement().cacheExpiryAfterWriteInSeconds(), actorSystem.scheduler(), loggingContext);
        HealthChecks healthChecksWithIndexService = healthChecks.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)indexService));
        AbstractResourceOwner abstractResourceOwner = new ExecutionSequencerFactoryOwner(actorSystem).map((Function1 & Serializable)executionSequencerFactory -> {
            String x$1 = participantId;
            Option x$22 = optWriteService;
            IndexService x$32 = indexService;
            Authorizer x$4 = authorizer;
            Engine x$5 = engine;
            TimeProvider x$6 = (TimeProvider)timeServiceBackend.getOrElse((Function0 & Serializable)() -> TimeProvider$UTC$.MODULE$);
            TimeProviderType x$7 = (TimeProviderType)timeServiceBackend.fold((Function0 & Serializable)() -> TimeProviderType.WallClock$.MODULE$, (Function1 & Serializable)x$2 -> TimeProviderType$Static$.MODULE$);
            Duration x$8 = config.configurationLoadTimeout();
            Option<InitialLedgerConfiguration> x$9 = config.initialLedgerConfiguration();
            CommandConfiguration x$10 = config.command();
            PartyConfiguration x$11 = config.party();
            Option x$12 = timeServiceBackend;
            ExecutionContextExecutor x$13 = servicesExecutionContext;
            Metrics x$14 = metrics;
            HealthChecks x$15 = healthChecksWithIndexService;
            SeedService x$16 = SeedService$.MODULE$.apply(config.seeding());
            FiniteDuration x$17 = config.managementServiceTimeout();
            Function1 x$18 = checkOverloaded;
            UserManagementStore x$19 = userManagementStore;
            LedgerFeatures x$20 = ledgerFeatures;
            UserManagementConfig x$21 = config.userManagement();
            Duration x$222 = config.apiStreamShutdownTimeout();
            Materializer x$23 = materializer;
            ExecutionSequencerFactory x$24 = executionSequencerFactory;
            LoggingContext x$25 = loggingContext;
            AbstractResourceOwner apiServicesOwner = new ApiServices.Owner(x$1, (Option<WriteService>)x$22, x$32, x$19, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option<TimeServiceBackend>)x$12, (ExecutionContext)x$13, x$14, x$15, x$16, x$17, (Function1<TelemetryContext, Option<SubmissionResult>>)x$18, x$20, x$21, x$222, x$23, x$24, x$25).map((Function1 & Serializable)x$3 -> x$3.withServices(otherServices));
            return new Tuple2(executionSequencerFactory, (Object)apiServicesOwner);
        });
        return abstractResourceOwner.flatMap((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AbstractResourceOwner apiServicesOwner = (AbstractResourceOwner)tuple2._2();
            AuthorizationInterceptor authorizationInterceptor = AuthorizationInterceptor$.MODULE$.apply(authService, Option$.MODULE$.when(config.userManagement().enabled(), (Function0 & Serializable)() -> userManagementStore), (ExecutionContext)servicesExecutionContext);
            LedgerApiServer ledgerApiServer = new LedgerApiServer((AbstractResourceOwner<ResourceContext, ApiServices>)apiServicesOwner, config.port(), config.maxInboundMessageSize(), config.address(), config.tls(), (List<ServerInterceptor>)otherInterceptors.$colon$colon((Object)authorizationInterceptor), (Executor)servicesExecutionContext, metrics, config.rateLimitingConfig(), loggingContext);
            AbstractResourceOwner abstractResourceOwner = ledgerApiServer.flatMap((Function1 & Serializable)apiServer -> ResourceOwner$.MODULE$.forTry((Function0 & Serializable)() -> StandaloneApiServer$.writePortFile$1(apiServer.port(), config)).map((Function1 & Serializable)x$4 -> {
                BoxedUnit boxedUnit = x$4;
                MODULE$.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(58).append("Initialized API server version ").append(BuildInfo$.MODULE$.Version()).append(" with ledger-id = ").append(ledgerId).append(", port = ").append(new Port(apiServer.port())).toString(), loggingContext);
                ApiServer apiServer = apiServer;
                return apiServer;
            }));
            return abstractResourceOwner;
        });
    }

    public Option<TimeServiceBackend> apply$default$9() {
        return None$.MODULE$;
    }

    public Seq<BindableService> apply$default$10() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public List<ServerInterceptor> apply$default$11() {
        return package$.MODULE$.List().empty();
    }

    public Function1<TelemetryContext, Option<SubmissionResult>> apply$default$14() {
        return (Function1 & Serializable)x$1 -> None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Try writePortFile$1(int port, ApiServerConfig config$1) {
        Option<Path> option = config$1.portFile();
        if (option instanceof Some) {
            Failure failure;
            Some some = (Some)option;
            Path path = (Path)some.value();
            .bslash.div div2 = PortFiles$.MODULE$.write(path, port);
            if (div2 instanceof .minus.bslash.div) {
                .minus.bslash.div div3 = (.minus.bslash.div)div2;
                PortFiles.Error err = (PortFiles.Error)div3.a();
                failure = new Failure((Throwable)new RuntimeException(err.toString()));
                return failure;
            }
            if (!(div2 instanceof .bslash.div.minus)) throw new MatchError((Object)div2);
            .bslash.div.minus minus2 = (.bslash.div.minus)div2;
            BoxedUnit boxedUnit = (BoxedUnit)minus2.b();
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            BoxedUnit boxedUnit3 = boxedUnit;
            if (boxedUnit2 == null) {
                if (boxedUnit3 != null) {
                    throw new MatchError((Object)div2);
                }
            } else if (!boxedUnit2.equals(boxedUnit3)) throw new MatchError((Object)div2);
            failure = new Success((Object)BoxedUnit.UNIT);
            return failure;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return new Success((Object)BoxedUnit.UNIT);
    }

    private StandaloneApiServer$() {
    }
}

