/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import com.daml.platform.apiserver.configuration.RateLimitingConfig;
import java.io.Serializable;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class TenuredMemoryPool$ {
    public static final TenuredMemoryPool$ MODULE$ = new TenuredMemoryPool$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public Option<MemoryPoolMXBean> findTenuredMemoryPool(RateLimitingConfig config, List<MemoryPoolMXBean> memoryPoolMxBeans) {
        None$ none$;
        Option option = ((IterableOps)this.candidates(memoryPoolMxBeans).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)TenuredMemoryPool$.$anonfun$findTenuredMemoryPool$1(x$5)), (Ordering)Ordering.Long$.MODULE$)).lastOption();
        if (None$.MODULE$.equals(option)) {
            this.logger().error("Could not find tenured memory pool");
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            MemoryPoolMXBean pool = (MemoryPoolMXBean)some.value();
            long threshold = config.calculateCollectionUsageThreshold(pool.getCollectionUsage().getMax());
            this.logger().info(new StringBuilder(72).append("Using 'tenured' memory pool ").append(pool.getName()).append(".  Setting its collection pool threshold to ").append(threshold).toString());
            pool.setCollectionUsageThreshold(threshold);
            none$ = new Some((Object)pool);
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    private List<MemoryPoolMXBean> candidates(List<MemoryPoolMXBean> memoryPoolMxBeans) {
        return memoryPoolMxBeans.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TenuredMemoryPool$.$anonfun$candidates$1(p)));
    }

    public static final /* synthetic */ long $anonfun$findTenuredMemoryPool$1(MemoryPoolMXBean x$5) {
        return x$5.getCollectionUsage().getMax();
    }

    public static final /* synthetic */ boolean $anonfun$candidates$1(MemoryPoolMXBean p) {
        MemoryType memoryType = p.getType();
        MemoryType memoryType2 = MemoryType.HEAP;
        return !(memoryType != null ? !((Object)((Object)memoryType)).equals((Object)memoryType2) : memoryType2 != null) && p.isCollectionUsageThresholdSupported();
    }

    private TenuredMemoryPool$() {
    }
}

