/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.daml.api.util.TimestampConversion$;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.grpc.adapter.server.akka.StreamingServiceLifecycleManagement;
import com.daml.ledger.api.domain$;
import com.daml.ledger.api.v1.testing.time_service.GetTimeRequest;
import com.daml.ledger.api.v1.testing.time_service.GetTimeResponse;
import com.daml.ledger.api.v1.testing.time_service.SetTimeRequest;
import com.daml.ledger.api.v1.testing.time_service.TimeServiceAkkaGrpc;
import com.daml.ledger.api.v1.testing.time_service.TimeServiceGrpc;
import com.daml.ledger.api.v1.testing.time_service.TimeServiceGrpc$;
import com.daml.ledger.api.v1.testing.time_service.TimeServiceGrpc$TimeService$;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.akkastreams.dispatcher.SignalDispatcher;
import com.daml.platform.akkastreams.dispatcher.SignalDispatcher$;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.TimeServiceBackend;
import com.daml.platform.apiserver.services.ApiTimeService$;
import com.daml.platform.server.api.ValidationLogger$;
import com.daml.platform.server.api.validation.FieldValidations$;
import com.daml.timer.Timeout;
import com.daml.timer.Timeout$;
import com.google.protobuf.empty.Empty;
import com.google.protobuf.empty.Empty$;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scalaz.syntax.TagOps$;

@ScalaSignature(bytes="\u0006\u0005\t%b!B\u000e\u001d\u0005y1\u0003\u0002\u0003\"\u0001\u0005\u000b\u0007I\u0011\u0001#\t\u0011]\u0003!\u0011!Q\u0001\n\u0015C\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"Aa\r\u0001BC\u0002\u0013Mq\r\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003i\u0011!\t\bA!b\u0001\n'\u0011\b\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u0011m\u0004!\u0011!Q\u0001\fqD!\"!\u0001\u0001\u0005\u0003\u0005\u000b1BA\u0002\u0011\u001d\ty\u0001\u0001C\u0005\u0003#A\u0011\"a\n\u0001\u0005\u0004%Y!!\u000b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%Y!!\u000e\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003oA\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u0013Bq!!\u0017\u0001\t#\nY\u0006C\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002D\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007bBAr\u0001\u0011\u0005\u0013Q]\u0004\t\u0003[d\u0002\u0012\u0001\u0010\u0002p\u001a91\u0004\bE\u0001=\u0005E\bbBA\b1\u0011\u0005\u00111\u001f\u0005\b\u0003kDB\u0011AA|\u00059\t\u0005/\u001b+j[\u0016\u001cVM\u001d<jG\u0016T!!\b\u0010\u0002\u0011M,'O^5dKNT!a\b\u0011\u0002\u0013\u0005\u0004\u0018n]3sm\u0016\u0014(BA\u0011#\u0003!\u0001H.\u0019;g_Jl'BA\u0012%\u0003\u0011!\u0017-\u001c7\u000b\u0003\u0015\n1aY8n'\u0011\u0001q%L\u001e\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tq\u0013(D\u00010\u0015\t\u0001\u0014'\u0001\u0007uS6,wl]3sm&\u001cWM\u0003\u00023g\u00059A/Z:uS:<'B\u0001\u001b6\u0003\t1\u0018G\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005a\u0012\u0013A\u00027fI\u001e,'/\u0003\u0002;_\t\u0019B+[7f'\u0016\u0014h/[2f\u0003.\\\u0017m\u0012:qGB\u0011A\bQ\u0007\u0002{)\u0011ahP\u0001\u0005OJ\u00048M\u0003\u00027A%\u0011\u0011)\u0010\u0002\u000f\u000fJ\u00048-\u00119j'\u0016\u0014h/[2f\u0003!aW\rZ4fe&#7\u0001A\u000b\u0002\u000bB\u0011a\t\u0016\b\u0003\u000fJs!\u0001S)\u000f\u0005%\u0003fB\u0001&P\u001d\tYe*D\u0001M\u0015\ti5)\u0001\u0004=e>|GOP\u0005\u0002K%\u00111\u0005J\u0005\u0003q\tJ!AN\u001c\n\u0005M+\u0014A\u00023p[\u0006Lg.\u0003\u0002V-\nAA*\u001a3hKJLEM\u0003\u0002Tk\u0005IA.\u001a3hKJLE\rI\u0001\bE\u0006\u001c7.\u001a8e!\tQ6,D\u0001\u001f\u0013\tafD\u0001\nUS6,7+\u001a:wS\u000e,')Y2lK:$\u0017\u0001G1qSN#(/Z1n'\",H\u000fZ8x]RKW.Z8viB\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\tIV\u0014\u0018\r^5p]*\u00111-K\u0001\u000bG>t7-\u001e:sK:$\u0018BA3a\u0005!!UO]1uS>t\u0017aA7biV\t\u0001\u000e\u0005\u0002j]6\t!N\u0003\u0002lY\u000611\u000f\u001e:fC6T\u0011!\\\u0001\u0005C.\\\u0017-\u0003\u0002pU\naQ*\u0019;fe&\fG.\u001b>fe\u0006!Q.\u0019;!\u0003\r)7OZ\u000b\u0002gB\u0011A\u000f_\u0007\u0002k*\u0011ao^\u0001\bC\u0012\f\u0007\u000f^3s\u0015\tq$%\u0003\u0002zk\nIR\t_3dkRLwN\\*fcV,gnY3s\r\u0006\u001cGo\u001c:z\u0003\u0011)7O\u001a\u0011\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\bCA?\u007f\u001b\u0005\u0011\u0017BA@c\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003#\u0003\u001dawnZ4j]\u001eLA!!\u0004\u0002\b\tqAj\\4hS:<7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0005\u0002\u0014\u0005\u0005\u00121EA\u0013))\t)\"!\u0007\u0002\u001c\u0005u\u0011q\u0004\t\u0004\u0003/\u0001Q\"\u0001\u000f\t\u000b\u0019\\\u00019\u00015\t\u000bE\\\u00019A:\t\u000bm\\\u00019\u0001?\t\u000f\u0005\u00051\u0002q\u0001\u0002\u0004!)!i\u0003a\u0001\u000b\")\u0001l\u0003a\u00013\")Ql\u0003a\u0001=\u00061An\\4hKJ,\"!a\u000b\u0011\t\u0005\u0015\u0011QF\u0005\u0005\u0003_\t9A\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003e\u0019wN\u001c;fqR,\u0018\r\\5{K\u0012,%O]8s\u0019><w-\u001a:\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u\"%A\u0003feJ|'/\u0003\u0003\u0002B\u0005m\"!G\"p]R,\u0007\u0010^;bY&TX\rZ#se>\u0014Hj\\4hKJ\f!dY8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4fe\u0002\n!\u0002Z5ta\u0006$8\r[3s+\t\tI\u0005\u0005\u0003\u0002L\u0005MSBAA'\u0015\u0011\t)%a\u0014\u000b\u0007\u0005E\u0003%A\u0006bW.\f7\u000f\u001e:fC6\u001c\u0018\u0002BA+\u0003\u001b\u0012\u0001cU5h]\u0006dG)[:qCR\u001c\u0007.\u001a:\u0002\u0017\u0011L7\u000f]1uG\",'\u000fI\u0001\u000eO\u0016$H+[7f'>,(oY3\u0015\t\u0005u\u0013q\u000f\t\t\u0003?\n)'!\u001b\u0002p5\u0011\u0011\u0011\r\u0006\u0004\u0003GR\u0017\u0001C:dC2\fGm\u001d7\n\t\u0005\u001d\u0014\u0011\r\u0002\u0007'>,(oY3\u0011\u00079\nY'C\u0002\u0002n=\u0012qbR3u)&lWMU3ta>t7/\u001a\t\u0005\u0003c\n\u0019(D\u0001m\u0013\r\t)\b\u001c\u0002\b\u001d>$Xk]3e\u0011\u001d\tIH\u0005a\u0001\u0003w\nqA]3rk\u0016\u001cH\u000fE\u0002/\u0003{J1!a 0\u000599U\r\u001e+j[\u0016\u0014V-];fgR\fqa]3u)&lW\r\u0006\u0003\u0002\u0006\u0006}\u0005#B?\u0002\b\u0006-\u0015bAAEE\n1a)\u001e;ve\u0016\u0004B!!$\u0002\u001c6\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0003f[B$\u0018P\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u00039s_R|'-\u001e4\u000b\u0007\u0005eE%\u0001\u0004h_><G.Z\u0005\u0005\u0003;\u000byIA\u0003F[B$\u0018\u0010C\u0004\u0002zM\u0001\r!!)\u0011\u00079\n\u0019+C\u0002\u0002&>\u0012abU3u)&lWMU3rk\u0016\u001cH\u000fK\u0004\u0014\u0003S\u000bI,a/\u0011\t\u0005-\u0016QW\u0007\u0003\u0003[SA!a,\u00022\u0006!A.\u00198h\u0015\t\t\u0019,\u0001\u0003kCZ\f\u0017\u0002BA\\\u0003[\u0013\u0001cU;qaJ,7o],be:LgnZ:\u0002\u000bY\fG.^3-\u0005\u0005u\u0016EAA`\u0003\u0019z'o\u001a\u0018xCJ$(/Z7pm\u0016\u0014hf^1siNt#*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\fE&tGmU3sm&\u001cW\r\u0006\u0002\u0002FB!\u0011qYAh\u001b\t\tIMC\u0002?\u0003\u0017T!!!4\u0002\u0005%|\u0017\u0002BAi\u0003\u0013\u0014qcU3sm\u0016\u00148+\u001a:wS\u000e,G)\u001a4j]&$\u0018n\u001c8\u0002\u001d\u001d,GoQ;se\u0016tG\u000fV5nKV\u0011\u0011q\u001b\t\u0005\u00033\fy.\u0004\u0002\u0002\\*!\u0011Q\\AY\u0003\u0011!\u0018.\\3\n\t\u0005\u0005\u00181\u001c\u0002\b\u0013:\u001cH/\u00198u\u0003\u0015\u0019Gn\\:f)\t\t9\u000fE\u0002)\u0003SL1!a;*\u0005\u0011)f.\u001b;\u0002\u001d\u0005\u0003\u0018\u000eV5nKN+'O^5dKB\u0019\u0011q\u0003\r\u0014\u0005a9CCAAx\u0003\u0019\u0019'/Z1uKRA\u0011\u0011 B\u0012\u0005K\u00119\u0003\u0006\u0006\u0002|\nm!Q\u0004B\u0010\u0005C\u0011R!!@\u0003\u0002m2a!a@\u0019\u0001\u0005m(\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003\u0002B\u0002\u0005+qAA!\u0002\u0003\u00129!!q\u0001B\b\u001d\u0011\u0011IA!\u0004\u000f\u0007\u001d\u0013Y!\u0003\u00025k%\u0011!gM\u0005\u0003aEJ1Aa\u00050\u0003=!\u0016.\\3TKJ4\u0018nY3HeB\u001c\u0017\u0002\u0002B\f\u00053\u00111\u0002V5nKN+'O^5dK*\u0019!1C\u0018\t\u000b\u0019T\u00029\u00015\t\u000bET\u00029A:\t\u000bmT\u00029\u0001?\t\u000f\u0005\u0005!\u0004q\u0001\u0002\u0004!)!I\u0007a\u0001\u000b\")\u0001L\u0007a\u00013\")QL\u0007a\u0001=\u0002")
public final class ApiTimeService
implements TimeServiceAkkaGrpc,
GrpcApiService {
    private final Object ledgerId;
    private final TimeServiceBackend backend;
    private final Duration apiStreamShutdownTimeout;
    private final Materializer mat;
    private final ExecutionSequencerFactory esf;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final ContextualizedErrorLogger contextualizedErrorLogger;
    private final SignalDispatcher dispatcher;
    private volatile boolean com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_closed;
    private TrieMap<KillSwitch, Object> com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_killSwitches;

    public static TimeServiceGrpc.TimeService create(Object ledgerId, TimeServiceBackend backend, Duration apiStreamShutdownTimeout, Materializer mat, ExecutionSequencerFactory esf, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ApiTimeService$.MODULE$.create(ledgerId, backend, apiStreamShutdownTimeout, mat, esf, executionContext, loggingContext);
    }

    public void getTime(GetTimeRequest request, StreamObserver<GetTimeResponse> responseObserver) {
        TimeServiceAkkaGrpc.getTime$((TimeServiceAkkaGrpc)this, (GetTimeRequest)request, responseObserver);
    }

    public <RespT> void registerStream(Function0<Source<RespT, NotUsed>> buildSource, StreamObserver<RespT> responseObserver, Materializer materializer, ExecutionSequencerFactory executionSequencerFactory) {
        StreamingServiceLifecycleManagement.registerStream$((StreamingServiceLifecycleManagement)this, buildSource, responseObserver, (Materializer)materializer, (ExecutionSequencerFactory)executionSequencerFactory);
    }

    public TimeServiceGrpc$TimeService$ serviceCompanion() {
        return TimeServiceGrpc.TimeService.serviceCompanion$((TimeServiceGrpc.TimeService)this);
    }

    public boolean com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_closed() {
        return this.com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_closed;
    }

    public void com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_closed_$eq(boolean x$1) {
        this.com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_closed = x$1;
    }

    public TrieMap<KillSwitch, Object> com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_killSwitches() {
        return this.com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_killSwitches;
    }

    public final void com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$_setter_$com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_killSwitches_$eq(TrieMap<KillSwitch, Object> x$1) {
        this.com$daml$grpc$adapter$server$akka$StreamingServiceLifecycleManagement$$_killSwitches = x$1;
    }

    public Object ledgerId() {
        return this.ledgerId;
    }

    public Materializer mat() {
        return this.mat;
    }

    public ExecutionSequencerFactory esf() {
        return this.esf;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private ContextualizedErrorLogger contextualizedErrorLogger() {
        return this.contextualizedErrorLogger;
    }

    private SignalDispatcher dispatcher() {
        return this.dispatcher;
    }

    public Source<GetTimeResponse, NotUsed> getTimeSource(GetTimeRequest request) {
        Either validated = FieldValidations$.MODULE$.matchLedgerId(this.ledgerId(), domain$.MODULE$.optionalLedgerId(request.ledgerId()), this.contextualizedErrorLogger());
        return (Source)validated.fold((Function1 & Serializable)t -> Source$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure((Object)request, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable)ledgerId -> {
            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(41).append("Received request for time with ledger ID ").append(ledgerId.getOrElse((Function0 & Serializable)() -> "<empty-ledger-id>")).toString(), $this.loggingContext);
            return ((Source)this.dispatcher().subscribe(this.dispatcher().subscribe$default$1()).map((Function1 & Serializable)x$1 -> $this.backend.getCurrentTime()).scan((Object)new Some((Object)$this.backend.getCurrentTime()), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Instant currentTime = (Instant)tuple2._2();
                    if (option instanceof Some) {
                        Instant previousTime;
                        Some some = (Some)option;
                        Instant instant = previousTime = (Instant)some.value();
                        Instant instant2 = currentTime;
                        if (instant == null) {
                            if (instant2 == null) return None$.MODULE$;
                        } else if (((Object)instant).equals(instant2)) {
                            return None$.MODULE$;
                        }
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Instant currentTime = (Instant)tuple2._2();
                return new Some((Object)currentTime);
            }).mapConcat((Function1 & Serializable)x0$2 -> {
                Nil$ nil$;
                Option option = x0$2;
                if (None$.MODULE$.equals(option)) {
                    nil$ = package$.MODULE$.Nil();
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant t = (Instant)some.value();
                    nil$ = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GetTimeResponse[]{new GetTimeResponse((Option)new Some((Object)TimestampConversion$.MODULE$.fromInstant(t)))}));
                } else {
                    throw new MatchError((Object)option);
                }
                return nil$;
            })).via((Graph)this.logger().logErrorsOnStream($this.loggingContext));
        });
    }

    public Future<Empty> setTime(SetTimeRequest request) {
        Either result = FieldValidations$.MODULE$.matchLedgerId(this.ledgerId(), domain$.MODULE$.optionalLedgerId(request.ledgerId()), this.contextualizedErrorLogger()).flatMap((Function1 & Serializable)x$4 -> {
            Option option = x$4;
            Either either = FieldValidations$.MODULE$.requirePresence(request.currentTime(), "current_time", this.contextualizedErrorLogger()).map((Function1 & Serializable)protoTimestamp -> TimestampConversion$.MODULE$.toInstant(protoTimestamp)).flatMap((Function1 & Serializable)expectedTime -> FieldValidations$.MODULE$.requirePresence(request.newTime(), "new_time", this.contextualizedErrorLogger()).map((Function1 & Serializable)protoTimestamp -> TimestampConversion$.MODULE$.toInstant(protoTimestamp)).flatMap((Function1 & Serializable)requestedTime -> (!requestedTime.isBefore((Instant)expectedTime) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)ValidationErrors$.MODULE$.invalidArgument(new StringBuilder(77).append("new_time [").append(requestedTime).append("] is before current_time [").append(expectedTime).append("]. Setting time backwards is not allowed.").toString(), this.contextualizedErrorLogger()))).map((Function1 & Serializable)x$3 -> {
                BoxedUnit boxedUnit = x$3;
                Future future = this.updateTime$1((Instant)expectedTime, (Instant)requestedTime).map((Function1 & Serializable)x$2 -> {
                    this.dispatcher().signal();
                    return new Empty(Empty$.MODULE$.apply$default$1());
                }, $this.executionContext).andThen(this.logger().logErrorsOnCall($this.loggingContext), $this.executionContext);
                return future;
            })));
            return either;
        });
        return (Future)result.fold((Function1 & Serializable)error -> {
            this.logger().warn().apply((Function0 & Serializable)() -> new StringBuilder(33).append("Failed to set time for request ").append(request).append(": ").append(error.getMessage()).toString(), $this.loggingContext);
            return Future$.MODULE$.failed((Throwable)error);
        }, (Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x));
    }

    public ServerServiceDefinition bindService() {
        return TimeServiceGrpc$.MODULE$.bindService((TimeServiceGrpc.TimeService)this, this.executionContext);
    }

    public Instant getCurrentTime() {
        return this.backend.getCurrentTime();
    }

    public void close() {
        StreamingServiceLifecycleManagement.close$((StreamingServiceLifecycleManagement)this);
        Await$.MODULE$.result((Awaitable)Timeout.FutureTimeoutOps$.MODULE$.withTimeout$extension(Timeout$.MODULE$.FutureTimeoutOps(this.dispatcher().shutdown()), this.apiStreamShutdownTimeout, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.logger().warn().apply((Function0 & Serializable)() -> new StringBuilder(90).append("Shutdown of TimeService API streams did not finish in ").append($this.apiStreamShutdownTimeout.toSeconds()).append(" seconds. System shutdown continues.").toString(), $this.loggingContext)), (Duration)Duration$.MODULE$.Inf());
    }

    public static final /* synthetic */ Either $anonfun$setTime$2(ApiTimeService $this, Instant requestedTime$1, Instant expectedTime$1, boolean success) {
        return success ? package$.MODULE$.Right().apply((Object)requestedTime$1) : package$.MODULE$.Left().apply((Object)ValidationErrors$.MODULE$.invalidArgument(new StringBuilder(43).append("current_time mismatch. Provided: ").append(expectedTime$1).append(". Actual: ").append($this.backend.getCurrentTime()).toString(), $this.contextualizedErrorLogger()));
    }

    private final Future updateTime$1(Instant expectedTime, Instant requestedTime) {
        this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(16).append("Setting time to ").append(requestedTime).toString(), this.loggingContext);
        return this.backend.setCurrentTime(expectedTime, requestedTime).map((Function1 & Serializable)success -> ApiTimeService.$anonfun$setTime$2(this, requestedTime, expectedTime, BoxesRunTime.unboxToBoolean((Object)success)), this.executionContext);
    }

    public ApiTimeService(Object ledgerId, TimeServiceBackend backend, Duration apiStreamShutdownTimeout, Materializer mat, ExecutionSequencerFactory esf, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.ledgerId = ledgerId;
        this.backend = backend;
        this.apiStreamShutdownTimeout = apiStreamShutdownTimeout;
        this.mat = mat;
        this.esf = esf;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        TimeServiceGrpc.TimeService.$init$((TimeServiceGrpc.TimeService)this);
        StreamingServiceLifecycleManagement.$init$((StreamingServiceLifecycleManagement)this);
        TimeServiceAkkaGrpc.$init$((TimeServiceAkkaGrpc)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.dispatcher = SignalDispatcher$.MODULE$.apply();
        this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(41).append(this.getClass().getSimpleName()).append(" initialized with ledger ID ").append(TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(this.ledgerId()))).append(", start time ").append($this.backend.getCurrentTime()).toString(), loggingContext);
        Statics.releaseFence();
    }
}

