/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.admin;

import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import com.daml.api.util.DurationConversion$;
import com.daml.api.util.TimeProvider;
import com.daml.api.util.TimestampConversion$;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.AdminServices;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.v1.admin.config_management_service.ConfigManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.config_management_service.ConfigManagementServiceGrpc$;
import com.daml.ledger.api.v1.admin.config_management_service.ConfigManagementServiceGrpc$ConfigManagementService$;
import com.daml.ledger.api.v1.admin.config_management_service.GetTimeModelRequest;
import com.daml.ledger.api.v1.admin.config_management_service.GetTimeModelResponse;
import com.daml.ledger.api.v1.admin.config_management_service.SetTimeModelRequest;
import com.daml.ledger.api.v1.admin.config_management_service.SetTimeModelResponse;
import com.daml.ledger.api.v1.admin.config_management_service.TimeModel;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.configuration.LedgerTimeModel;
import com.daml.ledger.configuration.LedgerTimeModel$;
import com.daml.ledger.participant.state.index.v2.IndexConfigManagementService;
import com.daml.ledger.participant.state.v2.SubmissionResult;
import com.daml.ledger.participant.state.v2.WriteConfigService;
import com.daml.lf.data.Time;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.services.admin.ApiConfigManagementService$;
import com.daml.platform.apiserver.services.admin.ApiConfigManagementService$SetTimeModelParameters$;
import com.daml.platform.apiserver.services.admin.SynchronousResponse;
import com.daml.platform.server.api.ValidationLogger$;
import com.daml.platform.server.api.validation.FieldValidations$;
import com.daml.telemetry.DefaultTelemetry$;
import com.daml.telemetry.TelemetryContext;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011ub!\u0002 @\u0005\r[\u0005\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u0015\u0005=\u0001A!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u001c\u0001\u0011\t\u0011)A\u0005\u0003;A!\"a\u000b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011)\tY\u0006\u0001B\u0001B\u0003-\u0011Q\f\u0005\u000b\u0003[\u0002!\u0011!Q\u0001\f\u0005=\u0004BCA>\u0001\t\u0005\t\u0015a\u0003\u0002~!9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005\"CAQ\u0001\t\u0007I1BAR\u0011!\tY\u000b\u0001Q\u0001\n\u0005\u0015\u0006bBAW\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\tI\r\u0001C!\u0003\u0017Dq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002x\u0002!\t%!?\u0007\r\t-\u0001\u0001\u0012B\u0007\u0011)\u00119\u0003\u0005BK\u0002\u0013\u0005!\u0011\u0006\u0005\u000b\u0005c\u0001\"\u0011#Q\u0001\n\t-\u0002B\u0003B\u001a!\tU\r\u0011\"\u0001\u00036!Q!Q\t\t\u0003\u0012\u0003\u0006IAa\u000e\t\u0015\t\u001d\u0003C!f\u0001\n\u0003\u0011I\u0005\u0003\u0006\u0003XA\u0011\t\u0012)A\u0005\u0005\u0017Bq!!#\u0011\t\u0003\u0011I\u0006C\u0005\u0003fA\t\t\u0011\"\u0001\u0003h!I!q\u000e\t\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0005\u000f\u0003\u0012\u0013!C\u0001\u0005\u0013C\u0011B!$\u0011#\u0003%\tAa$\t\u0013\tM\u0005#!A\u0005B\tU\u0005\"\u0003BS!\u0005\u0005I\u0011\u0001BT\u0011%\u0011y\u000bEA\u0001\n\u0003\u0011\t\fC\u0005\u0003>B\t\t\u0011\"\u0011\u0003@\"I!Q\u001a\t\u0002\u0002\u0013\u0005!q\u001a\u0005\n\u00053\u0004\u0012\u0011!C!\u00057D\u0011Ba8\u0011\u0003\u0003%\tE!9\t\u0013\t\r\b#!A\u0005B\t\u0015\b\"\u0003Bt!\u0005\u0005I\u0011\tBu\u000f%\u0011i\u000fAA\u0001\u0012\u0013\u0011yOB\u0005\u0003\f\u0001\t\t\u0011#\u0003\u0003r\"9\u0011\u0011\u0012\u0014\u0005\u0002\r\u001d\u0001\"\u0003BrM\u0005\u0005IQ\tBs\u0011%\u0019IAJA\u0001\n\u0003\u001bY\u0001C\u0005\u0004\u0014\u0019\n\t\u0011\"!\u0004\u0016!91q\u0005\u0001\u0005\n\r%r\u0001CB&\u007f!\u00051i!\u0014\u0007\u000fyz\u0004\u0012A\"\u0004P!9\u0011\u0011R\u0017\u0005\u0002\rE\u0003bBB*[\u0011\u00051Q\u000b\u0005\n\u0007kj\u0013\u0013!C\u0001\u0007o2aaa\u001f.\r\ru\u0004BCBXc\t\u0005\t\u0015!\u0003\u0002\u0012!I1\u0011W\u0019\u0003\u0002\u0003\u0006I\u0001 \u0005\u000b\u0007g\u000b$\u0011!Q\u0001\n\rU\u0006BCA>c\t\u0005\t\u0015a\u0003\u0002~!9\u0011\u0011R\u0019\u0005\u0002\r\r\u0007\"CAQc\t\u0007I\u0011BAR\u0011!\tY+\rQ\u0001\n\u0005\u0015\u0006bBBjc\u0011\u00053Q\u001b\u0005\b\u00077\fD\u0011IBo\u0011\u001d!\u0019!\rC!\t\u000bAq\u0001\"\u000b2\t\u0003\"Y\u0003C\u0004\u00056E\"\t\u0005b\u000e\u00035\u0005\u0003\u0018nQ8oM&<W*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3\u000b\u0005\u0001\u000b\u0015!B1e[&t'B\u0001\"D\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001#F\u0003%\t\u0007/[:feZ,'O\u0003\u0002G\u000f\u0006A\u0001\u000f\\1uM>\u0014XN\u0003\u0002I\u0013\u0006!A-Y7m\u0015\u0005Q\u0015aA2p[N!\u0001\u0001\u0014*u!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0019\te.\u001f*fMB\u00111+\u001d\b\u0003):t!!V6\u000f\u0005YKgBA,g\u001d\tA6M\u0004\u0002ZC:\u0011!\f\u0019\b\u00037~k\u0011\u0001\u0018\u0006\u0003;z\u000ba\u0001\u0010:p_Rt4\u0001A\u0005\u0002\u0015&\u0011\u0001*S\u0005\u0003E\u001e\u000ba\u0001\\3eO\u0016\u0014\u0018B\u00013f\u0003\r\t\u0007/\u001b\u0006\u0003E\u001eK!a\u001a5\u0002\u0005Y\f$B\u00013f\u0013\t\u0001%N\u0003\u0002hQ&\u0011A.\\\u0001\u001aG>tg-[4`[\u0006t\u0017mZ3nK:$xl]3sm&\u001cWM\u0003\u0002AU&\u0011q\u000e]\u0001\u001c\u0007>tg-[4NC:\fw-Z7f]R\u001cVM\u001d<jG\u0016<%\u000f]2\u000b\u00051l\u0017B\u0001:t\u0005]\u0019uN\u001c4jO6\u000bg.Y4f[\u0016tGoU3sm&\u001cWM\u0003\u0002paB\u0011Q/_\u0007\u0002m*\u0011q\u000f_\u0001\u0005OJ\u00048M\u0003\u0002e\u000b&\u0011!P\u001e\u0002\u000f\u000fJ\u00048-\u00119j'\u0016\u0014h/[2f\u0003\u0015Ig\u000eZ3y!\ri\u00181B\u0007\u0002}*\u0019q0!\u0001\u0002\u0005Y\u0014$bA>\u0002\u0004)!\u0011QAA\u0004\u0003\u0015\u0019H/\u0019;f\u0015\r\tI!Z\u0001\fa\u0006\u0014H/[2ja\u0006tG/C\u0002\u0002\u000ey\u0014A$\u00138eKb\u001cuN\u001c4jO6\u000bg.Y4f[\u0016tGoU3sm&\u001cW-\u0001\u0007xe&$XmU3sm&\u001cW\r\u0005\u0003\u0002\u0014\u0005]QBAA\u000b\u0015\ry\u00181A\u0005\u0005\u00033\t)B\u0001\nXe&$XmQ8oM&<7+\u001a:wS\u000e,\u0017\u0001\u0004;j[\u0016\u0004&o\u001c<jI\u0016\u0014\b\u0003BA\u0010\u0003Oi!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0005kRLGN\u0003\u0002e\u000f&!\u0011\u0011FA\u0011\u00051!\u0016.\\3Qe>4\u0018\u000eZ3s\u0003U\u0019XOY7jgNLwN\\%e\u000f\u0016tWM]1u_J\u0004r!TA\u0018\u0003g\t\u0019%C\u0002\u000229\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\u0005U\u0012Q\b\b\u0005\u0003o\tI\u0004\u0005\u0002\\\u001d&\u0019\u00111\b(\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tYD\u0014\t\u0005\u0003\u000b\n)F\u0004\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003\u001f:\u0015A\u00017g\u0013\u0011\t\u0019&!\u0013\u0002\u0007I+g-\u0003\u0003\u0002X\u0005e#\u0001D*vE6L7o]5p]&#'\u0002BA*\u0003\u0013\nA\"\\1uKJL\u0017\r\\5{KJ\u0004B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u0003O\nA!Y6lC&!\u00111NA1\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0003\u0002r\u0005]TBAA:\u0015\r\t)HT\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA=\u0003g\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004\u001e\u000bq\u0001\\8hO&tw-\u0003\u0003\u0002\b\u0006\u0005%A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u00055\u0015\u0011TAN\u0003;\u000by\n\u0006\u0005\u0002\u0010\u0006M\u0015QSAL!\r\t\t\nA\u0007\u0002\u007f!9\u00111\f\u0005A\u0004\u0005u\u0003bBA7\u0011\u0001\u000f\u0011q\u000e\u0005\b\u0003wB\u00019AA?\u0011\u0015Y\b\u00021\u0001}\u0011\u001d\ty\u0001\u0003a\u0001\u0003#Aq!a\u0007\t\u0001\u0004\ti\u0002C\u0004\u0002,!\u0001\r!!\f\u0002\r1|wmZ3s+\t\t)\u000b\u0005\u0003\u0002\u0000\u0005\u001d\u0016\u0002BAU\u0003\u0003\u0013AcQ8oi\u0016DH/^1mSj,G\rT8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0006G2|7/\u001a\u000b\u0003\u0003c\u00032!TAZ\u0013\r\t)L\u0014\u0002\u0005+:LG/A\u0006cS:$7+\u001a:wS\u000e,GCAA^!\u0011\ti,!2\u000e\u0005\u0005}&bA<\u0002B*\u0011\u00111Y\u0001\u0003S>LA!a2\u0002@\n92+\u001a:wKJ\u001cVM\u001d<jG\u0016$UMZ5oSRLwN\\\u0001\rO\u0016$H+[7f\u001b>$W\r\u001c\u000b\u0005\u0003\u001b\fY\u000e\u0005\u0004\u0002r\u0005=\u00171[\u0005\u0005\u0003#\f\u0019H\u0001\u0004GkR,(/\u001a\t\u0005\u0003+\f9.D\u0001q\u0013\r\tI\u000e\u001d\u0002\u0015\u000f\u0016$H+[7f\u001b>$W\r\u001c*fgB|gn]3\t\u000f\u0005uW\u00021\u0001\u0002`\u00069!/Z9vKN$\b\u0003BAk\u0003CL1!a9q\u0005M9U\r\u001e+j[\u0016lu\u000eZ3m%\u0016\fX/Z:u\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]R{'+Z:q_:\u001cX\r\u0006\u0003\u0002T\u0006%\bbBAv\u001d\u0001\u0007\u0011Q^\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\u0005=\u00181_\u0007\u0003\u0003cT1!a;f\u0013\u0011\t)0!=\u0003\u001b\r{gNZ5hkJ\fG/[8o\u00031\u0019X\r\u001e+j[\u0016lu\u000eZ3m)\u0011\tYPa\u0001\u0011\r\u0005E\u0014qZA\u007f!\u0011\t).a@\n\u0007\t\u0005\u0001O\u0001\u000bTKR$\u0016.\\3N_\u0012,GNU3ta>t7/\u001a\u0005\b\u0003;|\u0001\u0019\u0001B\u0003!\u0011\t)Na\u0002\n\u0007\t%\u0001OA\nTKR$\u0016.\\3N_\u0012,GNU3rk\u0016\u001cHO\u0001\fTKR$\u0016.\\3N_\u0012,G\u000eU1sC6,G/\u001a:t'\u0019\u0001BJa\u0004\u0003\u0016A\u0019QJ!\u0005\n\u0007\tMaJA\u0004Qe>$Wo\u0019;\u0011\t\t]!\u0011\u0005\b\u0005\u00053\u0011iBD\u0002\\\u00057I\u0011aT\u0005\u0004\u0005?q\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005G\u0011)C\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0003 9\u000bAB\\3x)&lW-T8eK2,\"Aa\u000b\u0011\t\u0005=(QF\u0005\u0005\u0005_\t\tPA\bMK\u0012<WM\u001d+j[\u0016lu\u000eZ3m\u00035qWm\u001e+j[\u0016lu\u000eZ3mA\u0005\tR.\u0019=j[Vl'+Z2pe\u0012$\u0016.\\3\u0016\u0005\t]\u0002\u0003\u0002B\u001d\u0005\u007fqA!a\u0012\u0003<%!!QHA%\u0003\u0011!\u0016.\\3\n\t\t\u0005#1\t\u0002\n)&lWm\u001d;b[BTAA!\u0010\u0002J\u0005\u0011R.\u0019=j[Vl'+Z2pe\u0012$\u0016.\\3!\u0003)!\u0018.\\3U_2Kg/Z\u000b\u0003\u0005\u0017\u0002BA!\u0014\u0003T5\u0011!q\n\u0006\u0005\u0005#\n\u0019(\u0001\u0005ekJ\fG/[8o\u0013\u0011\u0011)Fa\u0014\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006YA/[7f)>d\u0015N^3!)!\u0011YFa\u0018\u0003b\t\r\u0004c\u0001B/!5\t\u0001\u0001C\u0004\u0003(]\u0001\rAa\u000b\t\u000f\tMr\u00031\u0001\u00038!9!qI\fA\u0002\t-\u0013\u0001B2paf$\u0002Ba\u0017\u0003j\t-$Q\u000e\u0005\n\u0005OA\u0002\u0013!a\u0001\u0005WA\u0011Ba\r\u0019!\u0003\u0005\rAa\u000e\t\u0013\t\u001d\u0003\u0004%AA\u0002\t-\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005gRCAa\u000b\u0003v-\u0012!q\u000f\t\u0005\u0005s\u0012\u0019)\u0004\u0002\u0003|)!!Q\u0010B@\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0002:\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ia\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t-%\u0006\u0002B\u001c\u0005k\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0012*\"!1\nB;\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\u0013\t\u0005\u00053\u0013\u0019+\u0004\u0002\u0003\u001c*!!Q\u0014BP\u0003\u0011a\u0017M\\4\u000b\u0005\t\u0005\u0016\u0001\u00026bm\u0006LA!a\u0010\u0003\u001c\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\u0016\t\u0004\u001b\n-\u0016b\u0001BW\u001d\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0017B]!\ri%QW\u0005\u0004\u0005os%aA!os\"I!1\u0018\u0010\u0002\u0002\u0003\u0007!\u0011V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0007C\u0002Bb\u0005\u0013\u0014\u0019,\u0004\u0002\u0003F*\u0019!q\u0019(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003L\n\u0015'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!5\u0003XB\u0019QJa5\n\u0007\tUgJA\u0004C_>dW-\u00198\t\u0013\tm\u0006%!AA\u0002\tM\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa&\u0003^\"I!1X\u0011\u0002\u0002\u0003\u0007!\u0011V\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!\u0011V\u0001\ti>\u001cFO]5oOR\u0011!qS\u0001\u0007KF,\u0018\r\\:\u0015\t\tE'1\u001e\u0005\n\u0005w#\u0013\u0011!a\u0001\u0005g\u000bacU3u)&lW-T8eK2\u0004\u0016M]1nKR,'o\u001d\t\u0004\u0005;23#\u0002\u0014\u0003t\n}\b\u0003\u0004B{\u0005w\u0014YCa\u000e\u0003L\tmSB\u0001B|\u0015\r\u0011IPT\u0001\beVtG/[7f\u0013\u0011\u0011iPa>\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0004\u0002\r\u0015QBAB\u0002\u0015\u0011\t\u0019Ma(\n\t\t\r21\u0001\u000b\u0003\u0005_\fQ!\u00199qYf$\u0002Ba\u0017\u0004\u000e\r=1\u0011\u0003\u0005\b\u0005OI\u0003\u0019\u0001B\u0016\u0011\u001d\u0011\u0019$\u000ba\u0001\u0005oAqAa\u0012*\u0001\u0004\u0011Y%A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r]11\u0005\t\u0006\u001b\u000ee1QD\u0005\u0004\u00077q%AB(qi&|g\u000eE\u0005N\u0007?\u0011YCa\u000e\u0003L%\u00191\u0011\u0005(\u0003\rQ+\b\u000f\\34\u0011%\u0019)CKA\u0001\u0002\u0004\u0011Y&A\u0002yIA\n!C^1mS\u0012\fG/\u001a)be\u0006lW\r^3sgR!11FB%)\u0011\u0019ic!\u000f\u0011\u0011\t]1qFB\u001a\u00057JAa!\r\u0003&\t1Q)\u001b;iKJ\u0004B!!0\u00046%!1qGA`\u0005Y\u0019F/\u0019;vgJ+h\u000e^5nK\u0016C8-\u001a9uS>t\u0007bBB\u001eW\u0001\u000f1QH\u0001\u001aG>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'\u000f\u0005\u0003\u0004@\r\u0015SBAB!\u0015\r\u0019\u0019eR\u0001\u0006KJ\u0014xN]\u0005\u0005\u0007\u000f\u001a\tEA\rD_:$X\r\u001f;vC2L'0\u001a3FeJ|'\u000fT8hO\u0016\u0014\bbBAoW\u0001\u0007!QA\u0001\u001b\u0003BL7i\u001c8gS\u001el\u0015M\\1hK6,g\u000e^*feZL7-\u001a\t\u0004\u0003#k3CA\u0017M)\t\u0019i%\u0001\tde\u0016\fG/Z!qSN+'O^5dKRQ1qKB5\u0007[\u001a\tha\u001d\u0015\u0011\re31MB3\u0007O\u0012Raa\u0017\u0004`Q4aa!\u0018.\u0001\re#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004cAB1c:\u0019\u0011Q\u001b8\t\u000f\u0005ms\u0006q\u0001\u0002^!9\u0011QN\u0018A\u0004\u0005=\u0004bBA>_\u0001\u000f\u0011Q\u0010\u0005\u0007\u0007Wz\u0003\u0019\u0001?\u0002\u0017I,\u0017\r\u001a\"bG.,g\u000e\u001a\u0005\b\u0007_z\u0003\u0019AA\t\u000319(/\u001b;f\u0005\u0006\u001c7.\u001a8e\u0011\u001d\tYb\fa\u0001\u0003;A\u0011\"a\u000b0!\u0003\u0005\r!!\f\u00025\r\u0014X-\u0019;f\u0003BL7+\u001a:wS\u000e,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\re$\u0006BA\u0017\u0005k\u00121dU=oG\"\u0014xN\\8vgJ+7\u000f]8og\u0016\u001cFO]1uK\u001eL8\u0003B\u0019M\u0007\u007f\u0002\"b!!\u0004\b\u000e551SBQ\u001d\u0011\t\tja!\n\u0007\r\u0015u(A\nTs:\u001c\u0007N]8o_V\u001c(+Z:q_:\u001cX-\u0003\u0003\u0004\n\u000e-%\u0001C*ue\u0006$XmZ=\u000b\u0007\r\u0015u\bE\u0004N\u0007\u001f\u00139$!<\n\u0007\rEeJ\u0001\u0004UkBdWM\r\t\u0005\u0007+\u001bYJD\u0002X\u0007/K1a!'i\u0003\u0019!w.\\1j]&!1QTBP\u0005I\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0016sGO]=\u000b\u0007\re\u0005\u000e\u0005\u0003\u0004$\u000e%f\u0002BBK\u0007KKAaa*\u0004 \u0006\u00112i\u001c8gS\u001e,(/\u0019;j_:,e\u000e\u001e:z\u0013\u0011\u0019Yk!,\u0003\u0011\u0005\u001b7-\u001a9uK\u0012TAaa*\u0004 \u0006\u0011rO]5uK\u000e{gNZ5h'\u0016\u0014h/[2f\u0003]\u0019wN\u001c4jO6\u000bg.Y4f[\u0016tGoU3sm&\u001cW-A\u0005mK\u0012<WM]#oIB!1qWB_\u001d\u0011\u0019)j!/\n\t\rm6qT\u0001\r\u0019\u0016$w-\u001a:PM\u001a\u001cX\r^\u0005\u0005\u0007\u007f\u001b\tM\u0001\u0005BEN|G.\u001e;f\u0015\u0011\u0019Yla(\u0015\u0011\r\u00157QZBh\u0007#$Baa2\u0004LB\u00191\u0011Z\u0019\u000e\u00035Bq!a\u001f7\u0001\b\ti\bC\u0004\u00040Z\u0002\r!!\u0005\t\r\rEf\u00071\u0001}\u0011\u001d\u0019\u0019L\u000ea\u0001\u0007k\u000b\u0001cY;se\u0016tG\u000fT3eO\u0016\u0014XI\u001c3\u0015\u0005\r]\u0007CBA9\u0003\u001f\u001cI\u000eE\u0003N\u00073\u0019),\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0007\u0007?\u001cYpa@\u0015\r\r\u00058\u0011^B}!\u0019\t\t(a4\u0004dB!\u00111CBs\u0013\u0011\u00199/!\u0006\u0003!M+(-\\5tg&|gNU3tk2$\bbBBvu\u0001\u000f1Q^\u0001\u0011i\u0016dW-\\3uef\u001cuN\u001c;fqR\u0004Baa<\u0004v6\u00111\u0011\u001f\u0006\u0004\u0007g<\u0015!\u0003;fY\u0016lW\r\u001e:z\u0013\u0011\u00199p!=\u0003!Q+G.Z7fiJL8i\u001c8uKb$\bbBA>u\u0001\u000f\u0011Q\u0010\u0005\b\u0007{T\u0004\u0019AA\"\u00031\u0019XOY7jgNLwN\\%e\u0011\u001d!\tA\u000fa\u0001\u0007\u001b\u000bQ!\u001b8qkR\fq!\u001a8ue&,7\u000f\u0006\u0003\u0005\b\u0011\u0015\u0002\u0007\u0002C\u0005\t3\u0001\u0002\u0002b\u0003\u0005\u0012\rMEQC\u0007\u0003\t\u001bQA\u0001b\u0004\u0002b\u0005A1oY1mC\u0012\u001cH.\u0003\u0003\u0005\u0014\u00115!AB*pkJ\u001cW\r\u0005\u0003\u0005\u0018\u0011eA\u0002\u0001\u0003\f\t7Y\u0014\u0011!A\u0001\u0006\u0003!iBA\u0002`IE\nB\u0001b\b\u00034B\u0019Q\n\"\t\n\u0007\u0011\rbJA\u0004O_RD\u0017N\\4\t\u000f\u0011\u001d2\b1\u0001\u0004Z\u00061qN\u001a4tKR\fa!Y2dKB$H\u0003\u0002C\u0017\tg\u0001r!\u0014C\u0018\u0007'\u001b\t+C\u0002\u000529\u0013q\u0002U1si&\fGNR;oGRLwN\u001c\u0005\b\u0007{d\u0004\u0019AA\"\u0003\u0019\u0011XM[3diR!A\u0011\bC\u001e!\u001diEqFBJ\u0007gAqa!@>\u0001\u0004\t\u0019\u0005")
public final class ApiConfigManagementService
implements ConfigManagementServiceGrpc.ConfigManagementService,
GrpcApiService {
    private volatile ApiConfigManagementService$SetTimeModelParameters$ SetTimeModelParameters$module;
    private final IndexConfigManagementService index;
    private final WriteConfigService writeService;
    private final TimeProvider timeProvider;
    private final Function1<String, String> submissionIdGenerator;
    private final Materializer materializer;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;

    public static Function1<String, String> createApiService$default$4() {
        return ApiConfigManagementService$.MODULE$.createApiService$default$4();
    }

    public static ConfigManagementServiceGrpc.ConfigManagementService createApiService(IndexConfigManagementService readBackend, WriteConfigService writeBackend, TimeProvider timeProvider, Function1<String, String> submissionIdGenerator, Materializer materializer, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ApiConfigManagementService$.MODULE$.createApiService(readBackend, writeBackend, timeProvider, submissionIdGenerator, materializer, executionContext, loggingContext);
    }

    public ConfigManagementServiceGrpc$ConfigManagementService$ serviceCompanion() {
        return ConfigManagementServiceGrpc.ConfigManagementService.serviceCompanion$((ConfigManagementServiceGrpc.ConfigManagementService)this);
    }

    private ApiConfigManagementService$SetTimeModelParameters$ SetTimeModelParameters() {
        if (this.SetTimeModelParameters$module == null) {
            this.SetTimeModelParameters$lzycompute$1();
        }
        return this.SetTimeModelParameters$module;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public void close() {
    }

    public ServerServiceDefinition bindService() {
        return ConfigManagementServiceGrpc$.MODULE$.bindService((ConfigManagementServiceGrpc.ConfigManagementService)this, this.executionContext);
    }

    public Future<GetTimeModelResponse> getTimeModel(GetTimeModelRequest request) {
        this.logger().info().apply((Function0 & Serializable)() -> "Getting time model", this.loggingContext);
        return this.index.lookupConfiguration(this.loggingContext).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Configuration configuration = (Configuration)tuple2._2();
                future = Future$.MODULE$.successful((Object)this.configurationToResponse(configuration));
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RequestValidation.NotFound$.LedgerConfiguration$.Reject((ContextualizedErrorLogger)new DamlContextualizedErrorLogger(this.logger(), $this.loggingContext, (Option)None$.MODULE$)).asGrpcError());
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.executionContext).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    private GetTimeModelResponse configurationToResponse(Configuration configuration) {
        LedgerTimeModel timeModel = configuration.timeModel();
        return new GetTimeModelResponse(configuration.generation(), (Option)new Some((Object)new TimeModel((Option)new Some((Object)DurationConversion$.MODULE$.toProto(timeModel.avgTransactionLatency())), (Option)new Some((Object)DurationConversion$.MODULE$.toProto(timeModel.minSkew())), (Option)new Some((Object)DurationConversion$.MODULE$.toProto(timeModel.maxSkew())))));
    }

    public Future<SetTimeModelResponse> setTimeModel(SetTimeModelRequest request) {
        return (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(com.daml.platform.apiserver.services.logging.package$.MODULE$.submissionId(request.submissionId()), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Setting time model", loggingContext);
            TelemetryContext telemetryContext = DefaultTelemetry$.MODULE$.contextFromGrpcThreadLocalContext();
            DamlContextualizedErrorLogger contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)new Some((Object)request.submissionId()));
            Future response = ((Future)this.validateParameters(request, (ContextualizedErrorLogger)contextualizedErrorLogger).fold((Function1 & Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure((Object)request, (Throwable)t, this.logger(), loggingContext)), (Function1 & Serializable)result -> Future$.MODULE$.successful(result))).flatMap(arg_0 -> ApiConfigManagementService.$anonfun$setTimeModel$5(this, loggingContext, (ContextualizedErrorLogger)contextualizedErrorLogger, request, telemetryContext, arg_0), $this.executionContext);
            return response.andThen(this.logger().logErrorsOnCall(loggingContext), $this.executionContext);
        }, this.loggingContext);
    }

    private Either<StatusRuntimeException, SetTimeModelParameters> validateParameters(SetTimeModelRequest request, ContextualizedErrorLogger contextualizedErrorLogger) {
        return FieldValidations$.MODULE$.requirePresence(request.newTimeModel(), "new_time_model", contextualizedErrorLogger).flatMap((Function1 & Serializable)pTimeModel -> FieldValidations$.MODULE$.requirePresence(pTimeModel.avgTransactionLatency(), "avg_transaction_latency", contextualizedErrorLogger).flatMap((Function1 & Serializable)pAvgTransactionLatency -> FieldValidations$.MODULE$.requirePresence(pTimeModel.minSkew(), "min_skew", contextualizedErrorLogger).flatMap((Function1 & Serializable)pMinSkew -> FieldValidations$.MODULE$.requirePresence(pTimeModel.maxSkew(), "max_skew", contextualizedErrorLogger).flatMap((Function1 & Serializable)pMaxSkew -> {
            Left left;
            Try try_ = LedgerTimeModel$.MODULE$.apply(DurationConversion$.MODULE$.fromProto(pAvgTransactionLatency), DurationConversion$.MODULE$.fromProto(pMinSkew), DurationConversion$.MODULE$.fromProto(pMaxSkew));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                left = package$.MODULE$.Left().apply((Object)ValidationErrors$.MODULE$.invalidArgument(err.toString(), contextualizedErrorLogger));
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                LedgerTimeModel ok = (LedgerTimeModel)success.value();
                left = package$.MODULE$.Right().apply((Object)ok);
            } else {
                throw new MatchError((Object)try_);
            }
            return left.flatMap((Function1 & Serializable)newTimeModel -> FieldValidations$.MODULE$.requirePresence(request.maximumRecordTime(), "maximum_record_time", contextualizedErrorLogger).map((Function1 & Serializable)pMaxRecordTime -> {
                Instant mrtInstant = TimestampConversion$.MODULE$.toInstant(pMaxRecordTime);
                Duration ttl = Duration.between($this.timeProvider.getCurrentTime(), mrtInstant);
                FiniteDuration timeToLive = ttl.isNegative() ? Duration$.MODULE$.Zero() : Duration$.MODULE$.fromNanos(ttl.toNanos());
                return new Tuple3(pMaxRecordTime, (Object)mrtInstant, (Object)timeToLive);
            }).flatMap((Function1 & Serializable)x$7 -> {
                Tuple3 tuple3 = x$7;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Instant mrtInstant = (Instant)tuple3._2();
                FiniteDuration timeToLive = (FiniteDuration)tuple3._3();
                Either either = ((Either)Time.Timestamp$.MODULE$.fromInstant(mrtInstant).fold((Function1 & Serializable)err -> package$.MODULE$.Left().apply((Object)ValidationErrors$.MODULE$.invalidArgument(err, contextualizedErrorLogger)), (Function1 & Serializable)x$6 -> package$.MODULE$.Right().apply(x$6))).map((Function1 & Serializable)maximumRecordTime -> new SetTimeModelParameters(this, (LedgerTimeModel)newTimeModel, (Time.Timestamp)maximumRecordTime, timeToLive));
                return either;
            }));
        }))));
    }

    private final void SetTimeModelParameters$lzycompute$1() {
        ApiConfigManagementService apiConfigManagementService = this;
        synchronized (apiConfigManagementService) {
            if (this.SetTimeModelParameters$module == null) {
                this.SetTimeModelParameters$module = new ApiConfigManagementService$SetTimeModelParameters$(this);
            }
        }
    }

    public static final /* synthetic */ Future $anonfun$setTimeModel$5(ApiConfigManagementService $this, LoggingContext loggingContext$1, ContextualizedErrorLogger contextualizedErrorLogger$1, SetTimeModelRequest request$1, TelemetryContext telemetryContext$1, SetTimeModelParameters params) {
        return $this.index.lookupConfiguration(loggingContext$1).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Tuple2 result = (Tuple2)some.value();
                future = Future$.MODULE$.successful((Object)result);
            } else if (None$.MODULE$.equals(option)) {
                $this.logger().warn().apply((Function0 & Serializable)() -> "Could not get the current time model. The index does not yet have any ledger configuration.", loggingContext$1);
                future = Future$.MODULE$.failed((Throwable)new RequestValidation.NotFound$.LedgerConfiguration$.Reject(contextualizedErrorLogger$1).asGrpcError());
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, $this.executionContext).map((Function1 & Serializable)configuration -> {
            Tuple2 tuple2 = configuration;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            domain.LedgerOffset.Absolute ledgerEndBeforeRequest = (domain.LedgerOffset.Absolute)tuple2._1();
            Configuration currentConfig = (Configuration)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)ledgerEndBeforeRequest, (Object)currentConfig);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$1 = (Tuple2)tuple32._1();
            domain.LedgerOffset.Absolute ledgerEndBeforeRequest2 = (domain.LedgerOffset.Absolute)tuple32._2();
            Configuration currentConfig2 = (Configuration)tuple32._3();
            long expectedGeneration = currentConfig2.generation();
            return new Tuple3(configuration, (Object)x$1, (Object)BoxesRunTime.boxToLong((long)expectedGeneration));
        }, $this.executionContext).flatMap((Function1 & Serializable)x$5 -> {
            long expectedGeneration;
            Tuple2 tuple2;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$5;
                    if (tuple3 == null) break block2;
                    tuple2 = (Tuple2)tuple3._2();
                    expectedGeneration = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            domain.LedgerOffset.Absolute ledgerEndBeforeRequest = (domain.LedgerOffset.Absolute)tuple2._1();
            Configuration currentConfig = (Configuration)tuple2._2();
            Future future = (request$1.configurationGeneration() != expectedGeneration ? Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure((Object)request$1, (Throwable)ValidationErrors$.MODULE$.invalidArgument(new StringBuilder(58).append("Mismatching configuration generation, expected ").append(expectedGeneration).append(", received ").append(request$1.configurationGeneration()).toString(), contextualizedErrorLogger$1), $this.logger(), loggingContext$1)) : Future$.MODULE$.unit()).map((Function1 & Serializable)x$3 -> {
                Configuration newConfig = currentConfig.copy(currentConfig.generation() + 1L, params.newTimeModel(), currentConfig.copy$default$3());
                String augmentedSubmissionId = (String)$this.submissionIdGenerator.apply((Object)request$1.submissionId());
                SynchronousResponse<Tuple2<Time.Timestamp, Configuration>, domain.ConfigurationEntry, domain.ConfigurationEntry$.Accepted> synchronousResponse = new SynchronousResponse<Tuple2<Time.Timestamp, Configuration>, domain.ConfigurationEntry, domain.ConfigurationEntry$.Accepted>(new SynchronousResponseStrategy($this.writeService, $this.index, ledgerEndBeforeRequest, loggingContext$1), params.timeToLive(), $this.executionContext, $this.materializer);
                return new Tuple4(x$3, (Object)newConfig, (Object)augmentedSubmissionId, synchronousResponse);
            }, $this.executionContext).flatMap((Function1 & Serializable)x$4 -> {
                Tuple4 tuple4 = x$4;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Configuration newConfig = (Configuration)tuple4._2();
                String augmentedSubmissionId = (String)tuple4._3();
                SynchronousResponse synchronousResponse = (SynchronousResponse)tuple4._4();
                Future future = synchronousResponse.submitAndWait(augmentedSubmissionId, new Tuple2((Object)params.maximumRecordTime(), (Object)newConfig), telemetryContext$1, loggingContext$1).map((Function1 & Serializable)entry -> new SetTimeModelResponse(entry.configuration().generation()), $this.executionContext);
                return future;
            }, $this.executionContext);
            return future;
        }, $this.executionContext);
    }

    public ApiConfigManagementService(IndexConfigManagementService index, WriteConfigService writeService, TimeProvider timeProvider, Function1<String, String> submissionIdGenerator, Materializer materializer, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.index = index;
        this.writeService = writeService;
        this.timeProvider = timeProvider;
        this.submissionIdGenerator = submissionIdGenerator;
        this.materializer = materializer;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        ConfigManagementServiceGrpc.ConfigManagementService.$init$((ConfigManagementServiceGrpc.ConfigManagementService)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }

    private class SetTimeModelParameters
    implements Product,
    Serializable {
        private final LedgerTimeModel newTimeModel;
        private final Time.Timestamp maximumRecordTime;
        private final FiniteDuration timeToLive;
        public final /* synthetic */ ApiConfigManagementService $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public LedgerTimeModel newTimeModel() {
            return this.newTimeModel;
        }

        public Time.Timestamp maximumRecordTime() {
            return this.maximumRecordTime;
        }

        public FiniteDuration timeToLive() {
            return this.timeToLive;
        }

        public SetTimeModelParameters copy(LedgerTimeModel newTimeModel, Time.Timestamp maximumRecordTime, FiniteDuration timeToLive) {
            return new SetTimeModelParameters(this.com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SetTimeModelParameters$$$outer(), newTimeModel, maximumRecordTime, timeToLive);
        }

        public LedgerTimeModel copy$default$1() {
            return this.newTimeModel();
        }

        public Time.Timestamp copy$default$2() {
            return this.maximumRecordTime();
        }

        public FiniteDuration copy$default$3() {
            return this.timeToLive();
        }

        public String productPrefix() {
            return "SetTimeModelParameters";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.newTimeModel();
                    break;
                }
                case 1: {
                    object = this.maximumRecordTime();
                    break;
                }
                case 2: {
                    object = this.timeToLive();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SetTimeModelParameters;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "newTimeModel";
                    break;
                }
                case 1: {
                    string = "maximumRecordTime";
                    break;
                }
                case 2: {
                    string = "timeToLive";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SetTimeModelParameters)) return false;
            if (((SetTimeModelParameters)object).com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SetTimeModelParameters$$$outer() != this.com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SetTimeModelParameters$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            SetTimeModelParameters setTimeModelParameters = (SetTimeModelParameters)x$1;
            LedgerTimeModel ledgerTimeModel = this.newTimeModel();
            LedgerTimeModel ledgerTimeModel2 = setTimeModelParameters.newTimeModel();
            if (ledgerTimeModel == null) {
                if (ledgerTimeModel2 != null) {
                    return false;
                }
            } else if (!ledgerTimeModel.equals(ledgerTimeModel2)) return false;
            Time.Timestamp timestamp = this.maximumRecordTime();
            Time.Timestamp timestamp2 = setTimeModelParameters.maximumRecordTime();
            if (timestamp == null) {
                if (timestamp2 != null) {
                    return false;
                }
            } else if (!timestamp.equals(timestamp2)) return false;
            FiniteDuration finiteDuration = this.timeToLive();
            FiniteDuration finiteDuration2 = setTimeModelParameters.timeToLive();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            if (!setTimeModelParameters.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ApiConfigManagementService com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SetTimeModelParameters$$$outer() {
            return this.$outer;
        }

        public SetTimeModelParameters(ApiConfigManagementService $outer, LedgerTimeModel newTimeModel, Time.Timestamp maximumRecordTime, FiniteDuration timeToLive) {
            this.newTimeModel = newTimeModel;
            this.maximumRecordTime = maximumRecordTime;
            this.timeToLive = timeToLive;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private static final class SynchronousResponseStrategy
    implements SynchronousResponse.Strategy<Tuple2<Time.Timestamp, Configuration>, domain.ConfigurationEntry, domain.ConfigurationEntry$.Accepted> {
        private final WriteConfigService writeConfigService;
        private final IndexConfigManagementService configManagementService;
        private final domain.LedgerOffset.Absolute ledgerEnd;
        public final LoggingContext com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$loggingContext;
        private final ContextualizedLogger com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$logger;

        public ContextualizedLogger com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$logger() {
            return this.com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$logger;
        }

        @Override
        public Future<Option<domain.LedgerOffset.Absolute>> currentLedgerEnd() {
            return Future$.MODULE$.successful((Object)new Some((Object)this.ledgerEnd));
        }

        @Override
        public Future<SubmissionResult> submit(String submissionId, Tuple2<Time.Timestamp, Configuration> input, TelemetryContext telemetryContext, LoggingContext loggingContext) {
            Tuple2<Time.Timestamp, Configuration> tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Time.Timestamp maximumRecordTime = (Time.Timestamp)tuple2._1();
            Configuration newConfiguration = (Configuration)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maximumRecordTime, (Object)newConfiguration);
            Tuple2 tuple23 = tuple22;
            Time.Timestamp maximumRecordTime2 = (Time.Timestamp)tuple23._1();
            Configuration newConfiguration2 = (Configuration)tuple23._2();
            return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(this.writeConfigService.submitConfiguration(maximumRecordTime2, submissionId, newConfiguration2, loggingContext, telemetryContext)));
        }

        @Override
        public Source<domain.ConfigurationEntry, ?> entries(Option<domain.LedgerOffset.Absolute> offset) {
            return (Source)this.configManagementService.configurationEntries(offset, this.com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$loggingContext).map((Function1 & Serializable)x$9 -> (domain.ConfigurationEntry)x$9._2());
        }

        @Override
        public PartialFunction<domain.ConfigurationEntry, domain.ConfigurationEntry$.Accepted> accept(String submissionId) {
            return new Serializable(null, submissionId){
                private static final long serialVersionUID = 0L;
                private final String submissionId$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends domain.ConfigurationEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof domain.ConfigurationEntry$.Accepted) {
                        domain.ConfigurationEntry$.Accepted accepted = (domain.ConfigurationEntry$.Accepted)A1;
                        String string = accepted.submissionId();
                        String string2 = this.submissionId$1;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            object = accepted;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(domain.ConfigurationEntry x1) {
                    domain.ConfigurationEntry configurationEntry = x1;
                    if (!(configurationEntry instanceof domain.ConfigurationEntry$.Accepted)) return false;
                    domain.ConfigurationEntry$.Accepted accepted = (domain.ConfigurationEntry$.Accepted)configurationEntry;
                    String string = accepted.submissionId();
                    String string2 = this.submissionId$1;
                    String string3 = string;
                    if (string2 != null) {
                        if (!string2.equals(string3)) return false;
                        return true;
                    }
                    if (string3 == null) return true;
                    return false;
                }
                {
                    this.submissionId$1 = submissionId$1;
                }
            };
        }

        @Override
        public PartialFunction<domain.ConfigurationEntry, StatusRuntimeException> reject(String submissionId) {
            return new Serializable(this, submissionId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ SynchronousResponseStrategy $outer;
                private final String submissionId$2;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends domain.ConfigurationEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var3_10;
                    A1 A1 = x1;
                    if (A1 instanceof domain.ConfigurationEntry$.Rejected) {
                        domain.ConfigurationEntry$.Rejected rejected = (domain.ConfigurationEntry$.Rejected)A1;
                        String string = rejected.submissionId();
                        String reason = rejected.rejectionReason();
                        String string2 = this.submissionId$2;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            StatusRuntimeException statusRuntimeException = new AdminServices.ConfigurationEntryRejected$.Reject(reason, (ContextualizedErrorLogger)new DamlContextualizedErrorLogger(this.$outer.com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$logger(), this.$outer.com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$loggingContext, (Option)new Some((Object)this.submissionId$2))).asGrpcError();
                            return var3_10;
                        }
                    }
                    Object object = function1.apply(x1);
                    return var3_10;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(domain.ConfigurationEntry x1) {
                    domain.ConfigurationEntry configurationEntry = x1;
                    if (!(configurationEntry instanceof domain.ConfigurationEntry$.Rejected)) return false;
                    domain.ConfigurationEntry$.Rejected rejected = (domain.ConfigurationEntry$.Rejected)configurationEntry;
                    String string = rejected.submissionId();
                    String string2 = this.submissionId$2;
                    String string3 = string;
                    if (string2 != null) {
                        if (!string2.equals(string3)) return false;
                        return true;
                    }
                    if (string3 == null) return true;
                    return false;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.submissionId$2 = submissionId$2;
                }
            };
        }

        public SynchronousResponseStrategy(WriteConfigService writeConfigService, IndexConfigManagementService configManagementService, domain.LedgerOffset.Absolute ledgerEnd, LoggingContext loggingContext) {
            this.writeConfigService = writeConfigService;
            this.configManagementService = configManagementService;
            this.ledgerEnd = ledgerEnd;
            this.com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$loggingContext = loggingContext;
            this.com$daml$platform$apiserver$services$admin$ApiConfigManagementService$SynchronousResponseStrategy$$logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        }
    }
}

