/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.admin;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.error.definitions.groups.UserManagementServiceErrors;
import com.daml.ledger.api.SubmissionIdGenerator;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.v1.admin.user_management_service.CreateUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.CreateUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.DeleteUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserRequest;
import com.daml.ledger.api.v1.admin.user_management_service.GetUserResponse;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.GrantUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.ListUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersRequest;
import com.daml.ledger.api.v1.admin.user_management_service.ListUsersResponse;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsRequest;
import com.daml.ledger.api.v1.admin.user_management_service.RevokeUserRightsResponse;
import com.daml.ledger.api.v1.admin.user_management_service.Right;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc$;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc$UserManagementService$;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.logging.entries.LoggingValue$;
import com.daml.logging.entries.ToLoggingValue$;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.services.admin.ApiUserManagementService$;
import com.daml.platform.server.api.validation.FieldValidations$;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalaz.Applicative;
import scalaz.std.either$;
import scalaz.std.list$;

@ScalaSignature(bytes="\u0006\u0005\r-a!B\u0012%\u0005!\u0002\u0004\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0006S\"Aq\u000e\u0001B\u0001B\u0003-\u0001\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0005\u0002\u0002\u0001\u0011\r\u0011b\u0003\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011b\u0003\u0002\u0010!A\u0011Q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u00111\b\u0001\u0005B\u0005u\u0002bBA,\u0001\u0011\u0005\u0013\u0011\f\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!a%\u0001\t\u0003\n)\nC\u0004\u0002(\u0002!\t%!+\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\"9\u0011q\u001a\u0001\u0005\n\u0005E\u0007b\u0002B\u000e\u0001\u0011%!Q\u0004\u0005\n\u0005/\u0002!\u0019!C\u0005\u00053B\u0001Ba!\u0001A\u0003%!1\f\u0005\b\u0005\u000b\u0003A\u0011\u0002BD\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;;qA!,%\u0011\u0003\u0011yK\u0002\u0004$I!\u0005!\u0011\u0017\u0005\u0007mn!\tAa-\t\u000f\tU6\u0004\"\u0003\u00038\"I!qY\u000eC\u0002\u0013%!\u0011\u001a\u0005\t\u0005\u001b\\\u0002\u0015!\u0003\u0003L\"9!qZ\u000e\u0005\u0002\tE\u0007b\u0002B{7\u0011\u0005!q\u001f\u0005\b\u0007\u0007YB\u0011BB\u0003\u0005a\t\u0005/[+tKJl\u0015M\\1hK6,g\u000e^*feZL7-\u001a\u0006\u0003K\u0019\nQ!\u00193nS:T!a\n\u0015\u0002\u0011M,'O^5dKNT!!\u000b\u0016\u0002\u0013\u0005\u0004\u0018n]3sm\u0016\u0014(BA\u0016-\u0003!\u0001H.\u0019;g_Jl'BA\u0017/\u0003\u0011!\u0017-\u001c7\u000b\u0003=\n1aY8n'\u0011\u0001\u0011g\u000e&\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tAtI\u0004\u0002:\t:\u0011!HQ\u0007\u0002w)\u0011Q\u0005\u0010\u0006\u0003{y\n!A^\u0019\u000b\u0005}\u0002\u0015aA1qS*\u0011\u0011\tL\u0001\u0007Y\u0016$w-\u001a:\n\u0005\r[\u0014aF;tKJ|V.\u00198bO\u0016lWM\u001c;`g\u0016\u0014h/[2f\u0013\t)e)A\rVg\u0016\u0014X*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3HeB\u001c'BA\"<\u0013\tA\u0015JA\u000bVg\u0016\u0014X*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3\u000b\u0005\u00153\u0005CA&P\u001b\u0005a%BA'O\u0003\u00119'\u000f]2\u000b\u0005}R\u0013B\u0001)M\u000599%\u000f]2Ba&\u001cVM\u001d<jG\u0016\f1#^:fe6\u000bg.Y4f[\u0016tGo\u0015;pe\u0016\u001c\u0001\u0001\u0005\u0002U;6\tQK\u0003\u0002W/\u0006\u0011aO\r\u0006\u00031f\u000bQ!\u001b8eKbT!AW.\u0002\u000bM$\u0018\r^3\u000b\u0005q\u0003\u0015a\u00039beRL7-\u001b9b]RL!AX+\u0003'U\u001bXM]'b]\u0006<W-\\3oiN#xN]3\u0002!5\f\u00070V:feN\u0004\u0016mZ3TSj,\u0007C\u0001\u001ab\u0013\t\u00117GA\u0002J]R\fQc];c[&\u001c8/[8o\u0013\u0012<UM\\3sCR|'\u000f\u0005\u0002fM6\ta(\u0003\u0002h}\t)2+\u001e2nSN\u001c\u0018n\u001c8JI\u001e+g.\u001a:bi>\u0014\u0018\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\tQW.D\u0001l\u0015\ta7'\u0001\u0006d_:\u001cWO\u001d:f]RL!A\\6\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018A\u00047pO\u001eLgnZ\"p]R,\u0007\u0010\u001e\t\u0003cRl\u0011A\u001d\u0006\u0003g2\nq\u0001\\8hO&tw-\u0003\u0002ve\nqAj\\4hS:<7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0003y{z|HcA=|yB\u0011!\u0010A\u0007\u0002I!)\u0001N\u0002a\u0002S\")qN\u0002a\u0002a\")\u0011K\u0002a\u0001'\")qL\u0002a\u0001A\")1M\u0002a\u0001I\u00061An\\4hKJ,\"!!\u0002\u0011\u0007E\f9!C\u0002\u0002\nI\u0014AcQ8oi\u0016DH/^1mSj,G\rT8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u001aG>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'/\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u00181\nQ!\u001a:s_JLA!a\u0007\u0002\u0016\tI2i\u001c8uKb$X/\u00197ju\u0016$WI\u001d:pe2{wmZ3s\u0003i\u0019wN\u001c;fqR,\u0018\r\\5{K\u0012,%O]8s\u0019><w-\u001a:!\u0003\u0015\u0019Gn\\:f)\t\t\u0019\u0003E\u00023\u0003KI1!a\n4\u0005\u0011)f.\u001b;\u0002\u0017\tLg\u000eZ*feZL7-\u001a\u000b\u0003\u0003[\u0001B!a\f\u000285\u0011\u0011\u0011\u0007\u0006\u0004\u001b\u0006M\"BAA\u001b\u0003\tIw.\u0003\u0003\u0002:\u0005E\"aF*feZ,'oU3sm&\u001cW\rR3gS:LG/[8o\u0003)\u0019'/Z1uKV\u001bXM\u001d\u000b\u0005\u0003\u007f\ti\u0005E\u0003k\u0003\u0003\n)%C\u0002\u0002D-\u0014aAR;ukJ,\u0007\u0003BA$\u0003\u0013j\u0011AR\u0005\u0004\u0003\u00172%AE\"sK\u0006$X-V:feJ+7\u000f]8og\u0016Dq!a\u0014\u000e\u0001\u0004\t\t&A\u0004sKF,Xm\u001d;\u0011\t\u0005\u001d\u00131K\u0005\u0004\u0003+2%!E\"sK\u0006$X-V:feJ+\u0017/^3ti\u00069q-\u001a;Vg\u0016\u0014H\u0003BA.\u0003G\u0002RA[A!\u0003;\u0002B!a\u0012\u0002`%\u0019\u0011\u0011\r$\u0003\u001f\u001d+G/V:feJ+7\u000f]8og\u0016Dq!a\u0014\u000f\u0001\u0004\t)\u0007\u0005\u0003\u0002H\u0005\u001d\u0014bAA5\r\nqq)\u001a;Vg\u0016\u0014(+Z9vKN$\u0018A\u00033fY\u0016$X-V:feR!\u0011qNA<!\u0015Q\u0017\u0011IA9!\u0011\t9%a\u001d\n\u0007\u0005UdI\u0001\nEK2,G/Z+tKJ\u0014Vm\u001d9p]N,\u0007bBA(\u001f\u0001\u0007\u0011\u0011\u0010\t\u0005\u0003\u000f\nY(C\u0002\u0002~\u0019\u0013\u0011\u0003R3mKR,Wk]3s%\u0016\fX/Z:u\u0003%a\u0017n\u001d;Vg\u0016\u00148\u000f\u0006\u0003\u0002\u0004\u0006-\u0005#\u00026\u0002B\u0005\u0015\u0005\u0003BA$\u0003\u000fK1!!#G\u0005Ea\u0015n\u001d;Vg\u0016\u00148OU3ta>t7/\u001a\u0005\b\u0003\u001f\u0002\u0002\u0019AAG!\u0011\t9%a$\n\u0007\u0005EeI\u0001\tMSN$Xk]3sgJ+\u0017/^3ti\u0006yqM]1oiV\u001bXM\u001d*jO\"$8\u000f\u0006\u0003\u0002\u0018\u0006}\u0005#\u00026\u0002B\u0005e\u0005\u0003BA$\u00037K1!!(G\u0005]9%/\u00198u+N,'OU5hQR\u001c(+Z:q_:\u001cX\rC\u0004\u0002PE\u0001\r!!)\u0011\t\u0005\u001d\u00131U\u0005\u0004\u0003K3%AF$sC:$Xk]3s%&<\u0007\u000e^:SKF,Xm\u001d;\u0002!I,go\\6f+N,'OU5hQR\u001cH\u0003BAV\u0003g\u0003RA[A!\u0003[\u0003B!a\u0012\u00020&\u0019\u0011\u0011\u0017$\u00031I+go\\6f+N,'OU5hQR\u001c(+Z:q_:\u001cX\rC\u0004\u0002PI\u0001\r!!.\u0011\t\u0005\u001d\u0013qW\u0005\u0004\u0003s3%a\u0006*fm>\\W-V:feJKw\r\u001b;t%\u0016\fX/Z:u\u00039a\u0017n\u001d;Vg\u0016\u0014(+[4iiN$B!a0\u0002HB)!.!\u0011\u0002BB!\u0011qIAb\u0013\r\t)M\u0012\u0002\u0017\u0019&\u001cH/V:feJKw\r\u001b;t%\u0016\u001c\bo\u001c8tK\"9\u0011qJ\nA\u0002\u0005%\u0007\u0003BA$\u0003\u0017L1!!4G\u0005Ua\u0015n\u001d;Vg\u0016\u0014(+[4iiN\u0014V-];fgR\fA\u0002[1oI2,'+Z:vYR,B!a5\u0002^R!\u0011Q\u001bB\u0001)\u0011\t9.a<\u0011\u000b)\f\t%!7\u0011\t\u0005m\u0017Q\u001c\u0007\u0001\t\u001d\ty\u000e\u0006b\u0001\u0003C\u0014\u0011\u0001V\t\u0005\u0003G\fI\u000fE\u00023\u0003KL1!a:4\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AMAv\u0013\r\tio\r\u0002\u0004\u0003:L\bbBAy)\u0001\u0007\u00111_\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\r\u0005U\u00181`Am\u001d\r!\u0016q_\u0005\u0004\u0003s,\u0016aE+tKJl\u0015M\\1hK6,g\u000e^*u_J,\u0017\u0002BA\u007f\u0003\u007f\u0014aAU3tk2$(bAA}+\"9!1\u0001\u000bA\u0002\t\u0015\u0011!C8qKJ\fG/[8o!\u0011\u00119A!\u0006\u000f\t\t%!\u0011\u0003\t\u0004\u0005\u0017\u0019TB\u0001B\u0007\u0015\r\u0011yAU\u0001\u0007yI|w\u000e\u001e \n\u0007\tM1'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005/\u0011IB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005'\u0019\u0014AD<ji\"4\u0016\r\\5eCRLwN\\\u000b\u0007\u0005?\u00119Da\n\u0015\t\t\u0005\"1\b\u000b\u0005\u0005G\u0011Y\u0003E\u0003k\u0003\u0003\u0012)\u0003\u0005\u0003\u0002\\\n\u001dBa\u0002B\u0015+\t\u0007\u0011\u0011\u001d\u0002\u0002\u0005\"9!QF\u000bA\u0002\t=\u0012!\u00014\u0011\u000fI\u0012\tD!\u000e\u0003$%\u0019!1G\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAn\u0005o!qA!\u000f\u0016\u0005\u0004\t\tOA\u0001B\u0011\u001d\u0011i$\u0006a\u0001\u0005\u007f\tqB^1mS\u0012\fG/\u001a3SKN,H\u000e\u001e\t\t\u0005\u0003\u0012YE!\u0015\u000369!!1\tB$\u001d\u0011\u0011YA!\u0012\n\u0003QJ1A!\u00134\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0014\u0003P\t1Q)\u001b;iKJT1A!\u00134!\u0011\tyCa\u0015\n\t\tU\u0013\u0011\u0007\u0002\u0017'R\fG/^:Sk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]\u0006qaM]8n!J|Go\u001c*jO\"$XC\u0001B.!\u001d\u0011$\u0011\u0007B/\u0005G\u0002B!a\u0012\u0003`%\u0019!\u0011\r$\u0003\u000bIKw\r\u001b;\u0011\u0011\t\u0005#1\nB)\u0005K\u0002BAa\u001a\u0003~9!!\u0011\u000eB=\u001d\u0011\u0011YGa\u001e\u000f\t\t5$Q\u000f\b\u0005\u0005_\u0012\u0019H\u0004\u0003\u0003\f\tE\u0014\"A\u0018\n\u00055r\u0013BA!-\u0013\ty\u0004)C\u0002\u0003|y\na\u0001Z8nC&t\u0017\u0002\u0002B@\u0005\u0003\u0013\u0011\"V:feJKw\r\u001b;\u000b\u0007\tmd(A\bge>l\u0007K]8u_JKw\r\u001b;!\u0003=1'o\\7Qe>$xNU5hQR\u001cH\u0003\u0002BE\u0005#\u0003\u0002B!\u0011\u0003L\tE#1\u0012\t\u0007\u0005\u000f\u0011iI!\u001a\n\t\t=%\u0011\u0004\u0002\u0004'\u0016$\bb\u0002BJ1\u0001\u0007!QS\u0001\u0007e&<\u0007\u000e^:\u0011\r\t\u0005#q\u0013B/\u0013\u0011\u0011IJa\u0014\u0003\u0007M+\u0017/\u0001\txSRD7+\u001e2nSN\u001c\u0018n\u001c8JIV!!q\u0014BS)\u0011\u0011\tK!+\u0015\t\t\r&q\u0015\t\u0005\u00037\u0014)\u000bB\u0004\u0003:e\u0011\r!!9\t\u000b=L\u00029\u00019\t\u000f\t5\u0012\u00041\u0001\u0003,B1!G!\rq\u0005G\u000b\u0001$\u00119j+N,'/T1oC\u001e,W.\u001a8u'\u0016\u0014h/[2f!\tQ8d\u0005\u0002\u001ccQ\u0011!qV\u0001\fi>\u0004&o\u001c;p+N,'\u000f\u0006\u0003\u0003:\n}\u0006\u0003BA$\u0005wK1A!0G\u0005\u0011)6/\u001a:\t\u000f\t\u0005W\u00041\u0001\u0003D\u0006!Qo]3s!\u0011\u00119G!2\n\t\tu&\u0011Q\u0001\ri>\u0004&o\u001c;p%&<\u0007\u000e^\u000b\u0003\u0005\u0017\u0004rA\rB\u0019\u0005K\u0012i&A\u0007u_B\u0013x\u000e^8SS\u001eDG\u000fI\u0001\u0014K:\u001cw\u000eZ3OKb$\b+Y4f)>\\WM\u001c\u000b\u0005\u0005\u000b\u0011\u0019\u000eC\u0004\u0003V\u0002\u0002\rAa6\u0002\u000bQ|7.\u001a8\u0011\u000bI\u0012IN!8\n\u0007\tm7G\u0001\u0004PaRLwN\u001c\t\u0005\u0005?\u0014yO\u0004\u0003\u0003b\n-XB\u0001Br\u0015\u0011\u0011)Oa:\u0002\t\u0011\fG/\u0019\u0006\u0004\u0005Sd\u0013A\u00017g\u0013\u0011\u0011iOa9\u0002\u0007I+g-\u0003\u0003\u0003r\nM(AB+tKJLEM\u0003\u0003\u0003n\n\r\u0018!\u00073fG>$W-V:fe&#gI]8n!\u0006<W\rV8lK:$BA!?\u0003\u0000R!!1 B\u007f!!\u0011\tEa\u0013\u0003R\t]\u0007BB8\"\u0001\b\t\t\u0002C\u0004\u0004\u0002\u0005\u0002\rA!\u0002\u0002\u0013A\fw-\u001a+pW\u0016t\u0017\u0001E5om\u0006d\u0017\u000e\u001a)bO\u0016$vn[3o)\u0011\u0011\tfa\u0002\t\u000f\r%!\u0005q\u0001\u0002\u0012\u0005YQM\u001d:pe2{wmZ3s\u0001")
public final class ApiUserManagementService
implements UserManagementServiceGrpc.UserManagementService,
GrpcApiService {
    private final UserManagementStore userManagementStore;
    private final int maxUsersPageSize;
    private final SubmissionIdGenerator submissionIdGenerator;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final ContextualizedErrorLogger contextualizedErrorLogger;
    private final Function1<com.daml.ledger.api.v1.admin.user_management_service.Right, Either<StatusRuntimeException, domain.UserRight>> fromProtoRight;

    public static Either<StatusRuntimeException, Option<String>> decodeUserIdFromPageToken(String pageToken, ContextualizedErrorLogger loggingContext) {
        return ApiUserManagementService$.MODULE$.decodeUserIdFromPageToken(pageToken, loggingContext);
    }

    public static String encodeNextPageToken(Option<String> token) {
        return ApiUserManagementService$.MODULE$.encodeNextPageToken(token);
    }

    public UserManagementServiceGrpc$UserManagementService$ serviceCompanion() {
        return UserManagementServiceGrpc.UserManagementService.serviceCompanion$((UserManagementServiceGrpc.UserManagementService)this);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private ContextualizedErrorLogger contextualizedErrorLogger() {
        return this.contextualizedErrorLogger;
    }

    public void close() {
    }

    public ServerServiceDefinition bindService() {
        return UserManagementServiceGrpc$.MODULE$.bindService((UserManagementServiceGrpc.UserManagementService)this, this.executionContext);
    }

    public Future<CreateUserResponse> createUser(CreateUserRequest request) {
        return (Future)this.withSubmissionId((Function1 & Serializable)loggingContext -> this.withValidation(FieldValidations$.MODULE$.requirePresence(request.user(), "user", this.contextualizedErrorLogger()).flatMap((Function1 & Serializable)pUser -> FieldValidations$.MODULE$.requireUserId(pUser.id(), "id", this.contextualizedErrorLogger()).flatMap((Function1 & Serializable)pUserId -> FieldValidations$.MODULE$.optionalString(pUser.primaryParty(), (Function1 & Serializable)s -> FieldValidations$.MODULE$.requireParty(s, this.contextualizedErrorLogger())).flatMap((Function1 & Serializable)pOptPrimaryParty -> this.fromProtoRights((Seq<com.daml.ledger.api.v1.admin.user_management_service.Right>)request.rights()).map((Function1 & Serializable)pRights -> new Tuple2((Object)new domain.User(pUserId, pOptPrimaryParty), pRights))))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            domain.User user = (domain.User)tuple2._1();
            Set pRights = (Set)tuple2._2();
            Future future = $this.userManagementStore.createUser(user, pRights, loggingContext).flatMap((Function1 & Serializable)result -> this.handleResult("creating user", (Either)result), $this.executionContext).map((Function1 & Serializable)x$1 -> new CreateUserResponse((Option)new Some(request.user().get())), $this.executionContext);
            return future;
        }), this.loggingContext);
    }

    public Future<GetUserResponse> getUser(GetUserRequest request) {
        return this.withValidation(FieldValidations$.MODULE$.requireUserId(request.userId(), "user_id", this.contextualizedErrorLogger()), (Function1 & Serializable)userId -> $this.userManagementStore.getUser(userId, $this.loggingContext).flatMap((Function1 & Serializable)result -> this.handleResult("getting user", (Either)result), $this.executionContext).map((Function1 & Serializable)u -> new GetUserResponse((Option)new Some((Object)ApiUserManagementService$.MODULE$.com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoUser((domain.User)u))), $this.executionContext));
    }

    public Future<DeleteUserResponse> deleteUser(DeleteUserRequest request) {
        return (Future)this.withSubmissionId((Function1 & Serializable)loggingContext -> this.withValidation(FieldValidations$.MODULE$.requireUserId(request.userId(), "user_id", this.contextualizedErrorLogger()), (Function1 & Serializable)userId -> $this.userManagementStore.deleteUser(userId, loggingContext).flatMap((Function1 & Serializable)result -> this.handleResult("deleting user", (Either)result), $this.executionContext).map((Function1 & Serializable)x$2 -> new DeleteUserResponse(), $this.executionContext)), this.loggingContext);
    }

    public Future<ListUsersResponse> listUsers(ListUsersRequest request) {
        return this.withValidation(ApiUserManagementService$.MODULE$.decodeUserIdFromPageToken(request.pageToken(), this.contextualizedErrorLogger()).flatMap((Function1 & Serializable)fromExcl -> package$.MODULE$.Either().cond(request.pageSize() >= 0, (Function0)(JFunction0.mcI.sp & Serializable)() -> request.pageSize(), (Function0 & Serializable)() -> new RequestValidation.InvalidArgument$.Reject("Max page size must be non-negative", this.contextualizedErrorLogger()).asGrpcError()).map((Function1 & Serializable)rawPageSize -> ApiUserManagementService.$anonfun$listUsers$4(this, request, BoxesRunTime.unboxToInt((Object)rawPageSize))).map((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int pageSize = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2(fromExcl, (Object)BoxesRunTime.boxToInteger((int)pageSize));
            return tuple22;
        })), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option fromExcl = (Option)tuple2._1();
            int pageSize = tuple2._2$mcI$sp();
            Future future = $this.userManagementStore.listUsers(fromExcl, pageSize, $this.loggingContext).flatMap((Function1 & Serializable)result -> this.handleResult("listing users", (Either)result), $this.executionContext).map((Function1 & Serializable)page -> {
                Seq protoUsers = (Seq)page.users().map((Function1 & Serializable)user -> ApiUserManagementService$.MODULE$.com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoUser((domain.User)user));
                return new ListUsersResponse(protoUsers, ApiUserManagementService$.MODULE$.encodeNextPageToken((Option<String>)(page.users().size() < pageSize ? None$.MODULE$ : page.lastUserIdOption())));
            }, $this.executionContext);
            return future;
        });
    }

    public Future<GrantUserRightsResponse> grantUserRights(GrantUserRightsRequest request) {
        return (Future)this.withSubmissionId((Function1 & Serializable)loggingContext -> this.withValidation(FieldValidations$.MODULE$.requireUserId(request.userId(), "user_id", this.contextualizedErrorLogger()).flatMap((Function1 & Serializable)userId -> this.fromProtoRights((Seq<com.daml.ledger.api.v1.admin.user_management_service.Right>)request.rights()).map((Function1 & Serializable)rights -> new Tuple2(userId, rights))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String userId = (String)tuple2._1();
            Set rights = (Set)tuple2._2();
            Future future = $this.userManagementStore.grantRights(userId, rights, loggingContext).flatMap((Function1 & Serializable)result -> this.handleResult("grant user rights", (Either)result), $this.executionContext).map((Function1 & Serializable)x$4 -> ((IterableOnceOps)x$4.view().map(ApiUserManagementService$.MODULE$.com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoRight())).toList(), $this.executionContext).map((Function1 & Serializable)x$5 -> new GrantUserRightsResponse((Seq)x$5), $this.executionContext);
            return future;
        }), this.loggingContext);
    }

    public Future<RevokeUserRightsResponse> revokeUserRights(RevokeUserRightsRequest request) {
        return (Future)this.withSubmissionId((Function1 & Serializable)loggingContext -> this.withValidation(FieldValidations$.MODULE$.requireUserId(request.userId(), "user_id", this.contextualizedErrorLogger()).flatMap((Function1 & Serializable)userId -> this.fromProtoRights((Seq<com.daml.ledger.api.v1.admin.user_management_service.Right>)request.rights()).map((Function1 & Serializable)rights -> new Tuple2(userId, rights))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String userId = (String)tuple2._1();
            Set rights = (Set)tuple2._2();
            Future future = $this.userManagementStore.revokeRights(userId, rights, loggingContext).flatMap((Function1 & Serializable)result -> this.handleResult("revoke user rights", (Either)result), $this.executionContext).map((Function1 & Serializable)x$6 -> ((IterableOnceOps)x$6.view().map(ApiUserManagementService$.MODULE$.com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoRight())).toList(), $this.executionContext).map((Function1 & Serializable)x$7 -> new RevokeUserRightsResponse((Seq)x$7), $this.executionContext);
            return future;
        }), this.loggingContext);
    }

    public Future<ListUserRightsResponse> listUserRights(ListUserRightsRequest request) {
        return this.withValidation(FieldValidations$.MODULE$.requireUserId(request.userId(), "user_id", this.contextualizedErrorLogger()), (Function1 & Serializable)userId -> $this.userManagementStore.listUserRights(userId, $this.loggingContext).flatMap((Function1 & Serializable)result -> this.handleResult("list user rights", (Either)result), $this.executionContext).map((Function1 & Serializable)x$8 -> ((IterableOnceOps)x$8.view().map(ApiUserManagementService$.MODULE$.com$daml$platform$apiserver$services$admin$ApiUserManagementService$$toProtoRight())).toList(), $this.executionContext).map((Function1 & Serializable)x$9 -> new ListUserRightsResponse((Seq)x$9), $this.executionContext));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> Future<T> handleResult(String operation, Either<UserManagementStore.Error, T> result) {
        UserManagementStore.Error error;
        UserManagementStore.Error error2;
        boolean bl = false;
        Left left = null;
        Either<UserManagementStore.Error, T> either = result;
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            UserManagementStore.Error error3 = (UserManagementStore.Error)left.value();
            if (error3 instanceof UserManagementStore.UserNotFound) {
                UserManagementStore.UserNotFound userNotFound = (UserManagementStore.UserNotFound)error3;
                String id = userNotFound.userId();
                return Future$.MODULE$.failed((Throwable)new UserManagementServiceErrors.UserNotFound$.Reject(operation, id.toString(), this.contextualizedErrorLogger()).asGrpcError());
            }
        }
        if (bl && (error2 = (UserManagementStore.Error)left.value()) instanceof UserManagementStore.UserExists) {
            UserManagementStore.UserExists userExists = (UserManagementStore.UserExists)error2;
            String id = userExists.userId();
            return Future$.MODULE$.failed((Throwable)new UserManagementServiceErrors.UserAlreadyExists$.Reject(operation, id.toString(), this.contextualizedErrorLogger()).asGrpcError());
        }
        if (bl && (error = (UserManagementStore.Error)left.value()) instanceof UserManagementStore.TooManyUserRights) {
            UserManagementStore.TooManyUserRights tooManyUserRights = (UserManagementStore.TooManyUserRights)error;
            String id = tooManyUserRights.userId();
            return Future$.MODULE$.failed((Throwable)new UserManagementServiceErrors.TooManyUserRights$.Reject(operation, id, this.contextualizedErrorLogger()).asGrpcError());
        }
        if (!(either instanceof Right)) throw new MatchError(either);
        Right right = (Right)either;
        Object t = right.value();
        return Future$.MODULE$.successful(t);
    }

    private <A, B> Future<B> withValidation(Either<StatusRuntimeException, A> validatedResult, Function1<A, Future<B>> f) {
        return ((Future)validatedResult.fold((Function1 & Serializable)exception -> Future$.MODULE$.failed(exception), (Function1 & Serializable)result -> Future$.MODULE$.successful(result))).flatMap(f, this.executionContext);
    }

    private Function1<com.daml.ledger.api.v1.admin.user_management_service.Right, Either<StatusRuntimeException, domain.UserRight>> fromProtoRight() {
        return this.fromProtoRight;
    }

    private Either<StatusRuntimeException, Set<domain.UserRight>> fromProtoRights(Seq<com.daml.ledger.api.v1.admin.user_management_service.Right> rights) {
        return ((Either)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps((Object)rights.toList(), list$.MODULE$.listInstance()).traverse(this.fromProtoRight(), (Applicative)either$.MODULE$.eitherMonad())).map((Function1 & Serializable)x$12 -> x$12.toSet());
    }

    private <A> A withSubmissionId(Function1<LoggingContext, A> f, LoggingContext loggingContext) {
        return (A)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"submissionId"), (Object)LoggingValue$.MODULE$.from((Object)this.submissionIdGenerator.generate(), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), (Seq)Nil$.MODULE$, f, loggingContext);
    }

    public static final /* synthetic */ Tuple2 $anonfun$listUsers$4(ApiUserManagementService $this, ListUsersRequest request$3, int rawPageSize) {
        int pageSize = rawPageSize == 0 ? $this.maxUsersPageSize : Math.min(request$3.pageSize(), $this.maxUsersPageSize);
        return new Tuple2.mcII.sp(rawPageSize, pageSize);
    }

    public ApiUserManagementService(UserManagementStore userManagementStore, int maxUsersPageSize, SubmissionIdGenerator submissionIdGenerator, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.userManagementStore = userManagementStore;
        this.maxUsersPageSize = maxUsersPageSize;
        this.submissionIdGenerator = submissionIdGenerator;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        UserManagementServiceGrpc.UserManagementService.$init$((UserManagementServiceGrpc.UserManagementService)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.fromProtoRight = (Function1 & Serializable)x0$1 -> {
            Right.Kind kind;
            Right.Kind kind2;
            Right.Kind kind3;
            Right right;
            com.daml.ledger.api.v1.admin.user_management_service.Right right2 = x0$1;
            if (right2 != null && right2.kind() instanceof Right.Kind$.ParticipantAdmin) {
                right = package$.MODULE$.Right().apply((Object)domain.UserRight$.ParticipantAdmin$.MODULE$);
            } else if (right2 != null && (kind3 = right2.kind()) instanceof Right.Kind$.CanActAs) {
                Right.Kind$.CanActAs canActAs = (Right.Kind$.CanActAs)kind3;
                Right.CanActAs r = canActAs.value();
                right = FieldValidations$.MODULE$.requireParty(r.party(), this.contextualizedErrorLogger()).map((Function1 & Serializable)x$10 -> new domain.UserRight.CanActAs(x$10));
            } else if (right2 != null && (kind2 = right2.kind()) instanceof Right.Kind$.CanReadAs) {
                Right.Kind$.CanReadAs canReadAs = (Right.Kind$.CanReadAs)kind2;
                Right.CanReadAs r = canReadAs.value();
                right = FieldValidations$.MODULE$.requireParty(r.party(), this.contextualizedErrorLogger()).map((Function1 & Serializable)x$11 -> new domain.UserRight.CanReadAs(x$11));
            } else if (right2 != null && Right.Kind$.Empty$.MODULE$.equals(kind = right2.kind())) {
                right = package$.MODULE$.Left().apply((Object)new RequestValidation.InvalidArgument$.Reject("unknown kind of right - check that the Ledger API version of the server is recent enough", this.contextualizedErrorLogger()).asGrpcError());
            } else {
                throw new MatchError((Object)right2);
            }
            return right;
        };
    }
}

