/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store;

import com.codahale.metrics.MetricRegistry;
import com.daml.buildinfo.BuildInfo$;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.resources.ResourceContext;
import com.daml.lf.data.Ref$;
import com.daml.lf.engine.ValueEnricher;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.ApiOffset$;
import com.daml.platform.configuration.ServerRole$ReadIndexMetadata$;
import com.daml.platform.store.DbSupport;
import com.daml.platform.store.DbSupport$;
import com.daml.platform.store.DbSupport$DbConfig$;
import com.daml.platform.store.IndexMetadata;
import com.daml.platform.store.LfValueTranslationCache$Cache$;
import com.daml.platform.store.cache.MutableLedgerEndCache$;
import com.daml.platform.store.dao.JdbcLedgerDao$;
import com.daml.platform.store.dao.LedgerReadDao;
import com.daml.platform.store.interning.StringInterningView;
import com.daml.resources.AbstractResourceOwner;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.ModuleSerializationProxy;
import scalaz.Tag$;

public final class IndexMetadata$
implements Serializable {
    public static final IndexMetadata$ MODULE$ = new IndexMetadata$();
    private static final String Empty = "<empty>";

    public Future<IndexMetadata> read(String jdbcUrl, ResourceContext resourceContext, ExecutionContext executionContext, LoggingContext loggingContext) {
        return this.ownDao(jdbcUrl, executionContext, loggingContext).use((Function1 & Serializable)dao -> dao.lookupLedgerId(loggingContext).flatMap((Function1 & Serializable)ledgerId -> dao.lookupParticipantId(loggingContext).flatMap((Function1 & Serializable)participantId -> {
            Future future;
            Option option = ledgerId;
            if (option instanceof Some) {
                future = dao.lookupLedgerEnd(loggingContext).map((Function1 & Serializable)x -> new Some((Object)x.lastOffset()), executionContext);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            return future.map((Function1 & Serializable)ledgerEnd -> MODULE$.metadata((Option<Object>)ledgerId, (Option<Object>)participantId, (Option<Offset>)ledgerEnd), executionContext);
        }, executionContext), executionContext), (Object)resourceContext);
    }

    private AbstractResourceOwner<ResourceContext, LedgerReadDao> ownDao(String jdbcUrl, ExecutionContext executionContext, LoggingContext loggingContext) {
        Metrics metrics = new Metrics(new MetricRegistry());
        ServerRole$ReadIndexMetadata$ x$1 = ServerRole$ReadIndexMetadata$.MODULE$;
        Metrics x$2 = metrics;
        DbSupport.DbConfig x$3 = new DbSupport.DbConfig(jdbcUrl, new DbSupport.ConnectionPoolConfig(1, new package.DurationInt(package$.MODULE$.DurationInt(250)).millis()), DbSupport$DbConfig$.MODULE$.apply$default$3());
        return DbSupport$.MODULE$.owner(x$3, x$1, x$2, loggingContext).map((Function1 & Serializable)dbSupport -> JdbcLedgerDao$.MODULE$.read((DbSupport)dbSupport, 1000, 8, 20000, 1, 0x6400000, 2, 2, 10, executionContext, metrics, LfValueTranslationCache$Cache$.MODULE$.none(), (Option<ValueEnricher>)None$.MODULE$, (String)Ref$.MODULE$.ParticipantId().assertFromString("1"), MutableLedgerEndCache$.MODULE$.apply(), new StringInterningView()));
    }

    private String Empty() {
        return Empty;
    }

    private IndexMetadata metadata(Option<Object> ledgerId, Option<Object> participantId, Option<Offset> ledgerEnd) {
        return this.apply((String)ledgerId.fold((Function0 & Serializable)() -> MODULE$.Empty(), (Function1 & Serializable)a -> (String)Tag$.MODULE$.unwrap(a)), (String)participantId.fold((Function0 & Serializable)() -> MODULE$.Empty(), (Function1 & Serializable)a -> (String)Tag$.MODULE$.unwrap(a)), (String)ledgerEnd.fold((Function0 & Serializable)() -> MODULE$.Empty(), (Function1 & Serializable)offset -> ApiOffset$.MODULE$.toApiString((Offset)offset)), BuildInfo$.MODULE$.Version());
    }

    public IndexMetadata apply(String ledgerId, String participantId, String ledgerEnd, String participantIntegrationApiVersion) {
        return new IndexMetadata(ledgerId, participantId, ledgerEnd, participantIntegrationApiVersion);
    }

    public Option<Tuple4<String, String, String, String>> unapply(IndexMetadata x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.ledgerId(), (Object)x$0.participantId(), (Object)x$0.ledgerEnd(), (Object)x$0.participantIntegrationApiVersion()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IndexMetadata$.class);
    }

    private IndexMetadata$() {
    }
}

