/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.backend;

import com.daml.ledger.api.DeduplicationPeriod;
import com.daml.ledger.configuration.Configuration$;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.participant.state.v2.CompletionInfo;
import com.daml.ledger.participant.state.v2.Update;
import com.daml.lf.data.Bytes$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Time;
import com.daml.lf.engine.Blinding$;
import com.daml.lf.ledger.EventId;
import com.daml.lf.transaction.BlindingInfo;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.Transaction;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.value.Value;
import com.daml.platform.index.index.StatusDetails$;
import com.daml.platform.package$;
import com.daml.platform.store.ChoiceCoder$;
import com.daml.platform.store.backend.DbDto;
import com.daml.platform.store.dao.JdbcLedgerDao$;
import com.daml.platform.store.dao.events.CompressionStrategy;
import com.daml.platform.store.dao.events.LfValueSerialization;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class UpdateToDbDto$ {
    public static final UpdateToDbDto$ MODULE$ = new UpdateToDbDto$();

    public Function1<Offset, Function1<Update, Iterator<DbDto>>> apply(String participantId, LfValueSerialization translation, CompressionStrategy compressionStrategy) {
        return (Function1 & Serializable)offset -> (Function1 & Serializable)x0$1 -> {
            Iterator iterator;
            Update update = x0$1;
            if (update instanceof Update.CommandRejected) {
                Update.CommandRejected commandRejected = (Update.CommandRejected)update;
                DbDto.CommandCompletion[] commandCompletionArray = new DbDto.CommandCompletion[1];
                DbDto.CommandCompletion qual$1 = MODULE$.commandCompletion((Offset)offset, commandRejected.recordTime(), (Option<String>)None$.MODULE$, commandRejected.completionInfo());
                Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)commandRejected.reasonTemplate().code()));
                Some x$22 = new Some((Object)commandRejected.reasonTemplate().message());
                Some x$32 = new Some((Object)StatusDetails$.MODULE$.of(commandRejected.reasonTemplate().status().details()).toByteArray());
                String x$42 = qual$1.copy$default$1();
                long x$52 = qual$1.copy$default$2();
                String x$62 = qual$1.copy$default$3();
                scala.collection.immutable.Set<String> x$7 = qual$1.copy$default$4();
                String x$8 = qual$1.copy$default$5();
                Option<String> x$9 = qual$1.copy$default$6();
                Option<String> x$10 = qual$1.copy$default$10();
                Option<String> x$11 = qual$1.copy$default$11();
                Option<Object> x$122 = qual$1.copy$default$12();
                Option<Object> x$13 = qual$1.copy$default$13();
                Option<Object> x$14 = qual$1.copy$default$14();
                commandCompletionArray[0] = qual$1.copy(x$42, x$52, x$62, x$7, x$8, x$9, (Option<Object>)x$12, (Option<String>)x$22, (Option<byte[]>)x$32, x$10, x$11, x$122, x$13, x$14);
                iterator = scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])commandCompletionArray));
            } else if (update instanceof Update.ConfigurationChanged) {
                Update.ConfigurationChanged configurationChanged = (Update.ConfigurationChanged)update;
                iterator = scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DbDto.ConfigurationEntry[]{new DbDto.ConfigurationEntry(offset.toHexString(), configurationChanged.recordTime().micros(), configurationChanged.submissionId(), JdbcLedgerDao$.MODULE$.acceptType(), Configuration$.MODULE$.encode(configurationChanged.newConfiguration()).toByteArray(), (Option<String>)None$.MODULE$)}));
            } else if (update instanceof Update.ConfigurationChangeRejected) {
                Update.ConfigurationChangeRejected configurationChangeRejected = (Update.ConfigurationChangeRejected)update;
                iterator = scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DbDto.ConfigurationEntry[]{new DbDto.ConfigurationEntry(offset.toHexString(), configurationChangeRejected.recordTime().micros(), configurationChangeRejected.submissionId(), JdbcLedgerDao$.MODULE$.rejectType(), Configuration$.MODULE$.encode(configurationChangeRejected.proposedConfiguration()).toByteArray(), (Option<String>)new Some((Object)configurationChangeRejected.rejectionReason()))}));
            } else if (update instanceof Update.PartyAddedToParticipant) {
                Update.PartyAddedToParticipant partyAddedToParticipant = (Update.PartyAddedToParticipant)update;
                DbDto.PartyEntry[] partyEntryArray = new DbDto.PartyEntry[1];
                String string = partyAddedToParticipant.participantId();
                String string2 = participantId;
                partyEntryArray[0] = new DbDto.PartyEntry(offset.toHexString(), partyAddedToParticipant.recordTime().micros(), (Option<String>)partyAddedToParticipant.submissionId(), (Option<String>)new Some((Object)partyAddedToParticipant.party()), (Option<String>)Option$.MODULE$.apply((Object)partyAddedToParticipant.displayName()), JdbcLedgerDao$.MODULE$.acceptType(), (Option<String>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0)));
                iterator = scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])partyEntryArray));
            } else if (update instanceof Update.PartyAllocationRejected) {
                Update.PartyAllocationRejected partyAllocationRejected = (Update.PartyAllocationRejected)update;
                iterator = scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DbDto.PartyEntry[]{new DbDto.PartyEntry(offset.toHexString(), partyAllocationRejected.recordTime().micros(), (Option<String>)new Some((Object)partyAllocationRejected.submissionId()), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, JdbcLedgerDao$.MODULE$.rejectType(), (Option<String>)new Some((Object)partyAllocationRejected.rejectionReason()), (Option<Object>)None$.MODULE$)}));
            } else if (update instanceof Update.PublicPackageUpload) {
                Update.PublicPackageUpload publicPackageUpload = (Update.PublicPackageUpload)update;
                String uploadId = (String)publicPackageUpload.submissionId().getOrElse((Function0 & Serializable)() -> UUID.randomUUID().toString());
                Iterator packages = publicPackageUpload.archives().iterator().map((Function1 & Serializable)archive -> new DbDto.Package(archive.getHash(), uploadId, (Option<String>)publicPackageUpload.sourceDescription(), archive.getPayload().size(), publicPackageUpload.recordTime().micros(), offset.toHexString(), archive.toByteArray()));
                Iterator packageEntries = publicPackageUpload.submissionId().iterator().map((Function1 & Serializable)submissionId -> new DbDto.PackageEntry(offset.toHexString(), publicPackageUpload.recordTime().micros(), (Option<String>)new Some(submissionId), JdbcLedgerDao$.MODULE$.acceptType(), (Option<String>)None$.MODULE$));
                iterator = packages.$plus$plus((Function0 & Serializable)() -> packageEntries);
            } else if (update instanceof Update.PublicPackageUploadRejected) {
                Update.PublicPackageUploadRejected publicPackageUploadRejected = (Update.PublicPackageUploadRejected)update;
                iterator = scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DbDto.PackageEntry[]{new DbDto.PackageEntry(offset.toHexString(), publicPackageUploadRejected.recordTime().micros(), (Option<String>)new Some((Object)publicPackageUploadRejected.submissionId()), JdbcLedgerDao$.MODULE$.rejectType(), (Option<String>)new Some((Object)publicPackageUploadRejected.rejectionReason()))}));
            } else if (update instanceof Update.TransactionAccepted) {
                Update.TransactionAccepted transactionAccepted = (Update.TransactionAccepted)update;
                BlindingInfo blinding = (BlindingInfo)transactionAccepted.blindingInfo().getOrElse((Function0 & Serializable)() -> Blinding$.MODULE$.blind(transactionAccepted.transaction()));
                List preorderTraversal = ((List)transactionAccepted.transaction().foldInExecutionOrder((Object)scala.package$.MODULE$.List().empty(), (Function3 & Serializable)(acc, nid, node) -> {
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nid), node);
                    return new Tuple2((Object)acc.$colon$colon((Object)tuple2), (Object)Transaction.ChildrenRecursion$.DoRecurse$.MODULE$);
                }, (Function3 & Serializable)(acc, x$1, x$2) -> new Tuple2(acc, (Object)Transaction.ChildrenRecursion$.DoNotRecurse$.MODULE$), (Function3 & Serializable)(acc, nid, node) -> {
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nid), node);
                    return acc.$colon$colon((Object)tuple2);
                }, (Function3 & Serializable)(acc, x$3, x$4) -> acc, (Function3 & Serializable)(acc, x$5, x$6) -> acc)).reverse();
                Iterator events = preorderTraversal.iterator().flatMap((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        NodeId nodeId = (NodeId)tuple2._1();
                        Node create = (Node)tuple2._2();
                        if (create instanceof Node.Create) {
                            Node.Create create2 = (Node.Create)create;
                            EventId eventId = new EventId(transactionAccepted.transactionId(), nodeId);
                            String templateId = create2.templateId().toString();
                            scala.collection.immutable.Set stakeholders = (scala.collection.immutable.Set)create2.stakeholders().map((Function1 & Serializable)x$7 -> x$7.toString());
                            Tuple2<byte[], Option<byte[]>> tuple22 = translation.serialize(eventId, create2);
                            if (tuple22 == null) throw new MatchError(tuple22);
                            byte[] createArgument = (byte[])tuple22._1();
                            Option createKeyValue = (Option)tuple22._2();
                            Tuple2 tuple23 = new Tuple2((Object)createArgument, (Object)createKeyValue);
                            Tuple2 tuple24 = tuple23;
                            byte[] createArgument2 = (byte[])tuple24._1();
                            Option createKeyValue2 = (Option)tuple24._2();
                            return scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DbDto.EventCreate[]{new DbDto.EventCreate((Option<String>)new Some((Object)offset.toHexString()), (Option<String>)new Some((Object)transactionAccepted.transactionId()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)transactionAccepted.transactionMeta().ledgerEffectiveTime().micros())), (Option<String>)transactionAccepted.optCompletionInfo().map((Function1 & Serializable)x$9 -> x$9.commandId()), (Option<String>)transactionAccepted.transactionMeta().workflowId(), (Option<String>)transactionAccepted.optCompletionInfo().map((Function1 & Serializable)x$10 -> x$10.applicationId()), (Option<scala.collection.immutable.Set<String>>)transactionAccepted.optCompletionInfo().map((Function1 & Serializable)x$11 -> x$11.actAs().toSet()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)nodeId.index())), (Option<String>)new Some((Object)eventId.toLedgerString()), create2.coid().coid(), (Option<String>)new Some((Object)templateId), (scala.collection.immutable.Set<String>)stakeholders, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)((IterableOps)blinding.disclosure().getOrElse((Object)nodeId, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).map((Function1 & Serializable)x$12 -> x$12.toString())), (Option<byte[]>)new Some((Object)createArgument2).map(compressionStrategy.createArgumentCompression().compress()), (Option<scala.collection.immutable.Set<String>>)new Some(create2.signatories().map((Function1 & Serializable)x$13 -> x$13.toString())), (Option<scala.collection.immutable.Set<String>>)new Some(create2.stakeholders().diff((Set)create2.signatories()).map((Function1 & Serializable)x$14 -> x$14.toString())), (Option<String>)new Some((Object)create2.agreementText()).filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$15)))), (Option<byte[]>)createKeyValue2.map(compressionStrategy.createKeyValueCompression().compress()), (Option<String>)create2.key().map((Function1 & Serializable)key -> Bytes$.MODULE$.toHexString$extension(package$.MODULE$.Key().assertBuild(create2.templateId(), key.key()).hash().bytes())), compressionStrategy.createArgumentCompression().id(), (Option<Object>)compressionStrategy.createKeyValueCompression().id().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$16 -> createKeyValue2.isDefined()), 0L)})).$plus$plus((Function0 & Serializable)() -> stakeholders.iterator().map((Function1 & Serializable)x$17 -> new DbDto.CreateFilter(0L, templateId, (String)x$17)));
                        }
                    }
                    if (tuple2 == null) return scala.package$.MODULE$.Iterator().empty();
                    NodeId nodeId = (NodeId)tuple2._1();
                    Node exercise = (Node)tuple2._2();
                    if (!(exercise instanceof Node.Exercise)) return scala.package$.MODULE$.Iterator().empty();
                    Node.Exercise exercise2 = (Node.Exercise)exercise;
                    EventId eventId = new EventId(transactionAccepted.transactionId(), nodeId);
                    Tuple3<byte[], Option<byte[]>, Option<byte[]>> tuple3 = translation.serialize(eventId, exercise2);
                    if (tuple3 == null) throw new MatchError(tuple3);
                    byte[] exerciseArgument = (byte[])tuple3._1();
                    Option exerciseResult = (Option)tuple3._2();
                    Option createKeyValue = (Option)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)exerciseArgument, (Object)exerciseResult, (Object)createKeyValue);
                    Tuple3 tuple33 = tuple32;
                    byte[] exerciseArgument2 = (byte[])tuple33._1();
                    Option exerciseResult2 = (Option)tuple33._2();
                    Option createKeyValue3 = (Option)tuple33._3();
                    return scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DbDto.EventExercise[]{new DbDto.EventExercise(exercise2.consuming(), (Option<String>)new Some((Object)offset.toHexString()), (Option<String>)new Some((Object)transactionAccepted.transactionId()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)transactionAccepted.transactionMeta().ledgerEffectiveTime().micros())), (Option<String>)transactionAccepted.optCompletionInfo().map((Function1 & Serializable)x$19 -> x$19.commandId()), (Option<String>)transactionAccepted.transactionMeta().workflowId(), (Option<String>)transactionAccepted.optCompletionInfo().map((Function1 & Serializable)x$20 -> x$20.applicationId()), (Option<scala.collection.immutable.Set<String>>)transactionAccepted.optCompletionInfo().map((Function1 & Serializable)x$21 -> x$21.actAs().toSet()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)nodeId.index())), (Option<String>)new Some((Object)new EventId(transactionAccepted.transactionId(), nodeId).toLedgerString()), exercise2.targetCoid().coid(), (Option<String>)new Some((Object)exercise2.templateId().toString()), (scala.collection.immutable.Set<String>)(exercise2.consuming() ? (scala.collection.immutable.Set)exercise2.stakeholders().map((Function1 & Serializable)x$22 -> x$22.toString()) : Predef$.MODULE$.Set().empty()), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)((IterableOps)blinding.disclosure().getOrElse((Object)nodeId, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).map((Function1 & Serializable)x$23 -> x$23.toString())), (Option<byte[]>)createKeyValue3.map(compressionStrategy.createKeyValueCompression().compress()), (Option<String>)new Some((Object)ChoiceCoder$.MODULE$.encode((Option<Ref.Identifier>)exercise2.interfaceId(), exercise2.choiceId())), (Option<byte[]>)new Some((Object)exerciseArgument2).map(compressionStrategy.exerciseArgumentCompression().compress()), (Option<byte[]>)exerciseResult2.map(compressionStrategy.exerciseResultCompression().compress()), (Option<scala.collection.immutable.Set<String>>)new Some(exercise2.actingParties().map((Function1 & Serializable)x$24 -> x$24.toString())), (Option<Vector<String>>)new Some((Object)exercise2.children().iterator().map((Function1 & Serializable)x$25 -> new EventId(transactionAccepted.transactionId(), x$25).toLedgerString().toString()).toVector()), compressionStrategy.createKeyValueCompression().id(), compressionStrategy.exerciseArgumentCompression().id(), compressionStrategy.exerciseResultCompression().id(), 0L)}));
                });
                Map divulgedContractIndex = transactionAccepted.divulgedContracts().map((Function1 & Serializable)divulgedContract -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)divulgedContract.contractId()), divulgedContract)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Iterator divulgences = blinding.divulgence().iterator().collect((PartialFunction)new Serializable(divulgedContractIndex, (Offset)offset, transactionAccepted, translation, compressionStrategy){
                    private static final long serialVersionUID = 0L;
                    private final Map divulgedContractIndex$1;
                    private final Offset offset$1;
                    private final Update.TransactionAccepted x9$1;
                    private final LfValueSerialization translation$1;
                    private final CompressionStrategy compressionStrategy$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<Value.ContractId, scala.collection.immutable.Set<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            Value.ContractId contractId = (Value.ContractId)A1._1();
                            scala.collection.immutable.Set visibleToParties = (scala.collection.immutable.Set)A1._2();
                            if (visibleToParties.nonEmpty()) {
                                Option contractInst = this.divulgedContractIndex$1.get((Object)contractId).map((Function1 & Serializable)x$26 -> x$26.contractInst());
                                object = new DbDto.EventDivulgence((Option<String>)new Some((Object)this.offset$1.toHexString()), (Option<String>)this.x9$1.optCompletionInfo().map((Function1 & Serializable)x$27 -> x$27.commandId()), (Option<String>)this.x9$1.transactionMeta().workflowId(), (Option<String>)this.x9$1.optCompletionInfo().map((Function1 & Serializable)x$28 -> x$28.applicationId()), (Option<scala.collection.immutable.Set<String>>)this.x9$1.optCompletionInfo().map((Function1 & Serializable)x$29 -> x$29.actAs().toSet()), contractId.coid(), (Option<String>)contractInst.map((Function1 & Serializable)x$30 -> ((Value.ContractInstance)x$30.unversioned()).template().toString()), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)visibleToParties.map((Function1 & Serializable)x$31 -> x$31.toString())), (Option<byte[]>)contractInst.map((Function1 & Serializable)x$32 -> x$32.map((Function1 & Serializable)x$33 -> x$33.arg())).map((Function1 & Serializable)x$34 -> $this.translation$1.serialize(contractId, (Versioned<Value>)x$34)).map(this.compressionStrategy$1.createArgumentCompression().compress()), this.compressionStrategy$1.createArgumentCompression().id(), 0L);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<Value.ContractId, scala.collection.immutable.Set<String>> x1) {
                        scala.collection.immutable.Set visibleToParties;
                        Tuple2<Value.ContractId, scala.collection.immutable.Set<String>> tuple2 = x1;
                        boolean bl = tuple2 != null && (visibleToParties = (scala.collection.immutable.Set)tuple2._2()).nonEmpty();
                        return bl;
                    }
                    {
                        this.divulgedContractIndex$1 = divulgedContractIndex$1;
                        this.offset$1 = offset$1;
                        this.x9$1 = x9$1;
                        this.translation$1 = translation$1;
                        this.compressionStrategy$1 = compressionStrategy$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.daml.ledger.participant.state.v2.DivulgedContract ), $anonfun$applyOrElse$2(com.daml.ledger.participant.state.v2.CompletionInfo ), $anonfun$applyOrElse$3(com.daml.ledger.participant.state.v2.CompletionInfo ), $anonfun$applyOrElse$4(com.daml.ledger.participant.state.v2.CompletionInfo ), $anonfun$applyOrElse$5(com.daml.lf.transaction.Versioned ), $anonfun$applyOrElse$6(java.lang.String ), $anonfun$applyOrElse$7(com.daml.lf.transaction.Versioned ), $anonfun$applyOrElse$8(com.daml.lf.value.Value$ContractInstance ), $anonfun$applyOrElse$9(com.daml.platform.store.backend.UpdateToDbDto$$anonfun$1 com.daml.lf.value.Value$ContractId com.daml.lf.transaction.Versioned )}, serializedLambda);
                    }
                });
                Iterator completions = transactionAccepted.optCompletionInfo().iterator().map((Function1 & Serializable)x$35 -> MODULE$.commandCompletion((Offset)offset, transactionAccepted.recordTime(), (Option<String>)new Some((Object)transactionAccepted.transactionId()), (CompletionInfo)x$35));
                iterator = events.$plus$plus((Function0 & Serializable)() -> divulgences).$plus$plus((Function0 & Serializable)() -> completions);
            } else {
                throw new MatchError((Object)update);
            }
            return iterator;
        };
    }

    private DbDto.CommandCompletion commandCompletion(Offset offset, Time.Timestamp recordTime, Option<String> transactionId, CompletionInfo completionInfo) {
        Tuple3 tuple3 = (Tuple3)completionInfo.optDeduplicationPeriod().map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3;
            DeduplicationPeriod deduplicationPeriod = x0$1;
            if (deduplicationPeriod instanceof DeduplicationPeriod.DeduplicationOffset) {
                DeduplicationPeriod.DeduplicationOffset deduplicationOffset = (DeduplicationPeriod.DeduplicationOffset)deduplicationPeriod;
                Offset offset = deduplicationOffset.offset();
                tuple3 = new Tuple3((Object)new Some((Object)offset.toHexString()), (Object)None$.MODULE$, (Object)None$.MODULE$);
            } else if (deduplicationPeriod instanceof DeduplicationPeriod.DeduplicationDuration) {
                DeduplicationPeriod.DeduplicationDuration deduplicationDuration = (DeduplicationPeriod.DeduplicationDuration)deduplicationPeriod;
                Duration duration = deduplicationDuration.duration();
                tuple3 = new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)BoxesRunTime.boxToLong((long)duration.getSeconds())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)duration.getNano())));
            } else {
                throw new MatchError((Object)deduplicationPeriod);
            }
            return tuple3;
        }).getOrElse((Function0 & Serializable)() -> new Tuple3((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option deduplicationOffset = (Option)tuple3._1();
        Option deduplicationDurationSeconds = (Option)tuple3._2();
        Option deduplicationDurationNanos = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)deduplicationOffset, (Object)deduplicationDurationSeconds, (Object)deduplicationDurationNanos);
        Tuple3 tuple33 = tuple32;
        Option deduplicationOffset2 = (Option)tuple33._1();
        Option deduplicationDurationSeconds2 = (Option)tuple33._2();
        Option deduplicationDurationNanos2 = (Option)tuple33._3();
        return new DbDto.CommandCompletion(offset.toHexString(), recordTime.micros(), completionInfo.applicationId(), (scala.collection.immutable.Set<String>)completionInfo.actAs().toSet(), completionInfo.commandId(), transactionId, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<byte[]>)None$.MODULE$, (Option<String>)completionInfo.submissionId(), (Option<String>)deduplicationOffset2, (Option<Object>)deduplicationDurationSeconds2, (Option<Object>)deduplicationDurationNanos2, (Option<Object>)None$.MODULE$);
    }

    private UpdateToDbDto$() {
    }
}

