/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.backend.common;

import anorm.;
import anorm.Column$;
import anorm.Row;
import anorm.RowParser;
import anorm.SimpleSql;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import com.daml.platform.store.backend.IntegrityStorageBackend;
import com.daml.platform.store.backend.common.ComposableQuery;
import com.daml.platform.store.backend.common.ComposableQuery$;
import com.daml.platform.store.backend.common.ComposableQuery$QueryPart$;
import com.daml.platform.store.backend.common.ComposableQuery$SqlStringInterpolation$;
import com.daml.platform.store.backend.common.IntegrityStorageBackendImpl;
import java.io.Serializable;
import java.sql.Connection;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public final class IntegrityStorageBackendImpl$
implements IntegrityStorageBackend {
    public static final IntegrityStorageBackendImpl$ MODULE$ = new IntegrityStorageBackendImpl$();
    private static final String allSequentialIds = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |SELECT event_sequential_id FROM participant_events_divulgence\n      |UNION ALL\n      |SELECT event_sequential_id FROM participant_events_create\n      |UNION ALL\n      |SELECT event_sequential_id FROM participant_events_consuming_exercise\n      |UNION ALL\n      |SELECT event_sequential_id FROM participant_events_non_consuming_exercise\n      |"));
    private static final SimpleSql<Row> SqlEventSequentialIdsSummary;
    private static final int maxReportedDuplicates;
    private static final SimpleSql<Row> SqlDuplicateEventSequentialIds;
    private static final String allEventIds;
    private static final SimpleSql<Row> SqlDuplicateOffsets;
    private static final RowParser<IntegrityStorageBackendImpl.EventSequentialIdsRow> eventSequantialIdsParser;

    static {
        ComposableQuery.QueryPart[] queryPartArray = new ComposableQuery.QueryPart[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[0] = ComposableQuery$QueryPart$.MODULE$.from(MODULE$.allSequentialIds(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        SqlEventSequentialIdsSummary = ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      WITH sequential_ids AS (#", ")\n      SELECT min(event_sequential_id) as min, max(event_sequential_id) as max, count(event_sequential_id) as count\n      FROM sequential_ids, parameters\n      WHERE event_sequential_id <= parameters.ledger_end_sequential_id\n      "}))), (Seq<ComposableQuery.QueryPart>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])queryPartArray));
        maxReportedDuplicates = 100;
        ComposableQuery.QueryPart[] queryPartArray2 = new ComposableQuery.QueryPart[2];
        ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray2[0] = ComposableQuery$QueryPart$.MODULE$.from(MODULE$.allSequentialIds(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.intToStatement$ x$11 = ToStatement$.MODULE$.intToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray2[1] = ComposableQuery$QueryPart$.MODULE$.from(BoxesRunTime.boxToInteger((int)MODULE$.maxReportedDuplicates()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        SqlDuplicateEventSequentialIds = ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n       WITH sequential_ids AS (#", ")\n       SELECT event_sequential_id as id, count(*) as count\n       FROM sequential_ids, parameters\n       WHERE event_sequential_id <= parameters.ledger_end_sequential_id\n       GROUP BY event_sequential_id\n       HAVING count(*) > 1\n       FETCH NEXT #", " ROWS ONLY\n       "}))), (Seq<ComposableQuery.QueryPart>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])queryPartArray2));
        allEventIds = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |SELECT event_offset, node_index FROM participant_events_create\n       |UNION ALL\n       |SELECT event_offset, node_index FROM participant_events_consuming_exercise\n       |UNION ALL\n       |SELECT event_offset, node_index FROM participant_events_non_consuming_exercise\n       |"));
        ComposableQuery.QueryPart[] queryPartArray3 = new ComposableQuery.QueryPart[2];
        ToStatementPriority0.stringToStatement$ x$15 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray3[0] = ComposableQuery$QueryPart$.MODULE$.from(MODULE$.allEventIds(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
        ToStatementPriority0.intToStatement$ x$19 = ToStatement$.MODULE$.intToStatement();
        Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray3[1] = ComposableQuery$QueryPart$.MODULE$.from(BoxesRunTime.boxToInteger((int)MODULE$.maxReportedDuplicates()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
        SqlDuplicateOffsets = ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n       WITH event_ids AS (#", ")\n       SELECT event_offset, node_index, count(*) as count\n       FROM event_ids, parameters\n       WHERE event_offset <= parameters.ledger_end\n       GROUP BY event_offset, node_index\n       HAVING count(*) > 1\n       FETCH NEXT #", " ROWS ONLY\n       "}))), (Seq<ComposableQuery.QueryPart>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])queryPartArray3));
        eventSequantialIdsParser = SqlParser$.MODULE$.long("min", Column$.MODULE$.columnToLong()).$tilde(SqlParser$.MODULE$.long("max", Column$.MODULE$.columnToLong())).$tilde(SqlParser$.MODULE$.long("count", Column$.MODULE$.columnToLong())).map((Function1 & Serializable)x0$1 -> {
            long count;
            .tilde tilde2;
            block3: {
                .tilde tilde3;
                block2: {
                    tilde3 = x0$1;
                    if (tilde3 == null) break block2;
                    tilde2 = (.tilde)tilde3._1();
                    count = BoxesRunTime.unboxToLong((Object)tilde3._2());
                    if (tilde2 != null) break block3;
                }
                throw new MatchError((Object)tilde3);
            }
            long min = BoxesRunTime.unboxToLong((Object)tilde2._1());
            long max = BoxesRunTime.unboxToLong((Object)tilde2._2());
            IntegrityStorageBackendImpl.EventSequentialIdsRow eventSequentialIdsRow = new IntegrityStorageBackendImpl.EventSequentialIdsRow(min, max, count);
            return eventSequentialIdsRow;
        });
    }

    private String allSequentialIds() {
        return allSequentialIds;
    }

    private SimpleSql<Row> SqlEventSequentialIdsSummary() {
        return SqlEventSequentialIdsSummary;
    }

    private int maxReportedDuplicates() {
        return maxReportedDuplicates;
    }

    private SimpleSql<Row> SqlDuplicateEventSequentialIds() {
        return SqlDuplicateEventSequentialIds;
    }

    private String allEventIds() {
        return allEventIds;
    }

    private SimpleSql<Row> SqlDuplicateOffsets() {
        return SqlDuplicateOffsets;
    }

    private RowParser<IntegrityStorageBackendImpl.EventSequentialIdsRow> eventSequantialIdsParser() {
        return eventSequantialIdsParser;
    }

    @Override
    public void verifyIntegrity(Connection connection) {
        List duplicateSeqIds = (List)this.SqlDuplicateEventSequentialIds().as(SqlParser$.MODULE$.long("id", Column$.MODULE$.columnToLong()).$times(), connection);
        List duplicateOffsets = (List)this.SqlDuplicateOffsets().as(SqlParser$.MODULE$.str("event_offset", Column$.MODULE$.columnToString()).$times(), connection);
        IntegrityStorageBackendImpl.EventSequentialIdsRow summary = (IntegrityStorageBackendImpl.EventSequentialIdsRow)this.SqlEventSequentialIdsSummary().as(this.eventSequantialIdsParser().single(), connection);
        if (duplicateOffsets.nonEmpty()) {
            throw new RuntimeException(new StringBuilder(36).append("Found ").append(duplicateOffsets.length()).append(" duplicate offsets. Examples: ").append(duplicateOffsets.mkString(", ")).toString());
        }
        if (duplicateSeqIds.nonEmpty()) {
            throw new RuntimeException(new StringBuilder(49).append("Found ").append(duplicateSeqIds.length()).append(" duplicate event sequential ids. Examples: ").append(duplicateSeqIds.mkString(", ")).toString());
        }
        if (summary.count() != summary.max() - summary.min() + 1L) {
            throw new RuntimeException(new StringBuilder(61).append("Event sequential ids are not consecutive. Min=").append(summary.min()).append(", max=").append(summary.max()).append(", count=").append(summary.count()).append(".").toString());
        }
    }

    private IntegrityStorageBackendImpl$() {
    }
}

