/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.backend.postgresql;

import anorm.Column$;
import anorm.SqlParser$;
import anorm.package;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.store.backend.DataSourceStorageBackend;
import com.daml.platform.store.backend.common.DataSourceStorageBackendImpl$;
import com.daml.platform.store.backend.common.InitHookDataSourceProxy$;
import com.daml.platform.store.backend.postgresql.PostgresDataSourceStorageBackend$;
import com.daml.resources.ProgramResource;
import java.io.Serializable;
import java.sql.Connection;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\t\u0013\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006]\u0001!\ta\f\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019Y\u0004\u0001)A\u0005k!)A\b\u0001C!{!)q\r\u0001C!Q\"1Q\u000e\u0001C\u0001)9DaA\u001e\u0001\u0005\u0002Q9\bbBA\u0006\u0001\u0011\u0005\u0013QB\u0004\b\u0003#\u0011\u0002\u0012AA\n\r\u0019\t\"\u0003#\u0001\u0002\u0016!1af\u0003C\u0001\u0003/Aq!!\u0007\f\t\u0003\tYB\u0002\u0004\u0002\u001e-\u0011\u0011q\u0004\u0005\n\u0003#r!\u0011!Q\u0001\niDaA\f\b\u0005\u0002\u0005M#\u0001\t)pgR<'/Z:ECR\f7k\\;sG\u0016\u001cFo\u001c:bO\u0016\u0014\u0015mY6f]\u0012T!a\u0005\u000b\u0002\u0015A|7\u000f^4sKN\fHN\u0003\u0002\u0016-\u00059!-Y2lK:$'BA\f\u0019\u0003\u0015\u0019Ho\u001c:f\u0015\tI\"$\u0001\u0005qY\u0006$hm\u001c:n\u0015\tYB$\u0001\u0003eC6d'\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003O!j\u0011\u0001F\u0005\u0003SQ\u0011\u0001\u0004R1uCN{WO]2f'R|'/Y4f\u0005\u0006\u001c7.\u001a8e\u0003ai\u0017N\\'bU>\u0014h+\u001a:tS>t7+\u001e9q_J$X\r\u001a\t\u0003C1J!!\f\u0012\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0003aI\u0002\"!\r\u0001\u000e\u0003IAQA\u000b\u0002A\u0002-\na\u0001\\8hO\u0016\u0014X#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0005aR\u0012a\u00027pO\u001eLgnZ\u0005\u0003u]\u0012AcQ8oi\u0016DH/^1mSj,G\rT8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0011GJ,\u0017\r^3ECR\f7k\\;sG\u0016$2A\u0010'V)\tyt\t\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006\u00191/\u001d7\u000b\u0003\u0011\u000bQA[1wCbL!AR!\u0003\u0015\u0011\u000bG/Y*pkJ\u001cW\rC\u0003I\u000b\u0001\u000f\u0011*\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\u0005YR\u0015BA&8\u00059aunZ4j]\u001e\u001cuN\u001c;fqRDQ!T\u0003A\u00029\u000b\u0001\u0003Z1uCN{WO]2f\u0007>tg-[4\u0011\u0005=\u0013fBA\u0014Q\u0013\t\tF#\u0001\rECR\f7k\\;sG\u0016\u001cFo\u001c:bO\u0016\u0014\u0015mY6f]\u0012L!a\u0015+\u0003!\u0011\u000bG/Y*pkJ\u001cWmQ8oM&<'BA)\u0015\u0011\u001d1V\u0001%AA\u0002]\u000b!cY8o]\u0016\u001cG/[8o\u0013:LG\u000fS8pWB\u0019\u0011\u0005\u0017.\n\u0005e\u0013#AB(qi&|g\u000e\u0005\u0003\"7v#\u0017B\u0001/#\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002_E6\tqL\u0003\u0002CA*\t\u0011-\u0001\u0003kCZ\f\u0017BA2`\u0005)\u0019uN\u001c8fGRLwN\u001c\t\u0003C\u0015L!A\u001a\u0012\u0003\tUs\u0017\u000e^\u0001\u0013G\",7m[\"p[B\fG/\u001b2jY&$\u0018\u0010\u0006\u0002jWR\u0011AM\u001b\u0005\u0006\u0011\u001a\u0001\u001d!\u0013\u0005\u0006Y\u001a\u0001\r!X\u0001\u000bG>tg.Z2uS>t\u0017AE4fiB{7\u000f^4sKN4VM]:j_:$\"a\\;\u0015\u0005A$\bcA\u0011YcB!\u0011E]\u0016,\u0013\t\u0019(E\u0001\u0004UkBdWM\r\u0005\u0006\u0011\u001e\u0001\u001d!\u0013\u0005\u0006Y\u001e\u0001\r!X\u0001\u0015a\u0006\u00148/\u001a)pgR<'/Z:WKJ\u001c\u0018n\u001c8\u0015\u0005AD\b\"B=\t\u0001\u0004Q\u0018a\u0002<feNLwN\u001c\t\u0004w\u0006\u0015ab\u0001?\u0002\u0002A\u0011QPI\u0007\u0002}*\u0011qPH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r!%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\tIA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007\u0011\u0013AF2iK\u000e\\G)\u0019;bE\u0006\u001cX-\u0011<bS2\f'\r\\3\u0015\u0007\u0011\fy\u0001C\u0003m\u0013\u0001\u0007Q,\u0001\u0011Q_N$xM]3t\t\u0006$\u0018mU8ve\u000e,7\u000b^8sC\u001e,')Y2lK:$\u0007CA\u0019\f'\tY\u0001\u0005\u0006\u0002\u0002\u0014\u0005)\u0011\r\u001d9msR\t\u0001G\u0001\u000eV]N,\b\u000f]8si\u0016$\u0007k\\:uOJ,7OV3sg&|gnE\u0003\u000f\u0003C\t\u0019\u0004\u0005\u0003\u0002$\u00055b\u0002BA\u0013\u0003Sq1!`A\u0014\u0013\u0005\u0019\u0013bAA\u0016E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u0011\u0001CU;oi&lW-\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005-\"\u0005\u0005\u0003\u00026\u0005-c\u0002BA\u001c\u0003\u000brA!!\u000f\u0002B9!\u00111HA \u001d\ri\u0018QH\u0005\u0002;%\u00111\u0004H\u0005\u0004\u0003\u0007R\u0012!\u0003:fg>,(oY3t\u0013\u0011\t9%!\u0013\u0002\u001fA\u0013xn\u001a:b[J+7o\\;sG\u0016T1!a\u0011\u001b\u0013\u0011\ti%a\u0014\u0003!M#\u0018M\u001d;va\u0016C8-\u001a9uS>t'\u0002BA$\u0003\u0013\nq!\\3tg\u0006<W\r\u0006\u0003\u0002V\u0005e\u0003cAA,\u001d5\t1\u0002\u0003\u0004\u0002RA\u0001\rA\u001f")
public class PostgresDataSourceStorageBackend
implements DataSourceStorageBackend {
    private final int minMajorVersionSupported;
    private final ContextualizedLogger logger;

    public static PostgresDataSourceStorageBackend apply() {
        return PostgresDataSourceStorageBackend$.MODULE$.apply();
    }

    @Override
    public Option<Function1<Connection, BoxedUnit>> createDataSource$default$2() {
        return DataSourceStorageBackend.createDataSource$default$2$(this);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    @Override
    public DataSource createDataSource(DataSourceStorageBackend.DataSourceConfig dataSourceConfig, Option<Function1<Connection, BoxedUnit>> connectionInitHook, LoggingContext loggingContext) {
        PGSimpleDataSource pgSimpleDataSource = new PGSimpleDataSource();
        pgSimpleDataSource.setUrl(dataSourceConfig.jdbcUrl());
        List hookFunctions = (List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{dataSourceConfig.postgresConfig().synchronousCommit().toList().map((Function1 & Serializable)synchCommitValue -> DataSourceStorageBackendImpl$.MODULE$.exe(new StringBuilder(26).append("SET synchronous_commit TO ").append(synchCommitValue.pgSqlName()).toString())), dataSourceConfig.postgresConfig().tcpKeepalivesIdle().toList().map((Function1 & Serializable)i -> DataSourceStorageBackendImpl$.MODULE$.exe(new StringBuilder(27).append("SET tcp_keepalives_idle TO ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), dataSourceConfig.postgresConfig().tcpKeepalivesInterval().toList().map((Function1 & Serializable)i -> DataSourceStorageBackendImpl$.MODULE$.exe(new StringBuilder(31).append("SET tcp_keepalives_interval TO ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), dataSourceConfig.postgresConfig().tcpKeepalivesCount().toList().map((Function1 & Serializable)i -> DataSourceStorageBackendImpl$.MODULE$.exe(new StringBuilder(28).append("SET tcp_keepalives_count TO ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), connectionInitHook.toList()}))).flatten(Predef$.MODULE$.$conforms());
        return InitHookDataSourceProxy$.MODULE$.apply((DataSource)pgSimpleDataSource, (List<Function1<Connection, BoxedUnit>>)hookFunctions, loggingContext);
    }

    @Override
    public void checkCompatibility(Connection connection, LoggingContext loggingContext) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<Object, Object>> option = this.getPostgresVersion(connection, loggingContext);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            int major = tuple2._1$mcI$sp();
            int minor = tuple2._2$mcI$sp();
            if (major < this.minMajorVersionSupported) {
                String errorMessage = new StringBuilder(166).append("Deprecated Postgres version. ").append(new StringBuilder(65).append("Found Postgres version ").append(major).append(".").append(minor).append(", minimum required Postgres version is ").append(this.minMajorVersionSupported).append(". ").toString()).append("This application will continue running but is at risk of data loss, as Postgres < 10 does not support crash-fault tolerant hash indices. ").append(new StringBuilder(77).append("Please upgrade your Postgres database to version ").append(this.minMajorVersionSupported).append(" or later to fix this issue.").toString()).toString();
                this.logger().error().apply((Function0 & Serializable)() -> errorMessage, loggingContext);
                throw new UnsupportedPostgresVersion(errorMessage);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logger().warn().apply((Function0 & Serializable)() -> "Could not determine the version of the Postgres database. Please verify that this application is compatible with this Postgres version.", loggingContext);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public Option<Tuple2<Object, Object>> getPostgresVersion(Connection connection, LoggingContext loggingContext) {
        String version = (String)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SHOW server_version"}))), (Seq)Nil$.MODULE$).as(SqlParser$.MODULE$.get(1, Column$.MODULE$.columnToString()).single(), connection);
        this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(23).append("Found Postgres version ").append(version).toString(), loggingContext);
        return this.parsePostgresVersion(version);
    }

    public Option<Tuple2<Object, Object>> parsePostgresVersion(String version) {
        None$ none$;
        Option option;
        Regex versionPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+)[.](\\d+).*"));
        String string = version;
        if (string != null && !(option = versionPattern.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String major = (String)((LinearSeqOps)option.get()).apply(0);
            String minor = (String)((LinearSeqOps)option.get()).apply(1);
            none$ = new Some((Object)new Tuple2.mcII.sp(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(major)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(minor))));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public void checkDatabaseAvailable(Connection connection) {
        DataSourceStorageBackendImpl$.MODULE$.checkDatabaseAvailable(connection);
    }

    public PostgresDataSourceStorageBackend(int minMajorVersionSupported) {
        this.minMajorVersionSupported = minMajorVersionSupported;
        DataSourceStorageBackend.$init$(this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }

    public static final class UnsupportedPostgresVersion
    extends RuntimeException
    implements ProgramResource.StartupException {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public UnsupportedPostgresVersion(String message) {
            super(message);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }
}

