/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao.events;

import com.daml.lf.data.Ref;
import com.daml.lf.data.Time;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.value.Value;
import com.daml.platform.package$;
import com.daml.platform.store.LfValueTranslationCache;
import com.daml.platform.store.backend.ContractStorageBackend;
import com.daml.platform.store.dao.events.ContractStateEvent;
import com.daml.platform.store.dao.events.ContractStateEventsReader;
import com.daml.platform.store.dao.events.ContractStateEventsReader$EventKind$;
import com.daml.platform.store.dao.events.LfValueTranslation;
import com.daml.platform.store.serialization.Compression;
import com.daml.platform.store.serialization.Compression$Algorithm$;
import com.daml.platform.store.serialization.ValueSerializer$;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;

public final class ContractStateEventsReader$ {
    public static final ContractStateEventsReader$ MODULE$ = new ContractStateEventsReader$();

    public ContractStateEvent toContractStateEvent(ContractStorageBackend.RawContractStateEvent raw, LfValueTranslation lfValueTranslation) {
        ContractStateEvent contractStateEvent;
        int n = raw.eventKind();
        if (ContractStateEventsReader$EventKind$.MODULE$.ConsumingExercise() == n) {
            Ref.Identifier templateId = (Ref.Identifier)raw.templateId().getOrElse((Function0 & Serializable)() -> {
                throw new ContractStateEventsReader.CreateMissingError("template_id");
            });
            Option<GlobalKey> maybeGlobalKey = this.decompressKey(templateId, raw.createKeyValue(), raw.createKeyCompression());
            contractStateEvent = new ContractStateEvent.Archived(raw.contractId(), maybeGlobalKey, raw.flatEventWitnesses(), raw.offset(), raw.eventSequentialId());
        } else if (ContractStateEventsReader$EventKind$.MODULE$.Create() == n) {
            Ref.Identifier templateId = (Ref.Identifier)raw.templateId().getOrElse((Function0 & Serializable)() -> {
                throw new ContractStateEventsReader.CreateMissingError("template_id");
            });
            byte[] createArgument = (byte[])raw.createArgument().getOrElse((Function0 & Serializable)() -> {
                throw new ContractStateEventsReader.CreateMissingError("create_argument");
            });
            Option<GlobalKey> maybeGlobalKey = this.decompressKey(templateId, raw.createKeyValue(), raw.createKeyCompression());
            Versioned<Value.ContractInstance> contract = this.getCachedOrDecompressContract(raw.contractId(), templateId, createArgument, raw.createArgumentCompression(), lfValueTranslation);
            contractStateEvent = new ContractStateEvent.Created(raw.contractId(), contract, maybeGlobalKey, (Time.Timestamp)raw.ledgerEffectiveTime().getOrElse((Function0 & Serializable)() -> {
                throw new ContractStateEventsReader.CreateMissingError("ledger_effective_time");
            }), raw.flatEventWitnesses(), raw.offset(), raw.eventSequentialId());
        } else {
            throw new ContractStateEventsReader.InvalidEventKind(n);
        }
        return contractStateEvent;
    }

    private Option<LfValueTranslationCache.ContractCache.Value> cachedContractValue(Value.ContractId contractId, LfValueTranslation lfValueTranslation) {
        return lfValueTranslation.cache().contracts().getIfPresent((Object)new LfValueTranslationCache.ContractCache.Key(contractId));
    }

    private Versioned<Value.ContractInstance> getCachedOrDecompressContract(Value.ContractId contractId, Ref.Identifier templateId, byte[] createArgument, Option<Object> maybeCreateArgumentCompression, LfValueTranslation lfValueTranslation) {
        Compression.Algorithm createArgumentCompression = Compression$Algorithm$.MODULE$.assertLookup(maybeCreateArgumentCompression);
        Versioned deserializedCreateArgument = (Versioned)this.cachedContractValue(contractId, lfValueTranslation).map((Function1 & Serializable)x$1 -> x$1.argument()).getOrElse((Function0 & Serializable)() -> MODULE$.decompressAndDeserialize(createArgumentCompression, createArgument));
        return package$.MODULE$.Contract().apply(templateId, deserializedCreateArgument, "");
    }

    private Option<GlobalKey> decompressKey(Ref.Identifier templateId, Option<byte[]> maybeCreateKeyValue, Option<Object> maybeCreateKeyValueCompression) {
        return maybeCreateKeyValue.map((Function1 & Serializable)createKeyValue -> {
            Compression.Algorithm createKeyValueCompression = Compression$Algorithm$.MODULE$.assertLookup(maybeCreateKeyValueCompression);
            Versioned<Value> keyValue = MODULE$.decompressAndDeserialize(createKeyValueCompression, (byte[])createKeyValue);
            return new Tuple3(createKeyValue, (Object)createKeyValueCompression, keyValue);
        }).map((Function1 & Serializable)x$2 -> {
            Tuple3 tuple3 = x$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Versioned keyValue = (Versioned)tuple3._3();
            GlobalKey globalKey = package$.MODULE$.Key().assertBuild(templateId, (Value)keyValue.unversioned());
            return globalKey;
        });
    }

    private Versioned<Value> decompressAndDeserialize(Compression.Algorithm algorithm, byte[] value) {
        return ValueSerializer$.MODULE$.deserializeValue(algorithm.decompress(new ByteArrayInputStream(value)));
    }

    private ContractStateEventsReader$() {
    }
}

