/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao.events;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.IndexErrors;
import com.daml.ledger.offset.Offset;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.value.Value;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.metrics.Timed$;
import com.daml.platform.store.backend.ContractStorageBackend;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.store.dao.events.ContractsReader$;
import com.daml.platform.store.interfaces.LedgerDaoContractsReader;
import com.daml.platform.store.serialization.Compression$Algorithm$;
import java.io.Serializable;
import java.sql.Connection;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b!B\n\u0015!Y\u0001\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0006\u0003\")q\t\u0001C\u0001\u0011\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006B\u0002-\u0001A\u0003%!\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011\u0011\u000e\u0001\u0005B\u0005-t\u0001CA@)!\u0005a#!!\u0007\u000fM!\u0002\u0012\u0001\f\u0002\u0004\"1q)\u0004C\u0001\u0003\u000bC\u0001\"a\"\u000e\t\u00031\u0012\u0011\u0012\u0005\b\u0003+kA\u0011BAL\u0011\u001d\t)*\u0004C\u0005\u0003CDq!a:\u000e\t\u0013\tIOA\bD_:$(/Y2ugJ+\u0017\rZ3s\u0015\t)b#\u0001\u0004fm\u0016tGo\u001d\u0006\u0003/a\t1\u0001Z1p\u0015\tI\"$A\u0003ti>\u0014XM\u0003\u0002\u001c9\u0005A\u0001\u000f\\1uM>\u0014XN\u0003\u0002\u001e=\u0005!A-Y7m\u0015\u0005y\u0012aA2p[N\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA3&D\u0001*\u0015\tQ\u0003$\u0001\u0006j]R,'OZ1dKNL!\u0001L\u0015\u000311+GmZ3s\t\u0006|7i\u001c8ue\u0006\u001cGo\u001d*fC\u0012,'/\u0001\bti>\u0014\u0018mZ3CC\u000e\\WM\u001c3\u0004\u0001A\u0011\u0001gM\u0007\u0002c)\u0011!\u0007G\u0001\bE\u0006\u001c7.\u001a8e\u0013\t!\u0014G\u0001\fD_:$(/Y2u'R|'/Y4f\u0005\u0006\u001c7.\u001a8e\u0003)!\u0017n\u001d9bi\u000eDWM\u001d\t\u0003oaj\u0011AF\u0005\u0003sY\u0011A\u0002\u00122ESN\u0004\u0018\r^2iKJ\fq!\\3ue&\u001c7\u000f\u0005\u0002=}5\tQH\u0003\u0002;9%\u0011q(\u0010\u0002\b\u001b\u0016$(/[2t\u0003\t)7\r\u0005\u0002C\u000b6\t1I\u0003\u0002EG\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0019\u001b%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q!\u0011*\u0014(P)\tQE\n\u0005\u0002L\u00015\tA\u0003C\u0003A\u000b\u0001\u000f\u0011\tC\u0003.\u000b\u0001\u0007q\u0006C\u00036\u000b\u0001\u0007a\u0007C\u0003;\u000b\u0001\u00071(\u0001\u0004m_\u001e<WM]\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011Q\u000bH\u0001\bY><w-\u001b8h\u0013\t9FK\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u00039awn\\6va.+\u0017p\u0015;bi\u0016$Ba\u0017=\u0002\u0004Q\u0011Al\u001d\t\u0004\u0005v{\u0016B\u00010D\u0005\u00191U\u000f^;sKB\u0011\u0001\r\u001d\b\u0003C:t!AY7\u000f\u0005\rdgB\u00013l\u001d\t)'N\u0004\u0002gS6\tqM\u0003\u0002i]\u00051AH]8pizJ\u0011aH\u0005\u0003;yI!a\u0007\u000f\n\u0005eQ\u0012B\u0001\u0016\u0019\u0013\ty\u0017&\u0001\rMK\u0012<WM\u001d#b_\u000e{g\u000e\u001e:bGR\u001c(+Z1eKJL!!\u001d:\u0003\u0011-+\u0017p\u0015;bi\u0016T!a\\\u0015\t\u000bQD\u00019A;\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB\u00111K^\u0005\u0003oR\u0013a\u0002T8hO&twmQ8oi\u0016DH\u000fC\u0003z\u0011\u0001\u0007!0A\u0002lKf\u0004\"a\u001f@\u000f\u0005\rd\u0018BA?\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005\rYU-\u001f\u0006\u0003{jAq!!\u0002\t\u0001\u0004\t9!A\u0004wC2LG-\u0011;\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u00051qN\u001a4tKRT1!!\u0005\u001d\u0003\u0019aW\rZ4fe&!\u0011QCA\u0006\u0005\u0019yeMZ:fi\u0006\u0019Bn\\8lkB\u001cuN\u001c;sC\u000e$8\u000b^1uKR1\u00111DA\u0017\u0003o!B!!\b\u0002,A!!)XA\u0010!\u0015\u0011\u0013\u0011EA\u0013\u0013\r\t\u0019c\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0001\f9#C\u0002\u0002*I\u0014QbQ8oiJ\f7\r^*uCR,\u0007\"\u0002;\n\u0001\b)\bbBA\u0018\u0013\u0001\u0007\u0011\u0011G\u0001\u000bG>tGO]1di&#\u0007cA>\u00024%!\u0011QGA\u0001\u0005)\u0019uN\u001c;sC\u000e$\u0018\n\u001a\u0005\b\u0003sI\u0001\u0019AA\u0004\u0003\u0019\u0011WMZ8sK\u0006\u0019Cn\\8lkB\f5\r^5wK\u000e{g\u000e\u001e:bGR\fe\u000e\u001a'pC\u0012\f%oZ;nK:$HCBA \u0003\u001b\n9\u0007\u0006\u0003\u0002B\u0005-\u0003\u0003\u0002\"^\u0003\u0007\u0002RAIA\u0011\u0003\u000b\u00022a_A$\u0013\u0011\tI%!\u0001\u0003\u0011\r{g\u000e\u001e:bGRDQ\u0001\u001e\u0006A\u0004UDq!a\u0014\u000b\u0001\u0004\t\t&A\u0004sK\u0006$WM]:\u0011\r\u0005M\u00131LA1\u001d\u0011\t)&a\u0016\u0011\u0005\u0019\u001c\u0013bAA-G\u00051\u0001K]3eK\u001aLA!!\u0018\u0002`\t\u00191+\u001a;\u000b\u0007\u0005e3\u0005E\u0002|\u0003GJA!!\u001a\u0002\u0002\t)\u0001+\u0019:us\"9\u0011q\u0006\u0006A\u0002\u0005E\u0012A\n7p_.,\b/Q2uSZ,7i\u001c8ue\u0006\u001cGoV5uQ\u000e\u000b7\r[3e\u0003J<W/\\3oiRA\u0011QNA9\u0003g\n)\b\u0006\u0003\u0002B\u0005=\u0004\"\u0002;\f\u0001\b)\bbBA(\u0017\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003_Y\u0001\u0019AA\u0019\u0011\u001d\t9h\u0003a\u0001\u0003s\nab\u0019:fCR,\u0017I]4v[\u0016tG\u000fE\u0002|\u0003wJA!! \u0002\u0002\t)a+\u00197vK\u0006y1i\u001c8ue\u0006\u001cGo\u001d*fC\u0012,'\u000f\u0005\u0002L\u001bM\u0011Q\"\t\u000b\u0003\u0003\u0003\u000bQ!\u00199qYf$\u0002\"a#\u0002\u0010\u0006E\u00151\u0013\u000b\u0004\u0015\u00065\u0005\"\u0002!\u0010\u0001\b\t\u0005\"B\u001b\u0010\u0001\u00041\u0004\"\u0002\u001e\u0010\u0001\u0004Y\u0004\"B\u0017\u0010\u0001\u0004y\u0013A\u0003;p\u0007>tGO]1diRq\u0011QIAM\u00037\u000b)+a-\u0002L\u0006u\u0007bBA\u0018!\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003;\u0003\u0002\u0019AAP\u0003)!X-\u001c9mCR,\u0017\n\u001a\t\u0005\u0003'\n\t+\u0003\u0003\u0002$\u0006}#AB*ue&tw\rC\u0004\u0002xA\u0001\r!a*\u0011\u000b\t\nI+!,\n\u0007\u0005-6EA\u0003BeJ\f\u0017\u0010E\u0002#\u0003_K1!!-$\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005U\u0006\u00031\u0001\u00028\u0006I2M]3bi\u0016\f%oZ;nK:$8i\\7qe\u0016\u001c8/[8o!\u0011\tI,!2\u000f\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0\u0019\u00035\u0019XM]5bY&T\u0018\r^5p]&!\u00111YA_\u0003-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\n\t\u0005\u001d\u0017\u0011\u001a\u0002\n\u00032<wN]5uQ6TA!a1\u0002>\"9\u0011Q\u001a\tA\u0002\u0005=\u0017A\u00053fG>l\u0007O]3tg&|g\u000eV5nKJ\u0004B!!5\u0002Z6\u0011\u00111\u001b\u0006\u0004u\u0005U'bAAl=\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002\\\u0006M'!\u0002+j[\u0016\u0014\bbBAp!\u0001\u0007\u0011qZ\u0001\u0015I\u0016\u001cXM]5bY&T\u0018\r^5p]RKW.\u001a:\u0015\r\u0005\u0015\u00131]As\u0011\u001d\ti*\u0005a\u0001\u0003?Cq!a\u001e\u0012\u0001\u0004\tI(A\u0007bgN,'\u000f\u001e)sKN,g\u000e^\u000b\u0005\u0003W\f)\u0010\u0006\u0003\u0002n\nmA\u0003BAx\u0005/!B!!=\u0003\bA!\u00111_A{\u0019\u0001!q!a>\u0013\u0005\u0004\tIPA\u0001U#\u0011\tYP!\u0001\u0011\u0007\t\ni0C\u0002\u0002\u0000\u000e\u0012qAT8uQ&tw\rE\u0002#\u0005\u0007I1A!\u0002$\u0005\r\te.\u001f\u0005\b\u0005\u0013\u0011\u00029\u0001B\u0006\u0003-)'O]8s\u0019><w-\u001a:\u0011\t\t5!1C\u0007\u0003\u0005\u001fQ1A!\u0005\u001d\u0003\u0015)'O]8s\u0013\u0011\u0011)Ba\u0004\u00033\r{g\u000e^3yiV\fG.\u001b>fI\u0016\u0013(o\u001c:M_\u001e<WM\u001d\u0005\b\u00053\u0011\u0002\u0019AAP\u0003\r)'O\u001d\u0005\b\u0005;\u0011\u0002\u0019\u0001B\u0010\u0003\tIg\u000eE\u0003#\u0003C\t\t\u0010")
public class ContractsReader
implements LedgerDaoContractsReader {
    private final ContractStorageBackend storageBackend;
    private final DbDispatcher dispatcher;
    private final Metrics metrics;
    private final ExecutionContext ec;
    private final ContextualizedLogger logger;

    private ContextualizedLogger logger() {
        return this.logger;
    }

    @Override
    public Future<LedgerDaoContractsReader.KeyState> lookupKeyState(GlobalKey key, Offset validAt, LoggingContext loggingContext) {
        return Timed$.MODULE$.future(this.metrics.daml().index().db().lookupKey(), (Function0 & Serializable)() -> $this.dispatcher.executeSql($this.metrics.daml().index().db().lookupContractByKeyDbMetrics(), (Function1 & Serializable)connection -> $this.storageBackend.keyState(key, validAt, (Connection)connection), loggingContext));
    }

    @Override
    public Future<Option<LedgerDaoContractsReader.ContractState>> lookupContractState(Value.ContractId contractId, Offset before, LoggingContext loggingContext) {
        DamlContextualizedErrorLogger errorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        return Timed$.MODULE$.future(this.metrics.daml().index().db().lookupActiveContract(), () -> ContractsReader.$anonfun$lookupContractState$1(this, contractId, before, loggingContext, (ContextualizedErrorLogger)errorLogger));
    }

    @Override
    public Future<Option<Versioned<Value.ContractInstance>>> lookupActiveContractAndLoadArgument(Set<String> readers, Value.ContractId contractId, LoggingContext loggingContext) {
        return Timed$.MODULE$.future(this.metrics.daml().index().db().lookupActiveContract(), (Function0 & Serializable)() -> $this.dispatcher.executeSql($this.metrics.daml().index().db().lookupActiveContractDbMetrics(), (Function1 & Serializable)connection -> $this.storageBackend.activeContractWithArgument(readers, contractId, (Connection)connection), loggingContext).map((Function1 & Serializable)x$2 -> x$2.map((Function1 & Serializable)raw -> ContractsReader$.MODULE$.com$daml$platform$store$dao$events$ContractsReader$$toContract(contractId, raw.templateId(), raw.createArgument(), Compression$Algorithm$.MODULE$.assertLookup(raw.createArgumentCompression()), $this.metrics.daml().index().db().lookupActiveContractDbMetrics().compressionTimer(), $this.metrics.daml().index().db().lookupActiveContractDbMetrics().translationTimer())), $this.ec));
    }

    @Override
    public Future<Option<Versioned<Value.ContractInstance>>> lookupActiveContractWithCachedArgument(Set<String> readers, Value.ContractId contractId, Versioned<Value> createArgument, LoggingContext loggingContext) {
        return Timed$.MODULE$.future(this.metrics.daml().index().db().lookupActiveContract(), (Function0 & Serializable)() -> $this.dispatcher.executeSql($this.metrics.daml().index().db().lookupActiveContractDbMetrics(), (Function1 & Serializable)connection -> $this.storageBackend.activeContractWithoutArgument(readers, contractId, (Connection)connection), loggingContext).map((Function1 & Serializable)x$3 -> x$3.map((Function1 & Serializable)templateId -> ContractsReader$.MODULE$.com$daml$platform$store$dao$events$ContractsReader$$toContract((String)templateId, createArgument)), $this.ec));
    }

    public static final /* synthetic */ Future $anonfun$lookupContractState$1(ContractsReader $this, Value.ContractId contractId$1, Offset before$1, LoggingContext loggingContext$2, ContextualizedErrorLogger errorLogger$1) {
        return $this.dispatcher.executeSql($this.metrics.daml().index().db().lookupActiveContractDbMetrics(), (Function1 & Serializable)connection -> $this.storageBackend.contractState(contractId$1, before$1, (Connection)connection), loggingContext$2).map((Function1 & Serializable)x$1 -> x$1.map((Function1 & Serializable)x0$1 -> {
            LedgerDaoContractsReader.ContractState contractState;
            ContractStorageBackend.RawContractState rawContractState = x0$1;
            if (rawContractState.eventKind() == 10) {
                Versioned<Value.ContractInstance> contract = ContractsReader$.MODULE$.com$daml$platform$store$dao$events$ContractsReader$$toContract(contractId$1, ContractsReader$.MODULE$.com$daml$platform$store$dao$events$ContractsReader$$assertPresent(rawContractState.templateId(), "template_id must be present for a create event", errorLogger$1), ContractsReader$.MODULE$.com$daml$platform$store$dao$events$ContractsReader$$assertPresent(rawContractState.createArgument(), "create_argument must be present for a create event", errorLogger$1), Compression$Algorithm$.MODULE$.assertLookup(rawContractState.createArgumentCompression()), $this.metrics.daml().index().db().lookupActiveContractDbMetrics().compressionTimer(), $this.metrics.daml().index().db().lookupActiveContractDbMetrics().translationTimer());
                contractState = new LedgerDaoContractsReader.ActiveContract(contract, rawContractState.flatEventWitnesses(), ContractsReader$.MODULE$.com$daml$platform$store$dao$events$ContractsReader$$assertPresent(rawContractState.ledgerEffectiveTime(), "ledger_effective_time must be present for a create event", errorLogger$1));
            } else if (rawContractState.eventKind() == 20) {
                contractState = new LedgerDaoContractsReader.ArchivedContract(rawContractState.flatEventWitnesses());
            } else {
                throw new IndexErrors.DatabaseErrors$.ResultSetError$.Reject(new StringBuilder(22).append("Unexpected event kind ").append(rawContractState.eventKind()).toString(), errorLogger$1).asGrpcError();
            }
            return contractState;
        }), $this.ec);
    }

    public ContractsReader(ContractStorageBackend storageBackend, DbDispatcher dispatcher, Metrics metrics, ExecutionContext ec) {
        this.storageBackend = storageBackend;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
        this.ec = ec;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

