/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao.events;

import akka.Done;
import akka.NotUsed;
import akka.NotUsed$;
import akka.stream.Graph;
import akka.stream.scaladsl.FlowOpsMat;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.codahale.metrics.Timer;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.ledger.api.TraceIdentifiers$;
import com.daml.ledger.api.v1.active_contracts_service.GetActiveContractsResponse;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.api.v1.transaction.TransactionTree;
import com.daml.ledger.api.v1.transaction.TreeEvent;
import com.daml.ledger.api.v1.transaction_service.GetFlatTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionTreesResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsResponse;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.offset.Offset$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Time;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.DatabaseMetrics;
import com.daml.metrics.InstrumentedGraph;
import com.daml.metrics.InstrumentedGraph$;
import com.daml.metrics.Metrics;
import com.daml.metrics.Timed$;
import com.daml.platform.ApiOffset$;
import com.daml.platform.store.backend.ContractStorageBackend;
import com.daml.platform.store.backend.EventStorageBackend;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.store.dao.LedgerDaoTransactionsReader;
import com.daml.platform.store.dao.PaginatingAsyncStream$;
import com.daml.platform.store.dao.events.ACSReader;
import com.daml.platform.store.dao.events.ContractStateEvent;
import com.daml.platform.store.dao.events.ContractStateEventsReader$;
import com.daml.platform.store.dao.events.EventsRange;
import com.daml.platform.store.dao.events.EventsRange$;
import com.daml.platform.store.dao.events.EventsTable$TransactionConversions$;
import com.daml.platform.store.dao.events.EventsTableFlatEventsRangeQueries;
import com.daml.platform.store.dao.events.LfValueTranslation;
import com.daml.platform.store.dao.events.QueryNonPruned;
import com.daml.platform.store.dao.events.Raw;
import com.daml.platform.store.dao.events.TransactionLogUpdatesReader$;
import com.daml.platform.store.dao.events.TransactionsReader$;
import com.daml.platform.store.interfaces.TransactionLogUpdate;
import com.daml.platform.store.utils.Telemetry$Transactions$;
import com.daml.telemetry.Event;
import com.daml.telemetry.SpanAttribute$;
import com.daml.telemetry.Spans$;
import io.opentelemetry.api.trace.Span;
import java.io.Serializable;
import java.sql.Connection;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011Ud!B\u0017/\u0005AR\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003\\\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011%\u0004!\u0011!Q\u0001\n)D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006YA\u001c\u0005\u0006i\u0002!\t!\u001e\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"!\t\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003KA\u0001\"!\u000e\u0001A\u0003%\u0011q\u0005\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003sA\u0001\"!\u0013\u0001A\u0003%\u00111\b\u0005\n\u0003\u0017\u0002!\u0019!C\u0005\u0003\u001bB\u0001\"a\u0017\u0001A\u0003%\u0011q\n\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003?Bq!!\u0019\u0001A\u0003%1\fC\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002\u0010\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAv\u0001\u0011%\u0011Q\u001e\u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0011\u001d\u0011y\u0006\u0001C!\u0005CBqAa+\u0001\t\u0003\u0012i\u000bC\u0004\u0003@\u0002!\tE!1\t\u000f\tU\u0007\u0001\"\u0011\u0003X\"9!\u0011 \u0001\u0005\n\tm\bbBB\u0012\u0001\u0011\u00053Q\u0005\u0005\b\u0007\u0003\u0002A\u0011IB\"\u0011\u001d\u0019I\u0006\u0001C\u0005\u00077Bqa!\u001e\u0001\t\u0013\u00199\bC\u0004\u0004\u0002\u0002!Iaa!\t\u000f\r5\u0005\u0001\"\u0003\u0004\u0010\"911\u001e\u0001\u0005\n\r5x\u0001\u0003C\u0014]!\u0005\u0001\u0007\"\u000b\u0007\u000f5r\u0003\u0012\u0001\u0019\u0005,!1A\u000f\u000bC\u0001\t[A\u0001\u0002b\f)\t\u0003\u0001D\u0011\u0007\u0005\b\t\u0007BC\u0011\u0002C#\u0011\u001d!y\u0005\u000bC\u0001\t#\u0012!\u0003\u0016:b]N\f7\r^5p]N\u0014V-\u00193fe*\u0011q\u0006M\u0001\u0007KZ,g\u000e^:\u000b\u0005E\u0012\u0014a\u00013b_*\u00111\u0007N\u0001\u0006gR|'/\u001a\u0006\u0003kY\n\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u0003oa\nA\u0001Z1nY*\t\u0011(A\u0002d_6\u001c2\u0001A\u001eB!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fMB\u0011!iQ\u0007\u0002a%\u0011A\t\r\u0002\u001c\u0019\u0016$w-\u001a:EC>$&/\u00198tC\u000e$\u0018n\u001c8t%\u0016\fG-\u001a:\u0002\u0015\u0011L7\u000f]1uG\",'o\u0001\u0001\u0011\u0005\tC\u0015BA%1\u00051!%\rR5ta\u0006$8\r[3s\u00039\tX/\u001a:z\u001d>t\u0007K];oK\u0012\u0004\"\u0001T'\u000e\u00039J!A\u0014\u0018\u0003\u001dE+XM]=O_:\u0004&/\u001e8fI\u0006\u0019RM^3oiN#xN]1hK\n\u000b7m[3oIB\u0011\u0011\u000bV\u0007\u0002%*\u00111KM\u0001\bE\u0006\u001c7.\u001a8e\u0013\t)&KA\nFm\u0016tGo\u0015;pe\u0006<WMQ1dW\u0016tG-\u0001\fd_:$(/Y2u'R|'/Y4f\u0005\u0006\u001c7.\u001a8e!\t\t\u0006,\u0003\u0002Z%\n12i\u001c8ue\u0006\u001cGo\u0015;pe\u0006<WMQ1dW\u0016tG-\u0001\u0005qC\u001e,7+\u001b>f!\taD,\u0003\u0002^{\t\u0019\u0011J\u001c;\u00025\u00154XM\u001c;Qe>\u001cWm]:j]\u001e\u0004\u0016M]1mY\u0016d\u0017n]7\u0002\u000f5,GO]5dgB\u0011\u0011mY\u0007\u0002E*\u0011qLN\u0005\u0003I\n\u0014q!T3ue&\u001c7/\u0001\nmMZ\u000bG.^3Ue\u0006t7\u000f\\1uS>t\u0007C\u0001'h\u0013\tAgF\u0001\nMMZ\u000bG.^3Ue\u0006t7\u000f\\1uS>t\u0017!C1dgJ+\u0017\rZ3s!\ta5.\u0003\u0002m]\tI\u0011iQ*SK\u0006$WM]\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\"a\u001c:\u000e\u0003AT!!]\u001f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002ta\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019YL(p\u001f?~}~\f\t!a\u0001\u0015\u0005]D\bC\u0001'\u0001\u0011\u0015i7\u0002q\u0001o\u0011\u0015)5\u00021\u0001H\u0011\u0015Q5\u00021\u0001L\u0011\u0015y5\u00021\u0001Q\u0011\u001516\u00021\u0001X\u0011\u0015Q6\u00021\u0001\\\u0011\u0015q6\u00021\u0001\\\u0011\u0015y6\u00021\u0001a\u0011\u0015)7\u00021\u0001g\u0011\u0015I7\u00021\u0001k\u0003%!'-T3ue&\u001c7/\u0006\u0002\u0002\n9!\u00111BA\u000e\u001d\u0011\ti!!\u0006\u000f\t\u0005=\u00111\u0003\b\u0004\u0003#9Q\"\u0001\u0001\n\u0005]\u001a\u0017\u0002BA\f\u00033\tQ!\u001b8eKbT!aN2\n\t\u0005u\u0011qD\u0001\u0003I\nTA!a\u0006\u0002\u001a\u0005QAMY'fiJL7m\u001d\u0011\u0002!\u00154XM\u001c;TKFLEMU3bI\u0016\u0014XCAA\u0014!\u0011\tI#a\f\u000f\u00071\u000bY#C\u0002\u0002.9\n1\"\u0012<f]R\u001c(+\u00198hK&!\u0011\u0011GA\u001a\u0005A)e/\u001a8u'\u0016\f\u0018\n\u001a*fC\u0012,'OC\u0002\u0002.9\n\u0011#\u001a<f]R\u001cV-]%e%\u0016\fG-\u001a:!\u0003=9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cXCAA\u001e!\u0011\ti$a\u0011\u000f\u00071\u000by$C\u0002\u0002B9\n\u0011%\u0012<f]R\u001cH+\u00192mK\u001ac\u0017\r^#wK:$8OU1oO\u0016\fV/\u001a:jKNLA!!\u0012\u0002H\tyq)\u001a;Ue\u0006t7/Y2uS>t7OC\u0002\u0002B9\n\u0001cZ3u)J\fgn]1di&|gn\u001d\u0011\u0002\r1|wmZ3s+\t\ty\u0005\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)FN\u0001\bY><w-\u001b8h\u0013\u0011\tI&a\u0015\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\nac\\;uaV$8\u000b\u001e:fC6\u0014UO\u001a4feNK'0Z\u000b\u00027\u00069r.\u001e;qkR\u001cFO]3b[\n+hMZ3s'&TX\rI\u0001\n_\u001a47/\u001a;G_J$B!a\u001a\u0002xA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014AB8gMN,GOC\u0002\u0002rY\na\u0001\\3eO\u0016\u0014\u0018\u0002BA;\u0003W\u0012aa\u00144gg\u0016$\bbBA=-\u0001\u0007\u00111P\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011QPAF\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015a\u0005;sC:\u001c\u0018m\u0019;j_:|6/\u001a:wS\u000e,'\u0002BAC\u0003\u000f\u000b!A^\u0019\u000b\t\u0005%\u0015qN\u0001\u0004CBL\u0017\u0002BAG\u0003\u007f\u0012qcR3u)J\fgn]1di&|gn\u001d*fgB|gn]3\u0015\t\u0005\u001d\u0014\u0011\u0013\u0005\b\u0003s:\u0002\u0019AAJ!\u0011\ti(!&\n\t\u0005]\u0015q\u0010\u0002\u001c\u000f\u0016$HK]1og\u0006\u001cG/[8o)J,Wm\u001d*fgB|gn]3\u0002!\u0011,7/\u001a:jC2L'0Z#wK:$X\u0003BAO\u0003[#B!a(\u0002bR!\u0011\u0011UAe)\u0011\t\u0019+a0\u0011\u000b=\f)+!+\n\u0007\u0005\u001d\u0006O\u0001\u0004GkR,(/\u001a\t\u0005\u0003W\u000bi\u000b\u0004\u0001\u0005\u000f\u0005=\u0006D1\u0001\u00022\n\tQ)\u0005\u0003\u00024\u0006e\u0006c\u0001\u001f\u00026&\u0019\u0011qW\u001f\u0003\u000f9{G\u000f[5oOB\u0019A(a/\n\u0007\u0005uVHA\u0002B]fDq!!1\u0019\u0001\b\t\u0019-\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\t\u0005E\u0013QY\u0005\u0005\u0003\u000f\f\u0019F\u0001\bM_\u001e<\u0017N\\4D_:$X\r\u001f;\t\u000f\u0005-\u0007\u00041\u0001\u0002N\u0006)QM\u001c;ssB1\u0011qZAk\u00037t1!UAi\u0013\r\t\u0019NU\u0001\u0014\u000bZ,g\u000e^*u_J\fw-\u001a\"bG.,g\u000eZ\u0005\u0005\u0003/\fINA\u0003F]R\u0014\u0018PC\u0002\u0002TJ\u0003R\u0001TAo\u0003SK1!a8/\u0005\r\u0011\u0016m\u001e\u0005\b\u0003GD\u0002\u0019AAs\u0003\u001d1XM\u001d2pg\u0016\u00042\u0001PAt\u0013\r\tI/\u0010\u0002\b\u0005>|G.Z1o\u0003A!Wm]3sS\u0006d\u0017N_3F]R\u0014\u00180\u0006\u0003\u0002p\u0006mH\u0003BAy\u0005\u000b!B!a=\u0002\u0000R!\u0011Q_A\u007f!\u0015y\u0017QUA|!\u0019\ty-!6\u0002zB!\u00111VA~\t\u001d\ty+\u0007b\u0001\u0003cCq!!1\u001a\u0001\b\t\u0019\rC\u0004\u0002Lf\u0001\rA!\u0001\u0011\r\u0005=\u0017Q\u001bB\u0002!\u0015a\u0015Q\\A}\u0011\u001d\t\u0019/\u0007a\u0001\u0003K\f1cZ3u\r2\fG\u000f\u0016:b]N\f7\r^5p]N$\"Ba\u0003\u00032\tU\"\u0011\bB/)\u0011\u0011iAa\f\u0011\u0011\t=!Q\u0004B\u0011\u0005Oi!A!\u0005\u000b\t\tM!QC\u0001\tg\u000e\fG.\u00193tY*!!q\u0003B\r\u0003\u0019\u0019HO]3b[*\u0011!1D\u0001\u0005C.\\\u0017-\u0003\u0003\u0003 \tE!AB*pkJ\u001cW\rE\u0004=\u0005G\t9'a\u001f\n\u0007\t\u0015RH\u0001\u0004UkBdWM\r\t\u0005\u0005S\u0011Y#\u0004\u0002\u0003\u001a%!!Q\u0006B\r\u0005\u001dqu\u000e^+tK\u0012Dq!!1\u001b\u0001\b\t\u0019\rC\u0004\u00034i\u0001\r!a\u001a\u0002\u001dM$\u0018M\u001d;Fq\u000edWo]5wK\"9!q\u0007\u000eA\u0002\u0005\u001d\u0014\u0001D3oI&s7\r\\;tSZ,\u0007b\u0002B\u001e5\u0001\u0007!QH\u0001\u0007M&dG/\u001a:\u0011\t\t}\"q\u000b\b\u0005\u0005\u0003\u0012\u0019F\u0004\u0003\u0003D\tEc\u0002\u0002B#\u0005\u001frAAa\u0012\u0003N5\u0011!\u0011\n\u0006\u0004\u0005\u00172\u0015A\u0002\u001fs_>$h(C\u0001:\u0013\t9\u0004(\u0003\u00026m%\u0019!Q\u000b\u001b\u0002\u000fA\f7m[1hK&!!\u0011\fB.\u000591\u0015\u000e\u001c;feJ+G.\u0019;j_:T1A!\u00165\u0011\u001d\t\u0019O\u0007a\u0001\u0003K\f\u0011\u0004\\8pWV\u0004h\t\\1u)J\fgn]1di&|gNQ=JIR1!1\rB;\u0005##BA!\u001a\u0003tA)q.!*\u0003hA)AH!\u001b\u0003n%\u0019!1N\u001f\u0003\r=\u0003H/[8o!\u0011\tiHa\u001c\n\t\tE\u0014q\u0010\u0002\u001b\u000f\u0016$h\t\\1u)J\fgn]1di&|gNU3ta>t7/\u001a\u0005\b\u0003\u0003\\\u00029AAb\u0011\u001d\u00119h\u0007a\u0001\u0005s\nQ\u0002\u001e:b]N\f7\r^5p]&#\u0007\u0003\u0002B>\u0005\u0017sAA! \u0003\b6\u0011!q\u0010\u0006\u0005\u0005\u0003\u0013\u0019)\u0001\u0003eCR\f'b\u0001BCm\u0005\u0011ANZ\u0005\u0005\u0005\u0013\u0013y(A\u0002SK\u001aLAA!$\u0003\u0010\niAK]1og\u0006\u001cG/[8o\u0013\u0012TAA!#\u0003\u0000!9!1S\u000eA\u0002\tU\u0015!\u0005:fcV,7\u000f^5oOB\u000b'\u000f^5fgB1!q\u0013BP\u0005KsAA!'\u0003\u001cB\u0019!qI\u001f\n\u0007\tuU(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005C\u0013\u0019KA\u0002TKRT1A!(>!\u0011\u0011yDa*\n\t\t%&1\f\u0002\u0006!\u0006\u0014H/_\u0001\u0014O\u0016$HK]1og\u0006\u001cG/[8o)J,Wm\u001d\u000b\u000b\u0005_\u00139L!/\u0003<\nuF\u0003\u0002BY\u0005k\u0003\u0002Ba\u0004\u0003\u001e\tM&q\u0005\t\by\t\r\u0012qMAJ\u0011\u001d\t\t\r\ba\u0002\u0003\u0007DqAa\r\u001d\u0001\u0004\t9\u0007C\u0004\u00038q\u0001\r!a\u001a\t\u000f\tME\u00041\u0001\u0003\u0016\"9\u00111\u001d\u000fA\u0002\u0005\u0015\u0018!\u00077p_.,\b\u000f\u0016:b]N\f7\r^5p]R\u0013X-\u001a\"z\u0013\u0012$bAa1\u0003R\nMG\u0003\u0002Bc\u0005\u001f\u0004Ra\\AS\u0005\u000f\u0004R\u0001\u0010B5\u0005\u0013\u0004B!! \u0003L&!!QZA@\u0005Y9U\r\u001e+sC:\u001c\u0018m\u0019;j_:\u0014Vm\u001d9p]N,\u0007bBAa;\u0001\u000f\u00111\u0019\u0005\b\u0005oj\u0002\u0019\u0001B=\u0011\u001d\u0011\u0019*\ba\u0001\u0005+\u000b\u0001dZ3u)J\fgn]1di&|g\u000eT8h+B$\u0017\r^3t)\u0019\u0011IN!>\u0003xR!!1\u001cBz!!\u0011yA!\b\u0003^\n\u001d\u0002c\u0002\u001f\u0003$\t}'q\u001d\t\by\t\r\u0012q\rBq!\ra$1]\u0005\u0004\u0005Kl$\u0001\u0002'p]\u001e\u0004BA!;\u0003p6\u0011!1\u001e\u0006\u0004\u0005[\u0014\u0014AC5oi\u0016\u0014h-Y2fg&!!\u0011\u001fBv\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8M_\u001e,\u0006\u000fZ1uK\"9\u0011\u0011\u0019\u0010A\u0004\u0005\r\u0007b\u0002B\u001a=\u0001\u0007!q\u001c\u0005\b\u0005oq\u0002\u0019\u0001Bp\u00035!x\u000e\u0016:b]N\f7\r^5p]R!!Q`B\u0006!\u0011\u0011yp!\u0002\u000f\t\t%8\u0011A\u0005\u0005\u0007\u0007\u0011Y/\u0001\u000bUe\u0006t7/Y2uS>tGj\\4Va\u0012\fG/Z\u0005\u0005\u0007\u000f\u0019IAA\u0006Ue\u0006t7/Y2uS>t'\u0002BB\u0002\u0005WDaaL\u0010A\u0002\r5\u0001CBB\b\u0007/\u0019iB\u0004\u0003\u0004\u0012\rUa\u0002\u0002B$\u0007'I\u0011AP\u0005\u0004\u0005+j\u0014\u0002BB\r\u00077\u0011aAV3di>\u0014(b\u0001B+{A!!q`B\u0010\u0013\u0011\u0019\tc!\u0003\u0003\u000b\u00153XM\u001c;\u0002%\u001d,G/Q2uSZ,7i\u001c8ue\u0006\u001cGo\u001d\u000b\t\u0007O\u0019Id!\u0010\u0004@Q!1\u0011FB\u001c!!\u0011yA!\b\u0004,\t\u001d\u0002\u0003BB\u0017\u0007gi!aa\f\u000b\t\rE\u00121Q\u0001\u0019C\u000e$\u0018N^3`G>tGO]1diN|6/\u001a:wS\u000e,\u0017\u0002BB\u001b\u0007_\u0011!dR3u\u0003\u000e$\u0018N^3D_:$(/Y2ugJ+7\u000f]8og\u0016Dq!!1!\u0001\b\t\u0019\rC\u0004\u0004<\u0001\u0002\r!a\u001a\u0002\u0011\u0005\u001cG/\u001b<f\u0003RDqAa\u000f!\u0001\u0004\u0011i\u0004C\u0004\u0002d\u0002\u0002\r!!:\u0002-\u001d,GoQ8oiJ\f7\r^*uCR,WI^3oiN$ba!\u0012\u0004V\r]C\u0003BB$\u0007'\u0002\u0002Ba\u0004\u0003\u001e\r%#q\u0005\t\by\t\r\"q\\B&!\u0019\u0019yaa\u0006\u0004NA\u0019Aja\u0014\n\u0007\rEcF\u0001\nD_:$(/Y2u'R\fG/Z#wK:$\bbBAaC\u0001\u000f\u00111\u0019\u0005\b\u0005g\t\u0003\u0019\u0001Bp\u0011\u001d\u00119$\ta\u0001\u0005?\fQB\\3yiB\u000bw-\u001a*b]\u001e,W\u0003BB/\u0007_\"Baa\u0018\u0004rQ!1\u0011MB4!\u0015a51\rBp\u0013\r\u0019)G\f\u0002\f\u000bZ,g\u000e^:SC:<W\rC\u0004\u0004j\t\u0002\raa\u001b\u0002\u0003\u0005\u0004b!a4\u0002V\u000e5\u0004\u0003BAV\u0007_\"q!a,#\u0005\u0004\t\t\fC\u0004\u0004t\t\u0002\rAa8\u0002\u001b\u0015tG-\u0012<f]R\u001cV-]%e\u0003U9W\r^!dg\u00163XM\u001c;TKFLEMU1oO\u0016$Ba!\u001f\u0004\u0000Q!11PB?!\u0015y\u0017QUB1\u0011\u001d\t\tm\ta\u0002\u0003\u0007Dqaa\u000f$\u0001\u0004\t9'\u0001\nhKR,e/\u001a8u'\u0016\f\u0018\n\u001a*b]\u001e,GCBBC\u0007\u0013\u001bY\t\u0006\u0003\u0004|\r\u001d\u0005bBAaI\u0001\u000f\u00111\u0019\u0005\b\u0005g!\u0003\u0019AA4\u0011\u001d\u00119\u0004\na\u0001\u0003O\nAb\u001d;sK\u0006lWI^3oiN,ba!%\u0004,\u000euECCBJ\u0007o\u001bIla1\u0004fR!1QSBY)\u0019\u00199ja(\u00040BA!q\u0002B\u000f\u00073\u00139\u0003\u0005\u0004\u0002P\u0006U71\u0014\t\u0005\u0003W\u001bi\nB\u0004\u00020\u0016\u0012\r!!-\t\u0013\r\u0005V%!AA\u0004\r\r\u0016AC3wS\u0012,gnY3%cA11qBBS\u0007SKAaa*\u0004\u001c\tAqJ\u001d3fe&tw\r\u0005\u0003\u0002,\u000e-FaBBWK\t\u0007\u0011\u0011\u0017\u0002\u0002\u0003\"9\u0011\u0011Y\u0013A\u0004\u0005\r\u0007bBBZK\u0001\u00071QW\u0001\u0006e\u0006tw-\u001a\t\u0006\u0019\u000e\r4\u0011\u0016\u0005\b\u0003G,\u0003\u0019AAs\u0011\u001d\u0019Y,\na\u0001\u0007{\u000b1\"];feflU\r\u001e:jGB\u0019\u0011ma0\n\u0007\r\u0005'MA\bECR\f'-Y:f\u001b\u0016$(/[2t\u0011\u001d\u0019)-\na\u0001\u0007\u000f\fQ!];fef\u0004r\u0001PBe\u0007k\u001bi-C\u0002\u0004Lv\u0012\u0011BR;oGRLwN\\\u0019\u0011\u000fq\u001aIma4\u0004`B!1\u0011[Bn\u001b\t\u0019\u0019N\u0003\u0003\u0004V\u000e]\u0017aA:rY*\u00111\u0011\\\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004^\u000eM'AC\"p]:,7\r^5p]B11qBB\f\u0007C\u0004b!a4\u0002V\u000e\r\b#\u0002'\u0002^\u000em\u0005bBBtK\u0001\u00071\u0011^\u0001\u0011O\u0016$h*\u001a=u!\u0006<WMU1oO\u0016\u0004r\u0001PBe\u00073\u001b),\u0001\u000bf]\u0012\u001c\u0006/\u00198P]R+'/\\5oCRLwN\\\u000b\u0007\u0007_\u001c)\u0010b\t\u0015\t\rEH\u0011\u0002\u000b\u0007\u0007g\u001cIp!@\u0011\t\u0005-6Q\u001f\u0003\b\u0007o4#\u0019AAY\u0005\ri\u0015\r\u001e\u0005\b\u0007w4\u0003\u0019ABz\u0003\ri\u0017\r\u001e\u0005\b\u0007\u007f4\u0003\u0019\u0001C\u0001\u0003\u0011!wN\\3\u0011\u000b=\f)\u000bb\u0001\u0011\t\t%BQA\u0005\u0005\t\u000f\u0011IB\u0001\u0003E_:,\u0007b\u0002C\u0006M\u0001\u0007AQB\u0001\u0005gB\fg\u000e\u0005\u0003\u0005\u0010\u0011}QB\u0001C\t\u0015\u0011!\u0019\u0002\"\u0006\u0002\u000bQ\u0014\u0018mY3\u000b\t\u0005%Eq\u0003\u0006\u0005\t3!Y\"A\u0007pa\u0016tG/\u001a7f[\u0016$(/\u001f\u0006\u0003\t;\t!![8\n\t\u0011\u0005B\u0011\u0003\u0002\u0005'B\fg\u000eB\u0004\u0005&\u0019\u0012\r!!-\u0003\u0007=+H/\u0001\nUe\u0006t7/Y2uS>t7OU3bI\u0016\u0014\bC\u0001')'\tA3\b\u0006\u0002\u0005*\u0005Q1\u000f\u001d7jiJ\u000bgnZ3\u0015\u0015\u0011MBq\u0007C\u001d\tw!y\u0004\u0005\u0004\u0004\u0010\r]AQ\u0007\t\u0006\u0019\u000e\r$\u0011\u001d\u0005\b\u0005gQ\u0003\u0019\u0001Bq\u0011\u001d\u00119D\u000ba\u0001\u0005CDa\u0001\"\u0010+\u0001\u0004Y\u0016A\u00048v[\n,'o\u00144DQVt7n\u001d\u0005\u0007\t\u0003R\u0003\u0019A.\u0002\u00195\f\u0007p\u00115v].\u001c\u0016N_3\u0002!M\u0004H.\u001b;SC:<W-\u00168tC\u001a,G\u0003\u0003C\u001a\t\u000f\"I\u0005\"\u0014\t\u000f\tM2\u00061\u0001\u0003b\"9A1J\u0016A\u0002\t\u0005\u0018!\u0003:b]\u001e,7+\u001b>f\u0011\u0019!id\u000ba\u00017\u0006yqM]8va\u000e{g\u000e^5hk>,8/\u0006\u0005\u0005T\u0011uC1\u000eC1)\u0011!)\u0006b\u001c\u0015\t\u0011]C1\r\t\t\u0005\u001f\u0011i\u0002\"\u0017\u0005`A11qBB\f\t7\u0002B!a+\u0005^\u001191Q\u0016\u0017C\u0002\u0005E\u0006\u0003BAV\tC\"qaa>-\u0005\u0004\t\t\fC\u0004\u0005f1\u0002\r\u0001b\u001a\u0002\u0005\tL\bc\u0002\u001f\u0004J\u0012mC\u0011\u000e\t\u0005\u0003W#Y\u0007B\u0004\u0005n1\u0012\r!!-\u0003\u0003-Cq\u0001\"\u001d-\u0001\u0004!\u0019(\u0001\u0004t_V\u00148-\u001a\t\t\u0005\u001f\u0011i\u0002b\u0017\u0005`\u0001")
public final class TransactionsReader
implements LedgerDaoTransactionsReader {
    private final DbDispatcher dispatcher;
    private final QueryNonPruned queryNonPruned;
    private final EventStorageBackend eventStorageBackend;
    private final ContractStorageBackend contractStorageBackend;
    private final int pageSize;
    private final int eventProcessingParallelism;
    private final Metrics metrics;
    private final LfValueTranslation lfValueTranslation;
    private final ACSReader acsReader;
    private final ExecutionContext executionContext;
    private final Metrics.daml$.index$.db$ dbMetrics;
    private final EventsRange.EventSeqIdReader eventSeqIdReader;
    private final EventsTableFlatEventsRangeQueries.GetTransactions getTransactions;
    private final ContextualizedLogger logger;
    private final int outputStreamBufferSize;

    public static <A, K, Mat> Source<Vector<A>, Mat> groupContiguous(Source<A, Mat> source, Function1<A, K> by) {
        return TransactionsReader$.MODULE$.groupContiguous(source, by);
    }

    private Metrics.daml$.index$.db$ dbMetrics() {
        return this.dbMetrics;
    }

    private EventsRange.EventSeqIdReader eventSeqIdReader() {
        return this.eventSeqIdReader;
    }

    private EventsTableFlatEventsRangeQueries.GetTransactions getTransactions() {
        return this.getTransactions;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private int outputStreamBufferSize() {
        return this.outputStreamBufferSize;
    }

    private Offset offsetFor(GetTransactionsResponse response) {
        return ApiOffset$.MODULE$.assertFromString(((Transaction)response.transactions().head()).offset());
    }

    private Offset offsetFor(GetTransactionTreesResponse response) {
        return ApiOffset$.MODULE$.assertFromString(((TransactionTree)response.transactions().head()).offset());
    }

    private <E> Future<E> deserializeEvent(boolean verbose, EventStorageBackend.Entry<Raw<E>> entry, LoggingContext loggingContext) {
        return entry.event().applyDeserialization(this.lfValueTranslation, verbose, this.executionContext, loggingContext);
    }

    private <E> Future<EventStorageBackend.Entry<E>> deserializeEntry(boolean verbose, EventStorageBackend.Entry<Raw<E>> entry, LoggingContext loggingContext) {
        return this.deserializeEvent(verbose, entry, loggingContext).map((Function1 & Serializable)event -> {
            Object x$1 = event;
            Offset x$2 = entry.copy$default$1();
            String x$3 = entry.copy$default$2();
            int x$4 = entry.copy$default$3();
            long x$5 = entry.copy$default$4();
            Time.Timestamp x$6 = entry.copy$default$5();
            String x$7 = entry.copy$default$6();
            String x$8 = entry.copy$default$7();
            return entry.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Raw)x$1);
        }, this.executionContext);
    }

    @Override
    public Source<Tuple2<Offset, GetTransactionsResponse>, NotUsed> getFlatTransactions(Offset startExclusive, Offset endInclusive, Map<String, Set<Ref.Identifier>> filter, boolean verbose, LoggingContext loggingContext) {
        Span span = Telemetry$Transactions$.MODULE$.createSpan(startExclusive, endInclusive, "com.daml.platform.store.dao.events.TransactionsReader.getFlatTransactions");
        this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(27).append("getFlatTransactions(").append(startExclusive).append(", ").append(endInclusive).append(", ").append(filter).append(", ").append(verbose).append(")").toString(), loggingContext);
        Future<EventsRange<Tuple2<Offset, Object>>> requestedRangeF = this.getEventSeqIdRange(startExclusive, endInclusive, loggingContext);
        Function1 & Serializable query = (Function1 & Serializable)range -> (Function1 & Serializable)connection -> {
            this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(27).append("getFlatTransactions query(").append(range).append(")").toString(), loggingContext);
            return (Vector)$this.queryNonPruned.executeSql((Function0 & Serializable)() -> (Vector)this.getTransactions().apply(new EventsRange<Long>(BoxesRunTime.boxToLong((long)((Tuple2)range.startExclusive())._2$mcJ$sp()), BoxesRunTime.boxToLong((long)((Tuple2)range.endInclusive())._2$mcJ$sp())), filter, $this.pageSize).apply(connection), (Offset)((Tuple2)range.startExclusive())._1(), (Function1<Offset, String>)(Function1 & Serializable)pruned -> new StringBuilder(54).append("Transactions request from ").append(((Offset)((Tuple2)range.startExclusive())._1()).toHexString()).append(" to ").append(((Offset)((Tuple2)range.endInclusive())._1()).toHexString()).append(" precedes pruned offset ").append(pruned.toHexString()).toString(), (Connection)connection, loggingContext);
        };
        Source events2 = Source$.MODULE$.futureSource(requestedRangeF.map((Function1 & Serializable)requestedRange -> this.streamEvents(verbose, this.dbMetrics().getFlatTransactions(), (Function1)query, (Function1 & Serializable)a -> this.nextPageRange((Tuple2<Offset, Object>)((Tuple2)requestedRange.endInclusive()), (EventStorageBackend.Entry)a), (EventsRange)requestedRange, (Ordering)Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), (Ordering)Ordering.Long$.MODULE$), loggingContext), this.executionContext)).mapMaterializedValue((Function1 & Serializable)x$1 -> NotUsed$.MODULE$);
        return (Source)((FlowOpsMat)TransactionsReader$.MODULE$.groupContiguous(events2, (Function1 & Serializable)x$2 -> x$2.transactionId()).mapConcat((Function1 & Serializable)events -> {
            List<GetTransactionsResponse> response = EventsTable$TransactionConversions$.MODULE$.toGetTransactionsResponse((Vector<EventStorageBackend.Entry<com.daml.ledger.api.v1.event.Event>>)events);
            return response.map((Function1 & Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.offsetFor((GetTransactionsResponse)r)), r));
        }).wireTap((Function1 & Serializable)x$3 -> {
            TransactionsReader.$anonfun$getFlatTransactions$13(span, x$3);
            return BoxedUnit.UNIT;
        })).watchTermination((Function2 & Serializable)(mat, done) -> this.endSpanOnTermination(span, mat, (Future<Done>)done));
    }

    @Override
    public Future<Option<GetFlatTransactionResponse>> lookupFlatTransactionById(String transactionId, Set<String> requestingParties, LoggingContext loggingContext) {
        EventStorageBackend.FilterParams filterParams = new EventStorageBackend.FilterParams(requestingParties, (Set<Tuple2<Set<String>, Set<Ref.Identifier>>>)Predef$.MODULE$.Set().empty());
        return this.dispatcher.executeSql(this.dbMetrics().lookupFlatTransactionById(), (Function1 & Serializable)connection -> $this.eventStorageBackend.flatTransaction(transactionId, filterParams, (Connection)connection), loggingContext).flatMap((Function1 & Serializable)rawEvents -> (Future)Timed$.MODULE$.value(this.dbMetrics().lookupFlatTransactionById().translationTimer(), (Function0 & Serializable)() -> Future$.MODULE$.traverse((IterableOnce)rawEvents, (Function1 & Serializable)entry -> this.deserializeEntry(true, (EventStorageBackend.Entry)entry, loggingContext), BuildFrom$.MODULE$.buildFromIterableOps(), $this.executionContext)), this.executionContext).map((Function1 & Serializable)events -> EventsTable$TransactionConversions$.MODULE$.toGetFlatTransactionResponse((Vector<EventStorageBackend.Entry<com.daml.ledger.api.v1.event.Event>>)events), this.executionContext);
    }

    @Override
    public Source<Tuple2<Offset, GetTransactionTreesResponse>, NotUsed> getTransactionTrees(Offset startExclusive, Offset endInclusive, Set<String> requestingParties, boolean verbose, LoggingContext loggingContext) {
        Span span = Telemetry$Transactions$.MODULE$.createSpan(startExclusive, endInclusive, "com.daml.platform.store.dao.events.TransactionsReader.getTransactionTrees");
        this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(27).append("getTransactionTrees(").append(startExclusive).append(", ").append(endInclusive).append(", ").append(requestingParties).append(", ").append(verbose).append(")").toString(), loggingContext);
        Future<EventsRange<Tuple2<Offset, Object>>> requestedRangeF = this.getEventSeqIdRange(startExclusive, endInclusive, loggingContext);
        Function1 & Serializable query = (Function1 & Serializable)range -> (Function1 & Serializable)connection -> {
            this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(27).append("getTransactionTrees query(").append(range).append(")").toString(), loggingContext);
            return (Vector)$this.queryNonPruned.executeSql((Function0 & Serializable)() -> (Vector)EventsRange$.MODULE$.readPage((Function3 & Serializable)(range, limit, fetchSizeHint) -> {
                EventStorageBackend.RangeParams rangeParams = new EventStorageBackend.RangeParams(BoxesRunTime.unboxToLong(range.startExclusive()), BoxesRunTime.unboxToLong(range.endInclusive()), (Option<Object>)limit, (Option<Object>)fetchSizeHint);
                EventStorageBackend.FilterParams filterParams = new EventStorageBackend.FilterParams(requestingParties, (Set<Tuple2<Set<String>, Set<Ref.Identifier>>>)Predef$.MODULE$.Set().empty());
                return (Function1 & Serializable)connection -> $this.eventStorageBackend.transactionTreeEvents(rangeParams, filterParams, (Connection)connection);
            }, new EventsRange<Object>(BoxesRunTime.boxToLong((long)((Tuple2)range.startExclusive())._2$mcJ$sp()), BoxesRunTime.boxToLong((long)((Tuple2)range.endInclusive())._2$mcJ$sp())), $this.pageSize).apply(connection), (Offset)((Tuple2)range.startExclusive())._1(), (Function1<Offset, String>)(Function1 & Serializable)pruned -> new StringBuilder(54).append("Transactions request from ").append(((Offset)((Tuple2)range.startExclusive())._1()).toHexString()).append(" to ").append(((Offset)((Tuple2)range.endInclusive())._1()).toHexString()).append(" precedes pruned offset ").append(pruned.toHexString()).toString(), (Connection)connection, loggingContext);
        };
        Source events2 = Source$.MODULE$.futureSource(requestedRangeF.map((Function1 & Serializable)requestedRange -> this.streamEvents(verbose, this.dbMetrics().getTransactionTrees(), (Function1)query, (Function1 & Serializable)a -> this.nextPageRange((Tuple2<Offset, Object>)((Tuple2)requestedRange.endInclusive()), (EventStorageBackend.Entry)a), (EventsRange)requestedRange, (Ordering)Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), (Ordering)Ordering.Long$.MODULE$), loggingContext), this.executionContext)).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
        return (Source)((FlowOpsMat)TransactionsReader$.MODULE$.groupContiguous(events2, (Function1 & Serializable)x$5 -> x$5.transactionId()).mapConcat((Function1 & Serializable)events -> {
            List<GetTransactionTreesResponse> response = EventsTable$TransactionConversions$.MODULE$.toGetTransactionTreesResponse((Vector<EventStorageBackend.Entry<TreeEvent>>)events);
            return response.map((Function1 & Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.offsetFor((GetTransactionTreesResponse)r)), r));
        }).wireTap((Function1 & Serializable)x$6 -> {
            TransactionsReader.$anonfun$getTransactionTrees$15(span, x$6);
            return BoxedUnit.UNIT;
        })).watchTermination((Function2 & Serializable)(mat, done) -> this.endSpanOnTermination(span, mat, (Future<Done>)done));
    }

    @Override
    public Future<Option<GetTransactionResponse>> lookupTransactionTreeById(String transactionId, Set<String> requestingParties, LoggingContext loggingContext) {
        EventStorageBackend.FilterParams filterParams = new EventStorageBackend.FilterParams(requestingParties, (Set<Tuple2<Set<String>, Set<Ref.Identifier>>>)Predef$.MODULE$.Set().empty());
        return this.dispatcher.executeSql(this.dbMetrics().lookupTransactionTreeById(), (Function1 & Serializable)connection -> $this.eventStorageBackend.transactionTree(transactionId, filterParams, (Connection)connection), loggingContext).flatMap((Function1 & Serializable)rawEvents -> (Future)Timed$.MODULE$.value(this.dbMetrics().lookupTransactionTreeById().translationTimer(), (Function0 & Serializable)() -> Future$.MODULE$.traverse((IterableOnce)rawEvents, (Function1 & Serializable)entry -> this.deserializeEntry(true, (EventStorageBackend.Entry)entry, loggingContext), BuildFrom$.MODULE$.buildFromIterableOps(), $this.executionContext)), this.executionContext).map((Function1 & Serializable)events -> EventsTable$TransactionConversions$.MODULE$.toGetTransactionResponse((Vector<EventStorageBackend.Entry<TreeEvent>>)events), this.executionContext);
    }

    @Override
    public Source<Tuple2<Tuple2<Offset, Object>, TransactionLogUpdate>, NotUsed> getTransactionLogUpdates(Tuple2<Offset, Object> startExclusive, Tuple2<Offset, Object> endInclusive, LoggingContext loggingContext) {
        Source endMarker = Source$.MODULE$.single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(endInclusive), (Object)new TransactionLogUpdate.LedgerEndMarker((Offset)endInclusive._1(), endInclusive._2$mcJ$sp())));
        Source eventsSource = (Source)((Source)Source$.MODULE$.fromIterator((Function0 & Serializable)() -> TransactionsReader$.MODULE$.splitRange(startExclusive._2$mcJ$sp(), endInclusive._2$mcJ$sp(), $this.eventProcessingParallelism, $this.pageSize).iterator()).map((Function1 & Serializable)range -> {
            $this.metrics.daml().services().index().getTransactionLogUpdatesChunkSize().update(BoxesRunTime.unboxToLong(range.endInclusive()) - BoxesRunTime.unboxToLong(range.startExclusive()));
            return range;
        }).mapAsync(this.eventProcessingParallelism, (Function1 & Serializable)range -> $this.dispatcher.executeSql(this.dbMetrics().getTransactionLogUpdates(), (Function1 & Serializable)conn -> (Vector)$this.queryNonPruned.executeSql((Function0 & Serializable)() -> $this.eventStorageBackend.rawEvents(BoxesRunTime.unboxToLong(range.startExclusive()), BoxesRunTime.unboxToLong(range.endInclusive()), (Connection)conn), (Offset)startExclusive._1(), (Function1<Offset, String>)(Function1 & Serializable)pruned -> new StringBuilder(62).append("Transaction log updates request after ").append(((Offset)startExclusive._1()).toHexString()).append(" precedes pruned offset ").append(pruned.toHexString()).toString(), (Connection)conn, loggingContext), loggingContext))).async().mapAsync(this.eventProcessingParallelism, (Function1 & Serializable)raw -> Timed$.MODULE$.future($this.metrics.daml().index().decodeTransactionLogUpdate(), (Function0 & Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable)() -> (Vector)raw.map((Function1 & Serializable)raw -> TransactionLogUpdatesReader$.MODULE$.toTransactionEvent((EventStorageBackend.RawTransactionEvent)raw)), $this.executionContext))).mapConcat((Function1 & Serializable)x -> (Vector)Predef$.MODULE$.identity(x));
        return (Source)InstrumentedGraph.BufferedSource$.MODULE$.buffered$extension(InstrumentedGraph$.MODULE$.BufferedSource(((Source)TransactionsReader$.MODULE$.groupContiguous(eventsSource, (Function1 & Serializable)x$7 -> x$7.transactionId()).map((Function1 & Serializable)v -> {
            TransactionLogUpdate.Transaction tx = this.toTransaction((Vector<TransactionLogUpdate.Event>)v);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)tx.offset(), (Object)BoxesRunTime.boxToLong((long)((TransactionLogUpdate.Event)tx.events().last()).eventSequentialId()))), (Object)tx);
        })).mapMaterializedValue((Function1 & Serializable)x$8 -> NotUsed$.MODULE$)), this.metrics.daml().index().transactionLogUpdatesBufferSize(), this.outputStreamBufferSize()).concat((Graph)endMarker);
    }

    private TransactionLogUpdate.Transaction toTransaction(Vector<TransactionLogUpdate.Event> events) {
        TransactionLogUpdate.Event first = (TransactionLogUpdate.Event)events.head();
        return new TransactionLogUpdate.Transaction(first.transactionId(), first.workflowId(), first.ledgerEffectiveTime(), first.eventOffset(), events);
    }

    @Override
    public Source<GetActiveContractsResponse, NotUsed> getActiveContracts(Offset activeAt, Map<String, Set<Ref.Identifier>> filter, boolean verbose, LoggingContext loggingContext) {
        DamlContextualizedErrorLogger contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        Span span = Telemetry$Transactions$.MODULE$.createSpan(activeAt, "com.daml.platform.store.dao.events.TransactionsReader.getActiveContracts");
        this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(24).append("getActiveContracts(").append(activeAt).append(", ").append(filter).append(", ").append(verbose).append(")").toString(), loggingContext);
        return (Source)((Source)Source$.MODULE$.futureSource(this.getAcsEventSeqIdRange(activeAt, loggingContext).map((Function1 & Serializable)requestedRange -> $this.acsReader.acsStream(filter, (Tuple2<Offset, Object>)((Tuple2)requestedRange.endInclusive()), loggingContext), this.executionContext)).mapAsync(this.eventProcessingParallelism, (Function1 & Serializable)rawResult -> {
            Function0 & Serializable x$1 = (Function0 & Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable)() -> Future$.MODULE$.traverse((IterableOnce)rawResult, (Function1 & Serializable)entry -> this.deserializeEntry(verbose, (EventStorageBackend.Entry)entry, loggingContext), BuildFrom$.MODULE$.buildFromIterableOps(), $this.executionContext), $this.executionContext).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), $this.executionContext);
            Timer x$2 = this.dbMetrics().getActiveContracts().translationTimer();
            return Timed$.MODULE$.future(x$2, (Function0)x$1);
        }).mapConcat((Function1 & Serializable)x$9 -> EventsTable$TransactionConversions$.MODULE$.toGetActiveContractsResponse((Vector<EventStorageBackend.Entry<com.daml.ledger.api.v1.event.Event>>)x$9, (ContextualizedErrorLogger)contextualizedErrorLogger)).wireTap((Function1 & Serializable)response -> {
            Spans$.MODULE$.addEventToSpan(new Event("contract", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SpanAttribute$.MODULE$.Offset(), (Object)response.offset())}))), span);
            return BoxedUnit.UNIT;
        })).mapMaterializedValue((Function1 & Serializable)x$10 -> NotUsed$.MODULE$).watchTermination((Function2 & Serializable)(mat, done) -> this.endSpanOnTermination(span, mat, (Future<Done>)done));
    }

    @Override
    public Source<Tuple2<Tuple2<Offset, Object>, Vector<ContractStateEvent>>, NotUsed> getContractStateEvents(Tuple2<Offset, Object> startExclusive, Tuple2<Offset, Object> endInclusive, LoggingContext loggingContext) {
        Source endMarker = Source$.MODULE$.single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(endInclusive), package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ContractStateEvent.LedgerEndMarker[]{new ContractStateEvent.LedgerEndMarker((Offset)endInclusive._1(), endInclusive._2$mcJ$sp())}))));
        Source contractStateEventsSource = (Source)((Source)Source$.MODULE$.fromIterator((Function0 & Serializable)() -> TransactionsReader$.MODULE$.splitRange(startExclusive._2$mcJ$sp(), endInclusive._2$mcJ$sp(), $this.eventProcessingParallelism, $this.pageSize).iterator()).map((Function1 & Serializable)range -> {
            $this.metrics.daml().services().index().getContractStateEventsChunkSize().update(BoxesRunTime.unboxToLong(range.endInclusive()) - BoxesRunTime.unboxToLong(range.startExclusive()));
            return range;
        }).mapAsync(this.eventProcessingParallelism, (Function1 & Serializable)range -> $this.dispatcher.executeSql(this.dbMetrics().getContractStateEvents(), (Function1 & Serializable)conn -> (Vector)$this.queryNonPruned.executeSql((Function0 & Serializable)() -> $this.contractStorageBackend.contractStateEvents(BoxesRunTime.unboxToLong(range.startExclusive()), BoxesRunTime.unboxToLong(range.endInclusive()), (Connection)conn), (Offset)startExclusive._1(), (Function1<Offset, String>)(Function1 & Serializable)pruned -> new StringBuilder(63).append("Contract state events request from ").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong(range.startExclusive())))).append(" to ").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong(range.endInclusive())))).append(" precedes pruned offset ").append(pruned.toHexString()).toString(), (Connection)conn, loggingContext), loggingContext)).mapConcat((Function1 & Serializable)x -> (Vector)Predef$.MODULE$.identity(x))).async().mapAsync(this.eventProcessingParallelism, (Function1 & Serializable)raw -> Timed$.MODULE$.future($this.metrics.daml().index().decodeStateEvent(), (Function0 & Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable)() -> ContractStateEventsReader$.MODULE$.toContractStateEvent((ContractStorageBackend.RawContractStateEvent)raw, $this.lfValueTranslation), $this.executionContext))).map((Function1 & Serializable)event -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)event.eventOffset(), (Object)BoxesRunTime.boxToLong((long)event.eventSequentialId()))), event));
        return (Source)InstrumentedGraph.BufferedSource$.MODULE$.buffered$extension(InstrumentedGraph$.MODULE$.BufferedSource((Source)TransactionsReader$.MODULE$.groupContiguous(contractStateEventsSource, (Function1 & Serializable)x0$1 -> {
            Offset offset;
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                throw new MatchError((Object)tuple22);
            }
            Offset offset2 = offset = (Offset)tuple2._1();
            return offset2;
        }).map((Function1 & Serializable)v -> {
            Tuple2 offset = (Tuple2)((Tuple2)v.head())._1();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offset), v.map((Function1 & Serializable)x$11 -> (ContractStateEvent)x$11._2()));
        })), this.metrics.daml().index().contractStateEventsBufferSize(), this.outputStreamBufferSize()).concat((Graph)endMarker);
    }

    private <E> EventsRange<Tuple2<Offset, Object>> nextPageRange(Tuple2<Offset, Object> endEventSeqId, EventStorageBackend.Entry<E> a) {
        return new EventsRange<Tuple2<Offset, Object>>(new Tuple2((Object)a.eventOffset(), (Object)BoxesRunTime.boxToLong((long)a.eventSequentialId())), endEventSeqId);
    }

    private Future<EventsRange<Tuple2<Offset, Object>>> getAcsEventSeqIdRange(Offset activeAt, LoggingContext loggingContext) {
        return this.dispatcher.executeSql(this.dbMetrics().getAcsEventSeqIdRange(), (Function1 & Serializable)connection -> (EventsRange)$this.queryNonPruned.executeSql((Function0 & Serializable)() -> this.eventSeqIdReader().readEventSeqIdRange(activeAt, (Connection)connection), activeAt, (Function1<Offset, String>)(Function1 & Serializable)pruned -> new StringBuilder(55).append("Active contracts request after ").append(activeAt.toHexString()).append(" precedes pruned offset ").append(pruned.toHexString()).toString(), (Connection)connection, loggingContext), loggingContext).map((Function1 & Serializable)x -> new EventsRange<Tuple2>(new Tuple2((Object)Offset$.MODULE$.beforeBegin(), (Object)BoxesRunTime.boxToLong((long)0L)), new Tuple2((Object)activeAt, x.endInclusive())), this.executionContext);
    }

    private Future<EventsRange<Tuple2<Offset, Object>>> getEventSeqIdRange(Offset startExclusive, Offset endInclusive, LoggingContext loggingContext) {
        return this.dispatcher.executeSql(this.dbMetrics().getEventSeqIdRange(), (Function1 & Serializable)connection -> (EventsRange)$this.queryNonPruned.executeSql((Function0 & Serializable)() -> this.eventSeqIdReader().readEventSeqIdRange(new EventsRange<Offset>(startExclusive, endInclusive), (Connection)connection), startExclusive, (Function1<Offset, String>)(Function1 & Serializable)pruned -> new StringBuilder(54).append("Transactions request from ").append(startExclusive.toHexString()).append(" to ").append(endInclusive.toHexString()).append(" precedes pruned offset ").append(pruned.toHexString()).toString(), (Connection)connection, loggingContext), loggingContext).map((Function1 & Serializable)x -> new EventsRange<Tuple2>(new Tuple2((Object)startExclusive, x.startExclusive()), new Tuple2((Object)endInclusive, x.endInclusive())), this.executionContext);
    }

    private <A, E> Source<EventStorageBackend.Entry<E>, NotUsed> streamEvents(boolean verbose, DatabaseMetrics queryMetric, Function1<EventsRange<A>, Function1<Connection, Vector<EventStorageBackend.Entry<Raw<E>>>>> query, Function1<EventStorageBackend.Entry<E>, EventsRange<A>> getNextPageRange, EventsRange<A> range, Ordering<A> evidence$1, LoggingContext loggingContext) {
        return PaginatingAsyncStream$.MODULE$.streamFrom(range, getNextPageRange, (Function1 & Serializable)range1 -> {
            Future future;
            if (EventsRange$.MODULE$.isEmpty(range1, evidence$1)) {
                future = Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty());
            } else {
                Future rawEvents = $this.dispatcher.executeSql(queryMetric, (Function1)query.apply(range1), loggingContext);
                future = rawEvents.flatMap((Function1 & Serializable)es -> {
                    Function0 & Serializable x$1 = (Function0 & Serializable)() -> Future$.MODULE$.traverse((IterableOnce)es, (Function1 & Serializable)entry -> this.deserializeEntry(verbose, (EventStorageBackend.Entry)entry, loggingContext), BuildFrom$.MODULE$.buildFromIterableOps(), $this.executionContext);
                    Timer x$2 = queryMetric.translationTimer();
                    return Timed$.MODULE$.future(x$2, (Function0)x$1);
                }, $this.executionContext);
            }
            return future;
        });
    }

    private <Mat, Out> Mat endSpanOnTermination(Span span, Mat mat, Future<Done> done) {
        done.onComplete((Function1 & Serializable)x0$1 -> {
            TransactionsReader.$anonfun$endSpanOnTermination$1(span, x0$1);
            return BoxedUnit.UNIT;
        }, this.executionContext);
        return mat;
    }

    public static final /* synthetic */ void $anonfun$getFlatTransactions$13(Span span$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        GetTransactionsResponse response = (GetTransactionsResponse)tuple2._2();
        response.transactions().foreach((Function1 & Serializable)txn -> {
            Spans$.MODULE$.addEventToSpan(new Event("transaction", TraceIdentifiers$.MODULE$.fromTransaction(txn)), span$1);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$getTransactionTrees$15(Span span$2, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        GetTransactionTreesResponse response = (GetTransactionTreesResponse)tuple2._2();
        response.transactions().foreach((Function1 & Serializable)txn -> {
            Spans$.MODULE$.addEventToSpan(new Event("transaction", TraceIdentifiers$.MODULE$.fromTransactionTree(txn)), span$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$endSpanOnTermination$1(Span span$4, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            span$4.recordException(exception);
            span$4.end();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            span$4.end();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public TransactionsReader(DbDispatcher dispatcher, QueryNonPruned queryNonPruned, EventStorageBackend eventStorageBackend, ContractStorageBackend contractStorageBackend, int pageSize, int eventProcessingParallelism, Metrics metrics, LfValueTranslation lfValueTranslation, ACSReader acsReader, ExecutionContext executionContext) {
        this.dispatcher = dispatcher;
        this.queryNonPruned = queryNonPruned;
        this.eventStorageBackend = eventStorageBackend;
        this.contractStorageBackend = contractStorageBackend;
        this.pageSize = pageSize;
        this.eventProcessingParallelism = eventProcessingParallelism;
        this.metrics = metrics;
        this.lfValueTranslation = lfValueTranslation;
        this.acsReader = acsReader;
        this.executionContext = executionContext;
        this.dbMetrics = metrics.daml().index().db();
        this.eventSeqIdReader = new EventsRange.EventSeqIdReader((Function1<Offset, Function1<Connection, Option<Object>>>)(Function1 & Serializable)offset -> (Function1 & Serializable)connection -> $this.eventStorageBackend.maxEventSequentialIdOfAnObservableEvent((Offset)offset, (Connection)connection));
        this.getTransactions = new EventsTableFlatEventsRangeQueries.GetTransactions(eventStorageBackend);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.outputStreamBufferSize = 128;
    }
}

