/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import akka.NotUsed;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import com.daml.api.util.TimeProvider;
import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.ledger.api.SubmissionIdGenerator;
import com.daml.ledger.api.auth.Authorizer;
import com.daml.ledger.api.auth.services.ActiveContractsServiceAuthorization;
import com.daml.ledger.api.auth.services.CommandCompletionServiceAuthorization;
import com.daml.ledger.api.auth.services.CommandServiceAuthorization;
import com.daml.ledger.api.auth.services.CommandSubmissionServiceAuthorization;
import com.daml.ledger.api.auth.services.ConfigManagementServiceAuthorization;
import com.daml.ledger.api.auth.services.LedgerConfigurationServiceAuthorization;
import com.daml.ledger.api.auth.services.LedgerIdentityServiceAuthorization;
import com.daml.ledger.api.auth.services.MeteringReportServiceAuthorization;
import com.daml.ledger.api.auth.services.PackageManagementServiceAuthorization;
import com.daml.ledger.api.auth.services.PackageServiceAuthorization;
import com.daml.ledger.api.auth.services.ParticipantPruningServiceAuthorization;
import com.daml.ledger.api.auth.services.PartyManagementServiceAuthorization;
import com.daml.ledger.api.auth.services.TimeServiceAuthorization;
import com.daml.ledger.api.auth.services.TransactionServiceAuthorization;
import com.daml.ledger.api.auth.services.UserManagementServiceAuthorization;
import com.daml.ledger.api.health.HealthChecks;
import com.daml.ledger.api.v1.active_contracts_service.ActiveContractsServiceGrpc;
import com.daml.ledger.api.v1.admin.config_management_service.ConfigManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.metering_report_service.MeteringReportServiceGrpc;
import com.daml.ledger.api.v1.admin.package_management_service.PackageManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.participant_pruning_service.ParticipantPruningServiceGrpc;
import com.daml.ledger.api.v1.admin.party_management_service.PartyManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.user_management_service.UserManagementServiceGrpc;
import com.daml.ledger.api.v1.command_completion_service.CommandCompletionServiceGrpc;
import com.daml.ledger.api.v1.command_service.CommandServiceGrpc;
import com.daml.ledger.api.v1.command_submission_service.CommandSubmissionServiceGrpc;
import com.daml.ledger.api.v1.ledger_configuration_service.LedgerConfigurationServiceGrpc;
import com.daml.ledger.api.v1.ledger_identity_service.LedgerIdentityServiceGrpc;
import com.daml.ledger.api.v1.package_service.PackageServiceGrpc;
import com.daml.ledger.api.v1.transaction_service.GetFlatTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionByIdRequest;
import com.daml.ledger.api.v1.transaction_service.GetTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.TransactionServiceGrpc;
import com.daml.ledger.client.services.commands.CommandSubmission;
import com.daml.ledger.client.services.commands.CommandSubmissionFlow$;
import com.daml.ledger.client.services.commands.tracker.CompletionResponse;
import com.daml.ledger.client.services.commands.tracker.TrackedCommandKey;
import com.daml.ledger.participant.state.index.v2.ContractStore;
import com.daml.ledger.participant.state.index.v2.IdentityProvider;
import com.daml.ledger.participant.state.index.v2.IndexActiveContractsService;
import com.daml.ledger.participant.state.index.v2.IndexCompletionsService;
import com.daml.ledger.participant.state.index.v2.IndexConfigManagementService;
import com.daml.ledger.participant.state.index.v2.IndexConfigurationService;
import com.daml.ledger.participant.state.index.v2.IndexPackagesService;
import com.daml.ledger.participant.state.index.v2.IndexParticipantPruningService;
import com.daml.ledger.participant.state.index.v2.IndexPartyManagementService;
import com.daml.ledger.participant.state.index.v2.IndexService;
import com.daml.ledger.participant.state.index.v2.IndexTransactionsService;
import com.daml.ledger.participant.state.index.v2.MeteringStore;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.ledger.participant.state.v2.SubmissionResult;
import com.daml.ledger.participant.state.v2.WriteConfigService;
import com.daml.ledger.participant.state.v2.WritePackagesService;
import com.daml.ledger.participant.state.v2.WriteParticipantPruningService;
import com.daml.ledger.participant.state.v2.WritePartyService;
import com.daml.ledger.participant.state.v2.WriteService;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.package$;
import com.daml.lf.engine.Engine;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.ApiServices$;
import com.daml.platform.apiserver.ApiServicesBundle;
import com.daml.platform.apiserver.LedgerFeatures;
import com.daml.platform.apiserver.SeedService;
import com.daml.platform.apiserver.TimeServiceBackend;
import com.daml.platform.apiserver.configuration.LedgerConfigurationInitializer;
import com.daml.platform.apiserver.configuration.LedgerConfigurationSubscription;
import com.daml.platform.apiserver.execution.LedgerTimeAwareCommandExecutor;
import com.daml.platform.apiserver.execution.StoreBackedCommandExecutor;
import com.daml.platform.apiserver.execution.TimedCommandExecutor;
import com.daml.platform.apiserver.services.ApiActiveContractsService$;
import com.daml.platform.apiserver.services.ApiCommandCompletionService$;
import com.daml.platform.apiserver.services.ApiCommandService;
import com.daml.platform.apiserver.services.ApiCommandService$;
import com.daml.platform.apiserver.services.ApiLedgerConfigurationService$;
import com.daml.platform.apiserver.services.ApiLedgerIdentityService;
import com.daml.platform.apiserver.services.ApiLedgerIdentityService$;
import com.daml.platform.apiserver.services.ApiPackageService$;
import com.daml.platform.apiserver.services.ApiSubmissionService;
import com.daml.platform.apiserver.services.ApiSubmissionService$;
import com.daml.platform.apiserver.services.ApiTimeService$;
import com.daml.platform.apiserver.services.ApiVersionService;
import com.daml.platform.apiserver.services.ApiVersionService$;
import com.daml.platform.apiserver.services.admin.ApiConfigManagementService$;
import com.daml.platform.apiserver.services.admin.ApiMeteringReportService;
import com.daml.platform.apiserver.services.admin.ApiMeteringReportService$;
import com.daml.platform.apiserver.services.admin.ApiPackageManagementService$;
import com.daml.platform.apiserver.services.admin.ApiParticipantPruningService$;
import com.daml.platform.apiserver.services.admin.ApiPartyManagementService$;
import com.daml.platform.apiserver.services.admin.ApiUserManagementService;
import com.daml.platform.apiserver.services.transaction.ApiTransactionService$;
import com.daml.platform.configuration.CommandConfiguration;
import com.daml.platform.configuration.InitialLedgerConfiguration;
import com.daml.platform.configuration.PartyConfiguration;
import com.daml.platform.server.api.services.domain.CommandCompletionService;
import com.daml.platform.server.api.services.grpc.GrpcCommandCompletionService;
import com.daml.platform.server.api.services.grpc.GrpcCommandSubmissionService;
import com.daml.platform.server.api.services.grpc.GrpcHealthService;
import com.daml.platform.server.api.services.grpc.GrpcHealthService$;
import com.daml.platform.server.api.services.grpc.GrpcTransactionService;
import com.daml.platform.services.time.TimeProviderType;
import com.daml.platform.usermanagement.UserManagementConfig;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.HasExecutionContext;
import com.daml.resources.Resource;
import com.daml.telemetry.TelemetryContext;
import com.daml.util.Ctx;
import com.google.protobuf.empty.Empty;
import io.grpc.BindableService;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r}f\u0001\u0003\u001f>!\u0003\r\n!Q#\t\u000f1\u0003!\u0019!D\u0001\u001d\")1\r\u0001D\u0001I\u001e1\u0011/\u0010E\u0001\u0003J4a\u0001P\u001f\t\u0002\u0005\u001b\b\"\u0002;\u0005\t\u0003)\bb\u0002<\u0005\u0005\u0004%Ia\u001e\u0005\u0007}\u0012\u0001\u000b\u0011\u0002=\u0007\u000b}$!!!\u0001\t\u0015\u0005\u001d\u0002B!A!\u0002\u0013\tI\u0003\u0003\u0006\u0002B!\u0011\t\u0011)A\u0005\u0003\u0007B!\"!\u0018\t\u0005\u0003\u0005\u000b\u0011BA0\u0011)\ti\u0007\u0003B\u0001B\u0003%\u0011q\u000e\u0005\u000b\u0003kB!\u0011!Q\u0001\n\u0005]\u0004BCAD\u0011\t\u0005\t\u0015!\u0003\u0002\n\"Q\u00111\u0013\u0005\u0003\u0002\u0003\u0006I!!&\t\u0015\u0005\r\u0006B!A!\u0002\u0013\t)\u000b\u0003\u0006\u00024\"\u0011\t\u0011)A\u0005\u0003kC!\"!2\t\u0005\u0003\u0005\u000b\u0011BAd\u0011)\t)\u000e\u0003B\u0001B\u0003%\u0011q\u001b\u0005\u000b\u0003;D!\u0011!Q\u0001\n\u0005}\u0007BCAs\u0011\t\u0005\t\u0015!\u0003\u0002h\"Q\u0011q\u001e\u0005\u0003\u0002\u0003\u0006I!!=\t\u0015\u0005e\bB!A!\u0002\u0013\tY\u0010\u0003\u0006\u0003\u0006!\u0011\t\u0011)A\u0005\u0005\u000fA!Ba\u0005\t\u0005\u0003\u0005\u000b\u0011\u0002B\u000b\u0011)\u0011Y\u0002\u0003B\u0001B\u0003%!Q\u0004\u0005\u000b\u0005GA!\u0011!Q\u0001\n\t\u0015\u0002B\u0003B \u0011\t\u0005\t\u0015!\u0003\u0003B!Q!q\t\u0005\u0003\u0002\u0003\u0006IA!\u0013\t\u0015\tU\u0003B!A!\u0002\u0013\t)\f\u0003\u0006\u0003X!\u0011\t\u0011)A\u0006\u00053B!B!\u001b\t\u0005\u0003\u0005\u000b1\u0002B6\u0011)\u0011I\b\u0003B\u0001B\u0003-!1\u0010\u0005\u0007i\"!\tA!!\t\u0013\tm\u0006B1A\u0005\n\tu\u0006\u0002\u0003Bc\u0011\u0001\u0006IAa0\t\u0013\t\u001d\u0007B1A\u0005\n\t%\u0007\u0002\u0003Bi\u0011\u0001\u0006IAa3\t\u0013\tM\u0007B1A\u0005\n\tU\u0007\u0002\u0003Bo\u0011\u0001\u0006IAa6\t\u0013\t}\u0007B1A\u0005\n\t\u0005\b\u0002\u0003Bu\u0011\u0001\u0006IAa9\t\u0013\t-\bB1A\u0005\n\t5\b\u0002\u0003B{\u0011\u0001\u0006IAa<\t\u0013\t]\bB1A\u0005\n\te\b\u0002CB\u0001\u0011\u0001\u0006IAa?\t\u0013\r\r\u0001B1A\u0005\n\r\u0015\u0001\u0002CB\u0007\u0011\u0001\u0006Iaa\u0002\t\u0013\r=\u0001B1A\u0005\n\rE\u0001\u0002CB\r\u0011\u0001\u0006Iaa\u0005\t\u0013\rm\u0001B1A\u0005\n\ru\u0001\u0002CB\u0013\u0011\u0001\u0006Iaa\b\t\u0013\r\u001d\u0002B1A\u0005\n\r%\u0002\u0002CB\u0019\u0011\u0001\u0006Iaa\u000b\t\u0013\rM\u0002B1A\u0005\n\rU\u0002\u0002CB!\u0011\u0001\u0006Iaa\u000e\t\u000f\r\r\u0003\u0002\"\u0011\u0004F!911\f\u0005\u0005\n\ru\u0003bBBG\u0011\u0011%1q\u0012\u0002\f\u0003BL7+\u001a:wS\u000e,7O\u0003\u0002?\u007f\u0005I\u0011\r]5tKJ4XM\u001d\u0006\u0003\u0001\u0006\u000b\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u0003\u0005\u000e\u000bA\u0001Z1nY*\tA)A\u0002d_6\u001c\"\u0001\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\r\u0005s\u0017PU3g\u0003!\u0019XM\u001d<jG\u0016\u001c8\u0001A\u000b\u0002\u001fB\u0019\u0001\u000bW.\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+N\u0003\u0019a$o\\8u}%\t\u0011*\u0003\u0002X\u0011\u00069\u0001/Y2lC\u001e,\u0017BA-[\u0005!IE/\u001a:bE2,'BA,I!\ta\u0016-D\u0001^\u0015\tqv,\u0001\u0003heB\u001c'\"\u00011\u0002\u0005%|\u0017B\u00012^\u0005=\u0011\u0015N\u001c3bE2,7+\u001a:wS\u000e,\u0017\u0001D<ji\"\u001cVM\u001d<jG\u0016\u001cHCA3h!\t1\u0007!D\u0001>\u0011\u0015A'\u00011\u0001j\u00035yG\u000f[3s'\u0016\u0014h/[2fgB\u0019!n\\.\u000e\u0003-T!\u0001\\7\u0002\u0013%lW.\u001e;bE2,'B\u00018I\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003a.\u00141aU3r\u0003-\t\u0005/[*feZL7-Z:\u0011\u0005\u0019$1C\u0001\u0003G\u0003\u0019a\u0014N\\5u}Q\t!/\u0001\u0004m_\u001e<WM]\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u001110Q\u0001\bY><w-\u001b8h\u0013\ti(P\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0005\u0015yuO\\3s'\rA\u00111\u0001\t\u0006\u0003\u000b\t\t#\u001a\b\u0005\u0003\u000f\tiB\u0004\u0003\u0002\n\u0005]a\u0002BA\u0006\u0003'qA!!\u0004\u0002\u00129\u0019!+a\u0004\n\u0003\u0011K!AQ\"\n\u0007\u0005U\u0011)\u0001\u0004mK\u0012<WM]\u0005\u0005\u00033\tY\"A\u0005sKN|WO]2fg*\u0019\u0011QC!\n\u0007]\u000byB\u0003\u0003\u0002\u001a\u0005m\u0011\u0002BA\u0012\u0003K\u0011QBU3t_V\u00148-Z(x]\u0016\u0014(bA,\u0002 \u0005i\u0001/\u0019:uS\u000eL\u0007/\u00198u\u0013\u0012\u0004B!a\u000b\u0002<9!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u00023bi\u0006T1!!\u000eB\u0003\tag-\u0003\u0003\u0002:\u0005=\u0012a\u0001*fM&!\u0011QHA \u00055\u0001\u0016M\u001d;jG&\u0004\u0018M\u001c;JI*!\u0011\u0011HA\u0018\u0003=y\u0007\u000f^,sSR,7+\u001a:wS\u000e,\u0007#B$\u0002F\u0005%\u0013bAA$\u0011\n1q\n\u001d;j_:\u0004B!a\u0013\u0002Z5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0002we)!\u00111KA+\u0003\u0015\u0019H/\u0019;f\u0015\u0011\t9&a\u0007\u0002\u0017A\f'\u000f^5dSB\fg\u000e^\u0005\u0005\u00037\niE\u0001\u0007Xe&$XmU3sm&\u001cW-\u0001\u0007j]\u0012,\u0007pU3sm&\u001cW\r\u0005\u0003\u0002b\u0005%TBAA2\u0015\u0011\ty%!\u001a\u000b\t\u0005\u001d\u0014\u0011K\u0001\u0006S:$W\r_\u0005\u0005\u0003W\n\u0019G\u0001\u0007J]\u0012,\u0007pU3sm&\u001cW-A\nvg\u0016\u0014X*\u00198bO\u0016lWM\u001c;Ti>\u0014X\r\u0005\u0003\u0002b\u0005E\u0014\u0002BA:\u0003G\u00121#V:fe6\u000bg.Y4f[\u0016tGo\u0015;pe\u0016\f!\"Y;uQ>\u0014\u0018N_3s!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nA!Y;uQ*!\u0011\u0011QA\u000e\u0003\r\t\u0007/[\u0005\u0005\u0003\u000b\u000bYH\u0001\u0006BkRDwN]5{KJ\fa!\u001a8hS:,\u0007\u0003BAF\u0003\u001fk!!!$\u000b\t\u0005\u001d\u00151G\u0005\u0005\u0003#\u000biI\u0001\u0004F]\u001eLg.Z\u0001\ri&lW\r\u0015:pm&$WM\u001d\t\u0005\u0003/\u000by*\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\u0011)H/\u001b7\u000b\u0007\u0005\u0005\u0015)\u0003\u0003\u0002\"\u0006e%\u0001\u0004+j[\u0016\u0004&o\u001c<jI\u0016\u0014\u0018\u0001\u0005;j[\u0016\u0004&o\u001c<jI\u0016\u0014H+\u001f9f!\u0011\t9+a,\u000e\u0005\u0005%&\u0002BAV\u0003[\u000bA\u0001^5nK*\u0011AjP\u0005\u0005\u0003c\u000bIK\u0001\tUS6,\u0007K]8wS\u0012,'\u000fV=qK\u0006A2m\u001c8gS\u001e,(/\u0019;j_:du.\u00193US6,w.\u001e;\u0011\t\u0005]\u0016\u0011Y\u0007\u0003\u0003sSA!a/\u0002>\u0006AA-\u001e:bi&|gNC\u0002\u0002@\"\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\u0019-!/\u0003\u0011\u0011+(/\u0019;j_:\f!$\u001b8ji&\fG\u000eT3eO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0004RaRA#\u0003\u0013\u0004B!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0004\u0003\u001f|\u0014!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002T\u00065'AG%oSRL\u0017\r\u001c'fI\u001e,'oQ8oM&<WO]1uS>t\u0017!D2p[6\fg\u000eZ\"p]\u001aLw\r\u0005\u0003\u0002L\u0006e\u0017\u0002BAn\u0003\u001b\u0014AcQ8n[\u0006tGmQ8oM&<WO]1uS>t\u0017a\u00039beRL8i\u001c8gS\u001e\u0004B!a3\u0002b&!\u00111]Ag\u0005I\u0001\u0016M\u001d;z\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002+=\u0004H\u000fV5nKN+'O^5dK\n\u000b7m[3oIB)q)!\u0012\u0002jB\u0019a-a;\n\u0007\u00055XH\u0001\nUS6,7+\u001a:wS\u000e,')Y2lK:$\u0017\u0001G:feZL7-Z:Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB!\u00111_A{\u001b\t\ti,\u0003\u0003\u0002x\u0006u&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u001diW\r\u001e:jGN\u0004B!!@\u0003\u00025\u0011\u0011q \u0006\u0004\u0003s\f\u0015\u0002\u0002B\u0002\u0003\u007f\u0014q!T3ue&\u001c7/\u0001\u0007iK\u0006dG\u000f[\"iK\u000e\\7\u000f\u0005\u0003\u0003\n\t=QB\u0001B\u0006\u0015\u0011\u0011i!a \u0002\r!,\u0017\r\u001c;i\u0013\u0011\u0011\tBa\u0003\u0003\u0019!+\u0017\r\u001c;i\u0007\",7m[:\u0002\u0017M,W\rZ*feZL7-\u001a\t\u0004M\n]\u0011b\u0001B\r{\tY1+Z3e'\u0016\u0014h/[2f\u0003ai\u0017M\\1hK6,g\u000e^*feZL7-\u001a+j[\u0016|W\u000f\u001e\t\u0005\u0003o\u0013y\"\u0003\u0003\u0003\"\u0005e&A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0010G\",7m[(wKJdw.\u00193fIB9qIa\n\u0003,\t]\u0012b\u0001B\u0015\u0011\nIa)\u001e8di&|g.\r\t\u0005\u0005[\u0011\u0019$\u0004\u0002\u00030)\u0019!\u0011G!\u0002\u0013Q,G.Z7fiJL\u0018\u0002\u0002B\u001b\u0005_\u0011\u0001\u0003V3mK6,GO]=D_:$X\r\u001f;\u0011\u000b\u001d\u000b)E!\u000f\u0011\t\u0005-#1H\u0005\u0005\u0005{\tiE\u0001\tTk\nl\u0017n]:j_:\u0014Vm];mi\u0006qA.\u001a3hKJ4U-\u0019;ve\u0016\u001c\bc\u00014\u0003D%\u0019!QI\u001f\u0003\u001d1+GmZ3s\r\u0016\fG/\u001e:fg\u0006!Ro]3s\u001b\u0006t\u0017mZ3nK:$8i\u001c8gS\u001e\u0004BAa\u0013\u0003R5\u0011!Q\n\u0006\u0004\u0005\u001fz\u0014AD;tKJl\u0017M\\1hK6,g\u000e^\u0005\u0005\u0005'\u0012iE\u0001\u000bVg\u0016\u0014X*\u00198bO\u0016lWM\u001c;D_:4\u0017nZ\u0001\u0019CBL7\u000b\u001e:fC6\u001c\u0006.\u001e;e_^tG+[7f_V$\u0018\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002B.\u0005Kj!A!\u0018\u000b\t\t}#\u0011M\u0001\u0007gR\u0014X-Y7\u000b\u0005\t\r\u0014\u0001B1lW\u0006LAAa\u001a\u0003^\taQ*\u0019;fe&\fG.\u001b>fe\u0006\u0019Qm\u001d4\u0011\t\t5$QO\u0007\u0003\u0005_RAA!\u001d\u0003t\u00059\u0011\rZ1qi\u0016\u0014(B\u00010B\u0013\u0011\u00119Ha\u001c\u00033\u0015CXmY;uS>t7+Z9vK:\u001cWM\u001d$bGR|'/_\u0001\u000fY><w-\u001b8h\u0007>tG/\u001a=u!\rI(QP\u0005\u0004\u0005\u007fR(A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010\u001e\u000b/\u0005\u0007\u0013yI!%\u0003\u0014\nU%q\u0013BM\u00057\u0013iJa(\u0003\"\n\r&Q\u0015BT\u0005S\u0013YK!,\u00030\nE&1\u0017B[\u0005o\u0013I\f\u0006\u0005\u0003\u0006\n%%1\u0012BG!\r\u00119\tC\u0007\u0002\t!9!q\u000b\u0012A\u0004\te\u0003b\u0002B5E\u0001\u000f!1\u000e\u0005\b\u0005s\u0012\u00039\u0001B>\u0011\u001d\t9C\ta\u0001\u0003SAq!!\u0011#\u0001\u0004\t\u0019\u0005C\u0004\u0002^\t\u0002\r!a\u0018\t\u000f\u00055$\u00051\u0001\u0002p!9\u0011Q\u000f\u0012A\u0002\u0005]\u0004bBADE\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003'\u0013\u0003\u0019AAK\u0011\u001d\t\u0019K\ta\u0001\u0003KCq!a-#\u0001\u0004\t)\fC\u0004\u0002F\n\u0002\r!a2\t\u000f\u0005U'\u00051\u0001\u0002X\"9\u0011Q\u001c\u0012A\u0002\u0005}\u0007bBAsE\u0001\u0007\u0011q\u001d\u0005\b\u0003_\u0014\u0003\u0019AAy\u0011\u001d\tIP\ta\u0001\u0003wDqA!\u0002#\u0001\u0004\u00119\u0001C\u0004\u0003\u0014\t\u0002\rA!\u0006\t\u000f\tm!\u00051\u0001\u0003\u001e!9!1\u0005\u0012A\u0002\t\u0015\u0002b\u0002B E\u0001\u0007!\u0011\t\u0005\b\u0005\u000f\u0012\u0003\u0019\u0001B%\u0011\u001d\u0011)F\ta\u0001\u0003k\u000bAcY8oM&<WO]1uS>t7+\u001a:wS\u000e,WC\u0001B`!\u0011\t\tG!1\n\t\t\r\u00171\r\u0002\u001a\u0013:$W\r_\"p]\u001aLw-\u001e:bi&|gnU3sm&\u001cW-A\u000bd_:4\u0017nZ;sCRLwN\\*feZL7-\u001a\u0011\u0002\u001f%$WM\u001c;jif\u001cVM\u001d<jG\u0016,\"Aa3\u0011\t\u0005\u0005$QZ\u0005\u0005\u0005\u001f\f\u0019G\u0001\tJI\u0016tG/\u001b;z!J|g/\u001b3fe\u0006\u0001\u0012\u000eZ3oi&$\u0018pU3sm&\u001cW\rI\u0001\u0010a\u0006\u001c7.Y4fgN+'O^5dKV\u0011!q\u001b\t\u0005\u0003C\u0012I.\u0003\u0003\u0003\\\u0006\r$\u0001F%oI\u0016D\b+Y2lC\u001e,7oU3sm&\u001cW-\u0001\tqC\u000e\\\u0017mZ3t'\u0016\u0014h/[2fA\u00051\u0012m\u0019;jm\u0016\u001cuN\u001c;sC\u000e$8oU3sm&\u001cW-\u0006\u0002\u0003dB!\u0011\u0011\rBs\u0013\u0011\u00119/a\u0019\u00037%sG-\u001a=BGRLg/Z\"p]R\u0014\u0018m\u0019;t'\u0016\u0014h/[2f\u0003]\t7\r^5wK\u000e{g\u000e\u001e:bGR\u001c8+\u001a:wS\u000e,\u0007%A\nue\u0006t7/Y2uS>t7oU3sm&\u001cW-\u0006\u0002\u0003pB!\u0011\u0011\rBy\u0013\u0011\u0011\u00190a\u0019\u00031%sG-\u001a=Ue\u0006t7/Y2uS>t7oU3sm&\u001cW-\u0001\u000bue\u0006t7/Y2uS>t7oU3sm&\u001cW\rI\u0001\u000eG>tGO]1diN#xN]3\u0016\u0005\tm\b\u0003BA1\u0005{LAAa@\u0002d\ti1i\u001c8ue\u0006\u001cGo\u0015;pe\u0016\fabY8oiJ\f7\r^*u_J,\u0007%\u0001\nd_6\u0004H.\u001a;j_:\u001c8+\u001a:wS\u000e,WCAB\u0004!\u0011\t\tg!\u0003\n\t\r-\u00111\r\u0002\u0018\u0013:$W\r_\"p[BdW\r^5p]N\u001cVM\u001d<jG\u0016\f1cY8na2,G/[8ogN+'O^5dK\u0002\na\u0003]1sifl\u0015M\\1hK6,g\u000e^*feZL7-Z\u000b\u0003\u0007'\u0001B!!\u0019\u0004\u0016%!1qCA2\u0005mIe\u000eZ3y!\u0006\u0014H/_'b]\u0006<W-\\3oiN+'O^5dK\u00069\u0002/\u0019:us6\u000bg.Y4f[\u0016tGoU3sm&\u001cW\rI\u0001\u0018G>tg-[4NC:\fw-Z7f]R\u001cVM\u001d<jG\u0016,\"aa\b\u0011\t\u0005\u00054\u0011E\u0005\u0005\u0007G\t\u0019G\u0001\u000fJ]\u0012,\u0007pQ8oM&<W*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3\u00021\r|gNZ5h\u001b\u0006t\u0017mZ3nK:$8+\u001a:wS\u000e,\u0007%A\u0007nKR,'/\u001b8h'R|'/Z\u000b\u0003\u0007W\u0001B!!\u0019\u0004.%!1qFA2\u00055iU\r^3sS:<7\u000b^8sK\u0006qQ.\u001a;fe&twm\u0015;pe\u0016\u0004\u0013\u0001G2p]\u001aLw-\u001e:bi&|g.\u00138ji&\fG.\u001b>feV\u00111q\u0007\t\u0005\u0007s\u0019i$\u0004\u0002\u0004<)\u0019\u0011qZ\u001f\n\t\r}21\b\u0002\u001f\u0019\u0016$w-\u001a:D_:4\u0017nZ;sCRLwN\\%oSRL\u0017\r\\5{KJ\f\u0011dY8oM&<WO]1uS>t\u0017J\\5uS\u0006d\u0017N_3sA\u00059\u0011mY9vSJ,GCAB$)\u0011\u0019Iea\u0014\u0011\u000b\u0005\u001511J3\n\t\r5\u0013Q\u0005\u0002\t%\u0016\u001cx.\u001e:dK\"91\u0011K\u001dA\u0004\rM\u0013aB2p]R,\u0007\u0010\u001e\t\u0005\u0007+\u001a9&\u0004\u0002\u0002 %!1\u0011LA\u0010\u0005=\u0011Vm]8ve\u000e,7i\u001c8uKb$\u0018AD2sK\u0006$XmU3sm&\u001cWm\u001d\u000b\t\u0007?\u001aYg!!\u0004\fR!1\u0011MB4!\u0011\u000161M.\n\u0007\r\u0015$L\u0001\u0003MSN$\bbBB5u\u0001\u000f\u0011\u0011_\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqRDqa!\u001c;\u0001\u0004\u0019y'\u0001\u0005mK\u0012<WM]%e!\u0011\u0019\tha\u001f\u000f\t\rM4q\u000f\b\u0005\u0003\u0013\u0019)(\u0003\u0003\u0002\u0002\u0006m\u0011\u0002BB=\u0003\u007f\na\u0001Z8nC&t\u0017\u0002BB?\u0007\u007f\u0012\u0001\u0002T3eO\u0016\u0014\u0018\n\u001a\u0006\u0005\u0007s\ny\bC\u0004\u0004\u0004j\u0002\ra!\"\u0002?1,GmZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8Tk\n\u001c8M]5qi&|g\u000e\u0005\u0003\u0004:\r\u001d\u0015\u0002BBE\u0007w\u0011q\u0004T3eO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u001cVOY:de&\u0004H/[8o\u0011\u001d\u0011\u0019C\u000fa\u0001\u0005K\t\u0001&\u001b8uSRL\u0017\r\\5{K^\u0013\u0018\u000e^3TKJ4\u0018nY3CC\u000e\\W\rZ!qSN+'O^5dKN$Bb!%\u0004\u0016\u000e]5\u0011TBX\u0007{#Ba!\u0019\u0004\u0014\"91\u0011N\u001eA\u0004\u0005E\bbBB7w\u0001\u00071q\u000e\u0005\b\u0007\u0007[\u0004\u0019ABC\u0011\u001d\u0019Yj\u000fa\u0001\u0007;\u000bA#\u00199j\u0007>l\u0007\u000f\\3uS>t7+\u001a:wS\u000e,\u0007\u0003BBP\u0007Wk!a!)\u000b\t\re41\u0015\u0006\u0004\u0019\u000e\u0015&\u0002BAA\u0007OS1a!+@\u0003\u0019\u0019XM\u001d<fe&!1QVBQ\u0005a\u0019u.\\7b]\u0012\u001cu.\u001c9mKRLwN\\*feZL7-\u001a\u0005\b\u0007c[\u0004\u0019ABZ\u0003U\t\u0007/\u001b+sC:\u001c\u0018m\u0019;j_:\u001cVM\u001d<jG\u0016\u0004Ba!.\u0004:6\u00111q\u0017\u0006\u0004=\u000e\r\u0016\u0002BB^\u0007o\u0013ac\u0012:qGR\u0013\u0018M\\:bGRLwN\\*feZL7-\u001a\u0005\b\u0005GY\u0004\u0019\u0001B\u0013\u0001")
public interface ApiServices {
    public Iterable<BindableService> services();

    public ApiServices withServices(Seq<BindableService> var1);

    public static final class Owner
    extends AbstractResourceOwner<ResourceContext, ApiServices> {
        private final String participantId;
        private final Option<WriteService> optWriteService;
        private final IndexService indexService;
        private final UserManagementStore userManagementStore;
        private final Authorizer authorizer;
        private final Engine engine;
        private final TimeProvider timeProvider;
        private final TimeProviderType timeProviderType;
        private final Duration configurationLoadTimeout;
        private final Option<InitialLedgerConfiguration> initialLedgerConfiguration;
        private final CommandConfiguration commandConfig;
        private final PartyConfiguration partyConfig;
        private final Option<TimeServiceBackend> optTimeServiceBackend;
        private final ExecutionContext servicesExecutionContext;
        private final Metrics metrics;
        private final HealthChecks healthChecks;
        private final SeedService seedService;
        private final FiniteDuration managementServiceTimeout;
        private final Function1<TelemetryContext, Option<SubmissionResult>> checkOverloaded;
        private final LedgerFeatures ledgerFeatures;
        private final UserManagementConfig userManagementConfig;
        private final Duration apiStreamShutdownTimeout;
        private final Materializer materializer;
        private final ExecutionSequencerFactory esf;
        private final LoggingContext loggingContext;
        private final IndexConfigurationService configurationService;
        private final IdentityProvider identityService;
        private final IndexPackagesService packagesService;
        private final IndexActiveContractsService activeContractsService;
        private final IndexTransactionsService transactionsService;
        private final ContractStore contractStore;
        private final IndexCompletionsService completionsService;
        private final IndexPartyManagementService partyManagementService;
        private final IndexConfigManagementService configManagementService;
        private final MeteringStore meteringStore;
        private final LedgerConfigurationInitializer configurationInitializer;

        private IndexConfigurationService configurationService() {
            return this.configurationService;
        }

        private IdentityProvider identityService() {
            return this.identityService;
        }

        private IndexPackagesService packagesService() {
            return this.packagesService;
        }

        private IndexActiveContractsService activeContractsService() {
            return this.activeContractsService;
        }

        private IndexTransactionsService transactionsService() {
            return this.transactionsService;
        }

        private ContractStore contractStore() {
            return this.contractStore;
        }

        private IndexCompletionsService completionsService() {
            return this.completionsService;
        }

        private IndexPartyManagementService partyManagementService() {
            return this.partyManagementService;
        }

        private IndexConfigManagementService configManagementService() {
            return this.configManagementService;
        }

        private MeteringStore meteringStore() {
            return this.meteringStore;
        }

        private LedgerConfigurationInitializer configurationInitializer() {
            return this.configurationInitializer;
        }

        public Resource<ResourceContext, ApiServices> acquire(ResourceContext context) {
            ApiServices$.MODULE$.com$daml$platform$apiserver$ApiServices$$logger().info().apply((Function0 & Serializable)() -> $this.engine.info().toString(), this.loggingContext);
            Resource<ResourceContext, LedgerConfigurationSubscription> resource = this.configurationInitializer().initialize(this.initialLedgerConfiguration, this.configurationLoadTimeout, context, this.loggingContext);
            return resource.flatMap((Function1 & Serializable)currentLedgerConfiguration -> package$.MODULE$.Resource().apply(Future$.MODULE$.apply((Function0 & Serializable)() -> this.createServices(this.identityService().ledgerId(), (LedgerConfigurationSubscription)currentLedgerConfiguration, $this.checkOverloaded, $this.servicesExecutionContext), this.executionContext(context)), (Function1 & Serializable)services -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> services.foreach((Function1 & Serializable)x0$1 -> {
                Owner.$anonfun$acquire$6(x0$1);
                return BoxedUnit.UNIT;
            }), this.executionContext(context)), (Object)context).map((Function1 & Serializable)services -> new ApiServicesBundle((Seq<BindableService>)services), (Object)context), (Object)context);
        }

        private List<BindableService> createServices(Object ledgerId, LedgerConfigurationSubscription ledgerConfigurationSubscription, Function1<TelemetryContext, Option<SubmissionResult>> checkOverloaded, ExecutionContext executionContext) {
            None$ none$;
            GrpcTransactionService apiTransactionService = ApiTransactionService$.MODULE$.create(ledgerId, this.transactionsService(), this.metrics, executionContext, this.materializer, this.esf, this.loggingContext);
            ApiLedgerIdentityService apiLedgerIdentityService = ApiLedgerIdentityService$.MODULE$.create(ledgerId, executionContext, this.loggingContext);
            ApiVersionService apiVersionService = ApiVersionService$.MODULE$.create(this.ledgerFeatures, this.userManagementConfig, this.loggingContext, executionContext);
            PackageServiceGrpc.PackageService apiPackageService = ApiPackageService$.MODULE$.create(ledgerId, this.packagesService(), executionContext, this.loggingContext);
            LedgerConfigurationServiceGrpc.LedgerConfigurationService apiConfigurationService = ApiLedgerConfigurationService$.MODULE$.create(ledgerId, this.configurationService(), this.esf, this.materializer, executionContext, this.loggingContext);
            Tuple2<CommandCompletionService, GrpcCommandCompletionService> tuple2 = ApiCommandCompletionService$.MODULE$.create(ledgerId, this.completionsService(), this.metrics, this.materializer, this.esf, executionContext, this.loggingContext);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            CommandCompletionService completionService = (CommandCompletionService)tuple2._1();
            GrpcCommandCompletionService grpcCompletionService = (GrpcCommandCompletionService)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)completionService, (Object)grpcCompletionService);
            Tuple2 tuple23 = tuple22;
            CommandCompletionService completionService2 = (CommandCompletionService)tuple23._1();
            GrpcCommandCompletionService grpcCompletionService2 = (GrpcCommandCompletionService)tuple23._2();
            ActiveContractsServiceGrpc.ActiveContractsService apiActiveContractsService = ApiActiveContractsService$.MODULE$.create(ledgerId, this.activeContractsService(), this.metrics, this.materializer, this.esf, executionContext, this.loggingContext);
            Option apiTimeServiceOpt = this.optTimeServiceBackend.map((Function1 & Serializable)tsb -> new TimeServiceAuthorization(ApiTimeService$.MODULE$.create(ledgerId, (TimeServiceBackend)tsb, $this.apiStreamShutdownTimeout, $this.materializer, $this.esf, executionContext, $this.loggingContext), $this.authorizer, executionContext));
            List<BindableService> writeServiceBackedApiServices = this.intitializeWriteServiceBackedApiServices(ledgerId, ledgerConfigurationSubscription, completionService2, apiTransactionService, checkOverloaded, executionContext);
            BindableService apiReflectionService = ProtoReflectionService.newInstance();
            GrpcHealthService apiHealthService = new GrpcHealthService(this.healthChecks, GrpcHealthService$.MODULE$.$lessinit$greater$default$2(), this.esf, this.materializer, executionContext, this.loggingContext);
            if (this.userManagementConfig.enabled()) {
                ApiUserManagementService apiUserManagementService = new ApiUserManagementService(this.userManagementStore, this.userManagementConfig.maxUsersPageSize(), (SubmissionIdGenerator)SubmissionIdGenerator.Random$.MODULE$, executionContext, this.loggingContext);
                UserManagementServiceAuthorization authorized = new UserManagementServiceAuthorization((UserManagementServiceGrpc.UserManagementService)apiUserManagementService, this.authorizer, executionContext, this.loggingContext);
                none$ = new Some((Object)authorized);
            } else {
                none$ = None$.MODULE$;
            }
            None$ maybeApiUserManagementService = none$;
            ApiMeteringReportService apiMeteringReportService = new ApiMeteringReportService(this.participantId, this.meteringStore(), ApiMeteringReportService$.MODULE$.$lessinit$greater$default$3(), executionContext, this.loggingContext);
            List list = apiTimeServiceOpt.toList();
            List<BindableService> list2 = writeServiceBackedApiServices;
            List list3 = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BindableService[]{new LedgerIdentityServiceAuthorization((LedgerIdentityServiceGrpc.LedgerIdentityService)apiLedgerIdentityService, this.authorizer, executionContext), new PackageServiceAuthorization(apiPackageService, this.authorizer, executionContext), new LedgerConfigurationServiceAuthorization(apiConfigurationService, this.authorizer, executionContext), new TransactionServiceAuthorization((TransactionServiceGrpc.TransactionService)apiTransactionService, this.authorizer, executionContext), new CommandCompletionServiceAuthorization((CommandCompletionServiceGrpc.CommandCompletionService)grpcCompletionService2, this.authorizer, executionContext), new ActiveContractsServiceAuthorization(apiActiveContractsService, this.authorizer, executionContext), apiReflectionService, apiHealthService, apiVersionService, new MeteringReportServiceAuthorization((MeteringReportServiceGrpc.MeteringReportService)apiMeteringReportService, this.authorizer, executionContext)}));
            return maybeApiUserManagementService.toList().$colon$colon$colon(list3).$colon$colon$colon(list2).$colon$colon$colon(list);
        }

        private List<BindableService> intitializeWriteServiceBackedApiServices(Object ledgerId, LedgerConfigurationSubscription ledgerConfigurationSubscription, CommandCompletionService apiCompletionService, GrpcTransactionService apiTransactionService, Function1<TelemetryContext, Option<SubmissionResult>> checkOverloaded, ExecutionContext executionContext) {
            return this.optWriteService.toList().flatMap((Function1 & Serializable)writeService -> {
                TimedCommandExecutor commandExecutor = new TimedCommandExecutor(new LedgerTimeAwareCommandExecutor(new StoreBackedCommandExecutor($this.engine, $this.participantId, this.packagesService(), this.contractStore(), $this.metrics, executionContext), this.contractStore(), 3, $this.metrics, executionContext), $this.metrics);
                GrpcCommandSubmissionService apiSubmissionService = ApiSubmissionService$.MODULE$.create(ledgerId, (WriteService)writeService, this.partyManagementService(), $this.timeProvider, $this.timeProviderType, ledgerConfigurationSubscription, $this.seedService, commandExecutor, checkOverloaded, new ApiSubmissionService.Configuration($this.partyConfig.implicitPartyAllocation()), $this.metrics, executionContext, $this.loggingContext);
                CommandServiceGrpc.CommandService apiCommandService = ApiCommandService$.MODULE$.create(new ApiCommandService.Configuration(ledgerId, $this.commandConfig.inputBufferSize(), $this.commandConfig.maxCommandsInFlight(), $this.commandConfig.trackerRetentionPeriod()), (Flow<Ctx<Tuple2<Promise<Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, TrackedCommandKey>, CommandSubmission>, Ctx<Tuple2<Promise<Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, TrackedCommandKey>, Try<Empty>>, NotUsed>)CommandSubmissionFlow$.MODULE$.apply((Function1 & Serializable)request -> apiSubmissionService.submit(request), $this.commandConfig.maxCommandsInFlight()), apiCompletionService, new ApiCommandService.TransactionServices((Function1<GetTransactionByIdRequest, Future<GetTransactionResponse>>)(Function1 & Serializable)request -> apiTransactionService.getTransactionById(request), (Function1<GetTransactionByIdRequest, Future<GetFlatTransactionResponse>>)(Function1 & Serializable)request -> apiTransactionService.getFlatTransactionById(request)), $this.timeProvider, ledgerConfigurationSubscription, $this.metrics, $this.materializer, executionContext, $this.loggingContext);
                PartyManagementServiceGrpc.PartyManagementService apiPartyManagementService = ApiPartyManagementService$.MODULE$.createApiService(this.partyManagementService(), this.transactionsService(), (WritePartyService)writeService, $this.managementServiceTimeout, ApiPartyManagementService$.MODULE$.createApiService$default$5(), $this.materializer, executionContext, $this.loggingContext);
                PackageManagementServiceGrpc.PackageManagementService apiPackageManagementService = ApiPackageManagementService$.MODULE$.createApiService((IndexPackagesService)$this.indexService, this.transactionsService(), (WritePackagesService)writeService, $this.managementServiceTimeout, $this.engine, ApiPackageManagementService$.MODULE$.createApiService$default$6(), ApiPackageManagementService$.MODULE$.createApiService$default$7(), $this.materializer, executionContext, $this.loggingContext);
                ConfigManagementServiceGrpc.ConfigManagementService apiConfigManagementService = ApiConfigManagementService$.MODULE$.createApiService(this.configManagementService(), (WriteConfigService)writeService, $this.timeProvider, ApiConfigManagementService$.MODULE$.createApiService$default$4(), $this.materializer, executionContext, $this.loggingContext);
                ParticipantPruningServiceGrpc.ParticipantPruningService apiParticipantPruningService = ApiParticipantPruningService$.MODULE$.createApiService((IndexParticipantPruningService)$this.indexService, (WriteParticipantPruningService)writeService, executionContext, $this.loggingContext);
                return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GrpcApiService[]{new CommandSubmissionServiceAuthorization((CommandSubmissionServiceGrpc.CommandSubmissionService)apiSubmissionService, $this.authorizer, executionContext), new CommandServiceAuthorization(apiCommandService, $this.authorizer, executionContext), new PartyManagementServiceAuthorization(apiPartyManagementService, $this.authorizer, executionContext), new PackageManagementServiceAuthorization(apiPackageManagementService, $this.authorizer, executionContext), new ConfigManagementServiceAuthorization(apiConfigManagementService, $this.authorizer, executionContext), new ParticipantPruningServiceAuthorization(apiParticipantPruningService, $this.authorizer, executionContext)}));
            });
        }

        public static final /* synthetic */ void $anonfun$acquire$6(BindableService x0$1) {
            BindableService bindableService = x0$1;
            if (bindableService instanceof AutoCloseable) {
                BindableService bindableService2 = bindableService;
                ((AutoCloseable)bindableService2).close();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public Owner(String participantId, Option<WriteService> optWriteService, IndexService indexService, UserManagementStore userManagementStore, Authorizer authorizer, Engine engine, TimeProvider timeProvider, TimeProviderType timeProviderType, Duration configurationLoadTimeout, Option<InitialLedgerConfiguration> initialLedgerConfiguration, CommandConfiguration commandConfig, PartyConfiguration partyConfig, Option<TimeServiceBackend> optTimeServiceBackend, ExecutionContext servicesExecutionContext, Metrics metrics, HealthChecks healthChecks, SeedService seedService, FiniteDuration managementServiceTimeout, Function1<TelemetryContext, Option<SubmissionResult>> checkOverloaded, LedgerFeatures ledgerFeatures, UserManagementConfig userManagementConfig, Duration apiStreamShutdownTimeout, Materializer materializer, ExecutionSequencerFactory esf, LoggingContext loggingContext) {
            this.participantId = participantId;
            this.optWriteService = optWriteService;
            this.indexService = indexService;
            this.userManagementStore = userManagementStore;
            this.authorizer = authorizer;
            this.engine = engine;
            this.timeProvider = timeProvider;
            this.timeProviderType = timeProviderType;
            this.configurationLoadTimeout = configurationLoadTimeout;
            this.initialLedgerConfiguration = initialLedgerConfiguration;
            this.commandConfig = commandConfig;
            this.partyConfig = partyConfig;
            this.optTimeServiceBackend = optTimeServiceBackend;
            this.servicesExecutionContext = servicesExecutionContext;
            this.metrics = metrics;
            this.healthChecks = healthChecks;
            this.seedService = seedService;
            this.managementServiceTimeout = managementServiceTimeout;
            this.checkOverloaded = checkOverloaded;
            this.ledgerFeatures = ledgerFeatures;
            this.userManagementConfig = userManagementConfig;
            this.apiStreamShutdownTimeout = apiStreamShutdownTimeout;
            this.materializer = materializer;
            this.esf = esf;
            this.loggingContext = loggingContext;
            super((HasExecutionContext)ResourceContext.Context$u0020has$u0020ExecutionContext$.MODULE$);
            this.configurationService = indexService;
            this.identityService = indexService;
            this.packagesService = indexService;
            this.activeContractsService = indexService;
            this.transactionsService = indexService;
            this.contractStore = indexService;
            this.completionsService = indexService;
            this.partyManagementService = indexService;
            this.configManagementService = indexService;
            this.meteringStore = indexService;
            this.configurationInitializer = new LedgerConfigurationInitializer((IndexConfigManagementService)indexService, optWriteService, timeProvider, materializer, servicesExecutionContext);
        }
    }
}

