/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import com.auth0.jwt.algorithms.Algorithm;
import com.daml.jwt.ECDSAVerifier$;
import com.daml.jwt.HMAC256Verifier$;
import com.daml.jwt.JwksVerifier;
import com.daml.jwt.JwksVerifier$;
import com.daml.jwt.JwtVerifier;
import com.daml.jwt.JwtVerifierBase;
import com.daml.jwt.RSA256Verifier$;
import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.AuthServiceJWT$;
import java.io.Serializable;
import java.security.interfaces.ECPublicKey;
import scala.Function1;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r]bACA\u0007\u0003\u001f\u0001\n1%\t\u0002\"!9\u0011q\u0006\u0001\u0007\u0002\u0005Er\u0001CB\u001b\u0003\u001fA\t!!\u0015\u0007\u0011\u00055\u0011q\u0002E\u0001\u0003\u0017Bq!!\u0014\u0004\t\u0003\tyeB\u0004\u0002V\rA)!a\u0016\u0007\u000f\u0005m3\u0001#\u0002\u0002^!9\u0011Q\n\u0004\u0005\u0002\u0005\u0005\u0004bBA\u0018\r\u0011\u0005\u0013\u0011\u0007\u0004\u0007\u0003G\u001a!)!\u001a\t\u0015\u0005\u0015\u0015B!f\u0001\n\u0003\t9\t\u0003\u0006\u0002\u001a&\u0011\t\u0012)A\u0005\u0003\u0013Cq!!\u0014\n\t\u0003\tY\nC\u0005\u0002\"&\u0011\r\u0011\"\u0003\u0002$\"A\u0011\u0011W\u0005!\u0002\u0013\t)\u000bC\u0004\u00020%!\t%!\r\t\u0013\u0005M\u0016\"!A\u0005\u0002\u0005U\u0006\"CA]\u0013E\u0005I\u0011AA^\u0011%\t\t.CA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002d&\t\t\u0011\"\u0001\u0002f\"I\u0011Q^\u0005\u0002\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003wL\u0011\u0011!C!\u0003{D\u0011Ba\u0003\n\u0003\u0003%\tA!\u0004\t\u0013\t]\u0011\"!A\u0005B\te\u0001\"\u0003B\u000f\u0013\u0005\u0005I\u0011\tB\u0010\u0011%\u0011\t#CA\u0001\n\u0003\u0012\u0019\u0003C\u0005\u0003&%\t\t\u0011\"\u0011\u0003(\u001dI!1F\u0002\u0002\u0002#\u0005!Q\u0006\u0004\n\u0003G\u001a\u0011\u0011!E\u0001\u0005_Aq!!\u0014\u001d\t\u0003\u00119\u0005C\u0005\u0003\"q\t\t\u0011\"\u0012\u0003$!I!\u0011\n\u000f\u0002\u0002\u0013\u0005%1\n\u0005\n\u0005\u001fb\u0012\u0011!CA\u0005#B\u0011B!\u0018\u001d\u0003\u0003%IAa\u0018\u0007\r\t\u001d4A\u0011B5\u0011)\u0011YG\tBK\u0002\u0013\u0005\u0011q\u0011\u0005\u000b\u0005[\u0012#\u0011#Q\u0001\n\u0005%\u0005bBA'E\u0011\u0005!q\u000e\u0005\n\u0003C\u0013#\u0019!C\u0005\u0003GC\u0001\"!-#A\u0003%\u0011Q\u0015\u0005\b\u0003_\u0011C\u0011IA\u0019\u0011%\t\u0019LIA\u0001\n\u0003\u0011)\bC\u0005\u0002:\n\n\n\u0011\"\u0001\u0002<\"I\u0011\u0011\u001b\u0012\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003G\u0014\u0013\u0011!C\u0001\u0003KD\u0011\"!<#\u0003\u0003%\tA!\u001f\t\u0013\u0005m(%!A\u0005B\u0005u\b\"\u0003B\u0006E\u0005\u0005I\u0011\u0001B?\u0011%\u00119BIA\u0001\n\u0003\u0012\t\tC\u0005\u0003\u001e\t\n\t\u0011\"\u0011\u0003 !I!\u0011\u0005\u0012\u0002\u0002\u0013\u0005#1\u0005\u0005\n\u0005K\u0011\u0013\u0011!C!\u0005\u000b;\u0011B!#\u0004\u0003\u0003E\tAa#\u0007\u0013\t\u001d4!!A\t\u0002\t5\u0005bBA'k\u0011\u0005!\u0011\u0013\u0005\n\u0005C)\u0014\u0011!C#\u0005GA\u0011B!\u00136\u0003\u0003%\tIa%\t\u0013\t=S'!A\u0005\u0002\n]\u0005\"\u0003B/k\u0005\u0005I\u0011\u0002B0\r\u0019\tIe\u0001\"\u0004\u001c!Q!1N\u001e\u0003\u0016\u0004%\t!a\"\t\u0015\t54H!E!\u0002\u0013\tI\tC\u0004\u0002Nm\"\ta!\b\t\u0013\u0005\u00056H1A\u0005\n\u0005\r\u0006\u0002CAYw\u0001\u0006I!!*\t\u000f\u0005=2\b\"\u0011\u00022!I\u00111W\u001e\u0002\u0002\u0013\u00051\u0011\u0005\u0005\n\u0003s[\u0014\u0013!C\u0001\u0003wC\u0011\"!5<\u0003\u0003%\t%a5\t\u0013\u0005\r8(!A\u0005\u0002\u0005\u0015\b\"CAww\u0005\u0005I\u0011AB\u0013\u0011%\tYpOA\u0001\n\u0003\ni\u0010C\u0005\u0003\fm\n\t\u0011\"\u0001\u0004*!I!qC\u001e\u0002\u0002\u0013\u00053Q\u0006\u0005\n\u0005;Y\u0014\u0011!C!\u0005?A\u0011B!\t<\u0003\u0003%\tEa\t\t\u0013\t\u00152(!A\u0005B\rEr!\u0003BN\u0007\u0005\u0005\t\u0012\u0001BO\r%\tIeAA\u0001\u0012\u0003\u0011y\nC\u0004\u0002N9#\tA!*\t\u0013\t\u0005b*!A\u0005F\t\r\u0002\"\u0003B%\u001d\u0006\u0005I\u0011\u0011BT\u0011%\u0011yETA\u0001\n\u0003\u0013Y\u000bC\u0005\u0003^9\u000b\t\u0011\"\u0003\u0003`\u00191!qV\u0002C\u0005cC!Ba\u001bU\u0005+\u0007I\u0011AAD\u0011)\u0011i\u0007\u0016B\tB\u0003%\u0011\u0011\u0012\u0005\b\u0003\u001b\"F\u0011\u0001BZ\u0011%\t\t\u000b\u0016b\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u00022R\u0003\u000b\u0011BAS\u0011\u001d\ty\u0003\u0016C!\u0003cA\u0011\"a-U\u0003\u0003%\tA!/\t\u0013\u0005eF+%A\u0005\u0002\u0005m\u0006\"CAi)\u0006\u0005I\u0011IAj\u0011%\t\u0019\u000fVA\u0001\n\u0003\t)\u000fC\u0005\u0002nR\u000b\t\u0011\"\u0001\u0003>\"I\u00111 +\u0002\u0002\u0013\u0005\u0013Q \u0005\n\u0005\u0017!\u0016\u0011!C\u0001\u0005\u0003D\u0011Ba\u0006U\u0003\u0003%\tE!2\t\u0013\tuA+!A\u0005B\t}\u0001\"\u0003B\u0011)\u0006\u0005I\u0011\tB\u0012\u0011%\u0011)\u0003VA\u0001\n\u0003\u0012ImB\u0005\u0003N\u000e\t\t\u0011#\u0001\u0003P\u001aI!qV\u0002\u0002\u0002#\u0005!\u0011\u001b\u0005\b\u0003\u001b:G\u0011\u0001Bk\u0011%\u0011\tcZA\u0001\n\u000b\u0012\u0019\u0003C\u0005\u0003J\u001d\f\t\u0011\"!\u0003X\"I!qJ4\u0002\u0002\u0013\u0005%1\u001c\u0005\n\u0005;:\u0017\u0011!C\u0005\u0005?2aAa8\u0004\u0005\n\u0005\bB\u0003Br[\nU\r\u0011\"\u0001\u0002\b\"Q!Q]7\u0003\u0012\u0003\u0006I!!#\t\u000f\u00055S\u000e\"\u0001\u0003h\"I\u0011\u0011U7C\u0002\u0013%!Q\u001e\u0005\t\u0003ck\u0007\u0015!\u0003\u0003p\"9\u0011qF7\u0005B\u0005E\u0002\"CAZ[\u0006\u0005I\u0011\u0001B{\u0011%\tI,\\I\u0001\n\u0003\tY\fC\u0005\u0002R6\f\t\u0011\"\u0011\u0002T\"I\u00111]7\u0002\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003[l\u0017\u0011!C\u0001\u0005sD\u0011\"a?n\u0003\u0003%\t%!@\t\u0013\t-Q.!A\u0005\u0002\tu\b\"\u0003B\f[\u0006\u0005I\u0011IB\u0001\u0011%\u0011i\"\\A\u0001\n\u0003\u0012y\u0002C\u0005\u0003\"5\f\t\u0011\"\u0011\u0003$!I!QE7\u0002\u0002\u0013\u00053QA\u0004\n\u0007\u0013\u0019\u0011\u0011!E\u0001\u0007\u00171\u0011Ba8\u0004\u0003\u0003E\ta!\u0004\t\u0011\u00055\u0013\u0011\u0001C\u0001\u0007#A!B!\t\u0002\u0002\u0005\u0005IQ\tB\u0012\u0011)\u0011I%!\u0001\u0002\u0002\u0013\u000551\u0003\u0005\u000b\u0005\u001f\n\t!!A\u0005\u0002\u000e]\u0001B\u0003B/\u0003\u0003\t\t\u0011\"\u0003\u0003`\t\t\u0012)\u001e;i'\u0016\u0014h/[2f\u0007>tg-[4\u000b\t\u0005E\u00111C\u0001\nCBL7/\u001a:wKJTA!!\u0006\u0002\u0018\u0005A\u0001\u000f\\1uM>\u0014XN\u0003\u0003\u0002\u001a\u0005m\u0011\u0001\u00023b[2T!!!\b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\t\u0019\u0003\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\t\tI#A\u0003tG\u0006d\u0017-\u0003\u0003\u0002.\u0005\u001d\"AB!osJ+g-\u0001\u0004de\u0016\fG/\u001a\u000b\u0003\u0003g\u0001B!!\u000e\u0002D5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0003bkRD'\u0002BA\u001f\u0003\u007f\t1!\u00199j\u0015\u0011\t\t%a\u0006\u0002\r1,GmZ3s\u0013\u0011\t)%a\u000e\u0003\u0017\u0005+H\u000f[*feZL7-Z\u0015\b\u0001m\"&%\\\u0005\u0007\u0005-Qu\u000f^#teU24I\u001d;\u0014\u0007\r\t\u0019#\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003#\u00022!a\u0015\u0004\u001b\t\ty!\u0001\u0005XS2$7-\u0019:e!\r\tIFB\u0007\u0002\u0007\tAq+\u001b7eG\u0006\u0014HmE\u0003\u0007\u0003G\ty\u0006E\u0002\u0002T\u0001!\"!a\u0016\u0003!Us7/\u00194f\u0015^$\b*\\1deU24#C\u0005\u0002$\u0005}\u0013qMA7!\u0011\t)#!\u001b\n\t\u0005-\u0014q\u0005\u0002\b!J|G-^2u!\u0011\ty'a \u000f\t\u0005E\u00141\u0010\b\u0005\u0003g\nI(\u0004\u0002\u0002v)!\u0011qOA\u0010\u0003\u0019a$o\\8u}%\u0011\u0011\u0011F\u0005\u0005\u0003{\n9#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00151\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u0003{\n9#\u0001\u0004tK\u000e\u0014X\r^\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u0014:!\u0011QRAH!\u0011\t\u0019(a\n\n\t\u0005E\u0015qE\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0015q\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005E\u0015qE\u0001\bg\u0016\u001c'/\u001a;!)\u0011\ti*a(\u0011\u0007\u0005e\u0013\u0002C\u0004\u0002\u00062\u0001\r!!#\u0002\u0011Y,'/\u001b4jKJ,\"!!*\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SSA!a+\u0002\u0018\u0005\u0019!n\u001e;\n\t\u0005=\u0016\u0011\u0016\u0002\f\u0015^$h+\u001a:jM&,'/A\u0005wKJLg-[3sA\u0005!1m\u001c9z)\u0011\ti*a.\t\u0013\u0005\u0015\u0005\u0003%AA\u0002\u0005%\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003{SC!!#\u0002@.\u0012\u0011\u0011\u0019\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003%)hn\u00195fG.,GM\u0003\u0003\u0002L\u0006\u001d\u0012AC1o]>$\u0018\r^5p]&!\u0011qZAc\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0007\u0003BAl\u0003Cl!!!7\u000b\t\u0005m\u0017Q\\\u0001\u0005Y\u0006twM\u0003\u0002\u0002`\u0006!!.\u0019<b\u0013\u0011\t)*!7\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\b\u0003BA\u0013\u0003SLA!a;\u0002(\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011_A|!\u0011\t)#a=\n\t\u0005U\u0018q\u0005\u0002\u0004\u0003:L\b\"CA})\u0005\u0005\t\u0019AAt\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q \t\u0007\u0005\u0003\u00119!!=\u000e\u0005\t\r!\u0002\u0002B\u0003\u0003O\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IAa\u0001\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u001f\u0011)\u0002\u0005\u0003\u0002&\tE\u0011\u0002\u0002B\n\u0003O\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002zZ\t\t\u00111\u0001\u0002r\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)Na\u0007\t\u0013\u0005ex#!AA\u0002\u0005\u001d\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u001d\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005U\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0010\t%\u0002\"CA}5\u0005\u0005\t\u0019AAy\u0003A)fn]1gK*;H\u000fS7bGJ*d\u0007E\u0002\u0002Zq\u0019R\u0001\bB\u0019\u0005{\u0001\u0002Ba\r\u0003:\u0005%\u0015QT\u0007\u0003\u0005kQAAa\u000e\u0002(\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u001e\u0005k\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\u0011yD!\u0012\u000e\u0005\t\u0005#\u0002\u0002B\"\u0003;\f!![8\n\t\u0005\u0005%\u0011\t\u000b\u0003\u0005[\tQ!\u00199qYf$B!!(\u0003N!9\u0011QQ\u0010A\u0002\u0005%\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005'\u0012I\u0006\u0005\u0004\u0002&\tU\u0013\u0011R\u0005\u0005\u0005/\n9C\u0001\u0004PaRLwN\u001c\u0005\n\u00057\u0002\u0013\u0011!a\u0001\u0003;\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0007\u0005\u0003\u0002X\n\r\u0014\u0002\u0002B3\u00033\u0014aa\u00142kK\u000e$(a\u0003&xiJ\u001b('\u000e\u001cDeR\u001c\u0012BIA\u0012\u0003?\n9'!\u001c\u0002\u0017\r,'\u000f^5gS\u000e\fG/Z\u0001\rG\u0016\u0014H/\u001b4jG\u0006$X\r\t\u000b\u0005\u0005c\u0012\u0019\bE\u0002\u0002Z\tBqAa\u001b&\u0001\u0004\tI\t\u0006\u0003\u0003r\t]\u0004\"\u0003B6SA\u0005\t\u0019AAE)\u0011\t\tPa\u001f\t\u0013\u0005eX&!AA\u0002\u0005\u001dH\u0003\u0002B\b\u0005\u007fB\u0011\"!?0\u0003\u0003\u0005\r!!=\u0015\t\u0005U'1\u0011\u0005\n\u0003s\u0004\u0014\u0011!a\u0001\u0003O$BAa\u0004\u0003\b\"I\u0011\u0011`\u001a\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\f\u0015^$(k\u001d\u001a6m\r\u0013H\u000fE\u0002\u0002ZU\u001aR!\u000eBH\u0005{\u0001\u0002Ba\r\u0003:\u0005%%\u0011\u000f\u000b\u0003\u0005\u0017#BA!\u001d\u0003\u0016\"9!1\u000e\u001dA\u0002\u0005%E\u0003\u0002B*\u00053C\u0011Ba\u0017:\u0003\u0003\u0005\rA!\u001d\u0002\u0017);H/R:3kY\u001a%\u000f\u001e\t\u0004\u00033r5#\u0002(\u0003\"\nu\u0002\u0003\u0003B\u001a\u0005s\tIIa)\u0011\u0007\u0005e3\b\u0006\u0002\u0003\u001eR!!1\u0015BU\u0011\u001d\u0011Y'\u0015a\u0001\u0003\u0013#BAa\u0015\u0003.\"I!1\f*\u0002\u0002\u0003\u0007!1\u0015\u0002\f\u0015^$Xi]\u001b2e\r\u0013HoE\u0005U\u0003G\ty&a\u001a\u0002nQ!!Q\u0017B\\!\r\tI\u0006\u0016\u0005\b\u0005W:\u0006\u0019AAE)\u0011\u0011)La/\t\u0013\t-4\f%AA\u0002\u0005%E\u0003BAy\u0005\u007fC\u0011\"!?`\u0003\u0003\u0005\r!a:\u0015\t\t=!1\u0019\u0005\n\u0003s\f\u0017\u0011!a\u0001\u0003c$B!!6\u0003H\"I\u0011\u0011 2\u0002\u0002\u0003\u0007\u0011q\u001d\u000b\u0005\u0005\u001f\u0011Y\rC\u0005\u0002z\u0016\f\t\u00111\u0001\u0002r\u0006Y!j\u001e;FgV\n$g\u0011:u!\r\tIfZ\n\u0006O\nM'Q\b\t\t\u0005g\u0011I$!#\u00036R\u0011!q\u001a\u000b\u0005\u0005k\u0013I\u000eC\u0004\u0003l)\u0004\r!!#\u0015\t\tM#Q\u001c\u0005\n\u00057Z\u0017\u0011!a\u0001\u0005k\u0013ABS<u%N\u0014TG\u000e&xWN\u001c\u0012\"\\A\u0012\u0003?\n9'!\u001c\u0002\u0007U\u0014H.\u0001\u0003ve2\u0004C\u0003\u0002Bu\u0005W\u00042!!\u0017n\u0011\u001d\u0011\u0019\u000f\u001da\u0001\u0003\u0013+\"Aa<\u0011\t\u0005\u001d&\u0011_\u0005\u0005\u0005g\fIK\u0001\u0007Ko.\u001ch+\u001a:jM&,'\u000f\u0006\u0003\u0003j\n]\b\"\u0003BriB\u0005\t\u0019AAE)\u0011\t\tPa?\t\u0013\u0005e\b0!AA\u0002\u0005\u001dH\u0003\u0002B\b\u0005\u007fD\u0011\"!?{\u0003\u0003\u0005\r!!=\u0015\t\u0005U71\u0001\u0005\n\u0003s\\\u0018\u0011!a\u0001\u0003O$BAa\u0004\u0004\b!I\u0011\u0011 @\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\r\u0015^$(k\u001d\u001a6m);8n\u001d\t\u0005\u00033\n\ta\u0005\u0004\u0002\u0002\r=!Q\b\t\t\u0005g\u0011I$!#\u0003jR\u001111\u0002\u000b\u0005\u0005S\u001c)\u0002\u0003\u0005\u0003d\u0006\u001d\u0001\u0019AAE)\u0011\u0011\u0019f!\u0007\t\u0015\tm\u0013\u0011BA\u0001\u0002\u0004\u0011IoE\u0005<\u0003G\ty&a\u001a\u0002nQ!!1UB\u0010\u0011\u001d\u0011YG\u0010a\u0001\u0003\u0013#BAa)\u0004$!I!1\u000e\"\u0011\u0002\u0003\u0007\u0011\u0011\u0012\u000b\u0005\u0003c\u001c9\u0003C\u0005\u0002z\u001a\u000b\t\u00111\u0001\u0002hR!!qBB\u0016\u0011%\tI\u0010SA\u0001\u0002\u0004\t\t\u0010\u0006\u0003\u0002V\u000e=\u0002\"CA}\u0013\u0006\u0005\t\u0019AAt)\u0011\u0011yaa\r\t\u0013\u0005eH*!AA\u0002\u0005E\u0018!E!vi\"\u001cVM\u001d<jG\u0016\u001cuN\u001c4jO\u0002")
public interface AuthServiceConfig {
    public AuthService create();

    public static final class JwtEs256Crt
    implements AuthServiceConfig,
    Product,
    Serializable {
        private final String certificate;
        private final JwtVerifier verifier;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String certificate() {
            return this.certificate;
        }

        private JwtVerifier verifier() {
            return this.verifier;
        }

        @Override
        public AuthService create() {
            return AuthServiceJWT$.MODULE$.apply((JwtVerifierBase)this.verifier());
        }

        public JwtEs256Crt copy(String certificate) {
            return new JwtEs256Crt(certificate);
        }

        public String copy$default$1() {
            return this.certificate();
        }

        public String productPrefix() {
            return "JwtEs256Crt";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.certificate();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof JwtEs256Crt;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "certificate";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof JwtEs256Crt)) return false;
            boolean bl = true;
            if (!bl) return false;
            JwtEs256Crt jwtEs256Crt = (JwtEs256Crt)x$1;
            String string = this.certificate();
            String string2 = jwtEs256Crt.certificate();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public JwtEs256Crt(String certificate) {
            this.certificate = certificate;
            Product.$init$((Product)this);
            this.verifier = (JwtVerifier)ECDSAVerifier$.MODULE$.fromCrtFile(certificate, (Function1 & Serializable)x$1 -> Algorithm.ECDSA256((ECPublicKey)x$1, null)).valueOr((Function1 & Serializable)err -> {
                throw new IllegalArgumentException(new StringBuilder(36).append("Failed to create ECDSA256 verifier: ").append(err).toString());
            });
        }
    }

    public static final class JwtEs512Crt
    implements AuthServiceConfig,
    Product,
    Serializable {
        private final String certificate;
        private final JwtVerifier verifier;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String certificate() {
            return this.certificate;
        }

        private JwtVerifier verifier() {
            return this.verifier;
        }

        @Override
        public AuthService create() {
            return AuthServiceJWT$.MODULE$.apply((JwtVerifierBase)this.verifier());
        }

        public JwtEs512Crt copy(String certificate) {
            return new JwtEs512Crt(certificate);
        }

        public String copy$default$1() {
            return this.certificate();
        }

        public String productPrefix() {
            return "JwtEs512Crt";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.certificate();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof JwtEs512Crt;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "certificate";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof JwtEs512Crt)) return false;
            boolean bl = true;
            if (!bl) return false;
            JwtEs512Crt jwtEs512Crt = (JwtEs512Crt)x$1;
            String string = this.certificate();
            String string2 = jwtEs512Crt.certificate();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public JwtEs512Crt(String certificate) {
            this.certificate = certificate;
            Product.$init$((Product)this);
            this.verifier = (JwtVerifier)ECDSAVerifier$.MODULE$.fromCrtFile(certificate, (Function1 & Serializable)x$2 -> Algorithm.ECDSA512((ECPublicKey)x$2, null)).valueOr((Function1 & Serializable)err -> {
                throw new IllegalArgumentException(new StringBuilder(36).append("Failed to create ECDSA512 verifier: ").append(err).toString());
            });
        }
    }

    public static final class JwtRs256Crt
    implements AuthServiceConfig,
    Product,
    Serializable {
        private final String certificate;
        private final JwtVerifier verifier;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String certificate() {
            return this.certificate;
        }

        private JwtVerifier verifier() {
            return this.verifier;
        }

        @Override
        public AuthService create() {
            return AuthServiceJWT$.MODULE$.apply((JwtVerifierBase)this.verifier());
        }

        public JwtRs256Crt copy(String certificate) {
            return new JwtRs256Crt(certificate);
        }

        public String copy$default$1() {
            return this.certificate();
        }

        public String productPrefix() {
            return "JwtRs256Crt";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.certificate();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof JwtRs256Crt;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "certificate";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof JwtRs256Crt)) return false;
            boolean bl = true;
            if (!bl) return false;
            JwtRs256Crt jwtRs256Crt = (JwtRs256Crt)x$1;
            String string = this.certificate();
            String string2 = jwtRs256Crt.certificate();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public JwtRs256Crt(String certificate) {
            this.certificate = certificate;
            Product.$init$((Product)this);
            this.verifier = (JwtVerifier)RSA256Verifier$.MODULE$.fromCrtFile(certificate).valueOr((Function1 & Serializable)err -> {
                throw new IllegalArgumentException(new StringBuilder(34).append("Failed to create RSA256 verifier: ").append(err).toString());
            });
        }
    }

    public static final class JwtRs256Jwks
    implements AuthServiceConfig,
    Product,
    Serializable {
        private final String url;
        private final JwksVerifier verifier;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String url() {
            return this.url;
        }

        private JwksVerifier verifier() {
            return this.verifier;
        }

        @Override
        public AuthService create() {
            return AuthServiceJWT$.MODULE$.apply((JwtVerifierBase)this.verifier());
        }

        public JwtRs256Jwks copy(String url) {
            return new JwtRs256Jwks(url);
        }

        public String copy$default$1() {
            return this.url();
        }

        public String productPrefix() {
            return "JwtRs256Jwks";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.url();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof JwtRs256Jwks;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "url";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof JwtRs256Jwks)) return false;
            boolean bl = true;
            if (!bl) return false;
            JwtRs256Jwks jwtRs256Jwks = (JwtRs256Jwks)x$1;
            String string = this.url();
            String string2 = jwtRs256Jwks.url();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public JwtRs256Jwks(String url) {
            this.url = url;
            Product.$init$((Product)this);
            this.verifier = JwksVerifier$.MODULE$.apply(url);
        }
    }

    public static final class UnsafeJwtHmac256
    implements AuthServiceConfig,
    Product,
    Serializable {
        private final String secret;
        private final JwtVerifier verifier;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String secret() {
            return this.secret;
        }

        private JwtVerifier verifier() {
            return this.verifier;
        }

        @Override
        public AuthService create() {
            return AuthServiceJWT$.MODULE$.apply((JwtVerifierBase)this.verifier());
        }

        public UnsafeJwtHmac256 copy(String secret) {
            return new UnsafeJwtHmac256(secret);
        }

        public String copy$default$1() {
            return this.secret();
        }

        public String productPrefix() {
            return "UnsafeJwtHmac256";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.secret();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UnsafeJwtHmac256;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "secret";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UnsafeJwtHmac256)) return false;
            boolean bl = true;
            if (!bl) return false;
            UnsafeJwtHmac256 unsafeJwtHmac256 = (UnsafeJwtHmac256)x$1;
            String string = this.secret();
            String string2 = unsafeJwtHmac256.secret();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public UnsafeJwtHmac256(String secret) {
            this.secret = secret;
            Product.$init$((Product)this);
            this.verifier = (JwtVerifier)HMAC256Verifier$.MODULE$.apply(secret).valueOr((Function1 & Serializable)err -> {
                throw new IllegalArgumentException(new StringBuilder(24).append("Invalid hmac secret (").append(this.secret()).append("): ").append(err).toString());
            });
        }
    }
}

