/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.configuration;

import akka.Done;
import akka.actor.Cancellable;
import akka.actor.Cancellable$;
import akka.actor.Scheduler;
import akka.stream.Graph;
import akka.stream.KillSwitches$;
import akka.stream.Materializer;
import akka.stream.RestartSettings$;
import akka.stream.UniqueKillSwitch;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.RestartSource$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.domain;
import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.participant.state.index.v2.IndexConfigManagementService;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.package$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.apiserver.configuration.LedgerConfigurationSubscription;
import com.daml.platform.apiserver.configuration.LedgerConfigurationSubscriptionFromIndex;
import com.daml.platform.apiserver.configuration.LedgerConfigurationSubscriptionFromIndex$State$NoConfiguration$;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.HasExecutionContext;
import com.daml.resources.Resource;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\r\rh!\u00028p\u0005EL\bBCA\u0001\u0001\t\u0005\t\u0015!\u0003\u0002\u0006!Q\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005M\u0002A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003\u0007Bq!a\u0014\u0001\t\u0003\t\t\u0006C\u0005\u0002`\u0001\u0011\r\u0011\"\u0003\u0002b!A\u0011q\u000e\u0001!\u0002\u0013\t\u0019\u0007C\u0004\u0002r\u0001!\t!a\u001d\u0007\r\rU\u0004ABB<\u0011)\u0019I(\u0003B\u0001B\u0003%11\u0003\u0005\u000b\u0007OJ!\u0011!Q\u0001\n\r%\u0004BCB/\u0013\t\u0005\t\u0015a\u0003\u0004`!9\u0011qJ\u0005\u0005\u0002\rm\u0004\"CBE\u0013\t\u0007I\u0011BBF\u0011!\u0019\u0019*\u0003Q\u0001\n\r5\u0005\u0002\u0004B/\u0013A\u0005\t1!Q\u0001\n\rU\u0005\"CBY\u0013\t\u0007I\u0011BBZ\u0011!\u0019),\u0003Q\u0001\n\r]\u0005\"CB\\\u0013\t\u0007I\u0011BB]\u0011!\u0019Y,\u0003Q\u0001\n\r-\u0006\u0002DB_\u0013A\u0005\t1!Q\u0001\n\r}\u0006\"CBi\u0013\t\u0007I\u0011BBj\u0011!\u0019).\u0003Q\u0001\n\r\u0005\u0007\"CBl\u0013\t\u0007I\u0011BBm\u0011!\u0019Y.\u0003Q\u0001\n\r\u001d\u0007bBB&\u0013\u0011\u00053Q\n\u0005\b\u0003_LA\u0011IBo\u0011\u001d\u0019y.\u0003C\u0001\u0007C<\u0001\"a/p\u0011\u0003\t\u0018Q\u0018\u0004\b]>D\t!]A`\u0011\u001d\tyE\bC\u0001\u0003\u00034\u0011\"a1\u001f!\u0003\rJ#!2\t\u000f\u0005\u001d\u0007E\"\u0001\u0002J\"9\u0011q\u001e\u0011\u0007\u0002\u0005ExaBB#=!%!q\u0001\u0004\b\u0003\u0007t\u0002\u0012\u0002B\u0002\u0011\u001d\ty\u0005\nC\u0001\u0005\u000b9qAa\u0003%\u0011\u0003\u0013iAB\u0004\u0003\u0012\u0011B\tIa\u0005\t\u000f\u0005=s\u0005\"\u0001\u0003.!I\u0011qY\u0014C\u0002\u0013\u0005\u0013\u0011\u001a\u0005\t\u0005_9\u0003\u0015!\u0003\u0002L\"I\u0011q^\u0014C\u0002\u0013\u0005\u0013\u0011\u001f\u0005\t\u0005c9\u0003\u0015!\u0003\u0002t\"I!1G\u0014\u0002\u0002\u0013\u0005#Q\u0007\u0005\n\u0005\u000f:\u0013\u0011!C\u0001\u0005\u0013B\u0011B!\u0015(\u0003\u0003%\tAa\u0015\t\u0013\t}s%!A\u0005B\t\u0005\u0004\"\u0003B8O\u0005\u0005I\u0011\u0001B9\u0011%\u0011YhJA\u0001\n\u0003\u0012i\bC\u0005\u0003\u0000\u001d\n\t\u0011\"\u0011\u0003\u0002\"I!1Q\u0014\u0002\u0002\u0013%!Q\u0011\u0004\u0007\u0005\u001b##Ia$\t\u0015\tEUG!f\u0001\n\u0003\u0011\u0019\n\u0003\u0006\u0003\u0016V\u0012\t\u0012)A\u0005\u0003#Dq!a\u00146\t\u0003\u00119\nC\u0005\u0002HV\u0012\r\u0011\"\u0011\u0002J\"A!qF\u001b!\u0002\u0013\tY\rC\u0005\u0002pV\u0012\r\u0011\"\u0011\u0002r\"A!\u0011G\u001b!\u0002\u0013\t\u0019\u0010C\u0005\u0003\u001eV\n\t\u0011\"\u0001\u0003 \"I!1U\u001b\u0012\u0002\u0013\u0005!Q\u0015\u0005\n\u0005g)\u0014\u0011!C!\u0005kA\u0011Ba\u00126\u0003\u0003%\tA!\u0013\t\u0013\tES'!A\u0005\u0002\tm\u0006\"\u0003B0k\u0005\u0005I\u0011\tB1\u0011%\u0011y'NA\u0001\n\u0003\u0011y\fC\u0005\u0003DV\n\t\u0011\"\u0011\u0003F\"I!1P\u001b\u0002\u0002\u0013\u0005#Q\u0010\u0005\n\u0005\u007f*\u0014\u0011!C!\u0005\u0003C\u0011B!36\u0003\u0003%\tEa3\b\u0013\t=G%!A\t\u0002\tEg!\u0003BGI\u0005\u0005\t\u0012\u0001Bj\u0011\u001d\ty%\u0013C\u0001\u0005WD\u0011Ba J\u0003\u0003%)E!!\t\u0013\t5\u0018*!A\u0005\u0002\n=\b\"\u0003Bz\u0013\u0006\u0005I\u0011\u0011B{\u0011%\u0011\u0019)SA\u0001\n\u0013\u0011)I\u0002\u0004\u0003\u0002\u0011\u00125Q\u0004\u0005\u000b\u0005#{%Q3A\u0005\u0002\tM\u0005B\u0003BK\u001f\nE\t\u0015!\u0003\u0002R\"I\u0001o\u0014BK\u0002\u0013\u00051q\u0004\u0005\u000b\u0007Cy%\u0011#Q\u0001\n\u0005U\bbBA(\u001f\u0012\u000511\u0005\u0005\n\u0003\u000f|%\u0019!C!\u0003\u0013D\u0001Ba\fPA\u0003%\u00111\u001a\u0005\n\u0003_|%\u0019!C!\u0003cD\u0001B!\rPA\u0003%\u00111\u001f\u0005\n\u0005;{\u0015\u0011!C\u0001\u0007SA\u0011Ba)P#\u0003%\tA!*\t\u0013\r=r*%A\u0005\u0002\rE\u0002\"\u0003B\u001a\u001f\u0006\u0005I\u0011\tB\u001b\u0011%\u00119eTA\u0001\n\u0003\u0011I\u0005C\u0005\u0003R=\u000b\t\u0011\"\u0001\u00046!I!qL(\u0002\u0002\u0013\u0005#\u0011\r\u0005\n\u0005_z\u0015\u0011!C\u0001\u0007sA\u0011Ba1P\u0003\u0003%\te!\u0010\t\u0013\tmt*!A\u0005B\tu\u0004\"\u0003B@\u001f\u0006\u0005I\u0011\tBA\u0011%\u0011ImTA\u0001\n\u0003\u001a\teB\u0005\u0003|\u0012\n\t\u0011#\u0001\u0003~\u001aI!\u0011\u0001\u0013\u0002\u0002#\u0005!q \u0005\b\u0003\u001f2G\u0011AB\u0005\u0011%\u0011yHZA\u0001\n\u000b\u0012\t\tC\u0005\u0003n\u001a\f\t\u0011\"!\u0004\f!I!1\u001f4\u0002\u0002\u0013\u00055\u0011\u0003\u0005\n\u0005\u00073\u0017\u0011!C\u0005\u0005\u000b3\u0011ba\u0012\u001f!\u0003\r\na!\u0013\t\u000f\r-CN\"\u0001\u0004N\tAC*\u001a3hKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+(m]2sSB$\u0018n\u001c8Ge>l\u0017J\u001c3fq*\u0011\u0001/]\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005I\u001c\u0018!C1qSN,'O^3s\u0015\t!X/\u0001\u0005qY\u0006$hm\u001c:n\u0015\t1x/\u0001\u0003eC6d'\"\u0001=\u0002\u0007\r|Wn\u0005\u0002\u0001uB\u00111P`\u0007\u0002y*\tQ0A\u0003tG\u0006d\u0017-\u0003\u0002\u0000y\n1\u0011I\\=SK\u001a\fA\"\u001b8eKb\u001cVM\u001d<jG\u0016\u001c\u0001\u0001\u0005\u0003\u0002\b\u0005uQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u0005Y\u0014$\u0002BA\b\u0003#\tQ!\u001b8eKbTA!a\u0005\u0002\u0016\u0005)1\u000f^1uK*!\u0011qCA\r\u0003-\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;\u000b\u0007\u0005mQ/\u0001\u0004mK\u0012<WM]\u0005\u0005\u0003?\tIA\u0001\u000fJ]\u0012,\u0007pQ8oM&<W*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u0003[\tA!Y6lC&!\u0011\u0011GA\u0014\u0005%\u00196\r[3ek2,'/\u0001\u0007nCR,'/[1mSj,'\u000f\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\u0011\tY$a\u000b\u0002\rM$(/Z1n\u0013\u0011\ty$!\u000f\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u00021M,'O^5dKN,\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tI\u0005`\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA'\u0003\u000f\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?))\t\u0019&a\u0016\u0002Z\u0005m\u0013Q\f\t\u0004\u0003+\u0002Q\"A8\t\u000f\u0005\u0005Q\u00011\u0001\u0002\u0006!9\u0011\u0011E\u0003A\u0002\u0005\r\u0002bBA\u001a\u000b\u0001\u0007\u0011Q\u0007\u0005\b\u0003\u0003*\u0001\u0019AA\"\u0003\u0019awnZ4feV\u0011\u00111\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011N;\u0002\u000f1|wmZ5oO&!\u0011QNA4\u0005Q\u0019uN\u001c;fqR,\u0018\r\\5{K\u0012dunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001D:vEN\u001c'/\u001b9uS>tG\u0003BA;\u0007K\"B!a\u001e\u0004\\A1\u0011\u0011PAM\u0003?sA!a\u001f\u0002\u0014:!\u0011QPAH\u001d\u0011\ty(!$\u000f\t\u0005\u0005\u00151\u0012\b\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*!\u0011qQA\u0002\u0003\u0019a$o\\8u}%\t\u00010\u0003\u0002wo&\u0019\u00111D;\n\t\u0005E\u0015\u0011D\u0001\ne\u0016\u001cx.\u001e:dKNLA!!&\u0002\u0018\u00069\u0001/Y2lC\u001e,'\u0002BAI\u00033IA!a'\u0002\u001e\ni!+Z:pkJ\u001cWmT<oKJTA!!&\u0002\u0018J1\u0011\u0011UAS\u0003W3a!a)\u0001\u0001\u0005}%\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003BA+\u0003OK1!!+p\u0005}aU\rZ4fe\u000e{gNZ5hkJ\fG/[8o'V\u00147o\u0019:jaRLwN\u001c\t\u0004\u0003[cgbAAX;9!\u0011\u0011WA]\u001d\u0011\t\u0019,a.\u000f\t\u0005}\u0014QW\u0005\u0003iVL!A]:\n\u0005A\f\u0018\u0001\u000b'fI\u001e,'oQ8oM&<WO]1uS>t7+\u001e2tGJL\u0007\u000f^5p]\u001a\u0013x.\\%oI\u0016D\bcAA+=M\u0011aD\u001f\u000b\u0003\u0003{\u0013Qa\u0015;bi\u0016\u001c\"\u0001\t>\u0002\u00191\fG/Z:u\u001f\u001a47/\u001a;\u0016\u0005\u0005-\u0007#B>\u0002N\u0006E\u0017bAAhy\n1q\n\u001d;j_:\u0004B!a5\u0002j:!\u0011Q[Ar\u001d\u0011\t9.!8\u000f\t\u0005u\u0014\u0011\\\u0005\u0005\u00037\fI\"A\u0002ba&LA!a8\u0002b\u00061Am\\7bS:TA!a7\u0002\u001a%!\u0011Q]At\u00031aU\rZ4fe>3gm]3u\u0015\u0011\ty.!9\n\t\u0005-\u0018Q\u001e\u0002\t\u0003\n\u001cx\u000e\\;uK*!\u0011Q]At\u0003Ma\u0017\r^3ti\u000e{gNZ5hkJ\fG/[8o+\t\t\u0019\u0010E\u0003|\u0003\u001b\f)\u0010\u0005\u0003\u0002x\u0006mXBAA}\u0015\r\u0001\u0018\u0011D\u0005\u0005\u0003{\fIPA\u0007D_:4\u0017nZ;sCRLwN\\\u0015\u0005A=;SG\u0001\nD_:4\u0017nZ;sCRLwN\u001c$pk:$7C\u0001\u0013{)\t\u00119\u0001E\u0002\u0003\n\u0011j\u0011AH\u0001\u0010\u001d>\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0019!qB\u0014\u000e\u0003\u0011\u0012qBT8D_:4\u0017nZ;sCRLwN\\\n\tOi\u0014)Ba\u0006\u0003\u001eA\u0019!\u0011\u0002\u0011\u0011\u0007m\u0014I\"C\u0002\u0003\u001cq\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003 \t\u001db\u0002\u0002B\u0011\u0005KqA!a!\u0003$%\tQ0C\u0002\u0002\u0016rLAA!\u000b\u0003,\ta1+\u001a:jC2L'0\u00192mK*\u0019\u0011Q\u0013?\u0015\u0005\t5\u0011!\u00047bi\u0016\u001cHo\u00144gg\u0016$\b%\u0001\u000bmCR,7\u000f^\"p]\u001aLw-\u001e:bi&|g\u000eI\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t]\u0002\u0003\u0002B\u001d\u0005\u0007j!Aa\u000f\u000b\t\tu\"qH\u0001\u0005Y\u0006twM\u0003\u0002\u0003B\u0005!!.\u0019<b\u0013\u0011\u0011)Ea\u000f\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011Y\u0005E\u0002|\u0005\u001bJ1Aa\u0014}\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011)Fa\u0017\u0011\u0007m\u00149&C\u0002\u0003Zq\u00141!\u00118z\u0011%\u0011ifLA\u0001\u0002\u0004\u0011Y%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005G\u0002bA!\u001a\u0003l\tUSB\u0001B4\u0015\r\u0011I\u0007`\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B7\u0005O\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u000fB=!\rY(QO\u0005\u0004\u0005ob(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005;\n\u0014\u0011!a\u0001\u0005+\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005\u0017\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005o\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\"\u0011\t\te\"\u0011R\u0005\u0005\u0005\u0017\u0013YD\u0001\u0004PE*,7\r\u001e\u0002\u001b\u001f:d\u0017PU3kK\u000e$X\rZ\"p]\u001aLw-\u001e:bi&|gn]\n\tki\u0014)Ba\u0006\u0003\u001e\u00051qN\u001a4tKR,\"!!5\u0002\u000f=4gm]3uAQ!!\u0011\u0014BN!\r\u0011y!\u000e\u0005\b\u0005#C\u0004\u0019AAi\u0003\u0011\u0019w\u000e]=\u0015\t\te%\u0011\u0015\u0005\n\u0005#k\u0004\u0013!a\u0001\u0003#\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003(*\"\u0011\u0011\u001bBUW\t\u0011Y\u000b\u0005\u0003\u0003.\n]VB\u0001BX\u0015\u0011\u0011\tLa-\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B[y\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te&q\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003\u0002B+\u0005{C\u0011B!\u0018B\u0003\u0003\u0005\rAa\u0013\u0015\t\tM$\u0011\u0019\u0005\n\u0005;\u001a\u0015\u0011!a\u0001\u0005+\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!q\u0007Bd\u0011%\u0011i\u0006RA\u0001\u0002\u0004\u0011Y%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005g\u0012i\rC\u0005\u0003^\u001d\u000b\t\u00111\u0001\u0003V\u0005QrJ\u001c7z%\u0016TWm\u0019;fI\u000e{gNZ5hkJ\fG/[8ogB\u0019!qB%\u0014\u000b%\u0013)N!9\u0011\u0011\t]'Q\\Ai\u00053k!A!7\u000b\u0007\tmG0A\u0004sk:$\u0018.\\3\n\t\t}'\u0011\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003\u0002Br\u0005Sl!A!:\u000b\t\t\u001d(qH\u0001\u0003S>LAA!\u000b\u0003fR\u0011!\u0011[\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u00053\u0013\t\u0010C\u0004\u0003\u00122\u0003\r!!5\u0002\u000fUt\u0017\r\u001d9msR!\u00111\u001aB|\u0011%\u0011I0TA\u0001\u0002\u0004\u0011I*A\u0002yIA\n!cQ8oM&<WO]1uS>tgi\\;oIB\u0019!q\u00024\u0014\u000b\u0019\u001c\tA!9\u0011\u0015\t]71AAi\u0003k\u001c9!\u0003\u0003\u0004\u0006\te'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA\u0019!qB(\u0015\u0005\tuHCBB\u0004\u0007\u001b\u0019y\u0001C\u0004\u0003\u0012&\u0004\r!!5\t\rAL\u0007\u0019AA{)\u0011\u0019\u0019ba\u0007\u0011\u000bm\fim!\u0006\u0011\u000fm\u001c9\"!5\u0002v&\u00191\u0011\u0004?\u0003\rQ+\b\u000f\\33\u0011%\u0011IP[A\u0001\u0002\u0004\u00199a\u0005\u0005Pu\nU!q\u0003B\u000f+\t\t)0\u0001\bd_:4\u0017nZ;sCRLwN\u001c\u0011\u0015\r\r\u001d1QEB\u0014\u0011\u001d\u0011\t\n\u0016a\u0001\u0003#Da\u0001\u001d+A\u0002\u0005UHCBB\u0004\u0007W\u0019i\u0003C\u0005\u0003\u0012f\u0003\n\u00111\u0001\u0002R\"A\u0001/\u0017I\u0001\u0002\u0004\t)0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rM\"\u0006BA{\u0005S#BA!\u0016\u00048!I!Q\f0\u0002\u0002\u0003\u0007!1\n\u000b\u0005\u0005g\u001aY\u0004C\u0005\u0003^\u0001\f\t\u00111\u0001\u0003VQ!!qGB \u0011%\u0011i&YA\u0001\u0002\u0004\u0011Y\u0005\u0006\u0003\u0003t\r\r\u0003\"\u0003B/I\u0006\u0005\t\u0019\u0001B+\u0003\u0015\u0019F/\u0019;f\u0005\u001dI5OU3bIf\u001c\"\u0001\u001c>\u0002\u000bI,\u0017\rZ=\u0016\u0005\r=\u0003CBA#\u0007#\u001a)&\u0003\u0003\u0004T\u0005\u001d#A\u0002$viV\u0014X\rE\u0002|\u0007/J1a!\u0017}\u0005\u0011)f.\u001b;\t\u000f\ru\u0003\u0002q\u0001\u0004`\u0005qAn\\4hS:<7i\u001c8uKb$\b\u0003BA3\u0007CJAaa\u0019\u0002h\tqAj\\4hS:<7i\u001c8uKb$\bbBB4\u0011\u0001\u00071\u0011N\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8M_\u0006$G+[7f_V$\b\u0003BB6\u0007cj!a!\u001c\u000b\t\r=\u0014qI\u0001\tIV\u0014\u0018\r^5p]&!11OB7\u0005!!UO]1uS>t'\u0001D*vEN\u001c'/\u001b9uS>t7CB\u0005{\u0003K\u000bY+A\u000bti\u0006\u0014H/\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\r\ru4QQBD)\u0011\u0019yha!\u0011\u0007\r\u0005\u0015\"D\u0001\u0001\u0011\u001d\u0019i&\u0004a\u0002\u0007?Bqa!\u001f\u000e\u0001\u0004\u0019\u0019\u0002C\u0004\u0004h5\u0001\ra!\u001b\u0002\u0019I,\u0017\rZ=Qe>l\u0017n]3\u0016\u0005\r5\u0005CBA#\u0007\u001f\u001b)&\u0003\u0003\u0004\u0012\u0006\u001d#a\u0002)s_6L7/Z\u0001\u000ee\u0016\fG-\u001f)s_6L7/\u001a\u0011\u0011\u000fm\u001c9ba&\u0004,B11\u0011TBS\u0007Sk!aa'\u000b\t\ru5qT\u0001\u0007CR|W.[2\u000b\t\u0005%3\u0011\u0015\u0006\u0005\u0007G\u0013y$\u0001\u0003vi&d\u0017\u0002BBT\u00077\u0013q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0004\u0003[\u0003\u0003\u0003BA\u0013\u0007[KAaa,\u0002(\tY1)\u00198dK2d\u0017M\u00197f\u00031\u0019WO\u001d:f]R\u001cF/\u0019;f+\t\u00199*A\u0007dkJ\u0014XM\u001c;Ti\u0006$X\rI\u0001\u0011g\u000eDW\rZ;mK\u0012$\u0016.\\3pkR,\"aa+\u0002#M\u001c\u0007.\u001a3vY\u0016$G+[7f_V$\b%A\u0002yII\u0002ra_B\f\u0007\u0003\u001c9\r\u0005\u0003\u00028\r\r\u0017\u0002BBc\u0003s\u0011\u0001#\u00168jcV,7*\u001b7m'^LGo\u00195\u0011\r\u0005\u00153\u0011KBe!\u0011\u0019Ym!4\u000e\u0005\u0005-\u0012\u0002BBh\u0003W\u0011A\u0001R8oK\u0006Q1.\u001b7m'^LGo\u00195\u0016\u0005\r\u0005\u0017aC6jY2\u001cv/\u001b;dQ\u0002\n\u0001cY8na2,G/[8o\rV$XO]3\u0016\u0005\r\u001d\u0017!E2p[BdW\r^5p]\u001a+H/\u001e:fAQ\u0011\u00111_\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0004P\u0001")
public final class LedgerConfigurationSubscriptionFromIndex {
    public final IndexConfigManagementService com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$indexService;
    public final Scheduler com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$scheduler;
    public final Materializer com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$materializer;
    public final ExecutionContext com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$servicesExecutionContext;
    private final ContextualizedLogger com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger;

    public ContextualizedLogger com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger() {
        return this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger;
    }

    public AbstractResourceOwner<ResourceContext, LedgerConfigurationSubscription> subscription(Duration configurationLoadTimeout, LoggingContext loggingContext) {
        return new AbstractResourceOwner<ResourceContext, LedgerConfigurationSubscription>(this, loggingContext, configurationLoadTimeout){
            private final /* synthetic */ LedgerConfigurationSubscriptionFromIndex $outer;
            private final LoggingContext loggingContext$1;
            private final Duration configurationLoadTimeout$1;

            public Resource<ResourceContext, LedgerConfigurationSubscription> acquire(ResourceContext context) {
                return package$.MODULE$.Resource().apply(this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$indexService.lookupConfiguration(this.loggingContext$1).map((Function1 & Serializable)startingConfiguration -> new Subscription($this.$outer, (Option<Tuple2<domain.LedgerOffset.Absolute, Configuration>>)startingConfiguration, $this.configurationLoadTimeout$1, $this.loggingContext$1), context.executionContext()), (Function1 & Serializable)subscription -> subscription.stop(), (Object)context);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.loggingContext$1 = loggingContext$1;
                this.configurationLoadTimeout$1 = configurationLoadTimeout$1;
                super((HasExecutionContext)ResourceContext.Context$u0020has$u0020ExecutionContext$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$acquire$1(com.daml.platform.apiserver.configuration.LedgerConfigurationSubscriptionFromIndex$$anon$1 scala.Option ), $anonfun$acquire$2(com.daml.platform.apiserver.configuration.LedgerConfigurationSubscriptionFromIndex$Subscription )}, serializedLambda);
            }
        };
    }

    public LedgerConfigurationSubscriptionFromIndex(IndexConfigManagementService indexService, Scheduler scheduler, Materializer materializer, ExecutionContext servicesExecutionContext) {
        this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$indexService = indexService;
        this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$scheduler = scheduler;
        this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$materializer = materializer;
        this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$servicesExecutionContext = servicesExecutionContext;
        this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }

    public static interface IsReady {
        public Future<BoxedUnit> ready();
    }

    private static interface State {
        public Option<domain.LedgerOffset.Absolute> latestOffset();

        public Option<Configuration> latestConfiguration();
    }

    private final class Subscription
    implements LedgerConfigurationSubscription,
    IsReady {
        public final Duration com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$configurationLoadTimeout;
        public final LoggingContext com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$loggingContext;
        private final Promise<BoxedUnit> com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$readyPromise;
        private final /* synthetic */ Tuple2 x$1;
        private final AtomicReference<State> currentState;
        private final Cancellable scheduledTimeout;
        private final /* synthetic */ Tuple2 x$2;
        private final UniqueKillSwitch killSwitch;
        private final Future<Done> completionFuture;
        private final /* synthetic */ LedgerConfigurationSubscriptionFromIndex $outer;

        public Promise<BoxedUnit> com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$readyPromise() {
            return this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$readyPromise;
        }

        private AtomicReference<State> currentState() {
            return this.currentState;
        }

        private Cancellable scheduledTimeout() {
            return this.scheduledTimeout;
        }

        private UniqueKillSwitch killSwitch() {
            return this.killSwitch;
        }

        private Future<Done> completionFuture() {
            return this.completionFuture;
        }

        @Override
        public Future<BoxedUnit> ready() {
            return this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$readyPromise().future();
        }

        @Override
        public Option<Configuration> latestConfiguration() {
            return this.currentState().get().latestConfiguration();
        }

        public Future<BoxedUnit> stop() {
            this.scheduledTimeout().cancel();
            this.killSwitch().shutdown();
            return this.completionFuture().map((Function1 & Serializable)x$3 -> {
                Subscription.$anonfun$stop$1(x$3);
                return BoxedUnit.UNIT;
            }, this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$servicesExecutionContext);
        }

        public /* synthetic */ LedgerConfigurationSubscriptionFromIndex com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$$outer() {
            return this.$outer;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static final /* synthetic */ void $anonfun$x$2$2(Subscription $this, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                domain.LedgerOffset.Absolute offset = (domain.LedgerOffset.Absolute)tuple2._1();
                domain.ConfigurationEntry configurationEntry = (domain.ConfigurationEntry)tuple2._2();
                if (configurationEntry instanceof domain.ConfigurationEntry$.Accepted) {
                    domain.ConfigurationEntry$.Accepted accepted = (domain.ConfigurationEntry$.Accepted)configurationEntry;
                    Configuration configuration = accepted.configuration();
                    $this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger().info().apply((Function0 & Serializable)() -> new StringBuilder(35).append("New ledger configuration ").append(configuration).append(" found at ").append(offset).toString(), $this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$loggingContext);
                    $this.scheduledTimeout().cancel();
                    $this.currentState().set(new State.ConfigurationFound(offset, configuration));
                    $this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$readyPromise().trySuccess((Object)BoxedUnit.UNIT);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            domain.LedgerOffset.Absolute offset = (domain.LedgerOffset.Absolute)tuple2._1();
            if (!(tuple2._2() instanceof domain.ConfigurationEntry$.Rejected)) throw new MatchError((Object)tuple2);
            $this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger().info().apply((Function0 & Serializable)() -> new StringBuilder(44).append("New ledger configuration rejection found at ").append(offset).toString(), $this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$loggingContext);
            $this.currentState().updateAndGet(x0$2 -> {
                Product product;
                State state = x0$2;
                boolean bl = LedgerConfigurationSubscriptionFromIndex$State$NoConfiguration$.MODULE$.equals(state) ? true : state instanceof State.OnlyRejectedConfigurations;
                if (bl) {
                    product = new State.OnlyRejectedConfigurations(offset);
                } else if (state instanceof State.ConfigurationFound) {
                    State.ConfigurationFound configurationFound = (State.ConfigurationFound)state;
                    Configuration configuration = configurationFound.configuration();
                    product = new State.ConfigurationFound(offset, configuration);
                } else {
                    throw new MatchError((Object)state);
                }
                return product;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$stop$1(Done x$3) {
        }

        public Subscription(LedgerConfigurationSubscriptionFromIndex $outer, Option<Tuple2<domain.LedgerOffset.Absolute, Configuration>> startingConfiguration, Duration configurationLoadTimeout, LoggingContext loggingContext) {
            Tuple2 tuple2;
            Some some;
            Tuple2 tuple22;
            this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$configurationLoadTimeout = configurationLoadTimeout;
            this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$loggingContext = loggingContext;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$readyPromise = Promise$.MODULE$.apply();
            Option<Tuple2<domain.LedgerOffset.Absolute, Configuration>> option = startingConfiguration;
            if (option instanceof Some && (tuple22 = (Tuple2)(some = (Some)option).value()) != null) {
                domain.LedgerOffset.Absolute offset = (domain.LedgerOffset.Absolute)tuple22._1();
                Configuration configuration = (Configuration)tuple22._2();
                $outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger().info().apply((Function0 & Serializable)() -> new StringBuilder(117).append("Initial ledger configuration lookup found configuration ").append(configuration).append(" at ").append(offset).append(". Looking for new ledger configurations from this offset.").toString(), loggingContext);
                this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$readyPromise().trySuccess((Object)BoxedUnit.UNIT);
                State.ConfigurationFound state = new State.ConfigurationFound(offset, configuration);
                tuple2 = new Tuple2(new AtomicReference<State.ConfigurationFound>(state), (Object)Cancellable$.MODULE$.alreadyCancelled());
            } else if (None$.MODULE$.equals(option)) {
                $outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger().info().apply((Function0 & Serializable)() -> "Initial ledger configuration lookup did not find any configuration. Looking for new ledger configurations from the ledger beginning.", loggingContext);
                LedgerConfigurationSubscriptionFromIndex$State$NoConfiguration$ state = LedgerConfigurationSubscriptionFromIndex$State$NoConfiguration$.MODULE$;
                Cancellable scheduledTimeout = $outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$scheduler.scheduleOnce(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(configurationLoadTimeout.toNanos())).nanos(), new Runnable(this){
                    private final /* synthetic */ Subscription $outer;

                    public void run() {
                        block0: {
                            if (!this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$readyPromise().trySuccess((Object)BoxedUnit.UNIT)) break block0;
                            this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$$outer().com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$logger().warn().apply((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(75).append("No ledger configuration found after ").append($this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$configurationLoadTimeout).append(". The ledger API server will now start ").toString()).append("but all services that depend on the ledger configuration will return ").append(new StringBuilder(50).append(RequestValidation.NotFound$.LedgerConfiguration$.MODULE$.id()).append(" until at least one ledger configuration is found.").toString()).toString(), this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$loggingContext);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(com.daml.platform.apiserver.configuration.LedgerConfigurationSubscriptionFromIndex$Subscription$$anon$2 )}, serializedLambda);
                    }
                }, $outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$servicesExecutionContext);
                tuple2 = new Tuple2(new AtomicReference<LedgerConfigurationSubscriptionFromIndex$State$NoConfiguration$>(state), (Object)scheduledTimeout);
            } else {
                throw new MatchError(option);
            }
            Tuple2 tuple23 = tuple2;
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            AtomicReference currentState = (AtomicReference)tuple23._1();
            Cancellable scheduledTimeout = (Cancellable)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)currentState, (Object)scheduledTimeout);
            this.x$1 = tuple24;
            this.currentState = (AtomicReference)this.x$1._1();
            this.scheduledTimeout = (Cancellable)this.x$1._2();
            Tuple2 tuple25 = (Tuple2)RestartSource$.MODULE$.withBackoff(RestartSettings$.MODULE$.apply(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds(), 0.1), (Function0 & Serializable)() -> (Source)$this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$indexService.configurationEntries(this.currentState().get().latestOffset(), $this.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$Subscription$$loggingContext).map((Function1 & Serializable)x0$1 -> {
                Subscription.$anonfun$x$2$2(this, x0$1);
                return BoxedUnit.UNIT;
            })).viaMat(KillSwitches$.MODULE$.single(), Keep$.MODULE$.right()).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.both()).run($outer.com$daml$platform$apiserver$configuration$LedgerConfigurationSubscriptionFromIndex$$materializer);
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            UniqueKillSwitch killSwitch = (UniqueKillSwitch)tuple25._1();
            Future completionFuture = (Future)tuple25._2();
            Tuple2 tuple26 = new Tuple2((Object)killSwitch, (Object)completionFuture);
            this.x$2 = tuple26;
            this.killSwitch = (UniqueKillSwitch)this.x$2._1();
            this.completionFuture = (Future)this.x$2._2();
        }
    }
}

