/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.execution;

import com.daml.error.definitions.ErrorCause;
import com.daml.ledger.api.DeduplicationPeriod;
import com.daml.ledger.api.domain;
import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.participant.state.index.v2.ContractStore;
import com.daml.ledger.participant.state.index.v2.MaximumLedgerTime;
import com.daml.ledger.participant.state.v2.SubmitterInfo;
import com.daml.ledger.participant.state.v2.TransactionMeta;
import com.daml.lf.command.ApiCommands;
import com.daml.lf.crypto.Hash;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Time;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.lf.value.Value;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.execution.CommandExecutionResult;
import com.daml.platform.apiserver.execution.CommandExecutor;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005ed!B\u0007\u000f\u0005AA\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!Aa\b\u0001B\u0001B\u0003-q\bC\u0003F\u0001\u0011\u0005a\tC\u0004O\u0001\t\u0007I\u0011B(\t\rY\u0003\u0001\u0015!\u0003Q\u0011\u00159\u0006\u0001\"\u0011Y\u0011!\ti\u0004\u0001Q\u0005\n\u0005}\u0002\u0002CA(\u0001\u0001&I!!\u0015\t\u0011\u0005=\u0004\u0001)C\u0005\u0003c\u0012a\u0004T3eO\u0016\u0014H+[7f\u0003^\f'/Z\"p[6\fg\u000eZ#yK\u000e,Ho\u001c:\u000b\u0005=\u0001\u0012!C3yK\u000e,H/[8o\u0015\t\t\"#A\u0005ba&\u001cXM\u001d<fe*\u00111\u0003F\u0001\ta2\fGOZ8s[*\u0011QCF\u0001\u0005I\u0006lGNC\u0001\u0018\u0003\r\u0019w.\\\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!C5\ta\"\u0003\u0002#\u001d\ty1i\\7nC:$W\t_3dkR|'/\u0001\u0005eK2,w-\u0019;f\u0007\u0001\tQbY8oiJ\f7\r^*u_J,\u0007CA\u00143\u001b\u0005A#BA\u0015+\u0003\t1(G\u0003\u0002,Y\u0005)\u0011N\u001c3fq*\u0011QFL\u0001\u0006gR\fG/\u001a\u0006\u0003_A\n1\u0002]1si&\u001c\u0017\u000e]1oi*\u0011\u0011\u0007F\u0001\u0007Y\u0016$w-\u001a:\n\u0005MB#!D\"p]R\u0014\u0018m\u0019;Ti>\u0014X-\u0001\u0006nCb\u0014V\r\u001e:jKN\u0004\"A\u0007\u001c\n\u0005]Z\"aA%oi\u00069Q.\u001a;sS\u000e\u001c\bC\u0001\u001e=\u001b\u0005Y$B\u0001\u001d\u0015\u0013\ti4HA\u0004NKR\u0014\u0018nY:\u0002\u0005\u0015\u001c\u0007C\u0001!D\u001b\u0005\t%B\u0001\"\u001c\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\t\u0006\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u00159%j\u0013'N)\tA\u0015\n\u0005\u0002!\u0001!)aH\u0002a\u0002\u007f!)1E\u0002a\u0001?!)QE\u0002a\u0001M!)AG\u0002a\u0001k!)\u0001H\u0002a\u0001s\u00051An\\4hKJ,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'R\tq\u0001\\8hO&tw-\u0003\u0002V%\n!2i\u001c8uKb$X/\u00197ju\u0016$Gj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0004fq\u0016\u001cW\u000f^3\u0015\reK\u0018\u0011DA\u0017)\tQF\u000fE\u0002A7vK!\u0001X!\u0003\r\u0019+H/\u001e:f!\u0011qf-[9\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012%\u0003\u0019a$o\\8u}%\tA$\u0003\u0002f7\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005\u0019)\u0015\u000e\u001e5fe*\u0011Qm\u0007\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\f1\u0002Z3gS:LG/[8og*\u0011a\u000eF\u0001\u0006KJ\u0014xN]\u0005\u0003a.\u0014!\"\u0012:s_J\u001c\u0015-^:f!\t\u0001#/\u0003\u0002t\u001d\t12i\\7nC:$W\t_3dkRLwN\u001c*fgVdG\u000fC\u0003v\u0013\u0001\u000fa/\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\u0005E;\u0018B\u0001=S\u00059aunZ4j]\u001e\u001cuN\u001c;fqRDQA_\u0005A\u0002m\f\u0001bY8n[\u0006tGm\u001d\t\u0004y\u0006MabA?\u0002\u000e9\u0019a0!\u0003\u000f\u0007}\f9A\u0004\u0003\u0002\u0002\u0005\u0015ab\u00011\u0002\u0004%\tq#\u0003\u0002\u0016-%\u0011\u0011\u0007F\u0005\u0004\u0003\u0017\u0001\u0014aA1qS&!\u0011qBA\t\u0003\u0019!w.\\1j]*\u0019\u00111\u0002\u0019\n\t\u0005U\u0011q\u0003\u0002\t\u0007>lW.\u00198eg*!\u0011qBA\t\u0011\u001d\tY\"\u0003a\u0001\u0003;\tab];c[&\u001c8/[8o'\u0016,G\r\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\r\t9\u0003F\u0001\u0003Y\u001aLA!a\u000b\u0002\"\t!\u0001*Y:i\u0011\u001d\ty#\u0003a\u0001\u0003c\t1\u0003\\3eO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o\u0001\u0014!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002<\u0005U\"!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0003m_>\u0004HCCA!\u0003\u000b\n9%!\u0013\u0002LQ\u0019!,a\u0011\t\u000bUT\u00019\u0001<\t\u000biT\u0001\u0019A>\t\u000f\u0005m!\u00021\u0001\u0002\u001e!9\u0011q\u0006\u0006A\u0002\u0005E\u0002BBA'\u0015\u0001\u0007Q'A\u0006sKR\u0014\u0018.Z:MK\u001a$\u0018!E1em\u0006t7-Z(viB,H\u000fV5nKR)\u0011/a\u0015\u0002X!1\u0011QK\u0006A\u0002E\f1A]3t\u0011\u001d\tIf\u0003a\u0001\u00037\nqA\\3x)&lW\r\u0005\u0003\u0002^\u0005%d\u0002BA0\u0003Kj!!!\u0019\u000b\t\u0005\r\u0014QE\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0002h\u0005\u0005\u0014\u0001\u0002+j[\u0016LA!a\u001b\u0002n\tIA+[7fgR\fW\u000e\u001d\u0006\u0005\u0003O\n\t'\u0001\tbIZ\fgnY3J]B,H\u000fV5nKR)10a\u001d\u0002x!1\u0011Q\u000f\u0007A\u0002m\f1aY7e\u0011\u001d\tI\u0006\u0004a\u0001\u00037\u0002")
public final class LedgerTimeAwareCommandExecutor
implements CommandExecutor {
    private final CommandExecutor delegate;
    private final ContractStore contractStore;
    private final int maxRetries;
    private final Metrics metrics;
    private final ExecutionContext ec;
    private final ContextualizedLogger logger;

    private ContextualizedLogger logger() {
        return this.logger;
    }

    @Override
    public Future<Either<ErrorCause, CommandExecutionResult>> execute(domain.Commands commands, Hash submissionSeed, Configuration ledgerConfiguration2, LoggingContext loggingContext) {
        return this.loop(commands, submissionSeed, ledgerConfiguration2, this.maxRetries, loggingContext);
    }

    private Future<Either<ErrorCause, CommandExecutionResult>> loop(domain.Commands commands, Hash submissionSeed, Configuration ledgerConfiguration2, int retriesLeft, LoggingContext loggingContext) {
        return this.delegate.execute(commands, submissionSeed, ledgerConfiguration2, loggingContext).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                future = Future$.MODULE$.successful((Object)left);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                CommandExecutionResult cer = (CommandExecutionResult)right.value();
                Set usedContractIds = (Set)cer.transaction().inputContracts().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Value.ContractId, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1;
                        A1 A12 = x1;
                        Object object = A12 != null ? (A1 = A12) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Value.ContractId x1) {
                        Value.ContractId contractId = x1;
                        boolean bl = contractId != null;
                        return bl;
                    }
                });
                future = $this.contractStore.lookupMaximumLedgerTimeAfterInterpretation(usedContractIds, loggingContext).transformWith((Function1 & Serializable)x0$2 -> {
                    MaximumLedgerTime maximumLedgerTime;
                    MaximumLedgerTime maximumLedgerTime2;
                    MaximumLedgerTime maximumLedgerTime3;
                    MaximumLedgerTime.Max max;
                    Time.Timestamp maxUsedTime;
                    MaximumLedgerTime maximumLedgerTime4;
                    boolean bl = false;
                    Success success = null;
                    Try try_ = x0$2;
                    if (try_ instanceof Success) {
                        bl = true;
                        success = (Success)try_;
                        MaximumLedgerTime maximumLedgerTime5 = (MaximumLedgerTime)success.value();
                        if (MaximumLedgerTime.NotAvailable$.MODULE$.equals(maximumLedgerTime5)) {
                            return LedgerTimeAwareCommandExecutor.success$1(cer);
                        }
                    }
                    if (bl && (maximumLedgerTime4 = (MaximumLedgerTime)success.value()) instanceof MaximumLedgerTime.Max && (maxUsedTime = (max = (MaximumLedgerTime.Max)maximumLedgerTime4).ledgerTime()).$less$eq((Object)commands.commands().ledgerEffectiveTime())) {
                        return LedgerTimeAwareCommandExecutor.success$1(cer);
                    }
                    if (bl && (maximumLedgerTime3 = (MaximumLedgerTime)success.value()) instanceof MaximumLedgerTime.Max) {
                        MaximumLedgerTime.Max max2 = (MaximumLedgerTime.Max)maximumLedgerTime3;
                        Time.Timestamp maxUsedTime2 = max2.ledgerTime();
                        if (!cer.dependsOnLedgerTime()) {
                            this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(56).append("Advancing ledger effective time for the output from ").append(commands.commands().ledgerEffectiveTime()).append(" to ").append(maxUsedTime2).toString(), loggingContext);
                            return LedgerTimeAwareCommandExecutor.success$1(this.advanceOutputTime(cer, maxUsedTime2));
                        }
                    }
                    if (bl && (maximumLedgerTime2 = (MaximumLedgerTime)success.value()) instanceof MaximumLedgerTime.Max) {
                        Future future;
                        MaximumLedgerTime.Max max3 = (MaximumLedgerTime.Max)maximumLedgerTime2;
                        Time.Timestamp maxUsedTime3 = max3.ledgerTime();
                        if (retriesLeft > 0) {
                            this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(58).append("Restarting the computation with new ledger effective time ").append(maxUsedTime3).toString(), loggingContext);
                            future = this.retry$1(this.advanceInputTime(commands, maxUsedTime3), submissionSeed, ledgerConfiguration2, retriesLeft, loggingContext);
                            return future;
                        } else {
                            future = this.failed$1(retriesLeft);
                        }
                        return future;
                    }
                    if (bl && (maximumLedgerTime = (MaximumLedgerTime)success.value()) instanceof MaximumLedgerTime.Archived) {
                        Future future;
                        MaximumLedgerTime.Archived archived = (MaximumLedgerTime.Archived)maximumLedgerTime;
                        Set contracts = archived.contracts();
                        if (retriesLeft > 0) {
                            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(63).append("Some input contracts are archived: ").append(contracts.mkString("[", ", ", "]")).append(" Restarting the computation.").toString(), loggingContext);
                            future = this.retry$1(commands, submissionSeed, ledgerConfiguration2, retriesLeft, loggingContext);
                            return future;
                        } else {
                            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(62).append("Lookup of maximum ledger time failed after ").append($this.maxRetries - retriesLeft).append(". Used contracts: ").append(usedContractIds.mkString("[", ", ", "]")).append(".").toString(), loggingContext);
                            future = this.failed$1(retriesLeft);
                        }
                        return future;
                    }
                    if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                    Failure failure = (Failure)try_;
                    Throwable error = failure.exception();
                    this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(72).append("Lookup of maximum ledger time failed after ").append($this.maxRetries - retriesLeft).append(". Used contracts: ").append(usedContractIds.mkString("[", ", ", "]")).append(". Details: ").append(error).toString(), loggingContext);
                    return this.failed$1(retriesLeft);
                }, $this.ec);
            } else {
                throw new MatchError((Object)either);
            }
            return future;
        }, this.ec);
    }

    private CommandExecutionResult advanceOutputTime(CommandExecutionResult res, Time.Timestamp newTime) {
        TransactionMeta x$1 = res.transactionMeta().copy(newTime, res.transactionMeta().copy$default$2(), res.transactionMeta().copy$default$3(), res.transactionMeta().copy$default$4(), res.transactionMeta().copy$default$5(), res.transactionMeta().copy$default$6(), res.transactionMeta().copy$default$7());
        SubmitterInfo x$2 = res.copy$default$1();
        VersionedTransaction x$3 = res.copy$default$3();
        boolean x$4 = res.copy$default$4();
        long x$5 = res.copy$default$5();
        Map<GlobalKey, Option<Value.ContractId>> x$6 = res.copy$default$6();
        return res.copy(x$2, x$1, x$3, x$4, x$5, x$6);
    }

    private domain.Commands advanceInputTime(domain.Commands cmd, Time.Timestamp newTime) {
        Time.Timestamp x$1 = newTime;
        ImmArray x$2 = cmd.commands().copy$default$1();
        String x$3 = cmd.commands().copy$default$3();
        ApiCommands x$4 = cmd.commands().copy(x$2, x$1, x$3);
        Option x$5 = cmd.copy$default$1();
        Option x$6 = cmd.copy$default$2();
        String x$7 = cmd.copy$default$3();
        Object x$8 = cmd.copy$default$4();
        Option x$9 = cmd.copy$default$5();
        Set x$10 = cmd.copy$default$6();
        Set x$11 = cmd.copy$default$7();
        Time.Timestamp x$12 = cmd.copy$default$8();
        DeduplicationPeriod x$13 = cmd.copy$default$9();
        return cmd.copy(x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$4);
    }

    private final Future failed$1(int retriesLeft$1) {
        return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new ErrorCause.LedgerTime(this.maxRetries - retriesLeft$1)));
    }

    private static final Future success$1(CommandExecutionResult c) {
        return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)c));
    }

    private final Future retry$1(domain.Commands c, Hash submissionSeed$1, Configuration ledgerConfiguration$1, int retriesLeft$1, LoggingContext loggingContext$1) {
        this.metrics.daml().execution().retry().mark();
        return this.loop(c, submissionSeed$1, ledgerConfiguration$1, retriesLeft$1 - 1, loggingContext$1);
    }

    public LedgerTimeAwareCommandExecutor(CommandExecutor delegate, ContractStore contractStore, int maxRetries, Metrics metrics, ExecutionContext ec) {
        this.delegate = delegate;
        this.contractStore = contractStore;
        this.maxRetries = maxRetries;
        this.metrics = metrics;
        this.ec = ec;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

