/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.domain$LedgerOffset$LedgerEnd$;
import com.daml.ledger.api.messages.command.completion.CompletionStreamRequest;
import com.daml.ledger.api.v1.command_completion_service.CompletionStreamResponse;
import com.daml.ledger.api.validation.CompletionServiceRequestValidator;
import com.daml.ledger.participant.state.index.v2.IndexCompletionsService;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.logging.entries.LoggingEntries;
import com.daml.logging.entries.LoggingEntries$;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.services.ApiCommandCompletionService$;
import com.daml.platform.apiserver.services.ApiCommandCompletionService$Logging$;
import com.daml.platform.apiserver.services.StreamMetrics$;
import com.daml.platform.apiserver.services.logging.package$;
import com.daml.platform.server.api.ValidationLogger$;
import com.daml.platform.server.api.services.domain.CommandCompletionService;
import com.daml.platform.server.api.services.grpc.GrpcCommandCompletionService;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b!B\u000e\u001d\u0005y1\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t-\u0002\u0011)\u0019!C\n/\"A\u0001\r\u0001B\u0001B\u0003%\u0001\f\u0003\u0005b\u0001\t\u0015\r\u0011b\u0005c\u0011!Y\u0007A!A!\u0002\u0013\u0019\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b1B7\t\u0011M\u0004!\u0011!Q\u0001\fQDQA\u001f\u0001\u0005\nmD\u0011\"!\u0004\u0001\u0005\u0004%Y!a\u0004\t\u0011\u0005]\u0001\u0001)A\u0005\u0003#A\u0011\"!\u0007\u0001\u0005\u0004%Y!a\u0007\t\u0011\u0005%\u0002\u0001)A\u0005\u0003;A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003_Aq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002\b\u0002!\t%!#\b\u0011\u0005mF\u0004#\u0001\u001f\u0003{3qa\u0007\u000f\t\u0002y\ty\f\u0003\u0004{)\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003\u0007$B\u0011AAc\u000f\u001d\u0011\t\u0001\u0006E\u0005\u0005\u00071qAa\u0002\u0015\u0011\u0013\u0011I\u0001\u0003\u0004{1\u0011\u0005!1\u0002\u0005\b\u0005\u001bAB\u0011\u0001B\b\u0005m\t\u0005/[\"p[6\fg\u000eZ\"p[BdW\r^5p]N+'O^5dK*\u0011QDH\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0004I\u0001\nCBL7/\u001a:wKJT!!\t\u0012\u0002\u0011Ad\u0017\r\u001e4pe6T!a\t\u0013\u0002\t\u0011\fW\u000e\u001c\u0006\u0002K\u0005\u00191m\\7\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Yj\u0011a\f\u0006\u0003aE\na\u0001Z8nC&t'BA\u000f3\u0015\t\u0019D'A\u0002ba&T!!\u000e\u0011\u0002\rM,'O^3s\u0013\t9tF\u0001\rD_6l\u0017M\u001c3D_6\u0004H.\u001a;j_:\u001cVM\u001d<jG\u0016\f!cY8na2,G/[8ogN+'O^5dK\u000e\u0001\u0001CA\u001eG\u001b\u0005a$BA\u001f?\u0003\t1(G\u0003\u0002@\u0001\u0006)\u0011N\u001c3fq*\u0011\u0011IQ\u0001\u0006gR\fG/\u001a\u0006\u0003\u0007\u0012\u000b1\u0002]1si&\u001c\u0017\u000e]1oi*\u0011QII\u0001\u0007Y\u0016$w-\u001a:\n\u0005\u001dc$aF%oI\u0016D8i\\7qY\u0016$\u0018n\u001c8t'\u0016\u0014h/[2f\u0003%1\u0018\r\\5eCR|'\u000f\u0005\u0002K\u001d6\t1J\u0003\u0002M\u001b\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005M\"\u0015BA(L\u0005\u0005\u001au.\u001c9mKRLwN\\*feZL7-\u001a*fcV,7\u000f\u001e,bY&$\u0017\r^8s\u0003\u001diW\r\u001e:jGN\u0004\"A\u0015+\u000e\u0003MS!\u0001\u0015\u0012\n\u0005U\u001b&aB'fiJL7m]\u0001\r[\u0006$XM]5bY&TXM]\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0007gR\u0014X-Y7\u000b\u0003u\u000bA!Y6lC&\u0011qL\u0017\u0002\r\u001b\u0006$XM]5bY&TXM]\u0001\u000e[\u0006$XM]5bY&TXM\u001d\u0011\u0002\u0007\u0015\u001ch-F\u0001d!\t!\u0017.D\u0001f\u0015\t1w-A\u0004bI\u0006\u0004H/\u001a:\u000b\u0005!\u0014\u0013\u0001B4sa\u000eL!A[3\u00033\u0015CXmY;uS>t7+Z9vK:\u001cWM\u001d$bGR|'/_\u0001\u0005KN4\u0007%\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB\u0011a.]\u0007\u0002_*\u0011\u0001/K\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001:p\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\u0005UDX\"\u0001<\u000b\u0005]\u0014\u0013a\u00027pO\u001eLgnZ\u0005\u0003sZ\u0014a\u0002T8hO&twmQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\by\u0006\u001d\u0011\u0011BA\u0006)!ix0!\u0001\u0002\u0004\u0005\u0015\u0001C\u0001@\u0001\u001b\u0005a\u0002\"\u0002,\u000b\u0001\bA\u0006\"B1\u000b\u0001\b\u0019\u0007\"\u00027\u000b\u0001\bi\u0007\"B:\u000b\u0001\b!\b\"\u0002\u001d\u000b\u0001\u0004Q\u0004\"\u0002%\u000b\u0001\u0004I\u0005\"\u0002)\u000b\u0001\u0004\t\u0016A\u00027pO\u001e,'/\u0006\u0002\u0002\u0012A\u0019Q/a\u0005\n\u0007\u0005UaO\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003e\u0019wN\u001c;fqR,\u0018\r\\5{K\u0012,%O]8s\u0019><w-\u001a:\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\"%A\u0003feJ|'/\u0003\u0003\u0002(\u0005\u0005\"!\b#b[2\u001cuN\u001c;fqR,\u0018\r\\5{K\u0012,%O]8s\u0019><w-\u001a:\u00025\r|g\u000e^3yiV\fG.\u001b>fI\u0016\u0013(o\u001c:M_\u001e<WM\u001d\u0011\u0002+M,(m]2sSB$\u0018n\u001c8JI\u000e{WO\u001c;feV\u0011\u0011q\u0006\t\u0005\u0003c\t\t%\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0019\tGo\\7jG*\u0019\u0001/!\u000f\u000b\t\u0005m\u0012QH\u0001\u0005kRLGN\u0003\u0002\u0002@\u0005!!.\u0019<b\u0013\u0011\t\u0019%a\r\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\ftk\n\u001c8M]5qi&|g.\u00133D_VtG/\u001a:!\u0003Y\u0019w.\u001c9mKRLwN\\*ue\u0016\fWnU8ve\u000e,G\u0003BA&\u0003_\u0002\u0002\"!\u0014\u0002T\u0005]\u0013qM\u0007\u0003\u0003\u001fR1!!\u0015[\u0003!\u00198-\u00197bINd\u0017\u0002BA+\u0003\u001f\u0012aaU8ve\u000e,\u0007\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u001bG>lW.\u00198e?\u000e|W\u000e\u001d7fi&|gnX:feZL7-\u001a\u0006\u0004\u0003Cj\u0015A\u0001<2\u0013\u0011\t)'a\u0017\u00031\r{W\u000e\u001d7fi&|gn\u0015;sK\u0006l'+Z:q_:\u001cX\r\u0005\u0003\u0002j\u0005-T\"\u0001/\n\u0007\u00055DLA\u0004O_R,6/\u001a3\t\u000f\u0005E\u0014\u00031\u0001\u0002t\u00059!/Z9vKN$\b\u0003BA;\u0003\u0007k!!a\u001e\u000b\t\u0005e\u00141P\u0001\u000bG>l\u0007\u000f\\3uS>t'\u0002BA?\u0003\u007f\nqaY8n[\u0006tGMC\u0002\u0002\u00026\u000b\u0001\"\\3tg\u0006<Wm]\u0005\u0005\u0003\u000b\u000b9HA\fD_6\u0004H.\u001a;j_:\u001cFO]3b[J+\u0017/^3ti\u0006aq-\u001a;MK\u0012<WM]#oIR\u0011\u00111\u0012\t\u0006]\u00065\u0015\u0011S\u0005\u0004\u0003\u001f{'A\u0002$viV\u0014X\r\u0005\u0003\u0002\u0014\u0006Uf\u0002BAK\u0003_sA!a&\u0002.:!\u0011\u0011TAV\u001d\u0011\tY*!+\u000f\t\u0005u\u0015q\u0015\b\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111U\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0013BA\u0012%\u0013\t)%%\u0003\u00024\t&\u0011\u0001'T\u0005\u0005\u0003c\u000b\u0019,\u0001\u0007MK\u0012<WM](gMN,GO\u0003\u00021\u001b&!\u0011qWA]\u0005!\t%m]8mkR,'\u0002BAY\u0003g\u000b1$\u00119j\u0007>lW.\u00198e\u0007>l\u0007\u000f\\3uS>t7+\u001a:wS\u000e,\u0007C\u0001@\u0015'\t!r\u0005\u0006\u0002\u0002>\u000611M]3bi\u0016$\u0002\"a2\u0002t\u0006u\u0018q \u000b\u000b\u0003\u0013\fY/!<\u0002p\u0006E\bC\u0002\u0015\u0002L6\ny-C\u0002\u0002N&\u0012a\u0001V;qY\u0016\u0014$CBAi\u0003+\fyN\u0002\u0004\u0002TR\u0001\u0011q\u001a\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0005\u0003/\fY.\u0004\u0002\u0002Z*\u0011\u0001.M\u0005\u0005\u0003;\fIN\u0001\u000fHeB\u001c7i\\7nC:$7i\\7qY\u0016$\u0018n\u001c8TKJ4\u0018nY3\u0011\t\u0005\u0005\u0018q]\u0007\u0003\u0003GT1\u0001[As\u0015\t\u0019\u0004%\u0003\u0003\u0002j\u0006\r(AD$sa\u000e\f\u0005/[*feZL7-\u001a\u0005\u0006-Z\u0001\u001d\u0001\u0017\u0005\u0006CZ\u0001\u001da\u0019\u0005\u0006YZ\u0001\u001d!\u001c\u0005\u0006gZ\u0001\u001d\u0001\u001e\u0005\b\u0003k4\u0002\u0019AA|\u0003!aW\rZ4fe&#\u0007\u0003BAK\u0003sLA!a?\u00024\nAA*\u001a3hKJLE\rC\u00039-\u0001\u0007!\bC\u0003Q-\u0001\u0007\u0011+A\u0004M_\u001e<\u0017N\\4\u0011\u0007\t\u0015\u0001$D\u0001\u0015\u0005\u001daunZ4j]\u001e\u001c\"\u0001G\u0014\u0015\u0005\t\r\u0011A\u0006:fgB|gn]3U_2{wmZ5oOZ\u000bG.^3\u0015\t\tE!Q\u0004\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)\u0019!q\u0003<\u0002\u000f\u0015tGO]5fg&!!1\u0004B\u000b\u00051aunZ4j]\u001e4\u0016\r\\;f\u0011\u001d\u0011yB\u0007a\u0001\u0003/\n\u0001B]3ta>t7/\u001a")
public final class ApiCommandCompletionService
implements CommandCompletionService {
    private final IndexCompletionsService completionsService;
    private final CompletionServiceRequestValidator validator;
    private final Metrics metrics;
    private final Materializer materializer;
    private final ExecutionSequencerFactory esf;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final DamlContextualizedErrorLogger contextualizedErrorLogger;
    private final AtomicLong subscriptionIdCounter;

    public static Tuple2<CommandCompletionService, GrpcCommandCompletionService> create(Object ledgerId, IndexCompletionsService completionsService, Metrics metrics, Materializer materializer, ExecutionSequencerFactory esf, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ApiCommandCompletionService$.MODULE$.create(ledgerId, completionsService, metrics, materializer, esf, executionContext, loggingContext);
    }

    public Materializer materializer() {
        return this.materializer;
    }

    public ExecutionSequencerFactory esf() {
        return this.esf;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private DamlContextualizedErrorLogger contextualizedErrorLogger() {
        return this.contextualizedErrorLogger;
    }

    private AtomicLong subscriptionIdCounter() {
        return this.subscriptionIdCounter;
    }

    public Source<CompletionStreamResponse, NotUsed> completionStreamSource(CompletionStreamRequest request) {
        return (Source)Source$.MODULE$.future(this.getLedgerEnd()).flatMapConcat((Function1 & Serializable)ledgerEnd -> (Source)$this.validator.validateCompletionStreamRequest(request, ledgerEnd, (ContextualizedErrorLogger)this.contextualizedErrorLogger()).fold((Function1 & Serializable)t -> Source$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure((Object)request, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable)request -> (Source)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.parties((Iterable<String>)request.parties()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.offset((Option<domain.LedgerOffset>)request.offset())}), (Function1 & Serializable)loggingContext -> {
            String subscriptionId = Long.toString(this.subscriptionIdCounter().getAndIncrement());
            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(47).append("Received request for completion subscription ").append(subscriptionId).append(": ").append(request).toString(), loggingContext);
            domain.LedgerOffset offset = (domain.LedgerOffset)request.offset().getOrElse((Function0 & Serializable)() -> domain$LedgerOffset$LedgerEnd$.MODULE$);
            return $this.completionsService.getCompletions(offset, request.applicationId(), request.parties(), loggingContext).via((Graph)this.logger().enrichedDebugStream("Responding with completions.", (Function1 & Serializable)response -> new LoggingEntries(LoggingEntries$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response"), (Object)ApiCommandCompletionService$Logging$.MODULE$.responseToLoggingValue(response))}))), loggingContext)).via((Graph)this.logger().logErrorsOnStream(loggingContext)).via(StreamMetrics$.MODULE$.countElements($this.metrics.daml().lapi().streams().completions()));
        }, $this.loggingContext)));
    }

    public Future<domain.LedgerOffset.Absolute> getLedgerEnd() {
        return this.completionsService.currentLedgerEnd(this.loggingContext).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    public ApiCommandCompletionService(IndexCompletionsService completionsService, CompletionServiceRequestValidator validator, Metrics metrics, Materializer materializer, ExecutionSequencerFactory esf, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.completionsService = completionsService;
        this.validator = validator;
        this.metrics = metrics;
        this.materializer = materializer;
        this.esf = esf;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.subscriptionIdCounter = new AtomicLong();
    }
}

