/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services;

import com.daml.daml_lf_dev.DamlLf;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.v1.package_service.GetPackageRequest;
import com.daml.ledger.api.v1.package_service.GetPackageResponse;
import com.daml.ledger.api.v1.package_service.GetPackageStatusRequest;
import com.daml.ledger.api.v1.package_service.GetPackageStatusResponse;
import com.daml.ledger.api.v1.package_service.HashFunction;
import com.daml.ledger.api.v1.package_service.ListPackagesRequest;
import com.daml.ledger.api.v1.package_service.ListPackagesResponse;
import com.daml.ledger.api.v1.package_service.PackageServiceGrpc;
import com.daml.ledger.api.v1.package_service.PackageServiceGrpc$;
import com.daml.ledger.api.v1.package_service.PackageServiceGrpc$PackageService$;
import com.daml.ledger.api.v1.package_service.PackageStatus;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.ledger.participant.state.index.v2.IndexPackagesService;
import com.daml.lf.data.Ref$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.logging.entries.LoggingValue$;
import com.daml.logging.entries.ToLoggingValue$;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.services.ApiPackageService$;
import com.daml.platform.server.api.ValidationLogger$;
import io.grpc.ServerServiceDefinition;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\u001da!B\n\u0015\u0005Yq\u0002\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011a\u0003!\u0011!Q\u0001\feC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006Y\u0001\u0019\u0005\u0006M\u0002!Ia\u001a\u0005\b]\u0002\u0011\r\u0011b\u0003p\u0011\u0019\u0019\b\u0001)A\u0005a\")A\u000f\u0001C!k\")Q\u0010\u0001C!}\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003k\u0001A\u0011IA\u001c\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017Bq!a+\u0001\t\u0013\ti\u000bC\u0004\u0002J\u0002!I!a3\b\u0011\u0005mG\u0003#\u0001\u0019\u0003;4qa\u0005\u000b\t\u0002a\ty\u000e\u0003\u0004g!\u0011\u0005\u0011\u0011\u001d\u0005\b\u0003G\u0004B\u0011AAs\u0005E\t\u0005/\u001b)bG.\fw-Z*feZL7-\u001a\u0006\u0003+Y\t\u0001b]3sm&\u001cWm\u001d\u0006\u0003/a\t\u0011\"\u00199jg\u0016\u0014h/\u001a:\u000b\u0005eQ\u0012\u0001\u00039mCR4wN]7\u000b\u0005ma\u0012\u0001\u00023b[2T\u0011!H\u0001\u0004G>l7\u0003\u0002\u0001 K\u0011\u0003\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014B\u001d\t9cH\u0004\u0002)w9\u0011\u0011\u0006\u000f\b\u0003UUr!aK\u001a\u000f\u00051\u0012dBA\u00172\u001b\u0005q#BA\u00181\u0003\u0019a$o\\8u}\r\u0001\u0011\"A\u000f\n\u0005ma\u0012B\u0001\u001b\u001b\u0003\u0019aW\rZ4fe&\u0011agN\u0001\u0004CBL'B\u0001\u001b\u001b\u0013\tI$(\u0001\u0002wc)\u0011agN\u0005\u0003yu\nq\u0002]1dW\u0006<WmX:feZL7-\u001a\u0006\u0003siJ!a\u0010!\u0002%A\u000b7m[1hKN+'O^5dK\u001e\u0013\bo\u0019\u0006\u0003yuJ!AQ\"\u0003\u001dA\u000b7m[1hKN+'O^5dK*\u0011q\b\u0011\t\u0003\u000b&k\u0011A\u0012\u0006\u0003\u000f\"\u000bAa\u001a:qG*\u0011a\u0007G\u0005\u0003\u0015\u001a\u0013ab\u0012:qG\u0006\u0003\u0018nU3sm&\u001cW-A\u0004cC\u000e\\WM\u001c3\u0011\u000553V\"\u0001(\u000b\u0005=\u0003\u0016A\u0001<3\u0015\t\t&+A\u0003j]\u0012,\u0007P\u0003\u0002T)\u0006)1\u000f^1uK*\u0011QkN\u0001\fa\u0006\u0014H/[2ja\u0006tG/\u0003\u0002X\u001d\n!\u0012J\u001c3fqB\u000b7m[1hKN\u001cVM\u001d<jG\u0016\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005ikV\"A.\u000b\u0005q\u000b\u0013AC2p]\u000e,(O]3oi&\u0011al\u0017\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0002\\8hO&twmQ8oi\u0016DH\u000f\u0005\u0002bI6\t!M\u0003\u0002d5\u00059An\\4hS:<\u0017BA3c\u00059aunZ4j]\u001e\u001cuN\u001c;fqR\fa\u0001P5oSRtDC\u00015n)\rI7\u000e\u001c\t\u0003U\u0002i\u0011\u0001\u0006\u0005\u00061\u0012\u0001\u001d!\u0017\u0005\u0006?\u0012\u0001\u001d\u0001\u0019\u0005\u0006\u0017\u0012\u0001\r\u0001T\u0001\u0007Y><w-\u001a:\u0016\u0003A\u0004\"!Y9\n\u0005I\u0014'\u0001F\"p]R,\u0007\u0010^;bY&TX\r\u001a'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0017\tLg\u000eZ*feZL7-\u001a\u000b\u0002mB\u0011qo_\u0007\u0002q*\u0011q)\u001f\u0006\u0002u\u0006\u0011\u0011n\\\u0005\u0003yb\u0014qcU3sm\u0016\u00148+\u001a:wS\u000e,G)\u001a4j]&$\u0018n\u001c8\u0002\u000b\rdwn]3\u0015\u0003}\u00042\u0001IA\u0001\u0013\r\t\u0019!\t\u0002\u0005+:LG/\u0001\u0007mSN$\b+Y2lC\u001e,7\u000f\u0006\u0003\u0002\n\u0005]\u0001#\u0002.\u0002\f\u0005=\u0011bAA\u00077\n1a)\u001e;ve\u0016\u0004B!!\u0005\u0002\u00145\t\u0001)C\u0002\u0002\u0016\u0001\u0013A\u0003T5tiB\u000b7m[1hKN\u0014Vm\u001d9p]N,\u0007bBA\r\u0013\u0001\u0007\u00111D\u0001\be\u0016\fX/Z:u!\u0011\t\t\"!\b\n\u0007\u0005}\u0001IA\nMSN$\b+Y2lC\u001e,7OU3rk\u0016\u001cH/\u0001\u0006hKR\u0004\u0016mY6bO\u0016$B!!\n\u0002.A)!,a\u0003\u0002(A!\u0011\u0011CA\u0015\u0013\r\tY\u0003\u0011\u0002\u0013\u000f\u0016$\b+Y2lC\u001e,'+Z:q_:\u001cX\rC\u0004\u0002\u001a)\u0001\r!a\f\u0011\t\u0005E\u0011\u0011G\u0005\u0004\u0003g\u0001%!E$fiB\u000b7m[1hKJ+\u0017/^3ti\u0006\u0001r-\u001a;QC\u000e\\\u0017mZ3Ti\u0006$Xo\u001d\u000b\u0005\u0003s\t\t\u0005E\u0003[\u0003\u0017\tY\u0004\u0005\u0003\u0002\u0012\u0005u\u0012bAA \u0001\nAr)\u001a;QC\u000e\\\u0017mZ3Ti\u0006$Xo\u001d*fgB|gn]3\t\u000f\u0005e1\u00021\u0001\u0002DA!\u0011\u0011CA#\u0013\r\t9\u0005\u0011\u0002\u0018\u000f\u0016$\b+Y2lC\u001e,7\u000b^1ukN\u0014V-];fgR\fac^5uQZ\u000bG.\u001b3bi\u0016$\u0007+Y2lC\u001e,\u0017\nZ\u000b\u0007\u0003\u001b\nI&a*\u0015\r\u0005=\u0013qRAR)\u0011\t\t&!\u001c\u0015\t\u0005M\u00131\u000e\t\u00065\u0006-\u0011Q\u000b\t\u0005\u0003/\nI\u0006\u0004\u0001\u0005\u000f\u0005mCB1\u0001\u0002^\t\tA+\u0005\u0003\u0002`\u0005\u0015\u0004c\u0001\u0011\u0002b%\u0019\u00111M\u0011\u0003\u000f9{G\u000f[5oOB\u0019\u0001%a\u001a\n\u0007\u0005%\u0014EA\u0002B]fDQa\u0018\u0007A\u0004\u0001Dq!a\u001c\r\u0001\u0004\t\t(A\u0003cY>\u001c7\u000eE\u0004!\u0003g\n9(a\u0015\n\u0007\u0005U\u0014EA\u0005Gk:\u001cG/[8ocA!\u0011\u0011PAE\u001d\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000bA\u0001Z1uC*\u0019\u00111\u0011\u000e\u0002\u000514\u0017\u0002BAD\u0003{\n1AU3g\u0013\u0011\tY)!$\u0003\u0013A\u000b7m[1hK&#'\u0002BAD\u0003{Bq!!%\r\u0001\u0004\t\u0019*A\u0005qC\u000e\\\u0017mZ3JIB!\u0011QSAO\u001d\u0011\t9*!'\u0011\u00055\n\u0013bAANC\u00051\u0001K]3eK\u001aLA!a(\u0002\"\n11\u000b\u001e:j]\u001eT1!a'\"\u0011\u001d\tI\u0002\u0004a\u0001\u0003K\u0003B!a\u0016\u0002(\u00129\u0011\u0011\u0016\u0007C\u0002\u0005u#!\u0001*\u0002)Q|w)\u001a;QC\u000e\\\u0017mZ3SKN\u0004xN\\:f)\u0011\t9#a,\t\u000f\u0005EV\u00021\u0001\u00024\u00069\u0011M]2iSZ,\u0007\u0003BA[\u0003\u0007tA!a.\u0002>:\u00191&!/\n\u0007\u0005m&$A\u0006eC6dw\f\u001c4`I\u00164\u0018\u0002BA`\u0003\u0003\fa\u0001R1nY23'bAA^5%!\u0011QYAd\u0005\u001d\t%o\u00195jm\u0016TA!a0\u0002B\u0006y2M]3bi\u0016\u001cuN\u001c;fqR,\u0018\r\\5{K\u0012,%O]8s\u0019><w-\u001a:\u0015\t\u00055\u0017\u0011\u001c\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*\u0019\u00111\u001b\u000e\u0002\u000b\u0015\u0014(o\u001c:\n\t\u0005]\u0017\u0011\u001b\u0002\u001e\t\u0006lGnQ8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4fe\")qL\u0004a\u0002A\u0006\t\u0012\t]5QC\u000e\\\u0017mZ3TKJ4\u0018nY3\u0011\u0005)\u00042C\u0001\t )\t\ti.\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003O\f\u0019P!\u0002\u0015\r\u0005%\u0018q^Ay%\u0011\tY/\n#\u0007\r\u00055\b\u0003AAu\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0011\u0015A&\u0003q\u0001Z\u0011\u0015y&\u0003q\u0001a\u0011\u001d\t)P\u0005a\u0001\u0003o\f\u0001\u0002\\3eO\u0016\u0014\u0018\n\u001a\t\u0005\u0003s\fyPD\u0002*\u0003wL1!!@;\u0003\u0019!w.\\1j]&!!\u0011\u0001B\u0002\u0005!aU\rZ4fe&#'bAA\u007fu!)1J\u0005a\u0001\u0019\u0002")
public final class ApiPackageService
implements PackageServiceGrpc.PackageService,
GrpcApiService {
    private final IndexPackagesService backend;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;

    public static PackageServiceGrpc.PackageService create(Object ledgerId, IndexPackagesService backend, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ApiPackageService$.MODULE$.create(ledgerId, backend, executionContext, loggingContext);
    }

    public PackageServiceGrpc$PackageService$ serviceCompanion() {
        return PackageServiceGrpc.PackageService.serviceCompanion$((PackageServiceGrpc.PackageService)this);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public ServerServiceDefinition bindService() {
        return PackageServiceGrpc$.MODULE$.bindService((PackageServiceGrpc.PackageService)this, this.executionContext);
    }

    public void close() {
    }

    public Future<ListPackagesResponse> listPackages(ListPackagesRequest request) {
        this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(35).append("Received request to list packages: ").append(request).toString(), this.loggingContext);
        return this.backend.listLfPackages(this.loggingContext).map((Function1 & Serializable)p -> new ListPackagesResponse(p.keys().toSeq()), this.executionContext).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    public Future<GetPackageResponse> getPackage(GetPackageRequest request) {
        return (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"packageId"), (Object)LoggingValue$.MODULE$.from((Object)request.packageId(), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(32).append("Received request for a package: ").append(request).toString(), loggingContext);
            return this.withValidatedPackageId(request.packageId(), (Object)request, (Function1 & Serializable)packageId -> $this.backend.getLfArchive(packageId, loggingContext).flatMap((Function1 & Serializable)x0$1 -> {
                Future future;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    future = Future$.MODULE$.failed((Throwable)new RequestValidation.NotFound$.Package$.Reject(packageId, (ContextualizedErrorLogger)this.createContextualizedErrorLogger((LoggingContext)loggingContext)).asGrpcError());
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    DamlLf.Archive archive = (DamlLf.Archive)some.value();
                    future = Future$.MODULE$.successful((Object)this.toGetPackageResponse(archive));
                } else {
                    throw new MatchError((Object)option);
                }
                return future;
            }, $this.executionContext).andThen(this.logger().logErrorsOnCall(loggingContext), $this.executionContext), (LoggingContext)loggingContext);
        }, this.loggingContext);
    }

    public Future<GetPackageStatusResponse> getPackageStatus(GetPackageStatusRequest request) {
        return (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"packageId"), (Object)LoggingValue$.MODULE$.from((Object)request.packageId(), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(39).append("Received request for a package status: ").append(request).toString(), loggingContext);
            return this.withValidatedPackageId(request.packageId(), (Object)request, (Function1 & Serializable)packageId -> $this.backend.listLfPackages(loggingContext).map((Function1 & Serializable)packages -> {
                PackageStatus.REGISTERED$ result = packages.contains(packageId) ? PackageStatus.REGISTERED$.MODULE$ : PackageStatus.UNKNOWN$.MODULE$;
                return new GetPackageStatusResponse((PackageStatus)result);
            }, $this.executionContext).andThen(this.logger().logErrorsOnCall(loggingContext), $this.executionContext), (LoggingContext)loggingContext);
        }, this.loggingContext);
    }

    private <T, R> Future<T> withValidatedPackageId(String packageId2, R request, Function1<String, Future<T>> block, LoggingContext loggingContext) {
        return (Future)Ref$.MODULE$.PackageId().fromString(packageId2).fold((Function1 & Serializable)errorMessage -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(request, (Throwable)ValidationErrors$.MODULE$.invalidArgument(new StringBuilder(20).append("Invalid package id: ").append((String)errorMessage).toString(), (ContextualizedErrorLogger)this.createContextualizedErrorLogger(loggingContext)), this.logger(), loggingContext)), (Function1 & Serializable)packageId -> (Future)block.apply(packageId));
    }

    private GetPackageResponse toGetPackageResponse(DamlLf.Archive archive) {
        DamlLf.HashFunction hashFunction = archive.getHashFunction();
        Object object = DamlLf.HashFunction.SHA256.equals(hashFunction) ? HashFunction.SHA256$.MODULE$ : new HashFunction.Unrecognized(-1);
        HashFunction.SHA256$ hashFunction2 = object;
        return new GetPackageResponse((HashFunction)hashFunction2, archive.getPayload(), archive.getHash());
    }

    private DamlContextualizedErrorLogger createContextualizedErrorLogger(LoggingContext loggingContext) {
        return new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
    }

    public ApiPackageService(IndexPackagesService backend, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.backend = backend;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        PackageServiceGrpc.PackageService.$init$((PackageServiceGrpc.PackageService)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

