/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services;

import com.daml.api.util.TimeProvider;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.ErrorCode;
import com.daml.error.definitions.ErrorCause;
import com.daml.error.definitions.RejectionGenerators$;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.domain$;
import com.daml.ledger.api.messages.command.submission.SubmitRequest;
import com.daml.ledger.participant.state.index.v2.IndexPartyManagementService;
import com.daml.ledger.participant.state.v2.SubmissionResult;
import com.daml.ledger.participant.state.v2.WriteService;
import com.daml.lf.crypto.Hash;
import com.daml.lf.data.Ref$;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.SeedService;
import com.daml.platform.apiserver.configuration.LedgerConfigurationSubscription;
import com.daml.platform.apiserver.execution.CommandExecutionResult;
import com.daml.platform.apiserver.execution.CommandExecutor;
import com.daml.platform.apiserver.services.ApiSubmissionService$;
import com.daml.platform.apiserver.services.logging.package$;
import com.daml.platform.server.api.services.domain.CommandSubmissionService;
import com.daml.platform.server.api.services.grpc.GrpcCommandSubmissionService;
import com.daml.platform.services.time.TimeProviderType;
import com.daml.platform.services.time.TimeProviderType$Static$;
import com.daml.scalautil.future.FutureConversion;
import com.daml.scalautil.future.FutureConversion$;
import com.daml.telemetry.TelemetryContext;
import com.daml.timer.Delayed;
import java.io.Serializable;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005qA\u0002\u001b6\u0011\u00039tH\u0002\u0004Bk!\u0005qG\u0011\u0005\u0006\u0013\u0006!\ta\u0013\u0005\u0006\u0019\u0006!\t!\u0014\u0004\u0007\u0003o\u000b!)!/\t\u0015\u0005MGA!f\u0001\n\u0003\t)\u000e\u0003\u0006\u0002^\u0012\u0011\t\u0012)A\u0005\u0003/Da!\u0013\u0003\u0005\u0002\u0005}\u0007\"CAt\t\u0005\u0005I\u0011AAu\u0011%\ti\u000fBI\u0001\n\u0003\ty\u000fC\u0005\u0003\u0006\u0011\t\t\u0011\"\u0011\u0003\b!I!\u0011\u0004\u0003\u0002\u0002\u0013\u0005!1\u0004\u0005\n\u0005G!\u0011\u0011!C\u0001\u0005KA\u0011B!\r\u0005\u0003\u0003%\tEa\r\t\u0013\t\u0005C!!A\u0005\u0002\t\r\u0003\"\u0003B$\t\u0005\u0005I\u0011\tB%\u0011%\u0011i\u0005BA\u0001\n\u0003\u0012y\u0005C\u0005\u0003R\u0011\t\t\u0011\"\u0011\u0003T!I!Q\u000b\u0003\u0002\u0002\u0013\u0005#qK\u0004\n\u0005S\n\u0011\u0011!E\u0001\u0005W2\u0011\"a.\u0002\u0003\u0003E\tA!\u001c\t\r%#B\u0011\u0001BC\u0011%\u0011\t\u0006FA\u0001\n\u000b\u0012\u0019\u0006C\u0005\u0003\bR\t\t\u0011\"!\u0003\n\"I!Q\u0012\u000b\u0002\u0002\u0013\u0005%q\u0012\u0005\n\u0005/#\u0012\u0011!C\u0005\u000533a!Q\u001b\u0003o\t\u0005\u0006BCA\f5\t\u0005\t\u0015!\u0003\u0002\u001a!Q\u0011q\u0006\u000e\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005\u0005#D!A!\u0002\u0013\t\u0019\u0005\u0003\u0006\u0002Ti\u0011\t\u0011)A\u0005\u0003+B!\"!\u001a\u001b\u0005\u0003\u0005\u000b\u0011BA4\u0011)\t)H\u0007B\u0001B\u0003%\u0011q\u000f\u0005\u000b\u0003\u0003S\"\u0011!Q\u0001\n\u0005\r\u0005BCAI5\t\u0005\t\u0015!\u0003\u0002\u0014\"Q\u0011Q\u000e\u000e\u0003\u0002\u0003\u0006I!a-\t\u0015\tu#D!A!\u0002\u0013\u0011y\u0006\u0003\u0005e5\t\u0005\t\u0015a\u0003f\u0011!a'D!A!\u0002\u0017i\u0007bB%\u001b\t\u0003)$1\u0017\u0005\n\u0005#T\"\u0019!C\u0005\u0005'D\u0001Ba7\u001bA\u0003%!Q\u001b\u0005\b\u0005;TB\u0011\tBp\u0011\u001d\u0019YA\u0007C\u0005\u0007\u001bAqaa\t\u001b\t\u0013\u0019)\u0003C\u0004\u0004Vi!Iaa\u0016\t\u0011\r5%\u0004\"\u00016\u0007\u001fCqa!/\u001b\t\u0013\u0019Y\fC\u0004\u0004Zj!Iaa7\t\u000f\re'\u0004\"\u0003\u0004l\"911\u001f\u000e\u0005\n\rU\bbBB\u007f5\u0011\u00053q`\u0001\u0015\u0003BL7+\u001e2nSN\u001c\u0018n\u001c8TKJ4\u0018nY3\u000b\u0005Y:\u0014\u0001C:feZL7-Z:\u000b\u0005aJ\u0014!C1qSN,'O^3s\u0015\tQ4(\u0001\u0005qY\u0006$hm\u001c:n\u0015\taT(\u0001\u0003eC6d'\"\u0001 \u0002\u0007\r|W\u000e\u0005\u0002A\u00035\tQG\u0001\u000bBa&\u001cVOY7jgNLwN\\*feZL7-Z\n\u0003\u0003\r\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003}\naa\u0019:fCR,GC\u0006(t\u0003+\ti#a\u0010\u0002R\u0005\r\u00141OA@\u0003\u001f\u000b\tLa\u0017\u0015\u0007=\u001b7NE\u0002Q%v3A!U\u0001\u0001\u001f\naAH]3gS:,W.\u001a8u}A\u00111kW\u0007\u0002)*\u0011QKV\u0001\u0005OJ\u00048M\u0003\u00027/*\u0011\u0001,W\u0001\u0004CBL'B\u0001.:\u0003\u0019\u0019XM\u001d<fe&\u0011A\f\u0016\u0002\u001d\u000fJ\u00048mQ8n[\u0006tGmU;c[&\u001c8/[8o'\u0016\u0014h/[2f!\tq\u0016-D\u0001`\u0015\t)\u0006M\u0003\u0002Ys%\u0011!m\u0018\u0002\u000f\u000fJ\u00048-\u00119j'\u0016\u0014h/[2f\u0011\u0015!7\u0001q\u0001f\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0002gS6\tqM\u0003\u0002i\u000b\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005)<'\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015a7\u0001q\u0001n\u00039awnZ4j]\u001e\u001cuN\u001c;fqR\u0004\"A\\9\u000e\u0003=T!\u0001]\u001e\u0002\u000f1|wmZ5oO&\u0011!o\u001c\u0002\u000f\u0019><w-\u001b8h\u0007>tG/\u001a=u\u0011\u0015!8\u00011\u0001v\u0003!aW\rZ4fe&#\u0007c\u0001<\u0002\u00109\u0019q/!\u0003\u000f\u0007a\f)AD\u0002z\u0003\u0003q!A_@\u000f\u0005mtX\"\u0001?\u000b\u0005uT\u0015A\u0002\u001fs_>$h(C\u0001?\u0013\taT(C\u0002\u0002\u0004m\na\u0001\\3eO\u0016\u0014\u0018b\u0001-\u0002\b)\u0019\u00111A\u001e\n\t\u0005-\u0011QB\u0001\u0007I>l\u0017-\u001b8\u000b\u0007a\u000b9!\u0003\u0003\u0002\u0012\u0005M!\u0001\u0003'fI\u001e,'/\u00133\u000b\t\u0005-\u0011Q\u0002\u0005\b\u0003/\u0019\u0001\u0019AA\r\u000319(/\u001b;f'\u0016\u0014h/[2f!\u0011\tY\"!\u000b\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t!A\u001e\u001a\u000b\t\u0005\r\u0012QE\u0001\u0006gR\fG/\u001a\u0006\u0005\u0003O\t9!A\u0006qCJ$\u0018nY5qC:$\u0018\u0002BA\u0016\u0003;\u0011Ab\u0016:ji\u0016\u001cVM\u001d<jG\u0016Dq!a\f\u0004\u0001\u0004\t\t$\u0001\fqCJ$\u00180T1oC\u001e,W.\u001a8u'\u0016\u0014h/[2f!\u0011\t\u0019$a\u000f\u000e\u0005\u0005U\"\u0002BA\u0010\u0003oQA!!\u000f\u0002\"\u0005)\u0011N\u001c3fq&!\u0011QHA\u001b\u0005mIe\u000eZ3y!\u0006\u0014H/_'b]\u0006<W-\\3oiN+'O^5dK\"9\u0011\u0011I\u0002A\u0002\u0005\r\u0013\u0001\u0004;j[\u0016\u0004&o\u001c<jI\u0016\u0014\b\u0003BA#\u0003\u001bj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0005kRLGN\u0003\u0002Yw%!\u0011qJA$\u00051!\u0016.\\3Qe>4\u0018\u000eZ3s\u0011\u001d\t\u0019f\u0001a\u0001\u0003+\n\u0001\u0003^5nKB\u0013xN^5eKJ$\u0016\u0010]3\u0011\t\u0005]\u0013qL\u0007\u0003\u00033RA!a\u0017\u0002^\u0005!A/[7f\u0015\t1\u0014(\u0003\u0003\u0002b\u0005e#\u0001\u0005+j[\u0016\u0004&o\u001c<jI\u0016\u0014H+\u001f9f\u0011\u001d\t)g\u0001a\u0001\u0003O\nq\u0004\\3eO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u001cVOY:de&\u0004H/[8o!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7o\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!!\u001d\u0002l\tyB*\u001a3hKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+(m]2sSB$\u0018n\u001c8\t\u000f\u0005U4\u00011\u0001\u0002x\u0005Y1/Z3e'\u0016\u0014h/[2f!\u0011\tI(a\u001f\u000e\u0003]J1!! 8\u0005-\u0019V-\u001a3TKJ4\u0018nY3\t\u000f\u0005\u00055\u00011\u0001\u0002\u0004\u0006y1m\\7nC:$W\t_3dkR|'\u000f\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tIiN\u0001\nKb,7-\u001e;j_:LA!!$\u0002\b\ny1i\\7nC:$W\t_3dkR|'\u000fC\u0004\u0002\u0012\u000e\u0001\r!a%\u0002\u001f\rDWmY6Pm\u0016\u0014Hn\\1eK\u0012\u0004r\u0001RAK\u00033\u000b)+C\u0002\u0002\u0018\u0016\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\u0005m\u0015\u0011U\u0007\u0003\u0003;S1!a(<\u0003%!X\r\\3nKR\u0014\u00180\u0003\u0003\u0002$\u0006u%\u0001\u0005+fY\u0016lW\r\u001e:z\u0007>tG/\u001a=u!\u0015!\u0015qUAV\u0013\r\tI+\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005m\u0011QV\u0005\u0005\u0003_\u000biB\u0001\tTk\nl\u0017n]:j_:\u0014Vm];mi\"9\u0011QN\u0002A\u0002\u0005M\u0006cAA[\t9\u0011\u0001\t\u0001\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0014\r\u0011\u0019\u00151XAa!\r!\u0015QX\u0005\u0004\u0003\u007f+%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u0007\fiM\u0004\u0003\u0002F\u0006%gbA>\u0002H&\ta)C\u0002\u0002L\u0016\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0006E'\u0001D*fe&\fG.\u001b>bE2,'bAAf\u000b\u00069\u0012.\u001c9mS\u000eLG\u000fU1sif\fE\u000e\\8dCRLwN\\\u000b\u0003\u0003/\u00042\u0001RAm\u0013\r\tY.\u0012\u0002\b\u0005>|G.Z1o\u0003aIW\u000e\u001d7jG&$\b+\u0019:us\u0006cGn\\2bi&|g\u000e\t\u000b\u0005\u0003C\f)\u000fE\u0002\u0002d\u0012i\u0011!\u0001\u0005\b\u0003'<\u0001\u0019AAl\u0003\u0011\u0019w\u000e]=\u0015\t\u0005\u0005\u00181\u001e\u0005\n\u0003'D\u0001\u0013!a\u0001\u0003/\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r*\"\u0011q[AzW\t\t)\u0010\u0005\u0003\u0002x\n\u0005QBAA}\u0015\u0011\tY0!@\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0000\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\u0011\u0011 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\nA!!1\u0002B\u000b\u001b\t\u0011iA\u0003\u0003\u0003\u0010\tE\u0011\u0001\u00027b]\u001eT!Aa\u0005\u0002\t)\fg/Y\u0005\u0005\u0005/\u0011iA\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005;\u00012\u0001\u0012B\u0010\u0013\r\u0011\t#\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005O\u0011i\u0003E\u0002E\u0005SI1Aa\u000bF\u0005\r\te.\u001f\u0005\n\u0005_a\u0011\u0011!a\u0001\u0005;\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u001b!\u0019\u00119D!\u0010\u0003(5\u0011!\u0011\b\u0006\u0004\u0005w)\u0015AC2pY2,7\r^5p]&!!q\bB\u001d\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]'Q\t\u0005\n\u0005_q\u0011\u0011!a\u0001\u0005O\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\u0002B&\u0011%\u0011ycDA\u0001\u0002\u0004\u0011i\"\u0001\u0005iCND7i\u001c3f)\t\u0011i\"\u0001\u0005u_N#(/\u001b8h)\t\u0011I!\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003/\u0014I\u0006C\u0005\u00030I\t\t\u00111\u0001\u0003(!9!QL\u0002A\u0002\t}\u0013aB7fiJL7m\u001d\t\u0005\u0005C\u0012)'\u0004\u0002\u0003d)\u0019!QL\u001e\n\t\t\u001d$1\r\u0002\b\u001b\u0016$(/[2t\u00035\u0019uN\u001c4jOV\u0014\u0018\r^5p]B\u0019\u00111\u001d\u000b\u0014\u000bQ\u0011yGa\u001f\u0011\u0011\tE$qOAl\u0003Cl!Aa\u001d\u000b\u0007\tUT)A\u0004sk:$\u0018.\\3\n\t\te$1\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003\u0002B?\u0005\u0007k!Aa \u000b\t\t\u0005%\u0011C\u0001\u0003S>LA!a4\u0003\u0000Q\u0011!1N\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003C\u0014Y\tC\u0004\u0002T^\u0001\r!a6\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0013BJ!\u0015!\u0015qUAl\u0011%\u0011)\nGA\u0001\u0002\u0004\t\t/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa'\u0011\t\t-!QT\u0005\u0005\u0005?\u0013iA\u0001\u0004PE*,7\r^\n\u00075\r\u0013\u0019K!,\u0011\t\t\u0015&\u0011V\u0007\u0003\u0005OS1!a\u0003W\u0013\u0011\u0011YKa*\u00031\r{W.\\1oIN+(-\\5tg&|gnU3sm&\u001cW\r\u0005\u0003\u0003\f\t=\u0016\u0002\u0002BY\u0005\u001b\u0011Q\"Q;u_\u000ecwn]3bE2,GC\u0006B[\u0005{\u0013yL!1\u0003D\n\u0015'q\u0019Be\u0005\u0017\u0014iMa4\u0015\r\t]&\u0011\u0018B^!\t\u0001%\u0004C\u0003eO\u0001\u000fQ\rC\u0003mO\u0001\u000fQ\u000eC\u0004\u0002\u0018\u001d\u0002\r!!\u0007\t\u000f\u0005=r\u00051\u0001\u00022!9\u0011\u0011I\u0014A\u0002\u0005\r\u0003bBA*O\u0001\u0007\u0011Q\u000b\u0005\b\u0003K:\u0003\u0019AA4\u0011\u001d\t)h\na\u0001\u0003oBq!!!(\u0001\u0004\t\u0019\tC\u0004\u0002\u0012\u001e\u0002\r!a%\t\u000f\u00055t\u00051\u0001\u00024\"9!QL\u0014A\u0002\t}\u0013A\u00027pO\u001e,'/\u0006\u0002\u0003VB\u0019aNa6\n\u0007\tewN\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0019\u0019XOY7jiR!!\u0011\u001dBz)\u0011\u0011\u0019Oa<\u0011\u000b\u0019\u0014)O!;\n\u0007\t\u001dxM\u0001\u0004GkR,(/\u001a\t\u0004\t\n-\u0018b\u0001Bw\u000b\n!QK\\5u\u0011\u001d\u0011\tP\u000ba\u0002\u00033\u000b\u0001\u0003^3mK6,GO]=D_:$X\r\u001f;\t\u000f\tU(\u00061\u0001\u0003x\u00069!/Z9vKN$\b\u0003\u0002B}\u0007\u000fi!Aa?\u000b\t\tu(q`\u0001\u000bgV\u0014W.[:tS>t'\u0002BB\u0001\u0007\u0007\tqaY8n[\u0006tGM\u0003\u0003\u0004\u0006\u00055\u0011\u0001C7fgN\fw-Z:\n\t\r%!1 \u0002\u000e'V\u0014W.\u001b;SKF,Xm\u001d;\u0002-!\fg\u000e\u001a7f'V\u0014W.[:tS>t'+Z:vYR$Baa\u0004\u0004\u001eQ!1\u0011CB\u000e!\u0019\u0019\u0019ba\u0006\u0003j6\u00111Q\u0003\u0006\u0004\u0003\u0013*\u0015\u0002BB\r\u0007+\u00111\u0001\u0016:z\u0011\u0015a7\u0006q\u0001n\u0011\u001d\u0019yb\u000ba\u0001\u0007C\taA]3tk2$\bCBB\n\u0007/\tY+\u0001\u000fiC:$G.Z\"p[6\fg\u000eZ#yK\u000e,H/[8o%\u0016\u001cX\u000f\u001c;\u0015\t\r\u001d2\u0011\t\u000b\u0005\u0007S\u0019\t\u0004E\u0003g\u0005K\u001cY\u0003\u0005\u0003\u0002\u0006\u000e5\u0012\u0002BB\u0018\u0003\u000f\u0013acQ8n[\u0006tG-\u0012=fGV$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0007ga\u00039AB\u001b\u0003e\u0019wN\u001c;fqR,\u0018\r\\5{K\u0012,%O]8s\u0019><w-\u001a:\u0011\t\r]2QH\u0007\u0003\u0007sQ1aa\u000f<\u0003\u0015)'O]8s\u0013\u0011\u0019yd!\u000f\u00033\r{g\u000e^3yiV\fG.\u001b>fI\u0016\u0013(o\u001c:M_\u001e<WM\u001d\u0005\b\u0007?a\u0003\u0019AB\"!!\t\u0019m!\u0012\u0004J\r-\u0012\u0002BB$\u0003#\u0014a!R5uQ\u0016\u0014\b\u0003BB&\u0007#j!a!\u0014\u000b\t\r=3\u0011H\u0001\fI\u00164\u0017N\\5uS>t7/\u0003\u0003\u0004T\r5#AC#se>\u00148)Y;tK\u0006\tRM^1mk\u0006$X-\u00118e'V\u0014W.\u001b;\u0015\u0011\re31MB<\u0007\u0003#\u0002ba\u0017\u0004^\r}3\u0011\r\t\u0006M\n\u0015\u00181\u0016\u0005\u0006Y6\u0002\u001d!\u001c\u0005\b\u0005cl\u00039AAM\u0011\u001d\u0019\u0019$\fa\u0002\u0007kAqa!\u001a.\u0001\u0004\u00199'\u0001\btk\nl\u0017n]:j_:\u001cV-\u001a3\u0011\t\r%41O\u0007\u0003\u0007WRAa!\u001c\u0004p\u000511M]=qi>T1a!\u001d<\u0003\tag-\u0003\u0003\u0004v\r-$\u0001\u0002%bg\"Dqa!\u001f.\u0001\u0004\u0019Y(\u0001\u0005d_6l\u0017M\u001c3t!\r18QP\u0005\u0005\u0007\u007f\n\u0019B\u0001\u0005D_6l\u0017M\u001c3t\u0011\u001d\u0019\u0019)\fa\u0001\u0007\u000b\u000bA\u0002\\3eO\u0016\u00148i\u001c8gS\u001e\u0004Baa\"\u0004\f6\u00111\u0011\u0012\u0006\u0005\u0003[\n9!\u0003\u0003\u00028\u000e%\u0015\u0001G1mY>\u001c\u0017\r^3NSN\u001c\u0018N\\4J]\u001a|'/\\3fgR!1\u0011SBP)\u0019\u0019\u0019ja'\u0004\u001eB)aM!:\u0004\u0016B1\u00111YBL\u0003WKAa!'\u0002R\n\u00191+Z9\t\u000b1t\u00039A7\t\u000f\tEh\u0006q\u0001\u0002\u001a\"91\u0011\u0015\u0018A\u0002\r\r\u0016a\u0003;sC:\u001c\u0018m\u0019;j_:\u0004Ba!*\u00044:!1qUBX\u001d\u0011\u0019Ik!,\u000f\u0007e\u001cY+C\u0002\u0004rmJAa!)\u0004p%!\u00111ZBY\u0015\u0011\u0019\tka\u001c\n\t\rU6q\u0017\u0002\u0015'V\u0014W.\u001b;uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8\u000b\t\u0005-7\u0011W\u0001\u000eC2dwnY1uKB\u000b'\u000f^=\u0015\t\ru6\u0011\u0019\u000b\u0005\u00077\u001ay\fC\u0004\u0003r>\u0002\u001d!!'\t\u000f\r\rw\u00061\u0001\u0004F\u0006!a.Y7f!\u0011\u00199ma5\u000f\t\r%7qZ\u0007\u0003\u0007\u0017TAa!4\u0004p\u0005!A-\u0019;b\u0013\u0011\u0019\tna3\u0002\u0007I+g-\u0003\u0003\u0004V\u000e]'!\u0002)beRL(\u0002BBi\u0007\u0017\f\u0011c];c[&$HK]1og\u0006\u001cG/[8o)!\u0019in!9\u0004f\u000e%H\u0003BB.\u0007?DqA!=1\u0001\b\tI\nC\u0004\u0004dB\u0002\raa\u000b\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\%oM>Dqaa:1\u0001\u0004\u0019)*\u0001\fqCJ$\u00180\u00117m_\u000e\fG/[8o%\u0016\u001cX\u000f\u001c;t\u0011\u001d\u0019\u0019\t\ra\u0001\u0007\u000b#Ba!<\u0004rR!11LBx\u0011\u001d\u0011\t0\ra\u0002\u00033Cqaa\b2\u0001\u0004\u0019Y#\u0001\rgC&dW\rZ(o\u0007>lW.\u00198e\u000bb,7-\u001e;j_:$Baa>\u0004|R!1\u0011FB}\u0011\u001d\u0019\u0019D\ra\u0002\u0007kAqaa\u000f3\u0001\u0004\u0019I%A\u0003dY>\u001cX\r\u0006\u0002\u0003j\u0002")
public final class ApiSubmissionService
implements CommandSubmissionService,
AutoCloseable {
    private final WriteService writeService;
    private final IndexPartyManagementService partyManagementService;
    private final TimeProvider timeProvider;
    private final TimeProviderType timeProviderType;
    private final LedgerConfigurationSubscription ledgerConfigurationSubscription;
    private final SeedService seedService;
    private final CommandExecutor commandExecutor;
    private final Function1<TelemetryContext, Option<SubmissionResult>> checkOverloaded;
    private final Configuration configuration;
    private final Metrics metrics;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;

    public static GrpcCommandSubmissionService create(Object ledgerId, WriteService writeService, IndexPartyManagementService partyManagementService, TimeProvider timeProvider, TimeProviderType timeProviderType, LedgerConfigurationSubscription ledgerConfigurationSubscription, SeedService seedService, CommandExecutor commandExecutor, Function1<TelemetryContext, Option<SubmissionResult>> checkOverloaded, Configuration configuration, Metrics metrics, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ApiSubmissionService$.MODULE$.create(ledgerId, writeService, partyManagementService, timeProvider, timeProviderType, ledgerConfigurationSubscription, seedService, commandExecutor, checkOverloaded, configuration, metrics, executionContext, loggingContext);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public Future<BoxedUnit> submit(SubmitRequest request, TelemetryContext telemetryContext) {
        return (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.commands(request.commands()), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            Future future;
            this.logger().info().apply((Function0 & Serializable)() -> "Submitting transaction", loggingContext);
            this.logger().trace().apply((Function0 & Serializable)() -> new StringBuilder(10).append("Commands: ").append(request.commands().commands().commands()).toString(), loggingContext);
            DamlContextualizedErrorLogger contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, request.commands().submissionId().map((Function1 & Serializable)a -> (String)domain$.MODULE$.SubmissionId().unwrap(a)));
            Option<com.daml.ledger.configuration.Configuration> option = $this.ledgerConfigurationSubscription.latestConfiguration();
            if (option instanceof Some) {
                Some some = (Some)option;
                com.daml.ledger.configuration.Configuration ledgerConfiguration2 = (com.daml.ledger.configuration.Configuration)some.value();
                future = this.evaluateAndSubmit((Hash)$this.seedService.nextSeed().apply(), request.commands(), ledgerConfiguration2, (LoggingContext)loggingContext, telemetryContext, (ContextualizedErrorLogger)contextualizedErrorLogger).transform((Function1 & Serializable)result -> this.handleSubmissionResult((Try<SubmissionResult>)result, (LoggingContext)loggingContext), $this.executionContext);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RequestValidation.NotFound$.LedgerConfiguration$.Reject((ContextualizedErrorLogger)contextualizedErrorLogger).asGrpcError());
            } else {
                throw new MatchError(option);
            }
            Future evaluatedCommand = future;
            return evaluatedCommand.andThen(this.logger().logErrorsOnCall(loggingContext), $this.executionContext);
        }, this.loggingContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Try<BoxedUnit> handleSubmissionResult(Try<SubmissionResult> result, LoggingContext loggingContext) {
        SubmissionResult result2;
        boolean bl = false;
        Success success = null;
        boolean bl2 = false;
        Failure failure = null;
        Try<SubmissionResult> try_ = result;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            SubmissionResult submissionResult = (SubmissionResult)success.value();
            if (SubmissionResult.Acknowledged$.MODULE$.equals(submissionResult)) {
                this.logger().debug().apply((Function0 & Serializable)() -> "Success", loggingContext);
                return new Success((Object)BoxedUnit.UNIT);
            }
        }
        if (bl && (result2 = (SubmissionResult)success.value()) instanceof SubmissionResult.SynchronousError) {
            SubmissionResult.SynchronousError synchronousError = (SubmissionResult.SynchronousError)result2;
            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(10).append("Rejected: ").append(synchronousError.description()).toString(), loggingContext);
            return new Failure((Throwable)synchronousError.exception());
        }
        if (try_ instanceof Failure) {
            bl2 = true;
            failure = (Failure)try_;
            Throwable error = failure.exception();
            if (error instanceof ErrorCode.LoggedApiException) {
                ErrorCode.LoggedApiException loggedApiException = (ErrorCode.LoggedApiException)error;
                return new Failure((Throwable)loggedApiException);
            }
        }
        if (!bl2) throw new MatchError(try_);
        Throwable error = failure.exception();
        this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(10).append("Rejected: ").append(error.getMessage()).toString(), loggingContext);
        return new Failure(error);
    }

    private Future<CommandExecutionResult> handleCommandExecutionResult(Either<ErrorCause, CommandExecutionResult> result2, ContextualizedErrorLogger contextualizedErrorLogger) {
        return (Future)result2.fold((Function1 & Serializable)error -> {
            $this.metrics.daml().commands().failedCommandInterpretations().mark();
            return this.failedOnCommandExecution((ErrorCause)error, contextualizedErrorLogger);
        }, (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Future<SubmissionResult> evaluateAndSubmit(Hash submissionSeed, domain.Commands commands, com.daml.ledger.configuration.Configuration ledgerConfig, LoggingContext loggingContext, TelemetryContext telemetryContext, ContextualizedErrorLogger contextualizedErrorLogger) {
        Future future;
        Option option = (Option)this.checkOverloaded.apply((Object)telemetryContext);
        if (option instanceof Some) {
            Some some = (Some)option;
            SubmissionResult submissionResult = (SubmissionResult)some.value();
            future = Future$.MODULE$.successful((Object)submissionResult);
        } else if (None$.MODULE$.equals(option)) {
            future = this.commandExecutor.execute(commands, submissionSeed, ledgerConfig, loggingContext).flatMap((Function1 & Serializable)result -> this.handleCommandExecutionResult((Either<ErrorCause, CommandExecutionResult>)result, contextualizedErrorLogger).flatMap((Function1 & Serializable)transactionInfo -> this.allocateMissingInformees(transactionInfo.transaction(), loggingContext, telemetryContext).flatMap((Function1 & Serializable)partyAllocationResults -> this.submitTransaction((CommandExecutionResult)transactionInfo, (Seq<SubmissionResult>)partyAllocationResults, ledgerConfig, telemetryContext).map((Function1 & Serializable)submissionResult -> submissionResult, $this.executionContext), $this.executionContext), $this.executionContext), this.executionContext);
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public Future<Seq<SubmissionResult>> allocateMissingInformees(VersionedTransaction transaction, LoggingContext loggingContext, TelemetryContext telemetryContext) {
        Future future;
        if (this.configuration.implicitPartyAllocation()) {
            Seq partiesInTransaction = transaction.informees().toSeq();
            future = this.partyManagementService.getParties(partiesInTransaction, loggingContext).map((Function1 & Serializable)fetchedParties -> {
                Set knownParties = fetchedParties.iterator().map((Function1 & Serializable)x$2 -> x$2.party()).toSet();
                Seq missingParties = (Seq)partiesInTransaction.filterNot((Function1)knownParties);
                return new Tuple3(fetchedParties, (Object)knownParties, (Object)missingParties);
            }, this.executionContext).flatMap((Function1 & Serializable)x$3 -> {
                Tuple3 tuple3 = x$3;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Seq missingParties = (Seq)tuple3._3();
                Future future = Future$.MODULE$.sequence((IterableOnce)missingParties.map((Function1 & Serializable)name -> this.allocateParty((String)name, telemetryContext)), BuildFrom$.MODULE$.buildFromIterableOps(), $this.executionContext).map((Function1 & Serializable)submissionResults -> submissionResults, $this.executionContext);
                return future;
            }, this.executionContext);
        } else {
            future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Seq().empty());
        }
        return future;
    }

    private Future<SubmissionResult> allocateParty(String name, TelemetryContext telemetryContext) {
        String submissionId = (String)Ref$.MODULE$.SubmissionId().assertFromString(UUID.randomUUID().toString());
        return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.party(name), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package$.MODULE$.submissionId(submissionId)}), (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Implicit party allocation", loggingContext);
            return $this.writeService.allocateParty((Option)new Some((Object)name), (Option)new Some((Object)name), submissionId, loggingContext, telemetryContext);
        }, this.loggingContext)));
    }

    private Future<SubmissionResult> submitTransaction(CommandExecutionResult transactionInfo, Seq<SubmissionResult> partyAllocationResults, com.daml.ledger.configuration.Configuration ledgerConfig, TelemetryContext telemetryContext) {
        Future<SubmissionResult> future;
        Option option = partyAllocationResults.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ApiSubmissionService.$anonfun$submitTransaction$1(x$4)));
        if (option instanceof Some) {
            Some some = (Some)option;
            SubmissionResult result = (SubmissionResult)some.value();
            future = Future$.MODULE$.successful((Object)result);
        } else if (None$.MODULE$.equals(option)) {
            Future<SubmissionResult> future2;
            TimeProviderType timeProviderType = this.timeProviderType;
            if (TimeProviderType.WallClock$.MODULE$.equals(timeProviderType)) {
                Future future3;
                Instant submitAt = transactionInfo.transactionMeta().ledgerEffectiveTime().toInstant().minus(ledgerConfig.timeModel().avgTransactionLatency());
                java.time.Duration submissionDelay = java.time.Duration.between(this.timeProvider.getCurrentTime(), submitAt);
                if (submissionDelay.isNegative()) {
                    future3 = this.submitTransaction(transactionInfo, telemetryContext);
                } else {
                    this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(23).append("Delaying submission by ").append(submissionDelay).toString(), this.loggingContext);
                    this.metrics.daml().commands().delayedSubmissions().mark();
                    FiniteDuration scalaDelay = Duration$.MODULE$.fromNanos(submissionDelay.toNanos());
                    future3 = Delayed.Future$.MODULE$.by((Duration)scalaDelay, (Function0 & Serializable)() -> this.submitTransaction(transactionInfo, telemetryContext));
                }
                future2 = future3;
            } else if (TimeProviderType$Static$.MODULE$.equals(timeProviderType)) {
                future2 = this.submitTransaction(transactionInfo, telemetryContext);
            } else {
                throw new MatchError((Object)timeProviderType);
            }
            future = future2;
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private Future<SubmissionResult> submitTransaction(CommandExecutionResult result, TelemetryContext telemetryContext) {
        this.metrics.daml().commands().validSubmissions().mark();
        return FutureConversion.CompletionStageConversionOps$.MODULE$.toScalaUnwrapped$extension(FutureConversion$.MODULE$.CompletionStageConversionOps(this.writeService.submitTransaction(result.submitterInfo(), result.transactionMeta(), result.transaction(), result.interpretationTimeNanos(), result.globalKeyMapping(), this.loggingContext, telemetryContext)));
    }

    private Future<CommandExecutionResult> failedOnCommandExecution(ErrorCause error, ContextualizedErrorLogger contextualizedErrorLogger) {
        return Future$.MODULE$.failed((Throwable)RejectionGenerators$.MODULE$.commandExecutorError(error, contextualizedErrorLogger));
    }

    @Override
    public void close() {
    }

    public static final /* synthetic */ boolean $anonfun$submitTransaction$1(SubmissionResult x$4) {
        SubmissionResult submissionResult = x$4;
        SubmissionResult.Acknowledged$ acknowledged$ = SubmissionResult.Acknowledged$.MODULE$;
        return submissionResult == null ? acknowledged$ != null : !submissionResult.equals(acknowledged$);
    }

    public ApiSubmissionService(WriteService writeService, IndexPartyManagementService partyManagementService, TimeProvider timeProvider, TimeProviderType timeProviderType, LedgerConfigurationSubscription ledgerConfigurationSubscription, SeedService seedService, CommandExecutor commandExecutor, Function1<TelemetryContext, Option<SubmissionResult>> checkOverloaded, Configuration configuration, Metrics metrics, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.writeService = writeService;
        this.partyManagementService = partyManagementService;
        this.timeProvider = timeProvider;
        this.timeProviderType = timeProviderType;
        this.ledgerConfigurationSubscription = ledgerConfigurationSubscription;
        this.seedService = seedService;
        this.commandExecutor = commandExecutor;
        this.checkOverloaded = checkOverloaded;
        this.configuration = configuration;
        this.metrics = metrics;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }

    public static final class Configuration
    implements Product,
    Serializable {
        private final boolean implicitPartyAllocation;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean implicitPartyAllocation() {
            return this.implicitPartyAllocation;
        }

        public Configuration copy(boolean implicitPartyAllocation) {
            return new Configuration(implicitPartyAllocation);
        }

        public boolean copy$default$1() {
            return this.implicitPartyAllocation();
        }

        public String productPrefix() {
            return "Configuration";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.implicitPartyAllocation());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Configuration;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "implicitPartyAllocation";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.implicitPartyAllocation() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Configuration)) return false;
            boolean bl = true;
            if (!bl) return false;
            Configuration configuration = (Configuration)x$1;
            if (this.implicitPartyAllocation() != configuration.implicitPartyAllocation()) return false;
            return true;
        }

        public Configuration(boolean implicitPartyAllocation) {
            this.implicitPartyAllocation = implicitPartyAllocation;
            Product.$init$((Product)this);
        }
    }
}

