/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.LedgerApiErrors;
import com.daml.ledger.api.v1.experimental_features.ExperimentalFeatures$;
import com.daml.ledger.api.v1.experimental_features.ExperimentalOptionalLedgerId;
import com.daml.ledger.api.v1.experimental_features.ExperimentalSelfServiceErrorCodes;
import com.daml.ledger.api.v1.experimental_features.ExperimentalStaticTime;
import com.daml.ledger.api.v1.version_service.FeaturesDescriptor;
import com.daml.ledger.api.v1.version_service.FeaturesDescriptor$;
import com.daml.ledger.api.v1.version_service.GetLedgerApiVersionRequest;
import com.daml.ledger.api.v1.version_service.GetLedgerApiVersionResponse;
import com.daml.ledger.api.v1.version_service.UserManagementFeature;
import com.daml.ledger.api.v1.version_service.VersionServiceGrpc;
import com.daml.ledger.api.v1.version_service.VersionServiceGrpc$;
import com.daml.ledger.api.v1.version_service.VersionServiceGrpc$VersionService$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.LedgerFeatures;
import com.daml.platform.apiserver.services.ApiVersionService$;
import com.daml.platform.usermanagement.UserManagementConfig;
import com.daml.platform.usermanagement.UserManagementConfig$;
import io.grpc.ServerServiceDefinition;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]e!\u0002\r\u001a\u0005m\u0019\u0003\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011U\u0003!\u0011!Q\u0001\nYC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006Y!\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0006I\")!\u000e\u0001C\u0005W\"91\u000f\u0001b\u0001\n\u0013!\bB\u0002=\u0001A\u0003%Q\u000fC\u0004z\u0001\t\u0007I1\u0002>\t\u000f\u0005\r\u0001\u0001)A\u0005w\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!Q\u00111\u0004\u0001\t\u0006\u0004%I!!\b\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002\u0002CA\u001c\u0001\u0001\u0006I!a\f\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t)\b\u0001C!\u0003o:\u0001\"a \u001a\u0011\u0003Y\u0012\u0011\u0011\u0004\b1eA\taGAB\u0011\u0019QW\u0003\"\u0001\u0002\u0006\"9\u0011qQ\u000b\u0005\u0002\u0005%%!E!qSZ+'o]5p]N+'O^5dK*\u0011!dG\u0001\tg\u0016\u0014h/[2fg*\u0011A$H\u0001\nCBL7/\u001a:wKJT!AH\u0010\u0002\u0011Ad\u0017\r\u001e4pe6T!\u0001I\u0011\u0002\t\u0011\fW\u000e\u001c\u0006\u0002E\u0005\u00191m\\7\u0014\t\u0001!#&\u0013\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-2eB\u0001\u0017D\u001d\ti\u0003I\u0004\u0002/{9\u0011qF\u000f\b\u0003aar!!M\u001c\u000f\u0005I2T\"A\u001a\u000b\u0005Q*\u0014A\u0002\u001fs_>$hh\u0001\u0001\n\u0003\tJ!\u0001I\u0011\n\u0005ez\u0012A\u00027fI\u001e,'/\u0003\u0002<y\u0005\u0019\u0011\r]5\u000b\u0005ez\u0012B\u0001 @\u0003\t1\u0018G\u0003\u0002<y%\u0011\u0011IQ\u0001\u0010m\u0016\u00148/[8o?N,'O^5dK*\u0011ahP\u0005\u0003\t\u0016\u000b!CV3sg&|gnU3sm&\u001cWm\u0012:qG*\u0011\u0011IQ\u0005\u0003\u000f\"\u0013aBV3sg&|gnU3sm&\u001cWM\u0003\u0002E\u000bB\u0011!JT\u0007\u0002\u0017*\u0011A*T\u0001\u0005OJ\u00048M\u0003\u0002<;%\u0011qj\u0013\u0002\u000f\u000fJ\u00048-\u00119j'\u0016\u0014h/[2f\u00039aW\rZ4fe\u001a+\u0017\r^;sKN\u0004\"AU*\u000e\u0003mI!\u0001V\u000e\u0003\u001d1+GmZ3s\r\u0016\fG/\u001e:fg\u0006!Ro]3s\u001b\u0006t\u0017mZ3nK:$8i\u001c8gS\u001e\u0004\"a\u0016.\u000e\u0003aS!!W\u000f\u0002\u001dU\u001cXM]7b]\u0006<W-\\3oi&\u00111\f\u0017\u0002\u0015+N,'/T1oC\u001e,W.\u001a8u\u0007>tg-[4\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB\u0011a,Y\u0007\u0002?*\u0011\u0001mH\u0001\bY><w-\u001b8h\u0013\t\u0011wL\u0001\bM_\u001e<\u0017N\\4D_:$X\r\u001f;\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\bCA3i\u001b\u00051'BA4'\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003S\u001a\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\ra\u0017O\u001d\u000b\u0004[>\u0004\bC\u00018\u0001\u001b\u0005I\u0002\"\u0002/\u0006\u0001\bi\u0006\"B2\u0006\u0001\b!\u0007\"\u0002)\u0006\u0001\u0004\t\u0006\"B+\u0006\u0001\u00041\u0016A\u00027pO\u001e,'/F\u0001v!\tqf/\u0003\u0002x?\n!2i\u001c8uKb$X/\u00197ju\u0016$Gj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\rd_:$X\r\u001f;vC2L'0\u001a3FeJ|'\u000fT8hO\u0016\u0014X#A>\u0011\u0005q|X\"A?\u000b\u0005y|\u0012!B3se>\u0014\u0018bAA\u0001{\nI2i\u001c8uKb$X/\u00197ju\u0016$WI\u001d:pe2{wmZ3s\u0003i\u0019wN\u001c;fqR,\u0018\r\\5{K\u0012,%O]8s\u0019><w-\u001a:!\u0003-1XM]:j_:4\u0015\u000e\\3\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003'qA!!\u0004\u0002\u0010A\u0011!GJ\u0005\u0004\u0003#1\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005]!AB*ue&twMC\u0002\u0002\u0012\u0019\nAB^3sg&|gNR5mK\u0002\n!\"\u00199j-\u0016\u00148/[8o+\t\ty\u0002\u0005\u0004\u0002\"\u0005\u001d\u0012\u0011B\u0007\u0003\u0003GQ1!!\n'\u0003\u0011)H/\u001b7\n\t\u0005%\u00121\u0005\u0002\u0004)JL\u0018A\u00054fCR,(/Z:EKN\u001c'/\u001b9u_J,\"!a\f\u0011\t\u0005E\u00121G\u0007\u0002\u000b&\u0019\u0011QG#\u0003%\u0019+\u0017\r^;sKN$Um]2sSB$xN]\u0001\u0014M\u0016\fG/\u001e:fg\u0012+7o\u0019:jaR|'\u000fI\u0001\u0014O\u0016$H*\u001a3hKJ\f\u0005/\u001b,feNLwN\u001c\u000b\u0005\u0003{\tI\u0005E\u0003f\u0003\u007f\t\u0019%C\u0002\u0002B\u0019\u0014aAR;ukJ,\u0007\u0003BA\u0019\u0003\u000bJ1!a\u0012F\u0005m9U\r\u001e'fI\u001e,'/\u00119j-\u0016\u00148/[8o%\u0016\u001c\bo\u001c8tK\"9\u00111J\bA\u0002\u00055\u0013a\u0002:fcV,7\u000f\u001e\t\u0005\u0003c\ty%C\u0002\u0002R\u0015\u0013!dR3u\u0019\u0016$w-\u001a:Ba&4VM]:j_:\u0014V-];fgR\f!#\u00199j-\u0016\u00148/[8o%\u0016\u001c\bo\u001c8tKR!\u00111IA,\u0011\u001d\tI\u0006\u0005a\u0001\u0003\u0013\tqA^3sg&|g.A\u0006sK\u0006$g+\u001a:tS>tG\u0003BA\u0010\u0003?Bq!!\u0019\u0012\u0001\u0004\tI!A\bwKJ\u001c\u0018n\u001c8GS2,g*Y7f\u0003-\u0011\u0017N\u001c3TKJ4\u0018nY3\u0015\u0005\u0005\u001d\u0004\u0003BA5\u0003cj!!a\u001b\u000b\u00071\u000biG\u0003\u0002\u0002p\u0005\u0011\u0011n\\\u0005\u0005\u0003g\nYGA\fTKJ4XM]*feZL7-\u001a#fM&t\u0017\u000e^5p]\u0006)1\r\\8tKR\u0011\u0011\u0011\u0010\t\u0004K\u0005m\u0014bAA?M\t!QK\\5u\u0003E\t\u0005/\u001b,feNLwN\\*feZL7-\u001a\t\u0003]V\u0019\"!\u0006\u0013\u0015\u0005\u0005\u0005\u0015AB2sK\u0006$X\r\u0006\u0004\u0002\f\u0006M\u0015Q\u0013\u000b\u0006[\u00065\u0015q\u0012\u0005\u00069^\u0001\u001d!\u0018\u0005\u0007\u0003#;\u00029\u00013\u0002\u0005\u0015\u001c\u0007\"\u0002)\u0018\u0001\u0004\t\u0006\"B+\u0018\u0001\u00041\u0006")
public final class ApiVersionService
implements VersionServiceGrpc.VersionService,
GrpcApiService {
    private Try<String> apiVersion;
    private final LoggingContext loggingContext;
    private final ExecutionContext executionContext;
    private final ContextualizedLogger logger;
    private final ContextualizedErrorLogger com$daml$platform$apiserver$services$ApiVersionService$$contextualizedErrorLogger;
    private String versionFile;
    private final FeaturesDescriptor featuresDescriptor;
    private volatile boolean bitmap$0;

    public static ApiVersionService create(LedgerFeatures ledgerFeatures, UserManagementConfig userManagementConfig, LoggingContext loggingContext, ExecutionContext ec) {
        return ApiVersionService$.MODULE$.create(ledgerFeatures, userManagementConfig, loggingContext, ec);
    }

    public VersionServiceGrpc$VersionService$ serviceCompanion() {
        return VersionServiceGrpc.VersionService.serviceCompanion$((VersionServiceGrpc.VersionService)this);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public ContextualizedErrorLogger com$daml$platform$apiserver$services$ApiVersionService$$contextualizedErrorLogger() {
        return this.com$daml$platform$apiserver$services$ApiVersionService$$contextualizedErrorLogger;
    }

    private String versionFile() {
        return this.versionFile;
    }

    private Try<String> apiVersion$lzycompute() {
        ApiVersionService apiVersionService = this;
        synchronized (apiVersionService) {
            if (!this.bitmap$0) {
                this.apiVersion = this.readVersion(this.versionFile());
                this.bitmap$0 = true;
            }
        }
        this.versionFile = null;
        return this.apiVersion;
    }

    private Try<String> apiVersion() {
        return !this.bitmap$0 ? this.apiVersion$lzycompute() : this.apiVersion;
    }

    private FeaturesDescriptor featuresDescriptor() {
        return this.featuresDescriptor;
    }

    public Future<GetLedgerApiVersionResponse> getLedgerApiVersion(GetLedgerApiVersionRequest request) {
        return Future$.MODULE$.fromTry(this.apiVersion()).map((Function1 & Serializable)version -> this.apiVersionResponse((String)version), this.executionContext).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext).recoverWith((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ApiVersionService $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                Object object = A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty() ? Future$.MODULE$.failed((Throwable)new LedgerApiErrors.InternalError$.VersionService("Cannot read Ledger API version", this.$outer.com$daml$platform$apiserver$services$ApiVersionService$$contextualizedErrorLogger()).asGrpcError()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.executionContext);
    }

    private GetLedgerApiVersionResponse apiVersionResponse(String version) {
        return new GetLedgerApiVersionResponse(version, (Option)new Some((Object)this.featuresDescriptor()));
    }

    private Try<String> readVersion(String versionFileName) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (String)Source$.MODULE$.fromResource(versionFileName, Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().toList().head());
    }

    public ServerServiceDefinition bindService() {
        return VersionServiceGrpc$.MODULE$.bindService((VersionServiceGrpc.VersionService)this, this.executionContext);
    }

    public void close() {
    }

    public ApiVersionService(LedgerFeatures ledgerFeatures, UserManagementConfig userManagementConfig, LoggingContext loggingContext, ExecutionContext executionContext) {
        this.loggingContext = loggingContext;
        this.executionContext = executionContext;
        VersionServiceGrpc.VersionService.$init$((VersionServiceGrpc.VersionService)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.com$daml$platform$apiserver$services$ApiVersionService$$contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.versionFile = "ledger-api/VERSION";
        this.featuresDescriptor = FeaturesDescriptor$.MODULE$.of((Option)new Some((Object)(userManagementConfig.enabled() ? new UserManagementFeature(true, UserManagementConfig$.MODULE$.MaxRightsPerUser(), userManagementConfig.maxUsersPageSize()) : new UserManagementFeature(false, 0, 0))), (Option)new Some((Object)ExperimentalFeatures$.MODULE$.of((Option)new Some((Object)new ExperimentalSelfServiceErrorCodes()), (Option)new Some((Object)new ExperimentalStaticTime(ledgerFeatures.staticTime())), (Option)new Some((Object)ledgerFeatures.commandDeduplicationFeatures()), (Option)new Some((Object)new ExperimentalOptionalLedgerId()), (Option)new Some((Object)ledgerFeatures.contractIdFeatures()), (Option)new Some((Object)ledgerFeatures.committerEventLog()))));
    }
}

