/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.admin;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.ledger.api.v1.admin.metering_report_service.ApplicationMeteringReport;
import com.daml.ledger.api.v1.admin.metering_report_service.GetMeteringReportRequest;
import com.daml.ledger.api.v1.admin.metering_report_service.GetMeteringReportResponse;
import com.daml.ledger.api.v1.admin.metering_report_service.MeteringReportServiceGrpc;
import com.daml.ledger.api.v1.admin.metering_report_service.MeteringReportServiceGrpc$;
import com.daml.ledger.api.v1.admin.metering_report_service.MeteringReportServiceGrpc$MeteringReportService$;
import com.daml.ledger.api.v1.admin.metering_report_service.ParticipantMeteringReport;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.ledger.participant.state.index.v2.MeteringStore;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.Time;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.services.admin.ApiMeteringReportService$;
import com.daml.platform.server.api.ValidationLogger$;
import com.google.protobuf.timestamp.Timestamp;
import io.grpc.ServerServiceDefinition;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t-c!B\u000e\u001d\u0005\u0001B\u0003\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\f\u0005\r\u0001BCA\b\u0001\t\u0005\t\u0015a\u0003\u0002\u0012!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001\"CA\u0019\u0001\t\u0007I1BA\u001a\u0011!\tY\u0004\u0001Q\u0001\n\u0005U\u0002\"CA\u001f\u0001\t\u0007I1BA \u0011!\ti\u0005\u0001Q\u0001\n\u0005\u0005\u0003\"CA(\u0001\t\u0007I\u0011BA)\u0011!\u0011\t\u0003\u0001Q\u0001\n\u0005M\u0003b\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0005\b\u0005k\u0001A\u0011\tB\u001c\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003:\u0001\"a\u001a\u001d\u0011\u0003\u0001\u0013\u0011\u000e\u0004\b7qA\t\u0001IA6\u0011\u001d\ti\"\u0005C\u0001\u0003[Bq!a\u001c\u0012\t\u0003\t\t\bC\u0004\u0002\u000eF!\t!a$\t\u000f\u0005%\u0016\u0003\"\u0001\u0002,\u001a1\u0011\u0011Y\t\u0001\u0003\u0007D\u0001\u0002\u0017\f\u0003\u0002\u0003\u0006I!\u0017\u0005\b\u0003;1B\u0011AAc\u0011\u001d\tiM\u0006C\u0001\u0003\u001fD\u0011B!\u0003\u0012#\u0003%\tAa\u0003\u00031\u0005\u0003\u0018.T3uKJLgn\u001a*fa>\u0014HoU3sm&\u001cWM\u0003\u0002\u001e=\u0005)\u0011\rZ7j]*\u0011q\u0004I\u0001\tg\u0016\u0014h/[2fg*\u0011\u0011EI\u0001\nCBL7/\u001a:wKJT!a\t\u0013\u0002\u0011Ad\u0017\r\u001e4pe6T!!\n\u0014\u0002\t\u0011\fW\u000e\u001c\u0006\u0002O\u0005\u00191m\\7\u0014\t\u0001Is&\u0015\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005AreBA\u0019L\u001d\t\u0011\u0004J\u0004\u00024\r:\u0011Ag\u0011\b\u0003k\u0001s!A\u000e \u000f\u0005]jdB\u0001\u001d=\u001b\u0005I$B\u0001\u001e<\u0003\u0019a$o\\8u}\r\u0001\u0011\"A\u0014\n\u0005\u00152\u0013BA %\u0003\u0019aW\rZ4fe&\u0011\u0011IQ\u0001\u0004CBL'BA %\u0013\t!U)\u0001\u0002wc)\u0011\u0011IQ\u0005\u0003;\u001dS!\u0001R#\n\u0005%S\u0015aF7fi\u0016\u0014\u0018N\\4`e\u0016\u0004xN\u001d;`g\u0016\u0014h/[2f\u0015\tir)\u0003\u0002M\u001b\u0006IR*\u001a;fe&twMU3q_J$8+\u001a:wS\u000e,wI\u001d9d\u0015\tI%*\u0003\u0002P!\n)R*\u001a;fe&twMU3q_J$8+\u001a:wS\u000e,'B\u0001'N!\t\u0011f+D\u0001T\u0015\t!V+\u0001\u0003heB\u001c'BA!#\u0013\t96K\u0001\bHeB\u001c\u0017\t]5TKJ4\u0018nY3\u0002\u001bA\f'\u000f^5dSB\fg\u000e^%e!\tQ&M\u0004\u0002\\A6\tAL\u0003\u0002^=\u0006!A-\u0019;b\u0015\tyF%\u0001\u0002mM&\u0011\u0011\rX\u0001\u0004%\u00164\u0017BA2e\u00055\u0001\u0016M\u001d;jG&\u0004\u0018M\u001c;JI*\u0011\u0011\rX\u0001\u0006gR|'/\u001a\t\u0003OBl\u0011\u0001\u001b\u0006\u0003S*\f!A\u001e\u001a\u000b\u0005-d\u0017!B5oI\u0016D(BA7o\u0003\u0015\u0019H/\u0019;f\u0015\ty')A\u0006qCJ$\u0018nY5qC:$\u0018BA9i\u00055iU\r^3sS:<7\u000b^8sK\u0006)1\r\\8dWB\u0019!\u0006\u001e<\n\u0005U\\#!\u0003$v]\u000e$\u0018n\u001c81!\t9h0D\u0001y\u0015\tI(0A\u0005uS6,7\u000f^1na*\u00111\u0010`\u0001\taJ|Go\u001c2vM*\u0011QPJ\u0001\u0007O>|w\r\\3\n\u0005}D(!\u0003+j[\u0016\u001cH/Y7q\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIaK\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u0007\u0003\u000f\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018\u0011\nq\u0001\\8hO&tw-\u0003\u0003\u0002\u001c\u0005U!A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005\u0005\u00121FA\u0017\u0003_!b!a\t\u0002(\u0005%\u0002cAA\u0013\u00015\tA\u0004C\u0004\u0002\u0002\u0019\u0001\u001d!a\u0001\t\u000f\u0005=a\u0001q\u0001\u0002\u0012!)\u0001L\u0002a\u00013\")QM\u0002a\u0001M\"9!O\u0002I\u0001\u0002\u0004\u0019\u0018A\u00027pO\u001e,'/\u0006\u0002\u00026A!\u00111CA\u001c\u0013\u0011\tI$!\u0006\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0011dY8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4feV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t\u0013\u0002\u000b\u0015\u0014(o\u001c:\n\t\u0005-\u0013Q\t\u0002\u001a\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'/\u0001\u000ed_:$X\r\u001f;vC2L'0\u001a3FeJ|'\u000fT8hO\u0016\u0014\b%A\u0005hK:,'/\u0019;peV\u0011\u00111\u000b\t\u0004\u0003+2bbAA,!9!\u0011\u0011LA3\u001d\u0011\tY&a\u0019\u000f\t\u0005u\u0013\u0011\r\b\u0004m\u0005}\u0013BA\u0012%\u0013\t\t#%\u0003\u0002 A%\u0011QDH\u0001\u0019\u0003BLW*\u001a;fe&twMU3q_J$8+\u001a:wS\u000e,\u0007cAA\u0013#M\u0011\u0011#\u000b\u000b\u0003\u0003S\n\u0001\u0002^8PaRLwN\u001c\u000b\u0005\u0003g\nI\tE\u0003+\u0003k\nI(C\u0002\u0002x-\u0012aa\u00149uS>t\u0007\u0003BA>\u0003\u0007sA!! \u0002\u0000A\u0011\u0001hK\u0005\u0004\u0003\u0003[\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0006\u001d%AB*ue&twMC\u0002\u0002\u0002.Bq!a#\u0014\u0001\u0004\tI(A\u0006qe>$xn\u0015;sS:<\u0017\u0001\u0005;p!J|Go\u001c+j[\u0016\u001cH/Y7q)\r1\u0018\u0011\u0013\u0005\b\u0003'#\u0002\u0019AAK\u0003\t!8\u000f\u0005\u0003\u0002\u0018\u0006\u0015f\u0002BAM\u0003CsA!a'\u0002 :\u0019a'!(\n\u0005}#\u0013BA/_\u0013\r\t\u0019\u000bX\u0001\u0005)&lW-C\u0002\u0000\u0003OS1!a)]\u0003-!x\u000eV5nKN$\u0018-\u001c9\u0015\t\u00055\u0016q\u0018\t\t\u0003_\u000bI,!\u001f\u0002\u0016:!\u0011\u0011WA[\u001d\rA\u00141W\u0005\u0002Y%\u0019\u0011qW\u0016\u0002\u000fA\f7m[1hK&!\u00111XA_\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011qW\u0016\t\r\u0005MU\u00031\u0001w\u0005]iU\r^3sS:<'+\u001a9peR<UM\\3sCR|'o\u0005\u0002\u0017SQ!\u0011qYAf!\r\tIMF\u0007\u0002#!)\u0001\f\u0007a\u00013\u0006Aq-\u001a8fe\u0006$X\r\u0006\u0005\u0002R\u0006e\u00171\u001dB\u0003!\u0011\t\u0019.!6\u000e\u00035K1!a6N\u0005e9U\r^'fi\u0016\u0014\u0018N\\4SKB|'\u000f\u001e*fgB|gn]3\t\u000f\u0005m\u0017\u00041\u0001\u0002^\u00069!/Z9vKN$\b\u0003BAj\u0003?L1!!9N\u0005a9U\r^'fi\u0016\u0014\u0018N\\4SKB|'\u000f\u001e*fcV,7\u000f\u001e\u0005\b\u0003KL\u0002\u0019AAt\u0003)\u0011X\r]8si\u0012\u000bG/\u0019\t\u0005\u0003S\fyP\u0004\u0003\u0002l\u0006mh\u0002BAw\u0003stA!a<\u0002x:!\u0011\u0011_A{\u001d\r)\u00141_\u0005\u0003_\nK!!\u001c8\n\u0005-d\u0017BA5k\u0013\r\ti\u0010[\u0001\u000e\u001b\u0016$XM]5oON#xN]3\n\t\t\u0005!1\u0001\u0002\u000b%\u0016\u0004xN\u001d;ECR\f'bAA\u007fQ\"1!qA\rA\u0002Y\fabZ3oKJ\fG/[8o)&lW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001bQ3a\u001dB\bW\t\u0011\t\u0002\u0005\u0003\u0003\u0014\tuQB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u000eW\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}!Q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AC4f]\u0016\u0014\u0018\r^8sA\u0005Y!-\u001b8e'\u0016\u0014h/[2f)\t\u00119\u0003\u0005\u0003\u0003*\tERB\u0001B\u0016\u0015\r!&Q\u0006\u0006\u0003\u0005_\t!![8\n\t\tM\"1\u0006\u0002\u0018'\u0016\u0014h/\u001a:TKJ4\u0018nY3EK\u001aLg.\u001b;j_:\fQa\u00197pg\u0016$\"A!\u000f\u0011\u0007)\u0012Y$C\u0002\u0003>-\u0012A!\u00168ji\u0006\tr-\u001a;NKR,'/\u001b8h%\u0016\u0004xN\u001d;\u0015\t\t\r#\u0011\n\t\u0007\u0003\u000b\u0011)%!5\n\t\t\u001d\u0013q\u0001\u0002\u0007\rV$XO]3\t\u000f\u0005mw\u00021\u0001\u0002^\u0002")
public final class ApiMeteringReportService
implements MeteringReportServiceGrpc.MeteringReportService,
GrpcApiService {
    private final MeteringStore store;
    private final Function0<Timestamp> clock;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final ContextualizedErrorLogger contextualizedErrorLogger;
    private final MeteringReportGenerator generator;

    public static Function0<Timestamp> $lessinit$greater$default$3() {
        return ApiMeteringReportService$.MODULE$.$lessinit$greater$default$3();
    }

    public static Either<String, Time.Timestamp> toTimestamp(Timestamp ts) {
        return ApiMeteringReportService$.MODULE$.toTimestamp(ts);
    }

    public static Timestamp toProtoTimestamp(Time.Timestamp ts) {
        return ApiMeteringReportService$.MODULE$.toProtoTimestamp(ts);
    }

    public static Option<String> toOption(String protoString) {
        return ApiMeteringReportService$.MODULE$.toOption(protoString);
    }

    public MeteringReportServiceGrpc$MeteringReportService$ serviceCompanion() {
        return MeteringReportServiceGrpc.MeteringReportService.serviceCompanion$((MeteringReportServiceGrpc.MeteringReportService)this);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private ContextualizedErrorLogger contextualizedErrorLogger() {
        return this.contextualizedErrorLogger;
    }

    private MeteringReportGenerator generator() {
        return this.generator;
    }

    public ServerServiceDefinition bindService() {
        return MeteringReportServiceGrpc$.MODULE$.bindService((MeteringReportServiceGrpc.MeteringReportService)this, this.executionContext);
    }

    public void close() {
    }

    public Future<GetMeteringReportResponse> getMeteringReport(GetMeteringReportRequest request) {
        Future future;
        this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(34).append("Received metering report request: ").append(request).toString(), this.loggingContext);
        Either either = request.from().toRight((Function0 & Serializable)() -> "from date must be specified").flatMap((Function1 & Serializable)protoFrom -> ApiMeteringReportService$.MODULE$.toTimestamp((Timestamp)protoFrom).flatMap((Function1 & Serializable)from -> ((Either)request.to().fold((Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)None$.MODULE$), (Function1 & Serializable)t -> ApiMeteringReportService$.MODULE$.toTimestamp((Timestamp)t).map((Function1 & Serializable)value -> new Some(value)))).flatMap((Function1 & Serializable)to -> ((Either)ApiMeteringReportService$.MODULE$.toOption(request.applicationId()).fold((Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)None$.MODULE$), (Function1 & Serializable)t -> Ref$.MODULE$.ApplicationId().fromString(t).map((Function1 & Serializable)value -> new Some(value)))).map((Function1 & Serializable)applicationId -> {
            Timestamp reportTime = (Timestamp)$this.clock.apply();
            return $this.store.getMeteringReportData(from, to, applicationId, $this.loggingContext).map((Function1 & Serializable)reportData -> this.generator().generate(request, (MeteringStore.ReportData)reportData, reportTime), $this.executionContext);
        }))));
        if (either instanceof Right) {
            Future f;
            Right right = (Right)either;
            future = f = (Future)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            future = Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure((Object)request, (Throwable)ValidationErrors$.MODULE$.invalidArgument(error, this.contextualizedErrorLogger()), this.logger(), this.loggingContext));
        } else {
            throw new MatchError((Object)either);
        }
        return future;
    }

    public ApiMeteringReportService(String participantId, MeteringStore store, Function0<Timestamp> clock, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.store = store;
        this.clock = clock;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        MeteringReportServiceGrpc.MeteringReportService.$init$((MeteringReportServiceGrpc.MeteringReportService)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.generator = new MeteringReportGenerator(participantId);
    }

    public static class MeteringReportGenerator {
        private final String participantId;

        public GetMeteringReportResponse generate(GetMeteringReportRequest request, MeteringStore.ReportData reportData, Timestamp generationTime) {
            List applicationReports = ((List)reportData.applicationData().toList().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map(((Function2 & Serializable)(Function2 & Serializable)(applicationId, eventCount) -> MeteringReportGenerator.$anonfun$generate$2(applicationId, BoxesRunTime.unboxToLong((Object)eventCount))).tupled());
            ParticipantMeteringReport report = new ParticipantMeteringReport(this.participantId, reportData.isFinal(), (Seq)applicationReports);
            return new GetMeteringReportResponse((Option)new Some((Object)request), (Option)new Some((Object)report), (Option)new Some((Object)generationTime));
        }

        public static final /* synthetic */ ApplicationMeteringReport $anonfun$generate$2(String applicationId, long eventCount) {
            return new ApplicationMeteringReport(applicationId, eventCount);
        }

        public MeteringReportGenerator(String participantId) {
            this.participantId = participantId;
        }
    }
}

