/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.admin;

import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import com.daml.api.util.TimestampConversion$;
import com.daml.daml_lf_dev.DamlLf;
import com.daml.error.ContextualizedError;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.DamlError;
import com.daml.error.definitions.PackageServiceError;
import com.daml.error.definitions.groups.AdminServices;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.v1.admin.package_management_service.ListKnownPackagesRequest;
import com.daml.ledger.api.v1.admin.package_management_service.ListKnownPackagesResponse;
import com.daml.ledger.api.v1.admin.package_management_service.PackageDetails;
import com.daml.ledger.api.v1.admin.package_management_service.PackageManagementServiceGrpc;
import com.daml.ledger.api.v1.admin.package_management_service.PackageManagementServiceGrpc$;
import com.daml.ledger.api.v1.admin.package_management_service.PackageManagementServiceGrpc$PackageManagementService$;
import com.daml.ledger.api.v1.admin.package_management_service.UploadDarFileRequest;
import com.daml.ledger.api.v1.admin.package_management_service.UploadDarFileResponse;
import com.daml.ledger.participant.state.index.v2.IndexPackagesService;
import com.daml.ledger.participant.state.index.v2.IndexTransactionsService;
import com.daml.ledger.participant.state.index.v2.LedgerEndService;
import com.daml.ledger.participant.state.v2.SubmissionResult;
import com.daml.ledger.participant.state.v2.WritePackagesService;
import com.daml.lf.archive.Dar;
import com.daml.lf.archive.Decode$;
import com.daml.lf.archive.GenDarReader;
import com.daml.lf.engine.Engine;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.services.admin.ApiPackageManagementService$;
import com.daml.platform.apiserver.services.admin.SynchronousResponse;
import com.daml.platform.apiserver.services.logging.package$;
import com.daml.telemetry.DefaultTelemetry$;
import com.daml.telemetry.TelemetryContext;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.util.zip.ZipInputStream;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Try;
import scalaz.Applicative;
import scalaz.std.either$;
import scalaz.std.list$;

@ScalaSignature(bytes="\u0006\u0005\r]g!\u0002\u00180\u0005MZ\u0004\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011a\u0004!\u0011!Q\u0001\neD\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003\u000b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\f\u0001\t\u0005\t\u0015!\u0003\u0002\u001a!Q\u0011q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005-\u0003A!A!\u0002\u0013\ti\u0005\u0003\u0006\u0002x\u0001\u0011\t\u0011)A\u0006\u0003sB!\"!#\u0001\u0005\u0003\u0005\u000b1BAF\u0011)\t\u0019\n\u0001B\u0001B\u0003-\u0011Q\u0013\u0005\b\u0003C\u0003A\u0011BAR\u0011%\ty\f\u0001b\u0001\n\u0017\t\t\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0011BAb\u0011%\tY\r\u0001b\u0001\n\u0013\ti\r\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BAh\u0011\u001d\tI\u0010\u0001C!\u0003wDqAa\u0001\u0001\t\u0003\u0012)\u0001C\u0004\u0003\u0016\u0001!\tEa\u0006\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!q\r\u0001\u0005B\t%dA\u0002B>\u0001\u0015\u0011i\b\u0003\u0006\u0003\u0002V\u0011\t\u0011)A\u0005\u0005\u0007Cq!!)\u0016\t\u0003\u0011\t\fC\u0004\u0003:V!\tAa/\t\u0013\tE\u0007!!A\u0005\f\tMw\u0001\u0003Bs_!\u00051Ga:\u0007\u000f9z\u0003\u0012A\u001a\u0003j\"9\u0011\u0011U\u000e\u0005\u0002\t-\bb\u0002Bw7\u0011\u0005!q\u001e\u0005\n\u0007+Y\u0012\u0013!C\u0001\u0007/A\u0011b!\f\u001c#\u0003%\taa\f\u0007\r\rM2DBB\u001b\u0011)\u0019)\u0005\tB\u0001B\u0003%1q\t\u0005\tW\u0002\u0012\t\u0011)A\u0005Y\"AA\u0010\tB\u0001B\u0003%Q\u0010\u0003\u0006\u0002\n\u0002\u0012\t\u0011)A\u0006\u0003\u0017C!\"a%!\u0005\u0003\u0005\u000b1BAK\u0011\u001d\t\t\u000b\tC\u0001\u0007\u001bB\u0011\"a0!\u0005\u0004%Y!!1\t\u0011\u0005%\u0007\u0005)A\u0005\u0003\u0007Dqaa\u0018!\t\u0003\u001a\t\u0007C\u0004\u0004z\u0001\"\tea\u001f\t\u000f\r\u0005\u0006\u0005\"\u0011\u0004$\"91Q\u0018\u0011\u0005B\r}\u0006bBBeA\u0011\u000531\u001a\u0002\u001c\u0003BL\u0007+Y2lC\u001e,W*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3\u000b\u0005A\n\u0014!B1e[&t'B\u0001\u001a4\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001\u001b6\u0003%\t\u0007/[:feZ,'O\u0003\u00027o\u0005A\u0001\u000f\\1uM>\u0014XN\u0003\u00029s\u0005!A-Y7m\u0015\u0005Q\u0014aA2p[N!\u0001\u0001\u0010\"e!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0019\te.\u001f*fMB\u00111)\u0019\b\u0003\tzs!!R.\u000f\u0005\u0019KfBA$W\u001d\tA5K\u0004\u0002J#:\u0011!\n\u0015\b\u0003\u0017>k\u0011\u0001\u0014\u0006\u0003\u001b:\u000ba\u0001\u0010:p_Rt4\u0001A\u0005\u0002u%\u0011\u0001(O\u0005\u0003%^\na\u0001\\3eO\u0016\u0014\u0018B\u0001+V\u0003\r\t\u0007/\u001b\u0006\u0003%^J!a\u0016-\u0002\u0005Y\f$B\u0001+V\u0013\t\u0001$L\u0003\u0002X1&\u0011A,X\u0001\u001ba\u0006\u001c7.Y4f?6\fg.Y4f[\u0016tGoX:feZL7-\u001a\u0006\u0003aiK!a\u00181\u00029A\u000b7m[1hK6\u000bg.Y4f[\u0016tGoU3sm&\u001cWm\u0012:qG*\u0011A,X\u0005\u0003E\u000e\u0014\u0001\u0004U1dW\u0006<W-T1oC\u001e,W.\u001a8u'\u0016\u0014h/[2f\u0015\ty\u0006\r\u0005\u0002fS6\taM\u0003\u0002hQ\u0006!qM\u001d9d\u0015\t!V'\u0003\u0002kM\nqqI\u001d9d\u0003BL7+\u001a:wS\u000e,\u0017!\u00049bG.\fw-Z:J]\u0012,\u0007\u0010\u0005\u0002nm6\taN\u0003\u0002pa\u0006\u0011aO\r\u0006\u0003cJ\fQ!\u001b8eKbT!a\u001d;\u0002\u000bM$\u0018\r^3\u000b\u0005U,\u0016a\u00039beRL7-\u001b9b]RL!a\u001e8\u0003)%sG-\u001a=QC\u000e\\\u0017mZ3t'\u0016\u0014h/[2f\u0003M!(/\u00198tC\u000e$\u0018n\u001c8t'\u0016\u0014h/[2f!\ti'0\u0003\u0002|]\nA\u0012J\u001c3fqR\u0013\u0018M\\:bGRLwN\\:TKJ4\u0018nY3\u0002\u001bA\f7m[1hKN<&/\u001b;f!\rq\u0018\u0011A\u0007\u0002\u007f*\u0011qN]\u0005\u0004\u0003\u0007y(\u0001F,sSR,\u0007+Y2lC\u001e,7oU3sm&\u001cW-\u0001\rnC:\fw-Z7f]R\u001cVM\u001d<jG\u0016$\u0016.\\3pkR\u0004B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0005ekJ\fG/[8o\u0015\r\t\tBP\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u000b\u0003\u0017\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\u0004f]\u001eLg.\u001a\t\u0005\u00037\t\u0019#\u0004\u0002\u0002\u001e)!\u0011qCA\u0010\u0015\r\t\tcN\u0001\u0003Y\u001aLA!!\n\u0002\u001e\t1QI\\4j]\u0016\f\u0011\u0002Z1s%\u0016\fG-\u001a:\u0011\r\u0005-\u0012\u0011GA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005}\u0011aB1sG\"Lg/Z\u0005\u0005\u0003g\tiC\u0001\u0007HK:$\u0015M\u001d*fC\u0012,'\u000f\u0005\u0003\u00028\u0005\u0015c\u0002BA\u001d\u0003\u007fq1!SA\u001e\u0013\r\tidN\u0001\fI\u0006lGn\u00187g?\u0012,g/\u0003\u0003\u0002B\u0005\r\u0013A\u0002#b[2deMC\u0002\u0002>]JA!a\u0012\u0002J\t9\u0011I]2iSZ,'\u0002BA!\u0003\u0007\nQc];c[&\u001c8/[8o\u0013\u0012<UM\\3sCR|'\u000fE\u0004>\u0003\u001f\n\u0019&a\u0019\n\u0007\u0005EcHA\u0005Gk:\u001cG/[8ocA!\u0011QKA/\u001d\u0011\t9&!\u0017\u0011\u0005-s\u0014bAA.}\u00051\u0001K]3eK\u001aLA!a\u0018\u0002b\t11\u000b\u001e:j]\u001eT1!a\u0017?!\u0011\t)'!\u001d\u000f\t\u0005\u001d\u0014QN\u0007\u0003\u0003SRA!a\u001b\u0002 \u0005!A-\u0019;b\u0013\u0011\ty'!\u001b\u0002\u0007I+g-\u0003\u0003\u0002t\u0005U$\u0001D*vE6L7o]5p]&#'\u0002BA8\u0003S\nA\"\\1uKJL\u0017\r\\5{KJ\u0004B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u0003\u0007\u000bA!Y6lC&!\u0011qQA?\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0003\u0002\u000e\u0006=UBAA\b\u0013\u0011\t\t*a\u0004\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018A\u00047pO\u001eLgnZ\"p]R,\u0007\u0010\u001e\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111T\u001c\u0002\u000f1|wmZ5oO&!\u0011qTAM\u00059aunZ4j]\u001e\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003EAS\u0003c\u000b\u0019,!.\u00028\u0006e\u00161XA_)!\t9+a+\u0002.\u0006=\u0006cAAU\u00015\tq\u0006C\u0004\u0002x-\u0001\u001d!!\u001f\t\u000f\u0005%5\u0002q\u0001\u0002\f\"9\u00111S\u0006A\u0004\u0005U\u0005\"B6\f\u0001\u0004a\u0007\"\u0002=\f\u0001\u0004I\b\"\u0002?\f\u0001\u0004i\bbBA\u0003\u0017\u0001\u0007\u0011q\u0001\u0005\b\u0003/Y\u0001\u0019AA\r\u0011\u001d\t9c\u0003a\u0001\u0003SAq!a\u0013\f\u0001\u0004\ti%\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003\u0007\u0004B!a&\u0002F&!\u0011qYAM\u0005Q\u0019uN\u001c;fqR,\u0018\r\\5{K\u0012dunZ4fe\u00069An\\4hKJ\u0004\u0013aE:z]\u000eD'o\u001c8pkN\u0014Vm\u001d9p]N,WCAAh!)\tI+!5\u0002V\u0006m\u0017\u0011^\u0005\u0004\u0003'|#aE*z]\u000eD'o\u001c8pkN\u0014Vm\u001d9p]N,\u0007CBA\u0016\u0003/\f)$\u0003\u0003\u0002Z\u00065\"a\u0001#beB!\u0011Q\\Ar\u001d\r9\u0015q\\\u0005\u0004\u0003CD\u0016A\u00023p[\u0006Lg.\u0003\u0003\u0002f\u0006\u001d(\u0001\u0004)bG.\fw-Z#oiJL(bAAq1B!\u00111^Ay\u001d\u0011\ti.!<\n\t\u0005=\u0018q]\u0001\r!\u0006\u001c7.Y4f\u000b:$(/_\u0005\u0005\u0003g\f)PA\u000bQC\u000e\\\u0017mZ3Va2|\u0017\rZ!dG\u0016\u0004H/\u001a3\u000b\t\u0005=\u0018q]\u0001\u0015gft7\r\u001b:p]>,8OU3ta>t7/\u001a\u0011\u0002\u000b\rdwn]3\u0015\u0005\u0005u\bcA\u001f\u0002\u0000&\u0019!\u0011\u0001 \u0003\tUs\u0017\u000e^\u0001\fE&tGmU3sm&\u001cW\r\u0006\u0002\u0003\bA!!\u0011\u0002B\t\u001b\t\u0011YAC\u0002h\u0005\u001bQ!Aa\u0004\u0002\u0005%|\u0017\u0002\u0002B\n\u0005\u0017\u0011qcU3sm\u0016\u00148+\u001a:wS\u000e,G)\u001a4j]&$\u0018n\u001c8\u0002#1L7\u000f^&o_^t\u0007+Y2lC\u001e,7\u000f\u0006\u0003\u0003\u001a\t\u001d\u0002CBAG\u00057\u0011y\"\u0003\u0003\u0003\u001e\u0005=!A\u0002$viV\u0014X\r\u0005\u0003\u0003\"\t\rR\"\u00011\n\u0007\t\u0015\u0002MA\rMSN$8J\\8x]B\u000b7m[1hKN\u0014Vm\u001d9p]N,\u0007b\u0002B\u0015%\u0001\u0007!1F\u0001\be\u0016\fX/Z:u!\u0011\u0011\tC!\f\n\u0007\t=\u0002M\u0001\rMSN$8J\\8x]B\u000b7m[1hKN\u0014V-];fgR\f\u0011\u0003Z3d_\u0012,\u0017I\u001c3WC2LG-\u0019;f)\u0011\u0011)Da\u0015\u0015\t\t]\"1\t\t\u0007\u0005s\u0011y$!6\u000e\u0005\tm\"b\u0001B\u001f}\u0005!Q\u000f^5m\u0013\u0011\u0011\tEa\u000f\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0003FM\u0001\u001dAa\u0012\u00023\r|g\u000e^3yiV\fG.\u001b>fI\u0016\u0013(o\u001c:M_\u001e<WM\u001d\t\u0005\u0005\u0013\u0012y%\u0004\u0002\u0003L)\u0019!QJ\u001c\u0002\u000b\u0015\u0014(o\u001c:\n\t\tE#1\n\u0002\u001a\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'\u000fC\u0004\u0002\u0000M\u0001\rA!\u0016\u0011\t\t]#1M\u0007\u0003\u00053RAAa\u0017\u0003^\u0005\u0019!0\u001b9\u000b\t\tu\"q\f\u0006\u0003\u0005C\nAA[1wC&!!Q\rB-\u00059Q\u0016\u000e]%oaV$8\u000b\u001e:fC6\fQ\"\u001e9m_\u0006$G)\u0019:GS2,G\u0003\u0002B6\u0005g\u0002b!!$\u0003\u001c\t5\u0004\u0003\u0002B\u0011\u0005_J1A!\u001da\u0005U)\u0006\u000f\\8bI\u0012\u000b'OR5mKJ+7\u000f]8og\u0016DqA!\u000b\u0015\u0001\u0004\u0011)\b\u0005\u0003\u0003\"\t]\u0014b\u0001B=A\n!R\u000b\u001d7pC\u0012$\u0015M\u001d$jY\u0016\u0014V-];fgR\u0014\u0001#\u0012:s_J4\u0016\r\\5eCRLwN\\:\u0016\r\t}$\u0011\u0014BW'\t)B(\u0001\u0004sKN,H\u000e\u001e\t\t\u0005\u000b\u0013yI!&\u0003,:!!q\u0011BF\u001d\rY%\u0011R\u0005\u0002\u007f%\u0019!Q\u0012 \u0002\u000fA\f7m[1hK&!!\u0011\u0013BJ\u0005\u0019)\u0015\u000e\u001e5fe*\u0019!Q\u0012 \u0011\t\t]%\u0011\u0014\u0007\u0001\t\u001d\u0011Y*\u0006b\u0001\u0005;\u0013\u0011!R\t\u0005\u0005?\u0013)\u000bE\u0002>\u0005CK1Aa)?\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\u0010BT\u0013\r\u0011IK\u0010\u0002\u0004\u0003:L\b\u0003\u0002BL\u0005[#qAa,\u0016\u0005\u0004\u0011iJA\u0001S)\u0011\u0011\u0019La.\u0011\u000f\tUVC!&\u0003,6\t\u0001\u0001C\u0004\u0003\u0002^\u0001\rAa!\u0002\u0017!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d\u000b\u0005\u0005{\u0013y\f\u0005\u0004\u0003:\t}\"1\u0016\u0005\b\u0005\u0003D\u0002\u0019\u0001Bb\u0003Y!xnU3mMN+'O^5dK\u0016\u0013(o\u001c:D_\u0012,\u0007cB\u001f\u0002P\tU%Q\u0019\t\u0005\u0005\u000f\u0014i-\u0004\u0002\u0003J*!!1\u001aB&\u0003-!WMZ5oSRLwN\\:\n\t\t='\u0011\u001a\u0002\n\t\u0006lG.\u0012:s_J\f\u0001#\u0012:s_J4\u0016\r\\5eCRLwN\\:\u0016\r\tU'1\u001cBp)\u0011\u00119N!9\u0011\u000f\tUVC!7\u0003^B!!q\u0013Bn\t\u001d\u0011Y*\u0007b\u0001\u0005;\u0003BAa&\u0003`\u00129!qV\rC\u0002\tu\u0005b\u0002BA3\u0001\u0007!1\u001d\t\t\u0005\u000b\u0013yI!7\u0003^\u0006Y\u0012\t]5QC\u000e\\\u0017mZ3NC:\fw-Z7f]R\u001cVM\u001d<jG\u0016\u00042!!+\u001c'\tYB\b\u0006\u0002\u0003h\u0006\u00012M]3bi\u0016\f\u0005/[*feZL7-\u001a\u000b\u0011\u0005c\u001c\u0019aa\u0002\u0004\n\r51qBB\t\u0007'!\u0002Ba=\u0003~\n}8\u0011\u0001\n\u0006\u0005k\u0014I\u0010\u001a\u0004\u0007\u0005o\\\u0002Aa=\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007\tm\u0018MD\u0002\u0003\"yCq!a\u001e\u001e\u0001\b\tI\bC\u0004\u0002\nv\u0001\u001d!a#\t\u000f\u0005MU\u0004q\u0001\u0002\u0016\"11QA\u000fA\u00021\f1B]3bI\n\u000b7m[3oI\")\u00010\ba\u0001s\"111B\u000fA\u0002u\fAb\u001e:ji\u0016\u0014\u0015mY6f]\u0012Dq!!\u0002\u001e\u0001\u0004\t9\u0001C\u0004\u0002\u0018u\u0001\r!!\u0007\t\u0013\u0005\u001dR\u0004%AA\u0002\u0005%\u0002\"CA&;A\u0005\t\u0019AA'\u0003i\u0019'/Z1uK\u0006\u0003\u0018nU3sm&\u001cW\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019IB\u000b\u0003\u0002*\rm1FAB\u000f!\u0011\u0019yb!\u000b\u000e\u0005\r\u0005\"\u0002BB\u0012\u0007K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\u001db(\u0001\u0006b]:|G/\u0019;j_:LAaa\u000b\u0004\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\r\u0014X-\u0019;f\u0003BL7+\u001a:wS\u000e,G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\rE\"\u0006BA'\u00077\u00111dU=oG\"\u0014xN\\8vgJ+7\u000f]8og\u0016\u001cFO]1uK\u001eL8\u0003\u0002\u0011=\u0007o\u0001\"b!\u000f\u0004@\u0005U\u00171\\Au\u001d\u0011\tIka\u000f\n\u0007\rur&A\nTs:\u001c\u0007N]8o_V\u001c(+Z:q_:\u001cX-\u0003\u0003\u0004B\r\r#\u0001C*ue\u0006$XmZ=\u000b\u0007\rur&\u0001\tmK\u0012<WM]#oIN+'O^5dKB\u0019Qn!\u0013\n\u0007\r-cN\u0001\tMK\u0012<WM]#oIN+'O^5dKRA1qJB-\u00077\u001ai\u0006\u0006\u0004\u0004R\rU3q\u000b\t\u0004\u0007'\u0002S\"A\u000e\t\u000f\u0005%e\u0005q\u0001\u0002\f\"9\u00111\u0013\u0014A\u0004\u0005U\u0005bBB#M\u0001\u00071q\t\u0005\u0006W\u001a\u0002\r\u0001\u001c\u0005\u0006y\u001a\u0002\r!`\u0001\u0011GV\u0014(/\u001a8u\u0019\u0016$w-\u001a:F]\u0012$\"aa\u0019\u0011\r\u00055%1DB3!\u0015i4qMB6\u0013\r\u0019IG\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\r541\u000f\b\u0005\u0003;\u001cy'\u0003\u0003\u0004r\u0005\u001d\u0018\u0001\u0004'fI\u001e,'o\u00144gg\u0016$\u0018\u0002BB;\u0007o\u0012\u0001\"\u00112t_2,H/\u001a\u0006\u0005\u0007c\n9/\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0007\u0007{\u001aIj!(\u0015\r\r}4qQBL!\u0019\tiIa\u0007\u0004\u0002B\u0019apa!\n\u0007\r\u0015uP\u0001\tTk\nl\u0017n]:j_:\u0014Vm];mi\"91\u0011\u0012\u0016A\u0004\r-\u0015\u0001\u0005;fY\u0016lW\r\u001e:z\u0007>tG/\u001a=u!\u0011\u0019iia%\u000e\u0005\r=%bABIo\u0005IA/\u001a7f[\u0016$(/_\u0005\u0005\u0007+\u001byI\u0001\tUK2,W.\u001a;ss\u000e{g\u000e^3yi\"9\u00111\u0013\u0016A\u0004\u0005U\u0005bBBNU\u0001\u0007\u00111M\u0001\rgV\u0014W.[:tS>t\u0017\n\u001a\u0005\b\u0007?S\u0003\u0019AAk\u0003\r!\u0017M]\u0001\bK:$(/[3t)\u0011\u0019)k!/1\t\r\u001d6Q\u0017\t\t\u0007S\u001by+a7\u000446\u001111\u0016\u0006\u0005\u0007[\u000bi(\u0001\u0005tG\u0006d\u0017\rZ:m\u0013\u0011\u0019\tla+\u0003\rM{WO]2f!\u0011\u00119j!.\u0005\u0017\r]6&!A\u0001\u0002\u000b\u0005!Q\u0014\u0002\u0004?\u0012\n\u0004bBB^W\u0001\u00071QM\u0001\u0007_\u001a47/\u001a;\u0002\r\u0005\u001c7-\u001a9u)\u0011\u0019\tma2\u0011\u000fu\u001a\u0019-a7\u0002j&\u00191Q\u0019 \u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:Dqaa'-\u0001\u0004\t\u0019'\u0001\u0004sK*,7\r\u001e\u000b\u0005\u0007\u001b\u001c)\u000eE\u0004>\u0007\u0007\fYna4\u0011\t\t%1\u0011[\u0005\u0005\u0007'\u0014YA\u0001\fTi\u0006$Xo\u001d*v]RLW.Z#yG\u0016\u0004H/[8o\u0011\u001d\u0019Y*\fa\u0001\u0003G\u0002")
public final class ApiPackageManagementService
implements PackageManagementServiceGrpc.PackageManagementService,
GrpcApiService {
    private final IndexPackagesService packagesIndex;
    private final Engine engine;
    private final GenDarReader<DamlLf.Archive> darReader;
    private final Function1<String, String> submissionIdGenerator;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final SynchronousResponse<Dar<DamlLf.Archive>, domain.PackageEntry, domain.PackageEntry.PackageUploadAccepted> synchronousResponse;

    public static Function1<String, String> createApiService$default$7() {
        return ApiPackageManagementService$.MODULE$.createApiService$default$7();
    }

    public static GenDarReader<DamlLf.Archive> createApiService$default$6() {
        return ApiPackageManagementService$.MODULE$.createApiService$default$6();
    }

    public static PackageManagementServiceGrpc.PackageManagementService createApiService(IndexPackagesService readBackend, IndexTransactionsService transactionsService, WritePackagesService writeBackend, FiniteDuration managementServiceTimeout, Engine engine, GenDarReader<DamlLf.Archive> darReader, Function1<String, String> submissionIdGenerator, Materializer materializer, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ApiPackageManagementService$.MODULE$.createApiService(readBackend, transactionsService, writeBackend, managementServiceTimeout, engine, darReader, submissionIdGenerator, materializer, executionContext, loggingContext);
    }

    public PackageManagementServiceGrpc$PackageManagementService$ serviceCompanion() {
        return PackageManagementServiceGrpc.PackageManagementService.serviceCompanion$((PackageManagementServiceGrpc.PackageManagementService)this);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private SynchronousResponse<Dar<DamlLf.Archive>, domain.PackageEntry, domain.PackageEntry.PackageUploadAccepted> synchronousResponse() {
        return this.synchronousResponse;
    }

    public void close() {
    }

    public ServerServiceDefinition bindService() {
        return PackageManagementServiceGrpc$.MODULE$.bindService((PackageManagementServiceGrpc.PackageManagementService)this, this.executionContext);
    }

    public Future<ListKnownPackagesResponse> listKnownPackages(ListKnownPackagesRequest request) {
        this.logger().info().apply((Function0 & Serializable)() -> "Listing known packages", this.loggingContext);
        return this.packagesIndex.listLfPackages(this.loggingContext).map((Function1 & Serializable)pkgs -> new ListKnownPackagesResponse((Seq)pkgs.toSeq().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String pkgId = (String)tuple2._1();
            com.daml.ledger.participant.state.index.v2.PackageDetails details = (com.daml.ledger.participant.state.index.v2.PackageDetails)tuple2._2();
            PackageDetails packageDetails = new PackageDetails(pkgId.toString(), details.size(), (Option)new Some((Object)TimestampConversion$.MODULE$.fromLf(details.knownSince())), (String)details.sourceDescription().getOrElse((Function0 & Serializable)() -> ""));
            return packageDetails;
        })), this.executionContext).andThen(this.logger().logErrorsOnCall(this.loggingContext), this.executionContext);
    }

    private Try<Dar<DamlLf.Archive>> decodeAndValidate(ZipInputStream stream, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.ErrorValidations(this.darReader.readArchive("package-upload", stream, this.darReader.readArchive$default$3())).handleError((Function1 & Serializable)lfArchiveError -> PackageServiceError.Validation$.MODULE$.handleLfArchiveError(lfArchiveError, contextualizedErrorLogger)).flatMap((Function1 & Serializable)dar -> this.ErrorValidations((Either)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps((Object)dar.all(), list$.MODULE$.listInstance()).traverse((Function1 & Serializable)x$1 -> Decode$.MODULE$.decodeArchive(x$1, Decode$.MODULE$.decodeArchive$default$2()), (Applicative)either$.MODULE$.eitherMonad())).handleError((Function1 & Serializable)lfArchiveError -> PackageServiceError.Validation$.MODULE$.handleLfArchiveError(lfArchiveError, contextualizedErrorLogger)).flatMap((Function1 & Serializable)packages -> this.ErrorValidations($this.engine.validatePackages(packages.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).handleError((Function1 & Serializable)err -> PackageServiceError.Validation$.MODULE$.handleLfEnginePackageError(err, contextualizedErrorLogger)).map((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit = x$2;
            Dar dar = dar;
            return dar;
        })));
    }

    public Future<UploadDarFileResponse> uploadDarFile(UploadDarFileRequest request) {
        String submissionId = (String)this.submissionIdGenerator.apply((Object)request.submissionId());
        return (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(package$.MODULE$.submissionId(submissionId), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Uploading DAR file", loggingContext);
            ZipInputStream darInputStream = new ZipInputStream(request.darFile().newInput());
            TelemetryContext telemetryContext = DefaultTelemetry$.MODULE$.contextFromGrpcThreadLocalContext();
            DamlContextualizedErrorLogger contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)new Some((Object)submissionId));
            Future response = Future$.MODULE$.fromTry(this.decodeAndValidate(darInputStream, (ContextualizedErrorLogger)contextualizedErrorLogger)).flatMap((Function1 & Serializable)dar -> this.synchronousResponse().submitAndWait(submissionId, (Dar<DamlLf.Archive>)dar, telemetryContext, (LoggingContext)loggingContext).map((Function1 & Serializable)x$3 -> {
                domain.PackageEntry.PackageUploadAccepted packageUploadAccepted = x$3;
                dar.all().foreach((Function1 & Serializable)archive -> {
                    ApiPackageManagementService.$anonfun$uploadDarFile$5(this, loggingContext, archive);
                    return BoxedUnit.UNIT;
                });
                UploadDarFileResponse uploadDarFileResponse = new UploadDarFileResponse();
                return uploadDarFileResponse;
            }, $this.executionContext), $this.executionContext);
            return response.andThen(this.logger().logErrorsOnCall(loggingContext), $this.executionContext);
        }, this.loggingContext);
    }

    private <E, R> ErrorValidations<E, R> ErrorValidations(Either<E, R> result) {
        return new ErrorValidations<E, R>(this, result);
    }

    public static final /* synthetic */ void $anonfun$uploadDarFile$5(ApiPackageManagementService $this, LoggingContext loggingContext$1, DamlLf.Archive archive) {
        $this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(30).append("Package ").append(archive.getHash()).append(" successfully uploaded").toString(), loggingContext$1);
    }

    public ApiPackageManagementService(IndexPackagesService packagesIndex, IndexTransactionsService transactionsService, WritePackagesService packagesWrite, FiniteDuration managementServiceTimeout, Engine engine, GenDarReader<DamlLf.Archive> darReader, Function1<String, String> submissionIdGenerator, Materializer materializer, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.packagesIndex = packagesIndex;
        this.engine = engine;
        this.darReader = darReader;
        this.submissionIdGenerator = submissionIdGenerator;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        PackageManagementServiceGrpc.PackageManagementService.$init$((PackageManagementServiceGrpc.PackageManagementService)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.synchronousResponse = new SynchronousResponse<Dar<DamlLf.Archive>, domain.PackageEntry, domain.PackageEntry.PackageUploadAccepted>(new SynchronousResponseStrategy((LedgerEndService)transactionsService, packagesIndex, packagesWrite, executionContext, loggingContext), managementServiceTimeout, executionContext, materializer);
    }

    private class ErrorValidations<E, R> {
        private final Either<E, R> result;
        public final /* synthetic */ ApiPackageManagementService $outer;

        public Try<R> handleError(Function1<E, DamlError> toSelfServiceErrorCode) {
            return this.result.left().map((Function1 & Serializable)err -> ((ContextualizedError)toSelfServiceErrorCode.apply(err)).asGrpcError()).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public /* synthetic */ ApiPackageManagementService com$daml$platform$apiserver$services$admin$ApiPackageManagementService$ErrorValidations$$$outer() {
            return this.$outer;
        }

        public ErrorValidations(ApiPackageManagementService $outer, Either<E, R> result) {
            this.result = result;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private static final class SynchronousResponseStrategy
    implements SynchronousResponse.Strategy<Dar<DamlLf.Archive>, domain.PackageEntry, domain.PackageEntry.PackageUploadAccepted> {
        private final LedgerEndService ledgerEndService;
        private final IndexPackagesService packagesIndex;
        private final WritePackagesService packagesWrite;
        private final ExecutionContext executionContext;
        public final LoggingContext com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$loggingContext;
        private final ContextualizedLogger com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$logger;

        public ContextualizedLogger com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$logger() {
            return this.com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$logger;
        }

        @Override
        public Future<Option<domain.LedgerOffset.Absolute>> currentLedgerEnd() {
            return this.ledgerEndService.currentLedgerEnd(this.com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$loggingContext).map((Function1 & Serializable)x$4 -> new Some(x$4), this.executionContext);
        }

        @Override
        public Future<SubmissionResult> submit(String submissionId, Dar<DamlLf.Archive> dar, TelemetryContext telemetryContext, LoggingContext loggingContext) {
            return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(this.packagesWrite.uploadPackages(submissionId, dar.all(), (Option)None$.MODULE$, loggingContext, telemetryContext)));
        }

        @Override
        public Source<domain.PackageEntry, ?> entries(Option<domain.LedgerOffset.Absolute> offset) {
            return this.packagesIndex.packageEntries(offset, this.com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$loggingContext);
        }

        @Override
        public PartialFunction<domain.PackageEntry, domain.PackageEntry.PackageUploadAccepted> accept(String submissionId) {
            return new Serializable(null, submissionId){
                private static final long serialVersionUID = 0L;
                private final String submissionId$2;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends domain.PackageEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof domain.PackageEntry.PackageUploadAccepted) {
                        domain.PackageEntry.PackageUploadAccepted packageUploadAccepted = (domain.PackageEntry.PackageUploadAccepted)A1;
                        String string = packageUploadAccepted.submissionId();
                        String string2 = this.submissionId$2;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            object = packageUploadAccepted;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(domain.PackageEntry x1) {
                    domain.PackageEntry packageEntry = x1;
                    if (!(packageEntry instanceof domain.PackageEntry.PackageUploadAccepted)) return false;
                    domain.PackageEntry.PackageUploadAccepted packageUploadAccepted = (domain.PackageEntry.PackageUploadAccepted)packageEntry;
                    String string = packageUploadAccepted.submissionId();
                    String string2 = this.submissionId$2;
                    String string3 = string;
                    if (string2 != null) {
                        if (!string2.equals(string3)) return false;
                        return true;
                    }
                    if (string3 == null) return true;
                    return false;
                }
                {
                    this.submissionId$2 = submissionId$2;
                }
            };
        }

        @Override
        public PartialFunction<domain.PackageEntry, StatusRuntimeException> reject(String submissionId) {
            return new Serializable(this, submissionId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ SynchronousResponseStrategy $outer;
                private final String submissionId$3;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends domain.PackageEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var3_10;
                    A1 A1 = x1;
                    if (A1 instanceof domain.PackageEntry$.PackageUploadRejected) {
                        domain.PackageEntry$.PackageUploadRejected packageUploadRejected = (domain.PackageEntry$.PackageUploadRejected)A1;
                        String string = packageUploadRejected.submissionId();
                        String reason = packageUploadRejected.reason();
                        String string2 = this.submissionId$3;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            StatusRuntimeException statusRuntimeException = new AdminServices.PackageUploadRejected$.Reject(reason, (ContextualizedErrorLogger)new DamlContextualizedErrorLogger(this.$outer.com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$logger(), this.$outer.com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$loggingContext, (Option)new Some((Object)this.submissionId$3))).asGrpcError();
                            return var3_10;
                        }
                    }
                    Object object = function1.apply(x1);
                    return var3_10;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(domain.PackageEntry x1) {
                    domain.PackageEntry packageEntry = x1;
                    if (!(packageEntry instanceof domain.PackageEntry$.PackageUploadRejected)) return false;
                    domain.PackageEntry$.PackageUploadRejected packageUploadRejected = (domain.PackageEntry$.PackageUploadRejected)packageEntry;
                    String string = packageUploadRejected.submissionId();
                    String string2 = this.submissionId$3;
                    String string3 = string;
                    if (string2 != null) {
                        if (!string2.equals(string3)) return false;
                        return true;
                    }
                    if (string3 == null) return true;
                    return false;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.submissionId$3 = submissionId$3;
                }
            };
        }

        public SynchronousResponseStrategy(LedgerEndService ledgerEndService, IndexPackagesService packagesIndex, WritePackagesService packagesWrite, ExecutionContext executionContext, LoggingContext loggingContext) {
            this.ledgerEndService = ledgerEndService;
            this.packagesIndex = packagesIndex;
            this.packagesWrite = packagesWrite;
            this.executionContext = executionContext;
            this.com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$loggingContext = loggingContext;
            this.com$daml$platform$apiserver$services$admin$ApiPackageManagementService$SynchronousResponseStrategy$$logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        }
    }
}

