/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.admin;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.v1.admin.participant_pruning_service.ParticipantPruningServiceGrpc;
import com.daml.ledger.api.v1.admin.participant_pruning_service.ParticipantPruningServiceGrpc$;
import com.daml.ledger.api.v1.admin.participant_pruning_service.ParticipantPruningServiceGrpc$ParticipantPruningService$;
import com.daml.ledger.api.v1.admin.participant_pruning_service.PruneRequest;
import com.daml.ledger.api.v1.admin.participant_pruning_service.PruneResponse;
import com.daml.ledger.api.validation.ValidationErrors$;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.participant.state.index.v2.IndexParticipantPruningService;
import com.daml.ledger.participant.state.index.v2.LedgerEndService;
import com.daml.ledger.participant.state.v2.PruningResult;
import com.daml.ledger.participant.state.v2.WriteParticipantPruningService;
import com.daml.lf.data.Ref$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.platform.ApiOffset$;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.apiserver.services.admin.ApiParticipantPruningService$;
import com.daml.platform.server.api.ApiException;
import com.daml.platform.server.api.ValidationLogger$;
import com.google.rpc.Status;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001\u0002\f\u0018\u0005\u0011B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"AA\f\u0001B\u0001B\u0003-Q\f\u0003\u0005d\u0001\t\u0005\t\u0015a\u0003e\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u001d)\bA1A\u0005\fYDaA\u001f\u0001!\u0002\u00139\b\"B>\u0001\t\u0003b\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003'\u0001A\u0011IA\u000b\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002\n\u0002!I!a#\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0003W\u0004A\u0011BAw\u000f\u001d\t)p\u0006E\u0001\u0003o4aAF\f\t\u0002\u0005e\bB\u00026\u0014\t\u0003\tY\u0010C\u0004\u0002~N!\t!a@\u00039\u0005\u0003\u0018\u000eU1si&\u001c\u0017\u000e]1oiB\u0013XO\\5oON+'O^5dK*\u0011\u0001$G\u0001\u0006C\u0012l\u0017N\u001c\u0006\u00035m\t\u0001b]3sm&\u001cWm\u001d\u0006\u00039u\t\u0011\"\u00199jg\u0016\u0014h/\u001a:\u000b\u0005yy\u0012\u0001\u00039mCR4wN]7\u000b\u0005\u0001\n\u0013\u0001\u00023b[2T\u0011AI\u0001\u0004G>l7\u0001A\n\u0005\u0001\u0015ZC\b\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Yer!!L\u001c\u000e\u00039R!a\f\u0019\u00027A\f'\u000f^5dSB\fg\u000e^0qeVt\u0017N\\4`g\u0016\u0014h/[2f\u0015\tA\u0012G\u0003\u00023g\u0005\u0011a/\r\u0006\u0003iU\n1!\u00199j\u0015\t1t$\u0001\u0004mK\u0012<WM]\u0005\u0003q9\nQ\u0004U1si&\u001c\u0017\u000e]1oiB\u0013XO\\5oON+'O^5dK\u001e\u0013\boY\u0005\u0003um\u0012\u0011\u0004U1si&\u001c\u0017\u000e]1oiB\u0013XO\\5oON+'O^5dK*\u0011\u0001H\f\t\u0003{\u0005k\u0011A\u0010\u0006\u0003\u007f\u0001\u000bAa\u001a:qG*\u0011A'H\u0005\u0003\u0005z\u0012ab\u0012:qG\u0006\u0003\u0018nU3sm&\u001cW-A\u0006sK\u0006$')Y2lK:$'cA#H'\u001a!a\t\u0001\u0001E\u00051a$/\u001a4j]\u0016lWM\u001c;?!\tA\u0015+D\u0001J\u0015\tQ5*\u0001\u0002we)\u0011A*T\u0001\u0006S:$W\r\u001f\u0006\u0003\u001d>\u000bQa\u001d;bi\u0016T!\u0001U\u001b\u0002\u0017A\f'\u000f^5dSB\fg\u000e^\u0005\u0003%&\u0013a$\u00138eKb\u0004\u0016M\u001d;jG&\u0004\u0018M\u001c;QeVt\u0017N\\4TKJ4\u0018nY3\u0011\u0005!#\u0016BA+J\u0005AaU\rZ4fe\u0016sGmU3sm&\u001cW-\u0001\u0007xe&$XMQ1dW\u0016tG\r\u0005\u0002Y56\t\u0011L\u0003\u0002K\u001b&\u00111,\u0017\u0002\u001f/JLG/\u001a)beRL7-\u001b9b]R\u0004&/\u001e8j]\u001e\u001cVM\u001d<jG\u0016\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001<\u0013AC2p]\u000e,(O]3oi&\u0011!m\u0018\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0002\\8hO&twmQ8oi\u0016DH\u000f\u0005\u0002fQ6\taM\u0003\u0002h?\u00059An\\4hS:<\u0017BA5g\u00059aunZ4j]\u001e\u001cuN\u001c;fqR\fa\u0001P5oSRtDc\u00017riR\u0019Qn\u001c9\u0011\u00059\u0004Q\"A\f\t\u000bq+\u00019A/\t\u000b\r,\u00019\u00013\t\u000b\r+\u0001\u0019\u0001:\u0013\u0007M<5K\u0002\u0003G\u0001\u0001\u0011\b\"\u0002,\u0006\u0001\u00049\u0016A\u00027pO\u001e,'/F\u0001x!\t)\u00070\u0003\u0002zM\n!2i\u001c8uKb$X/\u00197ju\u0016$Gj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006cS:$7+\u001a:wS\u000e,G#A?\u0011\u0007y\f)!D\u0001\u0000\u0015\ry\u0014\u0011\u0001\u0006\u0003\u0003\u0007\t!![8\n\u0007\u0005\u001dqPA\fTKJ4XM]*feZL7-\u001a#fM&t\u0017\u000e^5p]\u0006)1\r\\8tKR\u0011\u0011Q\u0002\t\u0004M\u0005=\u0011bAA\tO\t!QK\\5u\u0003\u0015\u0001(/\u001e8f)\u0011\t9\"a\t\u0011\u000by\u000bI\"!\b\n\u0007\u0005mqL\u0001\u0004GkR,(/\u001a\t\u0004[\u0005}\u0011bAA\u0011]\ti\u0001K];oKJ+7\u000f]8og\u0016Dq!!\n\u000b\u0001\u0004\t9#A\u0004sKF,Xm\u001d;\u0011\u00075\nI#C\u0002\u0002,9\u0012A\u0002\u0015:v]\u0016\u0014V-];fgR\fqB^1mS\u0012\fG/\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003c\t\u0019\u0006\u0006\u0004\u00024\u0005\u0005\u00131\t\t\u0006=\u0006e\u0011Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H\u001b\u0002\r=4gm]3u\u0013\u0011\ty$!\u000f\u0003\r=3gm]3u\u0011\u0015\u00197\u0002q\u0001e\u0011\u001d\t)e\u0003a\u0002\u0003\u000f\n1\"\u001a:s_JdunZ4feB!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N}\tQ!\u001a:s_JLA!!\u0015\u0002L\tI2i\u001c8uKb$X/\u00197ju\u0016$WI\u001d:pe2{wmZ3s\u0011\u001d\t)c\u0003a\u0001\u0003O\t\u0011\u0003\u001d:v]\u0016<&/\u001b;f'\u0016\u0014h/[2f)!\tI&a\u0018\u0002d\u0005}D\u0003BA.\u0003;\u0002RAXA\r\u0003\u001bAQa\u0019\u0007A\u0004\u0011Dq!!\u0019\r\u0001\u0004\t)$A\u0005qeVtW-\u00169U_\"9\u0011Q\r\u0007A\u0002\u0005\u001d\u0014\u0001D:vE6L7o]5p]&#\u0007\u0003BA5\u0003srA!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0003eCR\f'bAA:?\u0005\u0011ANZ\u0005\u0005\u0003o\ni'A\u0002SK\u001aLA!a\u001f\u0002~\ta1+\u001e2nSN\u001c\u0018n\u001c8JI*!\u0011qOA7\u0011\u001d\t\t\t\u0004a\u0001\u0003\u0007\u000b\u0011\u0004\u001d:v]\u0016\fE\u000e\u001c#jmVdw-\u001a3D_:$(/Y2ugB\u0019a%!\"\n\u0007\u0005\u001duEA\u0004C_>dW-\u00198\u00023A\u0014XO\\3MK\u0012<WM]!qSN+'O^3s\u0013:$W\r\u001f\u000b\u0007\u0003\u001b\u000b\t*a%\u0015\t\u0005]\u0011q\u0012\u0005\u0006G6\u0001\u001d\u0001\u001a\u0005\b\u0003Cj\u0001\u0019AA\u001b\u0011\u001d\t\t)\u0004a\u0001\u0003\u0007\u000bac\u00195fG.|eMZ:fi&\u001b8\u000b]3dS\u001aLW\r\u001a\u000b\u0005\u00033\u000bY\r\u0006\u0003\u0002\u001c\u0006%\u0007\u0003CAO\u0003[\u000b\u0019,!/\u000f\t\u0005}\u0015\u0011\u0016\b\u0005\u0003C\u000b9+\u0004\u0002\u0002$*\u0019\u0011QU\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0013bAAVO\u00059\u0001/Y2lC\u001e,\u0017\u0002BAX\u0003c\u0013a!R5uQ\u0016\u0014(bAAVOA\u0019a0!.\n\u0007\u0005]vP\u0001\fTi\u0006$Xo\u001d*v]RLW.Z#yG\u0016\u0004H/[8o!\u0011\tY,a1\u000f\t\u0005u\u0016q\u0018\t\u0004\u0003C;\u0013bAAaO\u00051\u0001K]3eK\u001aLA!!2\u0002H\n11\u000b\u001e:j]\u001eT1!!1(\u0011\u001d\t)E\u0004a\u0002\u0003\u000fBq!a\u000f\u000f\u0001\u0004\tI,\u0001\rdQ\u0016\u001c7n\u00144gg\u0016$\u0018j\u001d%fq\u0006$WmY5nC2$B!!5\u0002XR!\u00111[Ak!!\ti*!,\u00024\u0006U\u0002bBA#\u001f\u0001\u000f\u0011q\t\u0005\b\u00033|\u0001\u0019AA]\u0003=\u0001(/\u001e8f+B$vn\u0015;sS:<\u0017\u0001H2iK\u000e\\wJ\u001a4tKRL5OQ3g_J,G*\u001a3hKJ,e\u000e\u001a\u000b\u0007\u0003?\f)/!;\u0015\r\u0005M\u0012\u0011]Ar\u0011\u0015\u0019\u0007\u0003q\u0001e\u0011\u001d\t)\u0005\u0005a\u0002\u0003\u000fBq!a:\u0011\u0001\u0004\t)$\u0001\bqeVtW-\u00169U_B\u0013x\u000e^8\t\u000f\u0005e\u0007\u00031\u0001\u0002:\u0006I2m\u001c8uKb$X/\u00197ju\u0016$WI\u001d:pe2{wmZ3s)\u0011\ty/a=\u0015\t\u0005\u001d\u0013\u0011\u001f\u0005\u0006GF\u0001\u001d\u0001\u001a\u0005\b\u0003K\n\u0002\u0019AA]\u0003q\t\u0005/\u001b)beRL7-\u001b9b]R\u0004&/\u001e8j]\u001e\u001cVM\u001d<jG\u0016\u0004\"A\\\n\u0014\u0005M)CCAA|\u0003A\u0019'/Z1uK\u0006\u0003\u0018nU3sm&\u001cW\r\u0006\u0004\u0003\u0002\t-!\u0011\u0003\u000b\u0007\u0005\u0007\u00119A!\u0003\u0013\t\t\u00151\u0006\u0010\u0004\u0006\rN\u0001!1\u0001\u0005\u00069V\u0001\u001d!\u0018\u0005\u0006GV\u0001\u001d\u0001\u001a\u0005\u0007\u0007V\u0001\rA!\u0004\u0013\t\t=qi\u0015\u0004\u0006\rN\u0001!Q\u0002\u0005\u0006-V\u0001\ra\u0016")
public final class ApiParticipantPruningService
implements ParticipantPruningServiceGrpc.ParticipantPruningService,
GrpcApiService {
    private final IndexParticipantPruningService readBackend;
    private final WriteParticipantPruningService writeBackend;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;

    public static ParticipantPruningServiceGrpc.ParticipantPruningService createApiService(IndexParticipantPruningService readBackend, WriteParticipantPruningService writeBackend, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ApiParticipantPruningService$.MODULE$.createApiService(readBackend, writeBackend, executionContext, loggingContext);
    }

    public ParticipantPruningServiceGrpc$ParticipantPruningService$ serviceCompanion() {
        return ParticipantPruningServiceGrpc.ParticipantPruningService.serviceCompanion$((ParticipantPruningServiceGrpc.ParticipantPruningService)this);
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public ServerServiceDefinition bindService() {
        return ParticipantPruningServiceGrpc$.MODULE$.bindService((ParticipantPruningServiceGrpc.ParticipantPruningService)this, this.executionContext);
    }

    public void close() {
    }

    public Future<PruneResponse> prune(PruneRequest request) {
        Either submissionIdOrErr = Ref$.MODULE$.SubmissionId().fromString(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(request.submissionId())) ? request.submissionId() : UUID.randomUUID().toString()).left().map((Function1 & Serializable)err -> ValidationErrors$.MODULE$.invalidArgument(new StringBuilder(14).append("submission_id ").append((String)err).toString(), this.contextualizedErrorLogger(request.submissionId(), $this.loggingContext)));
        return (Future)submissionIdOrErr.fold((Function1 & Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure((Object)request, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable)submissionId -> (Future)LoggingContext$.MODULE$.withEnrichedLoggingContext(com.daml.platform.apiserver.services.logging.package$.MODULE$.submissionId((String)submissionId), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(14).append("Pruning up to ").append(request.pruneUpTo()).toString(), loggingContext);
            return this.validateRequest(request, (LoggingContext)loggingContext, this.contextualizedErrorLogger((String)submissionId, (LoggingContext)loggingContext)).flatMap((Function1 & Serializable)pruneUpTo -> this.pruneWriteService((Offset)pruneUpTo, (String)submissionId, request.pruneAllDivulgedContracts(), (LoggingContext)loggingContext).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                Future future = this.pruneLedgerApiServerIndex((Offset)pruneUpTo, request.pruneAllDivulgedContracts(), (LoggingContext)loggingContext).map((Function1 & Serializable)pruneResponse -> pruneResponse, $this.executionContext);
                return future;
            }, $this.executionContext), $this.executionContext).andThen(this.logger().logErrorsOnCall(loggingContext), $this.executionContext);
        }, $this.loggingContext));
    }

    private Future<Offset> validateRequest(PruneRequest request, LoggingContext loggingContext, ContextualizedErrorLogger errorLogger) {
        return (Future)this.checkOffsetIsSpecified(request.pruneUpTo(), errorLogger).flatMap((Function1 & Serializable)pruneUpToString -> this.checkOffsetIsHexadecimal((String)pruneUpToString, errorLogger).map((Function1 & Serializable)pruneUpTo -> new Tuple2(pruneUpTo, pruneUpToString))).fold((Function1 & Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure((Object)request, (Throwable)t, this.logger(), loggingContext)), (Function1 & Serializable)o -> this.checkOffsetIsBeforeLedgerEnd((Offset)o._1(), (String)o._2(), loggingContext, errorLogger));
    }

    private Future<BoxedUnit> pruneWriteService(Offset pruneUpTo, String submissionId, boolean pruneAllDivulgedContracts, LoggingContext loggingContext) {
        this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(84).append("About to prune participant ledger up to ").append(ApiOffset$.MODULE$.ApiOffsetConverter(pruneUpTo).toApiString()).append(" inclusively starting with the write service").toString(), loggingContext);
        return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps(this.writeBackend.prune(pruneUpTo, submissionId, pruneAllDivulgedContracts))).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            PruningResult pruningResult = x0$1;
            if (pruningResult instanceof PruningResult.NotPruned) {
                PruningResult.NotPruned notPruned = (PruningResult.NotPruned)pruningResult;
                Status status = notPruned.grpcStatus();
                future = Future$.MODULE$.failed((Throwable)new ApiException(StatusProto.toStatusRuntimeException((Status)status)));
            } else if (PruningResult.ParticipantPruned$.MODULE$.equals(pruningResult)) {
                this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(45).append("Pruned participant ledger up to ").append(ApiOffset$.MODULE$.ApiOffsetConverter(pruneUpTo).toApiString()).append(" inclusively.").toString(), loggingContext);
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)pruningResult);
            }
            return future;
        }, this.executionContext);
    }

    private Future<PruneResponse> pruneLedgerApiServerIndex(Offset pruneUpTo, boolean pruneAllDivulgedContracts, LoggingContext loggingContext) {
        this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(54).append("About to prune ledger api server index to ").append(ApiOffset$.MODULE$.ApiOffsetConverter(pruneUpTo).toApiString()).append(" inclusively").toString(), loggingContext);
        return this.readBackend.prune(pruneUpTo, pruneAllDivulgedContracts, loggingContext).map((Function1 & Serializable)x$2 -> {
            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(50).append("Pruned ledger api server index up to ").append(ApiOffset$.MODULE$.ApiOffsetConverter(pruneUpTo).toApiString()).append(" inclusively.").toString(), loggingContext);
            return new PruneResponse();
        }, this.executionContext);
    }

    private Either<StatusRuntimeException, String> checkOffsetIsSpecified(String offset, ContextualizedErrorLogger errorLogger) {
        return package$.MODULE$.Either().cond(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(offset)), (Function0 & Serializable)() -> offset, (Function0 & Serializable)() -> ValidationErrors$.MODULE$.invalidArgument("prune_up_to not specified", errorLogger));
    }

    private Either<StatusRuntimeException, Offset> checkOffsetIsHexadecimal(String pruneUpToString, ContextualizedErrorLogger errorLogger) {
        return ApiOffset$.MODULE$.fromString(pruneUpToString).toEither().left().map((Function1 & Serializable)t -> new RequestValidation.NonHexOffset$.Error("prune_up_to", pruneUpToString, new StringBuilder(55).append("prune_up_to needs to be a hexadecimal string and not ").append(pruneUpToString).append(": ").append(t.getMessage()).toString(), errorLogger).asGrpcError());
    }

    private Future<Offset> checkOffsetIsBeforeLedgerEnd(Offset pruneUpToProto, String pruneUpToString, LoggingContext loggingContext, ContextualizedErrorLogger errorLogger) {
        return ((LedgerEndService)this.readBackend).currentLedgerEnd(loggingContext).flatMap((Function1 & Serializable)ledgerEnd -> (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(pruneUpToString), ledgerEnd.value()) ? Future$.MODULE$.successful((Object)BoxedUnit.UNIT) : Future$.MODULE$.failed((Throwable)new RequestValidation.OffsetOutOfRange$.Reject(new StringBuilder(42).append("prune_up_to needs to be before ledger end ").append(ledgerEnd.value()).toString(), errorLogger).asGrpcError())).map((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            Offset offset = pruneUpToProto;
            return offset;
        }, $this.executionContext), this.executionContext);
    }

    private ContextualizedErrorLogger contextualizedErrorLogger(String submissionId, LoggingContext loggingContext) {
        return new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)new Some((Object)submissionId));
    }

    public ApiParticipantPruningService(IndexParticipantPruningService readBackend, WriteParticipantPruningService writeBackend, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.readBackend = readBackend;
        this.writeBackend = writeBackend;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        ParticipantPruningServiceGrpc.ParticipantPruningService.$init$((ParticipantPruningServiceGrpc.ParticipantPruningService)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

